//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Fortress
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "Fort Wilderness"
//    COUNTRY: USA
//    WEBPAGE: http://www.angelfire.com/md2/castlewrks <<<<<<<------- VERY Important.
//             http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  MegaPov 0.7
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), 
//                PaintShop Pro (add copyright), FastZip98 (zip)
//    RENDER TIME: about 1 hour, 70 meg
//    HARDWARE USED: Pentium 700
//
//    IMAGE DESCRIPTION:
//
//    This is Fort'ress' Wilderness... on the edge of the great wild out-yonder.  The last
//    bastion of childhood resistance and mom's flower gardens... out yonder where the hippolumpus
//    and gargabuchi live.                                                       
//    
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//    O.K.  This is what happens when you give up on one picture and then turn around and
//    start another.  However, this one was restricted to no more than 4 hours of work... give
//    or take an hour or two.  So, with limited time, I generated the fortress and surroundings.
//    Here it is.   Of note, the limbs of the scrub in the back are done with a crackle texture
//    scaled to give the illusion of branches.  The leaves are also a crackle texture with clear
//    between the "leaves".
//
//    The sand in the sand-box is a heighfield sized appropriately.
//
//    There are two rows of hills in the background... one low set intended to look like wild
//    beyond the mowed lawn area and the mountains, fogged for distance.
//
//    Short, simple, and sweet.  Enjoy.
//
#version unofficial MegaPov 0.6;                                 
#include "kolors.inc"   // ken's kolor file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
//#include "../med/brick.inc" 
//#include "../garden/99ivista.inc"
//#include "castletext.inc" 
#declare RS=seed(182);

global_settings {
                    max_trace_level 30          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }

//#declare TreeOff=off;       // turns off trees
#declare CloudPlane=off;    // turns off clouds (upper/lower)
//#declare HillsOff=off;      // turns off Hills
//#declare SkyOff=off;        // turns off sky and fog
//#declare MenOff=off;        // turns off men

camera {      
 //   location <15,10,-1388> look_at <0,5,-100>      
    location <0,1.5,-4.5> look_at <0,1.5,10>          
}

light_source{<500,500,-500> color White*2}  // BIG light    

#ifndef(SkyOff)
difference{
  sphere {<0,0,0> 400000}
  sphere {<0,0,0> 399999}
  box{<-400001,-400001,-400001><400001,0,400001>}


 texture{
  pigment {
    wrinkles //gradient y
    color_map {
      [0 color rgb <.65,.7,.9>]
      [1 color rgb <0.2, 0.5, 1>]
    }
    scale 1
  }
}
} // difference

difference{
  sphere {<0,0,0> 200000}
  sphere {<0,0,0> 199999}
  box{<-400001,-400001,-400001><400001,0,400001>}

 texture{
  pigment {
    bozo //wrinkles
    turbulence 50
    octaves 260
    lambda 5 //3 to 6
    omega 0.55 //0.2 to 0.6
    color_map {
     // [0 color rgbt <1, 1, 1, 1>]
      [0 color rgbt <0.98, 0.99, 0.99, .8>] 
      [0.5 color rgbt <1, 1, 1, 1>]           
      [1.0 color rgbt <0.98, 0.99, 0.99, .8>]      
     // [1 color rgbt <1, 1, 1, 1>]
    }
   // scale <.8, .1, .8>
  } 
  scale 80000000
 } // texture
} // difference


fog {                                                 // White ground fog
  distance 500
  colour rgb<0.53, 0.62, 0.72>
  fog_type 2
  fog_offset 5
  fog_alt 30
  turbulence 1.0
  turb_depth 3.0
}

//fog {                                                 // Pink/purple ground fog
//  distance 8000
//  colour rgb<0.53, 0.22, 0.72>
//  fog_type 2
//  fog_offset 50
//  fog_alt 100
//  turbulence 1.0
//  turb_depth 3.0
//}

#end //ifndef(SkyOff)

#ifndef(CloudPlane)

plane {y, 5500 // clouds over fortress
  texture {
    pigment {
       wrinkles 
      //bozo
      turbulence 40
      omega .8
    lambda 5 //3 to 6
    omega 0.53 //0.2 to 0.6
      color_map {
        [0 color Gray40]
        [.15 color Gray90]
        [.2 color White]
       // [.55 color Clear]
       // [.6 color White]
        [.8 color Clear]
        [1 color Clear]
      } // color_map
    } // pigment
  finish {ambient .5 diffuse .8}
  scale <8000000,1,8000000>
//translate <-500,900,-10000>
 }  // texture
hollow
} // plane

#end //ifndef(CloudPlane)                 

#ifndef(TreeOff)
//--------------------- CSG Objects
#declare TLeaf3=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.1 color Clear]
            [0.17 color DarkGreen]
            [1.0 color Gray10] } }
//        finish { ambient .81 diffuse .0998 }
//        rotate<90,90,90>
//        scale .5
//}
#declare TLeaf2=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.2 color Clear]
            [0.27 color Green]
            [1.0 color ForestGreen] } }
//        finish { ambient .41 diffuse .998 } 
//        rotate<50,50,50>        
//        scale .5
//}
#declare TLeaf=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.2 color Clear]
            [0.27 color ForestGreen]
            [1.0 color Gray10] } }
//        finish { ambient .81 diffuse .0998 }
//        scale .5
//}
#declare Branch=pigment{crackle
           color_map {
            [0.0 color Gray10]
            [0.08 color DarkBrown]
            [0.12 color Clear]
            [1.0 color Clear] }
}      

#declare TLeafN=texture{
       pigment{crackle
            pigment_map{
              [0.1 TLeaf2]
              [0.3 Branch]
              [0.5 TLeaf] 
              [0.8 Branch]
              [1.0 TLeaf3]
            }
       }
       scale .5     
} 
#declare TreeTrunkTexture = texture {
  pigment { granite
     color_map {
      [0.1 color White]
      [0.2 color Gray10]
      [0.4 color Gray30]
      [0.6 color Gray]
      [0.8 color DarkBrown]
      [0.9 color DarkGreen] 
     }
   }
   scale <.51,7.5,.51> 
   normal{granite .05}
}          

//#declare TLeafN=texture{pigment{color Green}}

      
#macro TreeTop(YScale,TexSc,TOD,TX,TY,TZ,TXO,TYO,TZO,TSD)
 
//sphere { 0,1 scale<10,1,10>
  cone{<TX,TY,TZ>TOD/10 <TX+TXO,TY+TYO,TZ+TZO> TOD
       texture {  
         pigment { crackle
           color_map {
            [0.0 color Gray10]
            [0.08 color DarkBrown]
            [0.12 color Clear]
            [1.0 color Clear] } }
//        finish { ambient .001 diffuse .998 }
        scale .5
        scale <1,YScale,1>
       }
//       finish { ambient .000002 diffuse .999998 } 
  }


  #declare RC=1;
  #while (RC<=TSD)
     #declare RD=rand(RS)*TOD/2*3/5+TOD/2*2/5;
     #declare ROY=rand(RS)*360;
     #declare RY=rand(RS)*TOD-(TOD/2);
     #declare RZ=rand(RS)*TOD+5;
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
               
     sphere{ 0,RD
             scale<RSX,RSY,RSZ> 
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc}
      }
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
                     
      sphere{ 0,RD*8/10 
             scale<RSX,RSY,RSZ>      
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc }
      }
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
                     
      sphere{ 0,RD*7/10
             scale<RSX,RSY,RSZ>       
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc}
      }
      
    #declare RC=RC+1;
  #end 
#end  // macro TreeTop

#declare S1=-10;
#while (S1<=10)
   #declare RZ=rand(RS)*20-10;
   #declare RH=rand(RS)*2+2;
   #declare RSc=rand(RS)*.15+.15;
   #declare ROD=rand(RS)*2+1;
   #declare RCO=rand(RS)*50+50;
   
   TreeTop (4,RSc,ROD,S1,0,20+RZ, 0,RH,0,RCO)
   #declare S1=S1+rand(RS)*8;
#end

#end //ifndef(TreeOff)
                   
#ifndef(HillsOff)
union{
#declare C1=90;
#while (C1<=210)

  #declare RSY=rand(RS)*500+7000;
  #declare ROY=rand(RS)*360;
  
    object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Gray60 } }
                 scale <50000, RSY, 50000 >   
                 translate<-25000,0,-25000> // center
                 rotate<0,ROY,0>
                 translate < 0, 0, 65000 >
                 rotate<0,C1+210,0>
  }

    object { 
                height_field { png  "../graphics/hills1.png" }
                 scale <50000, RSY+1, 50000 >   
                 translate<-25000,0,-25000> // center
                texture {          
                   pigment { crackle
                        color_map {
                          [0.0 color Clear]
                          [0.1 color Clear]
                          [0.17 color Khaki]
                          [1.0 color Gray10] 
                        } 
                    } // pigment 
                  } // texture                 
                 rotate<0,ROY,0>
                 translate < 0, 0, 65000 >
                 rotate<0,C1+210,0>
  }

  #declare RSY=rand(RS)*2.5+2.5;
  #declare ROY=rand(RS)*360;
  #declare ROZ=rand(RS)*300;

    object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Tan } }
                 scale <500, RSY, 500 >   
                 translate<-250,0,-250> // center
                 rotate<0,ROY,0>
                 translate < 0, -.1, 200+ROZ >
                 rotate<0,C1+210,0>
  }

    object { 
                height_field { png  "../graphics/hills1.png" }
                 scale <500, RSY+.5, 500 >   
                 translate<-250,-.1,-250> // center
                texture {          
                   pigment { crackle
                        color_map {
                          [0.0 color Clear]
                          [0.1 color Clear]
                          [0.17 color Khaki]
                          [1.0 color Gray10] 
                        } 
                    } // pigment 
                  } // texture                 
                 rotate<0,ROY,0>
                 translate < 0, 0, 200+ROZ >
                 rotate<0,C1+210,0>
  }
  
  #declare C1=C1+rand(RS)*10+15;
#end



} // union
#end //ifndef(HillsOff)

box{<-15000,-0.1,-500><15000,0,500> 
    texture{pigment{image_map { png "..\graphics\natfl014.png"} 
    scale .5 
    rotate<90,0,0>}}}

    object { 
                height_field { png  "../graphics/ground.png" }
                 scale <20, .14 , 20 >   
                 translate<-10,0,-10> // center
                texture { pigment{image_map { png "..\graphics\natfl014.png"} 
                          scale .5 
                          rotate<90,0,0>}}                 
    }        

/////////////////////////////////////////////////////////////////////////////////////////////////////////// Play Towers/ Sandboxes
#declare City_ToTTower=union{
     union{
       box{<-.75,0,-.75><-.65,2.5,-.65> }
       box{<-.75,0,.75><-.65,2.5,.65> }
       box{<.75,0,-.75><.65,2.5,-.65> }
       box{<.75,0,.75><.65,2.5,.65> }
       
       cylinder{<-.7,2.5,-.7><-.7,2.6,-.7> .0075 texture{pigment{color Silver}}}
       cylinder{<.7,2.5,-.7><.7,2.6,-.7> .0075 texture{pigment{color Silver}}}
       cylinder{<-.7,2.5,.7><-.7,2.6,.7> .0075 texture{pigment{color Silver}}}
       cylinder{<.7,2.5,.7><.7,2.6,.7> .0075 texture{pigment{color Silver}}}
       cylinder{<-.7,2.6,-.7><-.7,2.61,-.7> .01 texture{pigment{color Silver}}}
       cylinder{<.7,2.6,-.7><.7,2.61,-.7> .01 texture{pigment{color Silver}}}
       cylinder{<-.7,2.6,.7><-.7,2.61,.7> .01 texture{pigment{color Silver}}}
       cylinder{<.7,2.6,.7><.7,2.61,.7> .01 texture{pigment{color Silver}}}
                                          
       #declare SC=-.55;
       #while (SC<=.55)
           box{<SC,1.05,-.75><SC+.05,2,-.8>}
           box{<SC,1.05,.75><SC+.05,2,.8>}
           box{<-.75,1.05,SC><-.8,2,SC+.05>}
           box{<.75,1.05,SC><.8,2,SC+.05>}
          #declare SC=SC+.2;
       #end
      texture{T_Wood8 scale .5 rotate<90,0,0>}
     }
     box{<-.75,1.05,-.75><.75,1.2,.75> }
     box{<-.75,1.9,-.75><-.75,2,.75> }
     box{<-.75,1.9,-.75><.75,2,-.75> }
     box{<-.75,1.9,.75><.75,2,.75> }
     box{<.75,1.9,-.75><.75,2,.75> } 
     union{
       triangle{<-.7501,2.5,-.7501><-.7501,2.5,.7501><-.7501,2.45,.7501>} // fold over
       triangle{<-.7501,2.5,-.7501><-.7501,2.45,.7501><-.7501,2.45,-.7501>}
       triangle{<.7501,2.5,-.7501><.7501,2.5,.7501><.7501,2.45,.7501>} // fold over
       triangle{<.7501,2.5,-.7501><.7501,2.45,.7501><.7501,2.45,-.7501>}       
       
       triangle{<-.7501,2.5,-.7501><-.7501,2.5,.7501><0,3.3,-.7501> }
       triangle{<0,3.3,-.7501><-.7501,2.5,.7501><0,3.3,.7501> }
       triangle{<.7501,2.5,-.7501><.7501,2.5,.7501><0,3.3,-.7501> }
       triangle{<0,3.3,-.7501><.7501,2.5,.7501><0,3.3,.7501> }
      texture{pigment{color Blue}}
     } // union 
     
     union{  // ladder
        box{<1,0,-.55><1.1,2,-.47> texture{T_Wood8 scale .5 rotate<90,0,0>}}
        box{<1,0,-.03><1.1,2,.05> texture{T_Wood8 scale .5 rotate<90,0,0>}}
        #declare C1=.25;
        #while (C1<2)
          box{<-.03,-.025,-.45><.03,.025,-.05> rotate<0,0,-20> translate<1.05,C1+.025,0>}
          #declare C1=C1+.3;
        #end
       rotate<0,0,20>
       translate<.45,-.3,0.05>
     }
  texture{T_Wood8 scale .5}
}
#declare City_Sandbox= union{
  difference{
    box{<-1,0,-1><1,.3,1> }
    box{<-.85,0,-.85><.85,.31,.85> }
   texture{T_Wood8 scale .25 rotate<0,5,0>} 
  } 
  object { 
                height_field { png  "../graphics/ground.png" }
                texture { pigment { color Tan } }
                 scale <2, .1 , 2 >   
                 translate<-1,.075,-1> // center
  }    
}
#declare City_ToTTower2=union{
    object{City_ToTTower}
    object{City_Sandbox}
}

object{City_ToTTower2 rotate<0,45,0>}



// Flowers....

#declare Dirt=texture{pigment{image_map { png "..\graphics\natfl113.png" } rotate<90,0,0>} normal{granite .25}}

#declare X1=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers1.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0> rotate<0,0,0>
               }}

#declare X2=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers2.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X3=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers3.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X4=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}               
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers4.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X5=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers5.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}
#declare X6=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers6.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}                                                                
#declare X7=union{
               box{<-.5,0,-.35><.5,.01,.35> texture{Dirt}}
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\flowers7.png" transmit 0, 1.0} 
               }} translate<-.5,-.1,0>  rotate<0,0,0>
               }}               
               
#declare C1=-10;
#while (C1<10) 
   #declare F1=int(rand(RS)*7+1);
   #declare RZ=rand(RS)*1-.5;
   
   #switch(F1)
     #case (1) object{X1 translate<C1,0,4+RZ>} #break
     #case (2) object{X2 translate<C1,0,4+RZ>} #break
     #case (3) object{X3 translate<C1,0,4+RZ>} #break
     #case (4) object{X4 translate<C1,0,4+RZ>} #break
     #case (5) object{X5 translate<C1,0,4+RZ>} #break                    
     #case (6) object{X6 translate<C1,0,4+RZ>} #break
     #case (7) object{X7 translate<C1,0,4+RZ>} #break     
   #end  
   #declare C1=C1+1;
#end               