#include "textures.inc"

#declare Skull = union
{       
        union
        {
                sphere
                {
                        < 0, 0, 0 >, 1
                }
                cylinder
                {
                        < 0, -2, 0 >< 0, 0, 0 >, 0.9
                }
                translate< 0, 0, .15 >
        }
        union
        { 
                difference
                {
                        sphere
                        {
                                < 0, 0, 0 >, 1
                        }
                        box
                        {
                                < -1, -1, -1 >< 1 ,0 , 1 >
                        }
                }
                cylinder
                {
                        < 0, -0.7, 0 >< 0, 0.1, 0 >, 1
                }
                sphere
                {
                        < 0, 0, 0 >, 1
                        translate< 0, -0.7, 0 >
                }
                translate< 0, 0, -.15 >
        }
        texture{ skin }
}

#declare Eye = union
{
        difference
        {       
                union
                {       
                        sphere
                        {
                                < 0, 0, 0 >, 1
                                scale< 1, 1, 0.6 >
                        }
                        cylinder
                        {
                                < 0, 0, 0 >< 0, 0, -3 >, 1
                        }
                        scale< 0.5, 0.3, 0.3 >
                }
                difference
                {
                        union
                        {       
                                sphere
                                {
                                        < 0, 0, 0 >, 1
                                }/*
                                torus
                                {
                                        0.3, .1
                                        rotate< 90, 0, 0 >
                                        translate< 0, 0, -1 >
                                        scale< 1.5, 1, 1 >
                                }*/ 
                                translate< 0.1, 0, 1.12 >
                        }
                        intersection
                        {
                                cylinder
                                {
                                        < 0.1, -0.1, -2 >< 0.1, -0.1, 2 >,0.2
                                }
                                cylinder
                                {
                                        < 0.1, 0.1, -2 >< 0.1, 0.1, 2 >,0.2
                                }
                        }
                }
        }
        
}

#declare EyeBall = union
{
        difference
        {
                sphere
                {
                        <0, 0, 0>, 0.98
                        texture{ eye_color }
                }
                cylinder
                {
                        <0, 0, -1.0><0, 0, 0.0>,0.1
                }
        }
        difference
        {
                sphere
                {
                        <0, 0, 0>, 0.99
                        texture{ eye_back }
                }
                cylinder
                {
                        <0, 0, -1.0><0, 0, 0.0>,0.3
                }
        }
        sphere
        {
                <0, 0, 0>, 1
                texture{ glass }
        }
}

#declare Face = union
{
        object
        {
                Eye
                translate< -0.55, -0.2, -1.0 >
                texture{ skin }
        }
        object
        {
                Eye 
                rotate< 0, 0, 180 >
                translate< 0.55, -0.2, -1.0 >
                texture{ skin }
        }
}

#declare Nose_Base = union
{
        sphere
        {
                < 0, 1, 0 >,1
        }
        cylinder
        {
                < 0, 1, 0 >< 0, -5, 0 >,1
        }
        sphere
        {
                < 0, -5, 0 >,1
        }
}

#declare Nose = union
{
        union
        {
                object
                {
                        Nose_Base
                        rotate< 25, 0, 0 >
                }
                object
                {
                        Nose_Base
                        rotate< 10, 0, 0 >
                        rotate< 0, 0, -10 >
                }
                object
                {
                        Nose_Base
                        rotate< 10, 0, 0 >
                        rotate< 0, 0, 10 >
                }
        }
        texture{ skin }
}

#declare Mouth = union
{
        union
        {
                torus
                {
                        1, .1
                }
                torus
                {
                        1, .12
                        translate< 0, -0.12, 0 >
                }
                texture{ lips }
        }/*
        sphere
        {
                < 0, 0, 0 >,0.5
                translate< 0, -0.8, -0.5 >
                scale< 2, 1, 0.5 >
                texture{ skin }
        }*/
}

#declare Head = union
{       
        difference
        {
                object{ Skull }
                object{ Face }
        }
        union
        {
                object
                {
                        EyeBall  
                        translate< -1.55, -0.7 , -1.9 >
                        scale 0.3
                }
                object
                {
                        EyeBall  
                        translate< 1.55, -0.7 , -1.9 >
                        scale 0.3
                }
        }
        object
        {
                Nose
                scale 0.1
                translate< 0, -0.2, -1.1 >
        }
        object
        {
                Mouth
                scale 0.5
                translate< 0, -0.9, -0.6 >
        }
}

#declare hand = union
{
        union
        {
                difference
                {
                        sphere
                        {
                                < 0, 0, 0 >,1
                        }
                        sphere
                        {
                                < 0, 0, 0 >,1
                                scale< 1, 0.5, 1 >
                                translate< 0, 0, 1 >
                        }
                }
                sphere
                {
                        < 0, 0, 0 >,1
                        scale< 0.5, 0.25, 0.5 >
                        translate< -1, 0.25, 0 >
                }
                texture{ clothes }
        }
        sphere
        {
                < 0, 0, 0 >,1
                translate< 0, 0, 0.5 >
                scale< 0.75, 0.75, 0.75 >
                texture{ ice_texture }
        }
}

#declare left_arm = union
{
        union
        {
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                }
                sphere
                {
                        < 0, 0, 0 >,1
                        translate< 0, 1, 0 >
                }
                sphere
                {
                        < 0, 0, 0 >,1
                        translate< 0, -1, 0 >
                }
                texture{ clothes }
        }
        union
        {
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                        texture{ clothes }
                }
                object
                {
                        hand
                        translate< 0, -2, 0 >
                }
                rotate< 0, 0, -40 >
                translate< -0.6, -1.7, 0 >
        }
}

#declare right_arm = union
{
        cylinder
        {
                < 0, -1, 0 >< 0, 1, 0 >,1
        }
        sphere
        {
                < 0, 0, 0 >,1
                translate< 0, 1, 0 >
        }
        texture{ clothes }
}

#declare body = union
{       
        union
        {
                box
                {
                        <-1, -1, -1 >< 1, 1, 1 >
                }
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                        translate< -1, 0, 0 >
                }
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                        translate< 1, 0, 0 >
                }
                union
                {
                        cylinder
                        {
                                < -1, 0, 0 >< 1, 0, 0 >,1
                        }
                        sphere
                        {
                                < 0, 0, 0 >,1
                                translate< -1, 0, 0 >
                        }
                        sphere
                        {
                                < 0, 0, 0 >,1
                                translate< 1, 0, 0 >
                        }
                        scale< 0, 0.25, 0 >
                        translate< 0, 1, 0 >
                }
                scale< 0.25, 0.7, 0.25 >
                texture{ clothes }
        }
        object
        {
                right_arm
                scale< 0.25, 0.25, 0.25 >
                rotate< 0, 0, 45 >
                translate< 0.5, 0.5, 0 >
        } 
        object
        {
                left_arm
                scale< 0.25, 0.25, 0.25 >
                rotate< 0, 0, -120 >
                translate< -0.5, 0.75, 0 >
        }
}

#declare hat = union
{
        difference
        {
                sphere
                {
                        < 0, 0, 0 >,1
                        texture{ clothes }
                }
                box
                {
                        < -1, -1, -1 >< 1, 0, 1 >
                }
        }
        torus
        {
                0.7,0.5 
                scale< 1, 0.2, 1 >
                texture{ white_clothes }       
        }
        sphere
        {
                < 0, 0, 0 >,1           
                scale< 0.5, 0.25, 0.5 >
                texture{ white_clothes }
                translate< 0, 1, 0 >
        }
}

#declare kid = union
{       
        object
        {
                body
                rotate< 0, -20, 0 >
        }
        object
        {
                Head
                rotate< 0, 180, 0 >
                scale< 0.3, 0.3, 0.3 >
                translate< 0, 1.33, 0 >
        }
        object
        {
                hat
                rotate< -10, 0, 0 >
                scale< 0.35, 0.7, 0.35 >
                translate< 0, 1.33, 0 >
        } 
        sphere
        {
                < 0, 0, 0 >,1             
                material{ steam_material }
                scale< 0.12, 0.1, 0.3 >    
                rotate< 45, 0, 0 >
                translate< 0, 0.95, 0.5 >    
                hollow
        }
}