#version unofficial MegaPov 0.7;

#include "shipTxt.inc"

#declare ShowBondage = 1;
#declare ShowSideBalcony = 1;
#declare ShowSideWindows = 1;
#declare ShowBackWindowsDoors = 1; 
#declare ShowBackBalcony = 1; 
#declare ShowPortDoors = 1; 
#declare ShowGuns = 1;
#declare ShowBuild1 = 1;
#declare ShowStairway = 1; 
#declare ShowGrid = 1; 
#declare ShowLadder = 1; 
#declare ShowFlag = 1;
#declare ShowLights = 1; 
#declare ShowOrnament = 1;
#declare ShowMasts = 1;

#declare Column = union{
    sphere{<0, 0.01, 0>, 0.01}
	sphere{0, 0.01 scale<1, 0.6, 1> translate y*0.05}
	sphere{<0, 0.09, 0>, 0.01}    
	    
	sphere{<0, 0.04, 0>, 0.01}
	sphere{<0, 0.06, 0>, 0.01}
	    
	difference{
	    sphere{0, 0.01 scale <1, 3, 1>}
	    plane{y, 0}
	    translate<0, 0.06, 0>
	} 
	difference{
	    sphere{0, 0.01 scale <1, 3, 1>}
	    plane{-y, 0}
	    translate<0, 0.04, 0>
	}  
	scale<0.7, 0.8, 0.7>
	
	texture{PaintLightTxt}
}

#declare Bondage = union {
        // bondage 1
        
    union{
        difference{
            sphere{0, 2 scale <1.001, 0.401, 0.401>}
            difference{
                sphere{0, 2 scale <1, 0.4, 0.4>}
                plane{x, -1.4}
            } 
            // back
            plane{x, -1.401}
            plane{-y, 0 translate -y*0.185}
            plane{y, 0 translate -y*0.215}
        }                               
        // bolts
        union{
            // back 
            union{  
                #local num = 41;
                #local cnt = 0;
	            #while (cnt < num)   
	                sphere{0, 0.004 scale <0.4, 1, 1> translate <-1.401, -0.2 - 0.006, -0.5 + (cnt * 0.025)>} 
	                sphere{0, 0.004 scale <0.4, 1, 1> translate <-1.401, -0.2 + 0.006, -0.5 + ((cnt + 1) * 0.025)>}
    	            #local cnt = cnt + 2;
	            #end 
            }
        
            // sides
            union{  
                #local incr = 1;
                #local maxAngle = 134;
                #local cnt = 0;
                #local rad = 1.942;
                #local angleX = 14.3;  
                #local angleY = 0;
                #local yc = -rad * sin(radians(angleX)) * 0.401; 
                #local yc1 = -rad * sin(radians(angleX + 1)) * 0.401;
	            #while (angleY < maxAngle)                        
	                #local angleY = incr * cnt;
	                #local xc = rad * cos(radians(angleY)) * 1.001;
	                #local zc = - rad * sin(radians(angleY)) * 0.401;
		            sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY, -angleX> translate <xc, yc, zc>} 
		            #local angleY1 = incr * (cnt + 1);
	                #local xc1 = rad * cos(radians(angleY1)) * 1.001;
	                #local zc1 = - rad * sin(radians(angleY1)) * 0.401;
		            sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY1, -angleX> translate <xc1, yc1, zc1 + 0.004>}
		            #local cnt = cnt + 2;
	            #end 
	        
            }
        }           
    }
          
    // bondage 2
    difference{
        union{
            difference{
                sphere{0, 2 scale <1.001, 0.401, 0.401>}
                difference{
                    sphere{0, 2 scale <1, 0.4, 0.4>}
                    plane{x, -1.4}
                } 
                // back
                plane{x, -1.401}
                plane{-y, 0 translate -y*0.185 translate y*0.085}
                plane{y, 0 translate -y*0.215 translate y*0.085}
            }                               
            // bolts
            union{
                // back 
                union{  
                    #local num = 42;
                    #local cnt = 0;
	                #while (cnt < num)   
	                    sphere{0, 0.004 scale <0.4, 1, 1> translate <-1.401, -0.2 - 0.006, -0.52 + (cnt * 0.025)> translate y*0.085} 
	                    sphere{0, 0.004 scale <0.4, 1, 1> translate <-1.401, -0.2 + 0.006, -0.52 + ((cnt + 1) * 0.025)> translate y*0.085}
    	                #local cnt = cnt + 2;
	                #end 
                }
        
                // sides
                union{  
                    #local incr = 1;
                    #local maxAngle = 132;
                    #local cnt = 0;
                    #local rad = 1.985;
                    #local angleX = 7.8;  
                    #local angleY = 0;
                    #local yc = -rad * sin(radians(angleX)) * 0.401; 
                    #local yc1 = -rad * sin(radians(angleX + 1)) * 0.401;
	                #while (angleY < maxAngle)                        
	                    #local angleY = incr * cnt;
	                    #local xc = rad * cos(radians(angleY)) * 1.001;
	                    #local zc = - rad * sin(radians(angleY)) * 0.401;
		                sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY, -angleX> translate <xc, yc, zc>} 
		                #local angleY1 = incr * (cnt + 1);
	                    #local xc1 = rad * cos(radians(angleY1)) * 1.001;
	                    #local zc1 = - rad * sin(radians(angleY1)) * 0.401;
		                sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY1, -angleX> translate <xc1, yc1, zc1 + 0.004>}
		                #local cnt = cnt + 2;
	                #end 
	        
                }
            }
        }
        union{   
            // back holes   
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3>} 
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.15} 
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.5}
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.65}
            // right side holes    
            // third level 
            union{  
                #local num = 13;
                #local cnt = 0;
	            #while (cnt < num)   
	                box{<-0.025, 0.05, -1>, <0.025, 0.1, 0> translate -y*0.05 translate x*(1.4 - 0.2*cnt) translate <-0.1, -0.15, 0>}
    	            #local cnt = cnt + 1;
	            #end 
	        }
        }
    }

    // bondage 3
    difference{
        union{
            difference{
                sphere{0, 2 scale <1.001, 0.401, 0.401>}
                sphere{0, 2 scale <1, 0.4, 0.4>}
                // back
                plane{x, -1.19}
                plane{-y, 0 translate -y*0.185 translate y*0.238}
                plane{y, 0 translate -y*0.215 translate y*0.238}
            }                               
            // bolts
            // sides
            union{  
                #local incr = 1;
                #local maxAngle = 124;
                #local cnt = 0;
                #local rad = 2;
                #local angleX = 2.2;  
                #local angleY = 0;
                #local yc = rad * sin(radians(angleX)) * 0.401; 
                #local yc1 = rad * sin(radians(angleX + 1)) * 0.401;
                #while (angleY < maxAngle)                        
	                #local angleY = incr * cnt;
	                #local xc = rad * cos(radians(angleY)) * 1.001;
	                #local zc = - rad * sin(radians(angleY)) * 0.401;
	                sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY, -angleX> translate <xc, yc, zc>} 
		            #local angleY1 = incr * (cnt + 1);
	                #local xc1 = rad * cos(radians(angleY1)) * 1.001;
	                #local zc1 = - rad * sin(radians(angleY1)) * 0.401;
		            sphere{0, 0.004 scale <0.4, 1, 1> rotate <0, angleY1, -angleX> translate <xc1, yc1, zc1>}
		            #local cnt = cnt + 2;
	            #end 
            }
        }
        union{   
            // back holes   
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3>} 
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.15} 
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.5}
            box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.65}
            // right side holes    
            // second level 
            union{  
                #local num = 13;
                #local cnt = 0;
	            #while (cnt < num)   
	                box{<-0.025, 0.05, -1>, <0.025, 0.1, 0> translate -y*0.05 translate x*(1.4 - 0.2*cnt)}
    	            #local cnt = cnt + 1;
	            #end 
            }
        }                   
    }
    texture{MetalTxt}
}

// side balcoon
#declare SideBalcony = union{
    cylinder{0, <0, 0.28, 0>, 0.07}         
    cylinder{0, <0, 0.006, 0>, 0.08 translate -y*0.004}
    cylinder{0, <0, 0.006, 0>, 0.08 translate y*0.076}
    cylinder{0, <0, 0.006, 0>, 0.08 translate y*0.196}
    cylinder{0, <0, 0.006, 0>, 0.08 translate y*0.276}
    // balcoon columns
    // 1
    #local num = 18;                                     
    #local incr = 360/num;
    #local cnt = 0;        
    #while (cnt < num)   
        object{Column translate -z*0.07 rotate y*cnt*incr}
        #local cnt = cnt + 1;
    #end
	// 2
    #local num = 18;                                     
	#local incr = 360/num;
    #local cnt = 0;        
	#while (cnt < num)   
	    object{Column translate <0, 0.2, -0.07> rotate y*cnt*incr}
    #local cnt = cnt + 1;
	#end 
	// glass
	cylinder{0, <0, 0.09, 0>, 0.072 translate y*0.095 texture{BalconyWindowsTxt}}
	// window
	cylinder{0, <0, 0.007, 0>, 0.075 translate -y*0.0035 translate y*0.095}
	cylinder{0, <0, 0.007, 0>, 0.075 translate -y*0.0035 translate y*0.185}
	#local num = 3;                                     
	#local incr = 180/num;
    #local cnt = 0;        
	#while (cnt < num)  
	    difference{
	        cylinder{<0, 0.0035, 0>, <0, 0.089, 0>, 0.075 translate y*0.095} 
	        plane{x, 0 translate -x*0.003} 
	        plane{-x, 0 translate x*0.003} 
	        rotate y*cnt*incr
	    } 
        #local cnt = cnt + 1;
	#end 
	#local num = 12;                                     
	#local incr = 180/num;
    #local cnt = 0;        
	#while (cnt < num)  
	    difference{
	        cylinder{<0, 0.0035, 0>, <0, 0.089, 0>, 0.074 translate y*0.095} 
	        plane{x, 0 translate -x*0.002} 
	        plane{-x, 0 translate x*0.002} 
	        rotate y*cnt*incr
	    } 
    #local cnt = cnt + 1;
	#end 
	#local num = 3;                                     
	#local incr = 0.09/num;
    #local cnt = 0;        
	#while (cnt < num)
	    cylinder{<0, -0.002, 0>, <0, 0.002, 0>, 0.074 translate y*0.095 translate y*cnt*incr}  
    #local cnt = cnt + 1;
	#end                           
	
	texture{PaintDarkTxt}
}

#declare SideBalconies = union{
    object{SideBalcony translate<-1.56, 0, -0.48>}  
    object{SideBalcony translate<-1.56, 0, 0.48>} 

    // row columns 1
    union{  
        #local incr = 1.2;
        #local maxAngle = 140;
        #local cnt = 0;
        #local rad = 1.98;
        #local startY = 128;
        #local angleY = startY;
	    #while (angleY < maxAngle)                        
	        #local angleY = startY + incr * cnt;
	        #local xc = rad * cos(radians(angleY)) * 1.001;
	        #local zc = - rad * sin(radians(angleY)) * 0.401; 
	        object{Column translate<xc, 0, zc>} 
	        #local cnt = cnt + 1;
	    #end 
    } 
    // row columns 2
    union{  
        #local incr = 1.2;
        #local maxAngle = 140;
        #local cnt = 0;
        #local rad = 1.98;
        #local startY = 127;
        #local angleY = startY;
	    #while (angleY < maxAngle)                        
	        #local angleY = startY + incr * cnt;
	        #local xc = rad * cos(radians(angleY)) * 1.001;
	        #local zc = - rad * sin(radians(angleY)) * 0.401; 
	        object{Column translate<xc, 0.2, zc + 0.06>} 
	        #local cnt = cnt + 1;
	    #end 
    } 
    // handles 1
    difference{
        sphere{0, 2.02 scale <1, 0.4, 0.4>} 
        sphere{0, 1.99 scale <1, 0.4, 0.4>}
        plane{y, 0.075} 
        plane{-y, 0 translate y*0.082}
        plane{x, 0 translate -x*1.59}
        plane{-x, 0 translate -x*1.19}
        
        texture{PaintDarkTxt}
    }
    // handles 2
    difference{
        sphere{0, 2.02 scale <1, 0.4, 0.4>}
        sphere{0, 1.99 scale <1, 0.4, 0.4>}
        plane{y, 0.275} 
        plane{-y, 0 translate y*0.282}
        plane{x, 0 translate -x*1.59}
        plane{-x, 0 translate -x*1.19}
        
        texture{PaintDarkTxt}
    }                        
}

#declare SideWindows = union{
    // side windows 1
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.1>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.11>}
        } 
        #local incr = (0.39 - 0.11)/12; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*4}
        union{ 
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*5}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*6}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*7}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*8}
        union{    
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*9}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*10}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*11}
        } 
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105> translate y*0.025}
        // glass
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.11> texture{WindowsTxt rotate y*90}}  
        
        translate x*1.5
        rotate -y*60
        translate <-1.147, 0, -0.62>
    }
    
    // side windows 2
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.1>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.11>}
        } 
        #local incr = (0.39 - 0.11)/12; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*4}
        union{ 
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*5}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*6}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*7}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*8}
        union{    
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*9}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*10}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*11}
        } 
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105> translate y*0.025}
        // glass
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.11> texture{WindowsTxt rotate y*90}}  
        
        translate x*1.5
        rotate -y*60
        translate <-1.147, 0.2, -0.54>
    }                                        
    
    texture{PaintDarkTxt}
} 

#declare BackWindowsDoors = union{
    // windows 1st left
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.1>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.11>}
        } 
        #local incr = (0.39 - 0.11)/12; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*4}
        union{ 
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*5}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*6}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*7}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*8}
        union{    
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*9}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*10}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*11}
        } 
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105> translate y*0.025}
        
        translate <0.007, 0, 0>
    } 
    // windows 1st right
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.1>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.11>}
        } 
        #local incr = (0.39 - 0.11)/12; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*4}
        union{ 
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*5}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*6}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*7}
        }  
        box{<-1.505, 0.105, 0.395>, <-1.52, 0.185, 0.385> translate -z*incr*8}
        union{    
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*9}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*10}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*11}
        } 
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.105> translate y*0.025}
        
        translate <0.007, 0, -0.5>
    }
    
    // doors 1st 
    union{    
        difference{
            box{<-1.495, 0, -0.1>, <-1.49, 0.19, 0.1>}
            box{<-1.5, 0.005, -0.1>, <-1.1, 0.185, 0.1>} 
        } 
        difference{
            box{<-1.51, 0.005, -0.1>, <-1.49, 0.185, 0.1>}  
            box{<-1.6, 0.01, -0.095>, <-1.3, 0.18, 0.095>} 
        }   
        box{<-1.51, 0.01, 0.003>, <-1.49, 0.18, -0.003>} 
        #local num = 7;
        #local cnt = 0;        
        #local incr = (0.18 - 0.01)/num;
	    #while (cnt < num)   
	        box{<-1.50, 0.01, -0.095>, <-1.48, 0.014, 0.095> translate <0, cnt*incr, 0>}
         #local cnt = cnt + 1;
	    #end 
	    #local num = 8;
        #local cnt = 0;        
        #local incr = (0.095 * 2)/num;
	    #while (cnt < num)   
	        box{<-1.50, 0.01, 0.0975>, <-1.48, 0.18, 0.0925> translate <0, 0, -cnt*incr>}
        #local cnt = cnt + 1;
	    #end
	}
	
	// glass 1st
	union{
        // left
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.11> translate <0.007, 0, 0>}
        // right
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.11> translate <0.007, 0, -0.5>}
        // doors
        box{<-1.495, 0.01, -0.095>, <-1.490, 0.18, 0.095>}
        
        texture{WindowsTxt rotate y*90}	    
	}
     
    // windows 2nd left
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.3>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.31>}
        } 
        #local incr = (0.39 - 0.31)/4; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.305>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.305> translate y*0.025}
        
        translate <0.007, 0.2, -0.2>
    } 
    
    // windows 2nd right
    union{
        difference {
            box{<-1.505, 0.1, 0.4>, <-1.52, 0.19, 0.3>} 
            box{<-1.6, 0.11, 0.39>, <-1.4, 0.18, 0.31>}
        } 
        #local incr = (0.39 - 0.31)/4; 
        union{
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*1}  
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*2}
            box{<-1.505, 0.105, 0.3925>, <-1.51, 0.185, 0.3875> translate -z*incr*3}
        }  
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.305>}
        box{<-1.505, 0.13, 0.395>, <-1.51, 0.135, 0.305> translate y*0.025}
        
        translate <0.007, 0.2, -0.5>
    } 
	
	// doors 2nd 
    union{    
        difference{
            box{<-1.495, 0, -0.1>, <-1.49, 0.19, 0.1>}
            box{<-1.5, 0.005, -0.1>, <-1.1, 0.185, 0.1>} 
        } 
        difference{
            box{<-1.51, 0.005, -0.1>, <-1.49, 0.185, 0.1>}  
            box{<-1.6, 0.01, -0.095>, <-1.3, 0.18, 0.095>} 
        }   
        box{<-1.51, 0.01, 0.003>, <-1.49, 0.18, -0.003>} 
        #local num = 7;
        #local cnt = 0;        
        #local incr = (0.18 - 0.01)/num;
	    #while (cnt < num)   
	        box{<-1.50, 0.01, -0.095>, <-1.48, 0.014, 0.095> translate <0, cnt*incr, 0>}
         #local cnt = cnt + 1;
	    #end 
	    #local num = 8;
        #local cnt = 0;        
        #local incr = (0.095 * 2)/num;
	    #while (cnt < num)   
	        box{<-1.50, 0.01, 0.0975>, <-1.48, 0.18, 0.0925> translate <0, 0, -cnt*incr>}
        #local cnt = cnt + 1;
	    #end
	    
	    translate y*0.2
	} 
	
	// glass 2nd
    union{
        // left
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.31> translate <0.007, 0.2, -0.2>} 
        // right
        box{<-1.5, 0.11, 0.39>, <-1.505, 0.18, 0.31> translate <0.007, 0.2, -0.5>}
        // doors
	    box{<-1.495, 0.01, -0.095>, <-1.490, 0.18, 0.095> translate y*0.2}
	    
	    texture{WindowsTxt rotate y*90 translate y*0.2}
    }	
	                   
	texture{PaintDarkTxt}
}                            

#declare BackBalcony = union{
	#declare Balcony = union{
	    difference{
	        union{
	            cylinder{<-1.6, 0, 0>, <-1.6, 0.01, 0>, 0.2} 
	            torus{0.2, 0.004 translate -x*1.6}
	        }
	        plane{-x, 0 translate -x*1.6}
	    }    
	    // columns
	    #local num = 25;                                     
	    #local incr = 180/num;
        #local cnt = 0;        
	    #while (cnt < num)   
	        object{Column translate -z*0.2 rotate y*cnt*incr translate <-1.6, 0, 0>}
        #local cnt = cnt + 1;
	    #end  
	    // handle
	    difference{
	        cylinder{0, <0, 0.006, 0>, 0.215}
	        cylinder{<0, -1, 0>, <0, 1, 0>, 0.19}
	        plane{-x, 0}
	        translate <-1.6, 0.076, 0>
	    }                
	    texture{PaintDarkTxt}
	} 
	// 1st floor
	object{Balcony} 
	// columns rows
	
	// handles               
	union{
	    box{<-0.015, 0, 0.4>, <0.01, 0.006, 0.19> translate <-1.6, 0.076, 0>} 
	    box{<-0.015, 0, -0.19>, <0.01, 0.006, -0.41> translate <-1.6, 0.076, 0>} 
	    cylinder{<0, 0, 0.4>, <0, 0, -0.4>, 0.004 translate <-1.6, 0, 0>}
	    sphere{0, 0.004 translate<-1.6, 0, 0.4>} 
	    sphere{0, 0.004 translate<-1.6, 0, -0.4>}
	    
	    texture{PaintDarkTxt}
	}
	
	#local num = 6;                                     
	#local incr = 0.2/num;
    #local cnt = 0;        
	#while (cnt < num)   
	    object{Column translate -z*(0.4 - incr*cnt) translate <-1.6, 0, 0>}
	    object{Column translate z*(0.4 - incr*cnt) translate <-1.6, 0, 0>}
    #local cnt = cnt + 1;
	#end 
	
	// 2nd floor
	object{Balcony translate y*0.19}
}                          

#declare PortDoors = union{
    #declare PortDoor = union {
        box{<-0.025, 0, -0.025>, <0.025, -0.003, 0.025>} 
        box{<-0.028, 0, -0.028>, <0.028, 0.005, 0.028>} 
        
        texture{PaintDarkTxt}
    }
    
    // back
    
    object{PortDoor translate -x*0.028 rotate -z*45 translate <-1.4, -0.1, -0.325>}
    object{PortDoor translate -x*0.028 rotate -z*47 translate <-1.4, -0.1, -0.325> translate z*0.15}
    object{PortDoor translate -x*0.028 rotate -z*42 translate <-1.4, -0.1, -0.325> translate z*0.5}
    object{PortDoor translate -x*0.028 rotate -z*46 translate <-1.4, -0.1, -0.325> translate z*0.65}
    
    // right side
 
    union{  
        #local num= 13;
        #local angleX = 7.2;  
        #local yc = rad * sin(radians(angleX)) * 0.401; 
        #local cnt = 0;
	    #while (cnt < num)                        
	        #local angleY = incr * cnt; 
	        #local xc = 1.4 - 0.2*cnt;
	        #local zc = -(sqrt(1.98*1.98 - xc*xc)) * 0.401; 
	        object{PortDoor translate -z*0.028 rotate x*47 rotate y*(-7+cnt) translate -y*0.053 translate <xc, yc, zc - 0.008>}
		    #local cnt = cnt + 1;
	    #end    
	    #local num= 13;  
	    #local angleX = 3.7;  
        #local yc = -rad * sin(radians(angleX)) * 0.401;
	    #local cnt = 0;
	    #while (cnt < num)                        
	        #local angleY = incr * cnt; 
	        #local xc = 1.4 - 0.2*cnt - 0.1;
	        #local zc = -(sqrt(1.99*1.99 - xc*xc)) * 0.401; 
	        object{PortDoor translate -z*0.028 rotate x*47 rotate y*(-7+cnt) translate -y*0.05 translate <xc, yc, zc>}
		    #local cnt = cnt + 1;
	    #end    
    }  
}                  

#declare Guns = union{
    #declare Gun = difference{
        union{
            difference{sphere{0, 0.3} plane{-x, 0}}
            cone{0, 0.3, <1.5, 0, 0>, 0.2}
            torus{0.18, 0.05 rotate z*90 translate x*1.5}
            cone{0, 0.23, <0.2, 0, 0>, 0.20 translate x*1.5} 
            torus{0.19, 0.06 rotate z*90 translate x*1.6}
        } 
        cylinder{0, <2, 0, 0>, 0.1} 
        texture{GunTxt}
    }  
    
    // back
    object{Gun scale 0.05 rotate z*180 translate <-1.35, -0.125, -0.325>}
    object{Gun scale 0.05 rotate z*180 translate <-1.35, -0.125, -0.325> translate z*0.15}
    object{Gun scale 0.05 rotate z*180 translate <-1.35, -0.125, -0.325> translate z*0.5}
    object{Gun scale 0.05 rotate z*180 translate <-1.35, -0.125, -0.325> translate z*0.65} 
    
    // right side
    union{  
        #local num= 13;
        #local angleX = 7.2;  
        #local yc = (rad * sin(radians(angleX)) * 0.401) - 0.025; 
        #local cnt = 0; 
	    #while (cnt < num)                        
	        #local angleY = incr * cnt; 
	        #local xc = 1.4 - 0.2*cnt;
	        #local zc = -(sqrt(1.98*1.98 - xc*xc)) * 0.401; 
	        object{Gun scale 0.05 rotate y*90 rotate y*(-7+cnt) translate -y*0.05 translate <xc, yc, zc + 0.045>}
		    #local cnt = cnt + 1;
	    #end
	    #local num= 13;  
	    #local angleX = 3.7;  
        #local yc = (-rad * sin(radians(angleX)) * 0.401) - 0.025;
	    #local cnt = 0;
	    #while (cnt < num)                        
	        #local angleY = incr * cnt; 
	        #local xc = 1.4 - 0.2*cnt - 0.1;
	        #local zc = -(sqrt(1.99*1.99 - xc*xc)) * 0.401;     
	        object{Gun scale 0.05 rotate y*90 rotate y*(-7+cnt) translate -y*0.05 translate <xc, yc, zc + 0.06>}
		    #local cnt = cnt + 1;
	    #end    
    }  
}                       

#declare Build1 = union{
    box{0, <0.1, 0.007, -0.1>}
    box{<0.004, -0.1, -0.004>, 0 rotate -x*45 translate <0, 0.002, -0.09>}
    box{<0.004, -0.1, -0.004>, 0 rotate -x*45 translate <0.05, 0.002, -0.09>}
    box{<0.004, -0.1, -0.004>, 0 rotate -x*45 translate <0.09, 0.002, -0.09>}
    rotate y*15
    translate <-1.15, 0.3, -0.55>
    
    texture{PaintDarkTxt}
}   

#declare Stairway = union{  
    #declare Step = union{
        cylinder{0, <0, 0, -0.1>, 0.002}
        cylinder{0, <0, 0, -0.1>, 0.002 translate x*0.06}
        cylinder{<0.02, 0, -0.12>, <0.04, 0, -0.12>, 0.002}
        difference{
            torus{0.02, 0.002}
            plane{-x, 0}
            plane{-z, 0}
            translate <0.02, 0, -0.1>
        }
        difference{
            torus{0.02, 0.002}
            plane{x, 0}
            plane{-z, 0}
            translate <0.04, 0, -0.1>    
        }      
        texture{MetalTxt}
    } 
    #local num= 8;  
	#local incr = 2.2;  
	#local cnt = 0;
	#while (cnt < num)                        
	    object{Step rotate <-(6 + cnt * incr), 12, 0> translate -z*0.585 rotate x*(6 + cnt * incr)}
		#local cnt = cnt + 1;
	#end
 
    translate <-1.14, 0, 0>
}                

#declare Grid = union{
    #local num= 8;  
	#local incr = 0.6/num;  
	#local cnt = 0;
	#while (cnt < num)
	    union{                        
            box{<0, 0, -0.55>, <0.006, 0.01, 0.55>} 
            union{
                cylinder{<0.003, 0, -0.55>, <0.003, 0.02, -0.55>, 0.004} 
                cylinder{<0.003, 0, 0.55>, <0.003, 0.02, 0.55>, 0.004}
                sphere{0, 0.006 scale <1, 0.5, 1> translate <0.003, 0.02, -0.55>} 
                sphere{0, 0.006 scale <1, 0.5, 1> translate <0.003, 0.02, 0.55>}
                texture{BlockTxt}
            }
            translate x*cnt*incr
        }
		#local cnt = cnt + 1;
	#end 
	#local num = 11;  
	#local incr = 1.1/num;  
	#local cnt = 0;
	#while (cnt <= num) 
	    union{                       
            box{<-0.01, 0, -0.54>, <0.61, 0.01, -0.534>}
            union{
                cylinder{<-0.01, 0, -0.537>, <-0.01, 0.02, -0.537>, 0.004} 
                cylinder{<0.61, 0, -0.537>, <0.61, 0.02, -0.537>, 0.004} 
                sphere{0, 0.006 scale <1, 0.5, 1> translate <-0.01, 0.02, -0.537>} 
                sphere{0, 0.006 scale <1, 0.5, 1> translate <0.61, 0.02, -0.537>}
                texture{BlockTxt}
            }
            translate z*cnt*incr
        }
		#local cnt = cnt + 1;
	#end                 
	
	texture{PaintDarkTxt}
	                                  
	translate <-1.58, 0.4, 0>
} 

#declare Lamp = union{
    // base
    sphere{0, 0.1}  
    torus{0.2, 0.03 rotate x*90 translate y*0.2} 
    torus{0.2, 0.03 rotate <90, 60, 0> translate y*0.2}
    torus{0.2, 0.03 rotate <90, -60, 0> translate y*0.2}
    sphere{0, 0.1 scale<1, 2, 1> translate<0, 0.25, 0>} 
    sphere{0, 0.3 scale<1, 1/3, 1> translate<0, 0.4, 0>}
    box{<-0.4, 0.4, -0.4>, <0.4, 0.5, 0.4>}
    // roof
    box{<-0.6, 1.7, -0.6>, <0.6, 1.8, 0.6>}
    sphere{<-0.55, 1.85, -0.55>, 0.05}
    sphere{<0.55, 1.85, -0.55>, 0.05}
    sphere{<0.55, 1.85, 0.55>, 0.05}
    sphere{<-0.55, 1.85, 0.55>, 0.05}
    sphere{<0, 2.2, 0>, 0.1}
    torus{0.2, 0.03 rotate x*90 translate y*2.4} 
    torus{0.2, 0.03 rotate <90, 60, 0> translate y*2.4}
    torus{0.2, 0.03 rotate <90, -60, 0> translate y*2.4} 
    sphere{<0, 2.6, 0>, 0.1}
    intersection{
        plane{-y, 0}
        plane{y, 0 rotate -x*40 translate -z*0.5}
        plane{y, 0 rotate -x*40 translate -z*0.5 rotate y*90}
        plane{y, 0 rotate -x*40 translate -z*0.5 rotate y*180}
        plane{y, 0 rotate -x*40 translate -z*0.5 rotate y*270}
        translate y*1.8
    }
    // glass
    intersection{
        plane{-y, 0 translate y*0.45}
        plane{y, 1.75}
        plane{x, 0 rotate -z*7 translate x*0.3} 
        plane{x, 0 rotate -z*7 translate x*0.3 rotate y*90}
        plane{x, 0 rotate -z*7 translate x*0.3 rotate y*180}
        plane{x, 0 rotate -z*7 translate x*0.3 rotate y*270}
        hollow
        pigment{color rgbf <1, 1, 1, 0.8>} finish{ambient 0 phong 0.4}
    }   
    // supports
    difference{
        intersection{
            plane{-y, 0 translate y*0.45}
            plane{y, 1.75}
            plane{x, 0 rotate -z*7 translate x*0.32} 
            plane{x, 0 rotate -z*7 translate x*0.32 rotate y*90}
            plane{x, 0 rotate -z*7 translate x*0.32 rotate y*180}
            plane{x, 0 rotate -z*7 translate x*0.32 rotate y*270}
            hollow
        }
        intersection{
            plane{x, 0 rotate -z*7 translate x*0.2} 
            plane{x, 0 rotate -z*7 translate x*0.2 rotate y*180}
        } 
        intersection{
            plane{x, 0 rotate -z*7 translate x*0.2 rotate y*90} 
            plane{x, 0 rotate -z*7 translate x*0.2 rotate y*270}
        }
    }
    texture{MetalTxt}
    scale 0.03
}

#declare Lights = union{
    // left
    union{
        object{Lamp} 
        light_source {
            <0, 0.033, 0> color rgb <1, 0.9, 0.75>
            glow {size 0.016 type 0}
	        fade_distance 0.5 fade_power 2
	    }
	    cylinder{0, <0.1, 0, 0>, 0.002}
	    translate <-1.7, 0.33, 0.28>     
	}
    // right
    union{
        object{Lamp} 
        light_source {
            <0, 0.033, 0> color rgb <1, 0.9, 0.75>
            glow {size 0.016 type 0}
	        fade_distance 0.5 fade_power 2
	    }  
	    cylinder{0, <0.1, 0, 0>, 0.002}
	    translate <-1.7, 0.33, -0.28>     
	} 
	// back
	union{
        object{Lamp} 
        light_source {
            <0, 0.033, 0> color rgb <1, 0.9, 0.75>
            glow {size 0.012 type 0}
	        fade_distance 0.5 fade_power 2
	    } 
	    rotate y*28
	    translate <-1.76, -2.6*0.03, 0>     
	}
	// right side
	union{
        object{Lamp} 
        light_source {
            <0, 0.033, 0> color rgb <0.6, 0.5, 0.35>
            glow {size 0.018 type 0}
	        fade_distance 0.25 fade_power 2
	    } 
	    rotate y*15
	    translate <-1.145, 0.307, -0.655>     
	}
} 

#declare Ornament = height_field {
    png "ornament.png"
    smooth  
    water_level 0.1
    texture{
        pigment {
            gradient y
            color_map{
                [0 color rgb<0.2, 0.1, 0>]
                [1 color rgb<1.4, 1.3, 0.95>]
            }
        } 
        finish{ambient 0.14 diffuse 0.6 phong 0.3}
    }
    translate -y*0.1
    scale<1, 0.02, 1> 
    translate -x*0.5
    scale <2, 1, 1> 
    scale 0.425
    rotate <-90, 90, 0>
    translate<-1.6, 0.12, 0>
}

#declare Top = union{
    cylinder{<-0.15, 0, -0.15>, <0.05, 0, -0.15>, 0.01} 
    cylinder{<-0.15, 0, -0.15>, <0.05, 0, -0.15>, 0.01 translate z*0.3}
    difference{
        torus{0.15, 0.01}
        plane{x, 0}
        translate x*0.05
    }
    sphere{<-0.15, 0, -0.15>, 0.01}
    sphere{<-0.15, 0, 0.15>, 0.01}              
    cylinder{<-0.15, 0, -0.15>, <-0.15, 0, 0.15>, 0.01}
    difference{
        union{
            box{<-0.15, -0.005, -0.15>, <0.05, 0.005, 0.15>}
            difference{
                cylinder{<0.05, -0.005, 0>, <0.05, 0.005, 0>, 0.149}
                plane{x, 0}
            }
        }
        box{<-0.05, -1, -0.1>, <0.1, 1, 0.1>}
    }
    cylinder{<-0.15, 0, -0.02>, <0.19, 0, -0.02>, 0.01} 
    cylinder{<-0.15, 0, -0.02>, <0.19, 0, -0.02>, 0.01 translate z*0.04}
    cylinder{<-0.05, 0, -0.15>, <-0.05, 0, 0.15>, 0.01}
    // back
    union{
        cylinder{<0, 0, -0.15>, <0, 0.05, -0.15>, 0.01} 
        cylinder{<0, 0, -0.15>, <0, 0.05, -0.15>, 0.01 translate z*0.1}
        cylinder{<0, 0, -0.15>, <0, 0.05, -0.15>, 0.01 translate z*0.2}
        cylinder{<0, 0, -0.15>, <0, 0.05, -0.15>, 0.01 translate z*0.3}
        cylinder{<0, 0.05, -0.15>, <0, 0.05, 0.15>, 0.01}
        sphere{<0, 0.05, -0.15>, 0.01}
        sphere{<0, 0.05, 0.15>, 0.01}
        box{<-0.005, 0, -0.15>, <0.005, 0.05, 0.15>}
        rotate z*20
        translate -x*0.15
    } 
    light_source {
        <0, -0.05, -0.08> color rgb 0.5 
        fade_distance 0.5 fade_power 2
	}
	light_source {
        <0, -0.05, 0.08> color rgb 0.5
        fade_distance 0.5 fade_power 2
	}       
	
	texture{PaintDarkTxt}
}

#declare Mizzen = union{ 
    // mast
    cone{0, 0.03, <0, 1.5, 0>, 0.02}
    cone{<0.056, 1.3, 0>, 0.02, <0.056, 2.5, 0>, 0.006} 
    // caps
    box{<-0.03, 1.299, -0.03>, <0.086, 1.331, 0.03>} 
    box{<-0.033, 1.32, -0.033>, <0.089, 1.324, 0.033>}
    
    box{<-0.03, 1.299 + 0.2 - 0.03, -0.03>, <0.086, 1.331 + 0.2 - 0.03, 0.03>}
    box{<-0.033, 1.32 + 0.2 - 0.03, -0.033>, <0.089, 1.324 + 0.2 - 0.03, 0.033>}
    // rings
    union{
    	#local num= 6;  
		#local cnt = 0;
		#while (cnt < num) 
			torus{0.006, 0.002 rotate x*90 translate<-0.032+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006, 0.1+(cnt*0.2)+0.025/2, 0>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, -0.032+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, 0.032-((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)+0.006>}
			#local cnt = cnt + 1;
		#end    	
    	difference{
        	cone{0, 0.032, <0, 1.5, 0>, 0.022}
        	box{<-1, -1, -1>, <1, 0.1, 1>}
        	box{<-1, 0.1 + 0.025, -1>, <1, 0.3, 1>} 
        	box{<-1, 0.3 + 0.025, -1>, <1, 0.5, 1>} 
        	box{<-1, 0.5 + 0.025, -1>, <1, 0.7, 1>}
        	box{<-1, 0.7 + 0.025, -1>, <1, 0.9, 1>}
        	box{<-1, 0.9 + 0.025, -1>, <1, 1.1, 1>}
        	box{<-1, 1.1 + 0.025, -1>, <1, 3, 1>}
    	}
    	texture{MetalTxt}
    }
     
    object{Top scale 0.8 translate y*1.35}
    
    translate -x*0.9
    
    texture{MastTxt} 
} 

#declare Main = union{
    // mast
    cone{0, 0.035, <0, 1.5, 0>, 0.025}
    cone{<0.062, 1.3, 0>, 0.025, <0.062, 2.2, 0>, 0.015} 
    cone{<0.1, 2, 0>, 0.015, <0.1, 3, 0>, 0.005} 
    // caps
    box{<-0.03, 1.299, -0.03>, <0.086, 1.331, 0.03>}
    box{<-0.033, 1.32, -0.033>, <0.089, 1.324, 0.033>}
     
    box{<-0.03, 1.299 + 0.2 - 0.03, -0.03>, <0.086, 1.331 + 0.2 - 0.03, 0.03>}
    box{<-0.033, 1.32 + 0.2 - 0.03, -0.033>, <0.089, 1.324 + 0.2 - 0.03, 0.033>} 
    
    box{<0.03, 1.999, -0.02>, <0.11, 2.031, 0.02>} 
    box{<0.03, 1.999 + 0.2 - 0.03, -0.02>, <0.11, 2.031 + 0.2 - 0.03, 0.02>}
    // rings                      
    union{ 
    	#local num= 6;  
		#local cnt = 0;
		#while (cnt < num) 
			torus{0.006, 0.002 rotate x*90 translate<-0.037+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006, 0.1+(cnt*0.2)+0.025/2, 0>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, -0.037+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, 0.037-((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)+0.006>}
			#local cnt = cnt + 1;
		#end
    	difference{
        	cone{0, 0.037, <0, 1.5, 0>, 0.027}
        	box{<-1, -1, -1>, <1, 0.1, 1>}
        	box{<-1, 0.1 + 0.025, -1>, <1, 0.3, 1>} 
        	box{<-1, 0.3 + 0.025, -1>, <1, 0.5, 1>} 
        	box{<-1, 0.5 + 0.025, -1>, <1, 0.7, 1>}
        	box{<-1, 0.7 + 0.025, -1>, <1, 0.9, 1>}
        	box{<-1, 0.9 + 0.025, -1>, <1, 1.1, 1>}
        	box{<-1, 1.1 + 0.025, -1>, <1, 3, 1>}
    	}     
    	texture{MetalTxt} 
    }
    
    object{Top translate y*1.35}
    
    translate x*0.2
    
    texture{MastTxt}
} 

#declare Fore = union{ 
    // mast
    cone{0, 0.035, <0, 1.3, 0>, 0.025}
    cone{<0.062, 1.1, 0>, 0.025, <0.062, 2.1, 0>, 0.015} 
    cone{<0.1, 1.9, 0>, 0.015, <0.1, 2.7, 0>, 0.005} 
    // caps
    box{<-0.03, 1.299 - 0.2, -0.03>, <0.086, 1.331 - 0.2, 0.03>} 
    box{<-0.03, 1.299 - 0.03, -0.03>, <0.086, 1.331 - 0.03, 0.03>} 
    
    box{<0.03, 1.999 - 0.1, - 0.02>, <0.11, 2.031 - 0.1, 0.02>} 
    box{<0.03, 1.999 + 0.1 - 0.03, -0.02>, <0.11, 2.031 + 0.1 - 0.03, 0.02>}
    // rings    
    union{ 
    	#local num= 5;  
		#local cnt = 0;
		#while (cnt < num) 
			torus{0.006, 0.002 rotate x*90 translate<-0.037+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006, 0.1+(cnt*0.2)+0.025/2, 0>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, -0.037+((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)-0.006>} 
			torus{0.006, 0.002 rotate z*90 translate<0, 0.1+(cnt*0.2)+0.025/2, 0.037-((0.01*(0.1+(cnt*0.2) + 0.025/2))/1.5)+0.006>}
			#local cnt = cnt + 1;
		#end
    	difference{
        	cone{0, 0.037, <0, 1.5, 0>, 0.027}
        	box{<-1, -1, -1>, <1, 0.1, 1>}
        	box{<-1, 0.1 + 0.025, -1>, <1, 0.3, 1>} 
        	box{<-1, 0.3 + 0.025, -1>, <1, 0.5, 1>} 
        	box{<-1, 0.5 + 0.025, -1>, <1, 0.7, 1>}
        	box{<-1, 0.7 + 0.025, -1>, <1, 0.9, 1>}
        	box{<-1, 0.9 + 0.025, -1>, <1, 3, 1>}
        }
        texture{MetalTxt}   
    }
    object{Top scale 0.8 translate y*1.15}
    
    translate x*1.3
    
    texture{MastTxt} 
}

#declare Standing = union{
    box{<0.05, 0, 0>, <0.3, 0.01, -0.2> rotate y*9 translate <-0.9, 0.22, -0.52> texture{PaintDarkTxt}}
    box{<0.05, 0, 0>, <0.3, 0.01, -0.2> rotate y*9 translate <-0.9, 0.14, -0.52> texture{PaintDarkTxt}}
    
    // mizzen right shrouds
    
    // starts
    #declare Block = union{           
        difference{
            difference{
                sphere{0, 0.01}
                sphere{0, 0.004 translate -z*0.01}
                scale<1, 1, 0.5>
            }
            torus{0.01, 0.004 rotate x*90}
        } 
        difference{
            difference{
                sphere{0, 0.01}
                sphere{0, 0.004 translate -z*0.01}
                scale<1, 1, 0.5>
            }
            torus{0.01, 0.004 rotate x*90} 
            translate -y*0.05
        }
        // ropes             
        union{
            difference{
                torus{0.008, 0.002 rotate x*90}
                plane{y, 0}
            }
            difference{
                torus{0.008, 0.002 rotate x*90}
                plane{-y, 0}
                translate -y*0.05
            }
            cylinder{<-0.008, 0, 0>, <-0.008, -0.05, 0>, 0.002} 
            cylinder{<0.008, 0, 0>, <0.008, -0.05, 0>, 0.002}
            
            texture{RopeTxt}
        }
        
        texture{BlockTxt}
    }                                 
    union{
        object{Block} 
        object{Block translate x*0.05} 
        object{Block translate x*0.1}
        object{Block translate x*0.15}
        object{Block translate x*0.2}
        
        rotate y*9
        translate<-0.85, 0.21, -0.72>
    }
    // finish
    union{
        cylinder{0, <0, -0.2, 0>, 0.002 rotate -x*10} 
        cylinder{0, <0, -0.2, 0>, 0.002 rotate -x*10 translate x*0.05} 
        cylinder{0, <0, -0.2, 0>, 0.002 rotate -x*10 translate x*0.1}
        cylinder{0, <0, -0.2, 0>, 0.002 rotate -x*10 translate x*0.15}
        cylinder{0, <0, -0.2, 0>, 0.002 rotate -x*10 translate x*0.2}
        
        union{               
            sphere{<0, -0.064, 0>, 0.01 scale<0.5, 1, 0.5> rotate -x*10}
            sphere{<0, -0.064, 0>, 0.01 scale<0.5, 1, 0.5> rotate -x*10 translate x*0.05}
            sphere{<0, -0.064, 0>, 0.01 scale<0.5, 1, 0.5> rotate -x*10 translate x*0.1}
            sphere{<0, -0.064, 0>, 0.01 scale<0.5, 1, 0.5> rotate -x*10 translate x*0.15}
            sphere{<0, -0.064, 0>, 0.01 scale<0.5, 1, 0.5> rotate -x*10 translate x*0.2}
            texture{BlockTxt}
        }
        
        rotate y*9
        translate<-0.85, 0.17, -0.73> 
        
        texture{RopeTxt}
    }  
    
    // ends 
    difference{     
        union{
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <-0.85, 1.3, -0.03>} 
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <-0.85 - (0.1/5), 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <-0.85 - (0.1/5)*2, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <-0.85 - (0.1/5)*3, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <-0.85 - (0.1/5)*4, 1.3, -0.03>}
        }
        plane{y, 1.3}
        
        texture{BlockTxt}
    }      
        
    // vertical
    cylinder{<-0.65, 0.22, -0.73>, <-0.85, 1.3, -0.03>, 0.002} 
    cylinder{<-0.7, 0.22, -0.73>, <-0.85 - (0.1/5), 1.3, -0.03>, 0.002}
    cylinder{<-0.75, 0.22, -0.73>, <-0.85 - (0.1/5)*2, 1.3, -0.03>, 0.002}
    cylinder{<-0.8, 0.22, -0.73>, <-0.85 - (0.1/5)*3, 1.3, -0.03>, 0.002}
    cylinder{<-0.85, 0.22, -0.73>, <-0.85 - (0.1/5)*4, 1.3, -0.03>, 0.002} 
    #local num= 52;  
	#local incr = 0.025;  
	#local cnt = 0;
	// horizontal
	difference{ 
	    union{
	        #while (cnt < num)
                cylinder{<-0.93, incr*cnt, 0>, <-0.65, incr*cnt, 0>, 0.001} 
		        #local cnt = cnt + 1;
	        #end                
	        rotate x*degrees(asin(0.7/sqrt(0.7*0.7 + 1.08*1.08)))
	        translate<0, 0.22, -0.73>  
	    }
	    plane{x, 0 rotate z*degrees(asin(0.08/sqrt(0.08*0.08 + 1.08*1.08))) translate <-0.85, 0.22, 0>}  
	    plane{-x, 0 rotate z*degrees(asin(0.2/sqrt(0.2*0.2 + 1.08*1.08))) translate <-0.65, 0.22, 0>}        
	}
    
    // mizzen left shrouds
    cylinder{<-0.65, 0.22, 0.73>, <-0.85, 1.3, 0.03>, 0.002} 
    cylinder{<-0.7, 0.22, 0.73>, <-0.85 - (0.1/5), 1.3, 0.03>, 0.002}
    cylinder{<-0.75, 0.22, 0.73>, <-0.85 - (0.1/5)*2, 1.3, 0.03>, 0.002}
    cylinder{<-0.8, 0.22, 0.73>, <-0.85 - (0.1/5)*3, 1.3, 0.03>, 0.002}
    cylinder{<-0.85, 0.22, 0.73>, <-0.85 - (0.1/5)*4, 1.3, 0.03>, 0.002}
    #local num= 52;  
	#local incr = 0.025;  
	#local cnt = 0;
	difference{ 
	    union{
	        #while (cnt < num)
                cylinder{<-0.93, incr*cnt, 0>, <-0.65, incr*cnt, 0>, 0.001} 
		        #local cnt = cnt + 1;
	        #end                
	        rotate -x*degrees(asin(0.7/sqrt(0.7*0.7 + 1.08*1.08)))
	        translate<0, 0.22, 0.73>  
	    }
	    plane{x, 0 rotate z*degrees(asin(0.08/sqrt(0.08*0.08 + 1.08*1.08))) translate <-0.85, 0.22, 0>}  
	    plane{-x, 0 rotate z*degrees(asin(0.2/sqrt(0.2*0.2 + 1.08*1.08))) translate <-0.65, 0.22, 0>}        
	}
	
	    // 2nd level
	// right
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 1)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 1)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 1)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 28;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 1)))}  
	    }
        
        translate<-1, 1.35, -0.158*0.8>
    }       
    // left
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 1)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 1)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 1)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(1 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 28;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 1))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 1)))}  
	    }
        
        translate<-1, 1.35, 0.158*0.8>
    }             
    // separate 
    cylinder{<-1.2, 0, -0.4>, <-0.85 - (0.1/5)*4, 1.3, -0.02> 0.002}
    cylinder{<-1.2, 0, -0.5>, <-0.85 - (0.1/5)*4, 1.3, -0.02> 0.002}
    cylinder{<-1.3, 0, 0>, <-0.85 - (0.1/5)*4, 1.3, 0> 0.002} 
    cylinder{<-1, 0, -0.6>, <-0.85 - (0.1/5)*3, 1.3, 0> 0.002}
    
    cylinder{<-1.5, 0, 0>, <-0.85, 2.3, 0> 0.002} 
    cylinder{<-1.4, 0, -0.2>, <-0.85, 2.3, 0> 0.002} 
    cylinder{<-1.45, 0, -0.2>, <-0.85, 2.3, 0> 0.002}
    
    // 2nd level
    cylinder{<-1, 1.37, -0.02>, <-0.85, 2.3, 0> 0.002} 
    cylinder{<-1, 1.37, 0.01>, <-0.85, 2.3, 0> 0.002}
    
    // main

    // main right shrouds
    // starts
    union{
        object{Block translate -x*0.2} 
        object{Block translate -x*0.15}
        object{Block translate -x*0.1}
        object{Block translate -x*0.05}
        object{Block}
        object{Block translate x*0.05} 
        object{Block translate x*0.1}
        
        translate<0, 0.16, -0.8>
    }
    // ends 
    difference{     
        union{
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2, 1.3, -0.03>} 
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*1, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*2, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*3, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*4, 1.3, -0.03>}  
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*5, 1.3, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*6, 1.3, -0.03>}
        }
        plane{y, 1.3}
        
        texture{BlockTxt}
    }      
    // vertical
    union{ 
        cylinder{<-0.2, 0.16, -0.8>, <0.2, 1.3, -0.03>, 0.002} 
        cylinder{<-0.15, 0.16, -0.8>, <0.2 + (0.1/7)*1, 1.3, -0.03>, 0.002} 
        cylinder{<-0.1, 0.16, -0.8>, <0.2 + (0.1/7)*2, 1.3, -0.03>, 0.002}
        cylinder{<-0.05, 0.16, -0.8>, <0.2 + (0.1/7)*3, 1.3, -0.03>, 0.002}
        cylinder{<0, 0.16, -0.8>, <0.2 + (0.1/7)*4, 1.3, -0.03>, 0.002}
        cylinder{<0.05, 0.16, -0.8>, <0.2 + (0.1/7)*5, 1.3, -0.03>, 0.002}
        cylinder{<0.1, 0.16, -0.8>, <0.2 + (0.1/7)*6, 1.3, -0.03>, 0.002}
        #local num= 55;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    // horizontal
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<-0.2, incr*cnt, 0>, <0.2 + (0.15/7)*6, incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate x*degrees(asin(0.77/sqrt(0.77*0.77 + 1.14*1.14)))
	            translate<0, 0.16, -0.8>  
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.4/sqrt(0.4*0.4 + 1.14*1.14))) translate <-0.2, 0.16, 0>}  
	        plane{-x, 0 rotate -z*degrees(asin((0.1 + (0.1/7)*6)/sqrt(((0.1 + (0.1/7)*6)*(0.1 + (0.1/7)*6)) + 1.14*1.14))) 
	            translate <0.1, 0.16, 0>
	        }        
	    }
	}
    
    // main left shrouds
    // vertical
    union{ 
        cylinder{<-0.2, 0.16, 0.8>, <0.2, 1.3, 0.03>, 0.002} 
        cylinder{<-0.15, 0.16, 0.8>, <0.2 + (0.1/7)*1, 1.3, 0.03>, 0.002} 
        cylinder{<-0.1, 0.16, 0.8>, <0.2 + (0.1/7)*2, 1.3, 0.03>, 0.002}
        cylinder{<-0.05, 0.16, 0.8>, <0.2 + (0.1/7)*3, 1.3, 0.03>, 0.002}
        cylinder{<0, 0.16, 0.8>, <0.2 + (0.1/7)*4, 1.3, 0.03>, 0.002}
        cylinder{<0.05, 0.16, 0.8>, <0.2 + (0.1/7)*5, 1.3, 0.03>, 0.002}
        cylinder{<0.1, 0.16, 0.8>, <0.2 + (0.1/7)*6, 1.3, 0.03>, 0.002}
        #local num= 55;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    // horizontal
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<-0.2, incr*cnt, 0>, <0.2 + (0.15/7)*6, incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate -x*degrees(asin(0.77/sqrt(0.77*0.77 + 1.14*1.14)))
	            translate<0, 0.16, 0.8>  
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.4/sqrt(0.4*0.4 + 1.14*1.14))) translate <-0.2, 0.16, 0>}  
	        plane{-x, 0 rotate -z*degrees(asin((0.1 + (0.1/7)*6)/sqrt(((0.1 + (0.1/7)*6)*(0.1 + (0.1/7)*6)) + 1.14*1.14))) 
	            translate <0.1, 0.16, 0>
	        }        
	    }
	}
	    
    // 2nd level
	// right
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.7*0.7)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158)/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 0.7*0.7)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 0.7*0.7)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 22;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.7*0.7)))}  
	    }
        
        translate<0.1, 1.35, -0.158>
    }    
    
    // left
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.7*0.7)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158)/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 0.7*0.7)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 0.7*0.7)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.7*0.7 + (0.158*0.158)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 22;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate -x*degrees(asin(0.158/(sqrt(pow(0.158, 2) + 0.7*0.7))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.7*0.7)))}  
	    }
        
        translate<0.1, 1.35, 0.158>
    }                                                
    
    // separate
    
    cylinder{<0, 0, -0.4>, <0.2, 1.3, -0.03>, 0.002} 
    cylinder{<0, 0, -0.5>, <0.2, 1.3, -0.03>, 0.002} 
    
    cylinder{<-0.5, 0, 0.1>, <0.3, 2.8, 0>, 0.002}
    cylinder{<-0.3, 0, -0.6>, <0.3, 2.8, 0>, 0.002} 
    cylinder{<-0.3, 0, 0.6>, <0.3, 2.8, 0>, 0.002}  
    
    cylinder{<-0.45, 0, 0>, <0.17, 1.3, 0>, 0.002}
    cylinder{<-0.35, 0, 0>, <0.17, 1.3, 0>, 0.002}
    
    // 2nd level
    cylinder{<0.1, 1.37, -0.014>, <0.25, 2, 0.02>, 0.002} 
    cylinder{<0.1, 1.37, 0.014>, <0.25, 2, -0.02>, 0.002} 
    
    cylinder{<0.1, 1.37, -0.14>, <0.3, 2.8, 0>, 0.002} 
    cylinder{<0.1, 1.37, 0.14>, <0.3, 2.8, 0>, 0.002}

    // fore

    // fore right shrouds
    // ends 
    difference{     
        union{
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2, 1.1, -0.03>} 
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*1, 1.1, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*2, 1.1, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*3, 1.1, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*4, 1.1, -0.03>}  
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*5, 1.1, -0.03>}
            sphere{0, 0.014 scale<0.2, 1, 0.4> translate <0.2 + (0.1/7)*6, 1.1, -0.03>}
        }
        plane{y, 1.1} 
        translate x*1.1 
        
        texture{BlockTxt}
    }      
    // vertical
    union{ 
        cylinder{<-0.2, 0, -0.6>, <0.2, 1.1, -0.03>, 0.002} 
        cylinder{<-0.15, 0, -0.6>, <0.2 + (0.1/7)*1, 1.1, -0.03>, 0.002} 
        cylinder{<-0.1, 0, -0.6>, <0.2 + (0.1/7)*2, 1.1, -0.03>, 0.002}
        cylinder{<-0.05, 0, -0.6>, <0.2 + (0.1/7)*3, 1.1, -0.03>, 0.002}
        cylinder{<0, 0, -0.6>, <0.2 + (0.1/7)*4, 1.1, -0.03>, 0.002}
        cylinder{<0.05, 0, -0.6>, <0.2 + (0.1/7)*5, 1.1, -0.03>, 0.002}
        cylinder{<0.1, 0, -0.6>, <0.2 + (0.1/7)*6, 1.1, -0.03>, 0.002}
        #local num= 55;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    // horizontal
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<-0.2, incr*cnt, 0>, <0.2 + (0.15/7)*6, incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate x*degrees(asin(0.57/sqrt(0.57*0.57 + 1.1*1.1)))
	            translate<0, 0, -0.6>  
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.4/sqrt(0.4*0.4 + 1.1*1.1))) translate <-0.2, 0, 0>}  
	        plane{-x, 0 rotate -z*degrees(asin((0.1 + (0.1/7)*6)/sqrt(((0.1 + (0.1/7)*6)*(0.1 + (0.1/7)*6)) + 1.1*1.1))) 
	            translate <0.1, 0, 0>
	        }        
	    }
	    translate x*1.1
	}
    
    // fore left shrouds
	// vertical
    union{ 
        cylinder{<-0.2, 0, 0.6>, <0.2, 1.1, 0.03>, 0.002} 
        cylinder{<-0.15, 0, 0.6>, <0.2 + (0.1/7)*1, 1.1, 0.03>, 0.002} 
        cylinder{<-0.1, 0, 0.6>, <0.2 + (0.1/7)*2, 1.1, 0.03>, 0.002}
        cylinder{<-0.05, 0, 0.6>, <0.2 + (0.1/7)*3, 1.1, 0.03>, 0.002}
        cylinder{<0, 0, 0.6>, <0.2 + (0.1/7)*4, 1.1, 0.03>, 0.002}
        cylinder{<0.05, 0, 0.6>, <0.2 + (0.1/7)*5, 1.1, 0.03>, 0.002}
        cylinder{<0.1, 0, 0.6>, <0.2 + (0.1/7)*6, 1.1, 0.03>, 0.002}
        #local num= 55;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    // horizontal
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<-0.2, incr*cnt, 0>, <0.2 + (0.15/7)*6, incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate -x*degrees(asin(0.57/sqrt(0.57*0.57 + 1.1*1.1)))
	            translate<0, 0, 0.6>  
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.4/sqrt(0.4*0.4 + 1.1*1.1))) translate <-0.2, 0, 0>}  
	        plane{-x, 0 rotate -z*degrees(asin((0.1 + (0.1/7)*6)/sqrt(((0.1 + (0.1/7)*6)*(0.1 + (0.1/7)*6)) + 1.1*1.1))) 
	            translate <0.1, 0, 0>
	        }        
	    }
	    translate x*1.1
	} 
	    
    // 2nd level
	// right
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.8*0.8)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 0.8*0.8)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 0.8*0.8)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 22;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.8*0.8)))}  
	    }
        
        translate<1.2, 1.15, -0.158*0.8>
    }    
    
    // left
    union{
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.15*0.15 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.8*0.8)))
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.1*0.1 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin((0.158*0.8)/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.1/sqrt(0.1*0.1 + 0.8*0.8)))
            translate x*0.05
        } 
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.05*0.05 + 0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0.05/sqrt(0.05*0.05 + 0.8*0.8)))
            translate x*0.1
        }
        union{
            object{Block translate <0, 0.05, 0>} 
            cylinder{<0, 0.05, 0>, <0, sqrt(0.8*0.8 + (0.158*0.8*0.158*0.8)) - 0.05, 0>, 0.002}
            rotate -x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
            rotate -z*degrees(asin(0))
            translate x*0.15
        }
        // horizontal       
        #local num= 22;  
	    #local incr = 0.025;  
	    #local cnt = 0;
	    difference{ 
	        union{
	            #while (cnt < num)
                    cylinder{<0, 0.05 + incr*cnt, 0>, <0.15, 0.05 + incr*cnt, 0>, 0.001} 
		            #local cnt = cnt + 1;
	            #end                
	            rotate -x*degrees(asin(0.158*0.8/(sqrt(pow(0.158*0.8, 2) + 0.8*0.8))))
	        }
	        plane{x, 0 rotate -z*degrees(asin(0.15/sqrt(0.15*0.15 + 0.8*0.8)))}  
	    }
        
        translate<1.2, 1.15, 0.158*0.8>
    }                                           
    
    // separate
    
    cylinder{<0.5, 0, -0.4>, <1.33, 1.9, 0>, 0.002} 
    cylinder{<0.7, 0, 0.4>, <1.33, 1.9, 0>, 0.002}
    
    cylinder{<0.8, 0, -0.4>, <1.33, 1.1, -0.1>, 0.002} 
    cylinder{<0.8, 0, 0.4>, <1.33, 1.1, 0.1>, 0.002}
    
    cylinder{<0.9, 0, -0.2>, <1.4, 2.5, 0>, 0.002} 
    cylinder{<0.9, 0, 0.2>, <1.4, 2.5, 0>, 0.002}  
    
    cylinder{<1.1, 0, -0.2>, <1.3, 1.1, -0.02>, 0.002} 
    cylinder{<1.1, 0, 0.2>, <1.3, 1.1, 0.02>, 0.002}
    
    cylinder{<1.3, 0, -0.45>, <1.3, 1.15, -0.158*0.8>, 0.002}
    cylinder{<1.3, 0, -0.35>, <1.3, 1.15, -0.158*0.8>, 0.002}
        
    texture{RopeTxt}
}

#declare Body = union{
    // center
    box{<-1.45, -0.85, -0.006>, <0, 0, 0.006> texture{BodyTxt} texture{Shader}} 
    difference{
        cylinder{<0, 0, -0.006>, <0, 0, 0.006>, 0.85 scale <2.4, 1, 1>} 
        cylinder{<0, 0, -0.02>, <0, 0, 0.02>, 0.8 scale <2.4, 1, 1>}
        plane{x, 0}
        plane{-y, -0.15}
        texture{BodyTxt}
        texture{Shader}        
    }    
    // rudder
    difference{
        box{<-0.13, -0.85, -0.006>, <0, 0, 0.006>}
        cylinder{<-0.13, 0, -1>, <-0.13, 0, 1>, 0.1}
        translate <-1.47, 0, 0>
        texture{BodyTxt rotate z*90 translate x*0.019}
        texture{Shader}
        translate <0.01, 0, 0>        
    }                 
    
    // body
    difference{
        sphere{0, 2 scale <1, 0.4, 0.4> texture{BodyTxt} texture{Shader}} 
        
        difference{
            sphere{0, 2 scale <1, 0.395, 0.395>}
            plane{x, 0 translate -x*1.38}
            plane{-y, 0 translate -y*0.1}
            texture{BodyTxt}
        }
        difference{
            sphere{0, 2 scale <1, 0.395, 0.395>}
            plane{x, 0 translate -x*1.16}
            plane{y, -0.099}
            texture{BodyTxt}
        }

        union{
            box{<-0.5, 0.15, -2>, <10, 10, 2>}
            box{<-1, 0.23, -2>, <10, 10, 2>}
            box{<-1.59, 0.4, -2>, <10, 10, 2>} 
            texture{BodyTxt}
        }  

        #declare BodyTxt1 = texture{BodyTxt rotate z*45} texture{Shader}
        #declare BodyTxt2 = texture{BodyTxt rotate -z*45}  texture{Shader}
        
        union{
            box{-4, <-1.5, 0, 4> texture{BodyTxt rotate <90, 90, 0>}} 
            cylinder{<-1.5, -0.1, -4>, <-1.5, -0.1, 4>, 0.1 texture{BodyTxt rotate y*90}}
            box{-4, <-1.4, -0.1, 4>
                texture {
                    gradient x       
                    texture_map {
                        [0.5 BodyTxt1]
                        [0.5 BodyTxt2]
                    }
                    translate -x*0.5
                    scale <1.1, 1, 1>
                    rotate y*90
                }
            }
        }
           
        // back
        plane{x, -1.6 texture{BodyTxt rotate y*90}}  
        
        // back gun holes   
        box{<-4, -0.15, -0.35>, <0, -0.1, -0.3>} 
        box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.15} 
        box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.5}
        box{<-4, -0.15, -0.35>, <0, -0.1, -0.3> translate z*0.65} 
        
        // back side 
        intersection{
            plane{z, 0 texture{BodyTxt} rotate y*30}
            plane{-y, 0 texture{BodyTxt rotate x*90} translate y*0.005}
            plane{y, 0.195 texture{BodyTxt rotate x*90}}
            plane{-x, 0 texture{BodyTxt rotate y*90}}
            plane{x, 0.4 texture{BodyTxt rotate y*90}}
            translate <-1.59, 0, -0.35>
        } 
        intersection{
            plane{z, 0 texture{BodyTxt} rotate y*30}
            plane{-y, 0 texture{BodyTxt rotate x*90} translate y*0.005}
            plane{y, 0.21 texture{BodyTxt rotate x*90}}
            plane{-x, 0 texture{BodyTxt rotate y*90}}
            plane{x, 0.4 texture{BodyTxt rotate y*90}}
            translate <-1.59, 0.2, -0.27>
        }
        
        // right side holes    
        
        // second level 
        union{  
            #local num = 13;
            #local cnt = 0;
	        #while (cnt < num)   
	            box{<-0.025, 0.05, -1>, <0.025, 0.1, 0> translate -y*0.05 translate x*(1.4 - 0.2*cnt)}
    	        #local cnt = cnt + 1;
	        #end 
        }
        
        // third level 
        union{  
            #local num = 13;
            #local cnt = 0;
	        #while (cnt < num)   
	            box{<-0.025, 0.05, -1>, <0.025, 0.1, 0> translate -y*0.05 translate x*(1.4 - 0.2*cnt) translate <-0.1, -0.15, 0>}
    	        #local cnt = cnt + 1;
	        #end 
        }
              
        // balconies
        intersection{
            plane{x, -1.5 texture{BodyTxt rotate y*90}}
            plane{z, 0.4 texture{BodyTxt}}
            plane{-z, 0 texture{BodyTxt} translate -z*0.4}
            plane{y, 0.1901 texture{BodyTxt rotate x*90}}
            plane{-y, 0 texture{BodyTxt rotate x*90} translate y*0.01}
        }
        intersection{
            plane{x, -1.5 texture{BodyTxt rotate y*90}}
            plane{z, 0.2 texture{BodyTxt}}
            plane{-z, 0 texture{BodyTxt} translate -z*0.2}
            plane{y, 0.3901 texture{BodyTxt rotate x*90}}
            plane{-y, 0 texture{BodyTxt rotate x*90} translate y*0.2}
        }
        
        union{
            // windows
            box{<-4, 0.1, -0.3999>, <-1.2, 0.19, 0.3999>} 
            box{<-4, 0.3, -0.1999>, <-1.2, 0.39, 0.1999>} 
        
            // doors
            box{<-4, 0.0101, -0.1>, <-1.2, 0.19, 0.1>} 
            box{<-4, 0.2001, -0.1>, <-1.2, 0.39, 0.1>}
            texture{BodyTxt}
        }
    }
                   
    #if(ShowBondage)
        object{Bondage}
    #end
        
    #if(ShowSideBalcony)
        object{SideBalconies}  
    #end 
    
    #if(ShowSideWindows)
        object{SideWindows}
    #end                      
    
    #if(ShowBackWindowsDoors)
        object{BackWindowsDoors}
    #end          
    
    #if(ShowBackBalcony)
        object{BackBalcony}
    #end
	
	#if(ShowPortDoors)
	    object{PortDoors}
	#end
    
    #if(ShowGuns)
        object{Guns}
    #end                        
    
    #if(ShowBuild1)
        object{Build1}
    #end 
    
    #if(ShowStairway)
        object{Stairway}
    #end 
    
    #if(ShowGrid)
        object{Grid}
    #end 
    
    #if(ShowLadder)  
        #include "ladder.inc"
        object{Ladder scale 0.1 rotate y*20 translate <-1.56, 0.03, -0.5>}
    #end
    
    #if(ShowFlag)  
        #include "flag.inc"
        object{Flag scale 0.12 rotate y*10 translate <-1.6, 0.58, 0>}
    #end                
    
    #if(ShowLights)
        object{Lights}
    #end
    
    #if(ShowOrnament)
        object{Ornament}
    #end 
    
    #if(ShowMasts)
        object{Fore}
        object{Main}
        object{Mizzen}
    #end
} 


