#version unofficial MegaPov 0.7; 

camera{
    location <0, 1.5, -3>
    right x*image_width/image_height
    up y
    look_at <0, 4, 10>                      
}

light_source{
    <50, 100, -50> 
    rgb <0.7, 0.7, 0.8> 
} 

#declare ShowSea = 1;
#declare ShowSky = 1;
#declare ShowDraftSky = 0;
#declare ShowShip = 1;

#if(ShowSea)
	#declare f = function{"ridgedmf" <1, 2, 5, 1, 1>} 
	#declare sea = function{y - 5 * f(0.2 * x, 0.2 * y, 0.2 * z) / 10 - f(x, y, z)/10 - f((x - 0.15)/0.2, 
		(y - 0.15)/0.2, (z - 0.15)/0.2)/100}
 
	isosurface{
    	function{sea(x, y, z)}
    	contained_by{box <-300, -1, -6> <300, 3, 500>}
    	accuracy .005  max_gradient 1.55  threshold 0
    	texture {
    		pigment{rgb <0.16, 0.16, 0.2>}
    		finish{ambient 0.1 diffuse 0.7 phong 0.25 specular 0.4 reflection 0.2}
		}
    	translate -y*1
    	scale <1, 0.8, 0.8>
    	translate y*0.5
	}
	
	glow {size 0.03 type 0 color rgb<1, 1, 1.1>/2.1 translate<33, 2, 100>}
	glow {size 0.06 type 0 color rgb<1.1, 1.1, 1>/2.2 translate<38, 2, 100>} 
	glow {size 0.03 type 0 color rgb<1, 1, 1.1>/2 translate<40, 2, 100>}
	glow {size 0.05 type 0 color rgb<1, 1, 1>/2.1 translate<43, 2, 100>}
	glow {size 0.06 type 0 color rgb<1.1, 1, 1>/2.1 translate<48, 2, 100>} 
	glow {size 0.04 type 0 color rgb<1, 1, 1.1>/2.2 translate<50, 2, 100>} 
	glow {size 0.03 type 0 color rgb<1, 1, 1.1>/2 translate<53, 2, 100>} 
	glow {size 0.05 type 0 color rgb<1.1, 1.1, 1>/2.1 translate<56, 2, 100>} 
	glow {size 0.03 type 0 color rgb<1, 1, 1>/2 translate<60, 2, 100>}
#end 

#if(ShowSky)
	global_settings{
    	max_trace_level 100
	}                                         
	fog {
    	distance 300
    	color rgbf 0
    	fog_type 2
    	fog_offset 1
    	fog_alt 10
    	turbulence 0.6
    	turb_depth 0.2
	}
    #declare Height = 3000; 
    #if(ShowDraftSky)
        #declare Layers = 10;
        #declare Shift = 35;
    #else
        #declare Layers = 70;
        #declare Shift = 5;
    #end      
    #declare Count = 1;      
    #declare baseColor = color rgb <0, 0, 0.04>;
    #declare topColor = color rgb <1, 1.03, 1.05>;

    #declare Clouds = union {
        #while (Count <= Layers)  
            #declare currColor = baseColor + topColor * (Count/Layers);
            plane{-y, 0  
                texture{
                    pigment{
	                    spotted    
    	                warp{ turbulence 4 omega 0.5 lambda 3}
    	                turbulence 0.3
                        color_map{        
                            [0.0 color rgbf 1]
                            [0.5 color rgbf 1]       
                            [1.0 currColor filter 0.7 * (Count/Layers)] 
                        } 
   	                    scale <3.5, 1, 2>
   	                    scale 2000
                    }
                    finish{ambient ambient 0.1 * Count/Layers diffuse 1 + (2 * Count/Layers)} 
            
                  	translate <0, Shift * Count, -Shift * Count>
                }
                translate <0, Shift * Count, -Shift * Count> 
                
		        hollow
            }
            #declare Count = Count + 1;
        #end
    }
    sky_sphere{pigment{color rgb<0, 0, 0.05>}}                 
    object{Clouds rotate x*8 translate y*Height}
#end                  

#if(ShowShip)
    #include "ship.inc"
    object{
        Ship 
        scale 4
        rotate <8, -65, 0>
        translate <0, 0, 10>
    }
#end 




 

