#declare BodyTxt = texture{             
    pigment{
        image_map {
            png "t1.png" 
            map_type 0	
    		interpolate 2	
		}
		scale <1.2, 1/4.9, 1>
		scale 0.5
    } 
             
    finish{ambient 0.14 diffuse 0.8 phong 0.1}
}

#declare DarkColor = color rgbf <0.2, 0.2, 0.25, 0.62>;

#declare Shader = texture{
    pigment{
        gradient y
        color_map{
            [0 0.15 color DarkColor color DarkColor]
            [0.15 0.25 color DarkColor color rgbf 1]
            [0.25 color rgbf 1]
        }                   
        turbulence 0.04
        scale<0.1, 1.5, 1>
        translate -y*0.5
    }                 
    finish{ambient 0.17 diffuse 0.85 phong 0.1}
}

#declare C1 = color rgb<211/256, 202/256, 172/256>*0.85;
#declare C2 = C1*0.7; 

#declare MetalTxt = texture{             
    pigment{
        granite
        color_map {
            [0 0.2 color C1 color C1] 
            [0.2 0.6 color C1 color C2]
            [0.6 1 color C2 color C2]
        }                                                                                                          
        turbulence 0.3
        scale 0.05
    } 
             
    finish{ambient 0.1 phong 0.5}
}

#declare G1 = color rgb<202/256, 211/256, 172/256>*0.8;
#declare G2 = G1*0.8;  

#declare GunTxt = texture{             
    pigment{
        granite
        color_map {
            [0 0.2 color G1 color G1] 
            [0.2 0.6 color G1 color G2]
            [0.6 1 color G2 color G2]
        }                                                                                                          
        turbulence 0.3
        scale 0.02
    } 
             
    finish{ambient 0.14 diffuse 0.6 phong 0.8}
}

#declare PaintLightTxt = texture{
    pigment {color rgb<0.95, 0.9, 0.7>}
    finish{ambient 0.16 diffuse 0.8 phong 0.11}
    normal{bumps bump_size 0.4 scale<0.03, 0.2, 0.03> scale 0.01}
}

#declare PaintDarkTxt = texture{
    pigment{color rgb<0.68, 0.54, 0.5>}
    finish{ambient 0.1 diffuse 0.8 phong 0.2}
    normal{bumps bump_size 0.22 scale 0.0002}
} 


#declare S1 = color rgb<1.7, 1.65, 1.6>;
#declare S2 = S1*0.91;

#declare SailTxt = texture{             
    pigment{
        bozo
        color_map {
            [0 0.2 color S1 color S1] 
            [0.2 0.6 color S1 color S2]
            [0.6 1 color S2 color S2]
        }                                                                                                          
        turbulence 0.22
        scale <1, 2.3, 1>
        scale 0.055
    } 
             
    finish{ambient 0 diffuse 0.6 phong 0}
}

#declare BlockTxt = texture{
    pigment{color rgb<0.8, 0.5, 0.3>}
    finish{ambient 0.1 diffuse 0.8 phong 0.4}
} 

#declare RopeTxt = texture{
    pigment{color rgb<1.1, 1, 0.85>}
    finish{ambient 0.18 diffuse 0.5 phong 0}
} 

#include "colors.inc"
#include "woods.inc"
#declare MastTxt = texture{
    T_Wood10 scale 0.08 rotate x*90 scale<1, 1.25, 1> 
    normal{bumps bump_size 0.45 scale<0.03, 0.2, 0.03> scale 0.03 scale<1, 5, 1>}
}

#declare WindowsTxt = texture{             
    pigment{
        image_map {
            png "windows.png" 
            map_type 0	
    		interpolate 2	
		} 
		translate -x*0.5
		scale <1, 0.25, 1>
		scale 0.8
    } 
             
    finish{ambient 1 diffuse 0.5 phong 0.2}
}

#declare BalconyWindowsTxt = texture{             
    pigment{
        image_map {
            png "windows1.png" 
            map_type 2	
    		interpolate 2	
		} 
		scale <1, 0.25, 1>
		scale 0.8
    } 
             
    finish{ambient 0.9 diffuse 0.6 phong 0.2}
}





