// Persistence of Vision Ray Tracer Scene Description File
// File: IceCastle.pov
// Vers: unofficial megapov 0.7
// Desc: A castle of ice set amidst the tundra 
// Date: 26 March 2001 
// Auth: Gail Shaw

#version unofficial megapov 0.6;

#declare ShowTerrain=1;
#declare ShowCastle=1;
#declare ShowAurora=1; 
#declare ShowBanner=1;           
#declare ShowPerson=1;
#declare SlowTexture=1;
#declare Radiosity=0;

#include "macros.inc"
#include "IceCastle.inc"
#include "wanderer.inc"
#include "snowBlob.inc"

//background {LightSkyBlue}
  
#if (Radiosity=1)  
 global_settings { 
  ambient_light rgb 0.5
 //assumed_gamma 1.5
  max_trace_level 20
  radiosity{
   pretrace_start 0.08
   pretrace_end   0.04
   count 80             
   nearest_count 5      
   error_bound 2        
   recursion_limit 2    
   low_error_factor .5  
   gray_threshold 0.0   
   minimum_reuse 0.015  
   brightness 1.25         
   adc_bailout 0.01/0.5 
  }
 } 
#else
 global_settings {
  ambient_light rgb 0.5 
  max_trace_level 20             
 }
#end
      
#declare DistanceCamera=      
 camera {   
  up y*image_height
  right x*image_width
  location <-40,-15,-350>
  look_at <25,20,0>   
  angle 40
 }

#declare AboveCamera=
 camera {
  location <0,100,-10>
  look_at <0,0,0>
 }

#declare CloseCamera=
 camera {          
  location <-10,52,-57>
  look_at <0,51,0>
 }

#declare TowerCamera=
 camera {
  location <-5,17,-50>
  look_at <-5,13,-30>
 }

camera {
 DistanceCamera
}               

light_source {
 <-400,500,-600>
 White*0.25
}

sphere {
 <-400,300,-600>,50
 pigment {rgb 1}
 finish {ambient 1}
 no_shadow
}

#if (ShowCastle=1) 
 object {Castle scale 1.2 translate y*14.5}
 light_source {
  <2.95,40,-0.5>*1.2 + y*14.5
  rgb <0.5,0.5,0>*0.6
  fade_distance 10
  fade_power 2
  glow { 
   type 1 
	 size 0.5
	 color<0.5,0.5,0>*0.2
  }
 }   
 object {Bridge translate <0,-47.5,-15>}   
  
#end

#if (ShowTerrain=1)
 height_field {
  tga "plateau2.tga" 
  smooth       
  //double_illuminate
  //water_level 0.15
  translate <-0.5,-0.75,-0.5>
  rotate y*175
  scale <25,10.6,25>*6          
  //pigment {White}
  //texture {T_Mountain scale 0.5}
  texture{
   slope -y
   texture_map{   
    [0.23 T_Snow2 ] //flatter 
    [0.24 T_Mountain ]  //steeper
   }
  }
 }     
 /*
 height_field {
  tga "Mountain1a.tga"
  //tga "Mountain5.tga"
  smooth      
  //double_illuminate
  texture{
   slope -y
   turbulence 0.1
   texture_map{   
    [0.42 T_Snow2 ] //flatter 
    [0.42 T_Mountain ]  //steeper
   }
   //T_Mountain
  }
  scale <27,30,27>*6
  translate <120,-35,100>
 }
 
 height_field {
  tga "Mountain2a.tga"
  smooth                
  //double_illuminate
  rotate y*120
  texture{
   slope -y
   turbulence 0.1
   texture_map{   
    [0.42 T_Snow2 ] //flatter 
    [0.42 T_Mountain ]  //steeper
   }
  }
  scale <27,25,27>*6
  translate <120,-35,350>
 }
 
 height_field {
  tga "Mountain2a.tga"
  smooth                
  //double_illuminate
  texture{
   slope -y 
   turbulence 0.1
   texture_map{   
    [0.42 T_Snow2 ] //flatter 
    [0.42 T_Mountain ]  //steeper
   }
  }
  scale <27,25,27>*6
  translate <-170,-37,150>
 } */
 
 height_field {
  tga "Mountain7.tga"
  smooth   
  scale <120,30,-100>*6
  translate <140,-50,400>
  texture{
   slope -y 
   turbulence 0.25
   texture_map{   
    [0.42 T_Snow2 ] //flatter 
    [0.42 T_Mountain ]  //steeper
   }
  } 
 }
 
 height_field {
  tga "Mountain2a.tga"
  scale 50
  translate <25,-40,-100>
  texture{
   slope -y 
   turbulence 0.25
   texture_map{   
    [0.42 T_Snow2 ] //flatter 
    [0.42 T_Mountain ]  //steeper
   }
  }
 } 
 
 height_field {
  tga "Mountain2a.tga"
  scale <50,40,50>
  rotate y*90
  translate <75,-40,-100>
  texture{
   slope -y 
   turbulence 0.25
   texture_map{   
    [0.41 T_Snow2 ] //flatter 
    [0.41 T_Mountain ]  //steeper
   }
  }
 }
 
 //difference { 
  /*isosurface {
   function {y-sin(z/3)*2-sin(x)*0.074-sin(x*2+pi/7)*0.045-sin(x/2.5-pi/3)*0.03-noise3d(x*2,y*2,z*2)*0.15}
   threshold 0       
   
   method 2
   //eval                              
   max_gradient 1.2
   all_intersections
   contained_by {box {<-80,-10,-7.5>,<40,10,7.5>}}*/
  //}
  /*height_field {
   png "footstep.png"
   translate <-0.5,0,-0.5> 
   rotate y*20
   scale <1,-0.5,1>*2
   translate <-57,1.3,1>
   //pigment {Red}
  }
  height_field {
   png "footstep.png"
   translate <-0.5,0,-0.5> 
   rotate y*20
   scale <1,-0.5,1>*2
   translate <-56,1.3,3>
   //pigment {Red}
  }*/
  /*sphere {
   <0,0,0>,0.2
   scale <1,10,3>
   rotate y*20
   translate <-58,0.5,1>
   pigment {Red}
  }*/
  //translate <0,-18,-330>
  //pigment {White}
  //texture {T_Snow}
 //}
 
 height_field {
  tga "hill2.tga"      
  smooth 
  //double_illuminate
  translate <-0.5,0,-0.5>
  scale <40,2.25,15>
  translate <-27.5,-17,-330.5>
  //pigment {White}
  //finish {ambient 0.8}
  texture {T_Snow2}    
 }                     
  
 height_field {
  tga "Mountain1a.tga"    
  smooth
  translate <-0.5,0,-0.5>
  scale <15,8,16>
  translate <-45,-16.75,-327>
  texture {
   T_Snow2 
  }
 }
  
#end      

#if (ShowBanner=1)
 object {
  Banner
  scale 0.9            
  translate <-40.5,-13.25,-334>
  pigment {Brown}
 }      
 
 #declare SnowCovered=object {Banner}
        
 blob {
  threshold 0.5
  snow_blobs(-1.1,1.1,-0.085,0.085,0.005,0.5,0.05)
  texture{
   T_Snow2
  }
  scale 0.9            
  translate <-40.5,-13.25,-334>
 }        
        
 object {
  Flag 
  pigment {image_map {png "RuneCircle.png"}} 
  finish {ambient 0.3 diffuse 0.8}
  scale 0.9
  translate <-40.5,-13.25,-334> 
 }
#end

#if (ShowPerson=1)
 union {
  object {
   Wanderer
  }                 
  object {
   Robe
  }
  scale <-1,1,1>*8
  rotate y*2
  translate <-26,-17.5,-318>
 }          
 
 object {
  Staff    
  scale <1.5,2,1.5>
  translate <-27.6,-15.5,-317> 
 }
 
#end

#if (ShowAurora=1)
 object {
  Aurora1
  scale <2,1.5,1.5>*2    
  rotate z*20
  rotate y*-15  
  translate <-25,120,200>
 } 
 object {
  Aurora1
  scale <2,1.5,1.5>*2    
  rotate z*20
  rotate y*-5  
  translate <70,145,280>
 }     
 
 union {  
  Stars (1,4000,2000)
 }
#end
 
   