#macro snow_blobs(XStart,XEnd,ZStart,ZEnd,Inc,Threshold,R_Val)
  #declare high_x = 0;
  #declare low_x = 100;
  #declare high_z = 0;
  #declare low_z = 100;

  //#declare R_Val = 0.1;
  #declare S_Val = 1.0;
  #declare R1 = seed(123);
  #declare R2 = seed(456);
  #declare R3 = seed(789);
  #declare R4 = seed(987);
  #declare R5 = seed(654);
  #declare x_count = XStart;
  #while (x_count < XEnd)
    #declare z_count = ZStart;
    #while (z_count < ZEnd)
      #declare norm_reg = <0,0,0>;
      #declare trace_result =
        trace(SnowCovered, <x_count, 10, z_count>, <x_count, -10, z_count>, norm_reg);
      #if ((trace_result.y/5) + norm_reg.y > Threshold)  
        sphere {
          <0,0,0>, R_Val, S_Val
          scale <0.5+(rand(R1)/2),0.5+(rand(R2)/2),0.5+(rand(R3)/2)>
          translate trace_result
        }
        #if (x_count < low_x) #declare low_x = x_count; #end
        #if (z_count < low_z) #declare low_z = z_count; #end
        #if (x_count > high_x) #declare high_x = x_count; #end
        #if (z_count > high_z) #declare high_z = z_count; #end
      #end
      #declare z_count = z_count + Inc + (rand(R4)*Inc/2);
      //#debug concat("z count: ", str(z_count, 2,3), "\n")
    #end
    #declare x_count = x_count + Inc + (rand(R5)*Inc/2);
    //#debug concat("x count: ", str(x_count, 2,3), "\n")
  #end
  //#debug concat ("high x: ", str(high_x, 2,3), "\n", "high z: ", str(high_z,2,3), "\n", "low x: ", str(low_x, 2,3), "\n", "low z: ", str(low_z, 2,3),"\n")
#end
/*
#declare SnowCovered=
 union {
  cylinder {
   <0,-4,0.2>,<0,0.5,0.2>,0.075
  }
  cylinder {
   <-1.1,0.075,0>,<1.1,0.075,0>,0.075
  }
  rotate z*-10        
 } 


blob
{
  threshold 0.5
  snow_blobs(-1.1,1.1,-0.085,0.085,0.005,0.5,0.05)
  texture{
    pigment{rgb<0.9,0.9,1.1>}
    finish{ambient 0.10 diffuse 0.85}
  }
}

object {SnowCovered pigment {rgb <0.6470, 0.1640, 0.1640>}}

camera {
 location <0,3,-5>
 look_at <0,-2,0>
}

light_source {
 <0,10,-10>
 rgb 1
} 
    
*/