#version unofficial MegaPov 0.7; 

// *** box shape points ***
#declare a_points=array[8]
#declare a_points[0]=<-1,-1,-1>;
#declare a_points[1]=< 1,-1,-1>;
#declare a_points[2]=< 1, 1,-1>;
#declare a_points[3]=<-1, 1,-1>;
#declare a_points[4]=<-1,-1, 1>;
#declare a_points[5]=< 1,-1, 1>;
#declare a_points[6]=< 1, 1, 1>;
#declare a_points[7]=<-1, 1, 1>;

// *** box shape triangles (vector elem. refers to point in a_points[]) ***
#declare a_triang=array[12]
#declare a_triang[0]=<1,3,0>;
#declare a_triang[1]=<1,3,2>;
#declare a_triang[2]=<1,6,5>;
#declare a_triang[3]=<1,6,2>;
#declare a_triang[4]=<5,7,6>;
#declare a_triang[5]=<5,7,4>;
#declare a_triang[6]=<0,7,3>;
#declare a_triang[7]=<0,7,4>;
#declare a_triang[8]=<3,6,7>;
#declare a_triang[9]=<3,6,2>;
#declare a_triang[10]=<0,5,4>;
#declare a_triang[11]=<0,5,1>;

// *** randomize and subdivide the "seed" shape ***
// *** for the small stones ***
Subdivide_Array(a_points,a_triang,r_stone)
Randomize_Array(a_points,.4,r_stone)
Subdivide_Array(a_points,a_triang,r_stone)
#declare small_stone=Build_Stone(a_points,r_stone)
// *** and for the big ones ***
Randomize_Array(a_points,.3,r_stone)
Subdivide_Array(a_points,a_triang,r_stone)
Randomize_Array(a_points,.2,r_stone)
#declare big_stone=Build_Stone(a_points,r_stone)

// *** create the stones union ***
// --- first the big ones ---
#declare num_stn=16;
#declare area_v=<20,0,30>;
#declare cnt=1;
#declare u_big_stones=
union{
#while (cnt<=num_stn)
 object{
  big_stone
  rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
  scale <.5+rand(r_stone)*.5,.5+rand(r_stone)*.5,.5+rand(r_stone)*.5>
  texture{t_stone}
  texture{t_wet translate -.9*y}
  translate
   <-area_v.x*.5+area_v.x*rand(r_stone),
    -1,
    -area_v.z*.5+area_v.z*rand(r_stone)>
 }
 #declare cnt=cnt+1;
#end
}
// --- and the small ---
#declare num_stn=1200;
#declare area_v=<25,0,40>;
#declare cnt=1;
#declare u_small_stones=
union{
#while (cnt<=num_stn)
 object{
  small_stone
  rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
  scale <.25+rand(r_stone),.25+rand(r_stone),.25+rand(r_stone)>
  scale .4
  texture{t_stone}
  texture{t_wet translate -.2*y}
  translate
   <-area_v.x*.5+area_v.x*rand(r_stone),
    -1.7,
    -area_v.z*.5+area_v.z*rand(r_stone)>
 }
 #declare cnt=cnt+1;
#end
}
