#version unofficial MegaPov 0.7;    

global_settings{
    max_trace_level 10 
    assumed_gamma 1  
    ini_option "+QR"     
    radiosity{
        count 80  
        error_bound 0.5 
        pretrace_start 0.08
        pretrace_end 0.01 
        recursion_limit 2
        gray_threshold 0
        nearest_count 8
        brightness 1.15
        normal on
    }   
}


#include "colors.inc"
#include "textures.inc"
#include "stones.inc" 



background { color <0.651685, 0.523315, 0.22084>*0.5 }  



 
fog {
  fog_type 1   
  distance    72
  color <0.205,0.165,0.11,-0.02,-0.8>
  turbulence   <0.0,0.5,0.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 20.0
}


fog {
  fog_type 2  
  distance     54
  color rgbft <0.35,0.4,0.15,0,-0.875>
  turbulence   <0.5,0.5,0.5>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 4.0
  up           <0,1,0>
  fog_offset   50
  fog_alt      -16
  rotate <0,0,10>
}


fog {
  fog_type 2  
  distance     30
  color <0.0175,0.007,0.0035,0,0.05>
  turbulence   <0,3,0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 2.0
  up           <0,1,0>
  fog_offset   -4
  fog_alt      2
  rotate <0,0,2>
}



#declare backgroundtex = 
   material 
   {   
      texture
      {      
         pigment
         {
            granite
            color_map
            {
               [ 0.0     rgbft <0.013, 0.023, 0.016, 0, 0> ]
               [ 0.256   rgbft <0.263, 0.225, 0.164, 0, 0> ]
               [ 0.473   rgbft <0.058, 0.059, 0.025, 0, 0> ]
               [ 0.722   rgbft <0.156, 0.135, 0.101, 0, 0> ]
               [ 1.0     rgbft <0.291, 0.258, 0.164, 0, 0> ]
            }
            turbulence 0.5
            ramp_wave
         }      
         finish
         {
            ambient 0.544
            diffuse 0
            brilliance 0.15
         }      
         scale  <0.05, 1.2, 0.5>
         translate 0.0 * y
      }
   }
   
   
cylinder { 
  <0,1,0>, <0,0,0>, 1 open
  material { backgroundtex }
  hollow
  scale <1500,335,180>
  rotate <-10,0,10>
  translate  <1490,0,150>
}



#declare fels = texture{
        pigment{crackle pigment_map
                   {[0.08 granite scale 0.2 color_map
                           {[0.5 rgb <0.8,0.75,0.68>]
                            [0.8 rgb <0.2,0.18,0.1>]
                           }]
                    [0.08 average pigment_map   
                                {[0.2 granite]
                                 [0.8 crackle  color_map
                                        {[0.0 rgb <1,0.9,0.7>]
                                         [0.7 rgb <0.8,0.7,0.5>]
                                         [0.8 rgb <0.8,0.75,0.45>]
                                         [0.9 rgb <0.35,0.3,0.25>]
                                        }]
                                } ] }
                }
        normal {average normal_map {
                        [0.6 crackle 2.4 slope_map
                               {[0.0 <0,0>]
                                [0.08 <0,0>]
                                [0.08 <0,1>]
                                [0.7 <1,0>]
                               }]
                        [0.4 granite 1.8 ]}
               }
        finish { ambient 0 diffuse 0.5 specular 0.15 }           
        rotate <20,20,20> 
        }


          
#include "krebsneu3.inc"
#include "hoehle.inc" 
#include "felsoben2.inc"
#include "steina6.inc"  
#include "Muschel3.inc" 
#include "muschel2.inc" 

object{ muschel scale <0.15,0.3,0.15> rotate <-13,224,85> translate <11.2,9.23,7.3>}

#include "hecht2.inc"
#include "fluss.inc" 
#include "strauch1.inc"
#include "algen2.inc"   

object{ waterplant scale 100 translate <65,26,35>} 

#include "algen6.inc" 

object{ P_aquatic06 scale 0.4 rotate <-76,0,-16>   translate <-7,4,35>}
object{ P_aquatic06 scale 0.4 rotate <-92,59,5>    translate <6,5,48>} 
object{ P_aquatic06 scale 0.4 rotate <-108,119,25> translate <15,6,61>}
object{ P_aquatic06 scale 0.4 rotate <-92,59,5>    translate <-9,14,53>}
object{ P_aquatic06 scale 0.4 rotate <-76,0,-16>   translate <58,59,28>-(<58,59,28>-<-1.1,-1.2,1.8>)*0.35}    

#include "algen8.inc" 

object{ P_aquatic08 scale 0.5 rotate <-72.7,209,13.5> translate <18.7,6,28>} 
object{ P_aquatic08 scale 0.5 rotate <-110,22,-20> translate <18.7,4,25>}    

#include "algen9.inc"   

object{ P_aquatic09 scale 0.8 rotate <-91,-7,-8> translate <20,12,50>} 
object{ P_aquatic09 scale 1.8 rotate <-146,261,-296> translate <65,50,30>}

#include "algen9a.inc" 

object{ P_aquatic09 scale 1.3 rotate <-91,-7,-8> translate <10,33,55>}
object{ P_aquatic09 scale 1.3 rotate <-146,261,-296> translate <-3,22,67>}

#include "algen11.inc"   

object{ P_aquatic11 scale <0.8,1.2,0.8> rotate <90,23,180> translate <15,4,59>}
object{ P_aquatic11 scale 1.5 rotate <90,-23,180> translate <0,4,90>} 





camera { 
location <-1.1,-1.2,1.8>
right 4/3*x
angle 90
look_at <-0.55,-0.95,2.7>
} 




light_source
{
  0*x                     
  color rgb <1,0.96,0.83>
  translate <-24.82,33.245,63.61> 
}



