//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 46 materials and 2296 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/29/2001    (29.04.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     39.950,     -20.001,     999.900>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.20305,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         18.00000    // Vertical      15.000
  look_at   <     39.950,     -20.000,       0.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera01
  location  <     39.650,     -20.000,     989.000> // Attached to Cube771
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35391,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         36.44688    // Vertical      27.335
  look_at   <    151.264,     -92.532,     557.163> // Following Light3
}

*/

/*
camera {  //  Camera StdCam1
  location  <     51.218,    -286.884,     297.315>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <     16.564,      20.000,       0.000>
}

*/

/*
camera {  //  Camera SpotCam001
  location  <     30.000,     -10.000,    1010.000> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33928,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         19.91215    // Vertical      14.934
  look_at   <     30.392,     -10.394,    1009.169> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    7.500  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  rotate <-173.050705, -146.890671, 122.257172>
  translate  <30.0, -10.0, 1010.0>
}

#declare Light3 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.7000
  translate  <105.342625, -283.059935, 255.76057>
}


//
// ********  MATERIALS  *******
//

#include "ww2fort_helper.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

box { // Cube411
  <-1, -1, -1>, <1, 1, 1>
  material {
    black
  }
  scale <1200.0, 1200.0, 0.00001>
}




#declare Group008 = union {
  box { // Cube514
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 150.0*x
    translate  <0.05, -1.818653, 1.05>
  }
  box { // Cube515
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 148.0*x
    translate  <0.05, -1.780901, 1.11283>
  }
  box { // Cube516
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 146.0*x
    translate  <0.05, -1.740979, 1.174305>
  }
  box { // Cube517
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 144.0*x
    translate  <0.05, -1.698936, 1.234349>
  }
  box { // Cube518
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 142.0*x
    translate  <0.05, -1.654823, 1.292889>
  }
  box { // Cube519
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 140.0*x
    translate  <0.05, -1.608693, 1.349854>
  }
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 138.0*x
    translate  <0.05, -1.560604, 1.405174>
  }
  box { // Cube521
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 136.0*x
    translate  <0.05, -1.510614, 1.458783>
  }
  box { // Cube522
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 134.0*x
    translate  <0.05, -1.458783, 1.510614>
  }
  box { // Cube523
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 132.0*x
    translate  <0.05, -1.405174, 1.560604>
  }
  box { // Cube524
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 130.0*x
    translate  <0.05, -1.349854, 1.608693>
  }
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 128.0*x
    translate  <0.05, -1.292889, 1.654823>
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 126.0*x
    translate  <0.05, -1.234349, 1.698936>
  }
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 124.0*x
    translate  <0.05, -1.174305, 1.740979>
  }
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 122.0*x
    translate  <0.05, -1.11283, 1.780901>
  }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 120.0*x
    translate  <0.05, -1.05, 1.818653>
  }
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 118.0*x
    translate  <0.05, -0.98589, 1.85419>
  }
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 116.0*x
    translate  <0.05, -0.920579, 1.887467>
  }
  box { // Cube532
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 114.0*x
    translate  <0.05, -0.854147, 1.918445>
  }
  box { // Cube533
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 112.0*x
    translate  <0.05, -0.786674, 1.947086>
  }
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 110.0*x
    translate  <0.05, -0.718242, 1.973355>
  }
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 108.0*x
    translate  <0.05, -0.648936, 1.997219>
  }
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 106.0*x
    translate  <0.05, -0.578838, 2.01865>
  }
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 104.0*x
    translate  <0.05, -0.508036, 2.037621>
  }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 102.0*x
    translate  <0.05, -0.436615, 2.05411>
  }
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 100.0*x
    translate  <0.05, -0.364661, 2.068096>
  }
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 98.0*x
    translate  <0.05, -0.292264, 2.079563>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 96.0*x
    translate  <0.05, -0.21951, 2.088496>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 94.0*x
    translate  <0.05, -0.146489, 2.094885>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 90.0*x
    translate  <0.05, 0.0, 2.1>
  }
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 86.0*x
    translate  <0.05, 0.146489, 2.094885>
  }
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 84.0*x
    translate  <0.05, 0.21951, 2.088496>
  }
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 82.0*x
    translate  <0.05, 0.292264, 2.079563>
  }
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 80.0*x
    translate  <0.05, 0.364661, 2.068096>
  }
  box { // Cube550
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 78.0*x
    translate  <0.05, 0.436615, 2.05411>
  }
  box { // Cube551
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 76.0*x
    translate  <0.05, 0.508036, 2.037621>
  }
  box { // Cube552
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 74.0*x
    translate  <0.05, 0.578838, 2.01865>
  }
  box { // Cube553
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 72.0*x
    translate  <0.05, 0.648936, 1.997219>
  }
  box { // Cube554
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 70.0*x
    translate  <0.05, 0.718242, 1.973355>
  }
  box { // Cube555
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 68.0*x
    translate  <0.05, 0.786674, 1.947086>
  }
  box { // Cube556
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 66.0*x
    translate  <0.05, 0.854147, 1.918445>
  }
  box { // Cube557
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 64.0*x
    translate  <0.05, 0.920579, 1.887467>
  }
  box { // Cube558
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 62.0*x
    translate  <0.05, 0.98589, 1.85419>
  }
  box { // Cube559
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 60.0*x
    translate  <0.05, 1.05, 1.818653>
  }
  box { // Cube560
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 58.0*x
    translate  <0.05, 1.11283, 1.780901>
  }
  box { // Cube561
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 56.0*x
    translate  <0.05, 1.174305, 1.740979>
  }
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 54.0*x
    translate  <0.05, 1.234349, 1.698936>
  }
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 52.0*x
    translate  <0.05, 1.292889, 1.654823>
  }
  box { // Cube564
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 50.0*x
    translate  <0.05, 1.349854, 1.608693>
  }
  box { // Cube565
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 48.0*x
    translate  <0.05, 1.405174, 1.560604>
  }
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 46.0*x
    translate  <0.05, 1.458783, 1.510614>
  }
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 44.0*x
    translate  <0.05, 1.510614, 1.458783>
  }
  box { // Cube568
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 42.0*x
    translate  <0.05, 1.560604, 1.405174>
  }
  box { // Cube569
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 40.0*x
    translate  <0.05, 1.608693, 1.349854>
  }
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 38.0*x
    translate  <0.05, 1.654823, 1.292889>
  }
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 36.0*x
    translate  <0.05, 1.698936, 1.234349>
  }
  box { // Cube572
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 34.0*x
    translate  <0.05, 1.740979, 1.174305>
  }
  box { // Cube573
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 32.0*x
    translate  <0.05, 1.780901, 1.11283>
  }
  box { // Cube574
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 30.0*x
    translate  <0.05, 1.818653, 1.05>
  }
  material {
    White
  }
  translate  <41.2, -20.0, 988.0>
}
#declare Group009 = union {
  box { // Cube696
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 150.0*x
    translate  <0.05, -1.818653, 1.05>
  }
  box { // Cube697
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 148.0*x
    translate  <0.05, -1.780901, 1.11283>
  }
  box { // Cube698
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 146.0*x
    translate  <0.05, -1.740979, 1.174305>
  }
  box { // Cube699
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 144.0*x
    translate  <0.05, -1.698936, 1.234349>
  }
  box { // Cube700
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 142.0*x
    translate  <0.05, -1.654823, 1.292889>
  }
  box { // Cube701
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 140.0*x
    translate  <0.05, -1.608693, 1.349854>
  }
  box { // Cube702
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 138.0*x
    translate  <0.05, -1.560604, 1.405174>
  }
  box { // Cube703
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 136.0*x
    translate  <0.05, -1.510614, 1.458783>
  }
  box { // Cube704
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 134.0*x
    translate  <0.05, -1.458783, 1.510614>
  }
  box { // Cube705
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 132.0*x
    translate  <0.05, -1.405174, 1.560604>
  }
  box { // Cube706
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 130.0*x
    translate  <0.05, -1.349854, 1.608693>
  }
  box { // Cube707
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 128.0*x
    translate  <0.05, -1.292889, 1.654823>
  }
  box { // Cube708
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 126.0*x
    translate  <0.05, -1.234349, 1.698936>
  }
  box { // Cube709
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 124.0*x
    translate  <0.05, -1.174305, 1.740979>
  }
  box { // Cube710
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 122.0*x
    translate  <0.05, -1.11283, 1.780901>
  }
  box { // Cube711
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 120.0*x
    translate  <0.05, -1.05, 1.818653>
  }
  box { // Cube712
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 118.0*x
    translate  <0.05, -0.98589, 1.85419>
  }
  box { // Cube713
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 116.0*x
    translate  <0.05, -0.920579, 1.887467>
  }
  box { // Cube714
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 114.0*x
    translate  <0.05, -0.854147, 1.918445>
  }
  box { // Cube715
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 112.0*x
    translate  <0.05, -0.786674, 1.947086>
  }
  box { // Cube716
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 110.0*x
    translate  <0.05, -0.718242, 1.973355>
  }
  box { // Cube717
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 108.0*x
    translate  <0.05, -0.648936, 1.997219>
  }
  box { // Cube718
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 106.0*x
    translate  <0.05, -0.578838, 2.01865>
  }
  box { // Cube719
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 104.0*x
    translate  <0.05, -0.508036, 2.037621>
  }
  box { // Cube720
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 102.0*x
    translate  <0.05, -0.436615, 2.05411>
  }
  box { // Cube721
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 100.0*x
    translate  <0.05, -0.364661, 2.068096>
  }
  box { // Cube722
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 98.0*x
    translate  <0.05, -0.292264, 2.079563>
  }
  box { // Cube723
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 96.0*x
    translate  <0.05, -0.21951, 2.088496>
  }
  box { // Cube724
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 94.0*x
    translate  <0.05, -0.146489, 2.094885>
  }
  box { // Cube725
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 92.0*x
    translate  <0.05, -0.073289, 2.098721>
  }
  box { // Cube726
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 90.0*x
    translate  <0.05, 0.0, 2.1>
  }
  box { // Cube727
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 88.0*x
    translate  <0.05, 0.073289, 2.098721>
  }
  box { // Cube728
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 86.0*x
    translate  <0.05, 0.146489, 2.094885>
  }
  box { // Cube729
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 84.0*x
    translate  <0.05, 0.21951, 2.088496>
  }
  box { // Cube730
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 82.0*x
    translate  <0.05, 0.292264, 2.079563>
  }
  box { // Cube731
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 80.0*x
    translate  <0.05, 0.364661, 2.068096>
  }
  box { // Cube732
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 78.0*x
    translate  <0.05, 0.436615, 2.05411>
  }
  box { // Cube733
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 76.0*x
    translate  <0.05, 0.508036, 2.037621>
  }
  box { // Cube734
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 74.0*x
    translate  <0.05, 0.578838, 2.01865>
  }
  box { // Cube735
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 72.0*x
    translate  <0.05, 0.648936, 1.997219>
  }
  box { // Cube736
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 70.0*x
    translate  <0.05, 0.718242, 1.973355>
  }
  box { // Cube737
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 68.0*x
    translate  <0.05, 0.786674, 1.947086>
  }
  box { // Cube738
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 66.0*x
    translate  <0.05, 0.854147, 1.918445>
  }
  box { // Cube739
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 64.0*x
    translate  <0.05, 0.920579, 1.887467>
  }
  box { // Cube740
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 62.0*x
    translate  <0.05, 0.98589, 1.85419>
  }
  box { // Cube741
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 60.0*x
    translate  <0.05, 1.05, 1.818653>
  }
  box { // Cube742
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 58.0*x
    translate  <0.05, 1.11283, 1.780901>
  }
  box { // Cube743
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 56.0*x
    translate  <0.05, 1.174305, 1.740979>
  }
  box { // Cube744
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 54.0*x
    translate  <0.05, 1.234349, 1.698936>
  }
  box { // Cube745
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 52.0*x
    translate  <0.05, 1.292889, 1.654823>
  }
  box { // Cube746
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 50.0*x
    translate  <0.05, 1.349854, 1.608693>
  }
  box { // Cube747
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 48.0*x
    translate  <0.05, 1.405174, 1.560604>
  }
  box { // Cube748
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 46.0*x
    translate  <0.05, 1.458783, 1.510614>
  }
  box { // Cube749
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 44.0*x
    translate  <0.05, 1.510614, 1.458783>
  }
  box { // Cube750
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 42.0*x
    translate  <0.05, 1.560604, 1.405174>
  }
  box { // Cube751
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 40.0*x
    translate  <0.05, 1.608693, 1.349854>
  }
  box { // Cube752
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 38.0*x
    translate  <0.05, 1.654823, 1.292889>
  }
  box { // Cube753
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 36.0*x
    translate  <0.05, 1.698936, 1.234349>
  }
  box { // Cube754
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 34.0*x
    translate  <0.05, 1.740979, 1.174305>
  }
  box { // Cube755
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 32.0*x
    translate  <0.05, 1.780901, 1.11283>
  }
  box { // Cube756
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.01, 0.01>
    rotate 30.0*x
    translate  <0.05, 1.818653, 1.05>
  }
  material {
    Yellow
  }
  scale <1.0, 0.96, 0.96>
  translate  <41.3, -20.0, 988.0>
}
#declare CSG289 = union {
  cylinder { // Cylndr1493
    <0,0,1>, <0,0,0>, 1 
    material {
      Grayrubber
    }
    scale <2.0, 2.0, 4.0>
    rotate 90.0*y
    translate  <38.0, -20.0, 988.0>
  }
  cylinder { // Cylndr1496
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <2.1, 2.1, 0.1>
    rotate 90.0*y
    translate  <41.2, -20.0, 988.0>
  }
  cylinder { // Cylndr1497
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <2.1, 2.1, 0.1>
    rotate 90.0*y
    translate  <41.4, -20.0, 988.0>
  }
  cylinder { // Cylndr1499
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <2.11, 2.11, 0.04>
    rotate 90.0*y
    translate  <41.455, -20.0, 988.0>
  }
  cylinder { // Cylndr1498
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <2.11, 2.11, 0.04>
    rotate 90.0*y
    translate  <41.405, -20.0, 988.0>
  }
  cylinder { // Cylndr1495
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <2.1, 2.1, 0.1>
    rotate 90.0*y
    translate  <41.0, -20.0, 988.0>
  }
}
#declare CSG287 = difference {
  object { CSG289 }
  plane { // Plane031
    z,0
    material {
      Grayrubber
    }
    scale <2.2, 2.0, 2.0>
    translate  <40.0, -20.0, 989.0>
  }
}
#declare CSG288 = difference {
  object { CSG287 }
  cylinder { // Cylndr1494
    <0,0,1>, <0,0,0>, 1 
    material {
      Grayrubber
    }
    scale <1.4, 1.4, 4.2>
    translate  <39.65, -20.0, 985.9>
  }
}
//
// Include file contains 'RotSweep001'
//
#include "ww2fort_helper.in1"
#declare RotSweep001 = object {
  RotSweep001_Raw
  material {
    Grayrubber
  }
  translate  <39.65, -20.0, 990.0>
}
#declare CSG290 = difference {
  box { // Cube589
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <0.1, 0.05, 0.01>
    translate  <41.3, -20.07329, 990.09872>
  }
  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "operamail.com",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      black
    }
    scale 0.03
    translate  <41.203003, -20.1, 990.103596>
  }

  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "howitzer@",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      black
    }
    scale 0.03
    translate  <41.203, -20.06, 990.103596>
  }

}
#declare CSG291 = difference {
  box { // Cube590
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <0.1, 0.05, 0.01>
    translate  <41.3, -19.92671, 990.09872>
  }
  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Jousimo",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      black
    }
    scale 0.04
    translate  <41.203, -19.96, 990.103596>
  }

  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    concat(chr(169), " Timo" ),
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      black
    }
    scale 0.04
    translate  <41.203, -19.92, 990.103596>
  }

}
union { // Norden
  object { Group008 }
  object { Group009 }
  object { CSG288 }
  object { RotSweep001 }
  box { // Cube771
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <1.5, 0.003, 0.003>
    rotate 90.0*x
    translate  <39.65, -20.0, 989.0>
  }
  box { // Cube774
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <1.5, 0.003, 0.003>
    translate  <39.65, -19.3, 989.0>
  }
  box { // Cube773
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <1.5, 0.003, 0.003>
    translate  <39.65, -20.7, 989.0>
  }
  box { // Cube772
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <1.5, 0.003, 0.003>
    rotate -90.0*z
    translate  <39.65, -20.0, 989.0>
  }
  object { CSG290 }
  object { CSG291 }
}


#declare Group001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  1.5*z
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  3.0*z
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  4.5*z
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  6.0*z
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  7.5*z
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  9.0*z
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.2>
    translate  10.5*z
  }
  material {
    lightblue
  }
  scale <1.2, 1.0, 1.0>
  rotate -20.0*y
  translate  <-11.3, 39.0, 44.2>
}
#declare Group002 = union {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 15.0, 49.117195>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 23.0, 49.117195>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 31.0, 49.117195>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 39.0, 49.117195>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 47.0, 49.117195>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 55.0, 49.117195>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 63.0, 49.117195>
  }
  material {
    lightblue
  }
}
#declare Group003 = union {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 15.0, 49.117195>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 16.0, 49.117195>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 17.0, 49.117195>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 18.0, 49.117195>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 19.0, 49.117195>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 20.0, 49.117195>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 21.0, 49.117195>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 22.0, 49.117195>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 23.0, 49.117195>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 24.0, 49.117195>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 25.0, 49.117195>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 26.0, 49.117195>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 27.0, 49.117195>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 28.0, 49.117195>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 29.0, 49.117195>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 30.0, 49.117195>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 31.0, 49.117195>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 32.0, 49.117195>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 33.0, 49.117195>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 34.0, 49.117195>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 35.0, 49.117195>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 36.0, 49.117195>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 37.0, 49.117195>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 38.0, 49.117195>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 39.0, 49.117195>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 40.0, 49.117195>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 41.0, 49.117195>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 42.0, 49.117195>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 43.0, 49.117195>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 44.0, 49.117195>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 45.0, 49.117195>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 46.0, 49.117195>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 47.0, 49.117195>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 48.0, 49.117195>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 49.0, 49.117195>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 50.0, 49.117195>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 51.0, 49.117195>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 52.0, 49.117195>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 53.0, 49.117195>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 54.0, 49.117195>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 55.0, 49.117195>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 56.0, 49.117195>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 57.0, 49.117195>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 58.0, 49.117195>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 59.0, 49.117195>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 60.0, 49.117195>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 61.0, 49.117195>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 62.0, 49.117195>
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 5.3>
    rotate -20.0*y
    translate  <-13.089713, 63.0, 49.117195>
  }
  material {
    Main_grey
    // Transform to world space
  }
}
#declare Group004 = union {
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.8>
    translate  1.5*z
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.8>
    translate  4.5*z
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 24.0, 0.8>
    translate  7.5*z
  }
  rotate -20.0*y
  translate  <-11.547717, 39.0, 44.880597>
  material {
    Main_grey
    // Transform to world space
  }
}
#declare Bwindows = union {
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    material {
      window
    }
    scale <0.01, 24.0, 5.2>
    rotate -20.0*y
    translate  <-13.092565, 39.0, 49.127654>
  }
  object { Group001 }
  object { Group002 }
  object { Group003 }
  object { Group004 }
}
#declare CSG002 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 29.0, 20.0>
    translate  <-35.0, 43.0, 35.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 24.0, 19.0>
    translate  <-15.35, 39.0, 35.0>
  }
}
#declare Main = intersection {
  object { CSG002 }
  plane { // Plane012
    z,0
    scale <30.0, 20.0, 1.0>
    rotate <90.0, 0.0, -17.191641>
    translate  <-38.5, 17.0, 43.0>
  }
  plane { // Plane013
    z,0
    scale <20.0, 20.0, 1.0>
    rotate <-45.0, -90.0, 0.0>
    translate  <-41.445848, 65.44284, 43.0>
  }
  plane { // Plane014
    z,0
    scale <11.0, 32.0, 1.0>
    rotate 70.0*y
    translate  <-11.5, 42.0, 45.0>
  }
  material {
    Main_grey
    // Transform to world space
  }
}
#declare Building = difference {
  object { Main }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-30.642547, 15.244651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-33.642547, 16.144651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-36.642547, 17.044651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-39.642547, 17.944651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-42.642547, 18.844651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-45.642547, 19.744651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-48.642547, 20.644651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-51.642547, 21.544651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-54.642547, 22.444651, 50.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-30.642547, 15.244651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-33.642547, 16.144651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-36.642547, 17.044651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-39.642547, 17.944651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-42.642547, 18.844651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-45.642547, 19.744651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-48.642547, 20.644651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-51.642547, 21.544651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    rotate -17.191641*z
    translate  <-54.642547, 22.444651, 40.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 4.0, 19.0>
    rotate -17.191641*z
    translate  <-41.747549, 23.254816, 35.0>
    material {
      black
      // Transform to world space
    }
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 19.0>
    translate  <-24.6, 19.0, 35.0>
    material {
      black
      // Transform to world space
    }
  }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    material {
      window
    }
    scale <13.5, 0.1, 6.2>
    rotate -17.191641*z
    translate  <-42.683005, 18.630298, 45.037741>
  }
}
#declare TransSweep043 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.5, -2.0>,
  <-2.0, -4.5>,
  <2.0, -4.5>,
  <4.5, -2.0>,
  <4.5, 2.0>,
  <2.0, 4.5>,
  <-2.0, 4.5>,
  <-4.5, 2.0>,
  <-4.5, -2.0>
  rotate -x*90
  material {
    Metaltex
  }
}
#declare TransSweep044 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate -90.0*y
  translate  <5.2, -5.5, 1.0>
}
#declare CSG195 = intersection {
  object { TransSweep044 }
  plane { // Plane049
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-22.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane050
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-22.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep045 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-45.0, -90.0, 0.0>
  translate  <-0.212132, -7.566043, 1.0>
}
#declare CSG196 = intersection {
  object { TransSweep045 }
  plane { // Plane051
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-67.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane052
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <22.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep046 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-90.0, -90.0, 0.0>
  translate  <-5.5, -5.2, 1.0>
}
#declare CSG197 = intersection {
  object { TransSweep046 }
  plane { // Plane053
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-112.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane054
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <67.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep047 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-135.0, -90.0, 0.0>
  translate  <-7.566043, 0.212132, 1.0>
}
#declare CSG198 = intersection {
  object { TransSweep047 }
  plane { // Plane055
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-157.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane056
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <112.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep048 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <180.0, -90.0, 0.0>
  translate  <-5.2, 5.5, 1.0>
}
#declare CSG199 = intersection {
  object { TransSweep048 }
  plane { // Plane057
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <157.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane058
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <157.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep049 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <135.0, -90.0, 0.0>
  translate  <0.212132, 7.566043, 1.0>
}
#declare CSG200 = intersection {
  object { TransSweep049 }
  plane { // Plane059
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <112.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane060
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-157.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep050 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <90.0, -90.0, 0.0>
  translate  <5.5, 5.2, 1.0>
}
#declare CSG201 = intersection {
  object { TransSweep050 }
  plane { // Plane061
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <67.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane062
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-112.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep051 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <45.0, -90.0, 0.0>
  translate  <7.566043, -0.212132, 1.0>
}
#declare CSG202 = intersection {
  object { TransSweep051 }
  plane { // Plane063
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <22.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane064
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-67.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare Group084 = union {
  cone { // Cone050
    <0,0,0>, 0.4, <0,0,1>, 0.05
    material {
      Metaltex
    }
    translate  12.88*z
  }
  cone { // Cone051
    <0,0,0>, 0.35, <0,0,1>, 0.3
    material {
      Metaltex
    }
    scale <1.0, 1.0, 10.0>
    translate  2.02*z
  }
  cone { // Cone052
    <0,0,0>, 0.7, <0,0,1>, 0.4
    material {
      Metaltex
    }
    translate  1.0*z
  }
  object { TransSweep043 }
  object { CSG195 }
  object { CSG196 }
  object { CSG197 }
  object { CSG198 }
  object { CSG199 }
  object { CSG200 }
  object { CSG201 }
  object { CSG202 }
  cylinder { // Cylndr1125
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate -45.0*y
    translate  <8.9, 0.0, 3.9>
  }
  cylinder { // Cylndr1126
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, -45.0>
    translate  <6.29325, -6.29325, 3.9>
  }
  cylinder { // Cylndr1127
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, -90.0>
    translate  <0.0, -8.9, 3.9>
  }
  cylinder { // Cylndr1128
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <-0.0, -45.0, -135.0>
    translate  <-6.29325, -6.29325, 3.9>
  }
  cylinder { // Cylndr1129
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 180.0>
    translate  <-8.9, 0.0, 3.9>
  }
  cylinder { // Cylndr1130
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 135.0>
    translate  <-6.29325, 6.29325, 3.9>
  }
  cylinder { // Cylndr1131
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 90.0>
    translate  <0.0, 8.9, 3.9>
  }
  cylinder { // Cylndr1132
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 45.0>
    translate  <6.29325, 6.29325, 3.9>
  }
  cone { // Cone053
    <0,0,0>, 0.3, <0,0,1>, 0.7
    material {
      Metaltex
    }
    scale <1.0, 1.0, 0.86>
    translate  12.02*z
  }
  cylinder { // Cylndr1133
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <-4.5, -4.5, -2.0>
    rotate -180.0*z
  }
  scale 0.3
  rotate <-45.948467, -0.0, -138.647339>
  translate  <-30.855245, 57.835758, 79.85321>
}
#declare TaperSweep002 = prism {
  conic_sweep
  linear_spline
  0.2,1.0
  5  // control points
  <-5.75, -5.75>,
  <5.75, -5.75>,
  <5.75, 5.75>,
  <-5.75, 5.75>,
  <-5.75, -5.75>
  rotate <90,0,90>
  material {
    Btowerroof
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <-31.0, 58.0, 69.8>
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.7,1.0
  5  // control points
  <-5.75, -5.75>,
  <5.75, -5.75>,
  <5.75, 5.75>,
  <-5.75, 5.75>,
  <-5.75, -5.75>
  rotate <90,0,90>
  material {
    glass
  }
  scale <0.98, 0.98, 16.0>
  translate  <-31.0, 58.0, 51.8>
}
#declare CSG004 = difference {
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      WrinkleGray
    }
    scale 4.0
    translate  <-31.0, 58.0, 59.0>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    translate  <-31.0, 54.5, 56.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  material {
    Main_grey
  }
}
#declare Group007 = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <-45.0, -90.0, 0.0>
    translate  <-34.4, 61.4, 77.4>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <45.0, -90.0, 0.0>
    translate  <-34.4, 62.6, 77.4>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <45.0, -90.0, 0.0>
    translate  <-26.4, 62.6, 77.4>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <-45.0, -90.0, 0.0>
    translate  <-26.4, 61.4, 77.4>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <-45.0, -90.0, 0.0>
    translate  <-26.4, 53.4, 77.4>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <45.0, -90.0, 0.0>
    translate  <-26.4, 54.6, 77.4>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <45.0, -90.0, 0.0>
    translate  <-34.4, 54.6, 77.4>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 1.697>
    rotate <-45.0, -90.0, 0.0>
    translate  <-34.4, 53.4, 77.4>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <-35.0, 54.0, 73.4>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <-35.0, 62.0, 73.4>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <-27.0, 62.0, 73.4>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <-27.0, 54.0, 73.4>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.2
    translate  <-35.0, 62.0, 73.4>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.2
    translate  <-35.0, 54.0, 73.4>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.2
    translate  <-27.0, 54.0, 73.4>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.2
    translate  <-27.0, 62.0, 73.4>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 11.313>
    rotate <45.0, -90.0, 0.0>
    translate  <-27.0, 62.0, 73.4>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 11.313>
    rotate <-45.0, -90.0, 0.0>
    translate  <-27.0, 54.0, 73.4>
  }
  material {
    Chrome_Metal
  }
}
#declare Btower = union {
  object { Group084 }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 76.4>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 75.4>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 74.4>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 73.4>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 72.4>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 71.4>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 70.4>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.0, 1.0, 0.1>
    translate  <-31.0, 58.0, 69.4>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.5>
    translate  <-31.8, 57.2, 72.9>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.5>
    translate  <-30.2, 57.2, 72.9>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.5>
    translate  <-30.2, 58.8, 72.9>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.5>
    translate  <-31.8, 58.8, 72.9>
    material {
      Main_grey
      // Transform to world space
    }
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome_Metal
    }
    scale <0.4, 0.4, 8.0>
    translate  <-31.0, 58.0, 68.4>
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    translate  <-31.0, 58.0, 79.0>
  }
  cone { // Cone001
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      Chrome_Metal
    }
    scale <1.0, 1.0, 2.0>
    translate  <-31.0, 58.0, 76.5>
  }
  object { TaperSweep002 }
  object { TaperSweep001 }
  object { CSG004 }
  object { Group007 }
}
#declare TaperSweep003 = prism {
  conic_sweep
  linear_spline
  0.7,1.0
  5  // control points
  <-5.75, -5.75>,
  <5.75, -5.75>,
  <5.75, 5.75>,
  <-5.75, 5.75>,
  <-5.75, -5.75>
  rotate <90,0,90>
  material {
    Btowerwindows
  }
  scale <1.0, 1.0, 16.0>
  translate  <-31.0, 58.0, 51.8>
}
#declare CSG001 = difference {
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      Yellowpaint
    }
    scale <11.5, 11.5, 0.21>
    translate  <-29.0, 33.0, 55.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      Yellowpaint
    }
    scale <10.5, 10.5, 0.22>
    translate  <-29.0, 33.0, 55.0>
  }
}
#declare TransSweep027 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG106 = union {
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG107 = union {
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG108 = difference {
  object { CSG106 }
  object { CSG107 }
}
#declare Group046 = union {
  cylinder { // Cylndr649
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr650
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG108 }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG109 = union {
  cylinder { // Cylndr668
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr669
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr670
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr671
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr672
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr673
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG110 = union {
  cylinder { // Cylndr674
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr675
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr676
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr677
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr678
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr679
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG111 = difference {
  object { CSG109 }
  object { CSG110 }
}
#declare Group047 = union {
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr667
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG111 }
  cylinder { // Cylndr680
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG112 = union {
  cylinder { // Cylndr684
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr685
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr686
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr687
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr688
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr689
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG113 = union {
  cylinder { // Cylndr690
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr691
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr692
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr693
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr694
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr695
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG114 = difference {
  object { CSG112 }
  object { CSG113 }
}
#declare Group048 = union {
  cylinder { // Cylndr681
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr682
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr683
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG114 }
  cylinder { // Cylndr696
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG115 = union {
  cylinder { // Cylndr700
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr701
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr702
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr703
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr704
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr705
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG116 = union {
  cylinder { // Cylndr706
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr707
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr708
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr709
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr710
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr711
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG117 = difference {
  object { CSG115 }
  object { CSG116 }
}
#declare Group049 = union {
  cylinder { // Cylndr697
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr698
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr699
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG117 }
  cylinder { // Cylndr712
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG118 = union {
  cylinder { // Cylndr713
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr714
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr715
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr716
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG119 = difference {
  object { CSG118 }
  cylinder { // Cylndr717
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr718
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr719
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr720
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group050 = union {
  object { Group046 }
  object { Group047 }
  object { Group048 }
  object { Group049 }
  object { CSG119 }
  cone { // Cone025
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone026
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone027
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone028
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr721
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep028 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare AA1 = union {
  cylinder { // Cylndr646
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr647
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep027 }
  cylinder { // Cylndr648
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group050 }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep028 }
  cylinder { // Cylndr722
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate <-0.0, -0.0, 75.143585>
  translate  <-18.0, 62.0, 53.8>
}
#declare TransSweep025 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG092 = union {
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG093 = union {
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG094 = difference {
  object { CSG092 }
  object { CSG093 }
}
#declare Group040 = union {
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG094 }
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG095 = union {
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG096 = union {
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG097 = difference {
  object { CSG095 }
  object { CSG096 }
}
#declare Group041 = union {
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG097 }
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG098 = union {
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG099 = union {
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG100 = difference {
  object { CSG098 }
  object { CSG099 }
}
#declare Group042 = union {
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG100 }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG101 = union {
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG102 = union {
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG103 = difference {
  object { CSG101 }
  object { CSG102 }
}
#declare Group043 = union {
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG103 }
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG104 = union {
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr637
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr638
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr639
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG105 = difference {
  object { CSG104 }
  cylinder { // Cylndr640
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr641
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr642
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr643
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group044 = union {
  object { Group040 }
  object { Group041 }
  object { Group042 }
  object { Group043 }
  object { CSG105 }
  cone { // Cone021
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone022
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone023
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone024
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr644
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep026 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare AA2 = union {
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep025 }
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group044 }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep026 }
  cylinder { // Cylndr645
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate <-0.0, -0.0, 70.448029>
  translate  <-18.0, 54.0, 53.8>
}
#declare TransSweep023 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG078 = union {
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG079 = union {
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG080 = difference {
  object { CSG078 }
  object { CSG079 }
}
#declare Group034 = union {
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG080 }
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG081 = union {
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG082 = union {
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG083 = difference {
  object { CSG081 }
  object { CSG082 }
}
#declare Group035 = union {
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG083 }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG084 = union {
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG085 = union {
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG086 = difference {
  object { CSG084 }
  object { CSG085 }
}
#declare Group036 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG086 }
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG087 = union {
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG088 = union {
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG089 = difference {
  object { CSG087 }
  object { CSG088 }
}
#declare Group037 = union {
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG089 }
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG090 = union {
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG091 = difference {
  object { CSG090 }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group038 = union {
  object { Group034 }
  object { Group035 }
  object { Group036 }
  object { Group037 }
  object { CSG091 }
  cone { // Cone017
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone018
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone019
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone020
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep024 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare AA3 = union {
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep023 }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group038 }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep024 }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate <0.0, -0.0, 47.345718>
  translate  <-18.0, 17.0, 53.8>
}
#declare CSG063 = intersection {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  7.0*z
  }
  plane { // Plane007
    z,0
    scale <5.0, 3.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -4.0, 7.24>
  }
  plane { // Plane008
    z,0
    scale <5.0, 3.0, 1.0>
    rotate -70.0*x
    translate  <0.0, 4.0, 7.24>
  }
  plane { // Plane009
    z,0
    scale <3.0, 5.0, 1.0>
    rotate -70.0*y
    translate  <-4.0, 0.0, 7.24>
  }
  plane { // Plane010
    z,0
    scale <3.8, 5.0, 1.0>
    rotate 50.0*y
    translate  <2.7, 0.0, 7.24>
  }
}
#declare CSG064 = difference {
  object { CSG063 }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 0.0, 7.82>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 2.2, 7.82>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, -2.2, 7.82>
  }
}
#declare CSG065 = union {
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
}
#declare CSG066 = union {
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
}
#declare CSG067 = difference {
  object { CSG065 }
  object { CSG066 }
}
#declare Cannon = union {
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -0.5, 7.64>
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -2.7, 7.64>
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <2.0, 2.7, 7.64>
  }
  object { CSG064 }
  object { CSG067 }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_1
    }
    scale <4.5, 4.5, 1.0>
    translate  3.0*z
  }
  material {
    lightblue
  }
  rotate -121.273247*z
  translate  <-49.0, 28.0, 52.0>
}
#declare Bcannons = union {
  object { AA1 }
  object { AA2 }
  object { AA3 }
  object { Cannon }
}
#declare TaperSweep004 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-2.0, -2.0>,
  <2.0, -2.0>,
  <2.0, 2.0>,
  <-2.0, 2.0>,
  <-2.0, -2.0>
  rotate <90,0,90>
  material {
    lightgreen
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-40.0, 53.0, 56.5>
}
#declare CSG005 = difference {
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    translate  <-40.0, 53.0, 55.025293>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.1, 0.25>
    translate  <-40.0, 53.0, 55.5>
  }
  material {
    lightgreen
  }
}
#declare Bstructure = union {
  object { Btower }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 open
    material {
      Metaltex
    }
    scale <0.4, 0.4, 4.0>
    translate  <-38.5, 48.5, 55.0>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metaltex
    }
    scale <0.5, 0.1, 1.0>
    translate  <-30.45, 55.5, 56.0>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metaltex
    }
    scale <0.5, 0.1, 1.0>
    translate  <-31.55, 55.5, 56.0>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metaltex
    }
    scale <1.1, 0.1, 0.1>
    translate  <-31.0, 54.0, 57.0>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metaltex
    }
    scale <0.1, 0.1, 1.1>
    translate  <-30.0, 54.0, 56.0>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    material {
      Main_grey
    }
    scale <0.1, 0.1, 1.1>
    translate  <-32.0, 54.0, 56.0>
  }
  object { TaperSweep003 }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <4.8, 4.8, 0.01>
    translate  <-31.0, 58.0, 65.4>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    material {
      Whitepaint
    }
    scale <4.0, 0.3, 0.21>
    translate  <-29.0, 33.0, 55.0>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    material {
      Whitepaint
    }
    scale <0.3, 8.0, 0.21>
    translate  <-25.0, 33.0, 55.0>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    material {
      Whitepaint
    }
    scale <0.3, 8.0, 0.21>
    translate  <-33.0, 33.0, 55.0>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 0.2>
    translate  <-29.0, 33.0, 55.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  object { CSG001 }
  object { Bcannons }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 open
    material {
      Metaltex
    }
    scale <0.4, 0.4, 4.0>
    translate  <-41.5, 48.5, 55.0>
  }
  object { TaperSweep004 }
  object { CSG005 }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    material {
      Main_grey
    }
    scale <5.0, 5.0, 1.0>
    rotate -17.191641*z
    translate  <-49.0, 28.0, 54.5>
  }
}
#declare BuildingGroup = union {
  object { Bwindows }
  object { Building }
  object { Bstructure }
}
#declare CSG269 = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 5.0, 5.0>
    rotate -17.191641*z
    translate  <-26.735016, 13.599354, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    rotate -17.191641*z
    translate  <-13.83031, 5.932917, 20.05561>
    material {
      RoughStone
      // Transform to world space
    }
  }
}
#declare Group113 = union {
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <1.6, 0.1, 0.1>
    translate  21.55527*z
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.1, 0.1, 1.6>
    translate  <-1.5, 0.0, 20.05527>
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.1, 0.1, 1.6>
    translate  <1.5, 0.0, 20.05527>
  }
  rotate -17.191641*z
  translate  <-14.268455, 4.51123, 0.0>
}
#declare Group114 = union {
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.1, 1.4>
    translate  <0.75, 0.0, 20.05527>
    material {
      Main_grey
      // Transform to world space
      translate  <13.385617, -7.367416, 0.0>
      rotate 17.191641*z
    }
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.1, 1.4>
    translate  <-0.75, 0.0, 20.05527>
    material {
      Main_grey
      // Transform to world space
      translate  <13.385617, -7.367416, 0.0>
      rotate 17.191641*z
    }
  }
  rotate -17.191641*z
  translate  <-13.385617, 7.367416, 0.0>
}
#declare TaperSweep025 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <0.5, 60.0, 30.0>
}
#declare TaperSweep017 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <-0.5, 60.0, 30.0>
}
#declare TaperSweep008 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <20.5, 2.0, 30.0>
}
#declare TaperSweep007 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <19.5, 2.0, 30.0>
}
#declare TaperSweep009 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <29.5, 2.0, 30.0>
}
#declare TaperSweep010 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <39.5, 2.0, 30.0>
}
#declare TaperSweep011 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <49.5, 2.0, 30.0>
}
#declare TaperSweep012 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <59.5, 2.0, 30.0>
}
#declare TaperSweep013 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <30.5, 2.0, 30.0>
}
#declare TaperSweep014 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <40.5, 2.0, 30.0>
}
#declare TaperSweep015 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <50.5, 2.0, 30.0>
}
#declare TaperSweep016 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <60.5, 2.0, 30.0>
}
#declare TaperSweep018 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <9.5, 60.0, 30.0>
}
#declare TaperSweep019 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <19.5, 60.0, 30.0>
}
#declare TaperSweep020 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <29.5, 60.0, 30.0>
}
#declare TaperSweep021 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <39.5, 60.0, 30.0>
}
#declare TaperSweep022 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <49.5, 60.0, 30.0>
}
#declare TaperSweep023 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <59.5, 60.0, 30.0>
}
#declare TaperSweep024 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <69.5, 60.0, 30.0>
}
#declare TaperSweep026 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <10.5, 60.0, 30.0>
}
#declare TaperSweep027 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <20.5, 60.0, 30.0>
}
#declare TaperSweep028 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <30.5, 60.0, 30.0>
}
#declare TaperSweep029 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <40.5, 60.0, 30.0>
}
#declare TaperSweep030 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <50.5, 60.0, 30.0>
}
#declare TaperSweep031 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <60.5, 60.0, 30.0>
}
#declare TaperSweep032 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate 180.0*x
  translate  <70.5, 60.0, 30.0>
}
#declare TaperSweep054 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-0.5, 0.0, 30.0>
}
#declare TaperSweep047 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <0.5, 0.0, 30.0>
}
#declare TaperSweep048 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-9.5, 0.0, 30.0>
}
#declare TaperSweep049 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-19.5, 0.0, 30.0>
}
#declare TaperSweep053 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-59.5, -2.0, 30.0>
}
#declare TaperSweep055 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-10.5, 0.0, 30.0>
}
#declare TaperSweep056 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-20.5, 0.0, 30.0>
}
#declare TaperSweep060 = prism {
  conic_sweep
  linear_spline
  0.6,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Metaltex
  }
  scale <1.0, 1.0, 2.0>
  rotate -180.0*x
  translate  <-60.5, -2.0, 30.0>
}
#declare Group116 = union {
  object { TaperSweep054 }
  object { TaperSweep047 }
  object { TaperSweep048 }
  object { TaperSweep049 }
  object { TaperSweep053 }
  object { TaperSweep055 }
  object { TaperSweep056 }
  object { TaperSweep060 }
  rotate -17.191641*z
  translate  <1.948029, 4.521643, 0.0>
}
#declare Group115 = union {
  object { TaperSweep025 }
  object { TaperSweep017 }
  object { TaperSweep008 }
  object { TaperSweep007 }
  object { TaperSweep009 }
  object { TaperSweep010 }
  object { TaperSweep011 }
  object { TaperSweep012 }
  object { TaperSweep013 }
  object { TaperSweep014 }
  object { TaperSweep015 }
  object { TaperSweep016 }
  object { TaperSweep018 }
  object { TaperSweep019 }
  object { TaperSweep020 }
  object { TaperSweep021 }
  object { TaperSweep022 }
  object { TaperSweep023 }
  object { TaperSweep024 }
  object { TaperSweep026 }
  object { TaperSweep027 }
  object { TaperSweep028 }
  object { TaperSweep029 }
  object { TaperSweep030 }
  object { TaperSweep031 }
  object { TaperSweep032 }
  object { Group116 }
}
#declare Group111 = union {
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <6.811983, 3.222886, 23.0>
  }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-3.188017, 3.222886, 23.0>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-23.188017, 3.222886, 23.0>
  }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-33.188017, 3.222886, 23.0>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-43.188017, 3.222886, 23.0>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-53.188017, 3.222886, 23.0>
  }
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-63.188017, 3.222886, 23.0>
  }
  rotate -17.191641*z
  translate  <-0.701398, 2.170548, 0.0>
}
#declare Group112 = union {
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.0, 0.2, 5.3>
    translate  <86.7, 55.0, 23.0>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <-5.0, 62.0, 23.0>
  }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 0.2, 5.3>
    translate  <-12.5, 15.0, 23.0>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <15.0, 2.0, 23.0>
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.35, 5.3>
    rotate -8.59582*z
    translate  <10.752806, 1.993846, 23.0>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <25.0, 2.0, 23.0>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <35.0, 2.0, 23.0>
  }
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <45.0, 2.0, 23.0>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <55.0, 2.0, 23.0>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <65.0, 2.0, 23.0>
  }
  object { Group111 }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 0.2, 5.3>
    translate  <-12.5, 25.0, 23.0>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 0.2, 5.3>
    translate  <-12.5, 35.0, 23.0>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 0.2, 5.3>
    translate  <-12.5, 45.0, 23.0>
  }
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 0.2, 5.3>
    translate  <-12.5, 55.0, 23.0>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <5.0, 62.0, 23.0>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <15.0, 62.0, 23.0>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <25.0, 62.0, 23.0>
  }
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <35.0, 62.0, 23.0>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <45.0, 62.0, 23.0>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <55.0, 62.0, 23.0>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <65.0, 62.0, 23.0>
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <0.2, 5.3, 5.3>
    translate  <75.0, 62.0, 23.0>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.0, 0.2, 5.3>
    translate  <86.7, 45.0, 23.0>
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.0, 0.2, 5.3>
    translate  <86.7, 35.0, 23.0>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.0, 0.2, 5.3>
    translate  <86.7, 25.0, 23.0>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.0, 0.2, 5.3>
    translate  <86.7, 15.0, 23.0>
  }
}
#declare CSG286 = difference {
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <50.0, 5.3, 0.2>
    translate  <60.0, 2.0, 26.0>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.7, 0.1, 0.21>
    translate  <20.0, -3.3, 26.0>
  }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.7, 0.1, 0.21>
    translate  <30.0, -3.3, 26.0>
  }
}
#declare Group005 = union {
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <5.3, 30.0, 0.2>
    translate  <-12.5, 37.0, 26.0>
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <40.0, 5.3, 0.2>
    rotate -17.191641*z
    translate  <-26.735016, 13.599354, 26.0>
  }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <10.3, 35.299999, 0.2>
    translate  <87.0, 32.0, 26.0>
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    material {
      DGray
    }
    scale <60.0, 5.3, 0.2>
    translate  <17.0, 62.0, 26.0>
  }
  object { CSG286 }
}
#declare Group120 = union {
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.2, 0.2, 5.0>
    translate  <30.0, -3.3, 22.0>
  }
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.2, 0.2, 5.0>
    translate  <20.0, -3.3, 22.0>
  }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.4, 0.3, 5.0>
    translate  <15.0, -3.3, 22.0>
  }
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.4, 0.3, 5.0>
    translate  <25.0, -3.3, 22.0>
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.4, 0.3, 5.0>
    translate  <35.0, -3.3, 22.0>
  }
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <10.4, 0.3, 0.4>
    translate  <25.0, -3.3, 27.0>
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <2.3, 0.1, 4.0>
    translate  <32.4, -3.3, 22.7>
  }
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <2.3, 0.1, 4.0>
    translate  <27.6, -3.3, 22.7>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <2.3, 0.1, 4.0>
    translate  <22.4, -3.3, 22.7>
  }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <2.3, 0.1, 4.0>
    translate  <17.6, -3.3, 22.7>
  }
  cylinder { // Cylndr1477
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 18.7>
  }
  cylinder { // Cylndr1478
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 19.2>
  }
  cylinder { // Cylndr1479
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 19.7>
  }
  cylinder { // Cylndr1480
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 20.2>
  }
  cylinder { // Cylndr1481
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 20.7>
  }
  cylinder { // Cylndr1482
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 21.2>
  }
  cylinder { // Cylndr1483
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 21.7>
  }
  cylinder { // Cylndr1484
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 22.2>
  }
  cylinder { // Cylndr1485
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 22.7>
  }
  cylinder { // Cylndr1486
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 23.2>
  }
  cylinder { // Cylndr1487
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 23.7>
  }
  cylinder { // Cylndr1488
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 24.2>
  }
  cylinder { // Cylndr1489
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 24.7>
  }
  cylinder { // Cylndr1490
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 25.2>
  }
  cylinder { // Cylndr1492
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 26.2>
  }
  cylinder { // Cylndr1491
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.02, 0.02, 20.0>
    rotate 90.0*y
    translate  <15.0, -3.4, 25.7>
  }
}
#declare CSG271 = difference {
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 6.0>
    translate  <80.0, -13.0, 23.0>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 15.0, 5.0>
    rotate <27.467003, 0.0, -0.0>
    translate  <70.95, -15.281462, 28.238289>
  }
}
#declare Group006 = union {
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 2.0, 1.0>
    rotate <0.0, -0.0, -0.0>
    translate  <80.0, -1.0, 28.0>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 4.7, 2.0>
    rotate <65.01561, -0.0, -0.0>
    translate  <81.0, -23.166423, 23.899793>
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 1.0>
    translate  <80.0, -17.0, 19.5>
  }
  object { CSG271 }
  material {
    RoughStone
  }
}
#declare StructureBase = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 5.0, 5.0>
    translate  <60.0, 2.0, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 35.0, 5.0>
    translate  <87.0, 32.0, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 5.0, 5.0>
    translate  <17.0, 62.0, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 30.0, 5.0>
    translate  <-40.0, 46.0, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 30.0, 5.0>
    translate  <-12.5, 37.0, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 10.0, 5.0>
    rotate -45.0*z
    translate  <73.5, 10.5, 23.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  object { CSG269 }
  object { Group113 }
  object { Group114 }
  object { Group115 }
  object { Group112 }
  object { Group005 }
  object { Group120 }
  object { Group006 }
}
#declare CSG265 = intersection {
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 5.0>
    translate  <80.0, 10.0, 33.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  plane { // Plane025
    z,0
    scale <5.0, 5.0, 1.0>
    rotate <0.0, -90.0, -45.0>
    translate  <75.0, 15.0, 33.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
}
#declare CSG266 = difference {
  object { CSG265 }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    translate  <70.5, 3.6, 29.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <72.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <75.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <78.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <81.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <84.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.8>
    translate  <87.5, 0.9, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
}
#declare CSG267 = difference {
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 10.0, 5.0>
    translate  <85.0, 17.0, 33.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 21.0, 32.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 21.0, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 22.2, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 23.4, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 24.6, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 25.8, 35.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 22.2, 32.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 23.4, 32.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 24.6, 32.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.8>
    translate  <80.9, 25.8, 32.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
}
#declare Smallbuilding = union {
  object { CSG266 }
  object { CSG267 }
  cylinder { // Cylndr1417
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 3.0>
    translate  <77.0, 7.0, 38.0>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 0.4>
    translate  <85.0, 10.0, 38.0>
    material {
      Main_grey
      // Transform to world space
    }
  }
  cylinder { // Cylndr1420
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 3.0>
    translate  <87.0, 25.0, 38.0>
  }
  cylinder { // Cylndr1419
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 3.0>
    translate  <85.0, 25.0, 38.0>
  }
  cylinder { // Cylndr1418
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 3.0>
    translate  <77.0, 5.0, 38.0>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    material {
      window
    }
    scale <0.1, 3.0, 2.5>
    translate  <80.2, 23.4, 33.5>
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    material {
      window
    }
    scale <8.1, 0.1, 1.0>
    translate  <80.0, 0.3, 35.0>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 1.1, 0.1>
    translate  <70.0, 3.6, 30.0>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 0.1, 1.1>
    translate  <70.0, 2.6, 29.0>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 0.1, 1.1>
    translate  <70.0, 4.6, 29.0>
  }
}
#declare CSG268 = intersection {
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    material {
      Asphalt
    }
    scale <50.0, 13.8, 1.0>
    translate  <58.099711, -18.870721, 17.6>
  }
  plane { // Plane026
    z,0
    material {
      Asphalt
    }
    scale <10.0, 1.0, 1.0>
    rotate <90.0, 0.0, -17.191641>
    translate  <24.452613, -27.621064, 17.6>
  }
}
#declare CSG264 = difference {
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <100.0, 50.0, 10.0>
    rotate -17.191645*z
    translate  <18.931509, 43.723651, 8.55561>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <50.0, 14.2, 1.0>
    translate  <58.132739, -19.391571, 18.55561>
  }
}
#declare Basement = union {
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    material {
      Asphalt
    }
    scale <60.0, 8.5, 1.0>
    rotate -17.191645*z
    translate  <-14.235703, -6.75475, 17.6>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <50.0, 1.0, 10.0>
    translate  <89.97658, -33.51746, 8.55561>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <60.0, 9.0, 9.0>
    rotate -17.191645*z
    translate  <-14.387129, -7.234265, 8.55561>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <50.0, 9.0, 9.0>
    translate  <89.916794, -24.518475, 8.55561>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <60.0, 1.0, 10.0>
    rotate -17.191645*z
    translate  <-17.047139, -15.828014, 8.55561>
  }
  object { CSG268 }
  object { CSG264 }
}
#declare CSG003 = difference {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightgreen
    }
    scale <14.0, 14.0, 1.0>
    translate  <20.0, 35.0, 20.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      darkgreen
    }
    scale <-8.0, -8.0, -2.2>
    rotate -180.0*z
    translate  <20.0, 35.0, 21.1>
  }
}
#declare CSG270 = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightgreen
    }
    scale <14.0, 14.0, 1.0>
    translate  <57.0, 35.0, 20.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      darkgreen
    }
    scale <-8.0, -8.0, -2.2>
    rotate 180.0*z
    translate  <57.0, 35.0, 21.1>
  }
}
#declare Silodoors = union {
  object { CSG003 }
  object { CSG270 }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <15.85, 39.15, 20.0>
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    material {
      Main_grey
    }
    scale <14.5, 14.5, 1.0>
    translate  <57.0, 35.0, 18.0>
  }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    material {
      Main_grey
    }
    scale <14.5, 14.5, 1.0>
    translate  <20.0, 35.0, 18.0>
  }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <52.85, 30.85, 20.0>
  }
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <61.15, 30.85, 20.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <52.85, 39.15, 20.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <61.15, 39.15, 20.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <15.85, 30.85, 20.0>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <24.15, 30.85, 20.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkgreen
    }
    scale <4.0, 4.0, 0.5>
    translate  <24.15, 39.15, 20.0>
  }
}
#declare Group117 = union {
  cylinder { // Cylndr1450
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  -6.0*x
  }
  cylinder { // Cylndr1451
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*z
    translate  <-4.242641, 4.242641, 0.0>
  }
  cylinder { // Cylndr1452
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate 180.0*z
    translate  <0.0, 6.0, 0.0>
  }
  cylinder { // Cylndr1453
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate 90.0*z
    translate  <4.242641, 4.242641, 0.0>
  }
  cylinder { // Cylndr1454
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -0.0*z
    translate  <6.0, -0.0, 0.0>
  }
  cylinder { // Cylndr1455
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*z
    translate  <4.242641, -4.242641, 0.0>
  }
  cylinder { // Cylndr1456
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate 180.0*z
    translate  <-0.0, -6.0, 0.0>
  }
  cylinder { // Cylndr1457
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate 90.0*z
    translate  <-4.242641, -4.242641, 0.0>
  }
  material {
    Main_grey
  }
}
#declare Cranebase = union {
  object { Group117 }
  cylinder { // Cylndr1470
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <3.0, 3.0, 0.5>
    rotate -90.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr1471
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*z
  }
  cylinder { // Cylndr1472
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <7.5, 7.5, 1.0>
    rotate -90.0*z
    translate  5.0*z
  }
  translate  <81.0, -13.0, 29.0>
}
#declare CSG272 = difference {
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.8, 1.95, 0.8>
    translate  <-0.8, 0.0, 0.8>
  }
  cylinder { // Cylndr1434
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <1.5, 1.5, 4.0>
    rotate -90.0*x
    translate  -2.0*y
  }
}
#declare CSG273 = difference {
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <1.5, 1.9, 1.5>
  }
  object { CSG272 }
}
#declare CSG274 = union {
  cylinder { // Cylndr1436
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.5, 0.5, 0.1>
    rotate -90.0*y
    translate  <23.55, 0.0, 1.9>
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.05, 0.5, 0.5>
    translate  <23.5, 0.0, 1.4>
  }
}
#declare CSG275 = difference {
  object { CSG274 }
  cylinder { // Cylndr1437
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.3, 0.3, 0.2>
    rotate -90.0*y
    translate  <23.6, 0.0, 1.9>
  }
}
#declare CSG276 = union {
  cylinder { // Cylndr1438
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.5, 0.5, 0.1>
    rotate -90.0*y
    translate  <11.55, 0.0, 1.9>
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.05, 0.5, 0.5>
    translate  <11.5, 0.0, 1.4>
  }
}
#declare CSG277 = difference {
  object { CSG276 }
  cylinder { // Cylndr1439
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.3, 0.3, 0.2>
    rotate -90.0*y
    translate  <11.6, 0.0, 1.9>
  }
}
#declare CSG278 = difference {
  cylinder { // Cylndr1440
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.5, 0.5, 0.1>
    rotate -90.0*y
    translate  1.9*z
  }
  cylinder { // Cylndr1441
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.3, 0.3, 0.2>
    rotate -90.0*y
    translate  <0.05, 0.0, 1.9>
  }
}
#declare CSG279 = difference {
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.9, 1.2, 1.2>
    translate  11.5*x
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.9, 0.8, 0.8>
    translate  11.6*x
  }
}
#declare CSG280 = difference {
  cylinder { // Cylndr1442
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.5, 0.5, 0.1>
    rotate -90.0*y
    translate  <1.4, 0.0, 1.9>
  }
  cylinder { // Cylndr1443
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.3, 0.3, 0.2>
    rotate -90.0*y
    translate  <1.45, 0.0, 1.9>
  }
}
#declare CSG281 = difference {
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale 0.9
    translate  23.55*x
  }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.9, 0.5, 0.5>
    translate  23.6*x
  }
}
#declare CSG282 = union {
  torus { // Torus009
    0.4, 0.1  rotate -x*90
    material {
      Dark_grey
    }
    rotate -90.0*x
    translate  <36.0, 0.1, 0.4>
  }
  torus { // Torus010
    0.4, 0.1  rotate -x*90
    material {
      Dark_grey
    }
    rotate -90.0*x
    translate  <36.0, -0.1, 0.4>
  }
}
#declare CSG283 = intersection {
  object { CSG282 }
  plane { // Plane027
    z,0
    material {
      Dark_grey
    }
    rotate <-180.0, 0.0, -180.0>
    translate  <36.0, 0.0, 0.4>
  }
  plane { // Plane028
    z,0
    material {
      Dark_grey
    }
    rotate -90.0*y
    translate  <36.0, 0.0, 0.4>
  }
}
#declare CSG284 = union {
  torus { // Torus011
    0.4, 0.1  rotate -x*90
    material {
      Dark_grey
    }
    rotate -90.0*x
    translate  <36.0, 0.1, -0.4>
  }
  torus { // Torus012
    0.4, 0.1  rotate -x*90
    material {
      Dark_grey
    }
    rotate -90.0*x
    translate  <36.0, -0.1, -0.4>
  }
}
#declare CSG285 = intersection {
  object { CSG284 }
  plane { // Plane030
    z,0
    material {
      Dark_grey
    }
    translate  <36.0, 0.0, -0.4>
  }
  plane { // Plane029
    z,0
    material {
      Dark_grey
    }
    rotate <-0.0, -146.148315, -0.0>
    translate  <36.0, 0.0, -0.4>
  }
}
#declare Group110 = union {
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.05, 0.4, 0.4>
    translate  36.55*x
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.3, 0.3, 1.0>
    rotate -90.0*x
    translate  <36.0, -0.5, 0.4>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.3, 0.3, 1.0>
    rotate -90.0*x
    translate  <36.0, -0.5, -0.4>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.6, 0.1, 0.4>
    translate  <36.0, -0.5, 0.0>
  }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <0.6, 0.1, 0.4>
    translate  <36.0, 0.5, 0.0>
  }
  cylinder { // Cylndr1431
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <-0.6, -0.6, -0.2>
    rotate <90.0, 0.0, -180.0>
    translate  <36.0, -0.4, 0.4>
  }
  cylinder { // Cylndr1432
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <-0.6, -0.6, -0.2>
    rotate <90.0, 0.0, -180.0>
    translate  <36.0, -0.4, -0.4>
  }
  cylinder { // Cylndr1433
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.6, 0.6, 0.2>
    rotate -90.0*x
    translate  <36.0, 0.4, -0.4>
  }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <6.0, 0.4, 0.4>
    translate  30.0*x
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <6.0, 0.7, 0.7>
    translate  18.0*x
  }
  object { CSG273 }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    material {
      lightblue
    }
    scale <6.0, 1.0, 1.0>
    translate  6.0*x
  }
  cylinder { // Cylndr1435
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <0.6, 0.6, 0.2>
    rotate -90.0*x
    translate  <36.0, 0.4, 0.4>
  }
  object { CSG275 }
  object { CSG277 }
  object { CSG278 }
  object { CSG279 }
  object { CSG280 }
  object { CSG281 }
  cylinder { // Cylndr1444
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <0.1, 0.1, 23.6>
    rotate 90.0*y
    translate  <-0.05, 0.1, 1.73>
  }
  cylinder { // Cylndr1445
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <0.1, 0.1, 23.6>
    rotate 90.0*y
    translate  <-0.05, -0.1, 1.73>
  }
  cylinder { // Cylndr1446
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <0.1, 0.1, 12.5>
    rotate <180.0, 85.731476, 180.0>
    translate  <23.55, -0.1, 1.73>
  }
  cylinder { // Cylndr1447
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <0.1, 0.1, 12.5>
    rotate <180.0, 85.731476, 180.0>
    translate  <23.55, 0.1, 1.73>
  }
  cylinder { // Cylndr1448
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <-0.1, -0.1, -0.8>
    rotate <0.0, 0.0, 180.0>
    translate  <36.4, -0.1, 0.4>
  }
  cylinder { // Cylndr1449
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <-0.1, -0.1, -0.8>
    rotate <0.0, 0.0, 180.0>
    translate  <36.4, 0.1, 0.4>
  }
  object { CSG283 }
  object { CSG285 }
  cylinder { // Cylndr1473
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <-0.1, -0.1, 30.0>
    rotate <0.0, -146.148315, -0.0>
    translate  <36.33114, -0.1, -0.623417>
  }
  cylinder { // Cylndr1474
    <0,0,1>, <0,0,0>, 1 
    material {
      Dark_grey
    }
    scale <-0.1, -0.1, 30.0>
    rotate -146.148315*y
    translate  <36.33114, 0.1, -0.62342>
  }
  rotate <0.0, -33.851692, -0.0>
  translate  <1.0, 0.0, 10.5>
}
// Include contains 'TransSweep067'
#include "ww2fort_helper.in2"

#declare TransSweep067 = object {
  TransSweep067_Raw
  material {
    lightblue
  }
  scale <-1.0, -1.0, -0.3>
  rotate <-90.0, 0.0, -180.0>
  translate  <-1.0, 2.1, 7.5>
}
// Include contains 'TransSweep068'
#include "ww2fort_helper.in3"

#declare TransSweep068 = object {
  TransSweep068_Raw
  material {
    lightblue
  }
  scale <1.0, 1.0, 0.3>
  rotate 90.0*x
  translate  <-1.0, -2.1, 7.5>
}
// Include contains 'TransSweep069'
#include "ww2fort_helper.in4"

#declare TransSweep069 = object {
  TransSweep069_Raw
  material {
    lightblue
  }
  scale <-1.0, -1.0, -0.5>
  rotate <-90.0, 0.0, -180.0>
  translate  <-1.0, 2.0, 7.5>
}
// Include contains 'TransSweep070'
#include "ww2fort_helper.in5"

#declare TransSweep070 = object {
  TransSweep070_Raw
  material {
    lightblue
  }
  scale <1.0, 1.0, 0.5>
  rotate 90.0*x
  translate  <-1.0, -2.0, 7.5>
}
// Include contains 'TransSweep071'
#include "ww2fort_helper.in6"

#declare TransSweep071 = object {
  TransSweep071_Raw
  material {
    lightblue
  }
  scale -1.0
  rotate <-90.0, 0.0, -180.0>
  translate  <1.0, 2.0, 8.5>
}
// Include contains 'TransSweep072'
#include "ww2fort_helper.in7"

#declare TransSweep072 = object {
  TransSweep072_Raw
  material {
    lightblue
  }
  rotate 90.0*x
  translate  <1.0, -2.0, 8.5>
}
#declare BezPtch017 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000009, 0.757316, 0.092446>, <-0.000009, 0.757320, 0.092446>, <-0.000004, 0.757325, 0.092446>, <-0.000000, 0.757325, 0.092446>, 
      <-0.200000, 0.676690, -0.635801>, <-0.200000, 0.744295, -0.709486>, <-0.100000, 0.811900, -0.783172>, <0.000000, 0.811900, -0.783172>, 
      <-0.200000, 0.205073, -0.801662>, <-0.200000, 0.199380, -0.901500>, <-0.100000, 0.193688, -1.001337>, <0.000000, 0.193688, -1.001337>, 
      <-0.200000, -0.133496, -0.671917>, <-0.200000, -0.176900, -0.746952>, <-0.100000, -0.221609, -0.824212>, <0.000000, -0.224301, -0.824212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000000, 0.757325, 0.092446>, <0.000004, 0.757325, 0.092446>, <0.000009, 0.757320, 0.092446>, <0.000009, 0.757316, 0.092446>, 
      <0.000000, 0.811900, -0.783172>, <0.100000, 0.811900, -0.783172>, <0.200000, 0.744295, -0.709486>, <0.200000, 0.676690, -0.635801>, 
      <0.000000, 0.193688, -1.001337>, <0.100000, 0.193688, -1.001337>, <0.200000, 0.199380, -0.901500>, <0.200000, 0.205073, -0.801662>, 
      <0.000000, -0.224301, -0.824212>, <0.100000, -0.221609, -0.824212>, <0.200000, -0.176900, -0.746952>, <0.200000, -0.133496, -0.671917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000009, 0.757316, 0.092446>, <0.000009, 0.757311, 0.092446>, <0.000004, 0.757311, 0.092446>, <-0.000000, 0.757311, 0.092446>, 
      <0.200000, 0.676690, -0.635801>, <0.200000, 0.609085, -0.562115>, <0.100000, 0.609085, -0.562115>, <0.000000, 0.609085, -0.562115>, 
      <0.200000, 0.205073, -0.801662>, <0.200000, 0.210765, -0.701824>, <0.100000, 0.210765, -0.701824>, <0.000000, 0.210765, -0.701824>, 
      <0.200000, -0.133496, -0.671917>, <0.200000, -0.084708, -0.596883>, <0.100000, -0.084708, -0.596883>, <0.000000, -0.087400, -0.596883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000000, 0.757311, 0.092446>, <-0.000004, 0.757311, 0.092446>, <-0.000009, 0.757311, 0.092446>, <-0.000009, 0.757316, 0.092446>, 
      <0.000000, 0.609085, -0.562115>, <-0.100000, 0.609085, -0.562115>, <-0.200000, 0.609085, -0.562115>, <-0.200000, 0.676690, -0.635801>, 
      <0.000000, 0.210765, -0.701824>, <-0.100000, 0.210765, -0.701824>, <-0.200000, 0.210765, -0.701824>, <-0.200000, 0.205073, -0.801662>, 
      <0.000000, -0.087400, -0.596883>, <-0.100000, -0.084708, -0.596883>, <-0.200000, -0.084708, -0.596883>, <-0.200000, -0.133496, -0.671917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.200000, -0.133496, -0.671917>, <-0.200000, -0.176900, -0.746952>, <-0.100000, -0.221609, -0.824212>, <0.000000, -0.224301, -0.824212>, 
      <-0.200000, -0.466680, -0.542173>, <-0.200000, -0.553180, -0.592405>, <-0.100000, -0.636906, -0.647086>, <0.000000, -0.636906, -0.647086>, 
      <-0.200000, -0.635155, -0.092167>, <-0.200000, -0.734402, -0.104416>, <-0.100000, -0.833649, -0.116665>, <0.000000, -0.833649, -0.116665>, 
      <-0.200000, -0.463841, 0.193760>, <-0.200000, -0.557892, 0.204361>, <-0.100000, -0.654635, 0.214962>, <0.000000, -0.657327, 0.214962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.224301, -0.824212>, <0.100000, -0.221609, -0.824212>, <0.200000, -0.176900, -0.746952>, <0.200000, -0.133496, -0.671917>, 
      <0.000000, -0.636906, -0.647086>, <0.100000, -0.636906, -0.647086>, <0.200000, -0.553180, -0.592405>, <0.200000, -0.466680, -0.542173>, 
      <0.000000, -0.833649, -0.116665>, <0.100000, -0.833649, -0.116665>, <0.200000, -0.734402, -0.104416>, <0.200000, -0.635155, -0.092167>, 
      <0.000000, -0.657327, 0.214962>, <0.100000, -0.654635, 0.214962>, <0.200000, -0.557892, 0.204361>, <0.200000, -0.463841, 0.193760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200000, -0.133496, -0.671917>, <0.200000, -0.084708, -0.596883>, <0.100000, -0.084708, -0.596883>, <0.000000, -0.087400, -0.596883>, 
      <0.200000, -0.466680, -0.542173>, <0.200000, -0.380180, -0.491941>, <0.100000, -0.380180, -0.491941>, <0.000000, -0.380180, -0.491941>, 
      <0.200000, -0.635155, -0.092167>, <0.200000, -0.535908, -0.079919>, <0.100000, -0.535908, -0.079919>, <0.000000, -0.535908, -0.079919>, 
      <0.200000, -0.463841, 0.193760>, <0.200000, -0.364405, 0.183160>, <0.100000, -0.364405, 0.183160>, <0.000000, -0.367097, 0.183160>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.087400, -0.596883>, <-0.100000, -0.084708, -0.596883>, <-0.200000, -0.084708, -0.596883>, <-0.200000, -0.133496, -0.671917>, 
      <0.000000, -0.380180, -0.491941>, <-0.100000, -0.380180, -0.491941>, <-0.200000, -0.380180, -0.491941>, <-0.200000, -0.466680, -0.542173>, 
      <0.000000, -0.535908, -0.079919>, <-0.100000, -0.535908, -0.079919>, <-0.200000, -0.535908, -0.079919>, <-0.200000, -0.635155, -0.092167>, 
      <0.000000, -0.367097, 0.183160>, <-0.100000, -0.364405, 0.183160>, <-0.200000, -0.364405, 0.183160>, <-0.200000, -0.463841, 0.193760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.200000, -0.463841, 0.193760>, <-0.200000, -0.557892, 0.204361>, <-0.100000, -0.654635, 0.214962>, <0.000000, -0.657327, 0.214962>, 
      <-0.200000, -0.287143, 0.479688>, <-0.200000, -0.381383, 0.513138>, <-0.100000, -0.475622, 0.546588>, <0.000000, -0.475622, 0.546588>, 
      <-0.200000, 0.053838, 0.889232>, <-0.200000, -0.046162, 0.889232>, <-0.100000, -0.146162, 0.889232>, <0.000000, -0.146162, 0.889232>, 
      <-0.200000, 0.053838, 1.298529>, <-0.200000, -0.046162, 1.298529>, <-0.100000, -0.146162, 1.298529>, <0.000000, -0.146162, 1.298529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.657327, 0.214962>, <0.100000, -0.654635, 0.214962>, <0.200000, -0.557892, 0.204361>, <0.200000, -0.463841, 0.193760>, 
      <0.000000, -0.475622, 0.546588>, <0.100000, -0.475622, 0.546588>, <0.200000, -0.381383, 0.513138>, <0.200000, -0.287143, 0.479688>, 
      <0.000000, -0.146162, 0.889232>, <0.100000, -0.146162, 0.889232>, <0.200000, -0.046162, 0.889232>, <0.200000, 0.053838, 0.889232>, 
      <0.000000, -0.146162, 1.298529>, <0.100000, -0.146162, 1.298529>, <0.200000, -0.046162, 1.298529>, <0.200000, 0.053838, 1.298529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200000, -0.463841, 0.193760>, <0.200000, -0.364405, 0.183160>, <0.100000, -0.364405, 0.183160>, <0.000000, -0.367097, 0.183160>, 
      <0.200000, -0.287143, 0.479688>, <0.200000, -0.192903, 0.446238>, <0.100000, -0.192903, 0.446238>, <0.000000, -0.192903, 0.446238>, 
      <0.200000, 0.053838, 0.889232>, <0.200000, 0.153838, 0.889232>, <0.100000, 0.153838, 0.889232>, <0.000000, 0.153838, 0.889232>, 
      <0.200000, 0.053838, 1.298529>, <0.200000, 0.153838, 1.298529>, <0.100000, 0.153838, 1.298529>, <0.000000, 0.153838, 1.298529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.367097, 0.183160>, <-0.100000, -0.364405, 0.183160>, <-0.200000, -0.364405, 0.183160>, <-0.200000, -0.463841, 0.193760>, 
      <0.000000, -0.192903, 0.446238>, <-0.100000, -0.192903, 0.446238>, <-0.200000, -0.192903, 0.446238>, <-0.200000, -0.287143, 0.479688>, 
      <0.000000, 0.153838, 0.889232>, <-0.100000, 0.153838, 0.889232>, <-0.200000, 0.153838, 0.889232>, <-0.200000, 0.053838, 0.889232>, 
      <0.000000, 0.153838, 1.298529>, <-0.100000, 0.153838, 1.298529>, <-0.200000, 0.153838, 1.298529>, <-0.200000, 0.053838, 1.298529>
    }
  }
  material {
    B_Silver
  }
  rotate -180.0*z
  translate  <31.515, 0.0, -2.6>
}
#declare TransSweep073 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.2, -0.3>,
  <0.5, -0.4>,
  <0.5, 0.4>,
  <-0.2, 0.3>,
  <-0.2, -0.3>
  rotate -x*90
  material {
    Main_grey
  }
  scale <1.0, 1.0, 0.44>
  rotate <-180.0, -90.0, 0.0>
  translate  <31.3, 0.0, -0.5>
}
#declare Crane = union {
  object { Group110 }
  cylinder { // Cylndr1458
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <1.0, 1.0, 0.1>
    rotate <-90.0, -90.0, 0.0>
    translate  <1.0, -2.0, 10.5>
  }
  cylinder { // Cylndr1459
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <-1.0, -1.0, -0.1>
    rotate <90.0, 90.0, 0.0>
    translate  <1.0, 2.0, 10.5>
  }
  cylinder { // Cylndr1460
    <0,0,1>, <0,0,0>, 1 
    material {
      lightblue
    }
    scale <1.0, 1.0, 6.6>
    rotate <-90.0, -90.0, 0.0>
    translate  <-7.0, -3.3, 15.0>
  }
  object { TransSweep067 }
  object { TransSweep068 }
  cylinder { // Cylndr1461
    <0,0,1>, <0,0,0>, 1 
    material {
      Cranecabletxtr
    }
    scale <0.4, 0.4, 3.8>
    rotate <-90.0, -90.0, 0.0>
    translate  <-1.75, -1.9, 8.75>
  }
  cylinder { // Cylndr1462
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.5, 0.5, 0.1>
    rotate <-90.0, -90.0, 0.0>
    translate  <-1.75, -2.0, 8.75>
  }
  cylinder { // Cylndr1463
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <-0.5, -0.5, -0.1>
    rotate <90.0, 90.0, 0.0>
    translate  <-1.75, 2.0, 8.75>
  }
  cylinder { // Cylndr1464
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <-0.5, -0.5, -0.1>
    rotate <90.0, 90.0, 0.0>
    translate  <-1.75, 2.6, 8.75>
  }
  cylinder { // Cylndr1465
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.5, 0.5, 0.1>
    rotate <-90.0, -90.0, 0.0>
    translate  <-1.75, -2.6, 8.75>
  }
  cylinder { // Cylndr1466
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.2, 0.2, 5.4>
    rotate <-90.0, -90.0, 0.0>
    translate  <-1.75, -2.7, 8.75>
  }
  object { TransSweep069 }
  object { TransSweep070 }
  cylinder { // Cylndr1467
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <-1.0, -1.0, -0.1>
    rotate <90.0, 90.0, 0.0>
    translate  <1.0, 3.1, 10.5>
  }
  cylinder { // Cylndr1468
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.5, 0.5, 6.6>
    rotate <-90.0, -90.0, 0.0>
    translate  <1.0, -3.3, 10.5>
  }
  cylinder { // Cylndr1469
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <1.0, 1.0, 0.1>
    rotate <-90.0, -90.0, 0.0>
    translate  <1.0, -3.1, 10.5>
  }
  object { TransSweep071 }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    material {
      Main_grey
    }
    scale <3.5, 3.5, 0.5>
    translate  7.0*z
  }
  object { TransSweep072 }
  torus { // Torus013
    0.35, 0.05  rotate -x*90
    material {
      B_Silver
    }
    rotate <-180.0, -90.0, 0.0>
    translate  <31.515, 0.0, -1.1>
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      B_Silver
    }
    scale 0.2
    rotate -180.0*z
    translate  <31.515, 0.0, -1.4>
  }
  object { BezPtch017 }
  object { TransSweep073 }
  cylinder { // Cylndr1475
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.4, 0.4, 0.44>
    rotate <-180.0, -90.0, 0.0>
    translate  <31.3, 0.0, 0.0>
  }
  cylinder { // Cylndr1476
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <0.3, 0.3, 0.44>
    rotate <-180.0, -90.0, 0.0>
    translate  <31.3, 0.0, -0.7>
  }
  rotate -153.261841*z
  translate  <81.0, -13.0, 29.0>
}
#declare Cranegroup = union {
  object { Cranebase }
  object { Crane }
}
#declare Crate = union {
  torus { // Torus014
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <3.346173, -14.099608, -0.01971>
}
#declare Crate1 = union {
  torus { // Torus015
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <3.0, -9.0, -1.7>
}
#declare Crate2 = union {
  torus { // Torus016
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <3.0, -4.0, -1.7>
}
#declare Crate3 = union {
  torus { // Torus017
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <3.0, 1.0, -1.7>
}
#declare Crate4 = union {
  torus { // Torus018
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <12.0, 1.0, -1.7>
}
#declare Crate5 = union {
  torus { // Torus019
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <12.0, -4.0, -1.7>
}
#declare Crate6 = union {
  torus { // Torus020
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <10.0, 25.0, -1.7>
}
#declare Crate7 = union {
  torus { // Torus021
    1.2, 0.1  rotate -x*90
    material {
      B_Silver
    }
    rotate -90.0*x
    translate  <49.485, -13.0, 24.7>
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 1.9, 2.1>
    translate  <53.54, -13.0, 22.5>
  }
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -14.0, 22.5>
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    material {
      Light_grey
      rotate <45.0, 0.0, -0.0>
    }
    scale <0.05, 0.9, 2.1>
    translate  <45.54, -12.0, 22.5>
  }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cratetxtr
      rotate <45.0, 0.0, -0.0>
    }
    scale <4.0, 2.0, 2.2>
    translate  <49.54, -13.0, 22.5>
  }
  translate  <10.0, 30.0, -1.7>
}
#declare Crates = union {
  object { Crate }
  object { Crate1 }
  object { Crate2 }
  object { Crate3 }
  object { Crate4 }
  object { Crate5 }
  object { Crate6 }
  object { Crate7 }
}
union { // Landstructure
  object { BuildingGroup }
  object { StructureBase }
  object { Smallbuilding }
  object { Basement }
  object { Silodoors }
  object { Cranegroup }
  object { Crates }
}


#declare HgtFld001 = object { 
  height_field {
    tga "E:\3D-Renderings\irtc\sceneryheightfield4.tga"
    water_level 0.01
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mountains
  }
  scale <200.0, 200.0, 43.0>
  translate  <0.0, 20.0, 43.0>
}
difference { // Ground
  object { HgtFld001 }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <72.0, 52.0, 23.55561>
    material {
      Main_grey
      // Transform to world space
      translate  <0.380161, -0.040764, 0.0>
    }
  }
  translate  <-0.380161, 0.040764, 0.0>
}


#declare CSG134 = intersection {
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  7.0*z
  }
  plane { // Plane015
    z,0
    scale <5.0, 3.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -4.0, 7.24>
  }
  plane { // Plane016
    z,0
    scale <5.0, 3.0, 1.0>
    rotate -70.0*x
    translate  <0.0, 4.0, 7.24>
  }
  plane { // Plane017
    z,0
    scale <3.0, 5.0, 1.0>
    rotate -70.0*y
    translate  <-4.0, 0.0, 7.24>
  }
  plane { // Plane018
    z,0
    scale <3.8, 5.0, 1.0>
    rotate 50.0*y
    translate  <2.7, 0.0, 7.24>
  }
}
#declare CSG135 = difference {
  object { CSG134 }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 0.0, 7.82>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 2.2, 7.82>
  }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, -2.2, 7.82>
  }
}
#declare CSG136 = union {
  cylinder { // Cylndr803
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
  cylinder { // Cylndr804
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr805
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
}
#declare CSG137 = union {
  cylinder { // Cylndr806
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr807
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
  cylinder { // Cylndr808
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
}
#declare CSG138 = difference {
  object { CSG136 }
  object { CSG137 }
}
#declare Cannon3 = union {
  cylinder { // Cylndr800
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -0.5, 7.64>
  }
  cylinder { // Cylndr801
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -2.7, 7.64>
  }
  cylinder { // Cylndr802
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <2.0, 2.7, 7.64>
  }
  object { CSG135 }
  object { CSG138 }
  cylinder { // Cylndr809
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_1
    }
    scale <4.5, 4.5, 1.0>
    translate  3.0*z
  }
  material {
    cannonmaterial
  }
  rotate -145.08551*z
  translate  <-68.833427, -31.408952, 41.0>
}
#declare TransSweep029 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG120 = union {
  cylinder { // Cylndr729
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr730
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr731
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr732
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr733
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr734
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG121 = union {
  cylinder { // Cylndr735
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr736
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr737
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr738
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr739
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr740
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG122 = difference {
  object { CSG120 }
  object { CSG121 }
}
#declare Group039 = union {
  cylinder { // Cylndr726
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr727
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr728
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG122 }
  cylinder { // Cylndr741
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG123 = union {
  cylinder { // Cylndr745
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr746
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr747
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr748
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr749
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr750
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG124 = union {
  cylinder { // Cylndr751
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr752
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr753
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr754
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr755
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr756
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG125 = difference {
  object { CSG123 }
  object { CSG124 }
}
#declare Group045 = union {
  cylinder { // Cylndr742
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr743
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr744
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG125 }
  cylinder { // Cylndr757
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG126 = union {
  cylinder { // Cylndr761
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr762
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr763
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr764
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr765
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr766
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG127 = union {
  cylinder { // Cylndr767
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr768
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr769
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr770
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr771
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr772
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG128 = difference {
  object { CSG126 }
  object { CSG127 }
}
#declare Group051 = union {
  cylinder { // Cylndr758
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr759
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr760
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG128 }
  cylinder { // Cylndr773
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG129 = union {
  cylinder { // Cylndr777
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr778
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr779
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr780
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr781
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr782
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG130 = union {
  cylinder { // Cylndr783
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr784
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr785
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr786
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr787
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr788
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG131 = difference {
  object { CSG129 }
  object { CSG130 }
}
#declare Group052 = union {
  cylinder { // Cylndr774
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr775
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr776
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG131 }
  cylinder { // Cylndr789
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG132 = union {
  cylinder { // Cylndr790
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr791
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr792
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr793
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG133 = difference {
  object { CSG132 }
  cylinder { // Cylndr794
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr795
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr796
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr797
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group053 = union {
  object { Group039 }
  object { Group045 }
  object { Group051 }
  object { Group052 }
  object { CSG133 }
  cone { // Cone029
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone030
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone031
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone032
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr798
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep030 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group054 = union {
  cylinder { // Cylndr723
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr724
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep029 }
  cylinder { // Cylndr725
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group053 }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep030 }
  cylinder { // Cylndr799
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate -38.08905*z
  translate  <0.0, -5.0, 1.8>
}
#declare TransSweep061 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG211 = union {
  cylinder { // Cylndr1150
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1151
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1152
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1153
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1154
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1155
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG212 = union {
  cylinder { // Cylndr1156
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1157
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1158
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1159
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1160
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1161
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG213 = difference {
  object { CSG211 }
  object { CSG212 }
}
#declare Group055 = union {
  cylinder { // Cylndr1147
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1148
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1149
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG213 }
  cylinder { // Cylndr1162
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG214 = union {
  cylinder { // Cylndr1166
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1167
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1168
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1169
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1170
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1171
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG215 = union {
  cylinder { // Cylndr1172
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1173
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1174
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1175
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1176
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1177
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG216 = difference {
  object { CSG214 }
  object { CSG215 }
}
#declare Group056 = union {
  cylinder { // Cylndr1163
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1164
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1165
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG216 }
  cylinder { // Cylndr1178
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG217 = union {
  cylinder { // Cylndr1182
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1183
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1184
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1185
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1186
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1187
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG218 = union {
  cylinder { // Cylndr1188
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1189
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1190
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1191
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1192
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1193
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG219 = difference {
  object { CSG217 }
  object { CSG218 }
}
#declare Group057 = union {
  cylinder { // Cylndr1179
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1180
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1181
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG219 }
  cylinder { // Cylndr1194
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG220 = union {
  cylinder { // Cylndr1198
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1199
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1200
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1201
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1202
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1203
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG221 = union {
  cylinder { // Cylndr1204
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1205
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1206
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1207
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1208
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1209
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG222 = difference {
  object { CSG220 }
  object { CSG221 }
}
#declare Group086 = union {
  cylinder { // Cylndr1195
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1196
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1197
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG222 }
  cylinder { // Cylndr1210
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG223 = union {
  cylinder { // Cylndr1211
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1212
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1213
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr1214
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG224 = difference {
  object { CSG223 }
  cylinder { // Cylndr1215
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1216
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1217
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1218
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group087 = union {
  object { Group055 }
  object { Group056 }
  object { Group057 }
  object { Group086 }
  object { CSG224 }
  cone { // Cone058
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone059
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone060
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone061
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1219
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep062 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group088 = union {
  cylinder { // Cylndr1144
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr1145
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep061 }
  cylinder { // Cylndr1146
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group087 }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep062 }
  cylinder { // Cylndr1220
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate -52.250614*z
  translate  <-5.0, 0.0, 1.8>
}
#declare TransSweep063 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG225 = union {
  cylinder { // Cylndr1227
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1228
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1229
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1230
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1231
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1232
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG226 = union {
  cylinder { // Cylndr1233
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1234
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1235
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1236
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1237
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1238
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG227 = difference {
  object { CSG225 }
  object { CSG226 }
}
#declare Group089 = union {
  cylinder { // Cylndr1224
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1225
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1226
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG227 }
  cylinder { // Cylndr1239
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG228 = union {
  cylinder { // Cylndr1243
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1244
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1245
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1246
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1247
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1248
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG229 = union {
  cylinder { // Cylndr1249
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1250
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1251
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1252
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1253
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1254
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG230 = difference {
  object { CSG228 }
  object { CSG229 }
}
#declare Group090 = union {
  cylinder { // Cylndr1240
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1241
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1242
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG230 }
  cylinder { // Cylndr1255
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG231 = union {
  cylinder { // Cylndr1259
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1260
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1261
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1262
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1263
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1264
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG232 = union {
  cylinder { // Cylndr1265
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1266
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1267
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1268
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1269
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1270
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG233 = difference {
  object { CSG231 }
  object { CSG232 }
}
#declare Group091 = union {
  cylinder { // Cylndr1256
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1257
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1258
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG233 }
  cylinder { // Cylndr1271
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG234 = union {
  cylinder { // Cylndr1275
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1276
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1277
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1278
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1279
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1280
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG235 = union {
  cylinder { // Cylndr1281
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1282
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1283
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1284
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1285
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1286
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG236 = difference {
  object { CSG234 }
  object { CSG235 }
}
#declare Group092 = union {
  cylinder { // Cylndr1272
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1273
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1274
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG236 }
  cylinder { // Cylndr1287
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG237 = union {
  cylinder { // Cylndr1288
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1289
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1290
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr1291
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG238 = difference {
  object { CSG237 }
  cylinder { // Cylndr1292
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1293
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1294
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1295
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group093 = union {
  object { Group089 }
  object { Group090 }
  object { Group091 }
  object { Group092 }
  object { CSG238 }
  cone { // Cone062
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone063
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone064
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone065
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1296
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep064 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group094 = union {
  cylinder { // Cylndr1221
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr1222
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep063 }
  cylinder { // Cylndr1223
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group093 }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep064 }
  cylinder { // Cylndr1297
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate 112.818687*z
  translate  <0.0, 5.0, 1.8>
}
#declare TransSweep065 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG239 = union {
  cylinder { // Cylndr1304
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1305
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1306
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1307
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1308
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1309
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG240 = union {
  cylinder { // Cylndr1310
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1311
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1312
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1313
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1314
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1315
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG241 = difference {
  object { CSG239 }
  object { CSG240 }
}
#declare Group095 = union {
  cylinder { // Cylndr1301
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1302
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1303
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG241 }
  cylinder { // Cylndr1316
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG242 = union {
  cylinder { // Cylndr1320
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1321
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1322
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1323
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1324
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1325
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG243 = union {
  cylinder { // Cylndr1326
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1327
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1328
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1329
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1330
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1331
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG244 = difference {
  object { CSG242 }
  object { CSG243 }
}
#declare Group096 = union {
  cylinder { // Cylndr1317
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1318
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1319
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG244 }
  cylinder { // Cylndr1332
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG245 = union {
  cylinder { // Cylndr1336
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1337
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1338
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1339
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1340
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1341
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG246 = union {
  cylinder { // Cylndr1342
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1343
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1344
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1345
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1346
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1347
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG247 = difference {
  object { CSG245 }
  object { CSG246 }
}
#declare Group097 = union {
  cylinder { // Cylndr1333
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1334
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1335
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG247 }
  cylinder { // Cylndr1348
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG248 = union {
  cylinder { // Cylndr1352
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1353
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1354
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1355
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1356
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1357
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG249 = union {
  cylinder { // Cylndr1358
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1359
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1360
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1361
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1362
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1363
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG250 = difference {
  object { CSG248 }
  object { CSG249 }
}
#declare Group098 = union {
  cylinder { // Cylndr1349
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1350
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1351
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG250 }
  cylinder { // Cylndr1364
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG251 = union {
  cylinder { // Cylndr1365
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1366
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1367
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr1368
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG252 = difference {
  object { CSG251 }
  cylinder { // Cylndr1369
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1370
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1371
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1372
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group099 = union {
  object { Group095 }
  object { Group096 }
  object { Group097 }
  object { Group098 }
  object { CSG252 }
  cone { // Cone066
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone067
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone068
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone069
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1373
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep066 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group100 = union {
  cylinder { // Cylndr1298
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr1299
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep065 }
  cylinder { // Cylndr1300
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group099 }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep066 }
  cylinder { // Cylndr1374
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate 90.0*z
  translate  <5.0, -0.0, 1.8>
}
#declare AAbattery1 = union {
  object { Group054 }
  object { Group088 }
  object { Group094 }
  object { Group100 }
  material {
    B_Silver
  }
  translate  <112.216529, -45.699372, 71.472549>
}
#declare CSG073 = intersection {
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  7.0*z
  }
  plane { // Plane011
    z,0
    scale <5.0, 3.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -4.0, 7.24>
  }
  plane { // Plane019
    z,0
    scale <5.0, 3.0, 1.0>
    rotate -70.0*x
    translate  <0.0, 4.0, 7.24>
  }
  plane { // Plane020
    z,0
    scale <3.0, 5.0, 1.0>
    rotate -70.0*y
    translate  <-4.0, 0.0, 7.24>
  }
  plane { // Plane021
    z,0
    scale <3.8, 5.0, 1.0>
    rotate 50.0*y
    translate  <2.7, 0.0, 7.24>
  }
}
#declare CSG074 = difference {
  object { CSG073 }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 0.0, 7.82>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 2.2, 7.82>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, -2.2, 7.82>
  }
}
#declare CSG075 = union {
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
}
#declare CSG076 = union {
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
}
#declare CSG077 = difference {
  object { CSG075 }
  object { CSG076 }
}
#declare Cannon2 = union {
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -0.5, 7.64>
  }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -2.7, 7.64>
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <2.0, 2.7, 7.64>
  }
  object { CSG074 }
  object { CSG077 }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_1
    }
    scale <4.5, 4.5, 1.0>
    translate  3.0*z
  }
  material {
    cannonmaterial
  }
  rotate -107.051437*z
  translate  <-70.696509, -78.547976, 41.0>
}
#declare CSG068 = intersection {
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  7.0*z
  }
  plane { // Plane005
    z,0
    scale <5.0, 3.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -4.0, 7.24>
  }
  plane { // Plane006
    z,0
    scale <5.0, 3.0, 1.0>
    rotate -70.0*x
    translate  <0.0, 4.0, 7.24>
  }
  plane { // Plane022
    z,0
    scale <3.0, 5.0, 1.0>
    rotate -70.0*y
    translate  <-4.0, 0.0, 7.24>
  }
  plane { // Plane023
    z,0
    scale <3.8, 5.0, 1.0>
    rotate 50.0*y
    translate  <2.7, 0.0, 7.24>
  }
}
#declare CSG069 = difference {
  object { CSG068 }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 0.0, 7.82>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 2.2, 7.82>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, -2.2, 7.82>
  }
}
#declare CSG070 = union {
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
}
#declare CSG071 = union {
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
}
#declare CSG072 = difference {
  object { CSG070 }
  object { CSG071 }
}
#declare Cannon1 = union {
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -0.5, 7.64>
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -2.7, 7.64>
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <2.0, 2.7, 7.64>
  }
  object { CSG069 }
  object { CSG072 }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_1
    }
    scale <4.5, 4.5, 1.0>
    translate  3.0*z
  }
  material {
    cannonmaterial
  }
  rotate -81.046593*z
  translate  <74.456568, -79.056989, 41.0>
}
#declare CSG253 = intersection {
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  7.0*z
  }
  plane { // Plane001
    z,0
    scale <5.0, 3.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -4.0, 7.24>
  }
  plane { // Plane002
    z,0
    scale <5.0, 3.0, 1.0>
    rotate -70.0*x
    translate  <0.0, 4.0, 7.24>
  }
  plane { // Plane003
    z,0
    scale <3.0, 5.0, 1.0>
    rotate -70.0*y
    translate  <-4.0, 0.0, 7.24>
  }
  plane { // Plane004
    z,0
    scale <3.8, 5.0, 1.0>
    rotate 50.0*y
    translate  <2.7, 0.0, 7.24>
  }
}
#declare CSG254 = difference {
  object { CSG253 }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 0.0, 7.82>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, 2.2, 7.82>
  }
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.9>
    translate  <1.1, -2.2, 7.82>
  }
}
#declare CSG255 = union {
  cylinder { // Cylndr1377
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
  cylinder { // Cylndr1378
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr1379
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
}
#declare CSG256 = union {
  cylinder { // Cylndr1380
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 2.2, 7.64>
  }
  cylinder { // Cylndr1381
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, 0.0, 7.64>
  }
  cylinder { // Cylndr1382
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.1>
    rotate 70.0*y
    translate  <2.0, -2.2, 7.64>
  }
}
#declare CSG257 = difference {
  object { CSG255 }
  object { CSG256 }
}
#declare Cannon4 = union {
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -0.5, 7.64>
  }
  cylinder { // Cylndr1375
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    rotate -90.0*x
    translate  <2.0, -2.7, 7.64>
  }
  cylinder { // Cylndr1376
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -1.0>
    rotate <90.0, 0.0, -180.0>
    translate  <2.0, 2.7, 7.64>
  }
  object { CSG254 }
  object { CSG257 }
  cylinder { // Cylndr1383
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_1
    }
    scale <4.5, 4.5, 1.0>
    translate  3.0*z
  }
  material {
    cannonmaterial
  }
  rotate -73.436897*z
  translate  <-14.184725, -91.842372, 41.0>
}
#declare TransSweep013 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG014 = union {
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG015 = union {
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG016 = difference {
  object { CSG014 }
  object { CSG015 }
}
#declare Group010 = union {
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG016 }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG011 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG012 = union {
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG013 = difference {
  object { CSG011 }
  object { CSG012 }
}
#declare Group011 = union {
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG013 }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG008 = union {
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG009 = union {
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG010 = difference {
  object { CSG008 }
  object { CSG009 }
}
#declare Group012 = union {
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG010 }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG007 = union {
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG017 = union {
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG018 = difference {
  object { CSG007 }
  object { CSG017 }
}
#declare Group013 = union {
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG018 }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG019 = union {
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG020 = difference {
  object { CSG019 }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group014 = union {
  object { Group010 }
  object { Group011 }
  object { Group012 }
  object { Group013 }
  object { CSG020 }
  cone { // Cone004
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone003
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone002
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone005
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep014 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group015 = union {
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep013 }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group014 }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep014 }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    B_Silver
  }
  scale 0.4
  rotate -11.198862*z
  translate  <0.0, -5.0, 1.8>
}
#declare TransSweep015 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG021 = union {
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG022 = union {
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG023 = difference {
  object { CSG021 }
  object { CSG022 }
}
#declare Group016 = union {
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG023 }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG024 = union {
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG025 = union {
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG026 = difference {
  object { CSG024 }
  object { CSG025 }
}
#declare Group017 = union {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG026 }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG027 = union {
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG028 = union {
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG029 = difference {
  object { CSG027 }
  object { CSG028 }
}
#declare Group018 = union {
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG029 }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG030 = union {
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG031 = union {
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG032 = difference {
  object { CSG030 }
  object { CSG031 }
}
#declare Group019 = union {
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG032 }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG033 = union {
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG034 = difference {
  object { CSG033 }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group020 = union {
  object { Group016 }
  object { Group017 }
  object { Group018 }
  object { Group019 }
  object { CSG034 }
  cone { // Cone006
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone007
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone008
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone009
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep016 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group021 = union {
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep015 }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group020 }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep016 }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate -57.458298*z
  translate  <-5.0, 0.0, 1.8>
}
#declare TransSweep017 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG035 = union {
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG036 = union {
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG037 = difference {
  object { CSG035 }
  object { CSG036 }
}
#declare Group022 = union {
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG037 }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG038 = union {
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG039 = union {
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG040 = difference {
  object { CSG038 }
  object { CSG039 }
}
#declare Group023 = union {
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG040 }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG041 = union {
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG042 = union {
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG043 = difference {
  object { CSG041 }
  object { CSG042 }
}
#declare Group024 = union {
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG043 }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG044 = union {
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG045 = union {
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG046 = difference {
  object { CSG044 }
  object { CSG045 }
}
#declare Group025 = union {
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG046 }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG047 = union {
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG048 = difference {
  object { CSG047 }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group026 = union {
  object { Group022 }
  object { Group023 }
  object { Group024 }
  object { Group025 }
  object { CSG048 }
  cone { // Cone010
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone011
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone012
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone013
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep018 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group027 = union {
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep017 }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group026 }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep018 }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  scale 0.4
  rotate 161.378784*z
  translate  <0.0, 5.0, 1.8>
}
#declare TransSweep019 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG049 = union {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG050 = union {
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG051 = difference {
  object { CSG049 }
  object { CSG050 }
}
#declare Group028 = union {
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG051 }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG052 = union {
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG053 = union {
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG054 = difference {
  object { CSG052 }
  object { CSG053 }
}
#declare Group029 = union {
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG054 }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG055 = union {
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG056 = union {
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG057 = difference {
  object { CSG055 }
  object { CSG056 }
}
#declare Group030 = union {
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG057 }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG058 = union {
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG059 = union {
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG060 = difference {
  object { CSG058 }
  object { CSG059 }
}
#declare Group031 = union {
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG060 }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG061 = union {
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG062 = difference {
  object { CSG061 }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group032 = union {
  object { Group028 }
  object { Group029 }
  object { Group030 }
  object { Group031 }
  object { CSG062 }
  cone { // Cone014
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone015
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone016
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone070
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep020 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group033 = union {
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep019 }
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group032 }
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep020 }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  no_shadow
  scale 0.4
  rotate 32.307911*z
  translate  <5.0, -0.0, 1.8>
}
#declare AAbattery = union {
  object { Group015 }
  object { Group021 }
  object { Group027 }
  object { Group033 }
  material {
    B_Silver
  }
  translate  <-24.664212, -54.454036, 25.0>
}
#declare CSG006 = difference {
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <2.0, 20.0, 17.0>
    rotate -50.0*z
    translate  <94.06973, -62.440146, 17.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-50.0, -90.0, 0.0>
    translate  <88.185264, -70.587497, 9.8>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-50.0, -90.0, 0.0>
    translate  <92.773871, -66.751121, 9.8>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-50.0, -90.0, 0.0>
    translate  <97.315276, -62.957035, 9.8>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-50.0, -90.0, 0.0>
    translate  <101.827939, -59.16295, 9.8>
  }
}
#declare CSG258 = union {
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <6.0, 2.0, 17.0>
    translate  <64.5, -80.0, 17.0>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <6.0, 2.0, 15.0>
    translate  <53.0, -81.0, 15.0>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <8.0, 2.0, 13.0>
    translate  <43.0, -82.0, 13.0>
  }
}
#declare CSG259 = difference {
  object { CSG258 }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <14.0, 2.0, 6.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <48.0, -84.472046, 9.8>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <16.0, 2.0, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <55.0, -83.5, 9.8>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <62.0, -82.5, 9.8>
  }
}
#declare CSG260 = difference {
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <30.0, 2.0, 17.0>
    rotate -13.0*z
    translate  <-40.292902, -85.65819, 17.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-103.0, -90.0, 0.0>
    translate  <-28.807658, -90.892349, 9.8>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-103.0, -90.0, 0.0>
    translate  <-35.807658, -89.292349, 9.8>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-103.0, -90.0, 0.0>
    translate  <-42.807658, -87.692349, 9.8>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-103.0, -90.0, 0.0>
    translate  <-49.807658, -86.092349, 9.8>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate <-103.0, -90.0, 0.0>
    translate  <-56.807658, -84.492349, 9.8>
  }
}
#declare CSG261 = difference {
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <25.0, 2.0, 17.0>
    rotate -90.0*z
    translate  <-69.0, -54.0, 17.0>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -66.0, 9.8>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -59.0, 9.8>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -52.0, 9.8>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -45.0, 9.8>
  }
}
#declare CSG262 = difference {
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <25.0, 2.0, 17.0>
    rotate -90.0*z
    translate  <-69.0, -5.0, 17.0>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -19.0, 9.8>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -12.0, 9.8>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <18.0, 2.0, 5.0>
    rotate -90.0*y
    translate  <-66.5, -5.0, 9.8>
  }
}
#declare Barrier = union {
  object { CSG006 }
  object { CSG259 }
  object { CSG260 }
  object { CSG261 }
  object { CSG262 }
}
#declare Bars = union {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <100.257803, -57.293622, -8.688842>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <95.74361, -61.082566, -8.688842>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <91.209878, -64.886726, -8.688842>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <86.62692, -68.731791, -8.688842>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <62.0, -80.0, -9.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <55.0, -81.0, -9.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <48.0, -82.0, -9.0>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-28.245859, -88.461931, -9.0>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-35.24363, -86.846874, -9.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-42.239421, -85.230977, -9.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-49.236946, -83.615744, -9.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-56.232871, -82.001376, -9.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -66.0, -9.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -59.0, -9.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -52.0, -9.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -45.0, -9.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -19.0, -9.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -12.0, -9.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 37.0>
    translate  <-69.0, -5.0, -9.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 25.0>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 25.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 23.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 21.0>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 25.0>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 25.0>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 25.0>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 23.0>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 21.0>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 19.0>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 17.0>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 15.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 13.0>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 11.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 9.0>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 7.0>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 5.0>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 3.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, 1.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, -1.0>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, -3.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 20.0>
    rotate 90.0*x
    translate  <-69.0, -2.0, -5.0>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 23.0>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 21.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 19.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 17.0>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 15.0>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 13.0>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 11.0>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 9.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 7.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 5.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 3.0>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, 1.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, -1.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, -3.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 27.0>
    rotate 90.0*x
    translate  <-69.0, -42.0, -5.0>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 23.0>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 21.0>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 19.0>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 17.0>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 15.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 13.0>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 11.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 9.0>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 7.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 5.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 3.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, 1.0>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, -1.0>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, -3.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 35.0>
    rotate <90.0, 0.0, 77.0>
    translate  <-59.102897, -81.338847, -5.0>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 19.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 17.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 15.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 13.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 11.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 9.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 7.0>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 5.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 3.0>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, 1.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate <90.0, 0.0, 90.0>
    translate  <37.0, -82.0, -1.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 21.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 19.0>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 17.0>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 15.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 13.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 11.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 9.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 7.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 5.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 3.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, 1.0>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, -1.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <52.0, -81.0, -3.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 23.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 21.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 19.0>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 17.0>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 15.0>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 13.0>
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 11.0>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 9.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 7.0>
  }
  cylinder { // Cylndr1384
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 5.0>
  }
  cylinder { // Cylndr1385
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 3.0>
  }
  cylinder { // Cylndr1386
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, 1.0>
  }
  cylinder { // Cylndr1387
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, -1.0>
  }
  cylinder { // Cylndr1388
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, -3.0>
  }
  cylinder { // Cylndr1389
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.0>
    rotate <90.0, 0.0, 90.0>
    translate  <59.0, -80.0, -5.0>
  }
  cylinder { // Cylndr1390
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 23.0>
  }
  cylinder { // Cylndr1391
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 21.0>
  }
  cylinder { // Cylndr1392
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 19.0>
  }
  cylinder { // Cylndr1393
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 17.0>
  }
  cylinder { // Cylndr1394
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 15.0>
  }
  cylinder { // Cylndr1395
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 13.0>
  }
  cylinder { // Cylndr1396
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 11.0>
  }
  cylinder { // Cylndr1397
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 9.0>
  }
  cylinder { // Cylndr1398
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 7.0>
  }
  cylinder { // Cylndr1399
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 5.0>
  }
  cylinder { // Cylndr1400
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 3.0>
  }
  cylinder { // Cylndr1401
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, 1.0>
  }
  cylinder { // Cylndr1402
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, -1.0>
  }
  cylinder { // Cylndr1403
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, -3.0>
  }
  cylinder { // Cylndr1404
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 24.0>
    rotate <90.0, 0.0, 130.0>
    translate  <84.264303, -70.71373, -5.0>
  }
  material {
    Streaky_Steel_Metal_2
  }
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group101 = union {
  object { TransSweep001 }
  object { TransSweep002 }
  translate  <-1.84074, -47.110334, 0.0>
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group102 = union {
  object { TransSweep003 }
  object { TransSweep004 }
  translate  <54.676004, -60.454668, 0.0>
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group103 = union {
  object { TransSweep005 }
  object { TransSweep006 }
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group104 = union {
  object { TransSweep007 }
  object { TransSweep008 }
  translate  <143.313876, -47.594898, 0.0>
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group105 = union {
  object { TransSweep009 }
  object { TransSweep010 }
  translate  <101.841912, -50.680767, -15.906447>
}
#declare TransSweep011 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <-68.84337, -32.66131, 38.918964>
}
#declare TransSweep012 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <-70.10593, -31.41131, 38.918964>
}
#declare Group106 = union {
  object { TransSweep011 }
  object { TransSweep012 }
  cylinder { // Cylndr1405
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 3.0>
    translate  <-68.841876, -31.409714, 40.919083>
  }
  translate  <44.169641, -23.06406, -16.0>
}
#declare TransSweep021 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate -90.0*x
  translate  <113.351667, -47.838419, 44.963602>
}
#declare TransSweep022 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.0, -1.0>,
  <3.0, -1.0>,
  <1.0, 3.0>,
  <-1.0, 3.0>,
  <-3.0, -1.0>
  rotate -x*90
  scale 2.5
  rotate <-90.0, 0.0, -90.0>
  translate  <112.107203, -46.651392, 44.963602>
}
#declare Group108 = union {
  object { TransSweep021 }
  object { TransSweep022 }
  cylinder { // Cylndr1410
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <8.0, 8.0, 3.0>
    translate  <113.357339, -46.642845, 47.5>
  }
  material {
    RoughStone
  }
  translate  <-1.171186, 0.981621, 24.0>
}
#declare Cannonbase = union {
  object { Group101 }
  object { Group102 }
  object { Group103 }
  object { Group104 }
  object { Group105 }
  object { Group106 }
  cylinder { // Cylndr1406
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 3.0>
    translate  <74.45194, -78.991154, 40.7689>
  }
  cylinder { // Cylndr1407
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 3.0>
    translate  <-14.173322, -91.882101, 40.7689>
  }
  cylinder { // Cylndr1408
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 3.0>
    translate  <-68.843368, -31.411315, 40.7689>
  }
  cylinder { // Cylndr1409
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 3.0>
    translate  <-70.6983, -78.52659, 40.7689>
  }
  object { Group108 }
  material {
    RoughStone
  }
}
#declare CSG263 = intersection {
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <4.2, 0.2, 0.5>
    rotate 45.0*y
    translate  <-11.5, -1.8, 1.8>
  }
  plane { // Plane024
    z,0
    scale <0.7, 0.3, 0.7>
    translate  <-14.1, -1.8, 4.5>
  }
  material {
    RoughStone
  }
}
#declare Dock = union {
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <10.0, 0.1, 0.3>
    translate  <0.0, -1.9, -0.3>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-10.3, 0.0, 0.6>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <10.0, 2.0, 0.3>
  }
  cylinder { // Cylndr1411
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <-9.2, -1.2, 0.0>
  }
  cylinder { // Cylndr1412
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <-5.5, -1.2, 0.0>
  }
  cylinder { // Cylndr1413
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <-1.8, -1.2, 0.0>
  }
  cylinder { // Cylndr1414
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <1.9, -1.2, 0.0>
  }
  cylinder { // Cylndr1415
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <5.6, -1.2, 0.0>
  }
  cylinder { // Cylndr1416
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood20
    }
    scale <-0.5, -0.5, -4.0>
    rotate -180.0*z
    translate  <9.3, -1.2, 0.0>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-10.9, 0.0, 1.2>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-11.5, 0.0, 1.8>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-12.1, 0.0, 2.4>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-12.7, 0.0, 3.0>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.3, 2.0, 0.3>
    translate  <-13.3, 0.0, 3.6>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <1.4, 2.0, 0.3>
    translate  <-15.0, 0.0, 4.2>
  }
  object { CSG263 }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 2.0, 0.3>
    translate  <-16.3, 0.0, 3.6>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <1.4, 0.1, 0.3>
    translate  <-15.0, -1.9, 3.6>
  }
  rotate -17.191641*z
  translate  <-30.009515, -14.920819, 14.0>
}
#declare TransSweep031 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.2, -4.0>,
  <-1.2, -4.8>,
  <-6.0, -4.8>,
  <-6.0, -5.0>,
  <6.0, -5.0>,
  <6.0, -4.8>,
  <1.2, -4.8>,
  <1.2, -4.0>,
  <0.7, 3.9>,
  <-0.7, 3.9>,
  <-1.2, -4.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal_2
  }
  scale <1.0, 1.0, 0.2>
  rotate 90.0*x
  translate  <0.0, 0.1, 44.1>
}
#declare TransSweep032 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.2, -4.0>,
  <-1.2, -4.8>,
  <-6.0, -4.8>,
  <-6.0, -5.0>,
  <6.0, -5.0>,
  <6.0, -4.8>,
  <1.2, -4.8>,
  <1.2, -4.0>,
  <0.7, 3.9>,
  <-0.7, 3.9>,
  <-1.2, -4.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal_2
  }
  scale <1.0, 1.0, 0.2>
  rotate <90.0, 0.0, -90.0>
  translate  <0.1, 0.0, 44.1>
}
#declare TransSweep033 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG139 = union {
  cylinder { // Cylndr816
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr817
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr818
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr819
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr820
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr821
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG140 = union {
  cylinder { // Cylndr822
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr823
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr824
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr825
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr826
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr827
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG141 = difference {
  object { CSG139 }
  object { CSG140 }
}
#declare Group058 = union {
  cylinder { // Cylndr813
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr814
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr815
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG141 }
  cylinder { // Cylndr828
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG142 = union {
  cylinder { // Cylndr832
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr833
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr834
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr835
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr836
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr837
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG143 = union {
  cylinder { // Cylndr838
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr839
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr840
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr841
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr842
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr843
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG144 = difference {
  object { CSG142 }
  object { CSG143 }
}
#declare Group059 = union {
  cylinder { // Cylndr829
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr830
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr831
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG144 }
  cylinder { // Cylndr844
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG145 = union {
  cylinder { // Cylndr848
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr849
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr850
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr851
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr852
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr853
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG146 = union {
  cylinder { // Cylndr854
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr855
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr856
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr857
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr858
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr859
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG147 = difference {
  object { CSG145 }
  object { CSG146 }
}
#declare Group060 = union {
  cylinder { // Cylndr845
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr846
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr847
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG147 }
  cylinder { // Cylndr860
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG148 = union {
  cylinder { // Cylndr864
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr865
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr866
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr867
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr868
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr869
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG149 = union {
  cylinder { // Cylndr870
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr871
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr872
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr873
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr874
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr875
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG150 = difference {
  object { CSG148 }
  object { CSG149 }
}
#declare Group061 = union {
  cylinder { // Cylndr861
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr862
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr863
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG150 }
  cylinder { // Cylndr876
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG151 = union {
  cylinder { // Cylndr877
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr878
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr879
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr880
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG152 = difference {
  object { CSG151 }
  cylinder { // Cylndr881
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr882
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr883
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr884
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group062 = union {
  object { Group058 }
  object { Group059 }
  object { Group060 }
  object { Group061 }
  object { CSG152 }
  cone { // Cone033
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone034
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone035
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone036
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr885
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep034 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group063 = union {
  cylinder { // Cylndr810
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr811
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep033 }
  cylinder { // Cylndr812
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group062 }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep034 }
  cylinder { // Cylndr886
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate -9.53045*z
  translate  <0.0, -6.5, 1.8>
}
#declare TransSweep035 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG153 = union {
  cylinder { // Cylndr893
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr894
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr895
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr896
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr897
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr898
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG154 = union {
  cylinder { // Cylndr899
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr900
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr901
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr902
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr903
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr904
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG155 = difference {
  object { CSG153 }
  object { CSG154 }
}
#declare Group064 = union {
  cylinder { // Cylndr890
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr891
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr892
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG155 }
  cylinder { // Cylndr905
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG156 = union {
  cylinder { // Cylndr909
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr910
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr911
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr912
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr913
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr914
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG157 = union {
  cylinder { // Cylndr915
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr916
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr917
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr918
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr919
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr920
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG158 = difference {
  object { CSG156 }
  object { CSG157 }
}
#declare Group065 = union {
  cylinder { // Cylndr906
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr907
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr908
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG158 }
  cylinder { // Cylndr921
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG159 = union {
  cylinder { // Cylndr925
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr926
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr927
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr928
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr929
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr930
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG160 = union {
  cylinder { // Cylndr931
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr932
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr933
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr934
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr935
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr936
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG161 = difference {
  object { CSG159 }
  object { CSG160 }
}
#declare Group066 = union {
  cylinder { // Cylndr922
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr923
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr924
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG161 }
  cylinder { // Cylndr937
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG162 = union {
  cylinder { // Cylndr941
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr942
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr943
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr944
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr945
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr946
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG163 = union {
  cylinder { // Cylndr947
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr948
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr949
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr950
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr951
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr952
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG164 = difference {
  object { CSG162 }
  object { CSG163 }
}
#declare Group067 = union {
  cylinder { // Cylndr938
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr939
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr940
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG164 }
  cylinder { // Cylndr953
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG165 = union {
  cylinder { // Cylndr954
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr955
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr956
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr957
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG166 = difference {
  object { CSG165 }
  cylinder { // Cylndr958
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr959
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr960
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr961
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group068 = union {
  object { Group064 }
  object { Group065 }
  object { Group066 }
  object { Group067 }
  object { CSG166 }
  cone { // Cone037
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone038
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone039
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone040
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr962
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep036 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group069 = union {
  cylinder { // Cylndr887
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr888
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep035 }
  cylinder { // Cylndr889
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group068 }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep036 }
  cylinder { // Cylndr963
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate -57.928585*z
  translate  <-6.5, 0.0, 1.8>
}
#declare TransSweep037 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG167 = union {
  cylinder { // Cylndr970
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr971
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr972
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr973
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr974
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr975
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG168 = union {
  cylinder { // Cylndr976
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr977
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr978
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr979
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr980
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr981
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG169 = difference {
  object { CSG167 }
  object { CSG168 }
}
#declare Group070 = union {
  cylinder { // Cylndr967
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr968
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr969
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG169 }
  cylinder { // Cylndr982
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG170 = union {
  cylinder { // Cylndr986
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr987
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr988
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr989
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr990
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr991
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG171 = union {
  cylinder { // Cylndr992
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr993
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr994
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr995
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr996
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr997
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG172 = difference {
  object { CSG170 }
  object { CSG171 }
}
#declare Group071 = union {
  cylinder { // Cylndr983
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr984
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr985
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG172 }
  cylinder { // Cylndr998
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG173 = union {
  cylinder { // Cylndr1002
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1003
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1004
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1005
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1006
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1007
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG174 = union {
  cylinder { // Cylndr1008
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1009
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1010
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1011
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1012
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1013
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG175 = difference {
  object { CSG173 }
  object { CSG174 }
}
#declare Group072 = union {
  cylinder { // Cylndr999
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1000
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1001
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG175 }
  cylinder { // Cylndr1014
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG176 = union {
  cylinder { // Cylndr1018
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1019
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1020
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1021
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1022
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1023
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG177 = union {
  cylinder { // Cylndr1024
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1025
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1026
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1027
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1028
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1029
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG178 = difference {
  object { CSG176 }
  object { CSG177 }
}
#declare Group073 = union {
  cylinder { // Cylndr1015
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1016
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1017
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG178 }
  cylinder { // Cylndr1030
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG179 = union {
  cylinder { // Cylndr1031
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1032
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1033
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr1034
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG180 = difference {
  object { CSG179 }
  cylinder { // Cylndr1035
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1036
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1037
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1038
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group074 = union {
  object { Group070 }
  object { Group071 }
  object { Group072 }
  object { Group073 }
  object { CSG180 }
  cone { // Cone041
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone042
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone043
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone044
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1039
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  material {
    Chrome_Metal
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep038 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group075 = union {
  cylinder { // Cylndr964
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr965
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep037 }
  cylinder { // Cylndr966
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group074 }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep038 }
  cylinder { // Cylndr1040
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate 180.0*z
  translate  <0.0, 6.5, 1.8>
}
#declare TransSweep039 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <-2.0, -2.0, -1.5>
  rotate <180.0, 90.0, 0.0>
  translate  <3.1, 0.0, 7.0>
}
#declare CSG181 = union {
  cylinder { // Cylndr1047
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1048
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1049
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1050
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1051
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1052
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG182 = union {
  cylinder { // Cylndr1053
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1054
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1055
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1056
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1057
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1058
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG183 = difference {
  object { CSG181 }
  object { CSG182 }
}
#declare Group076 = union {
  cylinder { // Cylndr1044
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1045
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1046
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG183 }
  cylinder { // Cylndr1059
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, 1.5, 0.0>
}
#declare CSG184 = union {
  cylinder { // Cylndr1063
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1064
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1065
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1066
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1067
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1068
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG185 = union {
  cylinder { // Cylndr1069
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1070
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1071
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1072
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1073
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1074
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG186 = difference {
  object { CSG184 }
  object { CSG185 }
}
#declare Group077 = union {
  cylinder { // Cylndr1060
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1061
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1062
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG186 }
  cylinder { // Cylndr1075
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, 1.5, 0.0>
}
#declare CSG187 = union {
  cylinder { // Cylndr1079
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1080
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1081
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1082
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1083
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1084
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG188 = union {
  cylinder { // Cylndr1085
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1086
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1087
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1088
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1089
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1090
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG189 = difference {
  object { CSG187 }
  object { CSG188 }
}
#declare Group078 = union {
  cylinder { // Cylndr1076
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1077
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1078
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG189 }
  cylinder { // Cylndr1091
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <-1.5, -1.5, 0.0>
}
#declare CSG190 = union {
  cylinder { // Cylndr1095
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    translate  0.5*x
  }
  cylinder { // Cylndr1096
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1097
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1098
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1099
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1100
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG191 = union {
  cylinder { // Cylndr1101
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1102
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -5.0*z
    translate  <0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1103
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -10.0*z
    translate  <-0.25, -0.433013, 0.0>
  }
  cylinder { // Cylndr1104
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -15.0*z
    translate  <-0.5, 0.0, 0.0>
  }
  cylinder { // Cylndr1105
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -20.0*z
    translate  <-0.25, 0.433013, 0.0>
  }
  cylinder { // Cylndr1106
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 10.1>
    rotate -25.0*z
    translate  <0.25, 0.433013, 0.0>
  }
}
#declare CSG192 = difference {
  object { CSG190 }
  object { CSG191 }
}
#declare Group079 = union {
  cylinder { // Cylndr1092
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  9.0*z
  }
  cylinder { // Cylndr1093
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // Cylndr1094
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    translate  3.0*z
  }
  object { CSG192 }
  cylinder { // Cylndr1107
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.3>
  }
  translate  <1.5, -1.5, 0.0>
}
#declare CSG193 = union {
  cylinder { // Cylndr1108
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1109
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, 1.5, -2.9>
  }
  cylinder { // Cylndr1110
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <1.5, -1.5, -2.9>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  -1.9*z
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 1.0>
    translate  -1.9*z
  }
  cylinder { // Cylndr1111
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    translate  <-1.5, -1.5, -2.9>
  }
}
#declare CSG194 = difference {
  object { CSG193 }
  cylinder { // Cylndr1112
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1113
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, -1.5, -1.0>
  }
  cylinder { // Cylndr1114
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1115
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.2>
    translate  <-1.5, 1.5, -1.0>
  }
}
#declare Group080 = union {
  object { Group076 }
  object { Group077 }
  object { Group078 }
  object { Group079 }
  object { CSG194 }
  cone { // Cone045
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, -1.5, -1.0>
  }
  cone { // Cone046
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, -1.5, -1.0>
  }
  cone { // Cone047
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <1.5, 1.5, -1.0>
  }
  cone { // Cone048
    <0,0,0>, 1.1, <0,0,1>, 0.9
    translate  <-1.5, 1.5, -1.0>
  }
  cylinder { // Cylndr1116
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, -3.0>
  }
  rotate 60.664711*x
  translate  <0.0, -1.62315, 10.93>
}
#declare TransSweep040 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -2.0>,
  <1.0, -1.5>,
  <2.2, -1.0>,
  <2.8, 0.0>,
  <2.2, 1.0>,
  <1.0, 1.5>,
  <-1.0, 2.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <2.0, 2.0, 1.5>
  rotate -90.0*y
  translate  <-3.1, 0.0, 7.0>
}
#declare Group081 = union {
  cylinder { // Cylndr1041
    <0,0,1>, <0,0,0>, 1 
    scale <-1.2, -1.2, -0.2>
    rotate <180.0, 90.0, 0.0>
    translate  <-4.8, 0.0, 10.0>
  }
  cylinder { // Cylndr1042
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.2>
    rotate -90.0*y
    translate  <4.8, 0.0, 10.0>
  }
  object { TransSweep039 }
  cylinder { // Cylndr1043
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 1.0>
    translate  3.0*z
  }
  object { Group080 }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 4.4, 0.5>
    translate  4.5*z
  }
  object { TransSweep040 }
  cylinder { // Cylndr1117
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 10.0>
  }
  material {
    Chrome_Metal
  }
  scale 0.4
  rotate -7.890845*z
  translate  <6.5, 0.0, 1.8>
}
#declare AAbattery2 = union {
  object { Group063 }
  object { Group069 }
  object { Group075 }
  object { Group081 }
  rotate -45.0*z
  translate  36.1*z
}
#declare TaperSweep005 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-5.0, -5.0>,
  <5.0, -5.0>,
  <5.0, 5.0>,
  <-5.0, 5.0>,
  <-5.0, -5.0>
  rotate <90,0,90>
  material {
    RoughStone
  }
  scale <1.0, 1.0, 4.0>
  translate  24.1*z
}
#declare TransSweep041 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-7.0, -15.1>,
  <7.0, -15.1>,
  <4.0, 15.0>,
  <-4.0, 15.0>,
  <-7.0, -15.1>
  rotate -x*90
  material {
    RoughStone
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, 0.0, -90.0>
  translate  <1.5, 0.0, 15.0>
}
#declare TransSweep042 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-7.0, -15.0>,
  <7.0, -15.0>,
  <4.0, 15.0>,
  <-4.0, 15.0>,
  <-7.0, -15.0>
  rotate -x*90
  material {
    RoughStone
  }
  scale <1.0, 1.0, 3.0>
  rotate 90.0*x
  translate  <0.0, 1.5, 15.0>
}
#declare TaperSweep006 = prism {
  conic_sweep
  linear_spline
  0.7,1.0
  5  // control points
  <-7.0, -7.0>,
  <7.0, -7.0>,
  <7.0, 7.0>,
  <-7.0, 7.0>,
  <-7.0, -7.0>
  rotate <90,0,90>
  material {
    RoughStone
  }
  scale <1.0, 1.0, 4.0>
  translate  35.1*z
}
#declare Group082 = union {
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 4.0, 0.2>
    translate  <-4.0, 0.0, 33.8>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 4.0, 0.2>
    translate  <4.0, 0.0, 33.8>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <4.0, 0.1, 0.2>
    translate  <0.0, 4.0, 33.8>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <4.0, 0.1, 0.2>
    translate  <0.0, -4.0, 33.8>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <4.0, 0.1, 0.2>
    translate  <0.0, -4.0, 35.4>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <4.0, 0.1, 0.2>
    translate  <0.0, 4.0, 35.4>
  }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 4.0, 0.2>
    translate  <-4.0, 0.0, 35.4>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 4.0, 0.2>
    translate  <4.0, 0.0, 35.4>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <4.0, -3.5, 34.6>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <4.0, 0.0, 34.6>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <4.0, 3.5, 34.6>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <-4.0, 3.5, 34.6>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <-4.0, 0.0, 34.6>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.1, 0.2, 0.9>
    translate  <-4.0, -3.5, 34.6>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <-3.5, 4.0, 34.6>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <0.0, 4.0, 34.6>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <3.5, 4.0, 34.6>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <3.5, -4.0, 34.6>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <-3.5, -4.0, 34.6>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood20
    }
    scale <0.2, 0.1, 0.9>
    translate  <0.0, -4.0, 34.6>
  }
}
#declare Group083 = union {
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    material {
      glass
    }
    scale <4.0, 0.05, 2.5>
    translate  <0.0, -4.0, 34.55>
  }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    material {
      glass
    }
    scale <4.0, 0.05, 2.5>
    translate  <0.0, 4.0, 34.55>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    material {
      glass
    }
    scale <0.05, 4.0, 2.5>
    translate  <-4.0, 0.0, 34.55>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    material {
      glass
    }
    scale <0.05, 4.0, 2.5>
    translate  <4.0, 0.0, 34.55>
  }
}
#declare TransSweep052 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.5, -2.0>,
  <-2.0, -4.5>,
  <2.0, -4.5>,
  <4.5, -2.0>,
  <4.5, 2.0>,
  <2.0, 4.5>,
  <-2.0, 4.5>,
  <-4.5, 2.0>,
  <-4.5, -2.0>
  rotate -x*90
  material {
    Metaltex
  }
}
#declare TransSweep053 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate -90.0*y
  translate  <5.2, -5.5, 1.0>
}
#declare CSG203 = intersection {
  object { TransSweep053 }
  plane { // Plane065
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-22.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane066
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-22.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep054 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-45.0, -90.0, 0.0>
  translate  <-0.212132, -7.566043, 1.0>
}
#declare CSG204 = intersection {
  object { TransSweep054 }
  plane { // Plane067
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-67.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane068
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <22.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep055 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-90.0, -90.0, 0.0>
  translate  <-5.5, -5.2, 1.0>
}
#declare CSG205 = intersection {
  object { TransSweep055 }
  plane { // Plane069
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-112.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane070
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <67.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep056 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <-135.0, -90.0, 0.0>
  translate  <-7.566043, 0.212132, 1.0>
}
#declare CSG206 = intersection {
  object { TransSweep056 }
  plane { // Plane071
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-157.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane072
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <112.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep057 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <180.0, -90.0, 0.0>
  translate  <-5.2, 5.5, 1.0>
}
#declare CSG207 = intersection {
  object { TransSweep057 }
  plane { // Plane073
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <157.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane074
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <157.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep058 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <135.0, -90.0, 0.0>
  translate  <0.212132, 7.566043, 1.0>
}
#declare CSG208 = intersection {
  object { TransSweep058 }
  plane { // Plane075
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <112.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane076
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-157.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep059 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <90.0, -90.0, 0.0>
  translate  <5.5, 5.2, 1.0>
}
#declare CSG209 = intersection {
  object { TransSweep059 }
  plane { // Plane077
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <67.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane078
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-112.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare TransSweep060 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <2.2, -3.8>,
  <7.0, -7.0>,
  <2.9, -3.4>,
  <0.0, 2.0>,
  <-1.0, 1.0>,
  <2.2, -3.8>
  rotate -x*90
  material {
    Metaltex
  }
  scale <1.0, 1.0, 10.4>
  rotate <45.0, -90.0, 0.0>
  translate  <7.566043, -0.212132, 1.0>
}
#declare CSG210 = intersection {
  object { TransSweep060 }
  plane { // Plane079
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <22.5, -90.0, 0.0>
    translate  4.5*z
  }
  plane { // Plane080
    z,0
    material {
      Metaltex
    }
    scale <4.0, 14.0, 1.0>
    rotate <-67.5, 90.0, 0.0>
    translate  4.5*z
  }
}
#declare Group085 = union {
  cone { // Cone054
    <0,0,0>, 0.4, <0,0,1>, 0.05
    material {
      Metaltex
    }
    translate  12.88*z
  }
  cone { // Cone055
    <0,0,0>, 0.35, <0,0,1>, 0.3
    material {
      Metaltex
    }
    scale <1.0, 1.0, 10.0>
    translate  2.02*z
  }
  cone { // Cone056
    <0,0,0>, 0.7, <0,0,1>, 0.4
    material {
      Metaltex
    }
    translate  1.0*z
  }
  object { TransSweep052 }
  object { CSG203 }
  object { CSG204 }
  object { CSG205 }
  object { CSG206 }
  object { CSG207 }
  object { CSG208 }
  object { CSG209 }
  object { CSG210 }
  cylinder { // Cylndr1134
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate -45.0*y
    translate  <8.9, 0.0, 3.9>
  }
  cylinder { // Cylndr1135
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, -45.0>
    translate  <6.29325, -6.29325, 3.9>
  }
  cylinder { // Cylndr1136
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, -90.0>
    translate  <0.0, -8.9, 3.9>
  }
  cylinder { // Cylndr1137
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <-0.0, -45.0, -135.0>
    translate  <-6.29325, -6.29325, 3.9>
  }
  cylinder { // Cylndr1138
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 180.0>
    translate  <-8.9, 0.0, 3.9>
  }
  cylinder { // Cylndr1139
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 135.0>
    translate  <-6.29325, 6.29325, 3.9>
  }
  cylinder { // Cylndr1140
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 90.0>
    translate  <0.0, 8.9, 3.9>
  }
  cylinder { // Cylndr1141
    <0,0,1>, <0,0,0>, 1 
    material {
      Metaltex
    }
    scale <0.3, 0.3, 12.4>
    rotate <0.0, -45.0, 45.0>
    translate  <6.29325, 6.29325, 3.9>
  }
  cone { // Cone057
    <0,0,0>, 0.3, <0,0,1>, 0.7
    material {
      Metaltex
    }
    scale <1.0, 1.0, 0.86>
    translate  12.02*z
  }
  cylinder { // Cylndr1142
    <0,0,1>, <0,0,0>, 1 
    material {
      Main_grey
    }
    scale <-4.5, -4.5, -2.0>
    rotate -180.0*z
  }
  scale 0.3
  rotate <-45.948467, -0.0, 139.526306>
  translate  <-0.269465, -0.314134, 49.219773>
}
#declare Tower = union {
  object { TransSweep031 }
  object { TransSweep032 }
  object { AAbattery2 }
  cylinder { // Cylndr1118
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <1.0, 1.0, 10.0>
    translate  30.0*z
  }
  object { TaperSweep005 }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 0.5, 0.5>
    translate  <0.0, -4.5, 37.5>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 0.5, 0.5>
    translate  <0.0, 4.5, 37.5>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.5, 5.0, 0.5>
    translate  <-4.5, 0.0, 37.5>
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.5, 5.0, 0.5>
    translate  <4.5, 0.0, 37.5>
  }
  cylinder { // Cylndr1119
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_2
    }
    scale <0.5, 0.5, 7.0>
    translate  <4.0, 4.0, 30.0>
  }
  cylinder { // Cylndr1120
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_2
    }
    scale <0.5, 0.5, 7.0>
    translate  <-4.0, 4.0, 30.0>
  }
  cylinder { // Cylndr1121
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_2
    }
    scale <0.5, 0.5, 7.0>
    translate  <4.0, -4.0, 30.0>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 0.5, 1.0>
    translate  <0.0, -4.5, 31.1>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 0.5, 1.0>
    translate  <0.0, 4.5, 31.1>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.5, 5.0, 1.0>
    translate  <-4.5, 0.0, 31.1>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.5, 5.0, 1.0>
    translate  <4.5, 0.0, 31.1>
  }
  object { TransSweep041 }
  cylinder { // Cylndr1122
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <-8.0, -8.0, -3.0>
    rotate -180.0*z
  }
  object { TransSweep042 }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 5.0, 1.0>
    translate  29.1*z
  }
  cylinder { // Cylndr1123
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal_2
    }
    scale <0.5, 0.5, 7.0>
    translate  <-4.0, -4.0, 30.0>
  }
  object { TaperSweep006 }
  object { Group082 }
  object { Group083 }
  cylinder { // Cylndr1124
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <4.0, 4.0, 30.0>
  }
  cone { // Cone049
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      Metaltex
    }
    scale <1.0, 1.0, 8.0>
    translate  40.0*z
  }
  object { Group085 }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Main_grey
    }
    translate  48.8*z
  }
  cylinder { // Cylndr1143
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone
    }
    scale <3.0, 3.0, 0.1>
    translate  39.1*z
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 4.0, 1.0>
    translate  <3.9, 0.0, 36.4>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <4.0, 0.1, 1.0>
    translate  <0.0, 3.9, 36.4>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 4.0, 1.0>
    translate  <-3.9, 0.0, 36.4>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <4.0, 0.1, 1.0>
    translate  <0.0, -3.9, 36.4>
  }
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 4.0, 1.0>
    translate  <3.9, 0.0, 32.8>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <0.1, 4.0, 1.0>
    translate  <-3.9, 0.0, 32.8>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <4.0, 0.1, 1.0>
    translate  <0.0, 3.9, 32.8>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <4.0, 0.1, 1.0>
    translate  <0.0, -3.9, 32.8>
  }
  translate  <33.0, -82.07961, 28.0>
}
union { // Seastructure
  object { Cannon3 }
  object { AAbattery1 }
  object { Cannon2 }
  object { Cannon1 }
  object { Cannon4 }
  object { AAbattery }
  object { Barrier }
  object { Bars }
  object { Cannonbase }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 5.0, 1.0>
    translate  <-14.184725, -91.842372, 43.5>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 5.0, 1.0>
    translate  <74.456568, -79.056989, 43.5>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 5.0, 1.0>
    translate  <-70.696509, -78.547976, 43.5>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoughStone
    }
    scale <5.0, 5.0, 1.0>
    translate  <-68.833427, -31.408952, 43.5>
  }
  object { Dock }
  object { Tower }
}


sphere { // SkySphere
  <0,0,0>,1
  hollow
  scale 1200.0
  material {
    Bright_Blue_Sky
    // Transform to world space
  }
}


union { // Group109
  object { Light3 }
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <0.1, 0.1, 0.00001>
    rotate <-20.361599, -5.509924, 0.0>
    translate  <100.324529, -279.801897, 275.17478>
  }
  translate  <45.921011, 190.527634, 301.402403>
}


union { // Water1
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-160.100000, -135.100000, -1.000000>, <-156.600000, -134.500000, -1.000000>, <-153.100000, -133.800000, -1.000000>, <-149.550000, -133.150000, -1.000000>, 
      <-160.800000, -131.200000, 1.000000>, <-157.300000, -130.500000, 1.000000>, <-153.800000, -129.900000, 1.000000>, <-150.250000, -129.250000, 1.000000>, 
      <-160.900000, -131.000000, -1.000000>, <-157.400000, -130.300000, -1.000000>, <-153.800000, -129.700000, -1.000000>, <-150.300000, -129.050000, -1.000000>, 
      <-161.450000, -128.000000, 0.000000>, <-157.900000, -127.350000, 0.000000>, <-154.350000, -126.700000, 0.000000>, <-150.825000, -126.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-161.450000, -128.000000, 0.000000>, <-157.900000, -127.350000, 0.000000>, <-154.350000, -126.700000, 0.000000>, <-150.825000, -126.050000, 0.000000>, 
      <-162.000000, -125.000000, 1.000000>, <-158.400000, -124.400000, 1.000000>, <-154.900000, -123.700000, 1.000000>, <-151.350000, -123.050000, 1.000000>, 
      <-162.000000, -124.800000, -1.000000>, <-158.500000, -124.200000, -1.000000>, <-155.000000, -123.500000, -1.000000>, <-151.450000, -122.850000, -1.000000>, 
      <-162.550000, -121.850000, 0.000000>, <-159.050000, -121.200000, 0.000000>, <-155.500000, -120.550000, 0.000000>, <-151.975000, -119.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-162.550000, -121.850000, 0.000000>, <-159.050000, -121.200000, 0.000000>, <-155.500000, -120.550000, 0.000000>, <-151.975000, -119.900000, 0.000000>, 
      <-163.100000, -118.900000, 1.000000>, <-159.600000, -118.200000, 1.000000>, <-156.000000, -117.600000, 1.000000>, <-152.500000, -116.950000, 1.000000>, 
      <-163.200000, -118.600000, -1.000000>, <-159.600000, -118.000000, -1.000000>, <-156.100000, -117.400000, -1.000000>, <-152.550000, -116.750000, -1.000000>, 
      <-163.700000, -115.650000, 0.000000>, <-160.150000, -115.000000, 0.000000>, <-156.650000, -114.400000, 0.000000>, <-153.100000, -113.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-163.700000, -115.650000, 0.000000>, <-160.150000, -115.000000, 0.000000>, <-156.650000, -114.400000, 0.000000>, <-153.100000, -113.750000, 0.000000>, 
      <-164.200000, -112.700000, 1.000000>, <-160.700000, -112.000000, 1.000000>, <-157.200000, -111.400000, 1.000000>, <-153.650000, -110.750000, 1.000000>, 
      <-164.300000, -112.500000, -1.000000>, <-160.700000, -111.800000, -1.000000>, <-157.200000, -111.200000, -1.000000>, <-153.650000, -110.550000, -1.000000>, 
      <-164.850000, -109.500000, 0.000000>, <-161.250000, -108.850000, 0.000000>, <-157.750000, -108.200000, 0.000000>, <-154.200000, -107.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-164.850000, -109.500000, 0.000000>, <-161.250000, -108.850000, 0.000000>, <-157.750000, -108.200000, 0.000000>, <-154.200000, -107.550000, 0.000000>, 
      <-165.400000, -106.500000, 1.000000>, <-161.800000, -105.900000, 1.000000>, <-158.300000, -105.200000, 1.000000>, <-154.750000, -104.550000, 1.000000>, 
      <-165.400000, -106.300000, -1.000000>, <-161.900000, -105.700000, -1.000000>, <-158.300000, -105.000000, -1.000000>, <-154.800000, -104.350000, -1.000000>, 
      <-165.950000, -103.300000, 0.000000>, <-162.400000, -102.700000, 0.000000>, <-158.850000, -102.050000, 0.000000>, <-155.325000, -101.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-165.950000, -103.300000, 0.000000>, <-162.400000, -102.700000, 0.000000>, <-158.850000, -102.050000, 0.000000>, <-155.325000, -101.400000, 0.000000>, 
      <-166.500000, -100.300000, 1.000000>, <-162.900000, -99.700000, 1.000000>, <-159.400000, -99.100000, 1.000000>, <-155.850000, -98.450000, 1.000000>, 
      <-166.500000, -100.100000, -1.000000>, <-163.000000, -99.500000, -1.000000>, <-159.500000, -98.800000, -1.000000>, <-155.950000, -98.150000, -1.000000>, 
      <-167.050000, -97.150000, 0.000000>, <-163.550000, -96.500000, 0.000000>, <-160.000000, -95.850000, 0.000000>, <-156.475000, -95.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-167.050000, -97.150000, 0.000000>, <-163.550000, -96.500000, 0.000000>, <-160.000000, -95.850000, 0.000000>, <-156.475000, -95.200000, 0.000000>, 
      <-167.600000, -94.200000, 1.000000>, <-164.100000, -93.500000, 1.000000>, <-160.500000, -92.900000, 1.000000>, <-157.000000, -92.250000, 1.000000>, 
      <-167.700000, -94.000000, -1.000000>, <-164.100000, -93.300000, -1.000000>, <-160.600000, -92.700000, -1.000000>, <-157.050000, -92.050000, -1.000000>, 
      <-168.200000, -91.000000, 0.000000>, <-164.650000, -90.350000, 0.000000>, <-161.150000, -89.700000, 0.000000>, <-157.600000, -89.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-168.200000, -91.000000, 0.000000>, <-164.650000, -90.350000, 0.000000>, <-161.150000, -89.700000, 0.000000>, <-157.600000, -89.050000, 0.000000>, 
      <-168.700000, -88.000000, 1.000000>, <-165.200000, -87.400000, 1.000000>, <-161.700000, -86.700000, 1.000000>, <-158.150000, -86.050000, 1.000000>, 
      <-168.800000, -87.800000, -1.000000>, <-165.300000, -87.100000, -1.000000>, <-161.700000, -86.500000, -1.000000>, <-158.200000, -85.850000, -1.000000>, 
      <-169.350000, -84.800000, 0.000000>, <-165.800000, -84.150000, 0.000000>, <-162.250000, -83.500000, 0.000000>, <-158.725000, -82.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-169.350000, -84.800000, 0.000000>, <-165.800000, -84.150000, 0.000000>, <-162.250000, -83.500000, 0.000000>, <-158.725000, -82.850000, 0.000000>, 
      <-169.900000, -81.800000, 1.000000>, <-166.300000, -81.200000, 1.000000>, <-162.800000, -80.500000, 1.000000>, <-159.250000, -79.850000, 1.000000>, 
      <-169.900000, -81.600000, -1.000000>, <-166.400000, -81.000000, -1.000000>, <-162.800000, -80.300000, -1.000000>, <-159.300000, -79.650000, -1.000000>, 
      <-170.450000, -78.650000, 0.000000>, <-166.950000, -78.000000, 0.000000>, <-163.350000, -77.350000, 0.000000>, <-159.850000, -76.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-170.450000, -78.650000, 0.000000>, <-166.950000, -78.000000, 0.000000>, <-163.350000, -77.350000, 0.000000>, <-159.850000, -76.700000, 0.000000>, 
      <-171.000000, -75.700000, 1.000000>, <-167.500000, -75.000000, 1.000000>, <-163.900000, -74.400000, 1.000000>, <-160.400000, -73.750000, 1.000000>, 
      <-171.000000, -75.400000, -1.000000>, <-167.500000, -74.800000, -1.000000>, <-164.000000, -74.200000, -1.000000>, <-160.450000, -73.550000, -1.000000>, 
      <-171.550000, -72.450000, 0.000000>, <-168.050000, -71.800000, 0.000000>, <-164.500000, -71.200000, 0.000000>, <-160.975000, -70.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-171.550000, -72.450000, 0.000000>, <-168.050000, -71.800000, 0.000000>, <-164.500000, -71.200000, 0.000000>, <-160.975000, -70.550000, 0.000000>, 
      <-172.100000, -69.500000, 1.000000>, <-168.600000, -68.800000, 1.000000>, <-165.000000, -68.200000, 1.000000>, <-161.500000, -67.550000, 1.000000>, 
      <-172.200000, -69.300000, -1.000000>, <-168.600000, -68.600000, -1.000000>, <-165.100000, -68.000000, -1.000000>, <-161.550000, -67.350000, -1.000000>, 
      <-172.700000, -66.300000, 0.000000>, <-169.150000, -65.650000, 0.000000>, <-165.650000, -65.000000, 0.000000>, <-162.100000, -64.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-172.700000, -66.300000, 0.000000>, <-169.150000, -65.650000, 0.000000>, <-165.650000, -65.000000, 0.000000>, <-162.100000, -64.350000, 0.000000>, 
      <-173.200000, -63.300000, 1.000000>, <-169.700000, -62.700000, 1.000000>, <-166.200000, -62.000000, 1.000000>, <-162.650000, -61.350000, 1.000000>, 
      <-173.300000, -63.100000, -1.000000>, <-169.800000, -62.500000, -1.000000>, <-166.200000, -61.800000, -1.000000>, <-162.700000, -61.150000, -1.000000>, 
      <-173.850000, -60.100000, 0.000000>, <-170.300000, -59.500000, 0.000000>, <-166.750000, -58.850000, 0.000000>, <-163.225000, -58.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-173.850000, -60.100000, 0.000000>, <-170.300000, -59.500000, 0.000000>, <-166.750000, -58.850000, 0.000000>, <-163.225000, -58.200000, 0.000000>, 
      <-174.400000, -57.100000, 1.000000>, <-170.800000, -56.500000, 1.000000>, <-167.300000, -55.900000, 1.000000>, <-163.750000, -55.250000, 1.000000>, 
      <-174.400000, -56.900000, -1.000000>, <-170.900000, -56.300000, -1.000000>, <-167.400000, -55.600000, -1.000000>, <-163.850000, -55.000000, -1.000000>, 
      <-174.950000, -53.950000, 0.000000>, <-171.450000, -53.300000, 0.000000>, <-167.900000, -52.650000, 0.000000>, <-164.375000, -52.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-174.950000, -53.950000, 0.000000>, <-171.450000, -53.300000, 0.000000>, <-167.900000, -52.650000, 0.000000>, <-164.375000, -52.025000, 0.000000>, 
      <-175.500000, -51.000000, 1.000000>, <-172.000000, -50.300000, 1.000000>, <-168.400000, -49.700000, 1.000000>, <-164.900000, -49.050000, 1.000000>, 
      <-175.600000, -50.800000, -1.000000>, <-172.000000, -50.100000, -1.000000>, <-168.500000, -49.500000, -1.000000>, <-164.950000, -48.850000, -1.000000>, 
      <-176.100000, -47.800000, 0.000000>, <-172.550000, -47.150000, 0.000000>, <-169.050000, -46.500000, 0.000000>, <-165.500000, -45.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-176.100000, -47.800000, 0.000000>, <-172.550000, -47.150000, 0.000000>, <-169.050000, -46.500000, 0.000000>, <-165.500000, -45.850000, 0.000000>, 
      <-176.600000, -44.800000, 1.000000>, <-173.100000, -44.200000, 1.000000>, <-169.600000, -43.500000, 1.000000>, <-166.050000, -42.850000, 1.000000>, 
      <-176.700000, -44.600000, -1.000000>, <-173.100000, -43.900000, -1.000000>, <-169.600000, -43.300000, -1.000000>, <-166.050000, -42.650000, -1.000000>, 
      <-177.250000, -41.600000, 0.000000>, <-173.650000, -40.950000, 0.000000>, <-170.150000, -40.300000, 0.000000>, <-166.600000, -39.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-177.250000, -41.600000, 0.000000>, <-173.650000, -40.950000, 0.000000>, <-170.150000, -40.300000, 0.000000>, <-166.600000, -39.675000, 0.000000>, 
      <-177.800000, -38.600000, 1.000000>, <-174.200000, -38.000000, 1.000000>, <-170.700000, -37.300000, 1.000000>, <-167.150000, -36.700000, 1.000000>, 
      <-177.800000, -38.400000, -1.000000>, <-174.300000, -37.800000, -1.000000>, <-170.700000, -37.100000, -1.000000>, <-167.200000, -36.450000, -1.000000>, 
      <-178.350000, -35.450000, 0.000000>, <-174.800000, -34.800000, 0.000000>, <-171.250000, -34.150000, 0.000000>, <-167.725000, -33.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-178.350000, -35.450000, 0.000000>, <-174.800000, -34.800000, 0.000000>, <-171.250000, -34.150000, 0.000000>, <-167.725000, -33.500000, 0.000000>, 
      <-178.900000, -32.500000, 1.000000>, <-175.300000, -31.800000, 1.000000>, <-171.800000, -31.200000, 1.000000>, <-168.250000, -30.550000, 1.000000>, 
      <-178.900000, -32.300000, -1.000000>, <-175.400000, -31.600000, -1.000000>, <-171.900000, -31.000000, -1.000000>, <-168.350000, -30.350000, -1.000000>, 
      <-179.450000, -29.300000, 0.000000>, <-175.950000, -28.600000, 0.000000>, <-172.400000, -28.000000, 0.000000>, <-168.875000, -27.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-179.450000, -29.300000, 0.000000>, <-175.950000, -28.600000, 0.000000>, <-172.400000, -28.000000, 0.000000>, <-168.875000, -27.350000, 0.000000>, 
      <-180.000000, -26.300000, 1.000000>, <-176.500000, -25.600000, 1.000000>, <-172.900000, -25.000000, 1.000000>, <-169.400000, -24.350000, 1.000000>, 
      <-180.100000, -26.100000, -1.000000>, <-176.500000, -25.400000, -1.000000>, <-173.000000, -24.800000, -1.000000>, <-169.450000, -24.150000, -1.000000>, 
      <-180.600000, -23.100000, 0.000000>, <-177.050000, -22.450000, 0.000000>, <-173.550000, -21.800000, 0.000000>, <-170.000000, -21.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-180.600000, -23.100000, 0.000000>, <-177.050000, -22.450000, 0.000000>, <-173.550000, -21.800000, 0.000000>, <-170.000000, -21.150000, 0.000000>, 
      <-181.100000, -20.100000, 1.000000>, <-177.600000, -19.500000, 1.000000>, <-174.100000, -18.800000, 1.000000>, <-170.550000, -18.150000, 1.000000>, 
      <-181.200000, -19.900000, -1.000000>, <-177.700000, -19.300000, -1.000000>, <-174.100000, -18.600000, -1.000000>, <-170.600000, -17.950000, -1.000000>, 
      <-181.750000, -16.950000, 0.000000>, <-178.200000, -16.300000, 0.000000>, <-174.650000, -15.650000, 0.000000>, <-171.125000, -15.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-181.750000, -16.950000, 0.000000>, <-178.200000, -16.300000, 0.000000>, <-174.650000, -15.650000, 0.000000>, <-171.125000, -15.000000, 0.000000>, 
      <-182.300000, -14.000000, 1.000000>, <-178.700000, -13.300000, 1.000000>, <-175.200000, -12.700000, 1.000000>, <-171.650000, -12.050000, 1.000000>, 
      <-182.300000, -13.700000, -1.000000>, <-178.800000, -13.100000, -1.000000>, <-175.200000, -12.400000, -1.000000>, <-171.700000, -11.800000, -1.000000>, 
      <-182.850000, -10.750000, 0.000000>, <-179.350000, -10.100000, 0.000000>, <-175.750000, -9.450000, 0.000000>, <-172.250000, -8.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-182.850000, -10.750000, 0.000000>, <-179.350000, -10.100000, 0.000000>, <-175.750000, -9.450000, 0.000000>, <-172.250000, -8.825000, 0.000000>, 
      <-183.400000, -7.800000, 1.000000>, <-179.900000, -7.100000, 1.000000>, <-176.300000, -6.500000, 1.000000>, <-172.800000, -5.850000, 1.000000>, 
      <-183.400000, -7.600000, -1.000000>, <-179.900000, -6.900000, -1.000000>, <-176.400000, -6.300000, -1.000000>, <-172.850000, -5.650000, -1.000000>, 
      <-183.950000, -4.600000, 0.000000>, <-180.450000, -3.950000, 0.000000>, <-176.900000, -3.300000, 0.000000>, <-173.375000, -2.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-183.950000, -4.600000, 0.000000>, <-180.450000, -3.950000, 0.000000>, <-176.900000, -3.300000, 0.000000>, <-173.375000, -2.650000, 0.000000>, 
      <-184.500000, -1.600000, 1.000000>, <-181.000000, -1.000000, 1.000000>, <-177.400000, -0.300000, 1.000000>, <-173.900000, 0.350000, 1.000000>, 
      <-184.600000, -1.400000, -1.000000>, <-181.000000, -0.800000, -1.000000>, <-177.500000, -0.100000, -1.000000>, <-173.950000, 0.550000, -1.000000>, 
      <-185.100000, 1.600000, 0.000000>, <-181.550000, 2.200000, 0.000000>, <-178.050000, 2.900000, 0.000000>, <-174.500000, 3.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-185.100000, 1.600000, 0.000000>, <-181.550000, 2.200000, 0.000000>, <-178.050000, 2.900000, 0.000000>, <-174.500000, 3.525000, 0.000000>, 
      <-185.600000, 4.600000, 1.000000>, <-182.100000, 5.200000, 1.000000>, <-178.600000, 5.900000, 1.000000>, <-175.050000, 6.500000, 1.000000>, 
      <-185.700000, 4.800000, -1.000000>, <-182.200000, 5.400000, -1.000000>, <-178.600000, 6.100000, -1.000000>, <-175.100000, 6.750000, -1.000000>, 
      <-186.250000, 7.750000, 0.000000>, <-182.700000, 8.400000, 0.000000>, <-179.150000, 9.050000, 0.000000>, <-175.625000, 9.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-186.250000, 7.750000, 0.000000>, <-182.700000, 8.400000, 0.000000>, <-179.150000, 9.050000, 0.000000>, <-175.625000, 9.700000, 0.000000>, 
      <-186.800000, 10.700000, 1.000000>, <-183.200000, 11.400000, 1.000000>, <-179.700000, 12.000000, 1.000000>, <-176.150000, 12.650000, 1.000000>, 
      <-186.800000, 10.900000, -1.000000>, <-183.300000, 11.600000, -1.000000>, <-179.800000, 12.200000, -1.000000>, <-176.250000, 12.850000, -1.000000>, 
      <-187.350000, 13.900000, 0.000000>, <-183.850000, 14.550000, 0.000000>, <-180.300000, 15.200000, 0.000000>, <-176.775000, 15.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-187.350000, 13.900000, 0.000000>, <-183.850000, 14.550000, 0.000000>, <-180.300000, 15.200000, 0.000000>, <-176.775000, 15.850000, 0.000000>, 
      <-187.900000, 16.900000, 1.000000>, <-184.400000, 17.500000, 1.000000>, <-180.800000, 18.200000, 1.000000>, <-177.300000, 18.850000, 1.000000>, 
      <-188.000000, 17.100000, -1.000000>, <-184.400000, 17.800000, -1.000000>, <-180.900000, 18.400000, -1.000000>, <-177.350000, 19.050000, -1.000000>, 
      <-188.500000, 20.100000, 0.000000>, <-184.950000, 20.750000, 0.000000>, <-181.450000, 22.100000, 0.000000>, <-177.900000, 22.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-188.500000, 20.100000, 0.000000>, <-184.950000, 20.750000, 0.000000>, <-181.450000, 22.100000, 0.000000>, <-177.900000, 22.750000, 0.000000>, 
      <-189.000000, 23.100000, 1.000000>, <-185.500000, 23.700000, 1.000000>, <-182.000000, 25.800000, 1.000000>, <-178.450000, 26.450000, 1.000000>, 
      <-189.100000, 23.300000, -1.000000>, <-185.500000, 25.400000, -1.000000>, <-182.000000, 26.000000, -1.000000>, <-178.450000, 26.650000, -1.000000>, 
      <-189.650000, 27.000000, 0.000000>, <-186.050000, 28.350000, 0.000000>, <-182.550000, 29.000000, 0.000000>, <-179.000000, 29.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-189.650000, 27.000000, 0.000000>, <-186.050000, 28.350000, 0.000000>, <-182.550000, 29.000000, 0.000000>, <-179.000000, 29.625000, 0.000000>, 
      <-190.200000, 30.700000, 1.000000>, <-186.600000, 31.300000, 1.000000>, <-183.100000, 32.000000, 1.000000>, <-179.550000, 32.600000, 1.000000>, 
      <-190.200000, 30.900000, -1.000000>, <-186.700000, 31.500000, -1.000000>, <-183.100000, 32.200000, -1.000000>, <-179.600000, 32.850000, -1.000000>, 
      <-190.750000, 33.850000, 0.000000>, <-187.200000, 34.500000, 0.000000>, <-183.650000, 35.150000, 0.000000>, <-180.125000, 35.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-190.750000, 33.850000, 0.000000>, <-187.200000, 34.500000, 0.000000>, <-183.650000, 35.150000, 0.000000>, <-180.125000, 35.800000, 0.000000>, 
      <-191.300000, 36.800000, 1.000000>, <-187.700000, 37.500000, 1.000000>, <-184.200000, 38.100000, 1.000000>, <-180.650000, 38.750000, 1.000000>, 
      <-191.300000, 37.000000, -1.000000>, <-187.800000, 37.700000, -1.000000>, <-184.300000, 38.300000, -1.000000>, <-180.750000, 38.950000, -1.000000>, 
      <-192.150000, 41.150000, 0.000000>, <-188.600000, 41.800000, 0.000000>, <-185.100000, 42.450000, 0.000000>, <-181.550000, 43.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-192.150000, 41.150000, 0.000000>, <-188.600000, 41.800000, 0.000000>, <-185.100000, 42.450000, 0.000000>, <-181.550000, 43.100000, 0.000000>, 
      <-193.000000, 45.300000, 1.000000>, <-189.400000, 45.900000, 1.000000>, <-185.900000, 46.600000, 1.000000>, <-182.350000, 47.250000, 1.000000>, 
      <-193.000000, 45.500000, -1.000000>, <-189.500000, 46.100000, -1.000000>, <-186.000000, 46.800000, -1.000000>, <-182.450000, 47.450000, -1.000000>, 
      <-193.550000, 48.500000, 0.000000>, <-190.050000, 49.100000, 0.000000>, <-186.500000, 49.750000, 0.000000>, <-182.975000, 50.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-193.550000, 48.500000, 0.000000>, <-190.050000, 49.100000, 0.000000>, <-186.500000, 49.750000, 0.000000>, <-182.975000, 50.775000, 0.000000>, 
      <-194.100000, 51.500000, 1.000000>, <-190.600000, 52.100000, 1.000000>, <-187.000000, 52.700000, 1.000000>, <-183.500000, 54.100000, 1.000000>, 
      <-194.200000, 51.700000, -1.000000>, <-190.600000, 52.300000, -1.000000>, <-187.100000, 53.000000, -1.000000>, <-183.550000, 54.350000, -1.000000>, 
      <-194.900000, 55.500000, 0.700000>, <-191.300000, 56.100000, 0.700000>, <-187.800000, 56.800000, 0.700000>, <-184.250000, 58.150000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-149.550000, -133.150000, -1.000000>, <-146.000000, -132.500000, -1.000000>, <-142.500000, -131.900000, -1.000000>, <-138.950000, -131.250000, -1.000000>, 
      <-150.250000, -129.250000, 1.000000>, <-146.700000, -128.600000, 1.000000>, <-143.200000, -128.000000, 1.000000>, <-139.650000, -127.350000, 1.000000>, 
      <-150.300000, -129.050000, -1.000000>, <-146.800000, -128.400000, -1.000000>, <-143.200000, -127.800000, -1.000000>, <-139.700000, -127.150000, -1.000000>, 
      <-150.825000, -126.050000, 0.000000>, <-147.300000, -125.400000, 0.000000>, <-143.750000, -124.800000, 0.000000>, <-140.225000, -124.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-150.825000, -126.050000, 0.000000>, <-147.300000, -125.400000, 0.000000>, <-143.750000, -124.800000, 0.000000>, <-140.225000, -124.150000, 0.000000>, 
      <-151.350000, -123.050000, 1.000000>, <-147.800000, -122.400000, 1.000000>, <-144.300000, -121.800000, 1.000000>, <-140.750000, -121.150000, 1.000000>, 
      <-151.450000, -122.850000, -1.000000>, <-147.900000, -122.200000, -1.000000>, <-144.400000, -121.600000, -1.000000>, <-140.850000, -120.950000, -1.000000>, 
      <-151.975000, -119.900000, 0.000000>, <-148.450000, -119.250000, 0.000000>, <-144.900000, -118.600000, 0.000000>, <-141.375000, -117.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-151.975000, -119.900000, 0.000000>, <-148.450000, -119.250000, 0.000000>, <-144.900000, -118.600000, 0.000000>, <-141.375000, -117.950000, 0.000000>, 
      <-152.500000, -116.950000, 1.000000>, <-149.000000, -116.300000, 1.000000>, <-145.400000, -115.600000, 1.000000>, <-141.900000, -114.950000, 1.000000>, 
      <-152.550000, -116.750000, -1.000000>, <-149.000000, -116.100000, -1.000000>, <-145.500000, -115.400000, -1.000000>, <-141.950000, -114.750000, -1.000000>, 
      <-153.100000, -113.750000, 0.000000>, <-149.550000, -113.100000, 0.000000>, <-146.050000, -112.450000, 0.000000>, <-142.500000, -111.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-153.100000, -113.750000, 0.000000>, <-149.550000, -113.100000, 0.000000>, <-146.050000, -112.450000, 0.000000>, <-142.500000, -111.800000, 0.000000>, 
      <-153.650000, -110.750000, 1.000000>, <-150.100000, -110.100000, 1.000000>, <-146.600000, -109.500000, 1.000000>, <-143.050000, -108.850000, 1.000000>, 
      <-153.650000, -110.550000, -1.000000>, <-150.100000, -109.900000, -1.000000>, <-146.600000, -109.200000, -1.000000>, <-143.050000, -108.600000, -1.000000>, 
      <-154.200000, -107.550000, 0.000000>, <-150.650000, -106.900000, 0.000000>, <-147.150000, -106.250000, 0.000000>, <-143.600000, -105.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.200000, -107.550000, 0.000000>, <-150.650000, -106.900000, 0.000000>, <-147.150000, -106.250000, 0.000000>, <-143.600000, -105.625000, 0.000000>, 
      <-154.750000, -104.550000, 1.000000>, <-151.200000, -103.900000, 1.000000>, <-147.700000, -103.300000, 1.000000>, <-144.150000, -102.650000, 1.000000>, 
      <-154.800000, -104.350000, -1.000000>, <-151.300000, -103.700000, -1.000000>, <-147.700000, -103.100000, -1.000000>, <-144.200000, -102.450000, -1.000000>, 
      <-155.325000, -101.400000, 0.000000>, <-151.800000, -100.750000, 0.000000>, <-148.250000, -100.100000, 0.000000>, <-144.725000, -99.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-155.325000, -101.400000, 0.000000>, <-151.800000, -100.750000, 0.000000>, <-148.250000, -100.100000, 0.000000>, <-144.725000, -99.450000, 0.000000>, 
      <-155.850000, -98.450000, 1.000000>, <-152.300000, -97.800000, 1.000000>, <-148.800000, -97.100000, 1.000000>, <-145.250000, -96.450000, 1.000000>, 
      <-155.950000, -98.150000, -1.000000>, <-152.400000, -97.500000, -1.000000>, <-148.900000, -96.900000, -1.000000>, <-145.350000, -96.250000, -1.000000>, 
      <-156.475000, -95.200000, 0.000000>, <-152.950000, -94.550000, 0.000000>, <-149.400000, -93.900000, 0.000000>, <-145.875000, -93.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-156.475000, -95.200000, 0.000000>, <-152.950000, -94.550000, 0.000000>, <-149.400000, -93.900000, 0.000000>, <-145.875000, -93.275000, 0.000000>, 
      <-157.000000, -92.250000, 1.000000>, <-153.500000, -91.600000, 1.000000>, <-149.900000, -90.900000, 1.000000>, <-146.400000, -90.300000, 1.000000>, 
      <-157.050000, -92.050000, -1.000000>, <-153.500000, -91.400000, -1.000000>, <-150.000000, -90.700000, -1.000000>, <-146.450000, -90.050000, -1.000000>, 
      <-157.600000, -89.050000, 0.000000>, <-154.050000, -88.400000, 0.000000>, <-150.550000, -87.750000, 0.000000>, <-147.000000, -87.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-157.600000, -89.050000, 0.000000>, <-154.050000, -88.400000, 0.000000>, <-150.550000, -87.750000, 0.000000>, <-147.000000, -87.100000, 0.000000>, 
      <-158.150000, -86.050000, 1.000000>, <-154.600000, -85.400000, 1.000000>, <-151.100000, -84.800000, 1.000000>, <-147.550000, -84.150000, 1.000000>, 
      <-158.200000, -85.850000, -1.000000>, <-154.700000, -85.200000, -1.000000>, <-151.100000, -84.600000, -1.000000>, <-147.550000, -83.950000, -1.000000>, 
      <-158.725000, -82.850000, 0.000000>, <-155.200000, -82.200000, 0.000000>, <-151.650000, -81.600000, 0.000000>, <-148.100000, -80.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-158.725000, -82.850000, 0.000000>, <-155.200000, -82.200000, 0.000000>, <-151.650000, -81.600000, 0.000000>, <-148.100000, -80.950000, 0.000000>, 
      <-159.250000, -79.850000, 1.000000>, <-155.700000, -79.200000, 1.000000>, <-152.200000, -78.600000, 1.000000>, <-148.650000, -77.950000, 1.000000>, 
      <-159.300000, -79.650000, -1.000000>, <-155.800000, -79.000000, -1.000000>, <-152.200000, -78.400000, -1.000000>, <-148.700000, -77.750000, -1.000000>, 
      <-159.850000, -76.700000, 0.000000>, <-156.350000, -76.050000, 0.000000>, <-152.750000, -75.400000, 0.000000>, <-149.225000, -74.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-159.850000, -76.700000, 0.000000>, <-156.350000, -76.050000, 0.000000>, <-152.750000, -75.400000, 0.000000>, <-149.225000, -74.750000, 0.000000>, 
      <-160.400000, -73.750000, 1.000000>, <-156.900000, -73.100000, 1.000000>, <-153.300000, -72.400000, 1.000000>, <-149.750000, -71.750000, 1.000000>, 
      <-160.450000, -73.550000, -1.000000>, <-156.900000, -72.900000, -1.000000>, <-153.400000, -72.200000, -1.000000>, <-149.850000, -71.550000, -1.000000>, 
      <-160.975000, -70.550000, 0.000000>, <-157.450000, -69.900000, 0.000000>, <-153.900000, -69.250000, 0.000000>, <-150.375000, -68.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-160.975000, -70.550000, 0.000000>, <-157.450000, -69.900000, 0.000000>, <-153.900000, -69.250000, 0.000000>, <-150.375000, -68.600000, 0.000000>, 
      <-161.500000, -67.550000, 1.000000>, <-158.000000, -66.900000, 1.000000>, <-154.400000, -66.300000, 1.000000>, <-150.900000, -65.650000, 1.000000>, 
      <-161.550000, -67.350000, -1.000000>, <-158.000000, -66.700000, -1.000000>, <-154.500000, -66.000000, -1.000000>, <-150.950000, -65.400000, -1.000000>, 
      <-162.100000, -64.350000, 0.000000>, <-158.550000, -63.700000, 0.000000>, <-155.050000, -63.050000, 0.000000>, <-151.500000, -62.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-162.100000, -64.350000, 0.000000>, <-158.550000, -63.700000, 0.000000>, <-155.050000, -63.050000, 0.000000>, <-151.500000, -62.425000, 0.000000>, 
      <-162.650000, -61.350000, 1.000000>, <-159.100000, -60.700000, 1.000000>, <-155.600000, -60.100000, 1.000000>, <-152.050000, -59.450000, 1.000000>, 
      <-162.700000, -61.150000, -1.000000>, <-159.200000, -60.500000, -1.000000>, <-155.600000, -59.900000, -1.000000>, <-152.100000, -59.250000, -1.000000>, 
      <-163.225000, -58.200000, 0.000000>, <-159.700000, -57.550000, 0.000000>, <-156.150000, -56.900000, 0.000000>, <-152.625000, -56.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-163.225000, -58.200000, 0.000000>, <-159.700000, -57.550000, 0.000000>, <-156.150000, -56.900000, 0.000000>, <-152.625000, -56.250000, 0.000000>, 
      <-163.750000, -55.250000, 1.000000>, <-160.200000, -54.600000, 1.000000>, <-156.700000, -53.900000, 1.000000>, <-153.150000, -53.250000, 1.000000>, 
      <-163.850000, -55.000000, -1.000000>, <-160.300000, -54.400000, -1.000000>, <-156.800000, -53.700000, -1.000000>, <-153.250000, -53.050000, -1.000000>, 
      <-164.375000, -52.025000, 0.000000>, <-160.850000, -51.400000, 0.000000>, <-157.300000, -50.700000, 0.000000>, <-153.775000, -50.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-164.375000, -52.025000, 0.000000>, <-160.850000, -51.400000, 0.000000>, <-157.300000, -50.700000, 0.000000>, <-153.775000, -50.075000, 0.000000>, 
      <-164.900000, -49.050000, 1.000000>, <-161.400000, -48.400000, 1.000000>, <-157.800000, -47.700000, 1.000000>, <-154.300000, -47.100000, 1.000000>, 
      <-164.950000, -48.850000, -1.000000>, <-161.400000, -48.200000, -1.000000>, <-157.900000, -47.500000, -1.000000>, <-154.350000, -46.850000, -1.000000>, 
      <-165.500000, -45.850000, 0.000000>, <-161.950000, -45.200000, 0.000000>, <-158.450000, -44.550000, 0.000000>, <-154.900000, -43.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-165.500000, -45.850000, 0.000000>, <-161.950000, -45.200000, 0.000000>, <-158.450000, -44.550000, 0.000000>, <-154.900000, -43.900000, 0.000000>, 
      <-166.050000, -42.850000, 1.000000>, <-162.500000, -42.200000, 1.000000>, <-159.000000, -41.600000, 1.000000>, <-155.450000, -40.950000, 1.000000>, 
      <-166.050000, -42.650000, -1.000000>, <-162.500000, -42.000000, -1.000000>, <-159.000000, -41.400000, -1.000000>, <-155.450000, -40.750000, -1.000000>, 
      <-166.600000, -39.675000, 0.000000>, <-163.050000, -39.050000, 0.000000>, <-159.550000, -38.400000, 0.000000>, <-156.000000, -37.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-166.600000, -39.675000, 0.000000>, <-163.050000, -39.050000, 0.000000>, <-159.550000, -38.400000, 0.000000>, <-156.000000, -37.750000, 0.000000>, 
      <-167.150000, -36.700000, 1.000000>, <-163.600000, -36.100000, 1.000000>, <-160.100000, -35.400000, 1.000000>, <-156.550000, -34.750000, 1.000000>, 
      <-167.200000, -36.450000, -1.000000>, <-163.700000, -35.800000, -1.000000>, <-160.100000, -35.200000, -1.000000>, <-156.600000, -34.550000, -1.000000>, 
      <-167.725000, -33.500000, 0.000000>, <-164.200000, -32.850000, 0.000000>, <-160.650000, -32.200000, 0.000000>, <-157.125000, -31.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-167.725000, -33.500000, 0.000000>, <-164.200000, -32.850000, 0.000000>, <-160.650000, -32.200000, 0.000000>, <-157.125000, -31.550000, 0.000000>, 
      <-168.250000, -30.550000, 1.000000>, <-164.700000, -29.900000, 1.000000>, <-161.200000, -29.200000, 1.000000>, <-157.650000, -28.550000, 1.000000>, 
      <-168.350000, -30.350000, -1.000000>, <-164.800000, -29.700000, -1.000000>, <-161.300000, -29.000000, -1.000000>, <-157.750000, -28.350000, -1.000000>, 
      <-168.875000, -27.350000, 0.000000>, <-165.350000, -26.700000, 0.000000>, <-161.800000, -26.050000, 0.000000>, <-158.275000, -25.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-168.875000, -27.350000, 0.000000>, <-165.350000, -26.700000, 0.000000>, <-161.800000, -26.050000, 0.000000>, <-158.275000, -25.400000, 0.000000>, 
      <-169.400000, -24.350000, 1.000000>, <-165.900000, -23.700000, 1.000000>, <-162.300000, -23.100000, 1.000000>, <-158.800000, -22.450000, 1.000000>, 
      <-169.450000, -24.150000, -1.000000>, <-165.900000, -23.500000, -1.000000>, <-162.400000, -22.900000, -1.000000>, <-158.850000, -22.250000, -1.000000>, 
      <-170.000000, -21.150000, 0.000000>, <-166.450000, -20.500000, 0.000000>, <-162.950000, -19.900000, 0.000000>, <-159.400000, -19.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-170.000000, -21.150000, 0.000000>, <-166.450000, -20.500000, 0.000000>, <-162.950000, -19.900000, 0.000000>, <-159.400000, -19.250000, 0.000000>, 
      <-170.550000, -18.150000, 1.000000>, <-167.000000, -17.500000, 1.000000>, <-163.500000, -16.900000, 1.000000>, <-159.950000, -16.250000, 1.000000>, 
      <-170.600000, -17.950000, -1.000000>, <-167.100000, -17.300000, -1.000000>, <-163.500000, -16.700000, -1.000000>, <-160.000000, -16.050000, -1.000000>, 
      <-171.125000, -15.000000, 0.000000>, <-167.600000, -14.350000, 0.000000>, <-164.050000, -13.700000, 0.000000>, <-160.525000, -13.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-171.125000, -15.000000, 0.000000>, <-167.600000, -14.350000, 0.000000>, <-164.050000, -13.700000, 0.000000>, <-160.525000, -13.050000, 0.000000>, 
      <-171.650000, -12.050000, 1.000000>, <-168.100000, -11.400000, 1.000000>, <-164.600000, -10.700000, 1.000000>, <-161.050000, -10.050000, 1.000000>, 
      <-171.700000, -11.800000, -1.000000>, <-168.200000, -11.200000, -1.000000>, <-164.600000, -10.500000, -1.000000>, <-161.100000, -9.850000, -1.000000>, 
      <-172.250000, -8.825000, 0.000000>, <-168.750000, -8.200000, 0.000000>, <-165.150000, -7.550000, 0.000000>, <-161.650000, -6.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-172.250000, -8.825000, 0.000000>, <-168.750000, -8.200000, 0.000000>, <-165.150000, -7.550000, 0.000000>, <-161.650000, -6.900000, 0.000000>, 
      <-172.800000, -5.850000, 1.000000>, <-169.300000, -5.200000, 1.000000>, <-165.700000, -4.600000, 1.000000>, <-162.200000, -3.950000, 1.000000>, 
      <-172.850000, -5.650000, -1.000000>, <-169.300000, -5.000000, -1.000000>, <-165.800000, -4.300000, -1.000000>, <-162.250000, -3.700000, -1.000000>, 
      <-173.375000, -2.650000, 0.000000>, <-169.850000, -2.000000, 0.000000>, <-166.300000, -1.350000, 0.000000>, <-162.775000, -0.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-173.375000, -2.650000, 0.000000>, <-169.850000, -2.000000, 0.000000>, <-166.300000, -1.350000, 0.000000>, <-162.775000, -0.725000, 0.000000>, 
      <-173.900000, 0.350000, 1.000000>, <-170.400000, 1.000000, 1.000000>, <-166.800000, 1.600000, 1.000000>, <-163.300000, 2.250000, 1.000000>, 
      <-173.950000, 0.550000, -1.000000>, <-170.400000, 1.200000, -1.000000>, <-166.900000, 1.800000, -1.000000>, <-163.350000, 2.450000, -1.000000>, 
      <-174.500000, 3.525000, 0.000000>, <-170.950000, 4.150000, 0.000000>, <-167.450000, 4.800000, 0.000000>, <-163.900000, 5.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-174.500000, 3.525000, 0.000000>, <-170.950000, 4.150000, 0.000000>, <-167.450000, 4.800000, 0.000000>, <-163.900000, 5.450000, 0.000000>, 
      <-175.050000, 6.500000, 1.000000>, <-171.500000, 7.100000, 1.000000>, <-168.000000, 7.800000, 1.000000>, <-164.450000, 8.450000, 1.000000>, 
      <-175.100000, 6.750000, -1.000000>, <-171.600000, 7.400000, -1.000000>, <-168.000000, 8.000000, -1.000000>, <-164.500000, 8.650000, -1.000000>, 
      <-175.625000, 9.700000, 0.000000>, <-172.100000, 10.350000, 0.000000>, <-168.550000, 11.000000, 0.000000>, <-165.025000, 11.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-175.625000, 9.700000, 0.000000>, <-172.100000, 10.350000, 0.000000>, <-168.550000, 11.000000, 0.000000>, <-165.025000, 11.650000, 0.000000>, 
      <-176.150000, 12.650000, 1.000000>, <-172.600000, 13.300000, 1.000000>, <-169.100000, 14.000000, 1.000000>, <-165.550000, 14.650000, 1.000000>, 
      <-176.250000, 12.850000, -1.000000>, <-172.700000, 13.500000, -1.000000>, <-169.200000, 14.200000, -1.000000>, <-165.650000, 14.850000, -1.000000>, 
      <-176.775000, 15.850000, 0.000000>, <-173.250000, 16.500000, 0.000000>, <-169.700000, 17.150000, 0.000000>, <-166.175000, 17.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-176.775000, 15.850000, 0.000000>, <-173.250000, 16.500000, 0.000000>, <-169.700000, 17.150000, 0.000000>, <-166.175000, 17.800000, 0.000000>, 
      <-177.300000, 18.850000, 1.000000>, <-173.800000, 19.500000, 1.000000>, <-170.200000, 20.100000, 1.000000>, <-166.700000, 20.750000, 1.000000>, 
      <-177.350000, 19.050000, -1.000000>, <-173.800000, 19.700000, -1.000000>, <-170.300000, 20.300000, -1.000000>, <-166.750000, 20.950000, -1.000000>, 
      <-177.900000, 22.750000, 0.000000>, <-174.350000, 23.400000, 0.000000>, <-170.450000, 24.100000, 0.000000>, <-166.475000, 25.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-177.900000, 22.750000, 0.000000>, <-174.350000, 23.400000, 0.000000>, <-170.450000, 24.100000, 0.000000>, <-166.475000, 25.000000, 0.000000>, 
      <-178.450000, 26.450000, 1.000000>, <-174.900000, 27.100000, 1.000000>, <-170.600000, 27.900000, 1.000000>, <-166.200000, 29.050000, 1.000000>, 
      <-178.450000, 26.650000, -1.000000>, <-174.900000, 27.300000, -1.000000>, <-170.700000, 28.100000, -1.000000>, <-166.300000, 29.250000, -1.000000>, 
      <-179.000000, 29.625000, 0.000000>, <-175.450000, 30.250000, 0.000000>, <-170.650000, 31.450000, 0.000000>, <-166.175000, 32.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-179.000000, 29.625000, 0.000000>, <-175.450000, 30.250000, 0.000000>, <-170.650000, 31.450000, 0.000000>, <-166.175000, 32.425000, 0.000000>, 
      <-179.550000, 32.600000, 1.000000>, <-176.000000, 33.200000, 1.000000>, <-170.600000, 34.800000, 1.000000>, <-166.050000, 35.600000, 1.000000>, 
      <-179.600000, 32.850000, -1.000000>, <-176.100000, 33.500000, -1.000000>, <-170.700000, 35.000000, -1.000000>, <-166.100000, 35.800000, -1.000000>, 
      <-180.125000, 35.800000, 0.000000>, <-176.600000, 36.450000, 0.000000>, <-171.500000, 39.100000, 0.000000>, <-166.850000, 39.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-180.125000, 35.800000, 0.000000>, <-176.600000, 36.450000, 0.000000>, <-171.500000, 39.100000, 0.000000>, <-166.850000, 39.925000, 0.000000>, 
      <-180.650000, 38.750000, 1.000000>, <-177.100000, 39.400000, 1.000000>, <-172.300000, 43.200000, 1.000000>, <-167.600000, 44.050000, 1.000000>, 
      <-180.750000, 38.950000, -1.000000>, <-177.200000, 39.600000, -1.000000>, <-172.300000, 43.500000, -1.000000>, <-167.650000, 44.300000, -1.000000>, 
      <-181.550000, 43.100000, 0.000000>, <-178.000000, 43.750000, 0.000000>, <-172.850000, 46.450000, 0.000000>, <-168.125000, 47.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-181.550000, 43.100000, 0.000000>, <-178.000000, 43.750000, 0.000000>, <-172.850000, 46.450000, 0.000000>, <-168.125000, 47.275000, 0.000000>, 
      <-182.350000, 47.250000, 1.000000>, <-178.800000, 47.900000, 1.000000>, <-173.400000, 49.400000, 1.000000>, <-168.600000, 50.250000, 1.000000>, 
      <-182.450000, 47.450000, -1.000000>, <-178.900000, 48.100000, -1.000000>, <-173.500000, 49.600000, -1.000000>, <-168.700000, 50.450000, -1.000000>, 
      <-182.975000, 50.775000, 0.000000>, <-179.450000, 51.800000, 0.000000>, <-174.000000, 53.300000, 0.000000>, <-169.150000, 54.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-182.975000, 50.775000, 0.000000>, <-179.450000, 51.800000, 0.000000>, <-174.000000, 53.300000, 0.000000>, <-169.150000, 54.150000, 0.000000>, 
      <-183.500000, 54.100000, 1.000000>, <-180.000000, 55.500000, 1.000000>, <-174.500000, 57.000000, 1.000000>, <-169.600000, 57.850000, 1.000000>, 
      <-183.550000, 54.350000, -1.000000>, <-180.000000, 55.700000, -1.000000>, <-174.600000, 57.200000, -1.000000>, <-169.700000, 58.050000, -1.000000>, 
      <-184.250000, 58.150000, 0.700000>, <-180.700000, 59.500000, 0.700000>, <-175.300000, 61.100000, 0.700000>, <-170.350000, 61.950000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-138.950000, -131.250000, -1.000000>, <-135.400000, -130.600000, -1.000000>, <-131.900000, -129.900000, -1.000000>, <-128.350000, -129.250000, -1.000000>, 
      <-139.650000, -127.350000, 1.000000>, <-136.100000, -126.700000, 1.000000>, <-132.600000, -126.000000, 1.000000>, <-129.050000, -125.350000, 1.000000>, 
      <-139.700000, -127.150000, -1.000000>, <-136.200000, -126.500000, -1.000000>, <-132.600000, -125.800000, -1.000000>, <-129.100000, -125.150000, -1.000000>, 
      <-140.225000, -124.150000, 0.000000>, <-136.700000, -123.500000, 0.000000>, <-133.150000, -122.850000, 0.000000>, <-129.625000, -122.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.225000, -124.150000, 0.000000>, <-136.700000, -123.500000, 0.000000>, <-133.150000, -122.850000, 0.000000>, <-129.625000, -122.200000, 0.000000>, 
      <-140.750000, -121.150000, 1.000000>, <-137.200000, -120.500000, 1.000000>, <-133.700000, -119.900000, 1.000000>, <-130.150000, -119.250000, 1.000000>, 
      <-140.850000, -120.950000, -1.000000>, <-137.300000, -120.300000, -1.000000>, <-133.800000, -119.600000, -1.000000>, <-130.250000, -119.000000, -1.000000>, 
      <-141.375000, -117.950000, 0.000000>, <-137.850000, -117.300000, 0.000000>, <-134.300000, -116.650000, 0.000000>, <-130.775000, -116.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-141.375000, -117.950000, 0.000000>, <-137.850000, -117.300000, 0.000000>, <-134.300000, -116.650000, 0.000000>, <-130.775000, -116.025000, 0.000000>, 
      <-141.900000, -114.950000, 1.000000>, <-138.400000, -114.300000, 1.000000>, <-134.800000, -113.700000, 1.000000>, <-131.300000, -113.050000, 1.000000>, 
      <-141.950000, -114.750000, -1.000000>, <-138.400000, -114.100000, -1.000000>, <-134.900000, -113.500000, -1.000000>, <-131.350000, -112.850000, -1.000000>, 
      <-142.500000, -111.800000, 0.000000>, <-138.950000, -111.150000, 0.000000>, <-135.400000, -110.500000, 0.000000>, <-131.875000, -109.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-142.500000, -111.800000, 0.000000>, <-138.950000, -111.150000, 0.000000>, <-135.400000, -110.500000, 0.000000>, <-131.875000, -109.850000, 0.000000>, 
      <-143.050000, -108.850000, 1.000000>, <-139.500000, -108.200000, 1.000000>, <-135.900000, -107.500000, 1.000000>, <-132.400000, -106.850000, 1.000000>, 
      <-143.050000, -108.600000, -1.000000>, <-139.500000, -108.000000, -1.000000>, <-136.000000, -107.300000, -1.000000>, <-132.450000, -106.650000, -1.000000>, 
      <-143.600000, -105.625000, 0.000000>, <-140.050000, -105.000000, 0.000000>, <-136.550000, -104.300000, 0.000000>, <-133.000000, -103.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-143.600000, -105.625000, 0.000000>, <-140.050000, -105.000000, 0.000000>, <-136.550000, -104.300000, 0.000000>, <-133.000000, -103.675000, 0.000000>, 
      <-144.150000, -102.650000, 1.000000>, <-140.600000, -102.000000, 1.000000>, <-137.100000, -101.300000, 1.000000>, <-133.550000, -100.700000, 1.000000>, 
      <-144.200000, -102.450000, -1.000000>, <-140.700000, -101.800000, -1.000000>, <-137.100000, -101.100000, -1.000000>, <-133.600000, -100.450000, -1.000000>, 
      <-144.725000, -99.450000, 0.000000>, <-141.200000, -98.800000, 0.000000>, <-137.650000, -98.150000, 0.000000>, <-134.125000, -97.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-144.725000, -99.450000, 0.000000>, <-141.200000, -98.800000, 0.000000>, <-137.650000, -98.150000, 0.000000>, <-134.125000, -97.500000, 0.000000>, 
      <-145.250000, -96.450000, 1.000000>, <-141.700000, -95.800000, 1.000000>, <-138.200000, -95.200000, 1.000000>, <-134.650000, -94.550000, 1.000000>, 
      <-145.350000, -96.250000, -1.000000>, <-141.800000, -95.600000, -1.000000>, <-138.300000, -95.000000, -1.000000>, <-134.750000, -94.350000, -1.000000>, 
      <-145.875000, -93.275000, 0.000000>, <-142.350000, -92.650000, 0.000000>, <-138.800000, -92.000000, 0.000000>, <-135.275000, -91.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-145.875000, -93.275000, 0.000000>, <-142.350000, -92.650000, 0.000000>, <-138.800000, -92.000000, 0.000000>, <-135.275000, -91.350000, 0.000000>, 
      <-146.400000, -90.300000, 1.000000>, <-142.900000, -89.700000, 1.000000>, <-139.300000, -89.000000, 1.000000>, <-135.800000, -88.350000, 1.000000>, 
      <-146.450000, -90.050000, -1.000000>, <-142.900000, -89.400000, -1.000000>, <-139.400000, -88.800000, -1.000000>, <-135.850000, -88.150000, -1.000000>, 
      <-147.000000, -87.100000, 0.000000>, <-143.450000, -86.450000, 0.000000>, <-139.950000, -85.800000, 0.000000>, <-136.400000, -85.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-147.000000, -87.100000, 0.000000>, <-143.450000, -86.450000, 0.000000>, <-139.950000, -85.800000, 0.000000>, <-136.400000, -85.150000, 0.000000>, 
      <-147.550000, -84.150000, 1.000000>, <-144.000000, -83.500000, 1.000000>, <-140.500000, -82.800000, 1.000000>, <-136.950000, -82.150000, 1.000000>, 
      <-147.550000, -83.950000, -1.000000>, <-144.000000, -83.300000, -1.000000>, <-140.500000, -82.600000, -1.000000>, <-136.950000, -81.950000, -1.000000>, 
      <-148.100000, -80.950000, 0.000000>, <-144.550000, -80.300000, 0.000000>, <-141.050000, -79.650000, 0.000000>, <-137.500000, -79.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-148.100000, -80.950000, 0.000000>, <-144.550000, -80.300000, 0.000000>, <-141.050000, -79.650000, 0.000000>, <-137.500000, -79.000000, 0.000000>, 
      <-148.650000, -77.950000, 1.000000>, <-145.100000, -77.300000, 1.000000>, <-141.600000, -76.700000, 1.000000>, <-138.050000, -76.050000, 1.000000>, 
      <-148.700000, -77.750000, -1.000000>, <-145.200000, -77.100000, -1.000000>, <-141.600000, -76.500000, -1.000000>, <-138.100000, -75.850000, -1.000000>, 
      <-149.225000, -74.750000, 0.000000>, <-145.700000, -74.100000, 0.000000>, <-142.150000, -73.500000, 0.000000>, <-138.625000, -72.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-149.225000, -74.750000, 0.000000>, <-145.700000, -74.100000, 0.000000>, <-142.150000, -73.500000, 0.000000>, <-138.625000, -72.850000, 0.000000>, 
      <-149.750000, -71.750000, 1.000000>, <-146.200000, -71.100000, 1.000000>, <-142.700000, -70.500000, 1.000000>, <-139.150000, -69.850000, 1.000000>, 
      <-149.850000, -71.550000, -1.000000>, <-146.300000, -70.900000, -1.000000>, <-142.800000, -70.300000, -1.000000>, <-139.250000, -69.650000, -1.000000>, 
      <-150.375000, -68.600000, 0.000000>, <-146.850000, -67.950000, 0.000000>, <-143.300000, -67.300000, 0.000000>, <-139.775000, -66.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-150.375000, -68.600000, 0.000000>, <-146.850000, -67.950000, 0.000000>, <-143.300000, -67.300000, 0.000000>, <-139.775000, -66.650000, 0.000000>, 
      <-150.900000, -65.650000, 1.000000>, <-147.400000, -65.000000, 1.000000>, <-143.800000, -64.300000, 1.000000>, <-140.300000, -63.650000, 1.000000>, 
      <-150.950000, -65.400000, -1.000000>, <-147.400000, -64.800000, -1.000000>, <-143.900000, -64.100000, -1.000000>, <-140.350000, -63.450000, -1.000000>, 
      <-151.500000, -62.425000, 0.000000>, <-147.950000, -61.800000, 0.000000>, <-144.450000, -61.150000, 0.000000>, <-140.900000, -60.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-151.500000, -62.425000, 0.000000>, <-147.950000, -61.800000, 0.000000>, <-144.450000, -61.150000, 0.000000>, <-140.900000, -60.500000, 0.000000>, 
      <-152.050000, -59.450000, 1.000000>, <-148.500000, -58.800000, 1.000000>, <-145.000000, -58.200000, 1.000000>, <-141.450000, -57.550000, 1.000000>, 
      <-152.100000, -59.250000, -1.000000>, <-148.600000, -58.600000, -1.000000>, <-145.000000, -57.900000, -1.000000>, <-141.500000, -57.250000, -1.000000>, 
      <-152.625000, -56.250000, 0.000000>, <-149.100000, -55.600000, 0.000000>, <-145.550000, -54.950000, 0.000000>, <-142.025000, -54.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-152.625000, -56.250000, 0.000000>, <-149.100000, -55.600000, 0.000000>, <-145.550000, -54.950000, 0.000000>, <-142.025000, -54.300000, 0.000000>, 
      <-153.150000, -53.250000, 1.000000>, <-149.600000, -52.600000, 1.000000>, <-146.100000, -52.000000, 1.000000>, <-142.550000, -51.350000, 1.000000>, 
      <-153.250000, -53.050000, -1.000000>, <-149.700000, -52.400000, -1.000000>, <-146.200000, -51.800000, -1.000000>, <-142.650000, -51.150000, -1.000000>, 
      <-153.775000, -50.075000, 0.000000>, <-150.250000, -49.450000, 0.000000>, <-146.700000, -48.800000, 0.000000>, <-143.175000, -48.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-153.775000, -50.075000, 0.000000>, <-150.250000, -49.450000, 0.000000>, <-146.700000, -48.800000, 0.000000>, <-143.175000, -48.150000, 0.000000>, 
      <-154.300000, -47.100000, 1.000000>, <-150.800000, -46.500000, 1.000000>, <-147.200000, -45.800000, 1.000000>, <-143.700000, -45.150000, 1.000000>, 
      <-154.350000, -46.850000, -1.000000>, <-150.800000, -46.200000, -1.000000>, <-147.300000, -45.600000, -1.000000>, <-143.750000, -44.950000, -1.000000>, 
      <-154.900000, -43.900000, 0.000000>, <-151.350000, -43.250000, 0.000000>, <-147.850000, -42.600000, 0.000000>, <-144.300000, -41.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.900000, -43.900000, 0.000000>, <-151.350000, -43.250000, 0.000000>, <-147.850000, -42.600000, 0.000000>, <-144.300000, -41.950000, 0.000000>, 
      <-155.450000, -40.950000, 1.000000>, <-151.900000, -40.300000, 1.000000>, <-148.400000, -39.600000, 1.000000>, <-144.850000, -38.950000, 1.000000>, 
      <-155.450000, -40.750000, -1.000000>, <-151.900000, -40.100000, -1.000000>, <-148.400000, -39.400000, -1.000000>, <-144.850000, -38.750000, -1.000000>, 
      <-156.000000, -37.750000, 0.000000>, <-152.450000, -37.100000, 0.000000>, <-148.950000, -36.450000, 0.000000>, <-145.400000, -35.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-156.000000, -37.750000, 0.000000>, <-152.450000, -37.100000, 0.000000>, <-148.950000, -36.450000, 0.000000>, <-145.400000, -35.800000, 0.000000>, 
      <-156.550000, -34.750000, 1.000000>, <-153.000000, -34.100000, 1.000000>, <-149.500000, -33.500000, 1.000000>, <-145.950000, -32.850000, 1.000000>, 
      <-156.600000, -34.550000, -1.000000>, <-153.100000, -33.900000, -1.000000>, <-149.500000, -33.300000, -1.000000>, <-146.000000, -32.650000, -1.000000>, 
      <-157.125000, -31.550000, 0.000000>, <-153.600000, -30.900000, 0.000000>, <-150.050000, -30.300000, 0.000000>, <-146.525000, -29.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-157.125000, -31.550000, 0.000000>, <-153.600000, -30.900000, 0.000000>, <-150.050000, -30.300000, 0.000000>, <-146.525000, -29.650000, 0.000000>, 
      <-157.650000, -28.550000, 1.000000>, <-154.100000, -27.900000, 1.000000>, <-150.600000, -27.300000, 1.000000>, <-147.050000, -26.650000, 1.000000>, 
      <-157.750000, -28.350000, -1.000000>, <-154.200000, -27.700000, -1.000000>, <-150.700000, -27.100000, -1.000000>, <-147.150000, -26.450000, -1.000000>, 
      <-158.275000, -25.400000, 0.000000>, <-154.750000, -24.750000, 0.000000>, <-151.200000, -24.100000, 0.000000>, <-147.675000, -23.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-158.275000, -25.400000, 0.000000>, <-154.750000, -24.750000, 0.000000>, <-151.200000, -24.100000, 0.000000>, <-147.675000, -23.450000, 0.000000>, 
      <-158.800000, -22.450000, 1.000000>, <-155.300000, -21.800000, 1.000000>, <-151.700000, -21.100000, 1.000000>, <-148.200000, -20.450000, 1.000000>, 
      <-158.850000, -22.250000, -1.000000>, <-155.300000, -21.600000, -1.000000>, <-151.800000, -20.900000, -1.000000>, <-148.250000, -20.250000, -1.000000>, 
      <-159.400000, -19.250000, 0.000000>, <-155.850000, -18.600000, 0.000000>, <-152.350000, -17.950000, 0.000000>, <-148.800000, -17.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-159.400000, -19.250000, 0.000000>, <-155.850000, -18.600000, 0.000000>, <-152.350000, -17.950000, 0.000000>, <-148.800000, -17.300000, 0.000000>, 
      <-159.950000, -16.250000, 1.000000>, <-156.400000, -15.600000, 1.000000>, <-152.900000, -15.000000, 1.000000>, <-149.350000, -14.350000, 1.000000>, 
      <-160.000000, -16.050000, -1.000000>, <-156.500000, -15.400000, -1.000000>, <-152.900000, -14.700000, -1.000000>, <-149.350000, -14.100000, -1.000000>, 
      <-160.525000, -13.050000, 0.000000>, <-157.000000, -12.400000, 0.000000>, <-153.450000, -11.750000, 0.000000>, <-149.900000, -11.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-160.525000, -13.050000, 0.000000>, <-157.000000, -12.400000, 0.000000>, <-153.450000, -11.750000, 0.000000>, <-149.900000, -11.125000, 0.000000>, 
      <-161.050000, -10.050000, 1.000000>, <-157.500000, -9.400000, 1.000000>, <-154.000000, -8.800000, 1.000000>, <-150.450000, -8.150000, 1.000000>, 
      <-161.100000, -9.850000, -1.000000>, <-157.600000, -9.200000, -1.000000>, <-154.000000, -8.600000, -1.000000>, <-150.500000, -7.950000, -1.000000>, 
      <-161.650000, -6.900000, 0.000000>, <-158.150000, -6.250000, 0.000000>, <-154.550000, -5.600000, 0.000000>, <-151.025000, -4.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-161.650000, -6.900000, 0.000000>, <-158.150000, -6.250000, 0.000000>, <-154.550000, -5.600000, 0.000000>, <-151.025000, -4.950000, 0.000000>, 
      <-162.200000, -3.950000, 1.000000>, <-158.700000, -3.300000, 1.000000>, <-155.100000, -2.600000, 1.000000>, <-151.550000, -1.950000, 1.000000>, 
      <-162.250000, -3.700000, -1.000000>, <-158.700000, -3.100000, -1.000000>, <-155.200000, -2.400000, -1.000000>, <-151.650000, -1.750000, -1.000000>, 
      <-162.775000, -0.725000, 0.000000>, <-159.250000, -0.100000, 0.000000>, <-155.700000, 0.600000, 0.000000>, <-152.175000, 1.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-162.775000, -0.725000, 0.000000>, <-159.250000, -0.100000, 0.000000>, <-155.700000, 0.600000, 0.000000>, <-152.175000, 1.225000, 0.000000>, 
      <-163.300000, 2.250000, 1.000000>, <-159.800000, 2.900000, 1.000000>, <-156.200000, 3.600000, 1.000000>, <-152.700000, 4.200000, 1.000000>, 
      <-163.350000, 2.450000, -1.000000>, <-159.800000, 3.100000, -1.000000>, <-156.300000, 3.800000, -1.000000>, <-152.750000, 4.450000, -1.000000>, 
      <-163.900000, 5.450000, 0.000000>, <-160.350000, 6.100000, 0.000000>, <-156.850000, 6.750000, 0.000000>, <-153.300000, 7.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-163.900000, 5.450000, 0.000000>, <-160.350000, 6.100000, 0.000000>, <-156.850000, 6.750000, 0.000000>, <-153.300000, 7.400000, 0.000000>, 
      <-164.450000, 8.450000, 1.000000>, <-160.900000, 9.100000, 1.000000>, <-157.400000, 9.700000, 1.000000>, <-153.850000, 10.350000, 1.000000>, 
      <-164.500000, 8.650000, -1.000000>, <-161.000000, 9.300000, -1.000000>, <-157.400000, 9.900000, -1.000000>, <-153.900000, 10.550000, -1.000000>, 
      <-165.025000, 11.650000, 0.000000>, <-161.500000, 12.300000, 0.000000>, <-157.950000, 12.900000, 0.000000>, <-154.425000, 13.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-165.025000, 11.650000, 0.000000>, <-161.500000, 12.300000, 0.000000>, <-157.950000, 12.900000, 0.000000>, <-154.425000, 13.550000, 0.000000>, 
      <-165.550000, 14.650000, 1.000000>, <-162.000000, 15.300000, 1.000000>, <-158.500000, 15.900000, 1.000000>, <-154.950000, 16.550000, 1.000000>, 
      <-165.650000, 14.850000, -1.000000>, <-162.100000, 15.500000, -1.000000>, <-158.600000, 16.100000, -1.000000>, <-155.050000, 16.750000, -1.000000>, 
      <-166.175000, 17.800000, 0.000000>, <-162.650000, 18.450000, 0.000000>, <-159.100000, 19.100000, 0.000000>, <-154.550000, 20.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-166.175000, 17.800000, 0.000000>, <-162.650000, 18.450000, 0.000000>, <-159.100000, 19.100000, 0.000000>, <-154.550000, 20.225000, 0.000000>, 
      <-166.700000, 20.750000, 1.000000>, <-163.200000, 21.400000, 1.000000>, <-159.600000, 22.100000, 1.000000>, <-154.050000, 23.700000, 1.000000>, 
      <-166.750000, 20.950000, -1.000000>, <-163.200000, 21.600000, -1.000000>, <-159.700000, 22.300000, -1.000000>, <-154.150000, 23.900000, -1.000000>, 
      <-166.475000, 25.000000, 0.000000>, <-162.500000, 25.900000, 0.000000>, <-159.000000, 26.500000, 0.000000>, <-154.050000, 27.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-166.475000, 25.000000, 0.000000>, <-162.500000, 25.900000, 0.000000>, <-159.000000, 26.500000, 0.000000>, <-154.050000, 27.475000, 0.000000>, 
      <-166.200000, 29.050000, 1.000000>, <-161.800000, 30.200000, 1.000000>, <-158.300000, 30.700000, 1.000000>, <-153.950000, 31.050000, 1.000000>, 
      <-166.300000, 29.250000, -1.000000>, <-161.900000, 30.400000, -1.000000>, <-158.300000, 30.900000, -1.000000>, <-154.000000, 31.250000, -1.000000>, 
      <-166.175000, 32.425000, 0.000000>, <-161.700000, 33.400000, 0.000000>, <-158.100000, 33.900000, 0.000000>, <-153.350000, 34.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-166.175000, 32.425000, 0.000000>, <-161.700000, 33.400000, 0.000000>, <-158.100000, 33.900000, 0.000000>, <-153.350000, 34.500000, 0.000000>, 
      <-166.050000, 35.600000, 1.000000>, <-161.500000, 36.400000, 1.000000>, <-157.900000, 36.900000, 1.000000>, <-152.700000, 37.750000, 1.000000>, 
      <-166.100000, 35.800000, -1.000000>, <-161.500000, 36.600000, -1.000000>, <-158.000000, 37.100000, -1.000000>, <-152.800000, 37.950000, -1.000000>, 
      <-166.850000, 39.925000, 0.000000>, <-162.200000, 40.750000, 0.000000>, <-158.700000, 41.250000, 0.000000>, <-153.550000, 42.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-166.850000, 39.925000, 0.000000>, <-162.200000, 40.750000, 0.000000>, <-158.700000, 41.250000, 0.000000>, <-153.550000, 42.100000, 0.000000>, 
      <-167.600000, 44.050000, 1.000000>, <-162.900000, 44.900000, 1.000000>, <-159.400000, 45.400000, 1.000000>, <-154.300000, 46.250000, 1.000000>, 
      <-167.650000, 44.300000, -1.000000>, <-163.000000, 45.100000, -1.000000>, <-159.400000, 45.600000, -1.000000>, <-154.350000, 46.450000, -1.000000>, 
      <-168.125000, 47.275000, 0.000000>, <-163.400000, 48.100000, 0.000000>, <-159.850000, 48.600000, 0.000000>, <-154.825000, 49.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-168.125000, 47.275000, 0.000000>, <-163.400000, 48.100000, 0.000000>, <-159.850000, 48.600000, 0.000000>, <-154.825000, 49.425000, 0.000000>, 
      <-168.600000, 50.250000, 1.000000>, <-163.800000, 51.100000, 1.000000>, <-160.300000, 51.600000, 1.000000>, <-155.300000, 52.400000, 1.000000>, 
      <-168.700000, 50.450000, -1.000000>, <-163.900000, 51.300000, -1.000000>, <-160.300000, 51.800000, -1.000000>, <-155.350000, 52.600000, -1.000000>, 
      <-169.150000, 54.150000, 0.000000>, <-164.300000, 55.000000, 0.000000>, <-160.750000, 55.550000, 0.000000>, <-155.850000, 55.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-169.150000, 54.150000, 0.000000>, <-164.300000, 55.000000, 0.000000>, <-160.750000, 55.550000, 0.000000>, <-155.850000, 55.975000, 0.000000>, 
      <-169.600000, 57.850000, 1.000000>, <-164.700000, 58.700000, 1.000000>, <-161.200000, 59.300000, 1.000000>, <-156.350000, 59.350000, 1.000000>, 
      <-169.700000, 58.050000, -1.000000>, <-164.800000, 58.900000, -1.000000>, <-161.200000, 59.500000, -1.000000>, <-156.350000, 59.550000, -1.000000>, 
      <-170.350000, 61.950000, 0.700000>, <-165.400000, 62.800000, 0.700000>, <-161.800000, 63.300000, 0.700000>, <-157.000000, 63.350000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-128.350000, -129.250000, -1.000000>, <-124.800000, -128.600000, -1.000000>, <-121.300000, -128.000000, -1.000000>, <-117.750000, -127.350000, -1.000000>, 
      <-129.050000, -125.350000, 1.000000>, <-125.500000, -124.700000, 1.000000>, <-122.000000, -124.100000, 1.000000>, <-118.450000, -123.450000, 1.000000>, 
      <-129.100000, -125.150000, -1.000000>, <-125.600000, -124.500000, -1.000000>, <-122.000000, -123.900000, -1.000000>, <-118.500000, -123.250000, -1.000000>, 
      <-129.625000, -122.200000, 0.000000>, <-126.100000, -121.550000, 0.000000>, <-122.550000, -120.900000, 0.000000>, <-119.025000, -120.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-129.625000, -122.200000, 0.000000>, <-126.100000, -121.550000, 0.000000>, <-122.550000, -120.900000, 0.000000>, <-119.025000, -120.250000, 0.000000>, 
      <-130.150000, -119.250000, 1.000000>, <-126.600000, -118.600000, 1.000000>, <-123.100000, -117.900000, 1.000000>, <-119.550000, -117.250000, 1.000000>, 
      <-130.250000, -119.000000, -1.000000>, <-126.700000, -118.400000, -1.000000>, <-123.100000, -117.700000, -1.000000>, <-119.600000, -117.050000, -1.000000>, 
      <-130.775000, -116.025000, 0.000000>, <-127.250000, -115.400000, 0.000000>, <-123.650000, -114.750000, 0.000000>, <-120.150000, -114.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-130.775000, -116.025000, 0.000000>, <-127.250000, -115.400000, 0.000000>, <-123.650000, -114.750000, 0.000000>, <-120.150000, -114.100000, 0.000000>, 
      <-131.300000, -113.050000, 1.000000>, <-127.800000, -112.400000, 1.000000>, <-124.200000, -111.800000, 1.000000>, <-120.700000, -111.150000, 1.000000>, 
      <-131.350000, -112.850000, -1.000000>, <-127.800000, -112.200000, -1.000000>, <-124.300000, -111.500000, -1.000000>, <-120.750000, -110.850000, -1.000000>, 
      <-131.875000, -109.850000, 0.000000>, <-128.350000, -109.200000, 0.000000>, <-124.800000, -108.550000, 0.000000>, <-121.275000, -107.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-131.875000, -109.850000, 0.000000>, <-128.350000, -109.200000, 0.000000>, <-124.800000, -108.550000, 0.000000>, <-121.275000, -107.900000, 0.000000>, 
      <-132.400000, -106.850000, 1.000000>, <-128.900000, -106.200000, 1.000000>, <-125.300000, -105.600000, 1.000000>, <-121.800000, -104.950000, 1.000000>, 
      <-132.450000, -106.650000, -1.000000>, <-128.900000, -106.000000, -1.000000>, <-125.400000, -105.400000, -1.000000>, <-121.850000, -104.750000, -1.000000>, 
      <-133.000000, -103.675000, 0.000000>, <-129.450000, -103.050000, 0.000000>, <-125.950000, -102.400000, 0.000000>, <-122.400000, -101.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-133.000000, -103.675000, 0.000000>, <-129.450000, -103.050000, 0.000000>, <-125.950000, -102.400000, 0.000000>, <-122.400000, -101.750000, 0.000000>, 
      <-133.550000, -100.700000, 1.000000>, <-130.000000, -100.100000, 1.000000>, <-126.500000, -99.400000, 1.000000>, <-122.950000, -98.750000, 1.000000>, 
      <-133.600000, -100.450000, -1.000000>, <-130.100000, -99.800000, -1.000000>, <-126.500000, -99.200000, -1.000000>, <-123.000000, -98.550000, -1.000000>, 
      <-134.125000, -97.500000, 0.000000>, <-130.600000, -96.850000, 0.000000>, <-127.050000, -96.200000, 0.000000>, <-123.525000, -95.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-134.125000, -97.500000, 0.000000>, <-130.600000, -96.850000, 0.000000>, <-127.050000, -96.200000, 0.000000>, <-123.525000, -95.550000, 0.000000>, 
      <-134.650000, -94.550000, 1.000000>, <-131.100000, -93.900000, 1.000000>, <-127.600000, -93.200000, 1.000000>, <-124.050000, -92.550000, 1.000000>, 
      <-134.750000, -94.350000, -1.000000>, <-131.200000, -93.700000, -1.000000>, <-127.700000, -93.000000, -1.000000>, <-124.150000, -92.350000, -1.000000>, 
      <-135.275000, -91.350000, 0.000000>, <-131.750000, -90.700000, 0.000000>, <-128.200000, -90.050000, 0.000000>, <-124.675000, -89.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-135.275000, -91.350000, 0.000000>, <-131.750000, -90.700000, 0.000000>, <-128.200000, -90.050000, 0.000000>, <-124.675000, -89.400000, 0.000000>, 
      <-135.800000, -88.350000, 1.000000>, <-132.300000, -87.700000, 1.000000>, <-128.700000, -87.100000, 1.000000>, <-125.200000, -86.450000, 1.000000>, 
      <-135.850000, -88.150000, -1.000000>, <-132.300000, -87.500000, -1.000000>, <-128.800000, -86.900000, -1.000000>, <-125.250000, -86.250000, -1.000000>, 
      <-136.400000, -85.150000, 0.000000>, <-132.850000, -84.500000, 0.000000>, <-129.350000, -83.900000, 0.000000>, <-125.800000, -83.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-136.400000, -85.150000, 0.000000>, <-132.850000, -84.500000, 0.000000>, <-129.350000, -83.900000, 0.000000>, <-125.800000, -83.250000, 0.000000>, 
      <-136.950000, -82.150000, 1.000000>, <-133.400000, -81.500000, 1.000000>, <-129.900000, -80.900000, 1.000000>, <-126.350000, -80.250000, 1.000000>, 
      <-136.950000, -81.950000, -1.000000>, <-133.400000, -81.300000, -1.000000>, <-129.900000, -80.700000, -1.000000>, <-126.350000, -80.050000, -1.000000>, 
      <-137.500000, -79.000000, 0.000000>, <-133.950000, -78.350000, 0.000000>, <-130.450000, -77.700000, 0.000000>, <-126.900000, -77.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-137.500000, -79.000000, 0.000000>, <-133.950000, -78.350000, 0.000000>, <-130.450000, -77.700000, 0.000000>, <-126.900000, -77.050000, 0.000000>, 
      <-138.050000, -76.050000, 1.000000>, <-134.500000, -75.400000, 1.000000>, <-131.000000, -74.700000, 1.000000>, <-127.450000, -74.050000, 1.000000>, 
      <-138.100000, -75.850000, -1.000000>, <-134.600000, -75.200000, -1.000000>, <-131.000000, -74.500000, -1.000000>, <-127.500000, -73.850000, -1.000000>, 
      <-138.625000, -72.850000, 0.000000>, <-135.100000, -72.200000, 0.000000>, <-131.550000, -71.550000, 0.000000>, <-128.025000, -70.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-138.625000, -72.850000, 0.000000>, <-135.100000, -72.200000, 0.000000>, <-131.550000, -71.550000, 0.000000>, <-128.025000, -70.900000, 0.000000>, 
      <-139.150000, -69.850000, 1.000000>, <-135.600000, -69.200000, 1.000000>, <-132.100000, -68.600000, 1.000000>, <-128.550000, -67.950000, 1.000000>, 
      <-139.250000, -69.650000, -1.000000>, <-135.700000, -69.000000, -1.000000>, <-132.200000, -68.300000, -1.000000>, <-128.650000, -67.700000, -1.000000>, 
      <-139.775000, -66.650000, 0.000000>, <-136.250000, -66.000000, 0.000000>, <-132.700000, -65.350000, 0.000000>, <-129.175000, -64.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-139.775000, -66.650000, 0.000000>, <-136.250000, -66.000000, 0.000000>, <-132.700000, -65.350000, 0.000000>, <-129.175000, -64.725000, 0.000000>, 
      <-140.300000, -63.650000, 1.000000>, <-136.800000, -63.000000, 1.000000>, <-133.200000, -62.400000, 1.000000>, <-129.700000, -61.750000, 1.000000>, 
      <-140.350000, -63.450000, -1.000000>, <-136.800000, -62.800000, -1.000000>, <-133.300000, -62.200000, -1.000000>, <-129.750000, -61.550000, -1.000000>, 
      <-140.900000, -60.500000, 0.000000>, <-137.350000, -59.850000, 0.000000>, <-133.850000, -59.200000, 0.000000>, <-130.300000, -58.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.900000, -60.500000, 0.000000>, <-137.350000, -59.850000, 0.000000>, <-133.850000, -59.200000, 0.000000>, <-130.300000, -58.550000, 0.000000>, 
      <-141.450000, -57.550000, 1.000000>, <-137.900000, -56.900000, 1.000000>, <-134.400000, -56.200000, 1.000000>, <-130.850000, -55.550000, 1.000000>, 
      <-141.500000, -57.250000, -1.000000>, <-138.000000, -56.600000, -1.000000>, <-134.400000, -56.000000, -1.000000>, <-130.900000, -55.350000, -1.000000>, 
      <-142.025000, -54.300000, 0.000000>, <-138.500000, -53.650000, 0.000000>, <-134.950000, -53.000000, 0.000000>, <-131.425000, -52.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-142.025000, -54.300000, 0.000000>, <-138.500000, -53.650000, 0.000000>, <-134.950000, -53.000000, 0.000000>, <-131.425000, -52.375000, 0.000000>, 
      <-142.550000, -51.350000, 1.000000>, <-139.000000, -50.700000, 1.000000>, <-135.500000, -50.000000, 1.000000>, <-131.950000, -49.400000, 1.000000>, 
      <-142.650000, -51.150000, -1.000000>, <-139.100000, -50.500000, -1.000000>, <-135.600000, -49.800000, -1.000000>, <-132.050000, -49.150000, -1.000000>, 
      <-143.175000, -48.150000, 0.000000>, <-139.650000, -47.500000, 0.000000>, <-136.100000, -46.850000, 0.000000>, <-132.575000, -46.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-143.175000, -48.150000, 0.000000>, <-139.650000, -47.500000, 0.000000>, <-136.100000, -46.850000, 0.000000>, <-132.575000, -46.200000, 0.000000>, 
      <-143.700000, -45.150000, 1.000000>, <-140.200000, -44.500000, 1.000000>, <-136.600000, -43.900000, 1.000000>, <-133.100000, -43.250000, 1.000000>, 
      <-143.750000, -44.950000, -1.000000>, <-140.200000, -44.300000, -1.000000>, <-136.700000, -43.700000, -1.000000>, <-133.150000, -43.050000, -1.000000>, 
      <-144.300000, -41.950000, 0.000000>, <-140.750000, -41.300000, 0.000000>, <-137.200000, -40.700000, 0.000000>, <-133.675000, -40.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-144.300000, -41.950000, 0.000000>, <-140.750000, -41.300000, 0.000000>, <-137.200000, -40.700000, 0.000000>, <-133.675000, -40.050000, 0.000000>, 
      <-144.850000, -38.950000, 1.000000>, <-141.300000, -38.300000, 1.000000>, <-137.700000, -37.700000, 1.000000>, <-134.200000, -37.050000, 1.000000>, 
      <-144.850000, -38.750000, -1.000000>, <-141.300000, -38.100000, -1.000000>, <-137.800000, -37.500000, -1.000000>, <-134.250000, -36.850000, -1.000000>, 
      <-145.400000, -35.800000, 0.000000>, <-141.850000, -35.150000, 0.000000>, <-138.350000, -34.500000, 0.000000>, <-134.800000, -33.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-145.400000, -35.800000, 0.000000>, <-141.850000, -35.150000, 0.000000>, <-138.350000, -34.500000, 0.000000>, <-134.800000, -33.850000, 0.000000>, 
      <-145.950000, -32.850000, 1.000000>, <-142.400000, -32.200000, 1.000000>, <-138.900000, -31.500000, 1.000000>, <-135.350000, -30.850000, 1.000000>, 
      <-146.000000, -32.650000, -1.000000>, <-142.500000, -32.000000, -1.000000>, <-138.900000, -31.300000, -1.000000>, <-135.400000, -30.650000, -1.000000>, 
      <-146.525000, -29.650000, 0.000000>, <-143.000000, -29.000000, 0.000000>, <-139.450000, -28.350000, 0.000000>, <-135.925000, -27.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-146.525000, -29.650000, 0.000000>, <-143.000000, -29.000000, 0.000000>, <-139.450000, -28.350000, 0.000000>, <-135.925000, -27.700000, 0.000000>, 
      <-147.050000, -26.650000, 1.000000>, <-143.500000, -26.000000, 1.000000>, <-140.000000, -25.400000, 1.000000>, <-136.450000, -24.750000, 1.000000>, 
      <-147.150000, -26.450000, -1.000000>, <-143.600000, -25.800000, -1.000000>, <-140.100000, -25.100000, -1.000000>, <-136.550000, -24.500000, -1.000000>, 
      <-147.675000, -23.450000, 0.000000>, <-144.150000, -22.800000, 0.000000>, <-140.600000, -22.150000, 0.000000>, <-137.075000, -21.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-147.675000, -23.450000, 0.000000>, <-144.150000, -22.800000, 0.000000>, <-140.600000, -22.150000, 0.000000>, <-137.075000, -21.525000, 0.000000>, 
      <-148.200000, -20.450000, 1.000000>, <-144.700000, -19.800000, 1.000000>, <-141.100000, -19.200000, 1.000000>, <-137.600000, -18.550000, 1.000000>, 
      <-148.250000, -20.250000, -1.000000>, <-144.700000, -19.600000, -1.000000>, <-141.200000, -19.000000, -1.000000>, <-137.650000, -18.350000, -1.000000>, 
      <-148.800000, -17.300000, 0.000000>, <-145.250000, -16.650000, 0.000000>, <-141.750000, -16.000000, 0.000000>, <-138.200000, -15.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-148.800000, -17.300000, 0.000000>, <-145.250000, -16.650000, 0.000000>, <-141.750000, -16.000000, 0.000000>, <-138.200000, -15.350000, 0.000000>, 
      <-149.350000, -14.350000, 1.000000>, <-145.800000, -13.700000, 1.000000>, <-142.300000, -13.000000, 1.000000>, <-138.750000, -12.350000, 1.000000>, 
      <-149.350000, -14.100000, -1.000000>, <-145.800000, -13.500000, -1.000000>, <-142.300000, -12.800000, -1.000000>, <-138.750000, -12.150000, -1.000000>, 
      <-149.900000, -11.125000, 0.000000>, <-146.350000, -10.500000, 0.000000>, <-142.850000, -9.800000, 0.000000>, <-139.300000, -9.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-149.900000, -11.125000, 0.000000>, <-146.350000, -10.500000, 0.000000>, <-142.850000, -9.800000, 0.000000>, <-139.300000, -9.175000, 0.000000>, 
      <-150.450000, -8.150000, 1.000000>, <-146.900000, -7.500000, 1.000000>, <-143.400000, -6.800000, 1.000000>, <-139.850000, -6.200000, 1.000000>, 
      <-150.500000, -7.950000, -1.000000>, <-147.000000, -7.300000, -1.000000>, <-143.400000, -6.600000, -1.000000>, <-139.900000, -5.950000, -1.000000>, 
      <-151.025000, -4.950000, 0.000000>, <-147.500000, -4.300000, 0.000000>, <-143.950000, -3.650000, 0.000000>, <-140.200000, -2.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-151.025000, -4.950000, 0.000000>, <-147.500000, -4.300000, 0.000000>, <-143.950000, -3.650000, 0.000000>, <-140.200000, -2.950000, 0.000000>, 
      <-151.550000, -1.950000, 1.000000>, <-148.000000, -1.300000, 1.000000>, <-144.500000, -0.700000, 1.000000>, <-140.500000, 0.050000, 1.000000>, 
      <-151.650000, -1.750000, -1.000000>, <-148.100000, -1.100000, -1.000000>, <-144.600000, -0.500000, -1.000000>, <-140.550000, 0.250000, -1.000000>, 
      <-152.175000, 1.225000, 0.000000>, <-148.650000, 1.850000, 0.000000>, <-145.100000, 2.500000, 0.000000>, <-141.075000, 3.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-152.175000, 1.225000, 0.000000>, <-148.650000, 1.850000, 0.000000>, <-145.100000, 2.500000, 0.000000>, <-141.075000, 3.250000, 0.000000>, 
      <-152.700000, 4.200000, 1.000000>, <-149.200000, 4.800000, 1.000000>, <-145.600000, 5.500000, 1.000000>, <-141.600000, 6.250000, 1.000000>, 
      <-152.750000, 4.450000, -1.000000>, <-149.200000, 5.100000, -1.000000>, <-145.700000, 5.700000, -1.000000>, <-141.650000, 6.450000, -1.000000>, 
      <-153.300000, 7.400000, 0.000000>, <-149.750000, 8.050000, 0.000000>, <-146.250000, 8.700000, 0.000000>, <-141.800000, 9.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-153.300000, 7.400000, 0.000000>, <-149.750000, 8.050000, 0.000000>, <-146.250000, 8.700000, 0.000000>, <-141.800000, 9.450000, 0.000000>, 
      <-153.850000, 10.350000, 1.000000>, <-150.300000, 11.000000, 1.000000>, <-146.800000, 11.700000, 1.000000>, <-141.950000, 12.450000, 1.000000>, 
      <-153.900000, 10.550000, -1.000000>, <-150.400000, 11.200000, -1.000000>, <-146.800000, 11.900000, -1.000000>, <-142.000000, 12.650000, -1.000000>, 
      <-154.425000, 13.550000, 0.000000>, <-150.900000, 14.200000, 0.000000>, <-147.350000, 14.850000, 0.000000>, <-142.225000, 15.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.425000, 13.550000, 0.000000>, <-150.900000, 14.200000, 0.000000>, <-147.350000, 14.850000, 0.000000>, <-142.225000, 15.675000, 0.000000>, 
      <-154.950000, 16.550000, 1.000000>, <-151.400000, 17.200000, 1.000000>, <-147.900000, 17.800000, 1.000000>, <-142.450000, 18.700000, 1.000000>, 
      <-155.050000, 16.750000, -1.000000>, <-151.500000, 17.400000, -1.000000>, <-148.000000, 18.000000, -1.000000>, <-142.500000, 18.900000, -1.000000>, 
      <-154.550000, 20.225000, 0.000000>, <-150.000000, 21.350000, 0.000000>, <-146.500000, 21.950000, 0.000000>, <-141.625000, 22.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.550000, 20.225000, 0.000000>, <-150.000000, 21.350000, 0.000000>, <-146.500000, 21.950000, 0.000000>, <-141.625000, 22.875000, 0.000000>, 
      <-154.050000, 23.700000, 1.000000>, <-148.500000, 25.300000, 1.000000>, <-145.000000, 25.900000, 1.000000>, <-140.750000, 26.850000, 1.000000>, 
      <-154.150000, 23.900000, -1.000000>, <-148.600000, 25.500000, -1.000000>, <-145.000000, 26.100000, -1.000000>, <-140.750000, 27.050000, -1.000000>, 
      <-154.050000, 27.475000, 0.000000>, <-149.100000, 28.450000, 0.000000>, <-145.550000, 29.100000, 0.000000>, <-140.500000, 30.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.050000, 27.475000, 0.000000>, <-149.100000, 28.450000, 0.000000>, <-145.550000, 29.100000, 0.000000>, <-140.500000, 30.225000, 0.000000>, 
      <-153.950000, 31.050000, 1.000000>, <-149.600000, 31.400000, 1.000000>, <-146.100000, 32.100000, 1.000000>, <-140.250000, 33.400000, 1.000000>, 
      <-154.000000, 31.250000, -1.000000>, <-149.700000, 31.600000, -1.000000>, <-146.200000, 32.300000, -1.000000>, <-140.300000, 33.600000, -1.000000>, 
      <-153.350000, 34.500000, 0.000000>, <-148.600000, 35.100000, 0.000000>, <-145.100000, 35.800000, 0.000000>, <-140.050000, 37.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-153.350000, 34.500000, 0.000000>, <-148.600000, 35.100000, 0.000000>, <-145.100000, 35.800000, 0.000000>, <-140.050000, 37.425000, 0.000000>, 
      <-152.700000, 37.750000, 1.000000>, <-147.500000, 38.600000, 1.000000>, <-144.000000, 39.300000, 1.000000>, <-139.800000, 41.250000, 1.000000>, 
      <-152.800000, 37.950000, -1.000000>, <-147.600000, 38.800000, -1.000000>, <-144.000000, 39.500000, -1.000000>, <-139.800000, 41.450000, -1.000000>, 
      <-153.550000, 42.100000, 0.000000>, <-148.400000, 42.950000, 0.000000>, <-143.850000, 43.950000, 0.000000>, <-139.875000, 45.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-153.550000, 42.100000, 0.000000>, <-148.400000, 42.950000, 0.000000>, <-143.850000, 43.950000, 0.000000>, <-139.875000, 45.200000, 0.000000>, 
      <-154.300000, 46.250000, 1.000000>, <-149.200000, 47.100000, 1.000000>, <-143.700000, 48.400000, 1.000000>, <-139.950000, 48.950000, 1.000000>, 
      <-154.350000, 46.450000, -1.000000>, <-149.300000, 47.300000, -1.000000>, <-143.800000, 48.600000, -1.000000>, <-140.050000, 49.150000, -1.000000>, 
      <-154.825000, 49.425000, 0.000000>, <-149.800000, 50.250000, 0.000000>, <-144.350000, 51.550000, 0.000000>, <-140.300000, 52.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-154.825000, 49.425000, 0.000000>, <-149.800000, 50.250000, 0.000000>, <-144.350000, 51.550000, 0.000000>, <-140.300000, 52.275000, 0.000000>, 
      <-155.300000, 52.400000, 1.000000>, <-150.300000, 53.200000, 1.000000>, <-144.900000, 54.500000, 1.000000>, <-140.550000, 55.400000, 1.000000>, 
      <-155.350000, 52.600000, -1.000000>, <-150.400000, 53.400000, -1.000000>, <-144.900000, 54.700000, -1.000000>, <-140.550000, 55.650000, -1.000000>, 
      <-155.850000, 55.975000, 0.000000>, <-150.950000, 56.400000, 0.000000>, <-145.450000, 57.700000, 0.000000>, <-141.025000, 58.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-155.850000, 55.975000, 0.000000>, <-150.950000, 56.400000, 0.000000>, <-145.450000, 57.700000, 0.000000>, <-141.025000, 58.650000, 0.000000>, 
      <-156.350000, 59.350000, 1.000000>, <-151.500000, 59.400000, 1.000000>, <-146.000000, 60.700000, 1.000000>, <-141.500000, 61.650000, 1.000000>, 
      <-156.350000, 59.550000, -1.000000>, <-151.500000, 59.600000, -1.000000>, <-146.100000, 60.900000, -1.000000>, <-141.550000, 61.850000, -1.000000>, 
      <-157.000000, 63.350000, 0.700000>, <-152.200000, 63.400000, 0.700000>, <-146.800000, 64.700000, 0.700000>, <-142.150000, 65.650000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-117.750000, -127.350000, -1.000000>, <-114.200000, -126.700000, -1.000000>, <-110.700000, -126.100000, -1.000000>, <-107.150000, -125.450000, -1.000000>, 
      <-118.450000, -123.450000, 1.000000>, <-114.900000, -122.800000, 1.000000>, <-111.400000, -122.200000, 1.000000>, <-107.850000, -121.550000, 1.000000>, 
      <-118.500000, -123.250000, -1.000000>, <-115.000000, -122.600000, -1.000000>, <-111.400000, -121.900000, -1.000000>, <-107.850000, -121.300000, -1.000000>, 
      <-119.025000, -120.250000, 0.000000>, <-115.500000, -119.600000, 0.000000>, <-111.950000, -118.950000, 0.000000>, <-108.400000, -118.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-119.025000, -120.250000, 0.000000>, <-115.500000, -119.600000, 0.000000>, <-111.950000, -118.950000, 0.000000>, <-108.400000, -118.325000, 0.000000>, 
      <-119.550000, -117.250000, 1.000000>, <-116.000000, -116.600000, 1.000000>, <-112.500000, -116.000000, 1.000000>, <-108.950000, -115.350000, 1.000000>, 
      <-119.600000, -117.050000, -1.000000>, <-116.100000, -116.400000, -1.000000>, <-112.500000, -115.800000, -1.000000>, <-109.000000, -115.150000, -1.000000>, 
      <-120.150000, -114.100000, 0.000000>, <-116.650000, -113.450000, 0.000000>, <-113.050000, -112.800000, 0.000000>, <-109.525000, -112.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-120.150000, -114.100000, 0.000000>, <-116.650000, -113.450000, 0.000000>, <-113.050000, -112.800000, 0.000000>, <-109.525000, -112.150000, 0.000000>, 
      <-120.700000, -111.150000, 1.000000>, <-117.200000, -110.500000, 1.000000>, <-113.600000, -109.800000, 1.000000>, <-110.050000, -109.150000, 1.000000>, 
      <-120.750000, -110.850000, -1.000000>, <-117.200000, -110.200000, -1.000000>, <-113.700000, -109.600000, -1.000000>, <-110.150000, -108.950000, -1.000000>, 
      <-121.275000, -107.900000, 0.000000>, <-117.750000, -107.250000, 0.000000>, <-114.200000, -106.600000, 0.000000>, <-110.675000, -105.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-121.275000, -107.900000, 0.000000>, <-117.750000, -107.250000, 0.000000>, <-114.200000, -106.600000, 0.000000>, <-110.675000, -105.975000, 0.000000>, 
      <-121.800000, -104.950000, 1.000000>, <-118.300000, -104.300000, 1.000000>, <-114.700000, -103.600000, 1.000000>, <-111.200000, -103.000000, 1.000000>, 
      <-121.850000, -104.750000, -1.000000>, <-118.300000, -104.100000, -1.000000>, <-114.800000, -103.400000, -1.000000>, <-111.250000, -102.750000, -1.000000>, 
      <-122.400000, -101.750000, 0.000000>, <-118.850000, -101.100000, 0.000000>, <-115.350000, -100.450000, 0.000000>, <-111.800000, -99.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-122.400000, -101.750000, 0.000000>, <-118.850000, -101.100000, 0.000000>, <-115.350000, -100.450000, 0.000000>, <-111.800000, -99.800000, 0.000000>, 
      <-122.950000, -98.750000, 1.000000>, <-119.400000, -98.100000, 1.000000>, <-115.900000, -97.500000, 1.000000>, <-112.350000, -96.850000, 1.000000>, 
      <-123.000000, -98.550000, -1.000000>, <-119.500000, -97.900000, -1.000000>, <-115.900000, -97.300000, -1.000000>, <-112.400000, -96.650000, -1.000000>, 
      <-123.525000, -95.550000, 0.000000>, <-120.000000, -94.900000, 0.000000>, <-116.450000, -94.300000, 0.000000>, <-112.925000, -93.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-123.525000, -95.550000, 0.000000>, <-120.000000, -94.900000, 0.000000>, <-116.450000, -94.300000, 0.000000>, <-112.925000, -93.650000, 0.000000>, 
      <-124.050000, -92.550000, 1.000000>, <-120.500000, -91.900000, 1.000000>, <-117.000000, -91.300000, 1.000000>, <-113.450000, -90.650000, 1.000000>, 
      <-124.150000, -92.350000, -1.000000>, <-120.600000, -91.700000, -1.000000>, <-117.100000, -91.100000, -1.000000>, <-113.550000, -90.450000, -1.000000>, 
      <-124.675000, -89.400000, 0.000000>, <-121.150000, -88.750000, 0.000000>, <-117.600000, -88.100000, 0.000000>, <-114.075000, -87.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-124.675000, -89.400000, 0.000000>, <-121.150000, -88.750000, 0.000000>, <-117.600000, -88.100000, 0.000000>, <-114.075000, -87.450000, 0.000000>, 
      <-125.200000, -86.450000, 1.000000>, <-121.700000, -85.800000, 1.000000>, <-118.100000, -85.100000, 1.000000>, <-114.600000, -84.450000, 1.000000>, 
      <-125.250000, -86.250000, -1.000000>, <-121.700000, -85.600000, -1.000000>, <-118.200000, -84.900000, -1.000000>, <-114.650000, -84.250000, -1.000000>, 
      <-125.800000, -83.250000, 0.000000>, <-122.250000, -82.600000, 0.000000>, <-118.750000, -81.950000, 0.000000>, <-115.200000, -81.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-125.800000, -83.250000, 0.000000>, <-122.250000, -82.600000, 0.000000>, <-118.750000, -81.950000, 0.000000>, <-115.200000, -81.300000, 0.000000>, 
      <-126.350000, -80.250000, 1.000000>, <-122.800000, -79.600000, 1.000000>, <-119.300000, -79.000000, 1.000000>, <-115.750000, -78.350000, 1.000000>, 
      <-126.350000, -80.050000, -1.000000>, <-122.800000, -79.400000, -1.000000>, <-119.300000, -78.700000, -1.000000>, <-115.750000, -78.100000, -1.000000>, 
      <-126.900000, -77.050000, 0.000000>, <-123.350000, -76.400000, 0.000000>, <-119.850000, -75.750000, 0.000000>, <-116.300000, -75.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.900000, -77.050000, 0.000000>, <-123.350000, -76.400000, 0.000000>, <-119.850000, -75.750000, 0.000000>, <-116.300000, -75.125000, 0.000000>, 
      <-127.450000, -74.050000, 1.000000>, <-123.900000, -73.400000, 1.000000>, <-120.400000, -72.800000, 1.000000>, <-116.850000, -72.150000, 1.000000>, 
      <-127.500000, -73.850000, -1.000000>, <-124.000000, -73.200000, -1.000000>, <-120.400000, -72.600000, -1.000000>, <-116.900000, -71.950000, -1.000000>, 
      <-128.025000, -70.900000, 0.000000>, <-124.500000, -70.250000, 0.000000>, <-120.950000, -69.600000, 0.000000>, <-117.425000, -68.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-128.025000, -70.900000, 0.000000>, <-124.500000, -70.250000, 0.000000>, <-120.950000, -69.600000, 0.000000>, <-117.425000, -68.950000, 0.000000>, 
      <-128.550000, -67.950000, 1.000000>, <-125.000000, -67.300000, 1.000000>, <-121.500000, -66.600000, 1.000000>, <-117.950000, -65.950000, 1.000000>, 
      <-128.650000, -67.700000, -1.000000>, <-125.100000, -67.100000, -1.000000>, <-121.600000, -66.400000, -1.000000>, <-118.050000, -65.750000, -1.000000>, 
      <-129.175000, -64.725000, 0.000000>, <-125.650000, -64.100000, 0.000000>, <-122.100000, -63.400000, 0.000000>, <-118.575000, -62.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-129.175000, -64.725000, 0.000000>, <-125.650000, -64.100000, 0.000000>, <-122.100000, -63.400000, 0.000000>, <-118.575000, -62.775000, 0.000000>, 
      <-129.700000, -61.750000, 1.000000>, <-126.200000, -61.100000, 1.000000>, <-122.600000, -60.400000, 1.000000>, <-119.100000, -59.800000, 1.000000>, 
      <-129.750000, -61.550000, -1.000000>, <-126.200000, -60.900000, -1.000000>, <-122.700000, -60.200000, -1.000000>, <-119.150000, -59.550000, -1.000000>, 
      <-130.300000, -58.550000, 0.000000>, <-126.750000, -57.900000, 0.000000>, <-123.250000, -57.250000, 0.000000>, <-119.700000, -56.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-130.300000, -58.550000, 0.000000>, <-126.750000, -57.900000, 0.000000>, <-123.250000, -57.250000, 0.000000>, <-119.700000, -56.600000, 0.000000>, 
      <-130.850000, -55.550000, 1.000000>, <-127.300000, -54.900000, 1.000000>, <-123.800000, -54.300000, 1.000000>, <-120.250000, -53.650000, 1.000000>, 
      <-130.900000, -55.350000, -1.000000>, <-127.400000, -54.700000, -1.000000>, <-123.800000, -54.100000, -1.000000>, <-120.300000, -53.450000, -1.000000>, 
      <-131.425000, -52.375000, 0.000000>, <-127.900000, -51.750000, 0.000000>, <-124.350000, -51.100000, 0.000000>, <-120.825000, -50.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-131.425000, -52.375000, 0.000000>, <-127.900000, -51.750000, 0.000000>, <-124.350000, -51.100000, 0.000000>, <-120.825000, -50.450000, 0.000000>, 
      <-131.950000, -49.400000, 1.000000>, <-128.400000, -48.800000, 1.000000>, <-124.900000, -48.100000, 1.000000>, <-121.350000, -47.450000, 1.000000>, 
      <-132.050000, -49.150000, -1.000000>, <-128.500000, -48.500000, -1.000000>, <-124.900000, -47.900000, -1.000000>, <-121.400000, -47.250000, -1.000000>, 
      <-132.575000, -46.200000, 0.000000>, <-129.050000, -45.550000, 0.000000>, <-125.450000, -44.900000, 0.000000>, <-121.950000, -44.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-132.575000, -46.200000, 0.000000>, <-129.050000, -45.550000, 0.000000>, <-125.450000, -44.900000, 0.000000>, <-121.950000, -44.250000, 0.000000>, 
      <-133.100000, -43.250000, 1.000000>, <-129.600000, -42.600000, 1.000000>, <-126.000000, -41.900000, 1.000000>, <-122.500000, -41.250000, 1.000000>, 
      <-133.150000, -43.050000, -1.000000>, <-129.600000, -42.400000, -1.000000>, <-126.100000, -41.700000, -1.000000>, <-122.550000, -41.050000, -1.000000>, 
      <-133.675000, -40.050000, 0.000000>, <-130.150000, -39.400000, 0.000000>, <-126.600000, -38.750000, 0.000000>, <-123.075000, -38.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-133.675000, -40.050000, 0.000000>, <-130.150000, -39.400000, 0.000000>, <-126.600000, -38.750000, 0.000000>, <-123.075000, -38.100000, 0.000000>, 
      <-134.200000, -37.050000, 1.000000>, <-130.700000, -36.400000, 1.000000>, <-127.100000, -35.800000, 1.000000>, <-123.600000, -35.150000, 1.000000>, 
      <-134.250000, -36.850000, -1.000000>, <-130.700000, -36.200000, -1.000000>, <-127.200000, -35.600000, -1.000000>, <-123.650000, -34.950000, -1.000000>, 
      <-134.800000, -33.850000, 0.000000>, <-131.250000, -33.200000, 0.000000>, <-127.750000, -32.600000, 0.000000>, <-124.200000, -31.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-134.800000, -33.850000, 0.000000>, <-131.250000, -33.200000, 0.000000>, <-127.750000, -32.600000, 0.000000>, <-124.200000, -31.950000, 0.000000>, 
      <-135.350000, -30.850000, 1.000000>, <-131.800000, -30.200000, 1.000000>, <-128.300000, -29.600000, 1.000000>, <-124.750000, -28.950000, 1.000000>, 
      <-135.400000, -30.650000, -1.000000>, <-131.900000, -30.000000, -1.000000>, <-128.300000, -29.400000, -1.000000>, <-124.800000, -28.750000, -1.000000>, 
      <-135.925000, -27.700000, 0.000000>, <-132.400000, -27.050000, 0.000000>, <-128.850000, -26.400000, 0.000000>, <-125.325000, -25.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-135.925000, -27.700000, 0.000000>, <-132.400000, -27.050000, 0.000000>, <-128.850000, -26.400000, 0.000000>, <-125.325000, -25.750000, 0.000000>, 
      <-136.450000, -24.750000, 1.000000>, <-132.900000, -24.100000, 1.000000>, <-129.400000, -23.400000, 1.000000>, <-125.850000, -22.750000, 1.000000>, 
      <-136.550000, -24.500000, -1.000000>, <-133.000000, -23.900000, -1.000000>, <-129.500000, -23.200000, -1.000000>, <-125.950000, -22.550000, -1.000000>, 
      <-137.075000, -21.525000, 0.000000>, <-133.550000, -20.900000, 0.000000>, <-130.000000, -20.250000, 0.000000>, <-126.075000, -19.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-137.075000, -21.525000, 0.000000>, <-133.550000, -20.900000, 0.000000>, <-130.000000, -20.250000, 0.000000>, <-126.075000, -19.575000, 0.000000>, 
      <-137.600000, -18.550000, 1.000000>, <-134.100000, -17.900000, 1.000000>, <-130.500000, -17.300000, 1.000000>, <-126.200000, -16.600000, 1.000000>, 
      <-137.650000, -18.350000, -1.000000>, <-134.100000, -17.700000, -1.000000>, <-130.600000, -17.000000, -1.000000>, <-126.100000, -16.300000, -1.000000>, 
      <-138.200000, -15.350000, 0.000000>, <-134.650000, -14.700000, 0.000000>, <-131.150000, -14.050000, 0.000000>, <-126.500000, -13.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-138.200000, -15.350000, 0.000000>, <-134.650000, -14.700000, 0.000000>, <-131.150000, -14.050000, 0.000000>, <-126.500000, -13.300000, 0.000000>, 
      <-138.750000, -12.350000, 1.000000>, <-135.200000, -11.700000, 1.000000>, <-131.700000, -11.100000, 1.000000>, <-126.900000, -10.300000, 1.000000>, 
      <-138.750000, -12.150000, -1.000000>, <-135.200000, -11.500000, -1.000000>, <-131.700000, -10.900000, -1.000000>, <-126.950000, -10.100000, -1.000000>, 
      <-139.300000, -9.175000, 0.000000>, <-135.750000, -8.550000, 0.000000>, <-131.550000, -7.750000, 0.000000>, <-127.000000, -7.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-139.300000, -9.175000, 0.000000>, <-135.750000, -8.550000, 0.000000>, <-131.550000, -7.750000, 0.000000>, <-127.000000, -7.025000, 0.000000>, 
      <-139.850000, -6.200000, 1.000000>, <-136.300000, -5.600000, 1.000000>, <-131.400000, -4.600000, 1.000000>, <-127.050000, -3.950000, 1.000000>, 
      <-139.900000, -5.950000, -1.000000>, <-136.400000, -5.300000, -1.000000>, <-131.400000, -4.300000, -1.000000>, <-127.050000, -3.700000, -1.000000>, 
      <-140.200000, -2.950000, 0.000000>, <-136.450000, -2.250000, 0.000000>, <-131.550000, -1.300000, 0.000000>, <-127.150000, -0.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.200000, -2.950000, 0.000000>, <-136.450000, -2.250000, 0.000000>, <-131.550000, -1.300000, 0.000000>, <-127.150000, -0.600000, 0.000000>, 
      <-140.500000, 0.050000, 1.000000>, <-136.500000, 0.800000, 1.000000>, <-131.700000, 1.700000, 1.000000>, <-127.250000, 2.500000, 1.000000>, 
      <-140.550000, 0.250000, -1.000000>, <-136.500000, 1.000000, -1.000000>, <-131.700000, 1.900000, -1.000000>, <-127.250000, 2.700000, -1.000000>, 
      <-141.075000, 3.250000, 0.000000>, <-137.050000, 4.000000, 0.000000>, <-131.850000, 4.950000, 0.000000>, <-126.900000, 5.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-141.075000, 3.250000, 0.000000>, <-137.050000, 4.000000, 0.000000>, <-131.850000, 4.950000, 0.000000>, <-126.900000, 5.700000, 0.000000>, 
      <-141.600000, 6.250000, 1.000000>, <-137.600000, 7.000000, 1.000000>, <-132.000000, 8.000000, 1.000000>, <-126.550000, 8.700000, 1.000000>, 
      <-141.650000, 6.450000, -1.000000>, <-137.600000, 7.200000, -1.000000>, <-132.000000, 8.200000, -1.000000>, <-126.600000, 8.900000, -1.000000>, 
      <-141.800000, 9.450000, 0.000000>, <-137.350000, 10.200000, 0.000000>, <-132.800000, 10.950000, 0.000000>, <-127.150000, 11.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-141.800000, 9.450000, 0.000000>, <-137.350000, 10.200000, 0.000000>, <-132.800000, 10.950000, 0.000000>, <-127.150000, 11.800000, 0.000000>, 
      <-141.950000, 12.450000, 1.000000>, <-137.100000, 13.200000, 1.000000>, <-133.600000, 13.700000, 1.000000>, <-127.700000, 14.700000, 1.000000>, 
      <-142.000000, 12.650000, -1.000000>, <-137.200000, 13.400000, -1.000000>, <-133.600000, 13.900000, -1.000000>, <-127.700000, 14.900000, -1.000000>, 
      <-142.225000, 15.675000, 0.000000>, <-137.100000, 16.500000, 0.000000>, <-133.500000, 17.000000, 0.000000>, <-127.800000, 17.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-142.225000, 15.675000, 0.000000>, <-137.100000, 16.500000, 0.000000>, <-133.500000, 17.000000, 0.000000>, <-127.800000, 17.950000, 0.000000>, 
      <-142.450000, 18.700000, 1.000000>, <-137.000000, 19.600000, 1.000000>, <-133.400000, 20.100000, 1.000000>, <-127.900000, 21.000000, 1.000000>, 
      <-142.500000, 18.900000, -1.000000>, <-137.000000, 19.800000, -1.000000>, <-133.500000, 20.300000, -1.000000>, <-127.950000, 21.200000, -1.000000>, 
      <-141.625000, 22.875000, 0.000000>, <-136.750000, 23.800000, 0.000000>, <-133.250000, 24.400000, 0.000000>, <-127.675000, 25.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-141.625000, 22.875000, 0.000000>, <-136.750000, 23.800000, 0.000000>, <-133.250000, 24.400000, 0.000000>, <-127.675000, 25.000000, 0.000000>, 
      <-140.750000, 26.850000, 1.000000>, <-136.500000, 27.800000, 1.000000>, <-133.000000, 28.500000, 1.000000>, <-127.400000, 28.800000, 1.000000>, 
      <-140.750000, 27.050000, -1.000000>, <-136.500000, 28.000000, -1.000000>, <-133.000000, 28.700000, -1.000000>, <-127.400000, 29.150000, -1.000000>, 
      <-140.500000, 30.225000, 0.000000>, <-135.450000, 31.350000, 0.000000>, <-131.900000, 31.900000, 0.000000>, <-126.700000, 32.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.500000, 30.225000, 0.000000>, <-135.450000, 31.350000, 0.000000>, <-131.900000, 31.900000, 0.000000>, <-126.700000, 32.275000, 0.000000>, 
      <-140.250000, 33.400000, 1.000000>, <-134.400000, 34.700000, 1.000000>, <-130.800000, 35.100000, 1.000000>, <-126.000000, 35.400000, 1.000000>, 
      <-140.300000, 33.600000, -1.000000>, <-134.400000, 34.900000, -1.000000>, <-130.900000, 35.300000, -1.000000>, <-126.050000, 35.600000, -1.000000>, 
      <-140.050000, 37.425000, 0.000000>, <-135.000000, 39.050000, 0.000000>, <-131.450000, 39.450000, 0.000000>, <-126.175000, 39.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.050000, 37.425000, 0.000000>, <-135.000000, 39.050000, 0.000000>, <-131.450000, 39.450000, 0.000000>, <-126.175000, 39.175000, 0.000000>, 
      <-139.800000, 41.250000, 1.000000>, <-135.600000, 43.200000, 1.000000>, <-132.000000, 43.600000, 1.000000>, <-126.300000, 42.750000, 1.000000>, 
      <-139.800000, 41.450000, -1.000000>, <-135.600000, 43.400000, -1.000000>, <-132.100000, 43.800000, -1.000000>, <-126.350000, 42.950000, -1.000000>, 
      <-139.875000, 45.200000, 0.000000>, <-135.900000, 46.450000, 0.000000>, <-131.750000, 46.950000, 0.000000>, <-125.525000, 46.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-139.875000, 45.200000, 0.000000>, <-135.900000, 46.450000, 0.000000>, <-131.750000, 46.950000, 0.000000>, <-125.525000, 46.375000, 0.000000>, 
      <-139.950000, 48.950000, 1.000000>, <-136.200000, 49.500000, 1.000000>, <-131.400000, 50.100000, 1.000000>, <-124.700000, 49.800000, 1.000000>, 
      <-140.050000, 49.150000, -1.000000>, <-136.300000, 49.700000, -1.000000>, <-131.500000, 50.300000, -1.000000>, <-124.750000, 50.000000, -1.000000>, 
      <-140.300000, 52.275000, 0.000000>, <-136.250000, 53.000000, 0.000000>, <-131.450000, 53.650000, 0.000000>, <-124.600000, 53.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-140.300000, 52.275000, 0.000000>, <-136.250000, 53.000000, 0.000000>, <-131.450000, 53.650000, 0.000000>, <-124.600000, 53.175000, 0.000000>, 
      <-140.550000, 55.400000, 1.000000>, <-136.200000, 56.300000, 1.000000>, <-131.400000, 57.000000, 1.000000>, <-124.450000, 56.350000, 1.000000>, 
      <-140.550000, 55.650000, -1.000000>, <-136.200000, 56.600000, -1.000000>, <-131.400000, 57.300000, -1.000000>, <-124.450000, 56.600000, -1.000000>, 
      <-141.025000, 58.650000, 0.000000>, <-136.600000, 59.600000, 0.000000>, <-131.800000, 60.300000, 0.000000>, <-124.375000, 59.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-141.025000, 58.650000, 0.000000>, <-136.600000, 59.600000, 0.000000>, <-131.800000, 60.300000, 0.000000>, <-124.375000, 59.725000, 0.000000>, 
      <-141.500000, 61.650000, 1.000000>, <-137.000000, 62.600000, 1.000000>, <-132.200000, 63.300000, 1.000000>, <-124.300000, 62.850000, 1.000000>, 
      <-141.550000, 61.850000, -1.000000>, <-137.000000, 62.800000, -1.000000>, <-132.200000, 63.500000, -1.000000>, <-124.350000, 63.050000, -1.000000>, 
      <-142.150000, 65.650000, 0.700000>, <-137.500000, 66.600000, 0.700000>, <-132.700000, 67.300000, 0.700000>, <-124.750000, 66.900000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-107.150000, -125.450000, -1.000000>, <-103.600000, -124.800000, -1.000000>, <-100.100000, -124.100000, -1.000000>, <-96.550000, -123.450000, -1.000000>, 
      <-107.850000, -121.550000, 1.000000>, <-104.300000, -120.900000, 1.000000>, <-100.800000, -120.200000, 1.000000>, <-97.250000, -119.550000, 1.000000>, 
      <-107.850000, -121.300000, -1.000000>, <-104.300000, -120.700000, -1.000000>, <-100.800000, -120.000000, -1.000000>, <-97.250000, -119.350000, -1.000000>, 
      <-108.400000, -118.325000, 0.000000>, <-104.850000, -117.700000, 0.000000>, <-101.350000, -117.000000, 0.000000>, <-97.800000, -116.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-108.400000, -118.325000, 0.000000>, <-104.850000, -117.700000, 0.000000>, <-101.350000, -117.000000, 0.000000>, <-97.800000, -116.375000, 0.000000>, 
      <-108.950000, -115.350000, 1.000000>, <-105.400000, -114.700000, 1.000000>, <-101.900000, -114.000000, 1.000000>, <-98.350000, -113.400000, 1.000000>, 
      <-109.000000, -115.150000, -1.000000>, <-105.500000, -114.500000, -1.000000>, <-101.900000, -113.800000, -1.000000>, <-98.400000, -113.150000, -1.000000>, 
      <-109.525000, -112.150000, 0.000000>, <-106.000000, -111.500000, 0.000000>, <-102.450000, -110.850000, 0.000000>, <-98.925000, -110.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.525000, -112.150000, 0.000000>, <-106.000000, -111.500000, 0.000000>, <-102.450000, -110.850000, 0.000000>, <-98.925000, -110.200000, 0.000000>, 
      <-110.050000, -109.150000, 1.000000>, <-106.500000, -108.500000, 1.000000>, <-103.000000, -107.900000, 1.000000>, <-99.450000, -107.250000, 1.000000>, 
      <-110.150000, -108.950000, -1.000000>, <-106.600000, -108.300000, -1.000000>, <-103.100000, -107.700000, -1.000000>, <-99.550000, -107.050000, -1.000000>, 
      <-110.675000, -105.975000, 0.000000>, <-107.150000, -105.350000, 0.000000>, <-103.600000, -104.700000, 0.000000>, <-100.075000, -104.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-110.675000, -105.975000, 0.000000>, <-107.150000, -105.350000, 0.000000>, <-103.600000, -104.700000, 0.000000>, <-100.075000, -104.050000, 0.000000>, 
      <-111.200000, -103.000000, 1.000000>, <-107.700000, -102.400000, 1.000000>, <-104.100000, -101.700000, 1.000000>, <-100.600000, -101.050000, 1.000000>, 
      <-111.250000, -102.750000, -1.000000>, <-107.700000, -102.100000, -1.000000>, <-104.200000, -101.500000, -1.000000>, <-100.650000, -100.850000, -1.000000>, 
      <-111.800000, -99.800000, 0.000000>, <-108.250000, -99.150000, 0.000000>, <-104.750000, -98.500000, 0.000000>, <-101.200000, -97.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-111.800000, -99.800000, 0.000000>, <-108.250000, -99.150000, 0.000000>, <-104.750000, -98.500000, 0.000000>, <-101.200000, -97.850000, 0.000000>, 
      <-112.350000, -96.850000, 1.000000>, <-108.800000, -96.200000, 1.000000>, <-105.300000, -95.500000, 1.000000>, <-101.750000, -94.850000, 1.000000>, 
      <-112.400000, -96.650000, -1.000000>, <-108.900000, -96.000000, -1.000000>, <-105.300000, -95.300000, -1.000000>, <-101.800000, -94.650000, -1.000000>, 
      <-112.925000, -93.650000, 0.000000>, <-109.400000, -93.000000, 0.000000>, <-105.850000, -92.350000, 0.000000>, <-102.325000, -91.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-112.925000, -93.650000, 0.000000>, <-109.400000, -93.000000, 0.000000>, <-105.850000, -92.350000, 0.000000>, <-102.325000, -91.700000, 0.000000>, 
      <-113.450000, -90.650000, 1.000000>, <-109.900000, -90.000000, 1.000000>, <-106.400000, -89.400000, 1.000000>, <-102.850000, -88.750000, 1.000000>, 
      <-113.550000, -90.450000, -1.000000>, <-110.000000, -89.800000, -1.000000>, <-106.500000, -89.200000, -1.000000>, <-102.950000, -88.550000, -1.000000>, 
      <-114.075000, -87.450000, 0.000000>, <-110.550000, -86.800000, 0.000000>, <-107.000000, -86.200000, 0.000000>, <-103.475000, -85.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-114.075000, -87.450000, 0.000000>, <-110.550000, -86.800000, 0.000000>, <-107.000000, -86.200000, 0.000000>, <-103.475000, -85.550000, 0.000000>, 
      <-114.600000, -84.450000, 1.000000>, <-111.100000, -83.800000, 1.000000>, <-107.500000, -83.200000, 1.000000>, <-104.000000, -82.550000, 1.000000>, 
      <-114.650000, -84.250000, -1.000000>, <-111.100000, -83.600000, -1.000000>, <-107.600000, -83.000000, -1.000000>, <-104.050000, -82.350000, -1.000000>, 
      <-115.200000, -81.300000, 0.000000>, <-111.650000, -80.650000, 0.000000>, <-108.150000, -80.000000, 0.000000>, <-104.600000, -79.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-115.200000, -81.300000, 0.000000>, <-111.650000, -80.650000, 0.000000>, <-108.150000, -80.000000, 0.000000>, <-104.600000, -79.350000, 0.000000>, 
      <-115.750000, -78.350000, 1.000000>, <-112.200000, -77.700000, 1.000000>, <-108.700000, -77.000000, 1.000000>, <-105.150000, -76.350000, 1.000000>, 
      <-115.750000, -78.100000, -1.000000>, <-112.200000, -77.500000, -1.000000>, <-108.700000, -76.800000, -1.000000>, <-105.150000, -76.150000, -1.000000>, 
      <-116.300000, -75.125000, 0.000000>, <-112.750000, -74.500000, 0.000000>, <-109.250000, -73.850000, 0.000000>, <-105.700000, -73.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-116.300000, -75.125000, 0.000000>, <-112.750000, -74.500000, 0.000000>, <-109.250000, -73.850000, 0.000000>, <-105.700000, -73.200000, 0.000000>, 
      <-116.850000, -72.150000, 1.000000>, <-113.300000, -71.500000, 1.000000>, <-109.800000, -70.900000, 1.000000>, <-106.250000, -70.250000, 1.000000>, 
      <-116.900000, -71.950000, -1.000000>, <-113.400000, -71.300000, -1.000000>, <-109.800000, -70.600000, -1.000000>, <-106.300000, -69.950000, -1.000000>, 
      <-117.425000, -68.950000, 0.000000>, <-113.900000, -68.300000, 0.000000>, <-110.350000, -67.650000, 0.000000>, <-106.825000, -67.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-117.425000, -68.950000, 0.000000>, <-113.900000, -68.300000, 0.000000>, <-110.350000, -67.650000, 0.000000>, <-106.825000, -67.000000, 0.000000>, 
      <-117.950000, -65.950000, 1.000000>, <-114.400000, -65.300000, 1.000000>, <-110.900000, -64.700000, 1.000000>, <-107.350000, -64.050000, 1.000000>, 
      <-118.050000, -65.750000, -1.000000>, <-114.500000, -65.100000, -1.000000>, <-111.000000, -64.500000, -1.000000>, <-107.450000, -63.850000, -1.000000>, 
      <-118.575000, -62.775000, 0.000000>, <-115.050000, -62.150000, 0.000000>, <-111.500000, -61.500000, 0.000000>, <-107.975000, -60.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-118.575000, -62.775000, 0.000000>, <-115.050000, -62.150000, 0.000000>, <-111.500000, -61.500000, 0.000000>, <-107.975000, -60.850000, 0.000000>, 
      <-119.100000, -59.800000, 1.000000>, <-115.600000, -59.200000, 1.000000>, <-112.000000, -58.500000, 1.000000>, <-108.500000, -57.850000, 1.000000>, 
      <-119.150000, -59.550000, -1.000000>, <-115.600000, -58.900000, -1.000000>, <-112.100000, -58.300000, -1.000000>, <-108.550000, -57.650000, -1.000000>, 
      <-119.700000, -56.600000, 0.000000>, <-116.150000, -55.950000, 0.000000>, <-112.650000, -55.300000, 0.000000>, <-109.100000, -54.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-119.700000, -56.600000, 0.000000>, <-116.150000, -55.950000, 0.000000>, <-112.650000, -55.300000, 0.000000>, <-109.100000, -54.650000, 0.000000>, 
      <-120.250000, -53.650000, 1.000000>, <-116.700000, -53.000000, 1.000000>, <-113.200000, -52.300000, 1.000000>, <-109.650000, -51.650000, 1.000000>, 
      <-120.300000, -53.450000, -1.000000>, <-116.800000, -52.800000, -1.000000>, <-113.200000, -52.100000, -1.000000>, <-109.650000, -51.450000, -1.000000>, 
      <-120.825000, -50.450000, 0.000000>, <-117.300000, -49.800000, 0.000000>, <-113.750000, -49.150000, 0.000000>, <-109.575000, -48.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-120.825000, -50.450000, 0.000000>, <-117.300000, -49.800000, 0.000000>, <-113.750000, -49.150000, 0.000000>, <-109.575000, -48.700000, 0.000000>, 
      <-121.350000, -47.450000, 1.000000>, <-117.800000, -46.800000, 1.000000>, <-114.300000, -46.200000, 1.000000>, <-109.500000, -45.950000, 1.000000>, 
      <-121.400000, -47.250000, -1.000000>, <-117.900000, -46.600000, -1.000000>, <-114.300000, -46.000000, -1.000000>, <-109.500000, -45.700000, -1.000000>, 
      <-121.950000, -44.250000, 0.000000>, <-118.450000, -43.600000, 0.000000>, <-114.850000, -43.000000, 0.000000>, <-109.925000, -42.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-121.950000, -44.250000, 0.000000>, <-118.450000, -43.600000, 0.000000>, <-114.850000, -43.000000, 0.000000>, <-109.925000, -42.700000, 0.000000>, 
      <-122.500000, -41.250000, 1.000000>, <-119.000000, -40.600000, 1.000000>, <-115.400000, -40.000000, 1.000000>, <-110.350000, -39.700000, 1.000000>, 
      <-122.550000, -41.050000, -1.000000>, <-119.000000, -40.400000, -1.000000>, <-115.500000, -39.800000, -1.000000>, <-110.450000, -39.500000, -1.000000>, 
      <-123.075000, -38.100000, 0.000000>, <-119.550000, -37.450000, 0.000000>, <-116.000000, -36.800000, 0.000000>, <-110.850000, -36.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-123.075000, -38.100000, 0.000000>, <-119.550000, -37.450000, 0.000000>, <-116.000000, -36.800000, 0.000000>, <-110.850000, -36.500000, 0.000000>, 
      <-123.600000, -35.150000, 1.000000>, <-120.100000, -34.500000, 1.000000>, <-116.500000, -33.800000, 1.000000>, <-111.250000, -33.500000, 1.000000>, 
      <-123.650000, -34.950000, -1.000000>, <-120.100000, -34.300000, -1.000000>, <-116.600000, -33.600000, -1.000000>, <-111.300000, -33.300000, -1.000000>, 
      <-124.200000, -31.950000, 0.000000>, <-120.650000, -31.300000, 0.000000>, <-116.400000, -30.500000, 0.000000>, <-110.700000, -29.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-124.200000, -31.950000, 0.000000>, <-120.650000, -31.300000, 0.000000>, <-116.400000, -30.500000, 0.000000>, <-110.700000, -29.900000, 0.000000>, 
      <-124.750000, -28.950000, 1.000000>, <-121.200000, -28.300000, 1.000000>, <-116.200000, -27.400000, 1.000000>, <-110.100000, -26.500000, 1.000000>, 
      <-124.800000, -28.750000, -1.000000>, <-121.300000, -28.100000, -1.000000>, <-116.200000, -27.100000, -1.000000>, <-110.150000, -26.200000, -1.000000>, 
      <-125.325000, -25.750000, 0.000000>, <-121.800000, -25.100000, 0.000000>, <-115.300000, -24.250000, 0.000000>, <-109.875000, -23.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-125.325000, -25.750000, 0.000000>, <-121.800000, -25.100000, 0.000000>, <-115.300000, -24.250000, 0.000000>, <-109.875000, -23.275000, 0.000000>, 
      <-125.850000, -22.750000, 1.000000>, <-122.300000, -22.100000, 1.000000>, <-114.400000, -21.400000, 1.000000>, <-109.600000, -20.350000, 1.000000>, 
      <-125.950000, -22.550000, -1.000000>, <-122.400000, -21.900000, -1.000000>, <-114.400000, -21.200000, -1.000000>, <-109.600000, -20.150000, -1.000000>, 
      <-126.075000, -19.575000, 0.000000>, <-122.150000, -18.900000, 0.000000>, <-114.700000, -18.200000, 0.000000>, <-109.500000, -17.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.075000, -19.575000, 0.000000>, <-122.150000, -18.900000, 0.000000>, <-114.700000, -18.200000, 0.000000>, <-109.500000, -17.125000, 0.000000>, 
      <-126.200000, -16.600000, 1.000000>, <-121.900000, -15.900000, 1.000000>, <-115.000000, -15.200000, 1.000000>, <-109.400000, -14.100000, 1.000000>, 
      <-126.100000, -16.300000, -1.000000>, <-121.600000, -15.600000, -1.000000>, <-115.100000, -15.000000, -1.000000>, <-109.450000, -13.900000, -1.000000>, 
      <-126.500000, -13.300000, 0.000000>, <-121.850000, -12.550000, 0.000000>, <-115.400000, -11.950000, 0.000000>, <-109.275000, -10.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.500000, -13.300000, 0.000000>, <-121.850000, -12.550000, 0.000000>, <-115.400000, -11.950000, 0.000000>, <-109.275000, -10.625000, 0.000000>, 
      <-126.900000, -10.300000, 1.000000>, <-122.100000, -9.500000, 1.000000>, <-115.700000, -8.900000, 1.000000>, <-109.100000, -7.350000, 1.000000>, 
      <-126.950000, -10.100000, -1.000000>, <-122.200000, -9.300000, -1.000000>, <-115.700000, -8.700000, -1.000000>, <-109.100000, -7.100000, -1.000000>, 
      <-127.000000, -7.025000, 0.000000>, <-122.450000, -6.300000, 0.000000>, <-116.000000, -5.700000, 0.000000>, <-109.375000, -4.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-127.000000, -7.025000, 0.000000>, <-122.450000, -6.300000, 0.000000>, <-116.000000, -5.700000, 0.000000>, <-109.375000, -4.100000, 0.000000>, 
      <-127.050000, -3.950000, 1.000000>, <-122.700000, -3.300000, 1.000000>, <-116.300000, -2.700000, 1.000000>, <-109.650000, -1.100000, 1.000000>, 
      <-127.050000, -3.700000, -1.000000>, <-122.700000, -3.100000, -1.000000>, <-116.300000, -2.500000, -1.000000>, <-109.650000, -0.900000, -1.000000>, 
      <-127.150000, -0.600000, 0.000000>, <-122.750000, 0.100000, 0.000000>, <-115.700000, 1.100000, 0.000000>, <-108.950000, 2.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-127.150000, -0.600000, 0.000000>, <-122.750000, 0.100000, 0.000000>, <-115.700000, 1.100000, 0.000000>, <-108.950000, 2.450000, 0.000000>, 
      <-127.250000, 2.500000, 1.000000>, <-122.800000, 3.300000, 1.000000>, <-115.100000, 4.700000, 1.000000>, <-108.250000, 5.800000, 1.000000>, 
      <-127.250000, 2.700000, -1.000000>, <-122.800000, 3.500000, -1.000000>, <-115.100000, 4.900000, -1.000000>, <-108.300000, 6.000000, -1.000000>, 
      <-126.900000, 5.700000, 0.000000>, <-121.950000, 6.450000, 0.000000>, <-115.500000, 7.900000, 0.000000>, <-108.600000, 9.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.900000, 5.700000, 0.000000>, <-121.950000, 6.450000, 0.000000>, <-115.500000, 7.900000, 0.000000>, <-108.600000, 9.025000, 0.000000>, 
      <-126.550000, 8.700000, 1.000000>, <-121.100000, 9.400000, 1.000000>, <-115.900000, 10.900000, 1.000000>, <-108.900000, 12.050000, 1.000000>, 
      <-126.600000, 8.900000, -1.000000>, <-121.200000, 9.600000, -1.000000>, <-115.900000, 11.100000, -1.000000>, <-108.900000, 12.250000, -1.000000>, 
      <-127.150000, 11.800000, 0.000000>, <-121.500000, 12.650000, 0.000000>, <-116.250000, 14.100000, 0.000000>, <-109.200000, 15.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-127.150000, 11.800000, 0.000000>, <-121.500000, 12.650000, 0.000000>, <-116.250000, 14.100000, 0.000000>, <-109.200000, 15.250000, 0.000000>, 
      <-127.700000, 14.700000, 1.000000>, <-121.800000, 15.700000, 1.000000>, <-116.600000, 17.100000, 1.000000>, <-109.500000, 18.250000, 1.000000>, 
      <-127.700000, 14.900000, -1.000000>, <-121.800000, 15.900000, -1.000000>, <-116.700000, 17.300000, -1.000000>, <-109.550000, 18.450000, -1.000000>, 
      <-127.800000, 17.950000, 0.000000>, <-122.100000, 18.900000, 0.000000>, <-116.550000, 20.300000, 0.000000>, <-109.575000, 21.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-127.800000, 17.950000, 0.000000>, <-122.100000, 18.900000, 0.000000>, <-116.550000, 20.300000, 0.000000>, <-109.575000, 21.475000, 0.000000>, 
      <-127.900000, 21.000000, 1.000000>, <-122.400000, 21.900000, 1.000000>, <-116.400000, 23.300000, 1.000000>, <-109.600000, 24.500000, 1.000000>, 
      <-127.950000, 21.200000, -1.000000>, <-122.400000, 22.100000, -1.000000>, <-116.400000, 23.500000, -1.000000>, <-109.650000, 24.700000, -1.000000>, 
      <-127.675000, 25.000000, 0.000000>, <-122.100000, 25.600000, 0.000000>, <-115.900000, 27.200000, 0.000000>, <-109.500000, 28.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-127.675000, 25.000000, 0.000000>, <-122.100000, 25.600000, 0.000000>, <-115.900000, 27.200000, 0.000000>, <-109.500000, 28.050000, 0.000000>, 
      <-127.400000, 28.800000, 1.000000>, <-121.800000, 29.100000, 1.000000>, <-115.400000, 30.900000, 1.000000>, <-109.350000, 31.400000, 1.000000>, 
      <-127.400000, 29.150000, -1.000000>, <-121.800000, 29.600000, -1.000000>, <-115.400000, 31.100000, -1.000000>, <-109.350000, 31.600000, -1.000000>, 
      <-126.700000, 32.275000, 0.000000>, <-121.500000, 32.650000, 0.000000>, <-115.000000, 34.150000, 0.000000>, <-108.975000, 34.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.700000, 32.275000, 0.000000>, <-121.500000, 32.650000, 0.000000>, <-115.000000, 34.150000, 0.000000>, <-108.975000, 34.825000, 0.000000>, 
      <-126.000000, 35.400000, 1.000000>, <-121.200000, 35.700000, 1.000000>, <-114.600000, 37.200000, 1.000000>, <-108.600000, 38.050000, 1.000000>, 
      <-126.050000, 35.600000, -1.000000>, <-121.200000, 35.900000, -1.000000>, <-114.600000, 37.500000, -1.000000>, <-108.650000, 38.300000, -1.000000>, 
      <-126.175000, 39.175000, 0.000000>, <-120.900000, 38.900000, 0.000000>, <-113.800000, 40.650000, 0.000000>, <-107.825000, 41.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-126.175000, 39.175000, 0.000000>, <-120.900000, 38.900000, 0.000000>, <-113.800000, 40.650000, 0.000000>, <-107.825000, 41.950000, 0.000000>, 
      <-126.300000, 42.750000, 1.000000>, <-120.600000, 41.900000, 1.000000>, <-113.000000, 43.800000, 1.000000>, <-107.000000, 45.600000, 1.000000>, 
      <-126.350000, 42.950000, -1.000000>, <-120.600000, 42.100000, -1.000000>, <-113.000000, 44.000000, -1.000000>, <-106.900000, 45.750000, -1.000000>, 
      <-125.525000, 46.375000, 0.000000>, <-119.300000, 45.800000, 0.000000>, <-112.450000, 47.050000, 0.000000>, <-106.750000, 48.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-125.525000, 46.375000, 0.000000>, <-119.300000, 45.800000, 0.000000>, <-112.450000, 47.050000, 0.000000>, <-106.750000, 48.775000, 0.000000>, 
      <-124.700000, 49.800000, 1.000000>, <-118.000000, 49.500000, 1.000000>, <-111.900000, 50.100000, 1.000000>, <-106.600000, 51.800000, 1.000000>, 
      <-124.750000, 50.000000, -1.000000>, <-118.000000, 49.700000, -1.000000>, <-111.900000, 50.400000, -1.000000>, <-106.600000, 52.050000, -1.000000>, 
      <-124.600000, 53.175000, 0.000000>, <-117.750000, 52.700000, 0.000000>, <-112.150000, 53.400000, 0.000000>, <-106.850000, 55.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-124.600000, 53.175000, 0.000000>, <-117.750000, 52.700000, 0.000000>, <-112.150000, 53.400000, 0.000000>, <-106.850000, 55.075000, 0.000000>, 
      <-124.450000, 56.350000, 1.000000>, <-117.500000, 55.700000, 1.000000>, <-112.400000, 56.400000, 1.000000>, <-107.100000, 58.100000, 1.000000>, 
      <-124.450000, 56.600000, -1.000000>, <-117.500000, 55.900000, -1.000000>, <-112.400000, 56.600000, -1.000000>, <-107.100000, 58.300000, -1.000000>, 
      <-124.375000, 59.725000, 0.000000>, <-116.950000, 59.150000, 0.000000>, <-112.600000, 59.650000, 0.000000>, <-107.325000, 61.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-124.375000, 59.725000, 0.000000>, <-116.950000, 59.150000, 0.000000>, <-112.600000, 59.650000, 0.000000>, <-107.325000, 61.325000, 0.000000>, 
      <-124.300000, 62.850000, 1.000000>, <-116.400000, 62.400000, 1.000000>, <-112.800000, 62.700000, 1.000000>, <-107.550000, 64.350000, 1.000000>, 
      <-124.350000, 63.050000, -1.000000>, <-116.500000, 62.600000, -1.000000>, <-112.900000, 62.900000, -1.000000>, <-107.600000, 64.550000, -1.000000>, 
      <-124.750000, 66.900000, 0.700000>, <-116.800000, 66.500000, 0.700000>, <-113.200000, 66.800000, 0.700000>, <-107.950000, 68.450000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-96.550000, -123.450000, -1.000000>, <-93.000000, -122.800000, -1.000000>, <-89.500000, -122.200000, -1.000000>, <-86.100000, -119.250000, -1.000000>, 
      <-97.250000, -119.550000, 1.000000>, <-93.700000, -118.900000, 1.000000>, <-90.200000, -118.300000, 1.000000>, <-86.800000, -115.350000, 1.000000>, 
      <-97.250000, -119.350000, -1.000000>, <-93.700000, -118.700000, -1.000000>, <-90.200000, -118.100000, -1.000000>, <-86.800000, -115.150000, -1.000000>, 
      <-97.800000, -116.375000, 0.000000>, <-94.250000, -115.750000, 0.000000>, <-90.750000, -115.100000, 0.000000>, <-87.350000, -112.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-97.800000, -116.375000, 0.000000>, <-94.250000, -115.750000, 0.000000>, <-90.750000, -115.100000, 0.000000>, <-87.350000, -112.175000, 0.000000>, 
      <-98.350000, -113.400000, 1.000000>, <-94.800000, -112.800000, 1.000000>, <-91.300000, -112.100000, 1.000000>, <-87.900000, -109.200000, 1.000000>, 
      <-98.400000, -113.150000, -1.000000>, <-94.900000, -112.500000, -1.000000>, <-91.300000, -111.900000, -1.000000>, <-87.950000, -109.000000, -1.000000>, 
      <-98.925000, -110.200000, 0.000000>, <-95.400000, -109.550000, 0.000000>, <-91.850000, -108.900000, 0.000000>, <-88.475000, -106.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-98.925000, -110.200000, 0.000000>, <-95.400000, -109.550000, 0.000000>, <-91.850000, -108.900000, 0.000000>, <-88.475000, -106.000000, 0.000000>, 
      <-99.450000, -107.250000, 1.000000>, <-95.900000, -106.600000, 1.000000>, <-92.400000, -105.900000, 1.000000>, <-89.000000, -103.000000, 1.000000>, 
      <-99.550000, -107.050000, -1.000000>, <-96.000000, -106.400000, -1.000000>, <-92.500000, -105.700000, -1.000000>, <-89.100000, -102.800000, -1.000000>, 
      <-100.075000, -104.050000, 0.000000>, <-96.550000, -103.400000, 0.000000>, <-93.000000, -102.750000, 0.000000>, <-89.625000, -99.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-100.075000, -104.050000, 0.000000>, <-96.550000, -103.400000, 0.000000>, <-93.000000, -102.750000, 0.000000>, <-89.625000, -99.825000, 0.000000>, 
      <-100.600000, -101.050000, 1.000000>, <-97.100000, -100.400000, 1.000000>, <-93.500000, -99.800000, 1.000000>, <-90.150000, -96.850000, 1.000000>, 
      <-100.650000, -100.850000, -1.000000>, <-97.100000, -100.200000, -1.000000>, <-93.600000, -99.600000, -1.000000>, <-90.200000, -96.650000, -1.000000>, 
      <-101.200000, -97.850000, 0.000000>, <-97.650000, -97.200000, 0.000000>, <-94.150000, -96.600000, 0.000000>, <-90.750000, -93.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-101.200000, -97.850000, 0.000000>, <-97.650000, -97.200000, 0.000000>, <-94.150000, -96.600000, 0.000000>, <-90.750000, -93.675000, 0.000000>, 
      <-101.750000, -94.850000, 1.000000>, <-98.200000, -94.200000, 1.000000>, <-94.700000, -93.600000, 1.000000>, <-91.300000, -90.700000, 1.000000>, 
      <-101.800000, -94.650000, -1.000000>, <-98.300000, -94.000000, -1.000000>, <-94.700000, -93.400000, -1.000000>, <-91.300000, -90.450000, -1.000000>, 
      <-102.325000, -91.700000, 0.000000>, <-98.800000, -91.050000, 0.000000>, <-95.250000, -90.400000, 0.000000>, <-91.850000, -87.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-102.325000, -91.700000, 0.000000>, <-98.800000, -91.050000, 0.000000>, <-95.250000, -90.400000, 0.000000>, <-91.850000, -87.475000, 0.000000>, 
      <-102.850000, -88.750000, 1.000000>, <-99.300000, -88.100000, 1.000000>, <-95.800000, -87.400000, 1.000000>, <-92.400000, -84.500000, 1.000000>, 
      <-102.950000, -88.550000, -1.000000>, <-99.400000, -87.900000, -1.000000>, <-95.900000, -87.200000, -1.000000>, <-92.500000, -84.300000, -1.000000>, 
      <-103.475000, -85.550000, 0.000000>, <-99.950000, -84.900000, 0.000000>, <-96.400000, -84.250000, 0.000000>, <-92.450000, -81.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-103.475000, -85.550000, 0.000000>, <-99.950000, -84.900000, 0.000000>, <-96.400000, -84.250000, 0.000000>, <-92.450000, -81.125000, 0.000000>, 
      <-104.000000, -82.550000, 1.000000>, <-100.500000, -81.900000, 1.000000>, <-96.900000, -81.300000, 1.000000>, <-92.400000, -77.950000, 1.000000>, 
      <-104.050000, -82.350000, -1.000000>, <-100.500000, -81.700000, -1.000000>, <-97.000000, -81.000000, -1.000000>, <-92.450000, -77.700000, -1.000000>, 
      <-104.600000, -79.350000, 0.000000>, <-101.050000, -78.700000, 0.000000>, <-97.500000, -78.050000, 0.000000>, <-92.550000, -74.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-104.600000, -79.350000, 0.000000>, <-101.050000, -78.700000, 0.000000>, <-97.500000, -78.050000, 0.000000>, <-92.550000, -74.975000, 0.000000>, 
      <-105.150000, -76.350000, 1.000000>, <-101.600000, -75.700000, 1.000000>, <-98.000000, -75.100000, 1.000000>, <-92.650000, -72.250000, 1.000000>, 
      <-105.150000, -76.150000, -1.000000>, <-101.600000, -75.500000, -1.000000>, <-98.100000, -74.900000, -1.000000>, <-92.000000, -71.900000, -1.000000>, 
      <-105.700000, -73.200000, 0.000000>, <-102.150000, -72.550000, 0.000000>, <-98.200000, -72.050000, 0.000000>, <-92.225000, -68.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-105.700000, -73.200000, 0.000000>, <-102.150000, -72.550000, 0.000000>, <-98.200000, -72.050000, 0.000000>, <-92.225000, -68.975000, 0.000000>, 
      <-106.250000, -70.250000, 1.000000>, <-102.700000, -69.600000, 1.000000>, <-98.300000, -69.200000, 1.000000>, <-92.450000, -66.050000, 1.000000>, 
      <-106.300000, -69.950000, -1.000000>, <-102.800000, -69.300000, -1.000000>, <-98.300000, -69.000000, -1.000000>, <-92.450000, -65.850000, -1.000000>, 
      <-106.825000, -67.000000, 0.000000>, <-103.300000, -66.350000, 0.000000>, <-98.550000, -65.950000, 0.000000>, <-92.600000, -62.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-106.825000, -67.000000, 0.000000>, <-103.300000, -66.350000, 0.000000>, <-98.550000, -65.950000, 0.000000>, <-92.600000, -62.875000, 0.000000>, 
      <-107.350000, -64.050000, 1.000000>, <-103.800000, -63.400000, 1.000000>, <-98.800000, -62.900000, 1.000000>, <-92.750000, -59.900000, 1.000000>, 
      <-107.450000, -63.850000, -1.000000>, <-103.900000, -63.200000, -1.000000>, <-98.800000, -62.700000, -1.000000>, <-92.750000, -59.700000, -1.000000>, 
      <-107.975000, -60.850000, 0.000000>, <-104.450000, -60.200000, 0.000000>, <-99.050000, -59.700000, 0.000000>, <-92.650000, -56.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-107.975000, -60.850000, 0.000000>, <-104.450000, -60.200000, 0.000000>, <-99.050000, -59.700000, 0.000000>, <-92.650000, -56.550000, 0.000000>, 
      <-108.500000, -57.850000, 1.000000>, <-105.000000, -57.200000, 1.000000>, <-99.300000, -56.700000, 1.000000>, <-92.550000, -53.400000, 1.000000>, 
      <-108.550000, -57.650000, -1.000000>, <-105.000000, -57.000000, -1.000000>, <-99.300000, -56.500000, -1.000000>, <-92.550000, -53.200000, -1.000000>, 
      <-109.100000, -54.650000, 0.000000>, <-105.550000, -54.000000, 0.000000>, <-99.550000, -53.450000, 0.000000>, <-92.550000, -50.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.100000, -54.650000, 0.000000>, <-105.550000, -54.000000, 0.000000>, <-99.550000, -53.450000, 0.000000>, <-92.550000, -50.125000, 0.000000>, 
      <-109.650000, -51.650000, 1.000000>, <-106.100000, -51.000000, 1.000000>, <-99.800000, -50.400000, 1.000000>, <-92.550000, -47.050000, 1.000000>, 
      <-109.650000, -51.450000, -1.000000>, <-106.100000, -50.800000, -1.000000>, <-99.800000, -50.200000, -1.000000>, <-92.550000, -46.850000, -1.000000>, 
      <-109.575000, -48.700000, 0.000000>, <-105.400000, -48.250000, 0.000000>, <-99.650000, -47.000000, 0.000000>, <-92.675000, -42.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.575000, -48.700000, 0.000000>, <-105.400000, -48.250000, 0.000000>, <-99.650000, -47.000000, 0.000000>, <-92.675000, -42.925000, 0.000000>, 
      <-109.500000, -45.950000, 1.000000>, <-104.700000, -45.700000, 1.000000>, <-99.500000, -43.800000, 1.000000>, <-92.800000, -39.000000, 1.000000>, 
      <-109.500000, -45.700000, -1.000000>, <-104.700000, -45.400000, -1.000000>, <-99.500000, -43.600000, -1.000000>, <-92.800000, -38.800000, -1.000000>, 
      <-109.925000, -42.700000, 0.000000>, <-105.000000, -42.400000, 0.000000>, <-99.450000, -40.600000, 0.000000>, <-92.775000, -35.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.925000, -42.700000, 0.000000>, <-105.000000, -42.400000, 0.000000>, <-99.450000, -40.600000, 0.000000>, <-92.775000, -35.800000, 0.000000>, 
      <-110.350000, -39.700000, 1.000000>, <-105.300000, -39.400000, 1.000000>, <-99.400000, -37.600000, 1.000000>, <-92.750000, -32.800000, 1.000000>, 
      <-110.450000, -39.500000, -1.000000>, <-105.400000, -39.200000, -1.000000>, <-99.400000, -37.400000, -1.000000>, <-92.750000, -32.600000, -1.000000>, 
      <-110.850000, -36.500000, 0.000000>, <-105.700000, -36.200000, 0.000000>, <-99.300000, -34.350000, 0.000000>, <-92.700000, -29.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-110.850000, -36.500000, 0.000000>, <-105.700000, -36.200000, 0.000000>, <-99.300000, -34.350000, 0.000000>, <-92.700000, -29.550000, 0.000000>, 
      <-111.250000, -33.500000, 1.000000>, <-106.000000, -33.200000, 1.000000>, <-99.200000, -31.300000, 1.000000>, <-92.650000, -26.500000, 1.000000>, 
      <-111.300000, -33.300000, -1.000000>, <-106.000000, -33.000000, -1.000000>, <-99.200000, -31.100000, -1.000000>, <-92.650000, -26.300000, -1.000000>, 
      <-110.700000, -29.900000, 0.000000>, <-105.000000, -29.300000, 0.000000>, <-99.100000, -28.050000, 0.000000>, <-92.575000, -23.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-110.700000, -29.900000, 0.000000>, <-105.000000, -29.300000, 0.000000>, <-99.100000, -28.050000, 0.000000>, <-92.575000, -23.250000, 0.000000>, 
      <-110.100000, -26.500000, 1.000000>, <-104.000000, -25.600000, 1.000000>, <-99.000000, -25.000000, 1.000000>, <-92.500000, -20.200000, 1.000000>, 
      <-110.150000, -26.200000, -1.000000>, <-104.100000, -25.300000, -1.000000>, <-99.000000, -24.800000, -1.000000>, <-92.500000, -20.000000, -1.000000>, 
      <-109.875000, -23.275000, 0.000000>, <-104.450000, -22.300000, 0.000000>, <-98.300000, -21.200000, 0.000000>, <-92.125000, -16.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.875000, -23.275000, 0.000000>, <-104.450000, -22.300000, 0.000000>, <-98.300000, -21.200000, 0.000000>, <-92.125000, -16.800000, 0.000000>, 
      <-109.600000, -20.350000, 1.000000>, <-104.800000, -19.300000, 1.000000>, <-97.600000, -17.600000, 1.000000>, <-91.750000, -13.600000, 1.000000>, 
      <-109.600000, -20.150000, -1.000000>, <-104.800000, -19.100000, -1.000000>, <-97.500000, -17.500000, -1.000000>, <-91.700000, -13.450000, -1.000000>, 
      <-109.500000, -17.125000, 0.000000>, <-104.300000, -16.050000, 0.000000>, <-96.950000, -14.550000, 0.000000>, <-91.550000, -10.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.500000, -17.125000, 0.000000>, <-104.300000, -16.050000, 0.000000>, <-96.950000, -14.550000, 0.000000>, <-91.550000, -10.450000, 0.000000>, 
      <-109.400000, -14.100000, 1.000000>, <-103.800000, -13.000000, 1.000000>, <-96.400000, -11.600000, 1.000000>, <-91.400000, -7.450000, 1.000000>, 
      <-109.450000, -13.900000, -1.000000>, <-103.800000, -12.800000, -1.000000>, <-96.500000, -11.400000, -1.000000>, <-91.450000, -7.250000, -1.000000>, 
      <-109.275000, -10.625000, 0.000000>, <-103.150000, -9.300000, 0.000000>, <-96.700000, -8.350000, 0.000000>, <-91.325000, -4.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.275000, -10.625000, 0.000000>, <-103.150000, -9.300000, 0.000000>, <-96.700000, -8.350000, 0.000000>, <-91.325000, -4.175000, 0.000000>, 
      <-109.100000, -7.350000, 1.000000>, <-102.500000, -5.800000, 1.000000>, <-96.900000, -5.300000, 1.000000>, <-91.200000, -1.100000, 1.000000>, 
      <-109.100000, -7.100000, -1.000000>, <-102.500000, -5.500000, -1.000000>, <-96.900000, -5.100000, -1.000000>, <-91.200000, -0.900000, -1.000000>, 
      <-109.375000, -4.100000, 0.000000>, <-102.750000, -2.500000, 0.000000>, <-97.150000, -2.100000, 0.000000>, <-91.325000, 2.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.375000, -4.100000, 0.000000>, <-102.750000, -2.500000, 0.000000>, <-97.150000, -2.100000, 0.000000>, <-91.325000, 2.125000, 0.000000>, 
      <-109.650000, -1.100000, 1.000000>, <-103.000000, 0.500000, 1.000000>, <-97.400000, 0.900000, 1.000000>, <-91.450000, 5.150000, 1.000000>, 
      <-109.650000, -0.900000, -1.000000>, <-103.000000, 0.700000, -1.000000>, <-97.400000, 1.100000, -1.000000>, <-91.450000, 5.350000, -1.000000>, 
      <-108.950000, 2.450000, 0.000000>, <-102.200000, 3.800000, 0.000000>, <-97.600000, 4.150000, 0.000000>, <-91.525000, 8.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-108.950000, 2.450000, 0.000000>, <-102.200000, 3.800000, 0.000000>, <-97.600000, 4.150000, 0.000000>, <-91.525000, 8.400000, 0.000000>, 
      <-108.250000, 5.800000, 1.000000>, <-101.400000, 6.900000, 1.000000>, <-97.800000, 7.200000, 1.000000>, <-91.600000, 11.450000, 1.000000>, 
      <-108.300000, 6.000000, -1.000000>, <-101.500000, 7.100000, -1.000000>, <-97.900000, 7.400000, -1.000000>, <-91.700000, 11.650000, -1.000000>, 
      <-108.600000, 9.025000, 0.000000>, <-101.700000, 10.150000, 0.000000>, <-97.550000, 10.800000, 0.000000>, <-91.500000, 14.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-108.600000, 9.025000, 0.000000>, <-101.700000, 10.150000, 0.000000>, <-97.550000, 10.800000, 0.000000>, <-91.500000, 14.850000, 0.000000>, 
      <-108.900000, 12.050000, 1.000000>, <-101.900000, 13.200000, 1.000000>, <-97.200000, 14.200000, 1.000000>, <-91.300000, 18.050000, 1.000000>, 
      <-108.900000, 12.250000, -1.000000>, <-101.900000, 13.400000, -1.000000>, <-97.200000, 14.400000, -1.000000>, <-91.300000, 18.300000, -1.000000>, 
      <-109.200000, 15.250000, 0.000000>, <-102.150000, 16.400000, 0.000000>, <-97.200000, 18.100000, 0.000000>, <-91.300000, 21.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.200000, 15.250000, 0.000000>, <-102.150000, 16.400000, 0.000000>, <-97.200000, 18.100000, 0.000000>, <-91.300000, 21.650000, 0.000000>, 
      <-109.500000, 18.250000, 1.000000>, <-102.400000, 19.400000, 1.000000>, <-97.200000, 21.800000, 1.000000>, <-91.300000, 25.000000, 1.000000>, 
      <-109.550000, 18.450000, -1.000000>, <-102.400000, 19.600000, -1.000000>, <-97.200000, 22.000000, -1.000000>, <-91.300000, 25.200000, -1.000000>, 
      <-109.575000, 21.475000, 0.000000>, <-102.600000, 22.650000, 0.000000>, <-97.300000, 25.850000, 0.000000>, <-91.325000, 28.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.575000, 21.475000, 0.000000>, <-102.600000, 22.650000, 0.000000>, <-97.300000, 25.850000, 0.000000>, <-91.325000, 28.650000, 0.000000>, 
      <-109.600000, 24.500000, 1.000000>, <-102.800000, 25.700000, 1.000000>, <-97.400000, 29.700000, 1.000000>, <-91.350000, 32.100000, 1.000000>, 
      <-109.650000, 24.700000, -1.000000>, <-102.900000, 25.900000, -1.000000>, <-97.500000, 29.900000, -1.000000>, <-91.400000, 32.300000, -1.000000>, 
      <-109.500000, 28.050000, 0.000000>, <-103.100000, 28.900000, 0.000000>, <-96.350000, 33.050000, 0.000000>, <-90.500000, 35.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-109.500000, 28.050000, 0.000000>, <-103.100000, 28.900000, 0.000000>, <-96.350000, 33.050000, 0.000000>, <-90.500000, 35.350000, 0.000000>, 
      <-109.350000, 31.400000, 1.000000>, <-103.300000, 31.900000, 1.000000>, <-95.200000, 36.200000, 1.000000>, <-89.600000, 38.400000, 1.000000>, 
      <-109.350000, 31.600000, -1.000000>, <-103.300000, 32.100000, -1.000000>, <-95.200000, 36.500000, -1.000000>, <-89.650000, 38.650000, -1.000000>, 
      <-108.975000, 34.825000, 0.000000>, <-102.950000, 35.500000, 0.000000>, <-95.700000, 39.400000, 0.000000>, <-89.875000, 41.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-108.975000, 34.825000, 0.000000>, <-102.950000, 35.500000, 0.000000>, <-95.700000, 39.400000, 0.000000>, <-89.875000, 41.625000, 0.000000>, 
      <-108.600000, 38.050000, 1.000000>, <-102.600000, 38.900000, 1.000000>, <-96.200000, 42.300000, 1.000000>, <-90.100000, 44.600000, 1.000000>, 
      <-108.650000, 38.300000, -1.000000>, <-102.700000, 39.100000, -1.000000>, <-96.200000, 42.500000, -1.000000>, <-90.100000, 44.800000, -1.000000>, 
      <-107.825000, 41.950000, 0.000000>, <-101.850000, 43.250000, 0.000000>, <-95.150000, 44.950000, 0.000000>, <-89.575000, 47.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-107.825000, 41.950000, 0.000000>, <-101.850000, 43.250000, 0.000000>, <-95.150000, 44.950000, 0.000000>, <-89.575000, 47.525000, 0.000000>, 
      <-107.000000, 45.600000, 1.000000>, <-101.000000, 47.400000, 1.000000>, <-94.100000, 47.400000, 1.000000>, <-89.050000, 50.250000, 1.000000>, 
      <-106.900000, 45.750000, -1.000000>, <-100.800000, 47.500000, -1.000000>, <-94.100000, 47.600000, -1.000000>, <-89.050000, 50.450000, -1.000000>, 
      <-106.750000, 48.775000, 0.000000>, <-101.050000, 50.500000, 0.000000>, <-94.350000, 50.650000, 0.000000>, <-88.700000, 53.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-106.750000, 48.775000, 0.000000>, <-101.050000, 50.500000, 0.000000>, <-94.350000, 50.650000, 0.000000>, <-88.700000, 53.525000, 0.000000>, 
      <-106.600000, 51.800000, 1.000000>, <-101.300000, 53.500000, 1.000000>, <-94.600000, 53.700000, 1.000000>, <-88.350000, 56.600000, 1.000000>, 
      <-106.600000, 52.050000, -1.000000>, <-101.300000, 53.700000, -1.000000>, <-94.600000, 53.900000, -1.000000>, <-88.350000, 56.800000, -1.000000>, 
      <-106.850000, 55.075000, 0.000000>, <-101.550000, 56.750000, 0.000000>, <-94.850000, 56.900000, 0.000000>, <-88.450000, 59.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-106.850000, 55.075000, 0.000000>, <-101.550000, 56.750000, 0.000000>, <-94.850000, 56.900000, 0.000000>, <-88.450000, 59.825000, 0.000000>, 
      <-107.100000, 58.100000, 1.000000>, <-101.800000, 59.800000, 1.000000>, <-95.100000, 59.900000, 1.000000>, <-88.550000, 62.850000, 1.000000>, 
      <-107.100000, 58.300000, -1.000000>, <-101.800000, 60.000000, -1.000000>, <-95.100000, 60.100000, -1.000000>, <-88.550000, 63.050000, -1.000000>, 
      <-107.325000, 61.325000, 0.000000>, <-102.050000, 63.000000, 0.000000>, <-95.350000, 63.150000, 0.000000>, <-88.675000, 66.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-107.325000, 61.325000, 0.000000>, <-102.050000, 63.000000, 0.000000>, <-95.350000, 63.150000, 0.000000>, <-88.675000, 66.100000, 0.000000>, 
      <-107.550000, 64.350000, 1.000000>, <-102.300000, 66.000000, 1.000000>, <-95.600000, 66.200000, 1.000000>, <-88.800000, 69.150000, 1.000000>, 
      <-107.600000, 64.550000, -1.000000>, <-102.300000, 66.200000, -1.000000>, <-95.600000, 66.400000, -1.000000>, <-88.800000, 69.350000, -1.000000>, 
      <-107.950000, 68.450000, 0.700000>, <-102.700000, 70.100000, 0.700000>, <-95.900000, 70.300000, 0.700000>, <-88.950000, 73.250000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-86.100000, -119.250000, -1.000000>, <-82.700000, -116.300000, -1.000000>, <-79.100000, -115.700000, -1.000000>, <-75.600000, -115.050000, -1.000000>, 
      <-86.800000, -115.350000, 1.000000>, <-83.400000, -112.400000, 1.000000>, <-79.800000, -111.800000, 1.000000>, <-76.300000, -111.150000, 1.000000>, 
      <-86.800000, -115.150000, -1.000000>, <-83.400000, -112.200000, -1.000000>, <-79.900000, -111.600000, -1.000000>, <-76.350000, -110.950000, -1.000000>, 
      <-87.350000, -112.175000, 0.000000>, <-83.950000, -109.250000, 0.000000>, <-80.450000, -108.600000, 0.000000>, <-76.900000, -107.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-87.350000, -112.175000, 0.000000>, <-83.950000, -109.250000, 0.000000>, <-80.450000, -108.600000, 0.000000>, <-76.900000, -107.950000, 0.000000>, 
      <-87.900000, -109.200000, 1.000000>, <-84.500000, -106.300000, 1.000000>, <-81.000000, -105.600000, 1.000000>, <-77.450000, -104.950000, 1.000000>, 
      <-87.950000, -109.000000, -1.000000>, <-84.600000, -106.100000, -1.000000>, <-81.000000, -105.400000, -1.000000>, <-77.500000, -104.750000, -1.000000>, 
      <-88.475000, -106.000000, 0.000000>, <-85.100000, -103.100000, 0.000000>, <-81.550000, -102.400000, 0.000000>, <-77.325000, -101.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-88.475000, -106.000000, 0.000000>, <-85.100000, -103.100000, 0.000000>, <-81.550000, -102.400000, 0.000000>, <-77.325000, -101.575000, 0.000000>, 
      <-89.000000, -103.000000, 1.000000>, <-85.600000, -100.100000, 1.000000>, <-82.100000, -99.400000, 1.000000>, <-77.150000, -98.400000, 1.000000>, 
      <-89.100000, -102.800000, -1.000000>, <-85.700000, -99.900000, -1.000000>, <-82.200000, -99.200000, -1.000000>, <-77.200000, -98.150000, -1.000000>, 
      <-89.625000, -99.825000, 0.000000>, <-86.250000, -96.900000, 0.000000>, <-82.700000, -96.250000, 0.000000>, <-77.450000, -95.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-89.625000, -99.825000, 0.000000>, <-86.250000, -96.900000, 0.000000>, <-82.700000, -96.250000, 0.000000>, <-77.450000, -95.175000, 0.000000>, 
      <-90.150000, -96.850000, 1.000000>, <-86.800000, -93.900000, 1.000000>, <-83.200000, -93.300000, 1.000000>, <-77.700000, -92.200000, 1.000000>, 
      <-90.200000, -96.650000, -1.000000>, <-86.800000, -93.700000, -1.000000>, <-83.300000, -93.100000, -1.000000>, <-77.750000, -92.000000, -1.000000>, 
      <-90.750000, -93.675000, 0.000000>, <-87.350000, -90.750000, 0.000000>, <-83.800000, -90.100000, 0.000000>, <-77.975000, -88.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-90.750000, -93.675000, 0.000000>, <-87.350000, -90.750000, 0.000000>, <-83.800000, -90.100000, 0.000000>, <-77.975000, -88.975000, 0.000000>, 
      <-91.300000, -90.700000, 1.000000>, <-87.900000, -87.800000, 1.000000>, <-84.300000, -87.100000, 1.000000>, <-78.200000, -85.950000, 1.000000>, 
      <-91.300000, -90.450000, -1.000000>, <-87.900000, -87.500000, -1.000000>, <-84.400000, -86.900000, -1.000000>, <-78.250000, -85.750000, -1.000000>, 
      <-91.850000, -87.475000, 0.000000>, <-88.450000, -84.550000, 0.000000>, <-84.950000, -83.900000, 0.000000>, <-78.525000, -82.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.850000, -87.475000, 0.000000>, <-88.450000, -84.550000, 0.000000>, <-84.950000, -83.900000, 0.000000>, <-78.525000, -82.725000, 0.000000>, 
      <-92.400000, -84.500000, 1.000000>, <-89.000000, -81.600000, 1.000000>, <-85.500000, -80.900000, 1.000000>, <-78.800000, -79.700000, 1.000000>, 
      <-92.500000, -84.300000, -1.000000>, <-89.100000, -81.400000, -1.000000>, <-85.500000, -80.700000, -1.000000>, <-78.800000, -79.500000, -1.000000>, 
      <-92.450000, -81.125000, 0.000000>, <-88.500000, -78.000000, 0.000000>, <-84.950000, -77.350000, 0.000000>, <-78.525000, -76.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.450000, -81.125000, 0.000000>, <-88.500000, -78.000000, 0.000000>, <-84.950000, -77.350000, 0.000000>, <-78.525000, -76.325000, 0.000000>, 
      <-92.400000, -77.950000, 1.000000>, <-87.900000, -74.600000, 1.000000>, <-84.400000, -74.000000, 1.000000>, <-78.250000, -73.150000, 1.000000>, 
      <-92.450000, -77.700000, -1.000000>, <-87.900000, -74.400000, -1.000000>, <-84.400000, -73.800000, -1.000000>, <-78.250000, -72.950000, -1.000000>, 
      <-92.550000, -74.975000, 0.000000>, <-87.600000, -71.900000, 0.000000>, <-84.050000, -71.400000, 0.000000>, <-78.050000, -70.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.550000, -74.975000, 0.000000>, <-87.600000, -71.900000, 0.000000>, <-84.050000, -71.400000, 0.000000>, <-78.050000, -70.225000, 0.000000>, 
      <-92.650000, -72.250000, 1.000000>, <-87.300000, -69.400000, 1.000000>, <-83.700000, -69.000000, 1.000000>, <-77.850000, -67.500000, 1.000000>, 
      <-92.000000, -71.900000, -1.000000>, <-85.900000, -68.900000, -1.000000>, <-79.200000, -65.700000, -1.000000>, <-75.600000, -65.750000, -1.000000>, 
      <-92.225000, -68.975000, 0.000000>, <-86.250000, -65.900000, 0.000000>, <-79.200000, -62.700000, 0.000000>, <-75.600000, -62.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.225000, -68.975000, 0.000000>, <-86.250000, -65.900000, 0.000000>, <-79.200000, -62.700000, 0.000000>, <-75.600000, -62.725000, 0.000000>, 
      <-92.450000, -66.050000, 1.000000>, <-86.600000, -62.900000, 1.000000>, <-79.200000, -59.700000, 1.000000>, <-75.600000, -59.700000, 1.000000>, 
      <-92.450000, -65.850000, -1.000000>, <-86.600000, -62.700000, -1.000000>, <-79.200000, -59.500000, -1.000000>, <-75.600000, -59.500000, -1.000000>, 
      <-92.600000, -62.875000, 0.000000>, <-86.650000, -59.800000, 0.000000>, <-79.150000, -56.450000, 0.000000>, <-75.550000, -56.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.600000, -62.875000, 0.000000>, <-86.650000, -59.800000, 0.000000>, <-79.150000, -56.450000, 0.000000>, <-75.550000, -56.450000, 0.000000>, 
      <-92.750000, -59.900000, 1.000000>, <-86.700000, -56.900000, 1.000000>, <-79.100000, -53.400000, 1.000000>, <-75.500000, -53.400000, 1.000000>, 
      <-92.750000, -59.700000, -1.000000>, <-86.700000, -56.700000, -1.000000>, <-79.100000, -53.200000, -1.000000>, <-75.550000, -53.200000, -1.000000>, 
      <-92.650000, -56.550000, 0.000000>, <-86.250000, -53.400000, 0.000000>, <-79.100000, -50.150000, 0.000000>, <-75.525000, -50.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.650000, -56.550000, 0.000000>, <-86.250000, -53.400000, 0.000000>, <-79.100000, -50.150000, 0.000000>, <-75.525000, -50.175000, 0.000000>, 
      <-92.550000, -53.400000, 1.000000>, <-85.800000, -50.100000, 1.000000>, <-79.100000, -47.100000, 1.000000>, <-75.500000, -47.150000, 1.000000>, 
      <-92.550000, -53.200000, -1.000000>, <-85.800000, -49.900000, -1.000000>, <-79.100000, -46.900000, -1.000000>, <-75.500000, -46.950000, -1.000000>, 
      <-92.550000, -50.125000, 0.000000>, <-85.550000, -46.800000, 0.000000>, <-79.100000, -43.900000, 0.000000>, <-75.500000, -43.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.550000, -50.125000, 0.000000>, <-85.550000, -46.800000, 0.000000>, <-79.100000, -43.900000, 0.000000>, <-75.500000, -43.925000, 0.000000>, 
      <-92.550000, -47.050000, 1.000000>, <-85.300000, -43.700000, 1.000000>, <-79.100000, -40.900000, 1.000000>, <-75.500000, -40.900000, 1.000000>, 
      <-92.550000, -46.850000, -1.000000>, <-85.300000, -43.500000, -1.000000>, <-79.000000, -40.900000, -1.000000>, <-75.450000, -40.800000, -1.000000>, 
      <-92.675000, -42.925000, 0.000000>, <-85.700000, -38.850000, 0.000000>, <-79.000000, -37.750000, 0.000000>, <-75.425000, -37.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.675000, -42.925000, 0.000000>, <-85.700000, -38.850000, 0.000000>, <-79.000000, -37.750000, 0.000000>, <-75.425000, -37.700000, 0.000000>, 
      <-92.800000, -39.000000, 1.000000>, <-86.100000, -34.200000, 1.000000>, <-79.000000, -34.600000, 1.000000>, <-75.400000, -34.600000, 1.000000>, 
      <-92.800000, -38.800000, -1.000000>, <-86.100000, -34.000000, -1.000000>, <-79.000000, -34.400000, -1.000000>, <-75.400000, -34.400000, -1.000000>, 
      <-92.775000, -35.800000, 0.000000>, <-86.100000, -31.000000, 0.000000>, <-79.000000, -31.350000, 0.000000>, <-75.400000, -31.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.775000, -35.800000, 0.000000>, <-86.100000, -31.000000, 0.000000>, <-79.000000, -31.350000, 0.000000>, <-75.400000, -31.375000, 0.000000>, 
      <-92.750000, -32.800000, 1.000000>, <-86.100000, -28.000000, 1.000000>, <-79.000000, -28.300000, 1.000000>, <-75.400000, -28.350000, 1.000000>, 
      <-92.750000, -32.600000, -1.000000>, <-86.100000, -27.800000, -1.000000>, <-79.000000, -28.100000, -1.000000>, <-75.400000, -28.100000, -1.000000>, 
      <-92.700000, -29.550000, 0.000000>, <-86.100000, -24.750000, 0.000000>, <-78.950000, -25.050000, 0.000000>, <-75.375000, -25.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.700000, -29.550000, 0.000000>, <-86.100000, -24.750000, 0.000000>, <-78.950000, -25.050000, 0.000000>, <-75.375000, -25.075000, 0.000000>, 
      <-92.650000, -26.500000, 1.000000>, <-86.100000, -21.700000, 1.000000>, <-78.900000, -22.000000, 1.000000>, <-75.350000, -22.050000, 1.000000>, 
      <-92.650000, -26.300000, -1.000000>, <-86.100000, -21.500000, -1.000000>, <-79.000000, -21.800000, -1.000000>, <-75.400000, -21.850000, -1.000000>, 
      <-92.575000, -23.250000, 0.000000>, <-86.050000, -18.450000, 0.000000>, <-78.950000, -18.800000, 0.000000>, <-75.095209, -18.828178, 0.020585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.575000, -23.250000, 0.000000>, <-86.050000, -18.450000, 0.000000>, <-78.950000, -18.800000, 0.000000>, <-75.095209, -18.828178, 0.020585>, 
      <-92.500000, -20.200000, 1.000000>, <-86.000000, -15.400000, 1.000000>, <-78.900000, -15.800000, 1.000000>, <-74.790417, -15.806355, 1.041170>, 
      <-92.500000, -20.000000, -1.000000>, <-86.000000, -15.200000, -1.000000>, <-78.900000, -15.600000, -1.000000>, <-74.789791, -15.599189, 0.058361>, 
      <-92.125000, -16.800000, 0.000000>, <-85.950000, -12.400000, 0.000000>, <-78.364659, -12.548958, 0.041170>, <-74.513264, -12.559056, 0.570350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-92.125000, -16.800000, 0.000000>, <-85.950000, -12.400000, 0.000000>, <-78.364659, -12.548958, 0.041170>, <-74.513264, -12.559056, 0.570350>, 
      <-91.750000, -13.600000, 1.000000>, <-85.900000, -9.600000, 1.000000>, <-77.829319, -9.497916, 1.082340>, <-74.236738, -9.518923, 1.082340>, 
      <-91.700000, -13.450000, -1.000000>, <-85.900000, -9.400000, -1.000000>, <-77.828066, -9.283584, 1.116721>, <-74.235484, -9.304591, 1.116721>, 
      <-91.550000, -10.450000, 0.000000>, <-86.150000, -6.350000, 0.000000>, <-77.810353, -6.254360, 1.099530>, <-74.393981, -6.367591, 1.088289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.550000, -10.450000, 0.000000>, <-86.150000, -6.350000, 0.000000>, <-77.810353, -6.254360, 1.099530>, <-74.393981, -6.367591, 1.088289>, 
      <-91.400000, -7.450000, 1.000000>, <-86.400000, -3.300000, 1.000000>, <-77.792641, -3.225136, 1.082340>, <-74.552478, -3.430592, 1.059856>, 
      <-91.450000, -7.250000, -1.000000>, <-86.400000, -3.100000, -1.000000>, <-77.791387, -3.010804, 1.116721>, <-74.551225, -3.216260, 1.115686>, 
      <-91.325000, -4.175000, 0.000000>, <-85.950000, 0.000000, 0.000000>, <-77.773675, 0.018421, 1.099530>, <-74.533512, -0.187036, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.325000, -4.175000, 0.000000>, <-85.950000, 0.000000, 0.000000>, <-77.773675, 0.018421, 1.099530>, <-74.533512, -0.187036, 1.087771>, 
      <-91.200000, -1.100000, 1.000000>, <-85.500000, 3.100000, 1.000000>, <-77.755962, 3.047645, 1.082340>, <-74.515800, 2.842188, 1.059856>, 
      <-91.200000, -0.900000, -1.000000>, <-85.500000, 3.300000, -1.000000>, <-77.754709, 3.261977, 1.116721>, <-74.514547, 3.056521, 1.115686>, 
      <-91.325000, 2.125000, 0.000000>, <-85.500000, 6.350000, 0.000000>, <-77.736997, 6.291201, 1.099530>, <-74.496834, 6.085745, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.325000, 2.125000, 0.000000>, <-85.500000, 6.350000, 0.000000>, <-77.736997, 6.291201, 1.099530>, <-74.496834, 6.085745, 1.087771>, 
      <-91.450000, 5.150000, 1.000000>, <-85.500000, 9.400000, 1.000000>, <-77.719284, 9.320425, 1.082340>, <-74.479122, 9.114969, 1.059856>, 
      <-91.450000, 5.350000, -1.000000>, <-85.500000, 9.600000, -1.000000>, <-77.718031, 9.534757, 1.116721>, <-74.477868, 9.329301, 1.115686>, 
      <-91.525000, 8.400000, 0.000000>, <-85.450000, 12.650000, 0.000000>, <-77.700318, 12.563982, 1.099530>, <-74.460156, 12.358525, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.525000, 8.400000, 0.000000>, <-85.450000, 12.650000, 0.000000>, <-77.700318, 12.563982, 1.099530>, <-74.460156, 12.358525, 1.087771>, 
      <-91.600000, 11.450000, 1.000000>, <-85.400000, 15.700000, 1.000000>, <-77.682606, 15.593206, 1.082340>, <-74.442443, 15.387749, 1.059856>, 
      <-91.700000, 11.650000, -1.000000>, <-85.500000, 15.900000, -1.000000>, <-77.681353, 15.807538, 1.116721>, <-74.441190, 15.602082, 1.115686>, 
      <-91.500000, 14.850000, 0.000000>, <-85.450000, 18.900000, 0.000000>, <-77.663640, 18.836762, 1.099530>, <-74.423478, 18.631306, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.500000, 14.850000, 0.000000>, <-85.450000, 18.900000, 0.000000>, <-77.663640, 18.836762, 1.099530>, <-74.423478, 18.631306, 1.087771>, 
      <-91.300000, 18.050000, 1.000000>, <-85.400000, 21.900000, 1.000000>, <-77.645928, 21.865986, 1.082340>, <-74.405765, 21.660530, 1.059856>, 
      <-91.300000, 18.300000, -1.000000>, <-85.400000, 22.200000, -1.000000>, <-77.644675, 22.080318, 1.116721>, <-74.404512, 21.874862, 1.115686>, 
      <-91.300000, 21.650000, 0.000000>, <-85.400000, 25.200000, 0.000000>, <-77.626962, 25.109543, 1.099530>, <-74.386800, 24.904086, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.300000, 21.650000, 0.000000>, <-85.400000, 25.200000, 0.000000>, <-77.626962, 25.109543, 1.099530>, <-74.386800, 24.904086, 1.087771>, 
      <-91.300000, 25.000000, 1.000000>, <-85.400000, 28.200000, 1.000000>, <-77.609250, 28.138767, 1.082340>, <-74.369087, 27.933310, 1.059856>, 
      <-91.300000, 25.200000, -1.000000>, <-85.400000, 28.400000, -1.000000>, <-77.607996, 28.353099, 1.116721>, <-74.367834, 28.147643, 1.115686>, 
      <-91.325000, 28.650000, 0.000000>, <-85.350000, 31.450000, 0.000000>, <-77.590284, 31.382323, 1.099530>, <-74.350121, 31.176867, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-91.325000, 28.650000, 0.000000>, <-85.350000, 31.450000, 0.000000>, <-77.590284, 31.382323, 1.099530>, <-74.350121, 31.176867, 1.087771>, 
      <-91.350000, 32.100000, 1.000000>, <-85.300000, 34.500000, 1.000000>, <-77.572571, 34.411547, 1.082340>, <-74.332409, 34.206091, 1.059856>, 
      <-91.400000, 32.300000, -1.000000>, <-85.300000, 34.700000, -1.000000>, <-77.571318, 34.625880, 1.116721>, <-74.331156, 34.420423, 1.115686>, 
      <-90.500000, 35.350000, 0.000000>, <-84.650000, 37.650000, 0.000000>, <-77.553606, 37.655104, 1.099530>, <-74.313443, 37.449647, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-90.500000, 35.350000, 0.000000>, <-84.650000, 37.650000, 0.000000>, <-77.553606, 37.655104, 1.099530>, <-74.313443, 37.449647, 1.087771>, 
      <-89.600000, 38.400000, 1.000000>, <-84.000000, 40.600000, 1.000000>, <-77.535893, 40.684328, 1.082340>, <-74.295731, 40.478872, 1.059856>, 
      <-89.650000, 38.650000, -1.000000>, <-84.100000, 40.800000, -1.000000>, <-77.534640, 40.898660, 1.116721>, <-74.294477, 40.693204, 1.115686>, 
      <-89.875000, 41.625000, 0.000000>, <-84.050000, 43.850000, 0.000000>, <-77.516927, 43.927884, 1.099530>, <-74.276765, 43.722428, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-89.875000, 41.625000, 0.000000>, <-84.050000, 43.850000, 0.000000>, <-77.516927, 43.927884, 1.099530>, <-74.276765, 43.722428, 1.087771>, 
      <-90.100000, 44.600000, 1.000000>, <-84.000000, 46.900000, 1.000000>, <-77.499215, 46.957108, 1.082340>, <-74.259052, 46.751652, 1.059856>, 
      <-90.100000, 44.800000, -1.000000>, <-84.000000, 47.100000, -1.000000>, <-77.497962, 47.171441, 1.116721>, <-74.257799, 46.965984, 1.115686>, 
      <-89.575000, 47.525000, 0.000000>, <-84.000000, 50.100000, 0.000000>, <-77.480249, 50.200665, 1.099530>, <-74.240087, 49.995208, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-89.575000, 47.525000, 0.000000>, <-84.000000, 50.100000, 0.000000>, <-77.480249, 50.200665, 1.099530>, <-74.240087, 49.995208, 1.087771>, 
      <-89.050000, 50.250000, 1.000000>, <-84.000000, 53.100000, 1.000000>, <-77.462537, 53.229889, 1.082340>, <-74.222374, 53.024433, 1.059856>, 
      <-89.050000, 50.450000, -1.000000>, <-84.000000, 53.300000, -1.000000>, <-77.461284, 53.444221, 1.116721>, <-74.221121, 53.238765, 1.115686>, 
      <-88.700000, 53.525000, 0.000000>, <-83.050000, 56.400000, 0.000000>, <-77.443571, 56.473445, 1.099530>, <-74.203408, 56.267989, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-88.700000, 53.525000, 0.000000>, <-83.050000, 56.400000, 0.000000>, <-77.443571, 56.473445, 1.099530>, <-74.203408, 56.267989, 1.087771>, 
      <-88.350000, 56.600000, 1.000000>, <-82.100000, 59.500000, 1.000000>, <-77.425859, 59.502669, 1.082340>, <-74.185696, 59.297213, 1.059856>, 
      <-88.350000, 56.800000, -1.000000>, <-82.100000, 59.700000, -1.000000>, <-77.424605, 59.717002, 1.116721>, <-74.184443, 59.511545, 1.115686>, 
      <-88.450000, 59.825000, 0.000000>, <-82.050000, 62.750000, 0.000000>, <-77.406893, 62.746226, 1.099530>, <-74.166730, 62.540770, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-88.450000, 59.825000, 0.000000>, <-82.050000, 62.750000, 0.000000>, <-77.406893, 62.746226, 1.099530>, <-74.166730, 62.540770, 1.087771>, 
      <-88.550000, 62.850000, 1.000000>, <-82.000000, 65.800000, 1.000000>, <-77.389180, 65.775450, 1.082340>, <-74.149018, 65.569994, 1.059856>, 
      <-88.550000, 63.050000, -1.000000>, <-82.000000, 66.000000, -1.000000>, <-77.387927, 65.989782, 1.116721>, <-74.147765, 65.784326, 1.115686>, 
      <-88.675000, 66.100000, 0.000000>, <-82.000000, 69.050000, 0.000000>, <-77.370215, 69.019006, 1.099530>, <-74.130052, 68.813550, 1.087771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-88.675000, 66.100000, 0.000000>, <-82.000000, 69.050000, 0.000000>, <-77.370215, 69.019006, 1.099530>, <-74.130052, 68.813550, 1.087771>, 
      <-88.800000, 69.150000, 1.000000>, <-82.000000, 72.100000, 1.000000>, <-77.352502, 72.048230, 1.082340>, <-74.112340, 71.842774, 1.059856>, 
      <-88.800000, 69.350000, -1.000000>, <-82.000000, 72.300000, -1.000000>, <-77.351249, 72.262563, 1.116721>, <-74.111086, 72.057106, 1.115686>, 
      <-88.950000, 73.250000, 0.700000>, <-82.000000, 76.200000, 0.700000>, <-78.400000, 76.200000, 0.700000>, <-74.800000, 76.150000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.600000, -115.050000, -1.000000>, <-72.100000, -114.400000, -1.000000>, <-68.700000, -113.900000, -1.000000>, <-64.950000, -109.650000, -1.000000>, 
      <-76.300000, -111.150000, 1.000000>, <-72.800000, -110.500000, 1.000000>, <-68.700000, -109.900000, 1.000000>, <-64.950000, -105.650000, 1.000000>, 
      <-76.350000, -110.950000, -1.000000>, <-72.800000, -110.300000, -1.000000>, <-68.700000, -109.700000, -1.000000>, <-64.950000, -105.450000, -1.000000>, 
      <-76.900000, -107.950000, 0.000000>, <-73.350000, -107.300000, 0.000000>, <-68.650000, -106.700000, 0.000000>, <-64.925000, -102.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-76.900000, -107.950000, 0.000000>, <-73.350000, -107.300000, 0.000000>, <-68.650000, -106.700000, 0.000000>, <-64.925000, -102.450000, 0.000000>, 
      <-77.450000, -104.950000, 1.000000>, <-73.900000, -104.300000, 1.000000>, <-68.600000, -103.700000, 1.000000>, <-64.900000, -99.450000, 1.000000>, 
      <-77.500000, -104.750000, -1.000000>, <-74.000000, -104.100000, -1.000000>, <-68.700000, -103.400000, -1.000000>, <-64.950000, -99.150000, -1.000000>, 
      <-77.325000, -101.575000, 0.000000>, <-73.100000, -100.750000, 0.000000>, <-68.650000, -100.400000, 0.000000>, <-64.900000, -96.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-77.325000, -101.575000, 0.000000>, <-73.100000, -100.750000, 0.000000>, <-68.650000, -100.400000, 0.000000>, <-64.900000, -96.150000, 0.000000>, 
      <-77.150000, -98.400000, 1.000000>, <-72.200000, -97.400000, 1.000000>, <-68.600000, -97.400000, 1.000000>, <-64.850000, -93.150000, 1.000000>, 
      <-77.200000, -98.150000, -1.000000>, <-72.200000, -97.100000, -1.000000>, <-68.600000, -97.200000, -1.000000>, <-64.900000, -92.950000, -1.000000>, 
      <-77.450000, -95.175000, 0.000000>, <-72.200000, -94.100000, 0.000000>, <-68.600000, -94.150000, 0.000000>, <-64.875000, -89.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-77.450000, -95.175000, 0.000000>, <-72.200000, -94.100000, 0.000000>, <-68.600000, -94.150000, 0.000000>, <-64.875000, -89.900000, 0.000000>, 
      <-77.700000, -92.200000, 1.000000>, <-72.200000, -91.100000, 1.000000>, <-68.600000, -91.100000, 1.000000>, <-64.850000, -86.850000, 1.000000>, 
      <-77.750000, -92.000000, -1.000000>, <-72.200000, -90.900000, -1.000000>, <-68.600000, -90.900000, -1.000000>, <-64.850000, -86.650000, -1.000000>, 
      <-77.975000, -88.975000, 0.000000>, <-72.150000, -87.850000, 0.000000>, <-68.550000, -87.850000, 0.000000>, <-64.825000, -83.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-77.975000, -88.975000, 0.000000>, <-72.150000, -87.850000, 0.000000>, <-68.550000, -87.850000, 0.000000>, <-64.825000, -83.600000, 0.000000>, 
      <-78.200000, -85.950000, 1.000000>, <-72.100000, -84.800000, 1.000000>, <-68.500000, -84.800000, 1.000000>, <-64.800000, -80.550000, 1.000000>, 
      <-78.250000, -85.750000, -1.000000>, <-72.100000, -84.600000, -1.000000>, <-68.500000, -84.600000, -1.000000>, <-64.800000, -80.350000, -1.000000>, 
      <-78.525000, -82.725000, 0.000000>, <-72.100000, -81.550000, 0.000000>, <-68.500000, -81.600000, 0.000000>, <-64.775000, -77.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-78.525000, -82.725000, 0.000000>, <-72.100000, -81.550000, 0.000000>, <-68.500000, -81.600000, 0.000000>, <-64.775000, -77.350000, 0.000000>, 
      <-78.800000, -79.700000, 1.000000>, <-72.100000, -78.500000, 1.000000>, <-68.500000, -78.600000, 1.000000>, <-64.750000, -74.350000, 1.000000>, 
      <-78.800000, -79.500000, -1.000000>, <-72.100000, -78.300000, -1.000000>, <-68.500000, -78.300000, -1.000000>, <-64.750000, -74.100000, -1.000000>, 
      <-78.525000, -76.325000, 0.000000>, <-72.100000, -75.300000, 0.000000>, <-68.500000, -75.300000, 0.000000>, <-64.750000, -71.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-78.525000, -76.325000, 0.000000>, <-72.100000, -75.300000, 0.000000>, <-68.500000, -75.300000, 0.000000>, <-64.750000, -71.075000, 0.000000>, 
      <-78.250000, -73.150000, 1.000000>, <-72.100000, -72.300000, 1.000000>, <-68.500000, -72.300000, 1.000000>, <-64.750000, -68.050000, 1.000000>, 
      <-78.250000, -72.950000, -1.000000>, <-72.100000, -72.100000, -1.000000>, <-68.500000, -72.100000, -1.000000>, <-64.750000, -67.850000, -1.000000>, 
      <-78.050000, -70.225000, 0.000000>, <-72.050000, -69.050000, 0.000000>, <-68.450000, -69.050000, 0.000000>, <-64.725000, -64.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-78.050000, -70.225000, 0.000000>, <-72.050000, -69.050000, 0.000000>, <-68.450000, -69.050000, 0.000000>, <-64.725000, -64.800000, 0.000000>, 
      <-77.850000, -67.500000, 1.000000>, <-72.000000, -66.000000, 1.000000>, <-68.400000, -66.000000, 1.000000>, <-64.700000, -61.750000, 1.000000>, 
      <-75.600000, -65.750000, -1.000000>, <-72.000000, -65.800000, -1.000000>, <-68.400000, -65.800000, -1.000000>, <-64.700000, -61.550000, -1.000000>, 
      <-75.600000, -62.725000, 0.000000>, <-72.000000, -62.750000, 0.000000>, <-68.400000, -62.750000, 0.000000>, <-64.675000, -58.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.600000, -62.725000, 0.000000>, <-72.000000, -62.750000, 0.000000>, <-68.400000, -62.750000, 0.000000>, <-64.675000, -58.525000, 0.000000>, 
      <-75.600000, -59.700000, 1.000000>, <-72.000000, -59.700000, 1.000000>, <-68.400000, -59.700000, 1.000000>, <-64.650000, -55.500000, 1.000000>, 
      <-75.600000, -59.500000, -1.000000>, <-72.000000, -59.500000, -1.000000>, <-68.400000, -59.500000, -1.000000>, <-64.650000, -55.250000, -1.000000>, 
      <-75.550000, -56.450000, 0.000000>, <-71.950000, -56.450000, 0.000000>, <-68.350000, -56.500000, 0.000000>, <-64.625000, -52.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.550000, -56.450000, 0.000000>, <-71.950000, -56.450000, 0.000000>, <-68.350000, -56.500000, 0.000000>, <-64.625000, -52.250000, 0.000000>, 
      <-75.500000, -53.400000, 1.000000>, <-71.900000, -53.400000, 1.000000>, <-68.300000, -53.500000, 1.000000>, <-64.600000, -49.250000, 1.000000>, 
      <-75.550000, -53.200000, -1.000000>, <-72.000000, -53.200000, -1.000000>, <-68.400000, -53.300000, -1.000000>, <-64.650000, -49.050000, -1.000000>, 
      <-75.525000, -50.175000, 0.000000>, <-71.950000, -50.200000, 0.000000>, <-68.350000, -50.250000, 0.000000>, <-64.600000, -46.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.525000, -50.175000, 0.000000>, <-71.950000, -50.200000, 0.000000>, <-68.350000, -50.250000, 0.000000>, <-64.600000, -46.000000, 0.000000>, 
      <-75.500000, -47.150000, 1.000000>, <-71.900000, -47.200000, 1.000000>, <-68.300000, -47.200000, 1.000000>, <-64.550000, -42.950000, 1.000000>, 
      <-75.500000, -46.950000, -1.000000>, <-71.900000, -47.000000, -1.000000>, <-68.300000, -47.000000, -1.000000>, <-64.600000, -42.750000, -1.000000>, 
      <-75.500000, -43.925000, 0.000000>, <-71.900000, -43.950000, 0.000000>, <-68.300000, -43.950000, 0.000000>, <-64.575000, -39.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.500000, -43.925000, 0.000000>, <-71.900000, -43.950000, 0.000000>, <-68.300000, -43.950000, 0.000000>, <-64.575000, -39.700000, 0.000000>, 
      <-75.500000, -40.900000, 1.000000>, <-71.900000, -40.900000, 1.000000>, <-68.300000, -40.900000, 1.000000>, <-64.550000, -36.650000, 1.000000>, 
      <-75.450000, -40.800000, -1.000000>, <-71.900000, -40.700000, -1.000000>, <-68.300000, -40.700000, -1.000000>, <-64.550000, -36.450000, -1.000000>, 
      <-75.425000, -37.700000, 0.000000>, <-71.850000, -37.650000, 0.000000>, <-68.250000, -37.700000, 0.000000>, <-64.525000, -33.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.425000, -37.700000, 0.000000>, <-71.850000, -37.650000, 0.000000>, <-68.250000, -37.700000, 0.000000>, <-64.525000, -33.450000, 0.000000>, 
      <-75.400000, -34.600000, 1.000000>, <-71.800000, -34.600000, 1.000000>, <-68.200000, -34.700000, 1.000000>, <-64.500000, -30.450000, 1.000000>, 
      <-75.400000, -34.400000, -1.000000>, <-71.800000, -34.400000, -1.000000>, <-68.300000, -34.400000, -1.000000>, <-64.550000, -30.150000, -1.000000>, 
      <-75.400000, -31.375000, 0.000000>, <-71.800000, -31.400000, 0.000000>, <-68.250000, -31.400000, 0.000000>, <-64.500000, -27.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.400000, -31.375000, 0.000000>, <-71.800000, -31.400000, 0.000000>, <-68.250000, -31.400000, 0.000000>, <-64.500000, -27.150000, 0.000000>, 
      <-75.400000, -28.350000, 1.000000>, <-71.800000, -28.400000, 1.000000>, <-68.200000, -28.400000, 1.000000>, <-64.450000, -24.150000, 1.000000>, 
      <-75.400000, -28.100000, -1.000000>, <-71.800000, -28.100000, -1.000000>, <-68.200000, -28.200000, -1.000000>, <-64.450000, -23.950000, -1.000000>, 
      <-75.375000, -25.075000, 0.000000>, <-71.800000, -25.100000, 0.000000>, <-68.200000, -25.150000, 0.000000>, <-64.188817, -20.903368, 0.020585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.375000, -25.075000, 0.000000>, <-71.800000, -25.100000, 0.000000>, <-68.200000, -25.150000, 0.000000>, <-64.188817, -20.903368, 0.020585>, 
      <-75.350000, -22.050000, 1.000000>, <-71.800000, -22.100000, 1.000000>, <-68.200000, -22.100000, 1.000000>, <-63.927634, -17.856736, 1.041170>, 
      <-75.400000, -21.850000, -1.000000>, <-71.800000, -21.900000, -1.000000>, <-68.200000, -21.900000, -1.000000>, <-63.927007, -17.649570, 0.058361>, 
      <-75.095209, -18.828178, 0.020585>, <-71.240417, -18.856355, 0.041170>, <-67.644127, -18.866858, 0.041170>, <-63.816424, -14.710612, 0.559108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-75.095209, -18.828178, 0.020585>, <-71.240417, -18.856355, 0.041170>, <-67.644127, -18.866858, 0.041170>, <-63.816424, -14.710612, 0.559108>, 
      <-74.790417, -15.806355, 1.041170>, <-70.680835, -15.812710, 1.082340>, <-67.088253, -15.833717, 1.082340>, <-63.705840, -11.771654, 1.059856>, 
      <-74.789791, -15.599189, 0.058361>, <-70.679581, -15.598378, 1.116721>, <-67.087000, -15.619384, 1.116721>, <-63.704587, -11.557321, 1.115686>, 
      <-74.513264, -12.559056, 0.570350>, <-70.661869, -12.569154, 1.099530>, <-67.421706, -12.774610, 1.077047>, <-63.859479, -8.684654, 1.077519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.513264, -12.559056, 0.570350>, <-70.661869, -12.569154, 1.099530>, <-67.421706, -12.774610, 1.077047>, <-63.859479, -8.684654, 1.077519>, 
      <-74.236738, -9.518923, 1.082340>, <-70.644156, -9.539929, 1.082340>, <-67.756412, -9.929836, 1.037373>, <-64.014372, -5.811986, 1.039352>, 
      <-74.235484, -9.304591, 1.116721>, <-70.642903, -9.325597, 1.116721>, <-67.755159, -9.715503, 1.114652>, <-64.013119, -5.597654, 1.128344>, 
      <-74.393981, -6.367591, 1.088289>, <-70.977609, -6.480823, 1.077047>, <-67.730238, -6.501829, 1.077992>, <-63.995406, -2.411873, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.393981, -6.367591, 1.088289>, <-70.977609, -6.480823, 1.077047>, <-67.730238, -6.501829, 1.077992>, <-63.995406, -2.411873, 1.083848>, 
      <-74.552478, -3.430592, 1.059856>, <-71.312316, -3.636048, 1.037373>, <-67.705317, -3.288156, 1.041331>, <-63.977694, 0.773907, 1.039352>, 
      <-74.551225, -3.216260, 1.115686>, <-71.311062, -3.421716, 1.114652>, <-67.704064, -3.073823, 1.142036>, <-63.976441, 0.988240, 1.128344>, 
      <-74.533512, -0.187036, 1.087771>, <-71.293350, -0.392492, 1.076012>, <-67.686351, -0.044599, 1.091684>, <-63.958728, 4.017464, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.533512, -0.187036, 1.087771>, <-71.293350, -0.392492, 1.076012>, <-67.686351, -0.044599, 1.091684>, <-63.958728, 4.017464, 1.083848>, 
      <-74.515800, 2.842188, 1.059856>, <-71.275637, 2.636732, 1.037373>, <-67.668639, 2.984625, 1.041331>, <-63.941016, 7.046688, 1.039352>, 
      <-74.514547, 3.056521, 1.115686>, <-71.274384, 2.851064, 1.114652>, <-67.667386, 3.198957, 1.142036>, <-63.939762, 7.261020, 1.128344>, 
      <-74.496834, 6.085745, 1.087771>, <-71.256672, 5.880288, 1.076012>, <-67.649673, 6.140292, 1.091684>, <-63.922050, 10.246299, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.496834, 6.085745, 1.087771>, <-71.256672, 5.880288, 1.076012>, <-67.649673, 6.140292, 1.091684>, <-63.922050, 10.246299, 1.083848>, 
      <-74.479122, 9.114969, 1.059856>, <-71.238959, 8.909513, 1.037373>, <-67.631961, 9.081626, 1.041331>, <-63.904337, 13.231579, 1.039352>, 
      <-74.477868, 9.329301, 1.115686>, <-71.237706, 9.123845, 1.114652>, <-67.630707, 9.295958, 1.142036>, <-63.903084, 13.445911, 1.128344>, 
      <-74.460156, 12.358525, 1.087771>, <-71.219993, 12.153069, 1.076012>, <-67.612995, 12.325182, 1.091684>, <-63.885372, 16.475135, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.460156, 12.358525, 1.087771>, <-71.219993, 12.153069, 1.076012>, <-67.612995, 12.325182, 1.091684>, <-63.885372, 16.475135, 1.083848>, 
      <-74.442443, 15.387749, 1.059856>, <-71.202281, 15.182293, 1.037373>, <-67.595282, 15.354406, 1.041331>, <-63.867659, 19.504359, 1.039352>, 
      <-74.441190, 15.602082, 1.115686>, <-71.201028, 15.396625, 1.114652>, <-67.594029, 15.568739, 1.142036>, <-63.866406, 19.718691, 1.128344>, 
      <-74.423478, 18.631306, 1.087771>, <-71.183315, 18.425850, 1.076012>, <-67.576317, 18.835384, 1.132603>, <-63.848693, 22.866626, 1.104307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.423478, 18.631306, 1.087771>, <-71.183315, 18.425850, 1.076012>, <-67.576317, 18.835384, 1.132603>, <-63.848693, 22.866626, 1.104307>, 
      <-74.405765, 21.660530, 1.059856>, <-71.165603, 21.455074, 1.037373>, <-67.558604, 22.102030, 1.123170>, <-63.830981, 26.014561, 1.080271>, 
      <-74.404512, 21.874862, 1.115686>, <-71.164349, 21.669406, 1.114652>, <-67.557351, 22.316362, 1.223874>, <-63.829728, 26.228893, 1.169263>, 
      <-74.386800, 24.904086, 1.087771>, <-71.146637, 24.698630, 1.076012>, <-67.539639, 25.152110, 1.176548>, <-63.812015, 29.161379, 1.126280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.386800, 24.904086, 1.087771>, <-71.146637, 24.698630, 1.076012>, <-67.539639, 25.152110, 1.176548>, <-63.812015, 29.161379, 1.126280>, 
      <-74.369087, 27.933310, 1.059856>, <-71.128924, 27.727854, 1.037373>, <-67.521926, 27.987857, 1.129221>, <-63.794303, 32.093865, 1.083297>, 
      <-74.367834, 28.147643, 1.115686>, <-71.127671, 27.942186, 1.114652>, <-67.520673, 28.202190, 1.229926>, <-63.793050, 32.308197, 1.172289>, 
      <-74.350121, 31.176867, 1.087771>, <-71.109959, 30.971411, 1.076012>, <-67.502960, 31.367747, 1.173817>, <-63.775337, 35.405588, 1.124915>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.350121, 31.176867, 1.087771>, <-71.109959, 30.971411, 1.076012>, <-67.502960, 31.367747, 1.173817>, <-63.775337, 35.405588, 1.124915>, 
      <-74.332409, 34.206091, 1.059856>, <-71.092246, 34.000635, 1.037373>, <-67.485248, 34.533305, 1.117708>, <-63.757625, 38.502979, 1.077541>, 
      <-74.331156, 34.420423, 1.115686>, <-71.090993, 34.214967, 1.114652>, <-67.483995, 34.747637, 1.218413>, <-63.756371, 38.717312, 1.166532>, 
      <-74.313443, 37.449647, 1.087771>, <-71.073281, 37.244191, 1.076012>, <-67.339386, 37.852538, 1.231597>, <-63.611763, 41.847822, 1.153805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.313443, 37.449647, 1.087771>, <-71.073281, 37.244191, 1.076012>, <-67.339386, 37.852538, 1.231597>, <-63.611763, 41.847822, 1.153805>, 
      <-74.295731, 40.478872, 1.059856>, <-71.055568, 40.273415, 1.037373>, <-67.194778, 40.957438, 1.244781>, <-63.467155, 44.978332, 1.141077>, 
      <-74.294477, 40.693204, 1.115686>, <-71.054315, 40.487748, 1.114652>, <-67.193525, 41.171770, 1.345485>, <-63.465902, 45.192664, 1.230069>, 
      <-74.276765, 43.722428, 1.087771>, <-71.036602, 43.516972, 1.076012>, <-67.302708, 44.032930, 1.193408>, <-63.511637, 48.010960, 1.134710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.276765, 43.722428, 1.087771>, <-71.036602, 43.516972, 1.076012>, <-67.302708, 44.032930, 1.193408>, <-63.511637, 48.010960, 1.134710>, 
      <-74.259052, 46.751652, 1.059856>, <-71.018890, 46.546196, 1.037373>, <-67.411891, 46.894089, 1.041331>, <-63.557373, 50.829256, 1.039352>, 
      <-74.257799, 46.965984, 1.115686>, <-71.017637, 46.760528, 1.114652>, <-67.410638, 47.108421, 1.142036>, <-63.556119, 51.043588, 1.128344>, 
      <-74.240087, 49.995208, 1.087771>, <-70.999924, 49.789752, 1.076012>, <-67.392926, 50.215418, 1.097058>, <-63.601855, 54.365490, 1.086535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.240087, 49.995208, 1.087771>, <-70.999924, 49.789752, 1.076012>, <-67.392926, 50.215418, 1.097058>, <-63.601855, 54.365490, 1.086535>, 
      <-74.222374, 53.024433, 1.059856>, <-70.982212, 52.818976, 1.037373>, <-67.375213, 53.322415, 1.052079>, <-63.647590, 57.687392, 1.044726>, 
      <-74.221121, 53.238765, 1.115686>, <-70.980958, 53.033309, 1.114652>, <-67.373960, 53.536748, 1.152784>, <-63.646337, 57.901724, 1.133718>, 
      <-74.203408, 56.267989, 1.087771>, <-70.963246, 56.062533, 1.076012>, <-67.356248, 56.565972, 1.102432>, <-63.628597, 60.939553, 1.089222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.203408, 56.267989, 1.087771>, <-70.963246, 56.062533, 1.076012>, <-67.356248, 56.565972, 1.102432>, <-63.628597, 60.939553, 1.089222>, 
      <-74.185696, 59.297213, 1.059856>, <-70.945533, 59.091757, 1.037373>, <-67.338535, 59.595196, 1.052079>, <-63.610856, 63.977382, 1.044726>, 
      <-74.184443, 59.511545, 1.115686>, <-70.944280, 59.306089, 1.114652>, <-67.337282, 59.809528, 1.152784>, <-63.609495, 64.191714, 1.133718>, 
      <-74.166730, 62.540770, 1.087771>, <-70.926568, 62.335313, 1.076012>, <-67.319569, 62.760979, 1.097058>, <-63.591864, 66.983104, 1.086535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.166730, 62.540770, 1.087771>, <-70.926568, 62.335313, 1.076012>, <-67.319569, 62.760979, 1.097058>, <-63.591864, 66.983104, 1.086535>, 
      <-74.149018, 65.569994, 1.059856>, <-70.908855, 65.364537, 1.037373>, <-67.301857, 65.712430, 1.041331>, <-63.574234, 69.774493, 1.039352>, 
      <-74.147765, 65.784326, 1.115686>, <-70.907602, 65.578870, 1.114652>, <-67.300604, 65.926763, 1.142036>, <-63.572980, 69.988826, 1.128344>, 
      <-74.130052, 68.813550, 1.087771>, <-70.889890, 68.608094, 1.076012>, <-67.282891, 68.955987, 1.091684>, <-63.555268, 73.018050, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-74.130052, 68.813550, 1.087771>, <-70.889890, 68.608094, 1.076012>, <-67.282891, 68.955987, 1.091684>, <-63.555268, 73.018050, 1.083848>, 
      <-74.112340, 71.842774, 1.059856>, <-70.872177, 71.637318, 1.037373>, <-67.265179, 71.985211, 1.041331>, <-63.537555, 76.047274, 1.039352>, 
      <-74.111086, 72.057106, 1.115686>, <-70.870924, 71.851650, 1.114652>, <-67.263925, 72.199543, 1.142036>, <-63.536302, 76.261606, 1.128344>, 
      <-74.800000, 76.150000, 0.700000>, <-71.200000, 76.100000, 0.700000>, <-67.300000, 76.100000, 0.800000>, <-63.700000, 80.350000, 0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.950000, -109.650000, -1.000000>, <-61.200000, -105.400000, -1.000000>, <-57.700000, -105.400000, -1.000000>, <-54.100000, -105.450000, -1.000000>, 
      <-64.950000, -105.650000, 1.000000>, <-61.200000, -101.400000, 1.000000>, <-57.600000, -101.500000, 1.000000>, <-54.000000, -101.500000, 1.000000>, 
      <-64.950000, -105.450000, -1.000000>, <-61.200000, -101.200000, -1.000000>, <-57.600000, -101.200000, -1.000000>, <-54.000000, -101.250000, -1.000000>, 
      <-64.925000, -102.450000, 0.000000>, <-61.200000, -98.200000, 0.000000>, <-57.600000, -98.200000, 0.000000>, <-54.000000, -98.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.925000, -102.450000, 0.000000>, <-61.200000, -98.200000, 0.000000>, <-57.600000, -98.200000, 0.000000>, <-54.000000, -98.225000, 0.000000>, 
      <-64.900000, -99.450000, 1.000000>, <-61.200000, -95.200000, 1.000000>, <-57.600000, -95.200000, 1.000000>, <-54.000000, -95.200000, 1.000000>, 
      <-64.950000, -99.150000, -1.000000>, <-61.200000, -94.900000, -1.000000>, <-57.600000, -95.000000, -1.000000>, <-54.000000, -95.000000, -1.000000>, 
      <-64.900000, -96.150000, 0.000000>, <-61.150000, -91.900000, 0.000000>, <-57.550000, -91.950000, 0.000000>, <-53.975000, -91.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.900000, -96.150000, 0.000000>, <-61.150000, -91.900000, 0.000000>, <-57.550000, -91.950000, 0.000000>, <-53.975000, -91.950000, 0.000000>, 
      <-64.850000, -93.150000, 1.000000>, <-61.100000, -88.900000, 1.000000>, <-57.500000, -88.900000, 1.000000>, <-53.950000, -88.900000, 1.000000>, 
      <-64.900000, -92.950000, -1.000000>, <-61.200000, -88.700000, -1.000000>, <-57.600000, -88.700000, -1.000000>, <-54.000000, -88.700000, -1.000000>, 
      <-64.875000, -89.900000, 0.000000>, <-61.150000, -85.650000, 0.000000>, <-57.550000, -85.650000, 0.000000>, <-53.950000, -85.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.875000, -89.900000, 0.000000>, <-61.150000, -85.650000, 0.000000>, <-57.550000, -85.650000, 0.000000>, <-53.950000, -85.675000, 0.000000>, 
      <-64.850000, -86.850000, 1.000000>, <-61.100000, -82.600000, 1.000000>, <-57.500000, -82.600000, 1.000000>, <-53.900000, -82.650000, 1.000000>, 
      <-64.850000, -86.650000, -1.000000>, <-61.100000, -82.400000, -1.000000>, <-57.500000, -82.400000, -1.000000>, <-53.900000, -82.450000, -1.000000>, 
      <-64.825000, -83.600000, 0.000000>, <-61.100000, -79.350000, 0.000000>, <-57.500000, -79.400000, 0.000000>, <-53.900000, -79.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.825000, -83.600000, 0.000000>, <-61.100000, -79.350000, 0.000000>, <-57.500000, -79.400000, 0.000000>, <-53.900000, -79.425000, 0.000000>, 
      <-64.800000, -80.550000, 1.000000>, <-61.100000, -76.300000, 1.000000>, <-57.500000, -76.400000, 1.000000>, <-53.900000, -76.400000, 1.000000>, 
      <-64.800000, -80.350000, -1.000000>, <-61.100000, -76.100000, -1.000000>, <-57.500000, -76.100000, -1.000000>, <-53.900000, -76.150000, -1.000000>, 
      <-64.775000, -77.350000, 0.000000>, <-61.050000, -73.100000, 0.000000>, <-57.450000, -73.100000, 0.000000>, <-53.850000, -73.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.775000, -77.350000, 0.000000>, <-61.050000, -73.100000, 0.000000>, <-57.450000, -73.100000, 0.000000>, <-53.850000, -73.125000, 0.000000>, 
      <-64.750000, -74.350000, 1.000000>, <-61.000000, -70.100000, 1.000000>, <-57.400000, -70.100000, 1.000000>, <-53.800000, -70.100000, 1.000000>, 
      <-64.750000, -74.100000, -1.000000>, <-61.000000, -69.900000, -1.000000>, <-57.400000, -69.900000, -1.000000>, <-53.850000, -69.900000, -1.000000>, 
      <-64.750000, -71.075000, 0.000000>, <-61.000000, -66.850000, 0.000000>, <-57.400000, -66.850000, 0.000000>, <-53.825000, -66.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.750000, -71.075000, 0.000000>, <-61.000000, -66.850000, 0.000000>, <-57.400000, -66.850000, 0.000000>, <-53.825000, -66.875000, 0.000000>, 
      <-64.750000, -68.050000, 1.000000>, <-61.000000, -63.800000, 1.000000>, <-57.400000, -63.800000, 1.000000>, <-53.800000, -63.850000, 1.000000>, 
      <-64.750000, -67.850000, -1.000000>, <-61.000000, -63.600000, -1.000000>, <-57.400000, -63.600000, -1.000000>, <-53.800000, -63.600000, -1.000000>, 
      <-64.725000, -64.800000, 0.000000>, <-61.000000, -60.550000, 0.000000>, <-57.400000, -60.550000, 0.000000>, <-53.800000, -60.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.725000, -64.800000, 0.000000>, <-61.000000, -60.550000, 0.000000>, <-57.400000, -60.550000, 0.000000>, <-53.800000, -60.575000, 0.000000>, 
      <-64.700000, -61.750000, 1.000000>, <-61.000000, -57.500000, 1.000000>, <-57.400000, -57.500000, 1.000000>, <-53.800000, -57.550000, 1.000000>, 
      <-64.700000, -61.550000, -1.000000>, <-61.000000, -57.300000, -1.000000>, <-57.400000, -57.300000, -1.000000>, <-53.800000, -57.350000, -1.000000>, 
      <-64.675000, -58.525000, 0.000000>, <-60.950000, -54.300000, 0.000000>, <-57.350000, -54.300000, 0.000000>, <-53.750000, -54.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.675000, -58.525000, 0.000000>, <-60.950000, -54.300000, 0.000000>, <-57.350000, -54.300000, 0.000000>, <-53.750000, -54.325000, 0.000000>, 
      <-64.650000, -55.500000, 1.000000>, <-60.900000, -51.300000, 1.000000>, <-57.300000, -51.300000, 1.000000>, <-53.700000, -51.300000, 1.000000>, 
      <-64.650000, -55.250000, -1.000000>, <-60.900000, -51.000000, -1.000000>, <-57.300000, -51.100000, -1.000000>, <-53.750000, -51.100000, -1.000000>, 
      <-64.625000, -52.250000, 0.000000>, <-60.900000, -48.000000, 0.000000>, <-57.300000, -48.050000, 0.000000>, <-53.725000, -48.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.625000, -52.250000, 0.000000>, <-60.900000, -48.000000, 0.000000>, <-57.300000, -48.050000, 0.000000>, <-53.725000, -48.050000, 0.000000>, 
      <-64.600000, -49.250000, 1.000000>, <-60.900000, -45.000000, 1.000000>, <-57.300000, -45.000000, 1.000000>, <-53.700000, -45.000000, 1.000000>, 
      <-64.650000, -49.050000, -1.000000>, <-60.900000, -44.800000, -1.000000>, <-57.300000, -44.800000, -1.000000>, <-53.700000, -44.800000, -1.000000>, 
      <-64.600000, -46.000000, 0.000000>, <-60.850000, -41.750000, 0.000000>, <-57.300000, -41.750000, 0.000000>, <-53.700000, -41.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.600000, -46.000000, 0.000000>, <-60.850000, -41.750000, 0.000000>, <-57.300000, -41.750000, 0.000000>, <-53.700000, -41.775000, 0.000000>, 
      <-64.550000, -42.950000, 1.000000>, <-60.800000, -38.700000, 1.000000>, <-57.300000, -38.700000, 1.000000>, <-53.700000, -38.750000, 1.000000>, 
      <-64.600000, -42.750000, -1.000000>, <-60.900000, -38.500000, -1.000000>, <-57.300000, -38.500000, -1.000000>, <-53.700000, -38.550000, -1.000000>, 
      <-64.575000, -39.700000, 0.000000>, <-60.850000, -35.450000, 0.000000>, <-57.250000, -35.500000, 0.000000>, <-53.650000, -35.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.575000, -39.700000, 0.000000>, <-60.850000, -35.450000, 0.000000>, <-57.250000, -35.500000, 0.000000>, <-53.650000, -35.525000, 0.000000>, 
      <-64.550000, -36.650000, 1.000000>, <-60.800000, -32.400000, 1.000000>, <-57.200000, -32.500000, 1.000000>, <-53.600000, -32.500000, 1.000000>, 
      <-64.550000, -36.450000, -1.000000>, <-60.800000, -32.200000, -1.000000>, <-57.200000, -32.200000, -1.000000>, <-53.600000, -32.250000, -1.000000>, 
      <-64.525000, -33.450000, 0.000000>, <-60.800000, -29.200000, 0.000000>, <-57.200000, -29.200000, 0.000000>, <-53.600000, -29.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.525000, -33.450000, 0.000000>, <-60.800000, -29.200000, 0.000000>, <-57.200000, -29.200000, 0.000000>, <-53.600000, -29.225000, 0.000000>, 
      <-64.500000, -30.450000, 1.000000>, <-60.800000, -26.200000, 1.000000>, <-57.200000, -26.200000, 1.000000>, <-53.600000, -26.200000, 1.000000>, 
      <-64.550000, -30.150000, -1.000000>, <-60.800000, -25.900000, -1.000000>, <-57.200000, -26.000000, -1.000000>, <-53.600000, -26.000000, -1.000000>, 
      <-64.500000, -27.150000, 0.000000>, <-60.750000, -22.900000, 0.000000>, <-57.150000, -22.950000, 0.000000>, <-53.575000, -22.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.500000, -27.150000, 0.000000>, <-60.750000, -22.900000, 0.000000>, <-57.150000, -22.950000, 0.000000>, <-53.575000, -22.950000, 0.000000>, 
      <-64.450000, -24.150000, 1.000000>, <-60.700000, -19.900000, 1.000000>, <-57.100000, -19.900000, 1.000000>, <-53.550000, -19.900000, 1.000000>, 
      <-64.450000, -23.950000, -1.000000>, <-60.700000, -19.700000, -1.000000>, <-57.200000, -19.700000, -1.000000>, <-53.600000, -19.700000, -1.000000>, 
      <-64.188817, -20.903368, 0.020585>, <-60.177634, -16.656736, 0.041170>, <-56.631343, -16.667239, 0.041170>, <-53.035053, -16.677742, 0.041170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-64.188817, -20.903368, 0.020585>, <-60.177634, -16.656736, 0.041170>, <-56.631343, -16.667239, 0.041170>, <-53.035053, -16.677742, 0.041170>, 
      <-63.927634, -17.856736, 1.041170>, <-59.655268, -13.613472, 1.082340>, <-56.062687, -13.634478, 1.082340>, <-52.470105, -13.655485, 1.082340>, 
      <-63.927007, -17.649570, 0.058361>, <-59.654015, -13.399139, 1.116721>, <-56.061433, -13.420146, 1.116721>, <-52.468852, -13.441153, 1.116721>, 
      <-63.816424, -14.710612, 0.559108>, <-59.988721, -10.554365, 1.077047>, <-56.396139, -10.575372, 1.077047>, <-52.803558, -10.596378, 1.077047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.816424, -14.710612, 0.559108>, <-59.988721, -10.554365, 1.077047>, <-56.396139, -10.575372, 1.077047>, <-52.803558, -10.596378, 1.077047>, 
      <-63.705840, -11.771654, 1.059856>, <-60.323427, -7.709591, 1.037373>, <-56.730846, -7.730597, 1.037373>, <-53.138264, -7.751604, 1.037373>, 
      <-63.704587, -11.557321, 1.115686>, <-60.322174, -7.495258, 1.114652>, <-56.729592, -7.516265, 1.114652>, <-53.137011, -7.537271, 1.114652>, 
      <-63.859479, -8.684654, 1.077519>, <-60.297253, -4.594697, 1.077992>, <-56.704671, -4.615704, 1.077992>, <-53.112090, -4.636710, 1.077992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.859479, -8.684654, 1.077519>, <-60.297253, -4.594697, 1.077992>, <-56.704671, -4.615704, 1.077992>, <-53.112090, -4.636710, 1.077992>, 
      <-64.014372, -5.811986, 1.039352>, <-60.272332, -1.694136, 1.041331>, <-56.679750, -1.715143, 1.041331>, <-53.087169, -1.736149, 1.041331>, 
      <-64.013119, -5.597654, 1.128344>, <-60.271078, -1.479804, 1.142036>, <-56.678497, -1.500810, 1.142036>, <-53.085916, -1.521817, 1.142036>, 
      <-63.995406, -2.411873, 1.083848>, <-60.260574, 1.678083, 1.089704>, <-56.667993, 1.657077, 1.089704>, <-53.075412, 1.636070, 1.089704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.995406, -2.411873, 1.083848>, <-60.260574, 1.678083, 1.089704>, <-56.667993, 1.657077, 1.089704>, <-53.075412, 1.636070, 1.089704>, 
      <-63.977694, 0.773907, 1.039352>, <-60.250071, 4.835970, 1.037373>, <-56.657489, 4.814964, 1.037373>, <-53.064908, 4.793957, 1.037373>, 
      <-63.976441, 0.988240, 1.128344>, <-60.248817, 5.050303, 1.114652>, <-56.656236, 5.029296, 1.114652>, <-53.063655, 5.008290, 1.114652>, 
      <-63.958728, 4.017464, 1.083848>, <-60.231105, 8.079527, 1.076012>, <-56.286105, 8.242970, 1.098496>, <-52.693524, 8.221963, 1.098496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.958728, 4.017464, 1.083848>, <-60.231105, 8.079527, 1.076012>, <-56.286105, 8.242970, 1.098496>, <-52.693524, 8.221963, 1.098496>, 
      <-63.941016, 7.046688, 1.039352>, <-60.213392, 11.108751, 1.037373>, <-55.915974, 11.456644, 1.082340>, <-52.323392, 11.435637, 1.082340>, 
      <-63.939762, 7.261020, 1.128344>, <-60.212139, 11.323083, 1.114652>, <-55.914720, 11.670976, 1.116721>, <-52.322139, 11.649970, 1.116721>, 
      <-63.922050, 10.246299, 1.083848>, <-60.194427, 14.352307, 1.076012>, <-55.897008, 14.700200, 1.099530>, <-52.555893, 14.682341, 1.078946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.922050, 10.246299, 1.083848>, <-60.194427, 14.352307, 1.076012>, <-55.897008, 14.700200, 1.099530>, <-52.555893, 14.682341, 1.078946>, 
      <-63.904337, 13.231579, 1.039352>, <-60.176714, 17.381531, 1.037373>, <-55.879295, 17.729424, 1.082340>, <-52.789648, 17.714712, 1.041170>, 
      <-63.903084, 13.445911, 1.128344>, <-60.175461, 17.595864, 1.114652>, <-55.878042, 17.943757, 1.116721>, <-52.839021, 17.921878, 0.058361>, 
      <-63.885372, 16.475135, 1.083848>, <-60.157748, 20.625088, 1.076012>, <-55.860330, 20.972981, 1.099530>, <-52.805165, 20.961490, 0.549765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.885372, 16.475135, 1.083848>, <-60.157748, 20.625088, 1.076012>, <-55.860330, 20.972981, 1.099530>, <-52.805165, 20.961490, 0.549765>, 
      <-63.867659, 19.504359, 1.039352>, <-60.140036, 23.654312, 1.037373>, <-55.842617, 24.002205, 1.082340>, <-52.771309, 24.001102, 1.041170>, 
      <-63.866406, 19.718691, 1.128344>, <-60.138783, 23.868644, 1.114652>, <-55.841364, 24.216537, 1.116721>, <-52.770682, 24.208269, 0.058361>, 
      <-63.848693, 22.866626, 1.104307>, <-60.121070, 26.897868, 1.076012>, <-56.320682, 27.258269, 1.058361>, <-53.010341, 27.229134, 0.529180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.848693, 22.866626, 1.104307>, <-60.121070, 26.897868, 1.076012>, <-56.320682, 27.258269, 1.058361>, <-53.010341, 27.229134, 0.529180>, 
      <-63.830981, 26.014561, 1.080271>, <-60.103358, 29.927093, 1.037373>, <-56.800000, 30.300000, 1.000000>, <-53.250000, 30.250000, 1.000000>, 
      <-63.829728, 26.228893, 1.169263>, <-60.102104, 30.141425, 1.114652>, <-56.900000, 30.500000, -1.000000>, <-53.300000, 30.450000, -1.000000>, 
      <-63.812015, 29.161379, 1.126280>, <-60.084392, 33.170649, 1.076012>, <-56.850000, 33.500000, 0.000000>, <-53.250000, 33.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.812015, 29.161379, 1.126280>, <-60.084392, 33.170649, 1.076012>, <-56.850000, 33.500000, 0.000000>, <-53.250000, 33.475000, 0.000000>, 
      <-63.794303, 32.093865, 1.083297>, <-60.066679, 36.199873, 1.037373>, <-56.800000, 36.500000, 1.000000>, <-53.200000, 36.500000, 1.000000>, 
      <-63.793050, 32.308197, 1.172289>, <-60.065426, 36.414205, 1.114652>, <-56.800000, 36.800000, -1.000000>, <-53.200000, 36.750000, -1.000000>, 
      <-63.775337, 35.405588, 1.124915>, <-60.047714, 39.443429, 1.076012>, <-56.800000, 39.800000, 0.000000>, <-53.200000, 39.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.775337, 35.405588, 1.124915>, <-60.047714, 39.443429, 1.076012>, <-56.800000, 39.800000, 0.000000>, <-53.200000, 39.775000, 0.000000>, 
      <-63.757625, 38.502979, 1.077541>, <-60.030001, 42.472654, 1.037373>, <-56.800000, 42.800000, 1.000000>, <-53.200000, 42.800000, 1.000000>, 
      <-63.756371, 38.717312, 1.166532>, <-60.028748, 42.686986, 1.114652>, <-56.800000, 43.000000, -1.000000>, <-53.200000, 43.000000, -1.000000>, 
      <-63.611763, 41.847822, 1.153805>, <-59.884140, 45.843106, 1.076012>, <-56.650000, 46.150000, 0.000000>, <-53.125000, 46.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.611763, 41.847822, 1.153805>, <-59.884140, 45.843106, 1.076012>, <-56.650000, 46.150000, 0.000000>, <-53.125000, 46.100000, 0.000000>, 
      <-63.467155, 44.978332, 1.141077>, <-59.739532, 48.999225, 1.037373>, <-56.500000, 49.300000, 1.000000>, <-53.050000, 49.200000, 1.000000>, 
      <-63.465902, 45.192664, 1.230069>, <-59.738279, 49.213558, 1.114652>, <-56.500000, 49.600000, -1.000000>, <-53.050000, 49.450000, -1.000000>, 
      <-63.511637, 48.010960, 1.134710>, <-59.720566, 51.988991, 1.076012>, <-56.450000, 52.350000, 0.000000>, <-52.950000, 52.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.511637, 48.010960, 1.134710>, <-59.720566, 51.988991, 1.076012>, <-56.450000, 52.350000, 0.000000>, <-52.950000, 52.275000, 0.000000>, 
      <-63.557373, 50.829256, 1.039352>, <-59.702854, 54.764423, 1.037373>, <-56.400000, 55.100000, 1.000000>, <-52.850000, 55.100000, 1.000000>, 
      <-63.556119, 51.043588, 1.128344>, <-59.701600, 54.978756, 1.114652>, <-56.500000, 55.300000, -1.000000>, <-52.900000, 55.300000, -1.000000>, 
      <-63.601855, 54.365490, 1.086535>, <-59.810783, 58.515562, 1.076012>, <-56.600000, 58.850000, 0.000000>, <-53.000000, 58.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.601855, 54.365490, 1.086535>, <-59.810783, 58.515562, 1.076012>, <-56.600000, 58.850000, 0.000000>, <-53.000000, 58.650000, 0.000000>, 
      <-63.647590, 57.687392, 1.044726>, <-59.919967, 62.052369, 1.037373>, <-56.700000, 62.400000, 1.000000>, <-53.100000, 62.000000, 1.000000>, 
      <-63.646337, 57.901724, 1.133718>, <-59.918713, 62.266701, 1.114652>, <-56.700000, 62.600000, -1.000000>, <-53.100000, 62.200000, -1.000000>, 
      <-63.628597, 60.939553, 1.089222>, <-59.900946, 65.313135, 1.076012>, <-56.650000, 65.650000, 0.000000>, <-53.050000, 65.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.628597, 60.939553, 1.089222>, <-59.900946, 65.313135, 1.076012>, <-56.650000, 65.650000, 0.000000>, <-53.050000, 65.450000, 0.000000>, 
      <-63.610856, 63.977382, 1.044726>, <-59.883178, 68.359569, 1.037373>, <-56.600000, 68.700000, 1.000000>, <-53.000000, 68.700000, 1.000000>, 
      <-63.609495, 64.191714, 1.133718>, <-59.881709, 68.573900, 1.114652>, <-56.600000, 68.900000, -1.000000>, <-53.050000, 68.900000, -1.000000>, 
      <-63.591864, 66.983104, 1.086535>, <-59.864159, 71.205228, 1.076012>, <-56.600000, 71.550000, 0.000000>, <-53.025000, 71.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.591864, 66.983104, 1.086535>, <-59.864159, 71.205228, 1.076012>, <-56.600000, 71.550000, 0.000000>, <-53.025000, 71.525000, 0.000000>, 
      <-63.574234, 69.774493, 1.039352>, <-59.846610, 73.836556, 1.037373>, <-56.600000, 74.200000, 1.000000>, <-53.000000, 74.150000, 1.000000>, 
      <-63.572980, 69.988826, 1.128344>, <-59.845357, 74.050888, 1.114652>, <-56.600000, 74.400000, -1.000000>, <-53.000000, 74.400000, -1.000000>, 
      <-63.555268, 73.018050, 1.083848>, <-59.827645, 77.080113, 1.076012>, <-56.600000, 77.450000, 0.000000>, <-53.050000, 77.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-63.555268, 73.018050, 1.083848>, <-59.827645, 77.080113, 1.076012>, <-56.600000, 77.450000, 0.000000>, <-53.050000, 77.175000, 0.000000>, 
      <-63.537555, 76.047274, 1.039352>, <-59.809932, 80.109337, 1.037373>, <-56.600000, 80.500000, 1.000000>, <-53.100000, 79.950000, 1.000000>, 
      <-63.536302, 76.261606, 1.128344>, <-59.808679, 80.323669, 1.114652>, <-56.600000, 80.700000, -1.000000>, <-53.100000, 80.150000, -1.000000>, 
      <-63.700000, 80.350000, 0.750000>, <-60.100000, 84.600000, 0.700000>, <-56.500000, 84.600000, 0.700000>, <-52.950000, 84.550000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-54.100000, -105.450000, -1.000000>, <-50.500000, -105.500000, -1.000000>, <-46.900000, -105.500000, -1.000000>, <-43.050000, -108.250000, -1.000000>, 
      <-54.000000, -101.500000, 1.000000>, <-50.400000, -101.500000, 1.000000>, <-46.800000, -101.500000, 1.000000>, <-43.000000, -104.250000, 1.000000>, 
      <-54.000000, -101.250000, -1.000000>, <-50.400000, -101.300000, -1.000000>, <-46.900000, -101.300000, -1.000000>, <-43.050000, -104.050000, -1.000000>, 
      <-54.000000, -98.225000, 0.000000>, <-50.400000, -98.250000, 0.000000>, <-46.850000, -98.250000, 0.000000>, <-43.025000, -101.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-54.000000, -98.225000, 0.000000>, <-50.400000, -98.250000, 0.000000>, <-46.850000, -98.250000, 0.000000>, <-43.025000, -101.025000, 0.000000>, 
      <-54.000000, -95.200000, 1.000000>, <-50.400000, -95.200000, 1.000000>, <-46.800000, -95.200000, 1.000000>, <-43.000000, -98.000000, 1.000000>, 
      <-54.000000, -95.000000, -1.000000>, <-50.400000, -95.000000, -1.000000>, <-46.800000, -95.000000, -1.000000>, <-43.000000, -97.750000, -1.000000>, 
      <-53.975000, -91.950000, 0.000000>, <-50.400000, -91.950000, 0.000000>, <-46.800000, -92.000000, 0.000000>, <-42.975000, -94.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.975000, -91.950000, 0.000000>, <-50.400000, -91.950000, 0.000000>, <-46.800000, -92.000000, 0.000000>, <-42.975000, -94.750000, 0.000000>, 
      <-53.950000, -88.900000, 1.000000>, <-50.400000, -88.900000, 1.000000>, <-46.800000, -89.000000, 1.000000>, <-42.950000, -91.750000, 1.000000>, 
      <-54.000000, -88.700000, -1.000000>, <-50.400000, -88.700000, -1.000000>, <-46.800000, -88.800000, -1.000000>, <-43.000000, -91.550000, -1.000000>, 
      <-53.950000, -85.675000, 0.000000>, <-50.350000, -85.700000, 0.000000>, <-46.750000, -85.750000, 0.000000>, <-42.950000, -88.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.950000, -85.675000, 0.000000>, <-50.350000, -85.700000, 0.000000>, <-46.750000, -85.750000, 0.000000>, <-42.950000, -88.500000, 0.000000>, 
      <-53.900000, -82.650000, 1.000000>, <-50.300000, -82.700000, 1.000000>, <-46.700000, -82.700000, 1.000000>, <-42.900000, -85.450000, 1.000000>, 
      <-53.900000, -82.450000, -1.000000>, <-50.300000, -82.500000, -1.000000>, <-46.700000, -82.500000, -1.000000>, <-42.900000, -85.250000, -1.000000>, 
      <-53.900000, -79.425000, 0.000000>, <-50.300000, -79.450000, 0.000000>, <-46.700000, -79.450000, 0.000000>, <-42.900000, -82.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.900000, -79.425000, 0.000000>, <-50.300000, -79.450000, 0.000000>, <-46.700000, -79.450000, 0.000000>, <-42.900000, -82.200000, 0.000000>, 
      <-53.900000, -76.400000, 1.000000>, <-50.300000, -76.400000, 1.000000>, <-46.700000, -76.400000, 1.000000>, <-42.900000, -79.150000, 1.000000>, 
      <-53.900000, -76.150000, -1.000000>, <-50.300000, -76.200000, -1.000000>, <-46.700000, -76.200000, -1.000000>, <-42.900000, -78.950000, -1.000000>, 
      <-53.850000, -73.125000, 0.000000>, <-50.250000, -73.150000, 0.000000>, <-46.700000, -73.200000, 0.000000>, <-42.875000, -75.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.850000, -73.125000, 0.000000>, <-50.250000, -73.150000, 0.000000>, <-46.700000, -73.200000, 0.000000>, <-42.875000, -75.950000, 0.000000>, 
      <-53.800000, -70.100000, 1.000000>, <-50.200000, -70.100000, 1.000000>, <-46.700000, -70.200000, 1.000000>, <-42.850000, -72.950000, 1.000000>, 
      <-53.850000, -69.900000, -1.000000>, <-50.300000, -69.900000, -1.000000>, <-46.700000, -69.900000, -1.000000>, <-42.850000, -72.700000, -1.000000>, 
      <-53.825000, -66.875000, 0.000000>, <-50.250000, -66.900000, 0.000000>, <-46.650000, -66.900000, 0.000000>, <-42.825000, -69.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.825000, -66.875000, 0.000000>, <-50.250000, -66.900000, 0.000000>, <-46.650000, -66.900000, 0.000000>, <-42.825000, -69.675000, 0.000000>, 
      <-53.800000, -63.850000, 1.000000>, <-50.200000, -63.900000, 1.000000>, <-46.600000, -63.900000, 1.000000>, <-42.800000, -66.650000, 1.000000>, 
      <-53.800000, -63.600000, -1.000000>, <-50.200000, -63.600000, -1.000000>, <-46.600000, -63.700000, -1.000000>, <-42.800000, -66.450000, -1.000000>, 
      <-53.800000, -60.575000, 0.000000>, <-50.200000, -60.600000, 0.000000>, <-46.600000, -60.650000, 0.000000>, <-42.800000, -63.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.800000, -60.575000, 0.000000>, <-50.200000, -60.600000, 0.000000>, <-46.600000, -60.650000, 0.000000>, <-42.800000, -63.400000, 0.000000>, 
      <-53.800000, -57.550000, 1.000000>, <-50.200000, -57.600000, 1.000000>, <-46.600000, -57.600000, 1.000000>, <-42.800000, -60.350000, 1.000000>, 
      <-53.800000, -57.350000, -1.000000>, <-50.200000, -57.400000, -1.000000>, <-46.600000, -57.400000, -1.000000>, <-42.800000, -60.150000, -1.000000>, 
      <-53.750000, -54.325000, 0.000000>, <-50.150000, -54.350000, 0.000000>, <-46.550000, -54.350000, 0.000000>, <-42.750000, -57.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.750000, -54.325000, 0.000000>, <-50.150000, -54.350000, 0.000000>, <-46.550000, -54.350000, 0.000000>, <-42.750000, -57.125000, 0.000000>, 
      <-53.700000, -51.300000, 1.000000>, <-50.100000, -51.300000, 1.000000>, <-46.500000, -51.300000, 1.000000>, <-42.700000, -54.100000, 1.000000>, 
      <-53.750000, -51.100000, -1.000000>, <-50.200000, -51.100000, -1.000000>, <-46.600000, -51.100000, -1.000000>, <-42.750000, -53.850000, -1.000000>, 
      <-53.725000, -48.050000, 0.000000>, <-50.150000, -48.050000, 0.000000>, <-46.550000, -48.100000, 0.000000>, <-42.725000, -50.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.725000, -48.050000, 0.000000>, <-50.150000, -48.050000, 0.000000>, <-46.550000, -48.100000, 0.000000>, <-42.725000, -50.850000, 0.000000>, 
      <-53.700000, -45.000000, 1.000000>, <-50.100000, -45.000000, 1.000000>, <-46.500000, -45.100000, 1.000000>, <-42.700000, -47.850000, 1.000000>, 
      <-53.700000, -44.800000, -1.000000>, <-50.100000, -44.800000, -1.000000>, <-46.500000, -44.800000, -1.000000>, <-42.700000, -47.600000, -1.000000>, 
      <-53.700000, -41.775000, 0.000000>, <-50.100000, -41.800000, 0.000000>, <-46.500000, -41.800000, 0.000000>, <-42.675000, -44.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.700000, -41.775000, 0.000000>, <-50.100000, -41.800000, 0.000000>, <-46.500000, -41.800000, 0.000000>, <-42.675000, -44.575000, 0.000000>, 
      <-53.700000, -38.750000, 1.000000>, <-50.100000, -38.800000, 1.000000>, <-46.500000, -38.800000, 1.000000>, <-42.650000, -41.550000, 1.000000>, 
      <-53.700000, -38.550000, -1.000000>, <-50.100000, -38.600000, -1.000000>, <-46.500000, -38.600000, -1.000000>, <-42.700000, -41.350000, -1.000000>, 
      <-53.650000, -35.525000, 0.000000>, <-50.050000, -35.550000, 0.000000>, <-46.450000, -35.550000, 0.000000>, <-42.650000, -38.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.650000, -35.525000, 0.000000>, <-50.050000, -35.550000, 0.000000>, <-46.450000, -35.550000, 0.000000>, <-42.650000, -38.300000, 0.000000>, 
      <-53.600000, -32.500000, 1.000000>, <-50.000000, -32.500000, 1.000000>, <-46.400000, -32.500000, 1.000000>, <-42.600000, -35.250000, 1.000000>, 
      <-53.600000, -32.250000, -1.000000>, <-50.000000, -32.300000, -1.000000>, <-46.500000, -32.300000, -1.000000>, <-42.650000, -35.050000, -1.000000>, 
      <-53.600000, -29.225000, 0.000000>, <-50.000000, -29.250000, 0.000000>, <-46.450000, -29.250000, 0.000000>, <-42.625000, -32.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.600000, -29.225000, 0.000000>, <-50.000000, -29.250000, 0.000000>, <-46.450000, -29.250000, 0.000000>, <-42.625000, -32.025000, 0.000000>, 
      <-53.600000, -26.200000, 1.000000>, <-50.000000, -26.200000, 1.000000>, <-46.400000, -26.200000, 1.000000>, <-42.600000, -29.000000, 1.000000>, 
      <-53.600000, -26.000000, -1.000000>, <-50.000000, -26.000000, -1.000000>, <-46.400000, -26.000000, -1.000000>, <-42.600000, -28.750000, -1.000000>, 
      <-53.575000, -22.950000, 0.000000>, <-50.000000, -22.950000, 0.000000>, <-46.400000, -23.000000, 0.000000>, <-42.575000, -25.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.575000, -22.950000, 0.000000>, <-50.000000, -22.950000, 0.000000>, <-46.400000, -23.000000, 0.000000>, <-42.575000, -25.750000, 0.000000>, 
      <-53.550000, -19.900000, 1.000000>, <-50.000000, -19.900000, 1.000000>, <-46.400000, -20.000000, 1.000000>, <-42.550000, -22.750000, 1.000000>, 
      <-53.600000, -19.700000, -1.000000>, <-50.000000, -19.700000, -1.000000>, <-46.400000, -19.800000, -1.000000>, <-42.550000, -22.550000, -1.000000>, 
      <-53.035053, -16.677742, 0.041170>, <-49.438762, -16.688246, 0.041170>, <-45.842471, -16.748749, 0.041170>, <-42.088553, -19.503450, 0.041170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.035053, -16.677742, 0.041170>, <-49.438762, -16.688246, 0.041170>, <-45.842471, -16.748749, 0.041170>, <-42.088553, -19.503450, 0.041170>, 
      <-52.470105, -13.655485, 1.082340>, <-48.877524, -13.676491, 1.082340>, <-45.284943, -13.697498, 1.082340>, <-41.627106, -16.456899, 1.082340>, 
      <-52.468852, -13.441153, 1.116721>, <-48.876271, -13.462159, 1.116721>, <-45.283690, -13.483166, 1.116721>, <-41.625853, -16.242567, 1.116721>, 
      <-52.803558, -10.596378, 1.077047>, <-49.210977, -10.617385, 1.077047>, <-45.618396, -10.638391, 1.077047>, <-41.881646, -13.397793, 1.077047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-52.803558, -10.596378, 1.077047>, <-49.210977, -10.617385, 1.077047>, <-45.618396, -10.638391, 1.077047>, <-41.881646, -13.397793, 1.077047>, 
      <-53.138264, -7.751604, 1.037373>, <-49.545683, -7.772610, 1.037373>, <-45.953102, -7.793617, 1.037373>, <-42.137439, -10.553018, 1.037373>, 
      <-53.137011, -7.537271, 1.114652>, <-49.544430, -7.558278, 1.114652>, <-45.951849, -7.579285, 1.114652>, <-42.136186, -10.338686, 1.114652>, 
      <-53.112090, -4.636710, 1.077992>, <-49.519509, -4.657717, 1.077992>, <-45.926928, -4.678723, 1.077992>, <-42.111265, -7.438125, 1.077992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.112090, -4.636710, 1.077992>, <-49.519509, -4.657717, 1.077992>, <-45.926928, -4.678723, 1.077992>, <-42.111265, -7.438125, 1.077992>, 
      <-53.087169, -1.736149, 1.041331>, <-49.494588, -1.757156, 1.041331>, <-45.902007, -1.778162, 1.041331>, <-42.086344, -4.537564, 1.041331>, 
      <-53.085916, -1.521817, 1.142036>, <-49.493335, -1.542824, 1.142036>, <-45.900753, -1.563830, 1.142036>, <-42.085091, -4.323232, 1.142036>, 
      <-53.075412, 1.636070, 1.089704>, <-49.482831, 1.615064, 1.089704>, <-45.890249, 1.594057, 1.089704>, <-42.074587, -1.165344, 1.089704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.075412, 1.636070, 1.089704>, <-49.482831, 1.615064, 1.089704>, <-45.890249, 1.594057, 1.089704>, <-42.074587, -1.165344, 1.089704>, 
      <-53.064908, 4.793957, 1.037373>, <-49.472327, 4.772951, 1.037373>, <-45.879746, 4.751944, 1.037373>, <-42.064083, 1.992543, 1.037373>, 
      <-53.063655, 5.008290, 1.114652>, <-49.471074, 4.987283, 1.114652>, <-45.878492, 4.966277, 1.114652>, <-42.062830, 2.206875, 1.114652>, 
      <-52.693524, 8.221963, 1.098496>, <-49.100942, 8.200957, 1.098496>, <-45.508361, 8.179950, 1.098496>, <-41.771612, 5.420549, 1.098496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-52.693524, 8.221963, 1.098496>, <-49.100942, 8.200957, 1.098496>, <-45.508361, 8.179950, 1.098496>, <-41.771612, 5.420549, 1.098496>, 
      <-52.323392, 11.435637, 1.082340>, <-48.730811, 11.414631, 1.082340>, <-45.138230, 11.393624, 1.082340>, <-41.480393, 8.634223, 1.082340>, 
      <-52.322139, 11.649970, 1.116721>, <-48.729558, 11.628963, 1.116721>, <-45.136977, 11.607956, 1.116721>, <-41.479140, 8.848555, 1.116721>, 
      <-52.555893, 14.682341, 1.078946>, <-49.214779, 14.664482, 1.058361>, <-45.618488, 14.653978, 1.058361>, <-41.889570, 11.874278, 1.058361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-52.555893, 14.682341, 1.078946>, <-49.214779, 14.664482, 1.058361>, <-45.618488, 14.653978, 1.058361>, <-41.889570, 11.874278, 1.058361>, 
      <-52.789648, 17.714712, 1.041170>, <-49.700000, 17.700000, 1.000000>, <-46.100000, 17.700000, 1.000000>, <-42.300000, 14.900000, 1.000000>, 
      <-52.839021, 17.921878, 0.058361>, <-49.800000, 17.900000, -1.000000>, <-46.200000, 17.900000, -1.000000>, <-42.350000, 15.150000, -1.000000>, 
      <-52.805165, 20.961490, 0.549765>, <-49.750000, 20.950000, 0.000000>, <-46.150000, 20.900000, 0.000000>, <-42.325000, 18.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-52.805165, 20.961490, 0.549765>, <-49.750000, 20.950000, 0.000000>, <-46.150000, 20.900000, 0.000000>, <-42.325000, 18.150000, 0.000000>, 
      <-52.771309, 24.001102, 1.041170>, <-49.700000, 24.000000, 1.000000>, <-46.100000, 23.900000, 1.000000>, <-42.300000, 21.150000, 1.000000>, 
      <-52.770682, 24.208269, 0.058361>, <-49.700000, 24.200000, -1.000000>, <-46.100000, 24.200000, -1.000000>, <-42.300000, 21.400000, -1.000000>, 
      <-53.010341, 27.229134, 0.529180>, <-49.700000, 27.200000, 0.000000>, <-46.100000, 27.200000, 0.000000>, <-42.275000, 24.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.010341, 27.229134, 0.529180>, <-49.700000, 27.200000, 0.000000>, <-46.100000, 27.200000, 0.000000>, <-42.275000, 24.425000, 0.000000>, 
      <-53.250000, 30.250000, 1.000000>, <-49.700000, 30.200000, 1.000000>, <-46.100000, 30.200000, 1.000000>, <-42.250000, 27.450000, 1.000000>, 
      <-53.300000, 30.450000, -1.000000>, <-49.700000, 30.400000, -1.000000>, <-46.100000, 30.400000, -1.000000>, <-42.300000, 27.650000, -1.000000>, 
      <-53.250000, 33.475000, 0.000000>, <-49.650000, 33.450000, 0.000000>, <-46.050000, 33.450000, 0.000000>, <-42.250000, 30.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.250000, 33.475000, 0.000000>, <-49.650000, 33.450000, 0.000000>, <-46.050000, 33.450000, 0.000000>, <-42.250000, 30.700000, 0.000000>, 
      <-53.200000, 36.500000, 1.000000>, <-49.600000, 36.500000, 1.000000>, <-46.000000, 36.500000, 1.000000>, <-42.200000, 33.750000, 1.000000>, 
      <-53.200000, 36.750000, -1.000000>, <-49.600000, 36.700000, -1.000000>, <-46.000000, 36.700000, -1.000000>, <-42.200000, 33.950000, -1.000000>, 
      <-53.200000, 39.775000, 0.000000>, <-49.600000, 39.750000, 0.000000>, <-46.000000, 39.750000, 0.000000>, <-42.200000, 36.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.200000, 39.775000, 0.000000>, <-49.600000, 39.750000, 0.000000>, <-46.000000, 39.750000, 0.000000>, <-42.200000, 36.975000, 0.000000>, 
      <-53.200000, 42.800000, 1.000000>, <-49.600000, 42.800000, 1.000000>, <-46.000000, 42.800000, 1.000000>, <-42.200000, 40.000000, 1.000000>, 
      <-53.200000, 43.000000, -1.000000>, <-49.600000, 43.000000, -1.000000>, <-46.000000, 43.000000, -1.000000>, <-42.200000, 40.250000, -1.000000>, 
      <-53.125000, 46.100000, 0.000000>, <-49.600000, 46.050000, 0.000000>, <-46.000000, 46.000000, 0.000000>, <-42.175000, 43.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.125000, 46.100000, 0.000000>, <-49.600000, 46.050000, 0.000000>, <-46.000000, 46.000000, 0.000000>, <-42.175000, 43.250000, 0.000000>, 
      <-53.050000, 49.200000, 1.000000>, <-49.600000, 49.100000, 1.000000>, <-46.000000, 49.000000, 1.000000>, <-42.150000, 46.250000, 1.000000>, 
      <-53.050000, 49.450000, -1.000000>, <-49.600000, 49.300000, -1.000000>, <-46.000000, 49.200000, -1.000000>, <-42.150000, 46.450000, -1.000000>, 
      <-52.950000, 52.275000, 0.000000>, <-49.450000, 52.200000, 0.000000>, <-46.100000, 51.500000, 0.000000>, <-42.250000, 48.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-52.950000, 52.275000, 0.000000>, <-49.450000, 52.200000, 0.000000>, <-46.100000, 51.500000, 0.000000>, <-42.250000, 48.750000, 0.000000>, 
      <-52.850000, 55.100000, 1.000000>, <-49.300000, 55.100000, 1.000000>, <-46.200000, 53.800000, 1.000000>, <-42.350000, 51.050000, 1.000000>, 
      <-52.900000, 55.300000, -1.000000>, <-49.300000, 55.300000, -1.000000>, <-46.200000, 54.000000, -1.000000>, <-42.400000, 51.250000, -1.000000>, 
      <-53.000000, 58.650000, 0.000000>, <-49.400000, 58.450000, 0.000000>, <-46.050000, 57.800000, 0.000000>, <-42.250000, 55.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.000000, 58.650000, 0.000000>, <-49.400000, 58.450000, 0.000000>, <-46.050000, 57.800000, 0.000000>, <-42.250000, 55.050000, 0.000000>, 
      <-53.100000, 62.000000, 1.000000>, <-49.500000, 61.600000, 1.000000>, <-45.900000, 61.600000, 1.000000>, <-42.100000, 58.850000, 1.000000>, 
      <-53.100000, 62.200000, -1.000000>, <-49.500000, 61.800000, -1.000000>, <-45.900000, 61.800000, -1.000000>, <-42.100000, 59.050000, -1.000000>, 
      <-53.050000, 65.450000, 0.000000>, <-49.450000, 65.250000, 0.000000>, <-45.850000, 65.200000, 0.000000>, <-42.050000, 62.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.050000, 65.450000, 0.000000>, <-49.450000, 65.250000, 0.000000>, <-45.850000, 65.200000, 0.000000>, <-42.050000, 62.450000, 0.000000>, 
      <-53.000000, 68.700000, 1.000000>, <-49.400000, 68.700000, 1.000000>, <-45.800000, 68.600000, 1.000000>, <-42.000000, 65.850000, 1.000000>, 
      <-53.050000, 68.900000, -1.000000>, <-49.500000, 68.900000, -1.000000>, <-45.900000, 68.800000, -1.000000>, <-42.050000, 66.050000, -1.000000>, 
      <-53.025000, 71.525000, 0.000000>, <-49.450000, 71.500000, 0.000000>, <-45.850000, 71.450000, 0.000000>, <-42.025000, 68.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.025000, 71.525000, 0.000000>, <-49.450000, 71.500000, 0.000000>, <-45.850000, 71.450000, 0.000000>, <-42.025000, 68.700000, 0.000000>, 
      <-53.000000, 74.150000, 1.000000>, <-49.400000, 74.100000, 1.000000>, <-45.800000, 74.100000, 1.000000>, <-42.000000, 71.350000, 1.000000>, 
      <-53.000000, 74.400000, -1.000000>, <-49.400000, 74.400000, -1.000000>, <-45.800000, 74.300000, -1.000000>, <-42.000000, 71.550000, -1.000000>, 
      <-53.050000, 77.175000, 0.000000>, <-49.500000, 76.900000, 0.000000>, <-45.900000, 76.850000, 0.000000>, <-42.100000, 74.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-53.050000, 77.175000, 0.000000>, <-49.500000, 76.900000, 0.000000>, <-45.900000, 76.850000, 0.000000>, <-42.100000, 74.100000, 0.000000>, 
      <-53.100000, 79.950000, 1.000000>, <-49.600000, 79.400000, 1.000000>, <-46.000000, 79.400000, 1.000000>, <-42.200000, 76.650000, 1.000000>, 
      <-53.100000, 80.150000, -1.000000>, <-49.600000, 79.600000, -1.000000>, <-46.000000, 79.600000, -1.000000>, <-42.200000, 76.850000, -1.000000>, 
      <-52.950000, 84.550000, 0.700000>, <-49.400000, 84.500000, 0.700000>, <-45.800000, 84.500000, 0.700000>, <-41.950000, 81.750000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-43.050000, -108.250000, -1.000000>, <-39.200000, -111.000000, -1.000000>, <-35.700000, -111.000000, -1.000000>, <-32.850000, -115.200000, -1.000000>, 
      <-43.000000, -104.250000, 1.000000>, <-39.200000, -107.000000, 1.000000>, <-35.600000, -107.100000, 1.000000>, <-32.800000, -111.300000, 1.000000>, 
      <-43.050000, -104.050000, -1.000000>, <-39.200000, -106.800000, -1.000000>, <-35.600000, -106.800000, -1.000000>, <-32.800000, -111.050000, -1.000000>, 
      <-43.025000, -101.025000, 0.000000>, <-39.200000, -103.800000, 0.000000>, <-35.600000, -103.800000, 0.000000>, <-32.775000, -108.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-43.025000, -101.025000, 0.000000>, <-39.200000, -103.800000, 0.000000>, <-35.600000, -103.800000, 0.000000>, <-32.775000, -108.025000, 0.000000>, 
      <-43.000000, -98.000000, 1.000000>, <-39.200000, -100.800000, 1.000000>, <-35.600000, -100.800000, 1.000000>, <-32.750000, -105.000000, 1.000000>, 
      <-43.000000, -97.750000, -1.000000>, <-39.200000, -100.500000, -1.000000>, <-35.600000, -100.600000, -1.000000>, <-32.750000, -104.800000, -1.000000>, 
      <-42.975000, -94.750000, 0.000000>, <-39.150000, -97.500000, 0.000000>, <-35.550000, -97.550000, 0.000000>, <-32.725000, -101.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.975000, -94.750000, 0.000000>, <-39.150000, -97.500000, 0.000000>, <-35.550000, -97.550000, 0.000000>, <-32.725000, -101.750000, 0.000000>, 
      <-42.950000, -91.750000, 1.000000>, <-39.100000, -94.500000, 1.000000>, <-35.500000, -94.500000, 1.000000>, <-32.700000, -98.700000, 1.000000>, 
      <-43.000000, -91.550000, -1.000000>, <-39.200000, -94.300000, -1.000000>, <-35.600000, -94.300000, -1.000000>, <-32.750000, -98.500000, -1.000000>, 
      <-42.950000, -88.500000, 0.000000>, <-39.150000, -91.250000, 0.000000>, <-35.550000, -91.250000, 0.000000>, <-32.700000, -95.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.950000, -88.500000, 0.000000>, <-39.150000, -91.250000, 0.000000>, <-35.550000, -91.250000, 0.000000>, <-32.700000, -95.475000, 0.000000>, 
      <-42.900000, -85.450000, 1.000000>, <-39.100000, -88.200000, 1.000000>, <-35.500000, -88.200000, 1.000000>, <-32.650000, -92.450000, 1.000000>, 
      <-42.900000, -85.250000, -1.000000>, <-39.100000, -88.000000, -1.000000>, <-35.500000, -88.000000, -1.000000>, <-32.700000, -92.200000, -1.000000>, 
      <-42.900000, -82.200000, 0.000000>, <-39.100000, -84.950000, 0.000000>, <-35.500000, -85.000000, 0.000000>, <-32.675000, -89.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.900000, -82.200000, 0.000000>, <-39.100000, -84.950000, 0.000000>, <-35.500000, -85.000000, 0.000000>, <-32.675000, -89.200000, 0.000000>, 
      <-42.900000, -79.150000, 1.000000>, <-39.100000, -81.900000, 1.000000>, <-35.500000, -82.000000, 1.000000>, <-32.650000, -86.200000, 1.000000>, 
      <-42.900000, -78.950000, -1.000000>, <-39.100000, -81.700000, -1.000000>, <-35.500000, -81.800000, -1.000000>, <-32.650000, -86.000000, -1.000000>, 
      <-42.875000, -75.950000, 0.000000>, <-39.050000, -78.700000, 0.000000>, <-35.450000, -78.750000, 0.000000>, <-32.625000, -82.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.875000, -75.950000, 0.000000>, <-39.050000, -78.700000, 0.000000>, <-35.450000, -78.750000, 0.000000>, <-32.625000, -82.950000, 0.000000>, 
      <-42.850000, -72.950000, 1.000000>, <-39.000000, -75.700000, 1.000000>, <-35.400000, -75.700000, 1.000000>, <-32.600000, -79.900000, 1.000000>, 
      <-42.850000, -72.700000, -1.000000>, <-39.000000, -75.500000, -1.000000>, <-35.400000, -75.500000, -1.000000>, <-32.600000, -79.700000, -1.000000>, 
      <-42.825000, -69.675000, 0.000000>, <-39.000000, -72.450000, 0.000000>, <-35.400000, -72.450000, 0.000000>, <-32.575000, -76.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.825000, -69.675000, 0.000000>, <-39.000000, -72.450000, 0.000000>, <-35.400000, -72.450000, 0.000000>, <-32.575000, -76.650000, 0.000000>, 
      <-42.800000, -66.650000, 1.000000>, <-39.000000, -69.400000, 1.000000>, <-35.400000, -69.400000, 1.000000>, <-32.550000, -73.600000, 1.000000>, 
      <-42.800000, -66.450000, -1.000000>, <-39.000000, -69.200000, -1.000000>, <-35.400000, -69.200000, -1.000000>, <-32.550000, -73.400000, -1.000000>, 
      <-42.800000, -63.400000, 0.000000>, <-39.000000, -66.150000, 0.000000>, <-35.400000, -66.150000, 0.000000>, <-32.550000, -70.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.800000, -63.400000, 0.000000>, <-39.000000, -66.150000, 0.000000>, <-35.400000, -66.150000, 0.000000>, <-32.550000, -70.375000, 0.000000>, 
      <-42.800000, -60.350000, 1.000000>, <-39.000000, -63.100000, 1.000000>, <-35.400000, -63.100000, 1.000000>, <-32.550000, -67.350000, 1.000000>, 
      <-42.800000, -60.150000, -1.000000>, <-39.000000, -62.900000, -1.000000>, <-35.400000, -62.900000, -1.000000>, <-32.550000, -67.100000, -1.000000>, 
      <-42.750000, -57.125000, 0.000000>, <-38.950000, -59.900000, 0.000000>, <-35.350000, -59.900000, 0.000000>, <-32.525000, -64.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.750000, -57.125000, 0.000000>, <-38.950000, -59.900000, 0.000000>, <-35.350000, -59.900000, 0.000000>, <-32.525000, -64.100000, 0.000000>, 
      <-42.700000, -54.100000, 1.000000>, <-38.900000, -56.900000, 1.000000>, <-35.300000, -56.900000, 1.000000>, <-32.500000, -61.100000, 1.000000>, 
      <-42.750000, -53.850000, -1.000000>, <-38.900000, -56.600000, -1.000000>, <-35.300000, -56.700000, -1.000000>, <-32.500000, -60.900000, -1.000000>, 
      <-42.725000, -50.850000, 0.000000>, <-38.900000, -53.600000, 0.000000>, <-35.300000, -53.650000, 0.000000>, <-32.475000, -57.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.725000, -50.850000, 0.000000>, <-38.900000, -53.600000, 0.000000>, <-35.300000, -53.650000, 0.000000>, <-32.475000, -57.850000, 0.000000>, 
      <-42.700000, -47.850000, 1.000000>, <-38.900000, -50.600000, 1.000000>, <-35.300000, -50.600000, 1.000000>, <-32.450000, -54.800000, 1.000000>, 
      <-42.700000, -47.600000, -1.000000>, <-38.900000, -50.400000, -1.000000>, <-35.300000, -50.400000, -1.000000>, <-32.450000, -54.600000, -1.000000>, 
      <-42.675000, -44.575000, 0.000000>, <-38.850000, -47.350000, 0.000000>, <-35.250000, -47.350000, 0.000000>, <-32.425000, -51.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.675000, -44.575000, 0.000000>, <-38.850000, -47.350000, 0.000000>, <-35.250000, -47.350000, 0.000000>, <-32.425000, -51.550000, 0.000000>, 
      <-42.650000, -41.550000, 1.000000>, <-38.800000, -44.300000, 1.000000>, <-35.200000, -44.300000, 1.000000>, <-32.400000, -48.500000, 1.000000>, 
      <-42.700000, -41.350000, -1.000000>, <-38.900000, -44.100000, -1.000000>, <-35.300000, -44.100000, -1.000000>, <-32.450000, -48.300000, -1.000000>, 
      <-42.650000, -38.300000, 0.000000>, <-38.850000, -41.050000, 0.000000>, <-35.250000, -41.100000, 0.000000>, <-32.400000, -45.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.650000, -38.300000, 0.000000>, <-38.850000, -41.050000, 0.000000>, <-35.250000, -41.100000, 0.000000>, <-32.400000, -45.300000, 0.000000>, 
      <-42.600000, -35.250000, 1.000000>, <-38.800000, -38.000000, 1.000000>, <-35.200000, -38.100000, 1.000000>, <-32.350000, -42.300000, 1.000000>, 
      <-42.650000, -35.050000, -1.000000>, <-38.800000, -37.800000, -1.000000>, <-35.200000, -37.800000, -1.000000>, <-32.400000, -42.050000, -1.000000>, 
      <-42.625000, -32.025000, 0.000000>, <-38.800000, -34.800000, 0.000000>, <-35.200000, -34.800000, 0.000000>, <-32.375000, -39.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.625000, -32.025000, 0.000000>, <-38.800000, -34.800000, 0.000000>, <-35.200000, -34.800000, 0.000000>, <-32.375000, -39.025000, 0.000000>, 
      <-42.600000, -29.000000, 1.000000>, <-38.800000, -31.800000, 1.000000>, <-35.200000, -31.800000, 1.000000>, <-32.350000, -36.000000, 1.000000>, 
      <-42.600000, -28.750000, -1.000000>, <-38.800000, -31.500000, -1.000000>, <-35.200000, -31.600000, -1.000000>, <-32.350000, -35.800000, -1.000000>, 
      <-42.575000, -25.750000, 0.000000>, <-38.750000, -28.500000, 0.000000>, <-35.150000, -28.550000, 0.000000>, <-32.325000, -32.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.575000, -25.750000, 0.000000>, <-38.750000, -28.500000, 0.000000>, <-35.150000, -28.550000, 0.000000>, <-32.325000, -32.750000, 0.000000>, 
      <-42.550000, -22.750000, 1.000000>, <-38.700000, -25.500000, 1.000000>, <-35.100000, -25.500000, 1.000000>, <-32.300000, -29.700000, 1.000000>, 
      <-42.550000, -22.550000, -1.000000>, <-38.700000, -25.300000, -1.000000>, <-35.200000, -25.300000, -1.000000>, <-32.350000, -29.500000, -1.000000>, 
      <-42.088553, -19.503450, 0.041170>, <-38.334635, -22.258150, 0.041170>, <-34.788344, -22.268654, 0.041170>, <-32.119172, -26.484327, 0.020585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.088553, -19.503450, 0.041170>, <-38.334635, -22.258150, 0.041170>, <-34.788344, -22.268654, 0.041170>, <-32.119172, -26.484327, 0.020585>, 
      <-41.627106, -16.456899, 1.082340>, <-37.969270, -19.216301, 1.082340>, <-34.376688, -19.237307, 1.082340>, <-31.888344, -23.468654, 1.041170>, 
      <-41.625853, -16.242567, 1.116721>, <-37.968016, -19.001969, 1.116721>, <-34.375435, -19.022975, 1.116721>, <-31.937718, -23.211488, 0.058361>, 
      <-41.881646, -13.397793, 1.077047>, <-38.144897, -16.157194, 1.077047>, <-34.552315, -16.178201, 1.077047>, <-31.741644, -20.284513, 0.559108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-41.881646, -13.397793, 1.077047>, <-38.144897, -16.157194, 1.077047>, <-34.552315, -16.178201, 1.077047>, <-31.741644, -20.284513, 0.559108>, 
      <-42.137439, -10.553018, 1.037373>, <-38.321777, -13.312420, 1.037373>, <-34.729196, -13.333426, 1.037373>, <-31.545570, -17.357539, 1.059856>, 
      <-42.136186, -10.338686, 1.114652>, <-38.320524, -13.098088, 1.114652>, <-34.727942, -13.119094, 1.114652>, <-31.544316, -17.143207, 1.115686>, 
      <-42.111265, -7.438125, 1.077992>, <-38.295603, -10.197526, 1.077992>, <-34.703021, -10.218533, 1.077992>, <-31.699209, -14.270539, 1.077519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.111265, -7.438125, 1.077992>, <-38.295603, -10.197526, 1.077992>, <-34.703021, -10.218533, 1.077992>, <-31.699209, -14.270539, 1.077519>, 
      <-42.086344, -4.537564, 1.041331>, <-38.270682, -7.296965, 1.041331>, <-34.678100, -7.317972, 1.041331>, <-31.854101, -11.397871, 1.039352>, 
      <-42.085091, -4.323232, 1.142036>, <-38.269428, -7.082633, 1.142036>, <-34.676847, -7.103640, 1.142036>, <-31.852848, -11.183539, 1.128344>, 
      <-42.074587, -1.165344, 1.089704>, <-38.258924, -3.924746, 1.089704>, <-34.666343, -3.945752, 1.089704>, <-31.835136, -8.154315, 1.083848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.074587, -1.165344, 1.089704>, <-38.258924, -3.924746, 1.089704>, <-34.666343, -3.945752, 1.089704>, <-31.835136, -8.154315, 1.083848>, 
      <-42.064083, 1.992543, 1.037373>, <-38.248421, -0.766859, 1.037373>, <-34.655839, -0.787865, 1.037373>, <-31.817423, -5.125091, 1.039352>, 
      <-42.062830, 2.206875, 1.114652>, <-38.247167, -0.552526, 1.114652>, <-34.654586, -0.573533, 1.114652>, <-31.816170, -4.910758, 1.128344>, 
      <-41.771612, 5.420549, 1.098496>, <-38.034862, 2.661147, 1.098496>, <-34.442281, 2.640141, 1.098496>, <-31.704765, -1.724978, 1.094100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-41.771612, 5.420549, 1.098496>, <-38.034862, 2.661147, 1.098496>, <-34.442281, 2.640141, 1.098496>, <-31.704765, -1.724978, 1.094100>, 
      <-41.480393, 8.634223, 1.082340>, <-37.822557, 5.874821, 1.082340>, <-34.229976, 5.853815, 1.082340>, <-31.593361, 1.460803, 1.059856>, 
      <-41.479140, 8.848555, 1.116721>, <-37.821304, 6.089154, 1.116721>, <-34.228722, 6.068147, 1.116721>, <-31.592108, 1.675135, 1.115686>, 
      <-41.889570, 11.874278, 1.058361>, <-38.160652, 9.094577, 1.058361>, <-34.564361, 9.084073, 1.058361>, <-31.574861, 4.789935, 1.078428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-41.889570, 11.874278, 1.058361>, <-38.160652, 9.094577, 1.058361>, <-34.564361, 9.084073, 1.058361>, <-31.574861, 4.789935, 1.078428>, 
      <-42.300000, 14.900000, 1.000000>, <-38.500000, 12.100000, 1.000000>, <-34.900000, 12.100000, 1.000000>, <-31.557615, 7.904735, 1.041170>, 
      <-42.350000, 15.150000, -1.000000>, <-38.500000, 12.400000, -1.000000>, <-34.900000, 12.300000, -1.000000>, <-31.556989, 8.111901, 0.058361>, 
      <-42.325000, 18.150000, 0.000000>, <-38.500000, 15.400000, 0.000000>, <-34.900000, 15.350000, 0.000000>, <-31.803494, 11.155951, 0.529180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.325000, 18.150000, 0.000000>, <-38.500000, 15.400000, 0.000000>, <-34.900000, 15.350000, 0.000000>, <-31.803494, 11.155951, 0.529180>, 
      <-42.300000, 21.150000, 1.000000>, <-38.500000, 18.400000, 1.000000>, <-34.900000, 18.400000, 1.000000>, <-32.050000, 14.200000, 1.000000>, 
      <-42.300000, 21.400000, -1.000000>, <-38.500000, 18.600000, -1.000000>, <-34.900000, 18.600000, -1.000000>, <-32.050000, 14.400000, -1.000000>, 
      <-42.275000, 24.425000, 0.000000>, <-38.450000, 21.650000, 0.000000>, <-34.850000, 21.650000, 0.000000>, <-32.025000, 17.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.275000, 24.425000, 0.000000>, <-38.450000, 21.650000, 0.000000>, <-34.850000, 21.650000, 0.000000>, <-32.025000, 17.450000, 0.000000>, 
      <-42.250000, 27.450000, 1.000000>, <-38.400000, 24.700000, 1.000000>, <-34.800000, 24.700000, 1.000000>, <-32.000000, 20.500000, 1.000000>, 
      <-42.300000, 27.650000, -1.000000>, <-38.500000, 24.900000, -1.000000>, <-34.900000, 24.900000, -1.000000>, <-32.050000, 20.700000, -1.000000>, 
      <-42.250000, 30.700000, 0.000000>, <-38.450000, 27.950000, 0.000000>, <-34.850000, 27.900000, 0.000000>, <-32.000000, 23.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.250000, 30.700000, 0.000000>, <-38.450000, 27.950000, 0.000000>, <-34.850000, 27.900000, 0.000000>, <-32.000000, 23.700000, 0.000000>, 
      <-42.200000, 33.750000, 1.000000>, <-38.400000, 31.000000, 1.000000>, <-34.800000, 30.900000, 1.000000>, <-31.950000, 26.700000, 1.000000>, 
      <-42.200000, 33.950000, -1.000000>, <-38.400000, 31.200000, -1.000000>, <-34.800000, 31.200000, -1.000000>, <-32.000000, 26.950000, -1.000000>, 
      <-42.200000, 36.975000, 0.000000>, <-38.400000, 34.200000, 0.000000>, <-34.800000, 34.200000, 0.000000>, <-31.975000, 29.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.200000, 36.975000, 0.000000>, <-38.400000, 34.200000, 0.000000>, <-34.800000, 34.200000, 0.000000>, <-31.975000, 29.975000, 0.000000>, 
      <-42.200000, 40.000000, 1.000000>, <-38.400000, 37.200000, 1.000000>, <-34.800000, 37.200000, 1.000000>, <-31.950000, 33.000000, 1.000000>, 
      <-42.200000, 40.250000, -1.000000>, <-38.400000, 37.500000, -1.000000>, <-34.800000, 37.400000, -1.000000>, <-31.950000, 33.200000, -1.000000>, 
      <-42.175000, 43.250000, 0.000000>, <-38.350000, 40.500000, 0.000000>, <-34.750000, 40.450000, 0.000000>, <-31.925000, 36.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.175000, 43.250000, 0.000000>, <-38.350000, 40.500000, 0.000000>, <-34.750000, 40.450000, 0.000000>, <-31.925000, 36.250000, 0.000000>, 
      <-42.150000, 46.250000, 1.000000>, <-38.300000, 43.500000, 1.000000>, <-34.700000, 43.500000, 1.000000>, <-31.900000, 39.300000, 1.000000>, 
      <-42.150000, 46.450000, -1.000000>, <-38.300000, 43.700000, -1.000000>, <-34.800000, 43.700000, -1.000000>, <-31.950000, 39.500000, -1.000000>, 
      <-42.250000, 48.750000, 0.000000>, <-38.400000, 46.000000, 0.000000>, <-34.900000, 45.950000, 0.000000>, <-32.050000, 41.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.250000, 48.750000, 0.000000>, <-38.400000, 46.000000, 0.000000>, <-34.900000, 45.950000, 0.000000>, <-32.050000, 41.750000, 0.000000>, 
      <-42.350000, 51.050000, 1.000000>, <-38.500000, 48.300000, 1.000000>, <-35.000000, 48.200000, 1.000000>, <-32.150000, 44.000000, 1.000000>, 
      <-42.400000, 51.250000, -1.000000>, <-38.600000, 48.500000, -1.000000>, <-35.000000, 48.500000, -1.000000>, <-32.150000, 44.250000, -1.000000>, 
      <-42.250000, 55.050000, 0.000000>, <-38.450000, 52.300000, 0.000000>, <-34.850000, 52.250000, 0.000000>, <-32.000000, 48.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.250000, 55.050000, 0.000000>, <-38.450000, 52.300000, 0.000000>, <-34.850000, 52.250000, 0.000000>, <-32.000000, 48.225000, 0.000000>, 
      <-42.100000, 58.850000, 1.000000>, <-38.300000, 56.100000, 1.000000>, <-34.700000, 56.000000, 1.000000>, <-31.850000, 52.200000, 1.000000>, 
      <-42.100000, 59.050000, -1.000000>, <-38.300000, 56.300000, -1.000000>, <-34.700000, 56.300000, -1.000000>, <-31.850000, 52.450000, -1.000000>, 
      <-42.050000, 62.450000, 0.000000>, <-38.250000, 59.700000, 0.000000>, <-34.650000, 59.700000, 0.000000>, <-31.825000, 55.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.050000, 62.450000, 0.000000>, <-38.250000, 59.700000, 0.000000>, <-34.650000, 59.700000, 0.000000>, <-31.825000, 55.675000, 0.000000>, 
      <-42.000000, 65.850000, 1.000000>, <-38.200000, 63.100000, 1.000000>, <-34.600000, 63.100000, 1.000000>, <-31.800000, 58.900000, 1.000000>, 
      <-42.050000, 66.050000, -1.000000>, <-38.200000, 63.300000, -1.000000>, <-34.600000, 63.300000, -1.000000>, <-31.800000, 59.100000, -1.000000>, 
      <-42.025000, 68.700000, 0.000000>, <-38.200000, 65.950000, 0.000000>, <-34.600000, 65.950000, 0.000000>, <-31.775000, 61.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.025000, 68.700000, 0.000000>, <-38.200000, 65.950000, 0.000000>, <-34.600000, 65.950000, 0.000000>, <-31.775000, 61.750000, 0.000000>, 
      <-42.000000, 71.350000, 1.000000>, <-38.200000, 68.600000, 1.000000>, <-34.600000, 68.600000, 1.000000>, <-31.750000, 64.400000, 1.000000>, 
      <-42.000000, 71.550000, -1.000000>, <-38.200000, 68.800000, -1.000000>, <-34.600000, 68.800000, -1.000000>, <-31.750000, 64.600000, -1.000000>, 
      <-42.100000, 74.100000, 0.000000>, <-38.300000, 71.350000, 0.000000>, <-34.700000, 71.300000, 0.000000>, <-31.850000, 67.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-42.100000, 74.100000, 0.000000>, <-38.300000, 71.350000, 0.000000>, <-34.700000, 71.300000, 0.000000>, <-31.850000, 67.750000, 0.000000>, 
      <-42.200000, 76.650000, 1.000000>, <-38.400000, 73.900000, 1.000000>, <-34.800000, 73.800000, 1.000000>, <-31.950000, 70.900000, 1.000000>, 
      <-42.200000, 76.850000, -1.000000>, <-38.400000, 74.100000, -1.000000>, <-34.800000, 74.100000, -1.000000>, <-32.000000, 71.600000, -1.000000>, 
      <-41.950000, 81.750000, 0.700000>, <-38.100000, 79.000000, 0.700000>, <-35.200000, 79.700000, 0.700000>, <-32.050000, 76.850000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.850000, -115.200000, -1.000000>, <-30.000000, -119.400000, -1.000000>, <-26.400000, -119.500000, -1.000000>, <-23.200000, -121.400000, -1.000000>, 
      <-32.800000, -111.300000, 1.000000>, <-30.000000, -115.500000, 1.000000>, <-26.400000, -115.500000, 1.000000>, <-23.150000, -117.400000, 1.000000>, 
      <-32.800000, -111.050000, -1.000000>, <-30.000000, -115.300000, -1.000000>, <-26.400000, -115.300000, -1.000000>, <-23.200000, -117.200000, -1.000000>, 
      <-32.775000, -108.025000, 0.000000>, <-29.950000, -112.250000, 0.000000>, <-26.350000, -112.250000, 0.000000>, <-23.150000, -114.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.775000, -108.025000, 0.000000>, <-29.950000, -112.250000, 0.000000>, <-26.350000, -112.250000, 0.000000>, <-23.150000, -114.175000, 0.000000>, 
      <-32.750000, -105.000000, 1.000000>, <-29.900000, -109.200000, 1.000000>, <-26.300000, -109.200000, 1.000000>, <-23.100000, -111.150000, 1.000000>, 
      <-32.750000, -104.800000, -1.000000>, <-29.900000, -109.000000, -1.000000>, <-26.300000, -109.000000, -1.000000>, <-23.100000, -110.950000, -1.000000>, 
      <-32.725000, -101.750000, 0.000000>, <-29.900000, -105.950000, 0.000000>, <-26.300000, -105.950000, 0.000000>, <-23.100000, -107.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.725000, -101.750000, 0.000000>, <-29.900000, -105.950000, 0.000000>, <-26.300000, -105.950000, 0.000000>, <-23.100000, -107.900000, 0.000000>, 
      <-32.700000, -98.700000, 1.000000>, <-29.900000, -102.900000, 1.000000>, <-26.300000, -102.900000, 1.000000>, <-23.100000, -104.850000, 1.000000>, 
      <-32.750000, -98.500000, -1.000000>, <-29.900000, -102.700000, -1.000000>, <-26.300000, -102.700000, -1.000000>, <-23.100000, -104.650000, -1.000000>, 
      <-32.700000, -95.475000, 0.000000>, <-29.850000, -99.700000, 0.000000>, <-26.300000, -99.700000, 0.000000>, <-23.075000, -101.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.700000, -95.475000, 0.000000>, <-29.850000, -99.700000, 0.000000>, <-26.300000, -99.700000, 0.000000>, <-23.075000, -101.625000, 0.000000>, 
      <-32.650000, -92.450000, 1.000000>, <-29.800000, -96.700000, 1.000000>, <-26.300000, -96.700000, 1.000000>, <-23.050000, -98.600000, 1.000000>, 
      <-32.700000, -92.200000, -1.000000>, <-29.900000, -96.400000, -1.000000>, <-26.300000, -96.500000, -1.000000>, <-23.050000, -98.400000, -1.000000>, 
      <-32.675000, -89.200000, 0.000000>, <-29.850000, -93.400000, 0.000000>, <-26.250000, -93.450000, 0.000000>, <-23.025000, -95.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.675000, -89.200000, 0.000000>, <-29.850000, -93.400000, 0.000000>, <-26.250000, -93.450000, 0.000000>, <-23.025000, -95.375000, 0.000000>, 
      <-32.650000, -86.200000, 1.000000>, <-29.800000, -90.400000, 1.000000>, <-26.200000, -90.400000, 1.000000>, <-23.000000, -92.350000, 1.000000>, 
      <-32.650000, -86.000000, -1.000000>, <-29.800000, -90.200000, -1.000000>, <-26.200000, -90.200000, -1.000000>, <-23.000000, -92.100000, -1.000000>, 
      <-32.625000, -82.950000, 0.000000>, <-29.800000, -87.150000, 0.000000>, <-26.200000, -87.150000, 0.000000>, <-23.000000, -89.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.625000, -82.950000, 0.000000>, <-29.800000, -87.150000, 0.000000>, <-26.200000, -87.150000, 0.000000>, <-23.000000, -89.075000, 0.000000>, 
      <-32.600000, -79.900000, 1.000000>, <-29.800000, -84.100000, 1.000000>, <-26.200000, -84.100000, 1.000000>, <-23.000000, -86.050000, 1.000000>, 
      <-32.600000, -79.700000, -1.000000>, <-29.800000, -83.900000, -1.000000>, <-26.200000, -83.900000, -1.000000>, <-23.000000, -85.850000, -1.000000>, 
      <-32.575000, -76.650000, 0.000000>, <-29.750000, -80.850000, 0.000000>, <-26.150000, -80.900000, 0.000000>, <-22.950000, -82.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.575000, -76.650000, 0.000000>, <-29.750000, -80.850000, 0.000000>, <-26.150000, -80.900000, 0.000000>, <-22.950000, -82.825000, 0.000000>, 
      <-32.550000, -73.600000, 1.000000>, <-29.700000, -77.800000, 1.000000>, <-26.100000, -77.900000, 1.000000>, <-22.900000, -79.800000, 1.000000>, 
      <-32.550000, -73.400000, -1.000000>, <-29.700000, -77.600000, -1.000000>, <-26.200000, -77.600000, -1.000000>, <-22.950000, -79.550000, -1.000000>, 
      <-32.550000, -70.375000, 0.000000>, <-29.700000, -74.600000, 0.000000>, <-26.150000, -74.600000, 0.000000>, <-22.925000, -76.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.550000, -70.375000, 0.000000>, <-29.700000, -74.600000, 0.000000>, <-26.150000, -74.600000, 0.000000>, <-22.925000, -76.525000, 0.000000>, 
      <-32.550000, -67.350000, 1.000000>, <-29.700000, -71.600000, 1.000000>, <-26.100000, -71.600000, 1.000000>, <-22.900000, -73.500000, 1.000000>, 
      <-32.550000, -67.100000, -1.000000>, <-29.700000, -71.300000, -1.000000>, <-26.100000, -71.400000, -1.000000>, <-22.900000, -73.300000, -1.000000>, 
      <-32.525000, -64.100000, 0.000000>, <-29.700000, -68.300000, 0.000000>, <-26.100000, -68.350000, 0.000000>, <-22.875000, -70.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.525000, -64.100000, 0.000000>, <-29.700000, -68.300000, 0.000000>, <-26.100000, -68.350000, 0.000000>, <-22.875000, -70.275000, 0.000000>, 
      <-32.500000, -61.100000, 1.000000>, <-29.700000, -65.300000, 1.000000>, <-26.100000, -65.300000, 1.000000>, <-22.850000, -67.250000, 1.000000>, 
      <-32.500000, -60.900000, -1.000000>, <-29.700000, -65.100000, -1.000000>, <-26.100000, -65.100000, -1.000000>, <-22.900000, -67.000000, -1.000000>, 
      <-32.475000, -57.850000, 0.000000>, <-29.650000, -62.050000, 0.000000>, <-26.050000, -62.050000, 0.000000>, <-22.850000, -63.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.475000, -57.850000, 0.000000>, <-29.650000, -62.050000, 0.000000>, <-26.050000, -62.050000, 0.000000>, <-22.850000, -63.975000, 0.000000>, 
      <-32.450000, -54.800000, 1.000000>, <-29.600000, -59.000000, 1.000000>, <-26.000000, -59.000000, 1.000000>, <-22.800000, -60.950000, 1.000000>, 
      <-32.450000, -54.600000, -1.000000>, <-29.600000, -58.800000, -1.000000>, <-26.000000, -58.800000, -1.000000>, <-22.800000, -60.750000, -1.000000>, 
      <-32.425000, -51.550000, 0.000000>, <-29.600000, -55.750000, 0.000000>, <-26.000000, -55.800000, 0.000000>, <-22.800000, -57.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.425000, -51.550000, 0.000000>, <-29.600000, -55.750000, 0.000000>, <-26.000000, -55.800000, 0.000000>, <-22.800000, -57.725000, 0.000000>, 
      <-32.400000, -48.500000, 1.000000>, <-29.600000, -52.700000, 1.000000>, <-26.000000, -52.800000, 1.000000>, <-22.800000, -54.700000, 1.000000>, 
      <-32.450000, -48.300000, -1.000000>, <-29.600000, -52.500000, -1.000000>, <-26.000000, -52.600000, -1.000000>, <-22.800000, -54.500000, -1.000000>, 
      <-32.400000, -45.300000, 0.000000>, <-29.550000, -49.500000, 0.000000>, <-26.000000, -49.550000, 0.000000>, <-22.775000, -51.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.400000, -45.300000, 0.000000>, <-29.550000, -49.500000, 0.000000>, <-26.000000, -49.550000, 0.000000>, <-22.775000, -51.450000, 0.000000>, 
      <-32.350000, -42.300000, 1.000000>, <-29.500000, -46.500000, 1.000000>, <-26.000000, -46.500000, 1.000000>, <-22.750000, -48.400000, 1.000000>, 
      <-32.400000, -42.050000, -1.000000>, <-29.600000, -46.300000, -1.000000>, <-26.000000, -46.300000, -1.000000>, <-22.750000, -48.200000, -1.000000>, 
      <-32.375000, -39.025000, 0.000000>, <-29.550000, -43.250000, 0.000000>, <-25.950000, -43.250000, 0.000000>, <-22.725000, -45.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.375000, -39.025000, 0.000000>, <-29.550000, -43.250000, 0.000000>, <-25.950000, -43.250000, 0.000000>, <-22.725000, -45.100000, 0.000000>, 
      <-32.350000, -36.000000, 1.000000>, <-29.500000, -40.200000, 1.000000>, <-25.900000, -40.200000, 1.000000>, <-22.700000, -42.000000, 1.000000>, 
      <-32.350000, -35.800000, -1.000000>, <-29.500000, -40.000000, -1.000000>, <-25.900000, -40.000000, -1.000000>, <-22.700000, -41.800000, -1.000000>, 
      <-32.325000, -32.750000, 0.000000>, <-29.500000, -36.950000, 0.000000>, <-25.900000, -36.950000, 0.000000>, <-22.700000, -38.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.325000, -32.750000, 0.000000>, <-29.500000, -36.950000, 0.000000>, <-25.900000, -36.950000, 0.000000>, <-22.700000, -38.750000, 0.000000>, 
      <-32.300000, -29.700000, 1.000000>, <-29.500000, -33.900000, 1.000000>, <-25.900000, -33.900000, 1.000000>, <-22.700000, -35.700000, 1.000000>, 
      <-32.350000, -29.500000, -1.000000>, <-29.500000, -33.700000, -1.000000>, <-25.900000, -33.700000, -1.000000>, <-22.700000, -35.500000, -1.000000>, 
      <-32.119172, -26.484327, 0.020585>, <-29.450000, -30.700000, 0.000000>, <-25.850000, -30.700000, 0.000000>, <-22.650000, -32.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.119172, -26.484327, 0.020585>, <-29.450000, -30.700000, 0.000000>, <-25.850000, -30.700000, 0.000000>, <-22.650000, -32.550000, 0.000000>, 
      <-31.888344, -23.468654, 1.041170>, <-29.400000, -27.700000, 1.000000>, <-25.800000, -27.700000, 1.000000>, <-22.600000, -29.600000, 1.000000>, 
      <-31.937718, -23.211488, 0.058361>, <-29.500000, -27.400000, -1.000000>, <-25.900000, -27.500000, -1.000000>, <-22.650000, -29.400000, -1.000000>, 
      <-31.741644, -20.284513, 0.559108>, <-28.930972, -24.390826, 0.041170>, <-25.334681, -24.451329, 0.041170>, <-22.103734, -26.426172, 0.041170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.741644, -20.284513, 0.559108>, <-28.930972, -24.390826, 0.041170>, <-25.334681, -24.451329, 0.041170>, <-22.103734, -26.426172, 0.041170>, 
      <-31.545570, -17.357539, 1.059856>, <-28.361943, -21.381652, 1.082340>, <-24.769362, -21.402658, 1.082340>, <-21.557468, -23.452344, 1.082340>, 
      <-31.544316, -17.143207, 1.115686>, <-28.360690, -21.167319, 1.116721>, <-24.768109, -21.188326, 1.116721>, <-21.556215, -23.238012, 1.116721>, 
      <-31.699209, -14.270539, 1.077519>, <-28.695396, -18.322545, 1.077047>, <-25.102815, -18.343551, 1.077047>, <-21.890921, -20.393238, 1.077047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.699209, -14.270539, 1.077519>, <-28.695396, -18.322545, 1.077047>, <-25.102815, -18.343551, 1.077047>, <-21.890921, -20.393238, 1.077047>, 
      <-31.854101, -11.397871, 1.039352>, <-29.030103, -15.477771, 1.037373>, <-25.437521, -15.498777, 1.037373>, <-22.225627, -17.548463, 1.037373>, 
      <-31.852848, -11.183539, 1.128344>, <-29.028849, -15.263438, 1.114652>, <-25.436268, -15.284445, 1.114652>, <-22.224374, -17.334131, 1.114652>, 
      <-31.835136, -8.154315, 1.083848>, <-29.003928, -12.362877, 1.077992>, <-25.411347, -12.383884, 1.077992>, <-22.199453, -14.120457, 1.077992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.835136, -8.154315, 1.083848>, <-29.003928, -12.362877, 1.077992>, <-25.411347, -12.383884, 1.077992>, <-22.199453, -14.120457, 1.077992>, 
      <-31.817423, -5.125091, 1.039352>, <-28.979007, -9.462316, 1.041331>, <-25.386426, -9.483323, 1.041331>, <-22.174532, -10.906783, 1.041331>, 
      <-31.816170, -4.910758, 1.128344>, <-28.977754, -9.247984, 1.142036>, <-25.385173, -9.268990, 1.142036>, <-22.173278, -10.692451, 1.142036>, 
      <-31.704765, -1.724978, 1.094100>, <-28.967250, -6.090097, 1.089704>, <-25.374669, -6.111103, 1.089704>, <-22.162774, -7.722431, 1.089704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.704765, -1.724978, 1.094100>, <-28.967250, -6.090097, 1.089704>, <-25.374669, -6.111103, 1.089704>, <-22.162774, -7.722431, 1.089704>, 
      <-31.593361, 1.460803, 1.059856>, <-28.956746, -2.932209, 1.037373>, <-25.364165, -2.953216, 1.037373>, <-22.152271, -4.752412, 1.037373>, 
      <-31.592108, 1.675135, 1.115686>, <-28.955493, -2.717877, 1.114652>, <-25.362912, -2.738884, 1.114652>, <-22.151017, -4.538080, 1.114652>, 
      <-31.574861, 4.789935, 1.078428>, <-28.585362, 0.495797, 1.098496>, <-24.992781, 0.474790, 1.098496>, <-21.780886, -1.387028, 1.098496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.574861, 4.789935, 1.078428>, <-28.585362, 0.495797, 1.098496>, <-24.992781, 0.474790, 1.098496>, <-21.780886, -1.387028, 1.098496>, 
      <-31.557615, 7.904735, 1.041170>, <-28.215231, 3.709471, 1.082340>, <-24.622649, 3.688464, 1.082340>, <-21.410755, 1.764023, 1.082340>, 
      <-31.556989, 8.111901, 0.058361>, <-28.213977, 3.923803, 1.116721>, <-24.621396, 3.902796, 1.116721>, <-21.409502, 1.978355, 1.116721>, 
      <-31.803494, 11.155951, 0.529180>, <-28.706989, 6.961901, 1.058361>, <-25.110698, 6.951398, 1.058361>, <-21.904751, 5.014178, 1.058361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.803494, 11.155951, 0.529180>, <-28.706989, 6.961901, 1.058361>, <-25.110698, 6.951398, 1.058361>, <-21.904751, 5.014178, 1.058361>, 
      <-32.050000, 14.200000, 1.000000>, <-29.200000, 10.000000, 1.000000>, <-25.600000, 10.000000, 1.000000>, <-22.400000, 8.050000, 1.000000>, 
      <-32.050000, 14.400000, -1.000000>, <-29.200000, 10.200000, -1.000000>, <-25.600000, 10.200000, -1.000000>, <-22.400000, 8.250000, -1.000000>, 
      <-32.025000, 17.450000, 0.000000>, <-29.200000, 13.250000, 0.000000>, <-25.600000, 13.200000, 0.000000>, <-22.400000, 11.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.025000, 17.450000, 0.000000>, <-29.200000, 13.250000, 0.000000>, <-25.600000, 13.200000, 0.000000>, <-22.400000, 11.275000, 0.000000>, 
      <-32.000000, 20.500000, 1.000000>, <-29.200000, 16.300000, 1.000000>, <-25.600000, 16.200000, 1.000000>, <-22.400000, 14.300000, 1.000000>, 
      <-32.050000, 20.700000, -1.000000>, <-29.200000, 16.500000, -1.000000>, <-25.600000, 16.400000, -1.000000>, <-22.400000, 14.500000, -1.000000>, 
      <-32.000000, 23.700000, 0.000000>, <-29.150000, 19.500000, 0.000000>, <-25.600000, 19.450000, 0.000000>, <-22.375000, 17.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.000000, 23.700000, 0.000000>, <-29.150000, 19.500000, 0.000000>, <-25.600000, 19.450000, 0.000000>, <-22.375000, 17.550000, 0.000000>, 
      <-31.950000, 26.700000, 1.000000>, <-29.100000, 22.500000, 1.000000>, <-25.600000, 22.500000, 1.000000>, <-22.350000, 20.600000, 1.000000>, 
      <-32.000000, 26.950000, -1.000000>, <-29.200000, 22.700000, -1.000000>, <-25.600000, 22.700000, -1.000000>, <-22.350000, 20.800000, -1.000000>, 
      <-31.975000, 29.975000, 0.000000>, <-29.150000, 25.750000, 0.000000>, <-25.550000, 25.750000, 0.000000>, <-22.325000, 23.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.975000, 29.975000, 0.000000>, <-29.150000, 25.750000, 0.000000>, <-25.550000, 25.750000, 0.000000>, <-22.325000, 23.825000, 0.000000>, 
      <-31.950000, 33.000000, 1.000000>, <-29.100000, 28.800000, 1.000000>, <-25.500000, 28.800000, 1.000000>, <-22.300000, 26.850000, 1.000000>, 
      <-31.950000, 33.200000, -1.000000>, <-29.100000, 29.000000, -1.000000>, <-25.500000, 29.000000, -1.000000>, <-22.300000, 27.050000, -1.000000>, 
      <-31.925000, 36.250000, 0.000000>, <-29.100000, 32.050000, 0.000000>, <-25.500000, 32.050000, 0.000000>, <-22.300000, 30.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.925000, 36.250000, 0.000000>, <-29.100000, 32.050000, 0.000000>, <-25.500000, 32.050000, 0.000000>, <-22.300000, 30.100000, 0.000000>, 
      <-31.900000, 39.300000, 1.000000>, <-29.100000, 35.100000, 1.000000>, <-25.500000, 35.100000, 1.000000>, <-22.300000, 33.150000, 1.000000>, 
      <-31.950000, 39.500000, -1.000000>, <-29.100000, 35.300000, -1.000000>, <-25.500000, 35.300000, -1.000000>, <-22.300000, 33.350000, -1.000000>, 
      <-32.050000, 41.750000, 0.000000>, <-29.200000, 37.550000, 0.000000>, <-25.600000, 37.550000, 0.000000>, <-22.400000, 35.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.050000, 41.750000, 0.000000>, <-29.200000, 37.550000, 0.000000>, <-25.600000, 37.550000, 0.000000>, <-22.400000, 35.625000, 0.000000>, 
      <-32.150000, 44.000000, 1.000000>, <-29.300000, 39.800000, 1.000000>, <-25.700000, 39.800000, 1.000000>, <-22.500000, 37.900000, 1.000000>, 
      <-32.150000, 44.250000, -1.000000>, <-29.300000, 40.000000, -1.000000>, <-25.700000, 40.000000, -1.000000>, <-22.500000, 38.100000, -1.000000>, 
      <-32.000000, 48.225000, 0.000000>, <-29.150000, 44.200000, 0.000000>, <-25.500000, 43.550000, 0.000000>, <-22.275000, 41.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.000000, 48.225000, 0.000000>, <-29.150000, 44.200000, 0.000000>, <-25.500000, 43.550000, 0.000000>, <-22.275000, 41.650000, 0.000000>, 
      <-31.850000, 52.200000, 1.000000>, <-29.000000, 48.400000, 1.000000>, <-25.300000, 47.100000, 1.000000>, <-22.050000, 45.200000, 1.000000>, 
      <-31.850000, 52.450000, -1.000000>, <-29.000000, 48.600000, -1.000000>, <-25.300000, 47.400000, -1.000000>, <-22.050000, 45.450000, -1.000000>, 
      <-31.825000, 55.675000, 0.000000>, <-29.000000, 51.650000, 0.000000>, <-25.250000, 50.400000, 0.000000>, <-22.025000, 48.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.825000, 55.675000, 0.000000>, <-29.000000, 51.650000, 0.000000>, <-25.250000, 50.400000, 0.000000>, <-22.025000, 48.475000, 0.000000>, 
      <-31.800000, 58.900000, 1.000000>, <-29.000000, 54.700000, 1.000000>, <-25.200000, 53.400000, 1.000000>, <-22.000000, 51.500000, 1.000000>, 
      <-31.800000, 59.100000, -1.000000>, <-29.000000, 54.900000, -1.000000>, <-25.200000, 53.600000, -1.000000>, <-22.000000, 51.700000, -1.000000>, 
      <-31.775000, 61.750000, 0.000000>, <-28.950000, 57.550000, 0.000000>, <-25.200000, 56.250000, 0.000000>, <-22.000000, 54.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.775000, 61.750000, 0.000000>, <-28.950000, 57.550000, 0.000000>, <-25.200000, 56.250000, 0.000000>, <-22.000000, 54.350000, 0.000000>, 
      <-31.750000, 64.400000, 1.000000>, <-28.900000, 60.200000, 1.000000>, <-25.200000, 58.900000, 1.000000>, <-22.000000, 57.000000, 1.000000>, 
      <-31.750000, 64.600000, -1.000000>, <-28.900000, 60.400000, -1.000000>, <-25.200000, 59.100000, -1.000000>, <-22.000000, 57.200000, -1.000000>, 
      <-31.850000, 67.750000, 0.000000>, <-29.000000, 64.200000, 0.000000>, <-25.300000, 62.350000, 0.000000>, <-22.025000, 60.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.850000, 67.750000, 0.000000>, <-29.000000, 64.200000, 0.000000>, <-25.300000, 62.350000, 0.000000>, <-22.025000, 60.350000, 0.000000>, 
      <-31.950000, 70.900000, 1.000000>, <-29.100000, 68.000000, 1.000000>, <-25.400000, 65.600000, 1.000000>, <-22.050000, 63.500000, 1.000000>, 
      <-32.000000, 71.600000, -1.000000>, <-29.200000, 69.100000, -1.000000>, <-25.400000, 65.800000, -1.000000>, <-22.050000, 63.700000, -1.000000>, 
      <-32.050000, 76.850000, 0.700000>, <-28.900000, 74.000000, 0.700000>, <-25.100000, 70.700000, 0.700000>, <-21.900000, 68.100000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.200000, -121.400000, -1.000000>, <-20.000000, -123.300000, -1.000000>, <-16.400000, -123.300000, -1.000000>, <-13.050000, -126.650000, -1.000000>, 
      <-23.150000, -117.400000, 1.000000>, <-19.900000, -119.300000, 1.000000>, <-16.300000, -119.400000, 1.000000>, <-13.000000, -122.700000, 1.000000>, 
      <-23.200000, -117.200000, -1.000000>, <-20.000000, -119.100000, -1.000000>, <-16.400000, -119.100000, -1.000000>, <-13.050000, -122.450000, -1.000000>, 
      <-23.150000, -114.175000, 0.000000>, <-19.950000, -116.100000, 0.000000>, <-16.350000, -116.100000, 0.000000>, <-13.000000, -119.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.150000, -114.175000, 0.000000>, <-19.950000, -116.100000, 0.000000>, <-16.350000, -116.100000, 0.000000>, <-13.000000, -119.425000, 0.000000>, 
      <-23.100000, -111.150000, 1.000000>, <-19.900000, -113.100000, 1.000000>, <-16.300000, -113.100000, 1.000000>, <-12.950000, -116.400000, 1.000000>, 
      <-23.100000, -110.950000, -1.000000>, <-19.900000, -112.900000, -1.000000>, <-16.300000, -112.900000, -1.000000>, <-12.950000, -116.200000, -1.000000>, 
      <-23.100000, -107.900000, 0.000000>, <-19.900000, -109.850000, 0.000000>, <-16.300000, -109.850000, 0.000000>, <-12.950000, -113.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.100000, -107.900000, 0.000000>, <-19.900000, -109.850000, 0.000000>, <-16.300000, -109.850000, 0.000000>, <-12.950000, -113.175000, 0.000000>, 
      <-23.100000, -104.850000, 1.000000>, <-19.900000, -106.800000, 1.000000>, <-16.300000, -106.800000, 1.000000>, <-12.950000, -110.150000, 1.000000>, 
      <-23.100000, -104.650000, -1.000000>, <-19.900000, -106.600000, -1.000000>, <-16.300000, -106.600000, -1.000000>, <-12.950000, -109.900000, -1.000000>, 
      <-23.075000, -101.625000, 0.000000>, <-19.850000, -103.550000, 0.000000>, <-16.250000, -103.550000, 0.000000>, <-12.925000, -106.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.075000, -101.625000, 0.000000>, <-19.850000, -103.550000, 0.000000>, <-16.250000, -103.550000, 0.000000>, <-12.925000, -106.875000, 0.000000>, 
      <-23.050000, -98.600000, 1.000000>, <-19.800000, -100.500000, 1.000000>, <-16.200000, -100.500000, 1.000000>, <-12.900000, -103.850000, 1.000000>, 
      <-23.050000, -98.400000, -1.000000>, <-19.800000, -100.300000, -1.000000>, <-16.200000, -100.300000, -1.000000>, <-12.900000, -103.650000, -1.000000>, 
      <-23.025000, -95.375000, 0.000000>, <-19.800000, -97.300000, 0.000000>, <-16.200000, -97.300000, 0.000000>, <-12.875000, -100.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.025000, -95.375000, 0.000000>, <-19.800000, -97.300000, 0.000000>, <-16.200000, -97.300000, 0.000000>, <-12.875000, -100.625000, 0.000000>, 
      <-23.000000, -92.350000, 1.000000>, <-19.800000, -94.300000, 1.000000>, <-16.200000, -94.300000, 1.000000>, <-12.850000, -97.600000, 1.000000>, 
      <-23.000000, -92.100000, -1.000000>, <-19.800000, -94.000000, -1.000000>, <-16.200000, -94.100000, -1.000000>, <-12.850000, -97.400000, -1.000000>, 
      <-23.000000, -89.075000, 0.000000>, <-19.800000, -91.000000, 0.000000>, <-16.200000, -91.050000, 0.000000>, <-12.850000, -94.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-23.000000, -89.075000, 0.000000>, <-19.800000, -91.000000, 0.000000>, <-16.200000, -91.050000, 0.000000>, <-12.850000, -94.350000, 0.000000>, 
      <-23.000000, -86.050000, 1.000000>, <-19.800000, -88.000000, 1.000000>, <-16.200000, -88.000000, 1.000000>, <-12.850000, -91.300000, 1.000000>, 
      <-23.000000, -85.850000, -1.000000>, <-19.800000, -87.800000, -1.000000>, <-16.200000, -87.800000, -1.000000>, <-12.850000, -91.100000, -1.000000>, 
      <-22.950000, -82.825000, 0.000000>, <-19.750000, -84.750000, 0.000000>, <-16.150000, -84.750000, 0.000000>, <-12.800000, -88.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.950000, -82.825000, 0.000000>, <-19.750000, -84.750000, 0.000000>, <-16.150000, -84.750000, 0.000000>, <-12.800000, -88.075000, 0.000000>, 
      <-22.900000, -79.800000, 1.000000>, <-19.700000, -81.700000, 1.000000>, <-16.100000, -81.700000, 1.000000>, <-12.750000, -85.050000, 1.000000>, 
      <-22.950000, -79.550000, -1.000000>, <-19.700000, -81.500000, -1.000000>, <-16.100000, -81.500000, -1.000000>, <-12.800000, -84.850000, -1.000000>, 
      <-22.925000, -76.525000, 0.000000>, <-19.700000, -78.450000, 0.000000>, <-16.100000, -78.500000, 0.000000>, <-12.775000, -81.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.925000, -76.525000, 0.000000>, <-19.700000, -78.450000, 0.000000>, <-16.100000, -78.500000, 0.000000>, <-12.775000, -81.825000, 0.000000>, 
      <-22.900000, -73.500000, 1.000000>, <-19.700000, -75.400000, 1.000000>, <-16.100000, -75.500000, 1.000000>, <-12.750000, -78.800000, 1.000000>, 
      <-22.900000, -73.300000, -1.000000>, <-19.700000, -75.200000, -1.000000>, <-16.100000, -75.200000, -1.000000>, <-12.750000, -78.550000, -1.000000>, 
      <-22.875000, -70.275000, 0.000000>, <-19.650000, -72.200000, 0.000000>, <-16.100000, -72.200000, 0.000000>, <-12.750000, -75.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.875000, -70.275000, 0.000000>, <-19.650000, -72.200000, 0.000000>, <-16.100000, -72.200000, 0.000000>, <-12.750000, -75.525000, 0.000000>, 
      <-22.850000, -67.250000, 1.000000>, <-19.600000, -69.200000, 1.000000>, <-16.100000, -69.200000, 1.000000>, <-12.750000, -72.500000, 1.000000>, 
      <-22.900000, -67.000000, -1.000000>, <-19.700000, -68.900000, -1.000000>, <-16.100000, -69.000000, -1.000000>, <-12.750000, -72.300000, -1.000000>, 
      <-22.850000, -63.975000, 0.000000>, <-19.650000, -65.900000, 0.000000>, <-16.050000, -65.950000, 0.000000>, <-12.700000, -69.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.850000, -63.975000, 0.000000>, <-19.650000, -65.900000, 0.000000>, <-16.050000, -65.950000, 0.000000>, <-12.700000, -69.250000, 0.000000>, 
      <-22.800000, -60.950000, 1.000000>, <-19.600000, -62.900000, 1.000000>, <-16.000000, -62.900000, 1.000000>, <-12.650000, -66.200000, 1.000000>, 
      <-22.800000, -60.750000, -1.000000>, <-19.600000, -62.700000, -1.000000>, <-16.000000, -62.700000, -1.000000>, <-12.700000, -66.000000, -1.000000>, 
      <-22.800000, -57.725000, 0.000000>, <-19.600000, -59.650000, 0.000000>, <-16.000000, -59.650000, 0.000000>, <-12.675000, -62.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.800000, -57.725000, 0.000000>, <-19.600000, -59.650000, 0.000000>, <-16.000000, -59.650000, 0.000000>, <-12.675000, -62.975000, 0.000000>, 
      <-22.800000, -54.700000, 1.000000>, <-19.600000, -56.600000, 1.000000>, <-16.000000, -56.600000, 1.000000>, <-12.650000, -59.950000, 1.000000>, 
      <-22.800000, -54.500000, -1.000000>, <-19.600000, -56.400000, -1.000000>, <-16.000000, -56.400000, -1.000000>, <-12.650000, -59.750000, -1.000000>, 
      <-22.775000, -51.450000, 0.000000>, <-19.550000, -53.350000, 0.000000>, <-15.950000, -53.400000, 0.000000>, <-12.625000, -56.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.775000, -51.450000, 0.000000>, <-19.550000, -53.350000, 0.000000>, <-15.950000, -53.400000, 0.000000>, <-12.625000, -56.725000, 0.000000>, 
      <-22.750000, -48.400000, 1.000000>, <-19.500000, -50.300000, 1.000000>, <-15.900000, -50.400000, 1.000000>, <-12.600000, -53.700000, 1.000000>, 
      <-22.750000, -48.200000, -1.000000>, <-19.500000, -50.100000, -1.000000>, <-16.000000, -50.100000, -1.000000>, <-12.650000, -53.450000, -1.000000>, 
      <-22.725000, -45.100000, 0.000000>, <-19.500000, -46.950000, 0.000000>, <-15.950000, -46.950000, 0.000000>, <-12.600000, -50.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.725000, -45.100000, 0.000000>, <-19.500000, -46.950000, 0.000000>, <-15.950000, -46.950000, 0.000000>, <-12.600000, -50.350000, 0.000000>, 
      <-22.700000, -42.000000, 1.000000>, <-19.500000, -43.800000, 1.000000>, <-15.900000, -43.800000, 1.000000>, <-12.550000, -47.250000, 1.000000>, 
      <-22.700000, -41.800000, -1.000000>, <-19.500000, -43.600000, -1.000000>, <-15.900000, -43.600000, -1.000000>, <-12.550000, -47.050000, -1.000000>, 
      <-22.700000, -38.750000, 0.000000>, <-19.500000, -40.550000, 0.000000>, <-15.900000, -40.600000, 0.000000>, <-12.550000, -44.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.700000, -38.750000, 0.000000>, <-19.500000, -40.550000, 0.000000>, <-15.900000, -40.600000, 0.000000>, <-12.550000, -44.050000, 0.000000>, 
      <-22.700000, -35.700000, 1.000000>, <-19.500000, -37.500000, 1.000000>, <-15.900000, -37.600000, 1.000000>, <-12.550000, -41.050000, 1.000000>, 
      <-22.700000, -35.500000, -1.000000>, <-19.500000, -37.300000, -1.000000>, <-15.900000, -37.400000, -1.000000>, <-12.550000, -40.800000, -1.000000>, 
      <-22.650000, -32.550000, 0.000000>, <-19.450000, -34.400000, 0.000000>, <-15.850000, -34.450000, 0.000000>, <-12.525000, -37.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.650000, -32.550000, 0.000000>, <-19.450000, -34.400000, 0.000000>, <-15.850000, -34.450000, 0.000000>, <-12.525000, -37.825000, 0.000000>, 
      <-22.600000, -29.600000, 1.000000>, <-19.400000, -31.500000, 1.000000>, <-15.800000, -31.500000, 1.000000>, <-12.500000, -34.850000, 1.000000>, 
      <-22.650000, -29.400000, -1.000000>, <-19.400000, -31.300000, -1.000000>, <-15.800000, -31.300000, -1.000000>, <-12.500000, -34.650000, -1.000000>, 
      <-22.103734, -26.426172, 0.041170>, <-18.872787, -28.401015, 0.041170>, <-15.276496, -28.411518, 0.041170>, <-12.213248, -31.680759, 0.020585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.103734, -26.426172, 0.041170>, <-18.872787, -28.401015, 0.041170>, <-15.276496, -28.411518, 0.041170>, <-12.213248, -31.680759, 0.020585>, 
      <-21.557468, -23.452344, 1.082340>, <-18.345573, -25.502030, 1.082340>, <-14.752992, -25.523037, 1.082340>, <-11.926496, -28.711518, 1.041170>, 
      <-21.556215, -23.238012, 1.116721>, <-18.344320, -25.287698, 1.116721>, <-14.751739, -25.308705, 1.116721>, <-11.925869, -28.504352, 0.058361>, 
      <-21.890921, -20.393238, 1.077047>, <-18.679026, -22.442924, 1.077047>, <-15.086445, -22.463930, 1.077047>, <-11.906819, -25.567053, 0.559108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-21.890921, -20.393238, 1.077047>, <-18.679026, -22.442924, 1.077047>, <-15.086445, -22.463930, 1.077047>, <-11.906819, -25.567053, 0.559108>, 
      <-22.225627, -17.548463, 1.037373>, <-19.013733, -19.598149, 1.037373>, <-15.421151, -19.619156, 1.037373>, <-11.887769, -22.629754, 1.059856>, 
      <-22.224374, -17.334131, 1.114652>, <-19.012479, -19.383817, 1.114652>, <-15.419898, -19.404824, 1.114652>, <-11.886515, -22.415422, 1.115686>, 
      <-22.199453, -14.120457, 1.077992>, <-18.987558, -15.857030, 1.077992>, <-15.394977, -15.878037, 1.077992>, <-11.962495, -19.229641, 1.077519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.199453, -14.120457, 1.077992>, <-18.987558, -15.857030, 1.077992>, <-15.394977, -15.878037, 1.077992>, <-11.962495, -19.229641, 1.077519>, 
      <-22.174532, -10.906783, 1.041331>, <-18.962637, -12.330244, 1.041331>, <-15.370056, -12.351250, 1.041331>, <-12.038475, -16.043861, 1.039352>, 
      <-22.173278, -10.692451, 1.142036>, <-18.961384, -12.115912, 1.142036>, <-15.368803, -12.136918, 1.142036>, <-12.037221, -15.829528, 1.128344>, 
      <-22.162774, -7.722431, 1.089704>, <-18.950880, -9.333760, 1.089704>, <-15.358299, -9.354766, 1.089704>, <-12.023113, -12.923840, 1.082858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.162774, -7.722431, 1.089704>, <-18.950880, -9.333760, 1.089704>, <-15.358299, -9.354766, 1.089704>, <-12.023113, -12.923840, 1.082858>, 
      <-22.152271, -4.752412, 1.037373>, <-18.940376, -6.551608, 1.037373>, <-15.347795, -6.572614, 1.037373>, <-12.009005, -10.018152, 1.037373>, 
      <-22.151017, -4.538080, 1.114652>, <-18.939123, -6.337276, 1.114652>, <-15.346542, -6.358282, 1.114652>, <-12.007752, -9.803820, 1.114652>, 
      <-21.780886, -1.387028, 1.098496>, <-18.568992, -3.248847, 1.098496>, <-14.976411, -3.269853, 1.098496>, <-11.716534, -6.652769, 1.098496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-21.780886, -1.387028, 1.098496>, <-18.568992, -3.248847, 1.098496>, <-14.976411, -3.269853, 1.098496>, <-11.716534, -6.652769, 1.098496>, 
      <-21.410755, 1.764023, 1.082340>, <-18.198861, -0.160418, 1.082340>, <-14.606279, -0.181425, 1.082340>, <-11.425315, -3.501718, 1.082340>, 
      <-21.409502, 1.978355, 1.116721>, <-18.197607, 0.053914, 1.116721>, <-14.605026, 0.032908, 1.116721>, <-11.424062, -3.287385, 1.116721>, 
      <-21.904751, 5.014178, 1.058361>, <-18.698804, 3.076957, 1.058361>, <-15.102513, 3.066454, 1.058361>, <-11.663949, -0.256000, 1.078946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-21.904751, 5.014178, 1.058361>, <-18.698804, 3.076957, 1.058361>, <-15.102513, 3.066454, 1.058361>, <-11.663949, -0.256000, 1.078946>, 
      <-22.400000, 8.050000, 1.000000>, <-19.200000, 6.100000, 1.000000>, <-15.600000, 6.100000, 1.000000>, <-11.903837, 2.775385, 1.041170>, 
      <-22.400000, 8.250000, -1.000000>, <-19.200000, 6.300000, -1.000000>, <-15.600000, 6.300000, -1.000000>, <-11.903210, 2.982551, 0.058361>, 
      <-22.400000, 11.275000, 0.000000>, <-19.200000, 9.350000, 0.000000>, <-15.600000, 9.350000, 0.000000>, <-11.894354, 6.022163, 0.549765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.400000, 11.275000, 0.000000>, <-19.200000, 9.350000, 0.000000>, <-15.600000, 9.350000, 0.000000>, <-11.894354, 6.022163, 0.549765>, 
      <-22.400000, 14.300000, 1.000000>, <-19.200000, 12.400000, 1.000000>, <-15.600000, 12.400000, 1.000000>, <-11.885497, 9.061775, 1.041170>, 
      <-22.400000, 14.500000, -1.000000>, <-19.200000, 12.600000, -1.000000>, <-15.600000, 12.600000, -1.000000>, <-11.884871, 9.268941, 0.058361>, 
      <-22.375000, 17.550000, 0.000000>, <-19.150000, 15.650000, 0.000000>, <-15.550000, 15.600000, 0.000000>, <-12.042435, 12.284471, 0.529180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.375000, 17.550000, 0.000000>, <-19.150000, 15.650000, 0.000000>, <-15.550000, 15.600000, 0.000000>, <-12.042435, 12.284471, 0.529180>, 
      <-22.350000, 20.600000, 1.000000>, <-19.100000, 18.700000, 1.000000>, <-15.500000, 18.600000, 1.000000>, <-12.200000, 15.300000, 1.000000>, 
      <-22.350000, 20.800000, -1.000000>, <-19.100000, 18.900000, -1.000000>, <-15.600000, 18.900000, -1.000000>, <-12.250000, 15.550000, -1.000000>, 
      <-22.325000, 23.825000, 0.000000>, <-19.100000, 21.900000, 0.000000>, <-15.550000, 21.900000, 0.000000>, <-12.200000, 18.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.325000, 23.825000, 0.000000>, <-19.100000, 21.900000, 0.000000>, <-15.550000, 21.900000, 0.000000>, <-12.200000, 18.575000, 0.000000>, 
      <-22.300000, 26.850000, 1.000000>, <-19.100000, 24.900000, 1.000000>, <-15.500000, 24.900000, 1.000000>, <-12.150000, 21.600000, 1.000000>, 
      <-22.300000, 27.050000, -1.000000>, <-19.100000, 25.100000, -1.000000>, <-15.500000, 25.100000, -1.000000>, <-12.150000, 21.800000, -1.000000>, 
      <-22.300000, 30.100000, 0.000000>, <-19.100000, 28.150000, 0.000000>, <-15.500000, 28.150000, 0.000000>, <-12.150000, 24.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.300000, 30.100000, 0.000000>, <-19.100000, 28.150000, 0.000000>, <-15.500000, 28.150000, 0.000000>, <-12.150000, 24.825000, 0.000000>, 
      <-22.300000, 33.150000, 1.000000>, <-19.100000, 31.200000, 1.000000>, <-15.500000, 31.200000, 1.000000>, <-12.150000, 27.850000, 1.000000>, 
      <-22.300000, 33.350000, -1.000000>, <-19.100000, 31.400000, -1.000000>, <-15.500000, 31.400000, -1.000000>, <-12.150000, 28.100000, -1.000000>, 
      <-22.400000, 35.625000, 0.000000>, <-19.200000, 33.700000, 0.000000>, <-15.450000, 34.450000, 0.000000>, <-12.175000, 31.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.400000, 35.625000, 0.000000>, <-19.200000, 33.700000, 0.000000>, <-15.450000, 34.450000, 0.000000>, <-12.175000, 31.325000, 0.000000>, 
      <-22.500000, 37.900000, 1.000000>, <-19.300000, 36.000000, 1.000000>, <-15.400000, 37.500000, 1.000000>, <-12.200000, 34.550000, 1.000000>, 
      <-22.500000, 38.100000, -1.000000>, <-19.300000, 36.200000, -1.000000>, <-15.400000, 37.700000, -1.000000>, <-12.200000, 34.750000, -1.000000>, 
      <-22.275000, 41.650000, 0.000000>, <-19.050000, 39.750000, 0.000000>, <-15.300000, 40.500000, 0.000000>, <-12.075000, 37.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.275000, 41.650000, 0.000000>, <-19.050000, 39.750000, 0.000000>, <-15.300000, 40.500000, 0.000000>, <-12.075000, 37.475000, 0.000000>, 
      <-22.050000, 45.200000, 1.000000>, <-18.800000, 43.300000, 1.000000>, <-15.200000, 43.300000, 1.000000>, <-11.950000, 40.200000, 1.000000>, 
      <-22.050000, 45.450000, -1.000000>, <-18.800000, 43.500000, -1.000000>, <-15.300000, 43.500000, -1.000000>, <-12.000000, 40.400000, -1.000000>, 
      <-22.025000, 48.475000, 0.000000>, <-18.800000, 46.550000, 0.000000>, <-15.250000, 46.500000, 0.000000>, <-11.925000, 43.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.025000, 48.475000, 0.000000>, <-18.800000, 46.550000, 0.000000>, <-15.250000, 46.500000, 0.000000>, <-11.925000, 43.300000, 0.000000>, 
      <-22.000000, 51.500000, 1.000000>, <-18.800000, 49.600000, 1.000000>, <-15.200000, 49.500000, 1.000000>, <-11.850000, 46.200000, 1.000000>, 
      <-22.000000, 51.700000, -1.000000>, <-18.800000, 49.800000, -1.000000>, <-15.200000, 49.700000, -1.000000>, <-11.850000, 46.400000, -1.000000>, 
      <-22.000000, 54.350000, 0.000000>, <-18.800000, 52.450000, 0.000000>, <-15.200000, 52.400000, 0.000000>, <-11.850000, 49.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.000000, 54.350000, 0.000000>, <-18.800000, 52.450000, 0.000000>, <-15.200000, 52.400000, 0.000000>, <-11.850000, 49.075000, 0.000000>, 
      <-22.000000, 57.000000, 1.000000>, <-18.800000, 55.100000, 1.000000>, <-15.200000, 55.100000, 1.000000>, <-11.850000, 51.750000, 1.000000>, 
      <-22.000000, 57.200000, -1.000000>, <-18.800000, 55.300000, -1.000000>, <-15.200000, 55.300000, -1.000000>, <-11.850000, 51.950000, -1.000000>, 
      <-22.025000, 60.350000, 0.000000>, <-18.750000, 58.350000, 0.000000>, <-15.150000, 58.300000, 0.000000>, <-11.825000, 54.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-22.025000, 60.350000, 0.000000>, <-18.750000, 58.350000, 0.000000>, <-15.150000, 58.300000, 0.000000>, <-11.825000, 54.975000, 0.000000>, 
      <-22.050000, 63.500000, 1.000000>, <-18.700000, 61.400000, 1.000000>, <-15.100000, 61.300000, 1.000000>, <-11.800000, 58.000000, 1.000000>, 
      <-22.050000, 63.700000, -1.000000>, <-18.700000, 61.600000, -1.000000>, <-15.100000, 61.500000, -1.000000>, <-11.800000, 58.200000, -1.000000>, 
      <-21.900000, 68.100000, 0.700000>, <-18.700000, 65.500000, 0.700000>, <-15.100000, 65.400000, 0.700000>, <-11.750000, 62.100000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-13.050000, -126.650000, -1.000000>, <-9.700000, -130.000000, -1.000000>, <-5.100000, -133.800000, -1.000000>, <-1.500000, -133.800000, -1.000000>, 
      <-13.000000, -122.700000, 1.000000>, <-9.700000, -126.000000, 1.000000>, <-5.100000, -129.800000, 1.000000>, <-1.500000, -129.850000, 1.000000>, 
      <-13.050000, -122.450000, -1.000000>, <-9.700000, -125.800000, -1.000000>, <-5.100000, -129.600000, -1.000000>, <-1.500000, -129.650000, -1.000000>, 
      <-13.000000, -119.425000, 0.000000>, <-9.650000, -122.750000, 0.000000>, <-5.050000, -126.600000, 0.000000>, <-1.450000, -126.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-13.000000, -119.425000, 0.000000>, <-9.650000, -122.750000, 0.000000>, <-5.050000, -126.600000, 0.000000>, <-1.450000, -126.625000, 0.000000>, 
      <-12.950000, -116.400000, 1.000000>, <-9.600000, -119.700000, 1.000000>, <-5.000000, -123.600000, 1.000000>, <-1.400000, -123.600000, 1.000000>, 
      <-12.950000, -116.200000, -1.000000>, <-9.600000, -119.500000, -1.000000>, <-5.000000, -123.300000, -1.000000>, <-1.450000, -123.350000, -1.000000>, 
      <-12.950000, -113.175000, 0.000000>, <-9.600000, -116.500000, 0.000000>, <-5.000000, -120.300000, 0.000000>, <-1.425000, -120.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.950000, -113.175000, 0.000000>, <-9.600000, -116.500000, 0.000000>, <-5.000000, -120.300000, 0.000000>, <-1.425000, -120.325000, 0.000000>, 
      <-12.950000, -110.150000, 1.000000>, <-9.600000, -113.500000, 1.000000>, <-5.000000, -117.300000, 1.000000>, <-1.400000, -117.300000, 1.000000>, 
      <-12.950000, -109.900000, -1.000000>, <-9.600000, -113.200000, -1.000000>, <-5.000000, -117.100000, -1.000000>, <-1.400000, -117.100000, -1.000000>, 
      <-12.925000, -106.875000, 0.000000>, <-9.600000, -110.200000, 0.000000>, <-4.950000, -114.050000, 0.000000>, <-1.375000, -114.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.925000, -106.875000, 0.000000>, <-9.600000, -110.200000, 0.000000>, <-4.950000, -114.050000, 0.000000>, <-1.375000, -114.075000, 0.000000>, 
      <-12.900000, -103.850000, 1.000000>, <-9.600000, -107.200000, 1.000000>, <-4.900000, -111.000000, 1.000000>, <-1.350000, -111.050000, 1.000000>, 
      <-12.900000, -103.650000, -1.000000>, <-9.600000, -107.000000, -1.000000>, <-5.000000, -110.800000, -1.000000>, <-1.400000, -110.800000, -1.000000>, 
      <-12.875000, -100.625000, 0.000000>, <-9.550000, -103.950000, 0.000000>, <-4.950000, -107.750000, 0.000000>, <-1.350000, -107.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.875000, -100.625000, 0.000000>, <-9.550000, -103.950000, 0.000000>, <-4.950000, -107.750000, 0.000000>, <-1.350000, -107.775000, 0.000000>, 
      <-12.850000, -97.600000, 1.000000>, <-9.500000, -100.900000, 1.000000>, <-4.900000, -104.700000, 1.000000>, <-1.300000, -104.750000, 1.000000>, 
      <-12.850000, -97.400000, -1.000000>, <-9.500000, -100.700000, -1.000000>, <-4.900000, -104.500000, -1.000000>, <-1.300000, -104.550000, -1.000000>, 
      <-12.850000, -94.350000, 0.000000>, <-9.500000, -97.650000, 0.000000>, <-4.900000, -101.500000, 0.000000>, <-1.300000, -101.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.850000, -94.350000, 0.000000>, <-9.500000, -97.650000, 0.000000>, <-4.900000, -101.500000, 0.000000>, <-1.300000, -101.525000, 0.000000>, 
      <-12.850000, -91.300000, 1.000000>, <-9.500000, -94.600000, 1.000000>, <-4.900000, -98.500000, 1.000000>, <-1.300000, -98.500000, 1.000000>, 
      <-12.850000, -91.100000, -1.000000>, <-9.500000, -94.400000, -1.000000>, <-4.900000, -98.300000, -1.000000>, <-1.300000, -98.300000, -1.000000>, 
      <-12.800000, -88.075000, 0.000000>, <-9.450000, -91.400000, 0.000000>, <-4.850000, -95.250000, 0.000000>, <-1.275000, -95.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.800000, -88.075000, 0.000000>, <-9.450000, -91.400000, 0.000000>, <-4.850000, -95.250000, 0.000000>, <-1.275000, -95.250000, 0.000000>, 
      <-12.750000, -85.050000, 1.000000>, <-9.400000, -88.400000, 1.000000>, <-4.800000, -92.200000, 1.000000>, <-1.250000, -92.200000, 1.000000>, 
      <-12.800000, -84.850000, -1.000000>, <-9.500000, -88.200000, -1.000000>, <-4.900000, -92.000000, -1.000000>, <-1.300000, -92.000000, -1.000000>, 
      <-12.775000, -81.825000, 0.000000>, <-9.450000, -85.150000, 0.000000>, <-4.850000, -88.950000, 0.000000>, <-1.250000, -88.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.775000, -81.825000, 0.000000>, <-9.450000, -85.150000, 0.000000>, <-4.850000, -88.950000, 0.000000>, <-1.250000, -88.975000, 0.000000>, 
      <-12.750000, -78.800000, 1.000000>, <-9.400000, -82.100000, 1.000000>, <-4.800000, -85.900000, 1.000000>, <-1.200000, -85.950000, 1.000000>, 
      <-12.750000, -78.550000, -1.000000>, <-9.400000, -81.900000, -1.000000>, <-4.800000, -85.700000, -1.000000>, <-1.200000, -85.750000, -1.000000>, 
      <-12.750000, -75.525000, 0.000000>, <-9.400000, -78.850000, 0.000000>, <-4.800000, -82.700000, 0.000000>, <-1.200000, -82.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.750000, -75.525000, 0.000000>, <-9.400000, -78.850000, 0.000000>, <-4.800000, -82.700000, 0.000000>, <-1.200000, -82.725000, 0.000000>, 
      <-12.750000, -72.500000, 1.000000>, <-9.400000, -75.800000, 1.000000>, <-4.800000, -79.700000, 1.000000>, <-1.200000, -79.700000, 1.000000>, 
      <-12.750000, -72.300000, -1.000000>, <-9.400000, -75.600000, -1.000000>, <-4.800000, -79.400000, -1.000000>, <-1.200000, -79.450000, -1.000000>, 
      <-12.700000, -69.250000, 0.000000>, <-9.350000, -72.550000, 0.000000>, <-4.750000, -76.400000, 0.000000>, <-1.150000, -76.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.700000, -69.250000, 0.000000>, <-9.350000, -72.550000, 0.000000>, <-4.750000, -76.400000, 0.000000>, <-1.150000, -76.425000, 0.000000>, 
      <-12.650000, -66.200000, 1.000000>, <-9.300000, -69.500000, 1.000000>, <-4.700000, -73.400000, 1.000000>, <-1.100000, -73.400000, 1.000000>, 
      <-12.700000, -66.000000, -1.000000>, <-9.400000, -69.300000, -1.000000>, <-4.700000, -73.200000, -1.000000>, <-1.150000, -73.200000, -1.000000>, 
      <-12.675000, -62.975000, 0.000000>, <-9.350000, -66.300000, 0.000000>, <-4.700000, -70.150000, 0.000000>, <-1.125000, -70.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.675000, -62.975000, 0.000000>, <-9.350000, -66.300000, 0.000000>, <-4.700000, -70.150000, 0.000000>, <-1.125000, -70.150000, 0.000000>, 
      <-12.650000, -59.950000, 1.000000>, <-9.300000, -63.300000, 1.000000>, <-4.700000, -67.100000, 1.000000>, <-1.100000, -67.100000, 1.000000>, 
      <-12.650000, -59.750000, -1.000000>, <-9.300000, -63.100000, -1.000000>, <-4.700000, -66.900000, -1.000000>, <-1.100000, -66.900000, -1.000000>, 
      <-12.625000, -56.725000, 0.000000>, <-9.300000, -60.050000, 0.000000>, <-4.700000, -63.850000, 0.000000>, <-1.100000, -63.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.625000, -56.725000, 0.000000>, <-9.300000, -60.050000, 0.000000>, <-4.700000, -63.850000, 0.000000>, <-1.100000, -63.875000, 0.000000>, 
      <-12.600000, -53.700000, 1.000000>, <-9.300000, -57.000000, 1.000000>, <-4.700000, -60.800000, 1.000000>, <-1.100000, -60.850000, 1.000000>, 
      <-12.650000, -53.450000, -1.000000>, <-9.300000, -56.800000, -1.000000>, <-4.700000, -60.600000, -1.000000>, <-1.100000, -60.650000, -1.000000>, 
      <-12.600000, -50.350000, 0.000000>, <-9.250000, -53.750000, 0.000000>, <-4.650000, -57.600000, 0.000000>, <-1.050000, -57.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.600000, -50.350000, 0.000000>, <-9.250000, -53.750000, 0.000000>, <-4.650000, -57.600000, 0.000000>, <-1.050000, -57.625000, 0.000000>, 
      <-12.550000, -47.250000, 1.000000>, <-9.200000, -50.700000, 1.000000>, <-4.600000, -54.600000, 1.000000>, <-1.000000, -54.600000, 1.000000>, 
      <-12.550000, -47.050000, -1.000000>, <-9.200000, -50.500000, -1.000000>, <-4.600000, -54.300000, -1.000000>, <-1.000000, -54.350000, -1.000000>, 
      <-12.550000, -44.050000, 0.000000>, <-9.200000, -47.500000, 0.000000>, <-4.600000, -51.300000, 0.000000>, <-1.000000, -51.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.550000, -44.050000, 0.000000>, <-9.200000, -47.500000, 0.000000>, <-4.600000, -51.300000, 0.000000>, <-1.000000, -51.325000, 0.000000>, 
      <-12.550000, -41.050000, 1.000000>, <-9.200000, -44.500000, 1.000000>, <-4.600000, -48.300000, 1.000000>, <-1.000000, -48.300000, 1.000000>, 
      <-12.550000, -40.800000, -1.000000>, <-9.200000, -44.200000, -1.000000>, <-4.600000, -48.100000, -1.000000>, <-1.000000, -48.100000, -1.000000>, 
      <-12.525000, -37.825000, 0.000000>, <-9.200000, -41.200000, 0.000000>, <-4.550000, -45.050000, 0.000000>, <-0.975000, -45.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.525000, -37.825000, 0.000000>, <-9.200000, -41.200000, 0.000000>, <-4.550000, -45.050000, 0.000000>, <-0.975000, -45.075000, 0.000000>, 
      <-12.500000, -34.850000, 1.000000>, <-9.200000, -38.200000, 1.000000>, <-4.500000, -42.000000, 1.000000>, <-0.950000, -42.050000, 1.000000>, 
      <-12.500000, -34.650000, -1.000000>, <-9.200000, -38.000000, -1.000000>, <-4.600000, -41.800000, -1.000000>, <-1.000000, -41.800000, -1.000000>, 
      <-12.213248, -31.680759, 0.020585>, <-9.150000, -34.950000, 0.000000>, <-4.550000, -38.750000, 0.000000>, <-0.950000, -38.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.213248, -31.680759, 0.020585>, <-9.150000, -34.950000, 0.000000>, <-4.550000, -38.750000, 0.000000>, <-0.950000, -38.775000, 0.000000>, 
      <-11.926496, -28.711518, 1.041170>, <-9.100000, -31.900000, 1.000000>, <-4.500000, -35.700000, 1.000000>, <-0.900000, -35.750000, 1.000000>, 
      <-11.925869, -28.504352, 0.058361>, <-9.100000, -31.700000, -1.000000>, <-4.500000, -35.500000, -1.000000>, <-0.900000, -35.550000, -1.000000>, 
      <-11.906819, -25.567053, 0.559108>, <-8.727193, -28.670176, 0.041170>, <-4.500000, -32.500000, 0.000000>, <-0.900000, -32.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.906819, -25.567053, 0.559108>, <-8.727193, -28.670176, 0.041170>, <-4.500000, -32.500000, 0.000000>, <-0.900000, -32.525000, 0.000000>, 
      <-11.887769, -22.629754, 1.059856>, <-8.354386, -25.640352, 1.082340>, <-4.500000, -29.500000, 1.000000>, <-0.900000, -29.500000, 1.000000>, 
      <-11.886515, -22.415422, 1.115686>, <-8.353133, -25.426020, 1.116721>, <-4.500000, -29.300000, -1.000000>, <-0.900000, -29.300000, -1.000000>, 
      <-11.962495, -19.229641, 1.077519>, <-8.530013, -22.581245, 1.077047>, <-3.947155, -26.247724, 0.041170>, <-0.350864, -26.258227, 0.041170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.962495, -19.229641, 1.077519>, <-8.530013, -22.581245, 1.077047>, <-3.947155, -26.247724, 0.041170>, <-0.350864, -26.258227, 0.041170>, 
      <-12.038475, -16.043861, 1.039352>, <-8.706893, -19.736471, 1.037373>, <-3.394310, -23.195447, 1.082340>, <0.198272, -23.216454, 1.082340>, 
      <-12.037221, -15.829528, 1.128344>, <-8.705640, -19.522139, 1.114652>, <-3.393056, -22.981115, 1.116721>, <0.199525, -23.002121, 1.116721>, 
      <-12.023113, -12.923840, 1.082858>, <-8.687928, -16.492915, 1.076012>, <-3.896528, -19.940557, 1.058361>, <-0.300238, -19.976061, 1.058361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.023113, -12.923840, 1.082858>, <-8.687928, -16.492915, 1.076012>, <-3.896528, -19.940557, 1.058361>, <-0.300238, -19.976061, 1.058361>, 
      <-12.009005, -10.018152, 1.037373>, <-8.670215, -13.463691, 1.037373>, <-4.400000, -16.900000, 1.000000>, <-0.800000, -16.950000, 1.000000>, 
      <-12.007752, -9.803820, 1.114652>, <-8.668962, -13.249358, 1.114652>, <-4.400000, -16.700000, -1.000000>, <-0.800000, -16.750000, -1.000000>, 
      <-11.716534, -6.652769, 1.098496>, <-8.456657, -10.035684, 1.098496>, <-3.860477, -13.674943, 0.041170>, <-0.264186, -13.710446, 0.041170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.716534, -6.652769, 1.098496>, <-8.456657, -10.035684, 1.098496>, <-3.860477, -13.674943, 0.041170>, <-0.264186, -13.710446, 0.041170>, 
      <-11.425315, -3.501718, 1.082340>, <-8.244351, -6.822011, 1.082340>, <-3.320953, -10.649886, 1.082340>, <0.271628, -10.670893, 1.082340>, 
      <-11.424062, -3.287385, 1.116721>, <-8.243098, -6.607678, 1.116721>, <-3.319700, -10.435554, 1.116721>, <0.272881, -10.456560, 1.116721>, 
      <-11.663949, -0.256000, 1.078946>, <-8.225386, -3.578454, 1.099530>, <-3.459813, -7.406330, 1.099530>, <-0.038541, -7.422557, 1.078946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.663949, -0.256000, 1.078946>, <-8.225386, -3.578454, 1.099530>, <-3.459813, -7.406330, 1.099530>, <-0.038541, -7.422557, 1.078946>, 
      <-11.903837, 2.775385, 1.041170>, <-8.207673, -0.549230, 1.082340>, <-3.599927, -4.377105, 1.082340>, <-0.349963, -4.388553, 1.041170>, 
      <-11.903210, 2.982551, 0.058361>, <-8.206420, -0.334898, 1.116721>, <-3.598674, -4.162773, 1.116721>, <-0.399337, -4.181387, 0.058361>, 
      <-11.894354, 6.022163, 0.549765>, <-8.188707, 2.694326, 1.099530>, <-3.580961, -1.133549, 1.099530>, <-0.365481, -1.141775, 0.549765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.894354, 6.022163, 0.549765>, <-8.188707, 2.694326, 1.099530>, <-3.580961, -1.133549, 1.099530>, <-0.365481, -1.141775, 0.549765>, 
      <-11.885497, 9.061775, 1.041170>, <-8.170995, 5.723551, 1.082340>, <-3.563249, 1.895675, 1.082340>, <-0.331624, 1.897838, 1.041170>, 
      <-11.884871, 9.268941, 0.058361>, <-8.169742, 5.937883, 1.116721>, <-3.561995, 2.110007, 1.116721>, <-0.330998, 2.105004, 0.058361>, 
      <-12.042435, 12.284471, 0.529180>, <-8.534871, 8.968941, 1.058361>, <-3.930998, 5.155004, 1.058361>, <-0.515499, 5.127502, 0.529180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.042435, 12.284471, 0.529180>, <-8.534871, 8.968941, 1.058361>, <-3.930998, 5.155004, 1.058361>, <-0.515499, 5.127502, 0.529180>, 
      <-12.200000, 15.300000, 1.000000>, <-8.900000, 12.000000, 1.000000>, <-4.300000, 8.200000, 1.000000>, <-0.700000, 8.150000, 1.000000>, 
      <-12.250000, 15.550000, -1.000000>, <-8.900000, 12.200000, -1.000000>, <-4.300000, 8.400000, -1.000000>, <-0.700000, 8.350000, -1.000000>, 
      <-12.200000, 18.575000, 0.000000>, <-8.850000, 15.250000, 0.000000>, <-4.250000, 11.400000, 0.000000>, <-0.650000, 11.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.200000, 18.575000, 0.000000>, <-8.850000, 15.250000, 0.000000>, <-4.250000, 11.400000, 0.000000>, <-0.650000, 11.375000, 0.000000>, 
      <-12.150000, 21.600000, 1.000000>, <-8.800000, 18.300000, 1.000000>, <-4.200000, 14.400000, 1.000000>, <-0.600000, 14.400000, 1.000000>, 
      <-12.150000, 21.800000, -1.000000>, <-8.800000, 18.500000, -1.000000>, <-4.200000, 14.700000, -1.000000>, <-0.600000, 14.650000, -1.000000>, 
      <-12.150000, 24.825000, 0.000000>, <-8.800000, 21.500000, 0.000000>, <-4.200000, 17.700000, 0.000000>, <-0.600000, 17.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.150000, 24.825000, 0.000000>, <-8.800000, 21.500000, 0.000000>, <-4.200000, 17.700000, 0.000000>, <-0.600000, 17.675000, 0.000000>, 
      <-12.150000, 27.850000, 1.000000>, <-8.800000, 24.500000, 1.000000>, <-4.200000, 20.700000, 1.000000>, <-0.600000, 20.700000, 1.000000>, 
      <-12.150000, 28.100000, -1.000000>, <-8.800000, 24.800000, -1.000000>, <-4.200000, 20.900000, -1.000000>, <-0.600000, 20.900000, -1.000000>, 
      <-12.175000, 31.325000, 0.000000>, <-8.900000, 28.200000, 0.000000>, <-4.300000, 24.300000, 0.000000>, <-0.650000, 24.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.175000, 31.325000, 0.000000>, <-8.900000, 28.200000, 0.000000>, <-4.300000, 24.300000, 0.000000>, <-0.650000, 24.100000, 0.000000>, 
      <-12.200000, 34.550000, 1.000000>, <-9.000000, 31.600000, 1.000000>, <-4.400000, 27.700000, 1.000000>, <-0.700000, 27.300000, 1.000000>, 
      <-12.200000, 34.750000, -1.000000>, <-9.000000, 31.800000, -1.000000>, <-4.400000, 28.000000, -1.000000>, <-0.700000, 27.600000, -1.000000>, 
      <-12.075000, 37.475000, 0.000000>, <-8.850000, 34.450000, 0.000000>, <-4.250000, 30.650000, 0.000000>, <-0.600000, 30.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.075000, 37.475000, 0.000000>, <-8.850000, 34.450000, 0.000000>, <-4.250000, 30.650000, 0.000000>, <-0.600000, 30.425000, 0.000000>, 
      <-11.950000, 40.200000, 1.000000>, <-8.700000, 37.100000, 1.000000>, <-4.100000, 33.300000, 1.000000>, <-0.500000, 33.250000, 1.000000>, 
      <-12.000000, 40.400000, -1.000000>, <-8.700000, 37.300000, -1.000000>, <-4.100000, 33.500000, -1.000000>, <-0.500000, 33.450000, -1.000000>, 
      <-11.925000, 43.300000, 0.000000>, <-8.600000, 40.100000, 0.000000>, <-4.100000, 36.900000, 0.000000>, <-0.500000, 36.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.925000, 43.300000, 0.000000>, <-8.600000, 40.100000, 0.000000>, <-4.100000, 36.900000, 0.000000>, <-0.500000, 36.675000, 0.000000>, 
      <-11.850000, 46.200000, 1.000000>, <-8.500000, 42.900000, 1.000000>, <-4.100000, 40.300000, 1.000000>, <-0.500000, 39.900000, 1.000000>, 
      <-11.850000, 46.400000, -1.000000>, <-8.500000, 43.100000, -1.000000>, <-3.900000, 40.000000, -1.000000>, <-0.400000, 39.850000, -1.000000>, 
      <-11.850000, 49.075000, 0.000000>, <-8.500000, 45.750000, 0.000000>, <-3.900000, 43.600000, 0.000000>, <-0.350000, 43.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.850000, 49.075000, 0.000000>, <-8.500000, 45.750000, 0.000000>, <-3.900000, 43.600000, 0.000000>, <-0.350000, 43.525000, 0.000000>, 
      <-11.850000, 51.750000, 1.000000>, <-8.500000, 48.400000, 1.000000>, <-3.900000, 47.200000, 1.000000>, <-0.300000, 47.200000, 1.000000>, 
      <-11.850000, 51.950000, -1.000000>, <-8.500000, 48.600000, -1.000000>, <-3.900000, 47.500000, -1.000000>, <-0.300000, 47.450000, -1.000000>, 
      <-11.825000, 54.975000, 0.000000>, <-8.500000, 51.650000, 0.000000>, <-3.850000, 49.950000, 0.000000>, <-0.275000, 49.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.825000, 54.975000, 0.000000>, <-8.500000, 51.650000, 0.000000>, <-3.850000, 49.950000, 0.000000>, <-0.275000, 49.925000, 0.000000>, 
      <-11.800000, 58.000000, 1.000000>, <-8.500000, 54.700000, 1.000000>, <-3.800000, 52.400000, 1.000000>, <-0.250000, 52.400000, 1.000000>, 
      <-11.800000, 58.200000, -1.000000>, <-8.500000, 54.900000, -1.000000>, <-3.900000, 52.600000, -1.000000>, <-0.300000, 52.600000, -1.000000>, 
      <-11.750000, 62.100000, 0.700000>, <-8.400000, 58.800000, 0.700000>, <-3.800000, 57.600000, 0.700000>, <-0.200000, 57.600000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, -133.800000, -1.000000>, <2.100000, -133.800000, -1.000000>, <8.200000, -142.500000, -1.000000>, <10.550000, -142.400000, -1.000000>, 
      <-1.500000, -129.850000, 1.000000>, <2.100000, -129.900000, 1.000000>, <8.300000, -138.500000, 1.000000>, <10.600000, -138.400000, 1.000000>, 
      <-1.500000, -129.650000, -1.000000>, <2.100000, -129.700000, -1.000000>, <8.200000, -138.300000, -1.000000>, <10.550000, -138.200000, -1.000000>, 
      <-1.450000, -126.625000, 0.000000>, <2.150000, -126.650000, 0.000000>, <8.250000, -135.300000, 0.000000>, <10.575000, -135.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.450000, -126.625000, 0.000000>, <2.150000, -126.650000, 0.000000>, <8.250000, -135.300000, 0.000000>, <10.575000, -135.175000, 0.000000>, 
      <-1.400000, -123.600000, 1.000000>, <2.200000, -123.600000, 1.000000>, <8.300000, -132.300000, 1.000000>, <10.600000, -132.150000, 1.000000>, 
      <-1.450000, -123.350000, -1.000000>, <2.100000, -123.400000, -1.000000>, <8.300000, -132.000000, -1.000000>, <10.600000, -131.900000, -1.000000>, 
      <-1.425000, -120.325000, 0.000000>, <2.150000, -120.350000, 0.000000>, <8.300000, -129.000000, 0.000000>, <10.625000, -128.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.425000, -120.325000, 0.000000>, <2.150000, -120.350000, 0.000000>, <8.300000, -129.000000, 0.000000>, <10.625000, -128.900000, 0.000000>, 
      <-1.400000, -117.300000, 1.000000>, <2.200000, -117.300000, 1.000000>, <8.300000, -126.000000, 1.000000>, <10.650000, -125.900000, 1.000000>, 
      <-1.400000, -117.100000, -1.000000>, <2.200000, -117.100000, -1.000000>, <8.300000, -125.800000, -1.000000>, <10.650000, -125.700000, -1.000000>, 
      <-1.375000, -114.075000, 0.000000>, <2.200000, -114.100000, 0.000000>, <8.350000, -122.750000, 0.000000>, <10.675000, -122.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.375000, -114.075000, 0.000000>, <2.200000, -114.100000, 0.000000>, <8.350000, -122.750000, 0.000000>, <10.675000, -122.650000, 0.000000>, 
      <-1.350000, -111.050000, 1.000000>, <2.200000, -111.100000, 1.000000>, <8.400000, -119.700000, 1.000000>, <10.700000, -119.600000, 1.000000>, 
      <-1.400000, -110.800000, -1.000000>, <2.200000, -110.800000, -1.000000>, <8.400000, -119.500000, -1.000000>, <10.700000, -119.400000, -1.000000>, 
      <-1.350000, -107.775000, 0.000000>, <2.250000, -107.800000, 0.000000>, <8.400000, -116.450000, 0.000000>, <10.725000, -116.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.350000, -107.775000, 0.000000>, <2.250000, -107.800000, 0.000000>, <8.400000, -116.450000, 0.000000>, <10.725000, -116.350000, 0.000000>, 
      <-1.300000, -104.750000, 1.000000>, <2.300000, -104.800000, 1.000000>, <8.400000, -113.400000, 1.000000>, <10.750000, -113.300000, 1.000000>, 
      <-1.300000, -104.550000, -1.000000>, <2.300000, -104.600000, -1.000000>, <8.400000, -113.200000, -1.000000>, <10.700000, -113.100000, -1.000000>, 
      <-1.300000, -101.525000, 0.000000>, <2.300000, -101.550000, 0.000000>, <8.400000, -110.200000, 0.000000>, <10.725000, -110.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.300000, -101.525000, 0.000000>, <2.300000, -101.550000, 0.000000>, <8.400000, -110.200000, 0.000000>, <10.725000, -110.075000, 0.000000>, 
      <-1.300000, -98.500000, 1.000000>, <2.300000, -98.500000, 1.000000>, <8.400000, -107.200000, 1.000000>, <10.750000, -107.050000, 1.000000>, 
      <-1.300000, -98.300000, -1.000000>, <2.300000, -98.300000, -1.000000>, <8.400000, -106.900000, -1.000000>, <10.750000, -106.800000, -1.000000>, 
      <-1.275000, -95.250000, 0.000000>, <2.300000, -95.250000, 0.000000>, <8.450000, -103.900000, 0.000000>, <10.775000, -103.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.275000, -95.250000, 0.000000>, <2.300000, -95.250000, 0.000000>, <8.450000, -103.900000, 0.000000>, <10.775000, -103.800000, 0.000000>, 
      <-1.250000, -92.200000, 1.000000>, <2.300000, -92.200000, 1.000000>, <8.500000, -100.900000, 1.000000>, <10.800000, -100.800000, 1.000000>, 
      <-1.300000, -92.000000, -1.000000>, <2.300000, -92.000000, -1.000000>, <8.500000, -100.700000, -1.000000>, <10.800000, -100.600000, -1.000000>, 
      <-1.250000, -88.975000, 0.000000>, <2.350000, -89.000000, 0.000000>, <8.500000, -97.650000, 0.000000>, <10.825000, -97.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.250000, -88.975000, 0.000000>, <2.350000, -89.000000, 0.000000>, <8.500000, -97.650000, 0.000000>, <10.825000, -97.550000, 0.000000>, 
      <-1.200000, -85.950000, 1.000000>, <2.400000, -86.000000, 1.000000>, <8.500000, -94.600000, 1.000000>, <10.850000, -94.500000, 1.000000>, 
      <-1.200000, -85.750000, -1.000000>, <2.400000, -85.800000, -1.000000>, <8.500000, -94.400000, -1.000000>, <10.800000, -94.300000, -1.000000>, 
      <-1.200000, -82.725000, 0.000000>, <2.400000, -82.750000, 0.000000>, <8.550000, -91.350000, 0.000000>, <10.850000, -91.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.200000, -82.725000, 0.000000>, <2.400000, -82.750000, 0.000000>, <8.550000, -91.350000, 0.000000>, <10.850000, -91.250000, 0.000000>, 
      <-1.200000, -79.700000, 1.000000>, <2.400000, -79.700000, 1.000000>, <8.600000, -88.300000, 1.000000>, <10.900000, -88.200000, 1.000000>, 
      <-1.200000, -79.450000, -1.000000>, <2.400000, -79.500000, -1.000000>, <8.500000, -88.100000, -1.000000>, <10.850000, -88.000000, -1.000000>, 
      <-1.150000, -76.425000, 0.000000>, <2.450000, -76.450000, 0.000000>, <8.550000, -85.100000, 0.000000>, <10.875000, -85.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.150000, -76.425000, 0.000000>, <2.450000, -76.450000, 0.000000>, <8.550000, -85.100000, 0.000000>, <10.875000, -85.000000, 0.000000>, 
      <-1.100000, -73.400000, 1.000000>, <2.500000, -73.400000, 1.000000>, <8.600000, -82.100000, 1.000000>, <10.900000, -82.000000, 1.000000>, 
      <-1.150000, -73.200000, -1.000000>, <2.400000, -73.200000, -1.000000>, <8.600000, -81.900000, -1.000000>, <10.900000, -81.750000, -1.000000>, 
      <-1.125000, -70.150000, 0.000000>, <2.450000, -70.150000, 0.000000>, <8.600000, -78.850000, 0.000000>, <10.925000, -78.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.125000, -70.150000, 0.000000>, <2.450000, -70.150000, 0.000000>, <8.600000, -78.850000, 0.000000>, <10.925000, -78.725000, 0.000000>, 
      <-1.100000, -67.100000, 1.000000>, <2.500000, -67.100000, 1.000000>, <8.600000, -75.800000, 1.000000>, <10.950000, -75.700000, 1.000000>, 
      <-1.100000, -66.900000, -1.000000>, <2.500000, -66.900000, -1.000000>, <8.600000, -75.600000, -1.000000>, <10.950000, -75.500000, -1.000000>, 
      <-1.100000, -63.875000, 0.000000>, <2.500000, -63.900000, 0.000000>, <8.650000, -72.550000, 0.000000>, <10.975000, -72.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.100000, -63.875000, 0.000000>, <2.500000, -63.900000, 0.000000>, <8.650000, -72.550000, 0.000000>, <10.975000, -72.450000, 0.000000>, 
      <-1.100000, -60.850000, 1.000000>, <2.500000, -60.900000, 1.000000>, <8.700000, -69.500000, 1.000000>, <11.000000, -69.400000, 1.000000>, 
      <-1.100000, -60.650000, -1.000000>, <2.500000, -60.700000, -1.000000>, <8.600000, -69.300000, -1.000000>, <10.950000, -69.200000, -1.000000>, 
      <-1.050000, -57.625000, 0.000000>, <2.550000, -57.650000, 0.000000>, <8.250000, -66.150000, 0.000000>, <10.925000, -66.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.050000, -57.625000, 0.000000>, <2.550000, -57.650000, 0.000000>, <8.250000, -66.150000, 0.000000>, <10.925000, -66.375000, 0.000000>, 
      <-1.000000, -54.600000, 1.000000>, <2.600000, -54.600000, 1.000000>, <7.900000, -63.000000, 1.000000>, <10.900000, -63.550000, 1.000000>, 
      <-1.000000, -54.350000, -1.000000>, <2.600000, -54.400000, -1.000000>, <7.900000, -62.800000, -1.000000>, <10.850000, -63.300000, -1.000000>, 
      <-1.000000, -51.325000, 0.000000>, <2.600000, -51.350000, 0.000000>, <7.950000, -59.750000, 0.000000>, <10.900000, -60.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -51.325000, 0.000000>, <2.600000, -51.350000, 0.000000>, <7.950000, -59.750000, 0.000000>, <10.900000, -60.275000, 0.000000>, 
      <-1.000000, -48.300000, 1.000000>, <2.600000, -48.300000, 1.000000>, <8.000000, -56.700000, 1.000000>, <10.950000, -57.250000, 1.000000>, 
      <-1.000000, -48.100000, -1.000000>, <2.600000, -48.100000, -1.000000>, <8.000000, -56.500000, -1.000000>, <10.950000, -57.050000, -1.000000>, 
      <-0.975000, -45.075000, 0.000000>, <2.600000, -45.100000, 0.000000>, <8.000000, -53.500000, 0.000000>, <10.950000, -54.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.975000, -45.075000, 0.000000>, <2.600000, -45.100000, 0.000000>, <8.000000, -53.500000, 0.000000>, <10.950000, -54.025000, 0.000000>, 
      <-0.950000, -42.050000, 1.000000>, <2.600000, -42.100000, 1.000000>, <8.000000, -50.500000, 1.000000>, <10.950000, -51.000000, 1.000000>, 
      <-1.000000, -41.800000, -1.000000>, <2.600000, -41.800000, -1.000000>, <8.000000, -50.200000, -1.000000>, <10.950000, -50.750000, -1.000000>, 
      <-0.950000, -38.775000, 0.000000>, <2.650000, -38.800000, 0.000000>, <8.000000, -47.200000, 0.000000>, <10.975000, -47.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.950000, -38.775000, 0.000000>, <2.650000, -38.800000, 0.000000>, <8.000000, -47.200000, 0.000000>, <10.975000, -47.725000, 0.000000>, 
      <-0.900000, -35.750000, 1.000000>, <2.700000, -35.800000, 1.000000>, <8.000000, -44.200000, 1.000000>, <11.000000, -44.700000, 1.000000>, 
      <-0.900000, -35.550000, -1.000000>, <2.700000, -35.600000, -1.000000>, <8.000000, -44.000000, -1.000000>, <10.950000, -44.500000, -1.000000>, 
      <-0.900000, -32.525000, 0.000000>, <2.700000, -32.550000, 0.000000>, <8.050000, -40.950000, 0.000000>, <11.000000, -41.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.900000, -32.525000, 0.000000>, <2.700000, -32.550000, 0.000000>, <8.050000, -40.950000, 0.000000>, <11.000000, -41.475000, 0.000000>, 
      <-0.900000, -29.500000, 1.000000>, <2.700000, -29.500000, 1.000000>, <8.100000, -37.900000, 1.000000>, <11.050000, -38.450000, 1.000000>, 
      <-0.900000, -29.300000, -1.000000>, <2.700000, -29.300000, -1.000000>, <8.100000, -37.700000, -1.000000>, <11.050000, -38.200000, -1.000000>, 
      <-0.350864, -26.258227, 0.041170>, <3.245426, -26.268730, 0.041170>, <8.100000, -34.650000, 0.000000>, <11.050000, -35.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.350864, -26.258227, 0.041170>, <3.245426, -26.268730, 0.041170>, <8.100000, -34.650000, 0.000000>, <11.050000, -35.175000, 0.000000>, 
      <0.198272, -23.216454, 1.082340>, <3.790853, -23.237460, 1.082340>, <8.100000, -31.600000, 1.000000>, <11.050000, -32.150000, 1.000000>, 
      <0.199525, -23.002121, 1.116721>, <3.792106, -23.023128, 1.116721>, <8.100000, -31.400000, -1.000000>, <11.050000, -31.950000, -1.000000>, 
      <-0.300238, -19.976061, 1.058361>, <3.296053, -20.011564, 1.058361>, <8.150000, -28.400000, 0.000000>, <11.100000, -28.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.300238, -19.976061, 1.058361>, <3.296053, -20.011564, 1.058361>, <8.150000, -28.400000, 0.000000>, <11.100000, -28.925000, 0.000000>, 
      <-0.800000, -16.950000, 1.000000>, <2.800000, -17.000000, 1.000000>, <8.200000, -25.400000, 1.000000>, <11.150000, -25.900000, 1.000000>, 
      <-0.800000, -16.750000, -1.000000>, <2.800000, -16.800000, -1.000000>, <8.100000, -25.100000, -1.000000>, <11.100000, -25.650000, -1.000000>, 
      <-0.264186, -13.710446, 0.041170>, <3.332105, -13.745950, 0.041170>, <8.150000, -22.100000, 0.000000>, <11.125000, -22.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.264186, -13.710446, 0.041170>, <3.332105, -13.745950, 0.041170>, <8.150000, -22.100000, 0.000000>, <11.125000, -22.625000, 0.000000>, 
      <0.271628, -10.670893, 1.082340>, <3.864209, -10.691899, 1.082340>, <8.200000, -19.100000, 1.000000>, <11.150000, -19.600000, 1.000000>, 
      <0.272881, -10.456560, 1.116721>, <3.865463, -10.477567, 1.116721>, <8.200000, -18.900000, -1.000000>, <11.150000, -19.400000, -1.000000>, 
      <-0.038541, -7.422557, 1.078946>, <3.382731, -7.438783, 1.058361>, <8.200000, -15.850000, 0.000000>, <11.150000, -16.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.038541, -7.422557, 1.078946>, <3.382731, -7.438783, 1.058361>, <8.200000, -15.850000, 0.000000>, <11.150000, -16.375000, 0.000000>, 
      <-0.349963, -4.388553, 1.041170>, <2.900000, -4.400000, 1.000000>, <8.200000, -12.800000, 1.000000>, <11.150000, -13.350000, 1.000000>, 
      <-0.399337, -4.181387, 0.058361>, <2.800000, -4.200000, -1.000000>, <8.200000, -12.600000, -1.000000>, <11.150000, -13.150000, -1.000000>, 
      <-0.365481, -1.141775, 0.549765>, <2.850000, -1.150000, 0.000000>, <8.250000, -9.550000, 0.000000>, <11.200000, -10.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.365481, -1.141775, 0.549765>, <2.850000, -1.150000, 0.000000>, <8.250000, -9.550000, 0.000000>, <11.200000, -10.100000, 0.000000>, 
      <-0.331624, 1.897838, 1.041170>, <2.900000, 1.900000, 1.000000>, <8.300000, -6.500000, 1.000000>, <11.250000, -7.050000, 1.000000>, 
      <-0.330998, 2.105004, 0.058361>, <2.900000, 2.100000, -1.000000>, <8.300000, -6.300000, -1.000000>, <11.250000, -6.850000, -1.000000>, 
      <-0.515499, 5.127502, 0.529180>, <2.900000, 5.100000, 0.000000>, <8.300000, -3.300000, 0.000000>, <11.250000, -3.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.515499, 5.127502, 0.529180>, <2.900000, 5.100000, 0.000000>, <8.300000, -3.300000, 0.000000>, <11.250000, -3.825000, 0.000000>, 
      <-0.700000, 8.150000, 1.000000>, <2.900000, 8.100000, 1.000000>, <8.300000, -0.300000, 1.000000>, <11.250000, -0.800000, 1.000000>, 
      <-0.700000, 8.350000, -1.000000>, <2.900000, 8.300000, -1.000000>, <8.300000, -0.100000, -1.000000>, <11.250000, -0.600000, -1.000000>, 
      <-0.650000, 11.375000, 0.000000>, <2.950000, 11.350000, 0.000000>, <8.300000, 3.400000, 0.000000>, <11.275000, 2.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.650000, 11.375000, 0.000000>, <2.950000, 11.350000, 0.000000>, <8.300000, 3.400000, 0.000000>, <11.275000, 2.900000, 0.000000>, 
      <-0.600000, 14.400000, 1.000000>, <3.000000, 14.400000, 1.000000>, <8.300000, 6.900000, 1.000000>, <11.300000, 6.400000, 1.000000>, 
      <-0.600000, 14.650000, -1.000000>, <3.000000, 14.600000, -1.000000>, <8.300000, 7.200000, -1.000000>, <11.250000, 6.650000, -1.000000>, 
      <-0.600000, 17.675000, 0.000000>, <3.000000, 17.650000, 0.000000>, <8.350000, 11.200000, 0.000000>, <11.300000, 10.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.600000, 17.675000, 0.000000>, <3.000000, 17.650000, 0.000000>, <8.350000, 11.200000, 0.000000>, <11.300000, 10.675000, 0.000000>, 
      <-0.600000, 20.700000, 1.000000>, <3.000000, 20.700000, 1.000000>, <8.400000, 15.200000, 1.000000>, <11.350000, 14.700000, 1.000000>, 
      <-0.600000, 20.900000, -1.000000>, <3.000000, 20.900000, -1.000000>, <8.400000, 15.500000, -1.000000>, <11.350000, 14.950000, -1.000000>, 
      <-0.650000, 24.100000, 0.000000>, <3.000000, 23.900000, 0.000000>, <8.350000, 19.650000, 0.000000>, <11.300000, 18.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.650000, 24.100000, 0.000000>, <3.000000, 23.900000, 0.000000>, <8.350000, 19.650000, 0.000000>, <11.300000, 18.925000, 0.000000>, 
      <-0.700000, 27.300000, 1.000000>, <3.000000, 26.900000, 1.000000>, <8.300000, 23.800000, 1.000000>, <11.250000, 22.900000, 1.000000>, 
      <-0.700000, 27.600000, -1.000000>, <3.000000, 27.200000, -1.000000>, <8.200000, 24.100000, -1.000000>, <11.200000, 23.150000, -1.000000>, 
      <-0.600000, 30.425000, 0.000000>, <3.050000, 30.200000, 0.000000>, <8.250000, 28.300000, 0.000000>, <11.225000, 27.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.600000, 30.425000, 0.000000>, <3.050000, 30.200000, 0.000000>, <8.250000, 28.300000, 0.000000>, <11.225000, 27.550000, 0.000000>, 
      <-0.500000, 33.250000, 1.000000>, <3.100000, 33.200000, 1.000000>, <8.300000, 32.500000, 1.000000>, <11.250000, 31.950000, 1.000000>, 
      <-0.500000, 33.450000, -1.000000>, <3.100000, 33.400000, -1.000000>, <8.300000, 32.700000, -1.000000>, <11.250000, 32.150000, -1.000000>, 
      <-0.500000, 36.675000, 0.000000>, <3.100000, 36.450000, 0.000000>, <8.300000, 36.400000, 0.000000>, <11.250000, 35.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 36.675000, 0.000000>, <3.100000, 36.450000, 0.000000>, <8.300000, 36.400000, 0.000000>, <11.250000, 35.675000, 0.000000>, 
      <-0.500000, 39.900000, 1.000000>, <3.100000, 39.500000, 1.000000>, <8.300000, 40.100000, 1.000000>, <11.250000, 39.200000, 1.000000>, 
      <-0.400000, 39.850000, -1.000000>, <3.100000, 39.700000, -1.000000>, <8.300000, 40.300000, -1.000000>, <11.250000, 39.400000, -1.000000>, 
      <-0.350000, 43.525000, 0.000000>, <3.200000, 43.450000, 0.000000>, <8.350000, 43.300000, 0.000000>, <11.300000, 42.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.350000, 43.525000, 0.000000>, <3.200000, 43.450000, 0.000000>, <8.350000, 43.300000, 0.000000>, <11.300000, 42.575000, 0.000000>, 
      <-0.300000, 47.200000, 1.000000>, <3.300000, 47.200000, 1.000000>, <8.400000, 46.300000, 1.000000>, <11.350000, 45.750000, 1.000000>, 
      <-0.300000, 47.450000, -1.000000>, <3.300000, 47.400000, -1.000000>, <8.400000, 46.500000, -1.000000>, <11.350000, 45.950000, -1.000000>, 
      <-0.275000, 49.925000, 0.000000>, <3.300000, 49.900000, 0.000000>, <8.500000, 49.450000, 0.000000>, <11.400000, 49.225000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.275000, 49.925000, 0.000000>, <3.300000, 49.900000, 0.000000>, <8.500000, 49.450000, 0.000000>, <11.400000, 49.225000, 0.000000>, 
      <-0.250000, 52.400000, 1.000000>, <3.300000, 52.400000, 1.000000>, <8.600000, 52.400000, 1.000000>, <11.450000, 52.500000, 1.000000>, 
      <-0.300000, 52.600000, -1.000000>, <3.300000, 52.600000, -1.000000>, <8.500000, 52.600000, -1.000000>, <11.400000, 52.700000, -1.000000>, 
      <-0.200000, 57.600000, 0.700000>, <3.400000, 57.600000, 0.700000>, <8.600000, 57.300000, 0.700000>, <11.450000, 57.350000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.550000, -142.400000, -1.000000>, <12.900000, -142.300000, -1.000000>, <17.000000, -146.600000, -1.000000>, <20.450000, -143.850000, -1.000000>, 
      <10.600000, -138.400000, 1.000000>, <12.900000, -138.300000, 1.000000>, <17.000000, -142.600000, 1.000000>, <20.450000, -139.850000, 1.000000>, 
      <10.550000, -138.200000, -1.000000>, <12.900000, -138.100000, -1.000000>, <17.000000, -142.400000, -1.000000>, <20.450000, -139.650000, -1.000000>, 
      <10.575000, -135.175000, 0.000000>, <12.900000, -135.050000, 0.000000>, <17.000000, -139.400000, 0.000000>, <20.475000, -136.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.575000, -135.175000, 0.000000>, <12.900000, -135.050000, 0.000000>, <17.000000, -139.400000, 0.000000>, <20.475000, -136.625000, 0.000000>, 
      <10.600000, -132.150000, 1.000000>, <12.900000, -132.000000, 1.000000>, <17.000000, -136.400000, 1.000000>, <20.500000, -133.600000, 1.000000>, 
      <10.600000, -131.900000, -1.000000>, <12.900000, -131.800000, -1.000000>, <17.000000, -136.200000, -1.000000>, <20.500000, -133.400000, -1.000000>, 
      <10.625000, -128.900000, 0.000000>, <12.950000, -128.800000, 0.000000>, <17.050000, -133.150000, 0.000000>, <20.525000, -130.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.625000, -128.900000, 0.000000>, <12.950000, -128.800000, 0.000000>, <17.050000, -133.150000, 0.000000>, <20.525000, -130.375000, 0.000000>, 
      <10.650000, -125.900000, 1.000000>, <13.000000, -125.800000, 1.000000>, <17.100000, -130.100000, 1.000000>, <20.550000, -127.350000, 1.000000>, 
      <10.650000, -125.700000, -1.000000>, <13.000000, -125.600000, -1.000000>, <17.100000, -129.900000, -1.000000>, <20.550000, -127.100000, -1.000000>, 
      <10.675000, -122.650000, 0.000000>, <13.000000, -122.550000, 0.000000>, <17.100000, -126.850000, 0.000000>, <20.550000, -124.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.675000, -122.650000, 0.000000>, <13.000000, -122.550000, 0.000000>, <17.100000, -126.850000, 0.000000>, <20.550000, -124.075000, 0.000000>, 
      <10.700000, -119.600000, 1.000000>, <13.000000, -119.500000, 1.000000>, <17.100000, -123.800000, 1.000000>, <20.550000, -121.050000, 1.000000>, 
      <10.700000, -119.400000, -1.000000>, <13.000000, -119.300000, -1.000000>, <17.100000, -123.600000, -1.000000>, <20.550000, -120.850000, -1.000000>, 
      <10.725000, -116.350000, 0.000000>, <13.050000, -116.250000, 0.000000>, <17.150000, -120.600000, 0.000000>, <20.600000, -117.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.725000, -116.350000, 0.000000>, <13.050000, -116.250000, 0.000000>, <17.150000, -120.600000, 0.000000>, <20.600000, -117.825000, 0.000000>, 
      <10.750000, -113.300000, 1.000000>, <13.100000, -113.200000, 1.000000>, <17.200000, -117.600000, 1.000000>, <20.650000, -114.800000, 1.000000>, 
      <10.700000, -113.100000, -1.000000>, <13.000000, -113.000000, -1.000000>, <17.100000, -117.300000, -1.000000>, <20.600000, -114.550000, -1.000000>, 
      <10.725000, -110.075000, 0.000000>, <13.050000, -109.950000, 0.000000>, <17.150000, -114.300000, 0.000000>, <20.625000, -111.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.725000, -110.075000, 0.000000>, <13.050000, -109.950000, 0.000000>, <17.150000, -114.300000, 0.000000>, <20.625000, -111.525000, 0.000000>, 
      <10.750000, -107.050000, 1.000000>, <13.100000, -106.900000, 1.000000>, <17.200000, -111.300000, 1.000000>, <20.650000, -108.500000, 1.000000>, 
      <10.750000, -106.800000, -1.000000>, <13.100000, -106.700000, -1.000000>, <17.200000, -111.100000, -1.000000>, <20.650000, -108.300000, -1.000000>, 
      <10.775000, -103.800000, 0.000000>, <13.100000, -103.700000, 0.000000>, <17.200000, -108.050000, 0.000000>, <20.675000, -105.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.775000, -103.800000, 0.000000>, <13.100000, -103.700000, 0.000000>, <17.200000, -108.050000, 0.000000>, <20.675000, -105.275000, 0.000000>, 
      <10.800000, -100.800000, 1.000000>, <13.100000, -100.700000, 1.000000>, <17.200000, -105.000000, 1.000000>, <20.700000, -102.250000, 1.000000>, 
      <10.800000, -100.600000, -1.000000>, <13.100000, -100.500000, -1.000000>, <17.200000, -104.800000, -1.000000>, <20.650000, -102.050000, -1.000000>, 
      <10.825000, -97.550000, 0.000000>, <13.150000, -97.450000, 0.000000>, <17.250000, -101.750000, 0.000000>, <20.700000, -99.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.825000, -97.550000, 0.000000>, <13.150000, -97.450000, 0.000000>, <17.250000, -101.750000, 0.000000>, <20.700000, -99.000000, 0.000000>, 
      <10.850000, -94.500000, 1.000000>, <13.200000, -94.400000, 1.000000>, <17.300000, -98.700000, 1.000000>, <20.750000, -95.950000, 1.000000>, 
      <10.800000, -94.300000, -1.000000>, <13.100000, -94.200000, -1.000000>, <17.200000, -98.500000, -1.000000>, <20.700000, -95.750000, -1.000000>, 
      <10.850000, -91.250000, 0.000000>, <13.150000, -91.150000, 0.000000>, <17.250000, -95.500000, 0.000000>, <20.725000, -92.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.850000, -91.250000, 0.000000>, <13.150000, -91.150000, 0.000000>, <17.250000, -95.500000, 0.000000>, <20.725000, -92.725000, 0.000000>, 
      <10.900000, -88.200000, 1.000000>, <13.200000, -88.100000, 1.000000>, <17.300000, -92.500000, 1.000000>, <20.750000, -89.700000, 1.000000>, 
      <10.850000, -88.000000, -1.000000>, <13.200000, -87.900000, -1.000000>, <17.300000, -92.300000, -1.000000>, <20.750000, -89.500000, -1.000000>, 
      <10.875000, -85.000000, 0.000000>, <13.200000, -84.900000, 0.000000>, <17.300000, -89.250000, 0.000000>, <20.775000, -86.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.875000, -85.000000, 0.000000>, <13.200000, -84.900000, 0.000000>, <17.300000, -89.250000, 0.000000>, <20.775000, -86.475000, 0.000000>, 
      <10.900000, -82.000000, 1.000000>, <13.200000, -81.900000, 1.000000>, <17.300000, -86.200000, 1.000000>, <20.800000, -83.450000, 1.000000>, 
      <10.900000, -81.750000, -1.000000>, <13.200000, -81.600000, -1.000000>, <17.300000, -86.000000, -1.000000>, <20.800000, -83.200000, -1.000000>, 
      <10.925000, -78.725000, 0.000000>, <13.250000, -78.600000, 0.000000>, <17.350000, -82.950000, 0.000000>, <20.825000, -80.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.925000, -78.725000, 0.000000>, <13.250000, -78.600000, 0.000000>, <17.350000, -82.950000, 0.000000>, <20.825000, -80.175000, 0.000000>, 
      <10.950000, -75.700000, 1.000000>, <13.300000, -75.600000, 1.000000>, <17.400000, -79.900000, 1.000000>, <20.850000, -77.150000, 1.000000>, 
      <10.950000, -75.500000, -1.000000>, <13.300000, -75.400000, -1.000000>, <17.400000, -79.700000, -1.000000>, <20.850000, -76.950000, -1.000000>, 
      <10.975000, -72.450000, 0.000000>, <13.300000, -72.350000, 0.000000>, <17.400000, -76.650000, 0.000000>, <20.850000, -73.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.975000, -72.450000, 0.000000>, <13.300000, -72.350000, 0.000000>, <17.400000, -76.650000, 0.000000>, <20.850000, -73.900000, 0.000000>, 
      <11.000000, -69.400000, 1.000000>, <13.300000, -69.300000, 1.000000>, <17.400000, -73.600000, 1.000000>, <20.850000, -70.850000, 1.000000>, 
      <10.950000, -69.200000, -1.000000>, <13.300000, -69.100000, -1.000000>, <17.400000, -73.400000, -1.000000>, <20.850000, -70.650000, -1.000000>, 
      <10.925000, -66.375000, 0.000000>, <13.600000, -66.600000, 0.000000>, <17.700000, -70.650000, 0.000000>, <21.025000, -67.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.925000, -66.375000, 0.000000>, <13.600000, -66.600000, 0.000000>, <17.700000, -70.650000, 0.000000>, <21.025000, -67.750000, 0.000000>, 
      <10.900000, -63.550000, 1.000000>, <13.900000, -64.100000, 1.000000>, <18.000000, -67.900000, 1.000000>, <21.200000, -64.850000, 1.000000>, 
      <10.850000, -63.300000, -1.000000>, <13.800000, -63.800000, -1.000000>, <17.900000, -67.700000, -1.000000>, <21.150000, -64.650000, -1.000000>, 
      <10.900000, -60.275000, 0.000000>, <13.850000, -60.800000, 0.000000>, <17.950000, -64.650000, 0.000000>, <21.175000, -61.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.900000, -60.275000, 0.000000>, <13.850000, -60.800000, 0.000000>, <17.950000, -64.650000, 0.000000>, <21.175000, -61.625000, 0.000000>, 
      <10.950000, -57.250000, 1.000000>, <13.900000, -57.800000, 1.000000>, <18.000000, -61.600000, 1.000000>, <21.200000, -58.600000, 1.000000>, 
      <10.950000, -57.050000, -1.000000>, <13.900000, -57.600000, -1.000000>, <18.000000, -61.400000, -1.000000>, <21.200000, -58.350000, -1.000000>, 
      <10.950000, -54.025000, 0.000000>, <13.900000, -54.550000, 0.000000>, <18.000000, -58.350000, 0.000000>, <21.200000, -55.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.950000, -54.025000, 0.000000>, <13.900000, -54.550000, 0.000000>, <18.000000, -58.350000, 0.000000>, <21.200000, -55.325000, 0.000000>, 
      <10.950000, -51.000000, 1.000000>, <13.900000, -51.500000, 1.000000>, <18.000000, -55.300000, 1.000000>, <21.200000, -52.300000, 1.000000>, 
      <10.950000, -50.750000, -1.000000>, <13.900000, -51.300000, -1.000000>, <18.000000, -55.100000, -1.000000>, <21.200000, -52.100000, -1.000000>, 
      <10.975000, -47.725000, 0.000000>, <13.950000, -48.250000, 0.000000>, <18.050000, -52.100000, 0.000000>, <21.250000, -49.075000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.975000, -47.725000, 0.000000>, <13.950000, -48.250000, 0.000000>, <18.050000, -52.100000, 0.000000>, <21.250000, -49.075000, 0.000000>, 
      <11.000000, -44.700000, 1.000000>, <14.000000, -45.200000, 1.000000>, <18.100000, -49.100000, 1.000000>, <21.300000, -46.050000, 1.000000>, 
      <10.950000, -44.500000, -1.000000>, <13.900000, -45.000000, -1.000000>, <18.000000, -48.800000, -1.000000>, <21.250000, -45.800000, -1.000000>, 
      <11.000000, -41.475000, 0.000000>, <13.950000, -42.000000, 0.000000>, <18.050000, -45.800000, 0.000000>, <21.275000, -42.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.000000, -41.475000, 0.000000>, <13.950000, -42.000000, 0.000000>, <18.050000, -45.800000, 0.000000>, <21.275000, -42.775000, 0.000000>, 
      <11.050000, -38.450000, 1.000000>, <14.000000, -39.000000, 1.000000>, <18.100000, -42.800000, 1.000000>, <21.300000, -39.750000, 1.000000>, 
      <11.050000, -38.200000, -1.000000>, <14.000000, -38.700000, -1.000000>, <18.100000, -42.600000, -1.000000>, <21.300000, -39.550000, -1.000000>, 
      <11.050000, -35.175000, 0.000000>, <14.000000, -35.700000, 0.000000>, <18.100000, -39.550000, 0.000000>, <21.325000, -36.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.050000, -35.175000, 0.000000>, <14.000000, -35.700000, 0.000000>, <18.100000, -39.550000, 0.000000>, <21.325000, -36.525000, 0.000000>, 
      <11.050000, -32.150000, 1.000000>, <14.000000, -32.700000, 1.000000>, <18.100000, -36.500000, 1.000000>, <21.350000, -33.500000, 1.000000>, 
      <11.050000, -31.950000, -1.000000>, <14.000000, -32.500000, -1.000000>, <18.100000, -36.300000, -1.000000>, <21.300000, -33.300000, -1.000000>, 
      <11.100000, -28.925000, 0.000000>, <14.050000, -29.450000, 0.000000>, <18.150000, -33.250000, 0.000000>, <21.350000, -30.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.100000, -28.925000, 0.000000>, <14.050000, -29.450000, 0.000000>, <18.150000, -33.250000, 0.000000>, <21.350000, -30.250000, 0.000000>, 
      <11.150000, -25.900000, 1.000000>, <14.100000, -26.400000, 1.000000>, <18.200000, -30.200000, 1.000000>, <21.400000, -27.200000, 1.000000>, 
      <11.100000, -25.650000, -1.000000>, <14.100000, -26.200000, -1.000000>, <18.200000, -30.000000, -1.000000>, <21.400000, -27.000000, -1.000000>, 
      <11.125000, -22.625000, 0.000000>, <14.100000, -23.150000, 0.000000>, <18.200000, -27.000000, 0.000000>, <21.400000, -23.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.125000, -22.625000, 0.000000>, <14.100000, -23.150000, 0.000000>, <18.200000, -27.000000, 0.000000>, <21.400000, -23.975000, 0.000000>, 
      <11.150000, -19.600000, 1.000000>, <14.100000, -20.100000, 1.000000>, <18.200000, -24.000000, 1.000000>, <21.400000, -20.950000, 1.000000>, 
      <11.150000, -19.400000, -1.000000>, <14.100000, -19.900000, -1.000000>, <18.200000, -23.800000, -1.000000>, <21.400000, -20.750000, -1.000000>, 
      <11.150000, -16.375000, 0.000000>, <14.100000, -16.900000, 0.000000>, <18.200000, -20.750000, 0.000000>, <21.624233, -17.805053, 0.021707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.150000, -16.375000, 0.000000>, <14.100000, -16.900000, 0.000000>, <18.200000, -20.750000, 0.000000>, <21.624233, -17.805053, 0.021707>, 
      <11.150000, -13.350000, 1.000000>, <14.100000, -13.900000, 1.000000>, <18.200000, -17.700000, 1.000000>, <21.848466, -14.860106, 1.043414>, 
      <11.150000, -13.150000, -1.000000>, <14.100000, -13.700000, -1.000000>, <18.200000, -17.500000, -1.000000>, <21.726111, -14.652940, 0.061466>, 
      <11.200000, -10.100000, 0.000000>, <14.150000, -10.650000, 0.000000>, <18.250000, -14.450000, 0.000000>, <21.821458, -11.582017, 0.552440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.200000, -10.100000, 0.000000>, <14.150000, -10.650000, 0.000000>, <18.250000, -14.450000, 0.000000>, <21.821458, -11.582017, 0.552440>, 
      <11.250000, -7.050000, 1.000000>, <14.200000, -7.600000, 1.000000>, <18.300000, -11.400000, 1.000000>, <21.916805, -8.511094, 1.043414>, 
      <11.250000, -6.850000, -1.000000>, <14.200000, -7.400000, -1.000000>, <18.300000, -11.200000, -1.000000>, <21.794450, -8.303927, 0.061466>, 
      <11.250000, -3.825000, 0.000000>, <14.200000, -4.350000, 0.000000>, <18.300000, -8.200000, 0.000000>, <21.647225, -4.951964, 0.530733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.250000, -3.825000, 0.000000>, <14.200000, -4.350000, 0.000000>, <18.300000, -8.200000, 0.000000>, <21.647225, -4.951964, 0.530733>, 
      <11.250000, -0.800000, 1.000000>, <14.200000, -1.300000, 1.000000>, <18.300000, -5.200000, 1.000000>, <21.500000, -1.600000, 1.000000>, 
      <11.250000, -0.600000, -1.000000>, <14.200000, -1.100000, -1.000000>, <18.300000, -4.900000, -1.000000>, <21.500000, -1.350000, -1.000000>, 
      <11.275000, 2.900000, 0.000000>, <14.250000, 2.400000, 0.000000>, <18.350000, -1.400000, 0.000000>, <21.550000, 2.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.275000, 2.900000, 0.000000>, <14.250000, 2.400000, 0.000000>, <18.350000, -1.400000, 0.000000>, <21.550000, 2.375000, 0.000000>, 
      <11.300000, 6.400000, 1.000000>, <14.300000, 5.900000, 1.000000>, <18.400000, 2.100000, 1.000000>, <21.600000, 6.100000, 1.000000>, 
      <11.250000, 6.650000, -1.000000>, <14.200000, 6.100000, -1.000000>, <18.300000, 2.300000, -1.000000>, <21.550000, 6.300000, -1.000000>, 
      <11.300000, 10.675000, 0.000000>, <14.250000, 10.150000, 0.000000>, <18.350000, 6.350000, 0.000000>, <21.550000, 10.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.300000, 10.675000, 0.000000>, <14.250000, 10.150000, 0.000000>, <18.350000, 6.350000, 0.000000>, <21.550000, 10.425000, 0.000000>, 
      <11.350000, 14.700000, 1.000000>, <14.300000, 14.200000, 1.000000>, <18.400000, 10.400000, 1.000000>, <21.550000, 14.550000, 1.000000>, 
      <11.350000, 14.950000, -1.000000>, <14.300000, 14.400000, -1.000000>, <18.400000, 10.600000, -1.000000>, <21.500000, 14.800000, -1.000000>, 
      <11.300000, 18.925000, 0.000000>, <14.250000, 18.200000, 0.000000>, <18.350000, 14.400000, 0.000000>, <21.500000, 18.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.300000, 18.925000, 0.000000>, <14.250000, 18.200000, 0.000000>, <18.350000, 14.400000, 0.000000>, <21.500000, 18.600000, 0.000000>, 
      <11.250000, 22.900000, 1.000000>, <14.200000, 22.000000, 1.000000>, <18.300000, 18.200000, 1.000000>, <21.500000, 22.400000, 1.000000>, 
      <11.200000, 23.150000, -1.000000>, <14.200000, 22.200000, -1.000000>, <18.300000, 18.400000, -1.000000>, <21.500000, 22.600000, -1.000000>, 
      <11.225000, 27.550000, 0.000000>, <14.200000, 26.800000, 0.000000>, <18.300000, 23.000000, 0.000000>, <21.500000, 26.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.225000, 27.550000, 0.000000>, <14.200000, 26.800000, 0.000000>, <18.300000, 23.000000, 0.000000>, <21.500000, 26.950000, 0.000000>, 
      <11.250000, 31.950000, 1.000000>, <14.200000, 31.400000, 1.000000>, <18.300000, 27.600000, 1.000000>, <21.500000, 31.300000, 1.000000>, 
      <11.250000, 32.150000, -1.000000>, <14.200000, 31.600000, -1.000000>, <18.300000, 27.800000, -1.000000>, <21.500000, 31.500000, -1.000000>, 
      <11.250000, 35.675000, 0.000000>, <14.200000, 34.950000, 0.000000>, <18.300000, 31.150000, 0.000000>, <21.475000, 34.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.250000, 35.675000, 0.000000>, <14.200000, 34.950000, 0.000000>, <18.300000, 31.150000, 0.000000>, <21.475000, 34.475000, 0.000000>, 
      <11.250000, 39.200000, 1.000000>, <14.200000, 38.300000, 1.000000>, <18.300000, 34.500000, 1.000000>, <21.450000, 37.450000, 1.000000>, 
      <11.250000, 39.400000, -1.000000>, <14.200000, 38.500000, -1.000000>, <18.300000, 34.700000, -1.000000>, <21.450000, 37.650000, -1.000000>, 
      <11.300000, 42.575000, 0.000000>, <14.250000, 41.850000, 0.000000>, <18.350000, 38.050000, 0.000000>, <21.575000, 40.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.300000, 42.575000, 0.000000>, <14.250000, 41.850000, 0.000000>, <18.350000, 38.050000, 0.000000>, <21.575000, 40.650000, 0.000000>, 
      <11.350000, 45.750000, 1.000000>, <14.300000, 45.200000, 1.000000>, <18.400000, 41.400000, 1.000000>, <21.700000, 43.650000, 1.000000>, 
      <11.350000, 45.950000, -1.000000>, <14.300000, 45.400000, -1.000000>, <18.400000, 41.600000, -1.000000>, <21.650000, 43.900000, -1.000000>, 
      <11.400000, 49.225000, 0.000000>, <14.300000, 49.000000, 0.000000>, <18.400000, 45.150000, 0.000000>, <21.625000, 46.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.400000, 49.225000, 0.000000>, <14.300000, 49.000000, 0.000000>, <18.400000, 45.150000, 0.000000>, <21.625000, 46.750000, 0.000000>, 
      <11.450000, 52.500000, 1.000000>, <14.300000, 52.600000, 1.000000>, <18.400000, 48.700000, 1.000000>, <21.600000, 49.600000, 1.000000>, 
      <11.400000, 52.700000, -1.000000>, <14.300000, 52.800000, -1.000000>, <18.400000, 49.000000, -1.000000>, <21.600000, 49.900000, -1.000000>, 
      <11.450000, 57.350000, 0.700000>, <14.300000, 57.400000, 0.700000>, <18.400000, 53.600000, 0.700000>, <21.650000, 54.500000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.450000, -143.850000, -1.000000>, <23.900000, -141.100000, -1.000000>, <27.500000, -141.100000, -1.000000>, <29.100000, -139.700000, -1.000000>, 
      <20.450000, -139.850000, 1.000000>, <23.900000, -137.100000, 1.000000>, <27.500000, -137.100000, 1.000000>, <29.250000, -135.750000, 1.000000>, 
      <20.450000, -139.650000, -1.000000>, <23.900000, -136.900000, -1.000000>, <27.500000, -136.900000, -1.000000>, <29.250000, -135.550000, -1.000000>, 
      <20.475000, -136.625000, 0.000000>, <23.950000, -133.850000, 0.000000>, <27.550000, -133.900000, 0.000000>, <29.275000, -132.275000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.475000, -136.625000, 0.000000>, <23.950000, -133.850000, 0.000000>, <27.550000, -133.900000, 0.000000>, <29.275000, -132.275000, 0.000000>, 
      <20.500000, -133.600000, 1.000000>, <24.000000, -130.800000, 1.000000>, <27.600000, -130.900000, 1.000000>, <29.300000, -129.000000, 1.000000>, 
      <20.500000, -133.400000, -1.000000>, <24.000000, -130.600000, -1.000000>, <27.500000, -130.600000, -1.000000>, <29.250000, -128.750000, -1.000000>, 
      <20.525000, -130.375000, 0.000000>, <24.000000, -127.600000, 0.000000>, <27.550000, -127.600000, 0.000000>, <29.400000, -125.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.525000, -130.375000, 0.000000>, <24.000000, -127.600000, 0.000000>, <27.550000, -127.600000, 0.000000>, <29.400000, -125.725000, 0.000000>, 
      <20.550000, -127.350000, 1.000000>, <24.000000, -124.600000, 1.000000>, <27.600000, -124.600000, 1.000000>, <29.550000, -122.700000, 1.000000>, 
      <20.550000, -127.100000, -1.000000>, <24.000000, -124.300000, -1.000000>, <27.600000, -124.400000, -1.000000>, <29.550000, -122.500000, -1.000000>, 
      <20.550000, -124.075000, 0.000000>, <24.000000, -121.300000, 0.000000>, <27.600000, -121.350000, 0.000000>, <29.700000, -119.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.550000, -124.075000, 0.000000>, <24.000000, -121.300000, 0.000000>, <27.600000, -121.350000, 0.000000>, <29.700000, -119.475000, 0.000000>, 
      <20.550000, -121.050000, 1.000000>, <24.000000, -118.300000, 1.000000>, <27.600000, -118.300000, 1.000000>, <29.850000, -116.450000, 1.000000>, 
      <20.550000, -120.850000, -1.000000>, <24.000000, -118.100000, -1.000000>, <27.600000, -118.100000, -1.000000>, <29.850000, -116.250000, -1.000000>, 
      <20.600000, -117.825000, 0.000000>, <24.050000, -115.050000, 0.000000>, <27.650000, -115.050000, 0.000000>, <30.000000, -113.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.600000, -117.825000, 0.000000>, <24.050000, -115.050000, 0.000000>, <27.650000, -115.050000, 0.000000>, <30.000000, -113.200000, 0.000000>, 
      <20.650000, -114.800000, 1.000000>, <24.100000, -112.000000, 1.000000>, <27.700000, -112.000000, 1.000000>, <30.150000, -110.150000, 1.000000>, 
      <20.600000, -114.550000, -1.000000>, <24.100000, -111.800000, -1.000000>, <27.700000, -111.800000, -1.000000>, <30.150000, -109.950000, -1.000000>, 
      <20.625000, -111.525000, 0.000000>, <24.100000, -108.750000, 0.000000>, <27.700000, -108.800000, 0.000000>, <30.275000, -106.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.625000, -111.525000, 0.000000>, <24.100000, -108.750000, 0.000000>, <27.700000, -108.800000, 0.000000>, <30.275000, -106.950000, 0.000000>, 
      <20.650000, -108.500000, 1.000000>, <24.100000, -105.700000, 1.000000>, <27.700000, -105.800000, 1.000000>, <30.400000, -103.950000, 1.000000>, 
      <20.650000, -108.300000, -1.000000>, <24.100000, -105.500000, -1.000000>, <27.700000, -105.500000, -1.000000>, <30.400000, -103.700000, -1.000000>, 
      <20.675000, -105.275000, 0.000000>, <24.150000, -102.500000, 0.000000>, <27.700000, -102.500000, 0.000000>, <30.525000, -100.336197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.675000, -105.275000, 0.000000>, <24.150000, -102.500000, 0.000000>, <27.700000, -102.500000, 0.000000>, <30.525000, -100.336197, 0.000000>, 
      <20.700000, -102.250000, 1.000000>, <24.200000, -99.500000, 1.000000>, <27.700000, -99.500000, 1.000000>, <30.650000, -96.972395, 1.000000>, 
      <20.650000, -102.050000, -1.000000>, <24.100000, -99.300000, -1.000000>, <27.700000, -99.300000, -1.000000>, <30.650000, -96.750000, -1.000000>, 
      <20.700000, -99.000000, 0.000000>, <24.150000, -96.250000, 0.000000>, <27.750000, -96.250000, 0.000000>, <30.825000, -93.736197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.700000, -99.000000, 0.000000>, <24.150000, -96.250000, 0.000000>, <27.750000, -96.250000, 0.000000>, <30.825000, -93.736197, 0.000000>, 
      <20.750000, -95.950000, 1.000000>, <24.200000, -93.200000, 1.000000>, <27.800000, -93.200000, 1.000000>, <31.000000, -90.722395, 1.000000>, 
      <20.700000, -95.750000, -1.000000>, <24.200000, -93.000000, -1.000000>, <27.800000, -93.000000, -1.000000>, <31.000000, -90.500000, -1.000000>, 
      <20.725000, -92.725000, 0.000000>, <24.200000, -89.950000, 0.000000>, <27.800000, -89.950000, 0.000000>, <31.125000, -87.461197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.725000, -92.725000, 0.000000>, <24.200000, -89.950000, 0.000000>, <27.800000, -89.950000, 0.000000>, <31.125000, -87.461197, 0.000000>, 
      <20.750000, -89.700000, 1.000000>, <24.200000, -86.900000, 1.000000>, <27.800000, -86.900000, 1.000000>, <31.250000, -84.422395, 1.000000>, 
      <20.750000, -89.500000, -1.000000>, <24.200000, -86.700000, -1.000000>, <27.800000, -86.700000, -1.000000>, <31.250000, -84.200000, -1.000000>, 
      <20.775000, -86.475000, 0.000000>, <24.250000, -83.700000, 0.000000>, <27.850000, -83.700000, 0.000000>, <31.400000, -81.211197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.775000, -86.475000, 0.000000>, <24.250000, -83.700000, 0.000000>, <27.850000, -83.700000, 0.000000>, <31.400000, -81.211197, 0.000000>, 
      <20.800000, -83.450000, 1.000000>, <24.300000, -80.700000, 1.000000>, <27.900000, -80.700000, 1.000000>, <31.550000, -78.222395, 1.000000>, 
      <20.800000, -83.200000, -1.000000>, <24.300000, -80.400000, -1.000000>, <27.800000, -80.500000, -1.000000>, <31.500000, -78.000000, -1.000000>, 
      <20.825000, -80.175000, 0.000000>, <24.300000, -77.400000, 0.000000>, <27.850000, -77.450000, 0.000000>, <31.650000, -74.961197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.825000, -80.175000, 0.000000>, <24.300000, -77.400000, 0.000000>, <27.850000, -77.450000, 0.000000>, <31.650000, -74.961197, 0.000000>, 
      <20.850000, -77.150000, 1.000000>, <24.300000, -74.400000, 1.000000>, <27.900000, -74.400000, 1.000000>, <31.800000, -71.922395, 1.000000>, 
      <20.850000, -76.950000, -1.000000>, <24.300000, -74.200000, -1.000000>, <27.900000, -74.200000, -1.000000>, <31.800000, -71.700000, -1.000000>, 
      <20.850000, -73.900000, 0.000000>, <24.300000, -71.150000, 0.000000>, <27.900000, -71.150000, 0.000000>, <31.950000, -68.686197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <20.850000, -73.900000, 0.000000>, <24.300000, -71.150000, 0.000000>, <27.900000, -71.150000, 0.000000>, <31.950000, -68.686197, 0.000000>, 
      <20.850000, -70.850000, 1.000000>, <24.300000, -68.100000, 1.000000>, <27.900000, -68.100000, 1.000000>, <32.100000, -65.672395, 1.000000>, 
      <20.850000, -70.650000, -1.000000>, <24.300000, -67.900000, -1.000000>, <27.900000, -67.900000, -1.000000>, <32.100000, -65.450000, -1.000000>, 
      <21.025000, -67.750000, 0.000000>, <24.350000, -64.850000, 0.000000>, <27.950000, -64.900000, 0.000000>, <31.950000, -62.436197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.025000, -67.750000, 0.000000>, <24.350000, -64.850000, 0.000000>, <27.950000, -64.900000, 0.000000>, <31.950000, -62.436197, 0.000000>, 
      <21.200000, -64.850000, 1.000000>, <24.400000, -61.800000, 1.000000>, <28.000000, -61.900000, 1.000000>, <31.800000, -59.422395, 1.000000>, 
      <21.150000, -64.650000, -1.000000>, <24.400000, -61.600000, -1.000000>, <28.000000, -61.600000, -1.000000>, <31.800000, -59.150000, -1.000000>, 
      <21.175000, -61.625000, 0.000000>, <24.400000, -58.600000, 0.000000>, <28.000000, -58.600000, 0.000000>, <31.925000, -56.161197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.175000, -61.625000, 0.000000>, <24.400000, -58.600000, 0.000000>, <28.000000, -58.600000, 0.000000>, <31.925000, -56.161197, 0.000000>, 
      <21.200000, -58.600000, 1.000000>, <24.400000, -55.600000, 1.000000>, <28.000000, -55.600000, 1.000000>, <32.050000, -53.172395, 1.000000>, 
      <21.200000, -58.350000, -1.000000>, <24.400000, -55.300000, -1.000000>, <28.000000, -55.400000, -1.000000>, <32.050000, -52.950000, -1.000000>, 
      <21.200000, -55.325000, 0.000000>, <24.400000, -52.300000, 0.000000>, <28.000000, -52.350000, 0.000000>, <32.175000, -49.911197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.200000, -55.325000, 0.000000>, <24.400000, -52.300000, 0.000000>, <28.000000, -52.350000, 0.000000>, <32.175000, -49.911197, 0.000000>, 
      <21.200000, -52.300000, 1.000000>, <24.400000, -49.300000, 1.000000>, <28.000000, -49.300000, 1.000000>, <32.300000, -46.872395, 1.000000>, 
      <21.200000, -52.100000, -1.000000>, <24.400000, -49.100000, -1.000000>, <28.000000, -49.100000, -1.000000>, <32.300000, -46.650000, -1.000000>, 
      <21.250000, -49.075000, 0.000000>, <24.450000, -46.050000, 0.000000>, <28.050000, -46.050000, 0.000000>, <31.925000, -43.686197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.250000, -49.075000, 0.000000>, <24.450000, -46.050000, 0.000000>, <28.050000, -46.050000, 0.000000>, <31.925000, -43.686197, 0.000000>, 
      <21.300000, -46.050000, 1.000000>, <24.500000, -43.000000, 1.000000>, <28.100000, -43.000000, 1.000000>, <31.550000, -40.722395, 1.000000>, 
      <21.250000, -45.800000, -1.000000>, <24.500000, -42.800000, -1.000000>, <28.100000, -42.800000, -1.000000>, <31.550000, -40.500000, -1.000000>, 
      <21.275000, -42.775000, 0.000000>, <24.500000, -39.750000, 0.000000>, <28.100000, -39.800000, 0.000000>, <31.700000, -37.511197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.275000, -42.775000, 0.000000>, <24.500000, -39.750000, 0.000000>, <28.100000, -39.800000, 0.000000>, <31.700000, -37.511197, 0.000000>, 
      <21.300000, -39.750000, 1.000000>, <24.500000, -36.700000, 1.000000>, <28.100000, -36.800000, 1.000000>, <31.850000, -34.522395, 1.000000>, 
      <21.300000, -39.550000, -1.000000>, <24.500000, -36.500000, -1.000000>, <28.100000, -36.500000, -1.000000>, <31.850000, -34.250000, -1.000000>, 
      <21.325000, -36.525000, 0.000000>, <24.550000, -33.500000, 0.000000>, <28.150000, -33.500000, 0.000000>, <32.000000, -31.236197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.325000, -36.525000, 0.000000>, <24.550000, -33.500000, 0.000000>, <28.150000, -33.500000, 0.000000>, <32.000000, -31.236197, 0.000000>, 
      <21.350000, -33.500000, 1.000000>, <24.600000, -30.500000, 1.000000>, <28.200000, -30.500000, 1.000000>, <32.150000, -28.222395, 1.000000>, 
      <21.300000, -33.300000, -1.000000>, <24.500000, -30.300000, -1.000000>, <28.100000, -30.300000, -1.000000>, <32.100000, -28.000000, -1.000000>, 
      <21.350000, -30.250000, 0.000000>, <24.550000, -27.250000, 0.000000>, <28.150000, -27.250000, 0.000000>, <32.250000, -24.986197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.350000, -30.250000, 0.000000>, <24.550000, -27.250000, 0.000000>, <28.150000, -27.250000, 0.000000>, <32.250000, -24.986197, 0.000000>, 
      <21.400000, -27.200000, 1.000000>, <24.600000, -24.200000, 1.000000>, <28.200000, -24.200000, 1.000000>, <32.400000, -21.972395, 1.000000>, 
      <21.400000, -27.000000, -1.000000>, <24.600000, -24.000000, -1.000000>, <28.200000, -24.000000, -1.000000>, <32.400000, -21.750000, -1.000000>, 
      <21.400000, -23.975000, 0.000000>, <24.600000, -20.950000, 0.000000>, <28.503597, -21.157000, 0.039274>, <32.636890, -19.205378, 0.039274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.400000, -23.975000, 0.000000>, <24.600000, -20.950000, 0.000000>, <28.503597, -21.157000, 0.039274>, <32.636890, -19.205378, 0.039274>, 
      <21.400000, -20.950000, 1.000000>, <24.600000, -17.900000, 1.000000>, <28.807194, -18.314000, 1.078548>, <32.873779, -16.660756, 1.078548>, 
      <21.400000, -20.750000, -1.000000>, <24.600000, -17.700000, -1.000000>, <28.562485, -18.099667, 1.114652>, <32.628949, -16.446423, 1.114652>, 
      <21.624233, -17.805053, 0.021707>, <25.048466, -14.860106, 0.043414>, <28.587406, -14.885994, 1.077992>, <32.486185, -13.216291, 0.564912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.624233, -17.805053, 0.021707>, <25.048466, -14.860106, 0.043414>, <28.587406, -14.885994, 1.077992>, <32.486185, -13.216291, 0.564912>, 
      <21.848466, -14.860106, 1.043414>, <25.496931, -12.020213, 1.086829>, <28.612327, -11.672320, 1.041331>, <32.356164, -9.986160, 0.020666>, 
      <21.726111, -14.652940, 0.061466>, <25.252223, -11.805880, 1.122933>, <28.613581, -11.457987, 1.142036>, <32.348965, -9.804724, 1.137895>, 
      <21.821458, -11.582017, 0.552440>, <25.392916, -8.714034, 1.104881>, <28.631293, -8.366141, 1.091684>, <32.355362, -6.720936, 0.576534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.821458, -11.582017, 0.552440>, <25.392916, -8.714034, 1.104881>, <28.631293, -8.366141, 1.091684>, <32.355362, -6.720936, 0.576534>, 
      <21.916805, -8.511094, 1.043414>, <25.533609, -5.622187, 1.086829>, <28.649006, -5.274294, 1.041331>, <32.374503, -3.637147, 0.020666>, 
      <21.794450, -8.303927, 0.061466>, <25.288901, -5.407855, 1.122933>, <28.650259, -5.059962, 1.142036>, <32.382084, -3.469302, 1.137895>, 
      <21.647225, -4.951964, 0.530733>, <24.994450, -1.703927, 1.061466>, <28.783744, -2.215187, 1.110292>, <32.677610, -0.624519, 1.108222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.647225, -4.951964, 0.530733>, <24.994450, -1.703927, 1.061466>, <28.783744, -2.215187, 1.110292>, <32.677610, -0.624519, 1.108222>, 
      <21.500000, -1.600000, 1.000000>, <24.700000, 2.000000, 1.000000>, <28.917229, 0.629587, 1.078548>, <32.973137, 2.220265, 1.078548>, 
      <21.500000, -1.350000, -1.000000>, <24.700000, 2.200000, -1.000000>, <28.672520, 0.843919, 1.114652>, <32.728306, 2.434598, 1.114652>, 
      <21.550000, 2.375000, 0.000000>, <24.750000, 6.150000, 0.000000>, <28.536260, 3.971960, 1.057326>, <32.589153, 5.606102, 1.057326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.550000, 2.375000, 0.000000>, <24.750000, 6.150000, 0.000000>, <28.536260, 3.971960, 1.057326>, <32.589153, 5.606102, 1.057326>, 
      <21.600000, 6.100000, 1.000000>, <24.800000, 10.100000, 1.000000>, <28.400000, 7.100000, 1.000000>, <32.450000, 8.777605, 1.000000>, 
      <21.550000, 6.300000, -1.000000>, <24.800000, 10.300000, -1.000000>, <28.400000, 7.400000, -1.000000>, <32.450000, 9.050000, -1.000000>, 
      <21.550000, 10.425000, 0.000000>, <24.750000, 14.500000, 0.000000>, <28.400000, 10.400000, 0.000000>, <32.450000, 12.063803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.550000, 10.425000, 0.000000>, <24.750000, 14.500000, 0.000000>, <28.400000, 10.400000, 0.000000>, <32.450000, 12.063803, 0.000000>, 
      <21.550000, 14.550000, 1.000000>, <24.700000, 18.700000, 1.000000>, <28.400000, 13.400000, 1.000000>, <32.450000, 15.077605, 1.000000>, 
      <21.500000, 14.800000, -1.000000>, <24.600000, 19.000000, -1.000000>, <28.400000, 13.600000, -1.000000>, <32.450000, 15.300000, -1.000000>, 
      <21.500000, 18.600000, 0.000000>, <24.650000, 22.800000, 0.000000>, <28.400000, 16.650000, 0.000000>, <32.450000, 18.313803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.500000, 18.600000, 0.000000>, <24.650000, 22.800000, 0.000000>, <28.400000, 16.650000, 0.000000>, <32.450000, 18.313803, 0.000000>, 
      <21.500000, 22.400000, 1.000000>, <24.700000, 26.600000, 1.000000>, <28.400000, 19.700000, 1.000000>, <32.450000, 21.327605, 1.000000>, 
      <21.500000, 22.600000, -1.000000>, <24.700000, 26.800000, -1.000000>, <28.400000, 19.900000, -1.000000>, <32.450000, 21.600000, -1.000000>, 
      <21.500000, 26.950000, 0.000000>, <24.700000, 30.900000, 0.000000>, <28.450000, 23.250000, 0.000000>, <32.500000, 24.763803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.500000, 26.950000, 0.000000>, <24.700000, 30.900000, 0.000000>, <28.450000, 23.250000, 0.000000>, <32.500000, 24.763803, 0.000000>, 
      <21.500000, 31.300000, 1.000000>, <24.700000, 35.000000, 1.000000>, <28.500000, 26.600000, 1.000000>, <32.550000, 27.927605, 1.000000>, 
      <21.500000, 31.500000, -1.000000>, <24.700000, 35.200000, -1.000000>, <28.500000, 26.800000, -1.000000>, <32.500000, 28.150000, -1.000000>, 
      <21.475000, 34.475000, 0.000000>, <24.650000, 37.800000, 0.000000>, <28.600000, 30.150000, 0.000000>, <32.400000, 31.338803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.475000, 34.475000, 0.000000>, <24.650000, 37.800000, 0.000000>, <28.600000, 30.150000, 0.000000>, <32.400000, 31.338803, 0.000000>, 
      <21.450000, 37.450000, 1.000000>, <24.600000, 40.400000, 1.000000>, <28.700000, 33.500000, 1.000000>, <32.300000, 34.527605, 1.000000>, 
      <21.450000, 37.650000, -1.000000>, <24.600000, 40.600000, -1.000000>, <28.700000, 33.700000, -1.000000>, <32.300000, 34.750000, -1.000000>, 
      <21.575000, 40.650000, 0.000000>, <24.800000, 43.250000, 0.000000>, <29.000000, 36.700000, 0.000000>, <32.525000, 37.813803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.575000, 40.650000, 0.000000>, <24.800000, 43.250000, 0.000000>, <29.000000, 36.700000, 0.000000>, <32.525000, 37.813803, 0.000000>, 
      <21.700000, 43.650000, 1.000000>, <25.000000, 45.900000, 1.000000>, <29.300000, 39.700000, 1.000000>, <32.750000, 40.877605, 1.000000>, 
      <21.650000, 43.900000, -1.000000>, <24.900000, 46.200000, -1.000000>, <29.300000, 39.900000, -1.000000>, <32.750000, 41.100000, -1.000000>, 
      <21.625000, 46.750000, 0.000000>, <24.850000, 48.350000, 0.000000>, <29.500000, 42.450000, 0.000000>, <32.825000, 43.463803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <21.625000, 46.750000, 0.000000>, <24.850000, 48.350000, 0.000000>, <29.500000, 42.450000, 0.000000>, <32.825000, 43.463803, 0.000000>, 
      <21.600000, 49.600000, 1.000000>, <24.800000, 50.500000, 1.000000>, <29.700000, 45.000000, 1.000000>, <32.900000, 45.827605, 1.000000>, 
      <21.600000, 49.900000, -1.000000>, <24.800000, 50.800000, -1.000000>, <29.700000, 45.200000, -1.000000>, <32.900000, 46.050000, -1.000000>, 
      <21.650000, 54.500000, 0.700000>, <24.900000, 55.400000, 0.700000>, <29.700000, 49.900000, 0.700000>, <32.900000, 50.327605, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <29.100000, -139.700000, -1.000000>, <30.700000, -138.300000, -1.000000>, <33.700000, -136.200000, -1.000000>, <37.300000, -136.500000, -1.000000>, 
      <29.250000, -135.750000, 1.000000>, <31.000000, -134.400000, 1.000000>, <34.100000, -132.244789, 1.000000>, <37.650000, -132.544789, 1.000000>, 
      <29.250000, -135.550000, -1.000000>, <31.000000, -134.200000, -1.000000>, <34.100000, -132.000000, -1.000000>, <37.650000, -132.300000, -1.000000>, 
      <29.275000, -132.275000, 0.000000>, <31.000000, -130.650000, 0.000000>, <34.350000, -129.022395, 0.000000>, <37.925000, -129.322395, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <29.275000, -132.275000, 0.000000>, <31.000000, -130.650000, 0.000000>, <34.350000, -129.022395, 0.000000>, <37.925000, -129.322395, 0.000000>, 
      <29.300000, -129.000000, 1.000000>, <31.000000, -127.100000, 1.000000>, <34.600000, -126.044789, 1.000000>, <38.200000, -126.344789, 1.000000>, 
      <29.250000, -128.750000, -1.000000>, <31.000000, -126.900000, -1.000000>, <34.600000, -125.800000, -1.000000>, <38.200000, -126.100000, -1.000000>, 
      <29.400000, -125.725000, 0.000000>, <31.250000, -123.850000, 0.000000>, <34.850000, -122.772395, 0.000000>, <38.450000, -123.072395, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <29.400000, -125.725000, 0.000000>, <31.250000, -123.850000, 0.000000>, <34.850000, -122.772395, 0.000000>, <38.450000, -123.072395, 0.000000>, 
      <29.550000, -122.700000, 1.000000>, <31.500000, -120.800000, 1.000000>, <35.100000, -119.744789, 1.000000>, <38.700000, -120.044789, 1.000000>, 
      <29.550000, -122.500000, -1.000000>, <31.500000, -120.600000, -1.000000>, <35.100000, -119.500000, -1.000000>, <38.700000, -119.800000, -1.000000>, 
      <29.700000, -119.475000, 0.000000>, <31.800000, -117.600000, 0.000000>, <35.350000, -116.522395, 0.000000>, <38.724132, -116.370658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <29.700000, -119.475000, 0.000000>, <31.800000, -117.600000, 0.000000>, <35.350000, -116.522395, 0.000000>, <38.724132, -116.370658, 0.000000>, 
      <29.850000, -116.450000, 1.000000>, <32.100000, -114.600000, 1.000000>, <35.600000, -113.544789, 1.000000>, <38.748263, -112.941315, 1.000000>, 
      <29.850000, -116.250000, -1.000000>, <32.100000, -114.400000, -1.000000>, <35.600000, -113.300000, -1.000000>, <38.750000, -112.700000, -1.000000>, 
      <30.000000, -113.200000, 0.000000>, <32.350000, -111.350000, 0.000000>, <35.900000, -110.272395, 0.000000>, <39.024132, -109.670658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <30.000000, -113.200000, 0.000000>, <32.350000, -111.350000, 0.000000>, <35.900000, -110.272395, 0.000000>, <39.024132, -109.670658, 0.000000>, 
      <30.150000, -110.150000, 1.000000>, <32.600000, -108.300000, 1.000000>, <36.200000, -107.244789, 1.000000>, <39.298263, -106.641315, 1.000000>, 
      <30.150000, -109.950000, -1.000000>, <32.600000, -108.100000, -1.000000>, <36.200000, -107.000000, -1.000000>, <39.300000, -106.400000, -1.000000>, 
      <30.275000, -106.950000, 0.000000>, <32.850000, -105.100000, 0.000000>, <36.450000, -104.022395, 0.000000>, <39.574132, -103.420658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <30.275000, -106.950000, 0.000000>, <32.850000, -105.100000, 0.000000>, <36.450000, -104.022395, 0.000000>, <39.574132, -103.420658, 0.000000>, 
      <30.400000, -103.950000, 1.000000>, <33.100000, -102.100000, 1.000000>, <36.700000, -101.044789, 1.000000>, <39.848263, -100.441315, 1.000000>, 
      <30.400000, -103.700000, -1.000000>, <33.100000, -101.900000, -1.000000>, <36.700000, -100.800000, -1.000000>, <39.850000, -100.200000, -1.000000>, 
      <30.525000, -100.336197, 0.000000>, <33.350000, -98.172395, 0.000000>, <36.950000, -97.772395, 0.000000>, <40.099132, -97.170658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <30.525000, -100.336197, 0.000000>, <33.350000, -98.172395, 0.000000>, <36.950000, -97.772395, 0.000000>, <40.099132, -97.170658, 0.000000>, 
      <30.650000, -96.972395, 1.000000>, <33.600000, -94.444789, 1.000000>, <37.200000, -94.744789, 1.000000>, <40.348263, -94.141315, 1.000000>, 
      <30.650000, -96.750000, -1.000000>, <33.600000, -94.200000, -1.000000>, <37.200000, -94.500000, -1.000000>, <40.350000, -93.900000, -1.000000>, 
      <30.825000, -93.736197, 0.000000>, <33.900000, -91.222395, 0.000000>, <37.450000, -91.522395, 0.000000>, <40.599132, -90.920658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <30.825000, -93.736197, 0.000000>, <33.900000, -91.222395, 0.000000>, <37.450000, -91.522395, 0.000000>, <40.599132, -90.920658, 0.000000>, 
      <31.000000, -90.722395, 1.000000>, <34.200000, -88.244789, 1.000000>, <37.700000, -88.544789, 1.000000>, <40.848263, -87.941315, 1.000000>, 
      <31.000000, -90.500000, -1.000000>, <34.200000, -88.000000, -1.000000>, <37.700000, -88.300000, -1.000000>, <40.850000, -87.700000, -1.000000>, 
      <31.125000, -87.461197, 0.000000>, <34.450000, -84.972395, 0.000000>, <38.000000, -85.272395, 0.000000>, <41.124132, -84.670658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.125000, -87.461197, 0.000000>, <34.450000, -84.972395, 0.000000>, <38.000000, -85.272395, 0.000000>, <41.124132, -84.670658, 0.000000>, 
      <31.250000, -84.422395, 1.000000>, <34.700000, -81.944789, 1.000000>, <38.300000, -82.244789, 1.000000>, <41.398263, -81.641315, 1.000000>, 
      <31.250000, -84.200000, -1.000000>, <34.700000, -81.700000, -1.000000>, <38.300000, -82.000000, -1.000000>, <41.400000, -81.400000, -1.000000>, 
      <31.400000, -81.211197, 0.000000>, <34.950000, -78.722395, 0.000000>, <38.550000, -79.022395, 0.000000>, <41.649132, -78.420658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.400000, -81.211197, 0.000000>, <34.950000, -78.722395, 0.000000>, <38.550000, -79.022395, 0.000000>, <41.649132, -78.420658, 0.000000>, 
      <31.550000, -78.222395, 1.000000>, <35.200000, -75.744789, 1.000000>, <38.800000, -76.044789, 1.000000>, <41.898263, -75.441315, 1.000000>, 
      <31.500000, -78.000000, -1.000000>, <35.200000, -75.500000, -1.000000>, <38.800000, -75.800000, -1.000000>, <41.950000, -75.200000, -1.000000>, 
      <31.650000, -74.961197, 0.000000>, <35.450000, -72.472395, 0.000000>, <39.050000, -72.772395, 0.000000>, <42.199132, -72.170658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.650000, -74.961197, 0.000000>, <35.450000, -72.472395, 0.000000>, <39.050000, -72.772395, 0.000000>, <42.199132, -72.170658, 0.000000>, 
      <31.800000, -71.922395, 1.000000>, <35.700000, -69.444789, 1.000000>, <39.300000, -69.744789, 1.000000>, <42.448263, -69.141315, 1.000000>, 
      <31.800000, -71.700000, -1.000000>, <35.700000, -69.200000, -1.000000>, <39.300000, -69.500000, -1.000000>, <42.450000, -68.900000, -1.000000>, 
      <31.950000, -68.686197, 0.000000>, <36.000000, -66.222395, 0.000000>, <39.550000, -66.522395, 0.000000>, <42.699132, -65.920658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.950000, -68.686197, 0.000000>, <36.000000, -66.222395, 0.000000>, <39.550000, -66.522395, 0.000000>, <42.699132, -65.920658, 0.000000>, 
      <32.100000, -65.672395, 1.000000>, <36.300000, -63.244789, 1.000000>, <39.800000, -63.544789, 1.000000>, <42.948263, -62.941315, 1.000000>, 
      <32.100000, -65.450000, -1.000000>, <36.300000, -63.000000, -1.000000>, <39.800000, -63.300000, -1.000000>, <42.950000, -62.700000, -1.000000>, 
      <31.950000, -62.436197, 0.000000>, <35.950000, -59.972395, 0.000000>, <39.500000, -60.272395, 0.000000>, <42.924132, -59.670658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.950000, -62.436197, 0.000000>, <35.950000, -59.972395, 0.000000>, <39.500000, -60.272395, 0.000000>, <42.924132, -59.670658, 0.000000>, 
      <31.800000, -59.422395, 1.000000>, <35.600000, -56.944789, 1.000000>, <39.200000, -57.244789, 1.000000>, <42.898263, -56.641315, 1.000000>, 
      <31.800000, -59.150000, -1.000000>, <35.600000, -56.700000, -1.000000>, <39.200000, -57.000000, -1.000000>, <42.900000, -56.400000, -1.000000>, 
      <31.925000, -56.161197, 0.000000>, <35.850000, -53.722395, 0.000000>, <39.450000, -54.022395, 0.000000>, <43.149132, -53.420658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.925000, -56.161197, 0.000000>, <35.850000, -53.722395, 0.000000>, <39.450000, -54.022395, 0.000000>, <43.149132, -53.420658, 0.000000>, 
      <32.050000, -53.172395, 1.000000>, <36.100000, -50.744789, 1.000000>, <39.700000, -51.044789, 1.000000>, <43.398263, -50.441315, 1.000000>, 
      <32.050000, -52.950000, -1.000000>, <36.100000, -50.500000, -1.000000>, <39.700000, -50.800000, -1.000000>, <43.400000, -50.200000, -1.000000>, 
      <32.175000, -49.911197, 0.000000>, <36.350000, -47.472395, 0.000000>, <39.950000, -47.772395, 0.000000>, <43.674132, -47.170658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.175000, -49.911197, 0.000000>, <36.350000, -47.472395, 0.000000>, <39.950000, -47.772395, 0.000000>, <43.674132, -47.170658, 0.000000>, 
      <32.300000, -46.872395, 1.000000>, <36.600000, -44.444789, 1.000000>, <40.200000, -44.744789, 1.000000>, <43.948263, -44.141315, 1.000000>, 
      <32.300000, -46.650000, -1.000000>, <36.600000, -44.200000, -1.000000>, <40.200000, -44.500000, -1.000000>, <43.950000, -43.900000, -1.000000>, 
      <31.925000, -43.686197, 0.000000>, <35.800000, -41.322395, 0.000000>, <39.400000, -41.622395, 0.000000>, <43.674132, -40.970658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.925000, -43.686197, 0.000000>, <35.800000, -41.322395, 0.000000>, <39.400000, -41.622395, 0.000000>, <43.674132, -40.970658, 0.000000>, 
      <31.550000, -40.722395, 1.000000>, <35.000000, -38.444789, 1.000000>, <38.600000, -38.744789, 1.000000>, <43.398263, -38.041315, 1.000000>, 
      <31.550000, -40.500000, -1.000000>, <35.000000, -38.200000, -1.000000>, <38.600000, -38.500000, -1.000000>, <43.400000, -37.800000, -1.000000>, 
      <31.700000, -37.511197, 0.000000>, <35.300000, -35.222395, 0.000000>, <38.850000, -35.522395, 0.000000>, <43.649132, -34.795658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <31.700000, -37.511197, 0.000000>, <35.300000, -35.222395, 0.000000>, <38.850000, -35.522395, 0.000000>, <43.649132, -34.795658, 0.000000>, 
      <31.850000, -34.522395, 1.000000>, <35.600000, -32.244789, 1.000000>, <39.100000, -32.544789, 1.000000>, <43.898263, -31.791315, 1.000000>, 
      <31.850000, -34.250000, -1.000000>, <35.600000, -32.000000, -1.000000>, <39.100000, -32.300000, -1.000000>, <43.900000, -31.550000, -1.000000>, 
      <32.000000, -31.236197, 0.000000>, <35.850000, -28.972395, 0.000000>, <39.400000, -29.272395, 0.000000>, <44.174132, -28.545658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.000000, -31.236197, 0.000000>, <35.850000, -28.972395, 0.000000>, <39.400000, -29.272395, 0.000000>, <44.174132, -28.545658, 0.000000>, 
      <32.150000, -28.222395, 1.000000>, <36.100000, -25.944789, 1.000000>, <39.700000, -26.244789, 1.000000>, <44.448263, -25.541315, 1.000000>, 
      <32.100000, -28.000000, -1.000000>, <36.100000, -25.700000, -1.000000>, <39.700000, -26.000000, -1.000000>, <44.450000, -25.300000, -1.000000>, 
      <32.250000, -24.986197, 0.000000>, <36.350000, -22.722395, 0.000000>, <39.950000, -23.022395, 0.000000>, <44.724132, -22.295658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.250000, -24.986197, 0.000000>, <36.350000, -22.722395, 0.000000>, <39.950000, -23.022395, 0.000000>, <44.724132, -22.295658, 0.000000>, 
      <32.400000, -21.972395, 1.000000>, <36.600000, -19.744789, 1.000000>, <40.200000, -20.044789, 1.000000>, <44.998263, -19.291315, 1.000000>, 
      <32.400000, -21.750000, -1.000000>, <36.600000, -19.500000, -1.000000>, <40.200000, -19.800000, -1.000000>, <45.000000, -19.050000, -1.000000>, 
      <32.636890, -19.205378, 0.039274>, <36.770182, -17.253756, 0.039274>, <40.366484, -17.412221, 0.039274>, <45.350011, -16.452603, 0.039274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.636890, -19.205378, 0.039274>, <36.770182, -17.253756, 0.039274>, <40.366484, -17.412221, 0.039274>, <45.350011, -16.452603, 0.039274>, 
      <32.873779, -16.660756, 1.078548>, <36.940365, -15.007512, 1.078548>, <40.532968, -15.024442, 1.078548>, <45.700023, -13.855206, 1.078548>, 
      <32.628949, -16.446423, 1.114652>, <36.695413, -14.793178, 1.114652>, <40.288016, -14.810108, 1.114652>, <45.463517, -13.641246, 1.114652>, 
      <32.486185, -13.216291, 0.564912>, <36.397706, -11.546589, 0.057326>, <40.350439, -11.596416, 1.114791>, <45.645310, -10.432830, 1.114791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.486185, -13.216291, 0.564912>, <36.397706, -11.546589, 0.057326>, <40.350439, -11.596416, 1.114791>, <45.645310, -10.432830, 1.114791>, 
      <32.356164, -9.986160, 0.020666>, <36.100000, -8.300000, -1.000000>, <40.412863, -8.382724, 1.114930>, <45.827103, -7.224413, 1.114930>, 
      <32.348965, -9.804724, 1.137895>, <36.084349, -8.151461, 1.133755>, <40.413873, -8.168390, 1.215635>, <45.836559, -7.010453, 1.215635>, 
      <32.355362, -6.720936, 0.576534>, <36.092175, -5.075730, 0.066877>, <40.428148, -5.139148, 1.165283>, <45.218874, -4.020499, 1.165283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.355362, -6.720936, 0.576534>, <36.092175, -5.075730, 0.066877>, <40.428148, -5.139148, 1.165283>, <45.218874, -4.020499, 1.165283>, 
      <32.374503, -3.637147, 0.020666>, <36.100000, -2.000000, -1.000000>, <40.442423, -2.109906, 1.114930>, <44.601188, -1.030545, 1.114930>, 
      <32.382084, -3.469302, 1.137895>, <36.113909, -1.878642, 1.133755>, <40.443433, -1.895572, 1.215635>, <44.604636, -0.816251, 1.215635>, 
      <32.677610, -0.624519, 1.108222>, <36.571477, 0.966150, 1.106151>, <40.532540, 0.949220, 1.147091>, <44.728210, 2.027987, 1.147091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.677610, -0.624519, 1.108222>, <36.571477, 0.966150, 1.106151>, <40.532540, 0.949220, 1.147091>, <44.728210, 2.027987, 1.147091>, 
      <32.973137, 2.220265, 1.078548>, <37.029045, 3.810943, 1.078548>, <40.621648, 3.794013, 1.078548>, <44.851783, 4.872225, 1.078548>, 
      <32.728306, 2.434598, 1.114652>, <36.784093, 4.025276, 1.114652>, <40.376696, 4.008346, 1.114652>, <44.609270, 5.086519, 1.114652>, 
      <32.589153, 5.606102, 1.057326>, <36.642047, 7.240243, 1.057326>, <40.238348, 7.231779, 1.057326>, <44.503766, 8.297602, 1.057326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.589153, 5.606102, 1.057326>, <36.642047, 7.240243, 1.057326>, <40.238348, 7.231779, 1.057326>, <44.503766, 8.297602, 1.057326>, 
      <32.450000, 8.777605, 1.000000>, <36.500000, 10.455211, 1.000000>, <40.100000, 10.455211, 1.000000>, <44.398263, 11.508685, 1.000000>, 
      <32.450000, 9.050000, -1.000000>, <36.500000, 10.700000, -1.000000>, <40.100000, 10.700000, -1.000000>, <44.400000, 11.750000, -1.000000>, 
      <32.450000, 12.063803, 0.000000>, <36.500000, 13.727605, 0.000000>, <40.100000, 13.727605, 0.000000>, <44.424132, 14.779342, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.450000, 12.063803, 0.000000>, <36.500000, 13.727605, 0.000000>, <40.100000, 13.727605, 0.000000>, <44.424132, 14.779342, 0.000000>, 
      <32.450000, 15.077605, 1.000000>, <36.500000, 16.755211, 1.000000>, <40.100000, 16.755211, 1.000000>, <44.448263, 17.808685, 1.000000>, 
      <32.450000, 15.300000, -1.000000>, <36.500000, 17.000000, -1.000000>, <40.100000, 17.000000, -1.000000>, <44.450000, 18.050000, -1.000000>, 
      <32.450000, 18.313803, 0.000000>, <36.500000, 19.977605, 0.000000>, <40.100000, 19.977605, 0.000000>, <44.499132, 21.054342, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.450000, 18.313803, 0.000000>, <36.500000, 19.977605, 0.000000>, <40.100000, 19.977605, 0.000000>, <44.499132, 21.054342, 0.000000>, 
      <32.450000, 21.327605, 1.000000>, <36.500000, 22.955211, 1.000000>, <40.100000, 22.955211, 1.000000>, <44.548263, 24.058685, 1.000000>, 
      <32.450000, 21.600000, -1.000000>, <36.500000, 23.300000, -1.000000>, <40.100000, 23.200000, -1.000000>, <44.550000, 24.300000, -1.000000>, 
      <32.500000, 24.763803, 0.000000>, <36.550000, 26.277605, 0.000000>, <40.150000, 26.227605, 0.000000>, <44.249132, 27.179342, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.500000, 24.763803, 0.000000>, <36.550000, 26.277605, 0.000000>, <40.150000, 26.227605, 0.000000>, <44.249132, 27.179342, 0.000000>, 
      <32.550000, 27.927605, 1.000000>, <36.600000, 29.255211, 1.000000>, <40.200000, 29.255211, 1.000000>, <43.948263, 30.058685, 1.000000>, 
      <32.500000, 28.150000, -1.000000>, <36.500000, 29.500000, -1.000000>, <40.100000, 29.500000, -1.000000>, <43.900000, 30.300000, -1.000000>, 
      <32.400000, 31.338803, 0.000000>, <36.200000, 32.527605, 0.000000>, <40.450000, 32.277605, 0.000000>, <45.149132, 33.254342, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.400000, 31.338803, 0.000000>, <36.200000, 32.527605, 0.000000>, <40.450000, 32.277605, 0.000000>, <45.149132, 33.254342, 0.000000>, 
      <32.300000, 34.527605, 1.000000>, <35.900000, 35.555211, 1.000000>, <40.800000, 35.055211, 1.000000>, <46.398263, 36.208685, 1.000000>, 
      <32.300000, 34.750000, -1.000000>, <35.900000, 35.800000, -1.000000>, <40.800000, 35.300000, -1.000000>, <46.400000, 36.500000, -1.000000>, 
      <32.525000, 37.813803, 0.000000>, <36.050000, 38.927605, 0.000000>, <41.648263, 38.631079, 0.000000>, <47.023263, 39.206079, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.525000, 37.813803, 0.000000>, <36.050000, 38.927605, 0.000000>, <41.648263, 38.631079, 0.000000>, <47.023263, 39.206079, 0.000000>, 
      <32.750000, 40.877605, 1.000000>, <36.200000, 42.055211, 1.000000>, <42.496526, 41.962159, 1.000000>, <47.646526, 41.912159, 1.000000>, 
      <32.750000, 41.100000, -1.000000>, <36.200000, 42.300000, -1.000000>, <42.500000, 42.200000, -1.000000>, <47.650000, 42.150000, -1.000000>, 
      <32.825000, 43.463803, 0.000000>, <36.150000, 44.477605, 0.000000>, <42.698263, 44.381079, 0.000000>, <47.848263, 44.306079, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <32.825000, 43.463803, 0.000000>, <36.150000, 44.477605, 0.000000>, <42.698263, 44.381079, 0.000000>, <47.848263, 44.306079, 0.000000>, 
      <32.900000, 45.827605, 1.000000>, <36.100000, 46.655211, 1.000000>, <42.896526, 46.562159, 1.000000>, <48.046526, 46.462159, 1.000000>, 
      <32.900000, 46.050000, -1.000000>, <36.100000, 46.900000, -1.000000>, <42.900000, 46.800000, -1.000000>, <48.050000, 46.750000, -1.000000>, 
      <32.900000, 50.327605, 0.700000>, <36.100000, 50.755211, 0.700000>, <43.196526, 50.662159, 0.700000>, <48.798263, 49.658685, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <37.300000, -136.500000, -1.000000>, <40.900000, -136.800000, -1.000000>, <43.600000, -135.300000, -1.000000>, <47.150000, -135.600000, -1.000000>, 
      <37.650000, -132.544789, 1.000000>, <41.200000, -132.844789, 1.000000>, <43.896526, -131.337841, 1.000000>, <47.496526, -131.637841, 1.000000>, 
      <37.650000, -132.300000, -1.000000>, <41.200000, -132.600000, -1.000000>, <43.900000, -131.100000, -1.000000>, <47.500000, -131.400000, -1.000000>, 
      <37.925000, -129.322395, 0.000000>, <41.500000, -129.622395, 0.000000>, <44.148263, -128.118921, 0.000000>, <47.748263, -128.418921, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <37.925000, -129.322395, 0.000000>, <41.500000, -129.622395, 0.000000>, <44.148263, -128.118921, 0.000000>, <47.748263, -128.418921, 0.000000>, 
      <38.200000, -126.344789, 1.000000>, <41.800000, -126.644789, 1.000000>, <44.396526, -125.137841, 1.000000>, <47.996526, -125.437841, 1.000000>, 
      <38.200000, -126.100000, -1.000000>, <41.800000, -126.400000, -1.000000>, <44.400000, -124.900000, -1.000000>, <48.000000, -125.200000, -1.000000>, 
      <38.450000, -123.072395, 0.000000>, <42.050000, -123.372395, 0.000000>, <44.698263, -121.868921, 0.000000>, <48.273263, -122.168921, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <38.450000, -123.072395, 0.000000>, <42.050000, -123.372395, 0.000000>, <44.698263, -121.868921, 0.000000>, <48.273263, -122.168921, 0.000000>, 
      <38.700000, -120.044789, 1.000000>, <42.300000, -120.344789, 1.000000>, <44.996526, -118.837841, 1.000000>, <48.546526, -119.137841, 1.000000>, 
      <38.700000, -119.800000, -1.000000>, <42.300000, -120.100000, -1.000000>, <45.000000, -118.600000, -1.000000>, <48.550000, -118.900000, -1.000000>, 
      <38.724132, -116.370658, 0.000000>, <42.098263, -116.218921, 0.000000>, <45.248263, -115.618921, 0.000000>, <48.798263, -115.918921, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <38.724132, -116.370658, 0.000000>, <42.098263, -116.218921, 0.000000>, <45.248263, -115.618921, 0.000000>, <48.798263, -115.918921, 0.000000>, 
      <38.748263, -112.941315, 1.000000>, <41.896526, -112.337841, 1.000000>, <45.496526, -112.637841, 1.000000>, <49.046526, -112.937841, 1.000000>, 
      <38.750000, -112.700000, -1.000000>, <41.900000, -112.100000, -1.000000>, <45.500000, -112.400000, -1.000000>, <49.050000, -112.700000, -1.000000>, 
      <39.024132, -109.670658, 0.000000>, <42.148263, -109.068921, 0.000000>, <45.748263, -109.368921, 0.000000>, <49.323263, -109.668921, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <39.024132, -109.670658, 0.000000>, <42.148263, -109.068921, 0.000000>, <45.748263, -109.368921, 0.000000>, <49.323263, -109.668921, 0.000000>, 
      <39.298263, -106.641315, 1.000000>, <42.396526, -106.037841, 1.000000>, <45.996526, -106.337841, 1.000000>, <49.596526, -106.637841, 1.000000>, 
      <39.300000, -106.400000, -1.000000>, <42.400000, -105.800000, -1.000000>, <46.000000, -106.100000, -1.000000>, <49.600000, -106.400000, -1.000000>, 
      <39.574132, -103.420658, 0.000000>, <42.698263, -102.818921, 0.000000>, <46.248263, -103.118921, 0.000000>, <50.074132, -103.870658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <39.574132, -103.420658, 0.000000>, <42.698263, -102.818921, 0.000000>, <46.248263, -103.118921, 0.000000>, <50.074132, -103.870658, 0.000000>, 
      <39.848263, -100.441315, 1.000000>, <42.996526, -99.837841, 1.000000>, <46.496526, -100.137841, 1.000000>, <50.548263, -101.341315, 1.000000>, 
      <39.850000, -100.200000, -1.000000>, <43.000000, -99.600000, -1.000000>, <46.500000, -99.900000, -1.000000>, <50.550000, -101.100000, -1.000000>, 
      <40.099132, -97.170658, 0.000000>, <43.248263, -96.568921, 0.000000>, <46.798263, -96.868921, 0.000000>, <50.824132, -98.070658, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <40.099132, -97.170658, 0.000000>, <43.248263, -96.568921, 0.000000>, <46.798263, -96.868921, 0.000000>, <50.824132, -98.070658, 0.000000>, 
      <40.348263, -94.141315, 1.000000>, <43.496526, -93.537841, 1.000000>, <47.096526, -93.837841, 1.000000>, <51.098263, -95.041315, 1.000000>, 
      <40.350000, -93.900000, -1.000000>, <43.500000, -93.300000, -1.000000>, <47.100000, -93.600000, -1.000000>, <51.100000, -94.800000, -1.000000>, 
      <40.599132, -90.920658, 0.000000>, <43.748263, -90.318921, 0.000000>, <47.348263, -90.618921, 0.000000>, <51.349132, -92.159460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <40.599132, -90.920658, 0.000000>, <43.748263, -90.318921, 0.000000>, <47.348263, -90.618921, 0.000000>, <51.349132, -92.159460, 0.000000>, 
      <40.848263, -87.941315, 1.000000>, <43.996526, -87.337841, 1.000000>, <47.596526, -87.637841, 1.000000>, <51.598263, -89.518921, 1.000000>, 
      <40.850000, -87.700000, -1.000000>, <44.000000, -87.100000, -1.000000>, <47.600000, -87.400000, -1.000000>, <51.600000, -89.300000, -1.000000>, 
      <41.124132, -84.670658, 0.000000>, <44.248263, -84.068921, 0.000000>, <47.848263, -84.368921, 0.000000>, <51.874132, -86.259460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <41.124132, -84.670658, 0.000000>, <44.248263, -84.068921, 0.000000>, <47.848263, -84.368921, 0.000000>, <51.874132, -86.259460, 0.000000>, 
      <41.398263, -81.641315, 1.000000>, <44.496526, -81.037841, 1.000000>, <48.096526, -81.337841, 1.000000>, <52.148263, -83.218921, 1.000000>, 
      <41.400000, -81.400000, -1.000000>, <44.500000, -80.800000, -1.000000>, <48.100000, -81.100000, -1.000000>, <52.150000, -83.000000, -1.000000>, 
      <41.649132, -78.420658, 0.000000>, <44.748263, -77.818921, 0.000000>, <48.348263, -78.118921, 0.000000>, <52.399132, -80.009460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <41.649132, -78.420658, 0.000000>, <44.748263, -77.818921, 0.000000>, <48.348263, -78.118921, 0.000000>, <52.399132, -80.009460, 0.000000>, 
      <41.898263, -75.441315, 1.000000>, <44.996526, -74.837841, 1.000000>, <48.596526, -75.137841, 1.000000>, <52.648263, -77.018921, 1.000000>, 
      <41.950000, -75.200000, -1.000000>, <45.100000, -74.600000, -1.000000>, <48.600000, -74.900000, -1.000000>, <52.650000, -76.800000, -1.000000>, 
      <42.199132, -72.170658, 0.000000>, <45.348263, -71.568921, 0.000000>, <48.898263, -71.868921, 0.000000>, <52.924132, -73.759460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <42.199132, -72.170658, 0.000000>, <45.348263, -71.568921, 0.000000>, <48.898263, -71.868921, 0.000000>, <52.924132, -73.759460, 0.000000>, 
      <42.448263, -69.141315, 1.000000>, <45.596526, -68.537841, 1.000000>, <49.196526, -68.837841, 1.000000>, <53.198263, -70.718921, 1.000000>, 
      <42.450000, -68.900000, -1.000000>, <45.600000, -68.300000, -1.000000>, <49.200000, -68.600000, -1.000000>, <53.200000, -70.500000, -1.000000>, 
      <42.699132, -65.920658, 0.000000>, <45.848263, -65.318921, 0.000000>, <49.448263, -65.618921, 0.000000>, <53.449132, -67.509460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <42.699132, -65.920658, 0.000000>, <45.848263, -65.318921, 0.000000>, <49.448263, -65.618921, 0.000000>, <53.449132, -67.509460, 0.000000>, 
      <42.948263, -62.941315, 1.000000>, <46.096526, -62.337841, 1.000000>, <49.696526, -62.637841, 1.000000>, <53.698263, -64.518921, 1.000000>, 
      <42.950000, -62.700000, -1.000000>, <46.100000, -62.100000, -1.000000>, <49.700000, -62.400000, -1.000000>, <53.700000, -64.300000, -1.000000>, 
      <42.924132, -59.670658, 0.000000>, <46.348263, -59.068921, 0.000000>, <49.948263, -59.368921, 0.000000>, <53.974132, -61.259460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <42.924132, -59.670658, 0.000000>, <46.348263, -59.068921, 0.000000>, <49.948263, -59.368921, 0.000000>, <53.974132, -61.259460, 0.000000>, 
      <42.898263, -56.641315, 1.000000>, <46.596526, -56.037841, 1.000000>, <50.196526, -56.337841, 1.000000>, <54.248263, -58.218921, 1.000000>, 
      <42.900000, -56.400000, -1.000000>, <46.600000, -55.800000, -1.000000>, <50.200000, -56.100000, -1.000000>, <54.250000, -58.000000, -1.000000>, 
      <43.149132, -53.420658, 0.000000>, <46.848263, -52.818921, 0.000000>, <50.448263, -53.118921, 0.000000>, <54.499132, -55.009460, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <43.149132, -53.420658, 0.000000>, <46.848263, -52.818921, 0.000000>, <50.448263, -53.118921, 0.000000>, <54.499132, -55.009460, 0.000000>, 
      <43.398263, -50.441315, 1.000000>, <47.096526, -49.837841, 1.000000>, <50.696526, -50.137841, 1.000000>, <54.748263, -52.018921, 1.000000>, 
      <43.400000, -50.200000, -1.000000>, <47.100000, -49.600000, -1.000000>, <50.700000, -49.900000, -1.000000>, <54.750000, -51.800000, -1.000000>, 
      <43.674132, -47.170658, 0.000000>, <47.398263, -46.568921, 0.000000>, <50.948263, -46.868921, 0.000000>, <54.886197, -49.211197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <43.674132, -47.170658, 0.000000>, <47.398263, -46.568921, 0.000000>, <50.948263, -46.868921, 0.000000>, <54.886197, -49.211197, 0.000000>, 
      <43.948263, -44.141315, 1.000000>, <47.696526, -43.537841, 1.000000>, <51.196526, -43.837841, 1.000000>, <55.022395, -46.622395, 1.000000>, 
      <43.950000, -43.900000, -1.000000>, <47.700000, -43.300000, -1.000000>, <51.200000, -43.600000, -1.000000>, <55.000000, -46.400000, -1.000000>, 
      <43.674132, -40.970658, 0.000000>, <47.948263, -40.318921, 0.000000>, <51.498263, -40.618921, 0.000000>, <55.286197, -43.411197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <43.674132, -40.970658, 0.000000>, <47.948263, -40.318921, 0.000000>, <51.498263, -40.618921, 0.000000>, <55.286197, -43.411197, 0.000000>, 
      <43.398263, -38.041315, 1.000000>, <48.196526, -37.337841, 1.000000>, <51.796526, -37.637841, 1.000000>, <55.572395, -40.422395, 1.000000>, 
      <43.400000, -37.800000, -1.000000>, <48.200000, -37.100000, -1.000000>, <51.800000, -37.400000, -1.000000>, <55.550000, -40.200000, -1.000000>, 
      <43.649132, -34.795658, 0.000000>, <48.448263, -34.068921, 0.000000>, <52.048263, -34.368921, 0.000000>, <55.836197, -37.161197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <43.649132, -34.795658, 0.000000>, <48.448263, -34.068921, 0.000000>, <52.048263, -34.368921, 0.000000>, <55.836197, -37.161197, 0.000000>, 
      <43.898263, -31.791315, 1.000000>, <48.696526, -31.037841, 1.000000>, <52.296526, -31.337841, 1.000000>, <56.122395, -34.122395, 1.000000>, 
      <43.900000, -31.550000, -1.000000>, <48.700000, -30.800000, -1.000000>, <52.300000, -31.100000, -1.000000>, <56.100000, -33.900000, -1.000000>, 
      <44.174132, -28.545658, 0.000000>, <48.948263, -27.818921, 0.000000>, <52.548263, -28.118921, 0.000000>, <56.361197, -30.911197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.174132, -28.545658, 0.000000>, <48.948263, -27.818921, 0.000000>, <52.548263, -28.118921, 0.000000>, <56.361197, -30.911197, 0.000000>, 
      <44.448263, -25.541315, 1.000000>, <49.196526, -24.837841, 1.000000>, <52.796526, -25.137841, 1.000000>, <56.622395, -27.922395, 1.000000>, 
      <44.450000, -25.300000, -1.000000>, <49.200000, -24.600000, -1.000000>, <52.800000, -24.900000, -1.000000>, <56.600000, -27.700000, -1.000000>, 
      <44.724132, -22.295658, 0.000000>, <49.498263, -21.568921, 0.000000>, <53.048263, -21.868921, 0.000000>, <56.861197, -24.661197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.724132, -22.295658, 0.000000>, <49.498263, -21.568921, 0.000000>, <53.048263, -21.868921, 0.000000>, <56.861197, -24.661197, 0.000000>, 
      <44.998263, -19.291315, 1.000000>, <49.796526, -18.537841, 1.000000>, <53.296526, -18.837841, 1.000000>, <57.122395, -21.622395, 1.000000>, 
      <45.000000, -19.050000, -1.000000>, <49.800000, -18.300000, -1.000000>, <53.300000, -18.600000, -1.000000>, <57.100000, -21.400000, -1.000000>, 
      <45.350011, -16.452603, 0.039274>, <50.333539, -15.492986, 0.039274>, <54.325320, -17.374099, 0.039274>, <57.902431, -19.375870, 0.039274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <45.350011, -16.452603, 0.039274>, <50.333539, -15.492986, 0.039274>, <54.325320, -17.374099, 0.039274>, <57.902431, -19.375870, 0.039274>, 
      <45.700023, -13.855206, 1.078548>, <50.867078, -12.685971, 1.078548>, <55.350641, -16.148198, 1.078548>, <58.704862, -17.351741, 1.078548>, 
      <45.463517, -13.641246, 1.114652>, <50.639018, -12.472384, 1.114652>, <55.122581, -14.579401, 1.114652>, <58.476802, -16.460548, 1.114652>, 
      <45.645310, -10.432830, 1.114791>, <50.940181, -9.269243, 1.114791>, <55.423744, -12.053865, 1.114791>, <58.777965, -13.596210, 1.114791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <45.645310, -10.432830, 1.114791>, <50.940181, -9.269243, 1.114791>, <55.423744, -12.053865, 1.114791>, <58.777965, -13.596210, 1.114791>, 
      <45.827103, -7.224413, 1.114930>, <51.241344, -6.066102, 1.114930>, <55.724907, -9.528330, 1.114930>, <59.079128, -10.731872, 1.114930>, 
      <45.836559, -7.010453, 1.215635>, <51.259246, -5.852515, 1.215635>, <55.742809, -9.314743, 1.215635>, <59.097030, -10.518285, 1.215635>, 
      <45.218874, -4.020499, 1.165283>, <50.009599, -2.901850, 1.165283>, <54.047024, -4.682304, 1.165283>, <58.488579, -6.240983, 1.165283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <45.218874, -4.020499, 1.165283>, <50.009599, -2.901850, 1.165283>, <54.047024, -4.682304, 1.165283>, <58.488579, -6.240983, 1.165283>, 
      <44.601188, -1.030545, 1.114930>, <48.759953, 0.048815, 1.114930>, <52.351240, -0.049866, 1.114930>, <57.880128, -1.963682, 1.114930>, 
      <44.604636, -0.816251, 1.215635>, <48.765840, 0.263070, 1.215635>, <52.357127, 0.164389, 1.215635>, <57.892023, -1.749761, 1.215635>, 
      <44.728210, 2.027987, 1.147091>, <48.923879, 3.106753, 1.147091>, <52.515166, 3.008072, 1.147091>, <58.022032, 0.637465, 1.147091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.728210, 2.027987, 1.147091>, <48.923879, 3.106753, 1.147091>, <52.515166, 3.008072, 1.147091>, <58.022032, 0.637465, 1.147091>, 
      <44.851783, 4.872225, 1.078548>, <49.081918, 5.950436, 1.078548>, <52.673205, 5.851755, 1.078548>, <58.152040, 3.024690, 1.078548>, 
      <44.609270, 5.086519, 1.114652>, <48.841843, 6.164691, 1.114652>, <52.433130, 6.066010, 1.114652>, <57.917973, 3.238611, 1.114652>, 
      <44.503766, 8.297602, 1.057326>, <48.769185, 9.363425, 1.057326>, <52.364828, 9.264084, 1.057326>, <57.920184, 6.433108, 1.057326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.503766, 8.297602, 1.057326>, <48.769185, 9.363425, 1.057326>, <52.364828, 9.264084, 1.057326>, <57.920184, 6.433108, 1.057326>, 
      <44.398263, 11.508685, 1.000000>, <48.696526, 12.562159, 1.000000>, <52.296526, 12.462159, 1.000000>, <57.922395, 9.627605, 1.000000>, 
      <44.400000, 11.750000, -1.000000>, <48.700000, 12.800000, -1.000000>, <52.300000, 12.700000, -1.000000>, <57.900000, 9.850000, -1.000000>, 
      <44.424132, 14.779342, 0.000000>, <48.748263, 15.831079, 0.000000>, <52.348263, 15.731079, 0.000000>, <58.061197, 12.888803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.424132, 14.779342, 0.000000>, <48.748263, 15.831079, 0.000000>, <52.348263, 15.731079, 0.000000>, <58.061197, 12.888803, 0.000000>, 
      <44.448263, 17.808685, 1.000000>, <48.796526, 18.862159, 1.000000>, <52.396526, 18.762159, 1.000000>, <58.222395, 15.927605, 1.000000>, 
      <44.450000, 18.050000, -1.000000>, <48.800000, 19.100000, -1.000000>, <52.400000, 19.000000, -1.000000>, <58.200000, 16.150000, -1.000000>, 
      <44.499132, 21.054342, 0.000000>, <48.898263, 22.131079, 0.000000>, <52.498263, 22.031079, 0.000000>, <58.411197, 19.163803, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.499132, 21.054342, 0.000000>, <48.898263, 22.131079, 0.000000>, <52.498263, 22.031079, 0.000000>, <58.411197, 19.163803, 0.000000>, 
      <44.548263, 24.058685, 1.000000>, <48.996526, 25.162159, 1.000000>, <52.596526, 25.062159, 1.000000>, <58.622395, 22.177605, 1.000000>, 
      <44.550000, 24.300000, -1.000000>, <49.000000, 25.400000, -1.000000>, <52.600000, 25.300000, -1.000000>, <58.600000, 22.400000, -1.000000>, 
      <44.249132, 27.179342, 0.000000>, <48.348263, 28.131079, 0.000000>, <53.850000, 26.977605, 0.000000>, <59.337066, 24.512066, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <44.249132, 27.179342, 0.000000>, <48.348263, 28.131079, 0.000000>, <53.850000, 26.977605, 0.000000>, <59.337066, 24.512066, 0.000000>, 
      <43.948263, 30.058685, 1.000000>, <47.696526, 30.862159, 1.000000>, <55.100000, 28.655211, 1.000000>, <60.074132, 26.624132, 1.000000>, 
      <43.900000, 30.300000, -1.000000>, <47.700000, 31.100000, -1.000000>, <55.100000, 28.900000, -1.000000>, <60.050000, 26.850000, -1.000000>, 
      <45.149132, 33.254342, 0.000000>, <49.848263, 34.231079, 0.000000>, <55.750000, 31.400000, 0.000000>, <60.537066, 29.023263, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <45.149132, 33.254342, 0.000000>, <49.848263, 34.231079, 0.000000>, <55.750000, 31.400000, 0.000000>, <60.537066, 29.023263, 0.000000>, 
      <46.398263, 36.208685, 1.000000>, <51.996526, 37.362159, 1.000000>, <56.400000, 33.900000, 1.000000>, <61.024132, 31.196526, 1.000000>, 
      <46.400000, 36.500000, -1.000000>, <52.000000, 37.700000, -1.000000>, <56.400000, 34.200000, -1.000000>, <61.000000, 31.450000, -1.000000>, 
      <47.023263, 39.206079, 0.000000>, <52.398263, 39.781079, 0.000000>, <56.850000, 36.300000, 0.000000>, <61.437066, 34.048263, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <47.023263, 39.206079, 0.000000>, <52.398263, 39.781079, 0.000000>, <56.850000, 36.300000, 0.000000>, <61.437066, 34.048263, 0.000000>, 
      <47.646526, 41.912159, 1.000000>, <52.796526, 41.862159, 1.000000>, <57.300000, 38.400000, 1.000000>, <61.874132, 36.646526, 1.000000>, 
      <47.650000, 42.150000, -1.000000>, <52.800000, 42.100000, -1.000000>, <57.300000, 38.600000, -1.000000>, <61.850000, 36.900000, -1.000000>, 
      <47.848263, 44.306079, 0.000000>, <52.998263, 44.231079, 0.000000>, <57.450000, 40.750000, 0.000000>, <62.037066, 39.048263, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <47.848263, 44.306079, 0.000000>, <52.998263, 44.231079, 0.000000>, <57.450000, 40.750000, 0.000000>, <62.037066, 39.048263, 0.000000>, 
      <48.046526, 46.462159, 1.000000>, <53.196526, 46.362159, 1.000000>, <57.600000, 42.900000, 1.000000>, <62.224132, 41.196526, 1.000000>, 
      <48.050000, 46.750000, -1.000000>, <53.200000, 46.700000, -1.000000>, <57.600000, 43.200000, -1.000000>, <62.200000, 41.450000, -1.000000>, 
      <48.798263, 49.658685, 0.700000>, <54.400000, 48.655211, 0.700000>, <58.000000, 47.000000, 0.700000>, <62.624132, 45.296526, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <47.150000, -135.600000, -1.000000>, <50.700000, -135.900000, -1.000000>, <55.200000, -138.000000, -1.000000>, <58.550000, -139.900000, -1.000000>, 
      <47.496526, -131.637841, 1.000000>, <51.096526, -131.937841, 1.000000>, <55.600000, -135.400000, 1.000000>, <58.924132, -136.603474, 1.000000>, 
      <47.500000, -131.400000, -1.000000>, <51.100000, -131.700000, -1.000000>, <55.600000, -135.200000, -1.000000>, <58.900000, -136.400000, -1.000000>, 
      <47.748263, -128.418921, 0.000000>, <51.348263, -128.718921, 0.000000>, <55.850000, -132.200000, 0.000000>, <59.162066, -133.401737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <47.748263, -128.418921, 0.000000>, <51.348263, -128.718921, 0.000000>, <55.850000, -132.200000, 0.000000>, <59.162066, -133.401737, 0.000000>, 
      <47.996526, -125.437841, 1.000000>, <51.596526, -125.737841, 1.000000>, <56.100000, -129.200000, 1.000000>, <59.424132, -130.403474, 1.000000>, 
      <48.000000, -125.200000, -1.000000>, <51.600000, -125.500000, -1.000000>, <56.100000, -129.000000, -1.000000>, <59.400000, -130.200000, -1.000000>, 
      <48.273263, -122.168921, 0.000000>, <51.848263, -122.468921, 0.000000>, <56.350000, -125.950000, 0.000000>, <59.800000, -126.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <48.273263, -122.168921, 0.000000>, <51.848263, -122.468921, 0.000000>, <56.350000, -125.950000, 0.000000>, <59.800000, -126.700000, 0.000000>, 
      <48.546526, -119.137841, 1.000000>, <52.096526, -119.437841, 1.000000>, <56.600000, -122.900000, 1.000000>, <60.200000, -123.200000, 1.000000>, 
      <48.550000, -118.900000, -1.000000>, <52.100000, -119.200000, -1.000000>, <56.600000, -122.700000, -1.000000>, <60.200000, -123.000000, -1.000000>, 
      <48.798263, -115.918921, 0.000000>, <52.348263, -116.218921, 0.000000>, <56.850000, -119.700000, 0.000000>, <60.450000, -120.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <48.798263, -115.918921, 0.000000>, <52.348263, -116.218921, 0.000000>, <56.850000, -119.700000, 0.000000>, <60.450000, -120.000000, 0.000000>, 
      <49.046526, -112.937841, 1.000000>, <52.596526, -113.237841, 1.000000>, <57.100000, -116.700000, 1.000000>, <60.700000, -117.000000, 1.000000>, 
      <49.050000, -112.700000, -1.000000>, <52.600000, -113.000000, -1.000000>, <57.100000, -116.500000, -1.000000>, <60.700000, -116.800000, -1.000000>, 
      <49.323263, -109.668921, 0.000000>, <52.898263, -109.968921, 0.000000>, <57.350000, -113.450000, 0.000000>, <60.950000, -113.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <49.323263, -109.668921, 0.000000>, <52.898263, -109.968921, 0.000000>, <57.350000, -113.450000, 0.000000>, <60.950000, -113.750000, 0.000000>, 
      <49.596526, -106.637841, 1.000000>, <53.196526, -106.937841, 1.000000>, <57.600000, -110.400000, 1.000000>, <61.200000, -110.700000, 1.000000>, 
      <49.600000, -106.400000, -1.000000>, <53.200000, -106.700000, -1.000000>, <57.700000, -110.200000, -1.000000>, <61.250000, -110.500000, -1.000000>, 
      <50.074132, -103.870658, 0.000000>, <53.900000, -104.622395, 0.000000>, <57.950000, -107.200000, 0.000000>, <61.500000, -107.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <50.074132, -103.870658, 0.000000>, <53.900000, -104.622395, 0.000000>, <57.950000, -107.200000, 0.000000>, <61.500000, -107.500000, 0.000000>, 
      <50.548263, -101.341315, 1.000000>, <54.600000, -102.544789, 1.000000>, <58.200000, -104.200000, 1.000000>, <61.750000, -104.500000, 1.000000>, 
      <50.550000, -101.100000, -1.000000>, <54.600000, -102.300000, -1.000000>, <58.200000, -104.000000, -1.000000>, <61.750000, -104.300000, -1.000000>, 
      <50.824132, -98.070658, 0.000000>, <54.850000, -99.272395, 0.000000>, <58.450000, -100.950000, 0.000000>, <62.025000, -101.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <50.824132, -98.070658, 0.000000>, <54.850000, -99.272395, 0.000000>, <58.450000, -100.950000, 0.000000>, <62.025000, -101.250000, 0.000000>, 
      <51.098263, -95.041315, 1.000000>, <55.100000, -96.244789, 1.000000>, <58.700000, -97.900000, 1.000000>, <62.300000, -98.200000, 1.000000>, 
      <51.100000, -94.800000, -1.000000>, <55.100000, -96.000000, -1.000000>, <58.700000, -97.700000, -1.000000>, <62.300000, -98.000000, -1.000000>, 
      <51.349132, -92.159460, 0.000000>, <55.350000, -93.700000, 0.000000>, <58.724132, -95.603474, 0.000000>, <62.437066, -95.451737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <51.349132, -92.159460, 0.000000>, <55.350000, -93.700000, 0.000000>, <58.724132, -95.603474, 0.000000>, <62.437066, -95.451737, 0.000000>, 
      <51.598263, -89.518921, 1.000000>, <55.600000, -91.400000, 1.000000>, <58.748263, -93.506948, 1.000000>, <62.574132, -92.903474, 1.000000>, 
      <51.600000, -89.300000, -1.000000>, <55.600000, -91.200000, -1.000000>, <58.700000, -93.300000, -1.000000>, <62.550000, -92.700000, -1.000000>, 
      <51.874132, -86.259460, 0.000000>, <55.900000, -88.150000, 0.000000>, <58.974132, -90.253474, 0.000000>, <62.812066, -89.651737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <51.874132, -86.259460, 0.000000>, <55.900000, -88.150000, 0.000000>, <58.974132, -90.253474, 0.000000>, <62.812066, -89.651737, 0.000000>, 
      <52.148263, -83.218921, 1.000000>, <56.200000, -85.100000, 1.000000>, <59.248263, -87.206948, 1.000000>, <63.074132, -86.603474, 1.000000>, 
      <52.150000, -83.000000, -1.000000>, <56.200000, -84.900000, -1.000000>, <59.200000, -87.000000, -1.000000>, <63.050000, -86.400000, -1.000000>, 
      <52.399132, -80.009460, 0.000000>, <56.450000, -81.900000, 0.000000>, <59.524132, -84.003474, 0.000000>, <63.337066, -83.401737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <52.399132, -80.009460, 0.000000>, <56.450000, -81.900000, 0.000000>, <59.524132, -84.003474, 0.000000>, <63.337066, -83.401737, 0.000000>, 
      <52.648263, -77.018921, 1.000000>, <56.700000, -78.900000, 1.000000>, <59.848263, -81.006948, 1.000000>, <63.624132, -80.403474, 1.000000>, 
      <52.650000, -76.800000, -1.000000>, <56.700000, -78.700000, -1.000000>, <59.800000, -80.800000, -1.000000>, <63.600000, -80.200000, -1.000000>, 
      <52.924132, -73.759460, 0.000000>, <56.950000, -75.650000, 0.000000>, <60.074132, -77.753474, 0.000000>, <63.887066, -77.151737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <52.924132, -73.759460, 0.000000>, <56.950000, -75.650000, 0.000000>, <60.074132, -77.753474, 0.000000>, <63.887066, -77.151737, 0.000000>, 
      <53.198263, -70.718921, 1.000000>, <57.200000, -72.600000, 1.000000>, <60.348263, -74.706948, 1.000000>, <64.174132, -74.103474, 1.000000>, 
      <53.200000, -70.500000, -1.000000>, <57.200000, -72.400000, -1.000000>, <60.300000, -74.500000, -1.000000>, <64.150000, -73.900000, -1.000000>, 
      <53.449132, -67.509460, 0.000000>, <57.450000, -69.400000, 0.000000>, <60.574132, -71.503474, 0.000000>, <64.412066, -70.901737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <53.449132, -67.509460, 0.000000>, <57.450000, -69.400000, 0.000000>, <60.574132, -71.503474, 0.000000>, <64.412066, -70.901737, 0.000000>, 
      <53.698263, -64.518921, 1.000000>, <57.700000, -66.400000, 1.000000>, <60.848263, -68.506948, 1.000000>, <64.674132, -67.903474, 1.000000>, 
      <53.700000, -64.300000, -1.000000>, <57.700000, -66.200000, -1.000000>, <60.800000, -68.300000, -1.000000>, <64.650000, -67.700000, -1.000000>, 
      <53.974132, -61.259460, 0.000000>, <58.000000, -63.150000, 0.000000>, <61.074132, -65.253474, 0.000000>, <64.912066, -64.651737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <53.974132, -61.259460, 0.000000>, <58.000000, -63.150000, 0.000000>, <61.074132, -65.253474, 0.000000>, <64.912066, -64.651737, 0.000000>, 
      <54.248263, -58.218921, 1.000000>, <58.300000, -60.100000, 1.000000>, <61.348263, -62.206948, 1.000000>, <65.174132, -61.603474, 1.000000>, 
      <54.250000, -58.000000, -1.000000>, <58.300000, -59.900000, -1.000000>, <61.300000, -62.000000, -1.000000>, <65.150000, -61.400000, -1.000000>, 
      <54.499132, -55.009460, 0.000000>, <58.550000, -56.900000, 0.000000>, <61.624132, -59.003474, 0.000000>, <65.437066, -58.401737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <54.499132, -55.009460, 0.000000>, <58.550000, -56.900000, 0.000000>, <61.624132, -59.003474, 0.000000>, <65.437066, -58.401737, 0.000000>, 
      <54.748263, -52.018921, 1.000000>, <58.800000, -53.900000, 1.000000>, <61.948263, -56.006948, 1.000000>, <65.724132, -55.403474, 1.000000>, 
      <54.750000, -51.800000, -1.000000>, <58.800000, -53.700000, -1.000000>, <61.900000, -55.800000, -1.000000>, <65.700000, -55.200000, -1.000000>, 
      <54.886197, -49.211197, 0.000000>, <58.824132, -51.553474, 0.000000>, <62.174132, -52.753474, 0.000000>, <65.962066, -52.151737, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <54.886197, -49.211197, 0.000000>, <58.824132, -51.553474, 0.000000>, <62.174132, -52.753474, 0.000000>, <65.962066, -52.151737, 0.000000>, 
      <55.022395, -46.622395, 1.000000>, <58.848263, -49.406948, 1.000000>, <62.448263, -49.706948, 1.000000>, <66.224132, -49.103474, 1.000000>, 
      <55.000000, -46.400000, -1.000000>, <58.800000, -49.200000, -1.000000>, <62.400000, -49.500000, -1.000000>, <66.250000, -48.900000, -1.000000>, 
      <55.286197, -43.411197, 0.000000>, <59.074132, -46.203474, 0.000000>, <62.900000, -45.600000, 0.000000>, <66.625000, -45.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <55.286197, -43.411197, 0.000000>, <59.074132, -46.203474, 0.000000>, <62.900000, -45.600000, 0.000000>, <66.625000, -45.450000, 0.000000>, 
      <55.572395, -40.422395, 1.000000>, <59.348263, -43.206948, 1.000000>, <63.400000, -41.700000, 1.000000>, <67.000000, -42.000000, 1.000000>, 
      <55.550000, -40.200000, -1.000000>, <59.300000, -43.000000, -1.000000>, <63.400000, -41.500000, -1.000000>, <67.000000, -41.800000, -1.000000>, 
      <55.836197, -37.161197, 0.000000>, <59.624132, -39.953474, 0.000000>, <63.650000, -38.450000, 0.000000>, <67.250000, -38.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <55.836197, -37.161197, 0.000000>, <59.624132, -39.953474, 0.000000>, <63.650000, -38.450000, 0.000000>, <67.250000, -38.750000, 0.000000>, 
      <56.122395, -34.122395, 1.000000>, <59.948263, -36.906948, 1.000000>, <63.900000, -35.400000, 1.000000>, <67.500000, -35.700000, 1.000000>, 
      <56.100000, -33.900000, -1.000000>, <59.900000, -36.700000, -1.000000>, <63.900000, -35.200000, -1.000000>, <67.500000, -35.500000, -1.000000>, 
      <56.361197, -30.911197, 0.000000>, <60.174132, -33.703474, 0.000000>, <64.200000, -32.200000, 0.000000>, <67.775000, -32.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <56.361197, -30.911197, 0.000000>, <60.174132, -33.703474, 0.000000>, <64.200000, -32.200000, 0.000000>, <67.775000, -32.500000, 0.000000>, 
      <56.622395, -27.922395, 1.000000>, <60.448263, -30.706948, 1.000000>, <64.500000, -29.200000, 1.000000>, <68.050000, -29.500000, 1.000000>, 
      <56.600000, -27.700000, -1.000000>, <60.400000, -30.500000, -1.000000>, <64.500000, -29.000000, -1.000000>, <68.050000, -29.300000, -1.000000>, 
      <56.861197, -24.661197, 0.000000>, <60.674132, -27.453474, 0.000000>, <64.750000, -25.950000, 0.000000>, <68.300000, -26.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <56.861197, -24.661197, 0.000000>, <60.674132, -27.453474, 0.000000>, <64.750000, -25.950000, 0.000000>, <68.300000, -26.250000, 0.000000>, 
      <57.122395, -21.622395, 1.000000>, <60.948263, -24.406948, 1.000000>, <65.000000, -22.900000, 1.000000>, <68.550000, -23.200000, 1.000000>, 
      <57.100000, -21.400000, -1.000000>, <60.900000, -24.200000, -1.000000>, <65.000000, -22.700000, -1.000000>, <68.550000, -23.000000, -1.000000>, 
      <57.902431, -19.375870, 0.039274>, <61.479541, -21.377642, 0.039274>, <65.545455, -19.874202, 0.039274>, <69.110499, -20.174236, 0.039274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <57.902431, -19.375870, 0.039274>, <61.479541, -21.377642, 0.039274>, <65.545455, -19.874202, 0.039274>, <69.110499, -20.174236, 0.039274>, 
      <58.704862, -17.351741, 1.078548>, <62.059083, -18.555283, 1.078548>, <66.090909, -17.048404, 1.078548>, <69.670999, -17.348472, 1.078548>, 
      <58.476802, -16.460548, 1.114652>, <61.831023, -18.341696, 1.114652>, <65.862849, -16.834817, 1.114652>, <69.442939, -17.134885, 1.114652>, 
      <58.777965, -13.596210, 1.114791>, <62.132186, -15.138555, 1.114791>, <66.164012, -13.631676, 1.114791>, <69.744102, -13.931745, 1.114791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.777965, -13.596210, 1.114791>, <62.132186, -15.138555, 1.114791>, <66.164012, -13.631676, 1.114791>, <69.744102, -13.931745, 1.114791>, 
      <59.079128, -10.731872, 1.114930>, <62.433349, -11.935414, 1.114930>, <66.465175, -10.428535, 1.114930>, <70.045265, -10.728604, 1.114930>, 
      <59.097030, -10.518285, 1.215635>, <62.451251, -11.721827, 1.215635>, <66.483077, -10.214948, 1.215635>, <70.063167, -10.515017, 1.215635>, 
      <58.488579, -6.240983, 1.165283>, <62.930134, -7.799662, 1.165283>, <66.736092, -7.196257, 1.165283>, <70.316181, -7.496325, 1.165283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.488579, -6.240983, 1.165283>, <62.930134, -7.799662, 1.165283>, <66.736092, -7.196257, 1.165283>, <70.316181, -7.496325, 1.165283>, 
      <57.880128, -1.963682, 1.114930>, <63.409017, -3.877497, 1.114930>, <66.989106, -4.177566, 1.114930>, <70.569196, -4.477634, 1.114930>, 
      <57.892023, -1.749761, 1.215635>, <63.426919, -3.663910, 1.215635>, <67.007008, -3.963979, 1.215635>, <70.587098, -4.264047, 1.215635>, 
      <58.022032, 0.637465, 1.147091>, <63.528897, -1.733143, 1.147091>, <67.334855, -1.129737, 1.147091>, <70.914944, -1.429806, 1.147091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.022032, 0.637465, 1.147091>, <63.528897, -1.733143, 1.147091>, <67.334855, -1.129737, 1.147091>, <70.914944, -1.429806, 1.147091>, 
      <58.152040, 3.024690, 1.078548>, <63.630875, 0.197625, 1.078548>, <67.662702, 1.704504, 1.078548>, <71.242791, 1.404436, 1.078548>, 
      <57.917973, 3.238611, 1.114652>, <63.402815, 0.411212, 1.114652>, <67.434642, 1.918091, 1.114652>, <71.014731, 1.618023, 1.114652>, 
      <57.920184, 6.433108, 1.057326>, <63.475539, 3.602132, 1.057326>, <67.517321, 5.109046, 1.057326>, <71.107365, 4.809011, 1.057326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <57.920184, 6.433108, 1.057326>, <63.475539, 3.602132, 1.057326>, <67.517321, 5.109046, 1.057326>, <71.107365, 4.809011, 1.057326>, 
      <57.922395, 9.627605, 1.000000>, <63.548263, 6.793052, 1.000000>, <67.600000, 8.300000, 1.000000>, <71.200000, 8.000000, 1.000000>, 
      <57.900000, 9.850000, -1.000000>, <63.500000, 7.000000, -1.000000>, <67.600000, 8.500000, -1.000000>, <71.200000, 8.200000, -1.000000>, 
      <58.061197, 12.888803, 0.000000>, <63.774132, 10.046526, 0.000000>, <67.850000, 11.550000, 0.000000>, <71.450000, 11.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.061197, 12.888803, 0.000000>, <63.774132, 10.046526, 0.000000>, <67.850000, 11.550000, 0.000000>, <71.450000, 11.250000, 0.000000>, 
      <58.222395, 15.927605, 1.000000>, <64.048263, 13.093052, 1.000000>, <68.100000, 14.600000, 1.000000>, <71.700000, 14.300000, 1.000000>, 
      <58.200000, 16.150000, -1.000000>, <64.000000, 13.300000, -1.000000>, <68.100000, 14.800000, -1.000000>, <71.700000, 14.500000, -1.000000>, 
      <58.411197, 19.163803, 0.000000>, <64.324132, 16.296526, 0.000000>, <68.400000, 17.800000, 0.000000>, <71.975000, 17.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.411197, 19.163803, 0.000000>, <64.324132, 16.296526, 0.000000>, <68.400000, 17.800000, 0.000000>, <71.975000, 17.500000, 0.000000>, 
      <58.622395, 22.177605, 1.000000>, <64.648263, 19.293052, 1.000000>, <68.700000, 20.800000, 1.000000>, <72.250000, 20.500000, 1.000000>, 
      <58.600000, 22.400000, -1.000000>, <64.600000, 19.500000, -1.000000>, <68.700000, 21.000000, -1.000000>, <72.250000, 20.700000, -1.000000>, 
      <59.337066, 24.512066, 0.000000>, <64.824132, 22.046526, 0.000000>, <68.900000, 23.550000, 0.000000>, <72.475000, 23.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <59.337066, 24.512066, 0.000000>, <64.824132, 22.046526, 0.000000>, <68.900000, 23.550000, 0.000000>, <72.475000, 23.250000, 0.000000>, 
      <60.074132, 26.624132, 1.000000>, <65.048263, 24.593052, 1.000000>, <69.100000, 26.100000, 1.000000>, <72.700000, 25.800000, 1.000000>, 
      <60.050000, 26.850000, -1.000000>, <65.000000, 24.800000, -1.000000>, <69.100000, 26.300000, -1.000000>, <72.700000, 26.000000, -1.000000>, 
      <60.537066, 29.023263, 0.000000>, <65.324132, 26.646526, 0.000000>, <69.400000, 28.150000, 0.000000>, <73.025000, 28.025000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <60.537066, 29.023263, 0.000000>, <65.324132, 26.646526, 0.000000>, <69.400000, 28.150000, 0.000000>, <73.025000, 28.025000, 0.000000>, 
      <61.024132, 31.196526, 1.000000>, <65.648263, 28.493052, 1.000000>, <69.700000, 30.000000, 1.000000>, <73.350000, 30.050000, 1.000000>, 
      <61.000000, 31.450000, -1.000000>, <65.600000, 28.700000, -1.000000>, <69.700000, 30.200000, -1.000000>, <73.350000, 30.300000, -1.000000>, 
      <61.437066, 34.048263, 0.000000>, <66.024132, 31.796526, 0.000000>, <70.100000, 33.300000, 0.000000>, <73.675000, 33.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <61.437066, 34.048263, 0.000000>, <66.024132, 31.796526, 0.000000>, <70.100000, 33.300000, 0.000000>, <73.675000, 33.350000, 0.000000>, 
      <61.874132, 36.646526, 1.000000>, <66.448263, 34.893052, 1.000000>, <70.500000, 36.400000, 1.000000>, <74.000000, 36.400000, 1.000000>, 
      <61.850000, 36.900000, -1.000000>, <66.400000, 35.200000, -1.000000>, <70.500000, 36.700000, -1.000000>, <74.000000, 36.650000, -1.000000>, 
      <62.037066, 39.048263, 0.000000>, <66.624132, 37.346526, 0.000000>, <70.700000, 38.850000, 0.000000>, <74.575000, 39.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <62.037066, 39.048263, 0.000000>, <66.624132, 37.346526, 0.000000>, <70.700000, 38.850000, 0.000000>, <74.575000, 39.050000, 0.000000>, 
      <62.224132, 41.196526, 1.000000>, <66.848263, 39.493052, 1.000000>, <70.900000, 41.000000, 1.000000>, <75.150000, 41.450000, 1.000000>, 
      <62.200000, 41.450000, -1.000000>, <66.800000, 39.700000, -1.000000>, <70.900000, 41.200000, -1.000000>, <75.150000, 41.650000, -1.000000>, 
      <62.624132, 45.296526, 0.700000>, <67.248263, 43.593052, 0.700000>, <71.200000, 45.100000, 0.700000>, <76.000000, 45.000000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <58.550000, -139.900000, -1.000000>, <61.900000, -141.800000, -1.000000>, <65.900000, -140.300000, -1.000000>, <69.200000, -144.600000, -1.000000>, 
      <58.924132, -136.603474, 1.000000>, <62.248263, -137.806948, 1.000000>, <66.300000, -136.300000, 1.000000>, <69.550000, -140.650000, 1.000000>, 
      <58.900000, -136.400000, -1.000000>, <62.200000, -137.600000, -1.000000>, <66.300000, -136.100000, -1.000000>, <69.550000, -140.450000, -1.000000>, 
      <59.162066, -133.401737, 0.000000>, <62.474132, -134.603474, 0.000000>, <66.550000, -133.100000, 0.000000>, <69.800000, -137.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <59.162066, -133.401737, 0.000000>, <62.474132, -134.603474, 0.000000>, <66.550000, -133.100000, 0.000000>, <69.800000, -137.425000, 0.000000>, 
      <59.424132, -130.403474, 1.000000>, <62.748263, -131.606948, 1.000000>, <66.800000, -130.100000, 1.000000>, <70.050000, -134.400000, 1.000000>, 
      <59.400000, -130.200000, -1.000000>, <62.700000, -131.400000, -1.000000>, <66.800000, -129.900000, -1.000000>, <70.050000, -134.200000, -1.000000>, 
      <59.800000, -126.700000, 0.000000>, <63.250000, -127.450000, 0.000000>, <67.050000, -126.850000, 0.000000>, <70.325000, -131.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <59.800000, -126.700000, 0.000000>, <63.250000, -127.450000, 0.000000>, <67.050000, -126.850000, 0.000000>, <70.325000, -131.175000, 0.000000>, 
      <60.200000, -123.200000, 1.000000>, <63.800000, -123.500000, 1.000000>, <67.300000, -123.800000, 1.000000>, <70.600000, -128.150000, 1.000000>, 
      <60.200000, -123.000000, -1.000000>, <63.800000, -123.300000, -1.000000>, <67.300000, -123.600000, -1.000000>, <70.600000, -127.950000, -1.000000>, 
      <60.450000, -120.000000, 0.000000>, <64.050000, -120.300000, 0.000000>, <67.600000, -120.600000, 0.000000>, <70.875000, -124.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <60.450000, -120.000000, 0.000000>, <64.050000, -120.300000, 0.000000>, <67.600000, -120.600000, 0.000000>, <70.875000, -124.925000, 0.000000>, 
      <60.700000, -117.000000, 1.000000>, <64.300000, -117.300000, 1.000000>, <67.900000, -117.600000, 1.000000>, <71.150000, -121.900000, 1.000000>, 
      <60.700000, -116.800000, -1.000000>, <64.300000, -117.100000, -1.000000>, <67.900000, -117.400000, -1.000000>, <71.150000, -121.700000, -1.000000>, 
      <60.950000, -113.750000, 0.000000>, <64.550000, -114.050000, 0.000000>, <68.150000, -114.350000, 0.000000>, <71.400000, -118.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <60.950000, -113.750000, 0.000000>, <64.550000, -114.050000, 0.000000>, <68.150000, -114.350000, 0.000000>, <71.400000, -118.675000, 0.000000>, 
      <61.200000, -110.700000, 1.000000>, <64.800000, -111.000000, 1.000000>, <68.400000, -111.300000, 1.000000>, <71.650000, -115.650000, 1.000000>, 
      <61.250000, -110.500000, -1.000000>, <64.800000, -110.800000, -1.000000>, <68.400000, -111.100000, -1.000000>, <71.650000, -115.450000, -1.000000>, 
      <61.500000, -107.500000, 0.000000>, <65.050000, -107.800000, 0.000000>, <68.650000, -108.100000, 0.000000>, <71.900000, -112.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <61.500000, -107.500000, 0.000000>, <65.050000, -107.800000, 0.000000>, <68.650000, -108.100000, 0.000000>, <71.900000, -112.425000, 0.000000>, 
      <61.750000, -104.500000, 1.000000>, <65.300000, -104.800000, 1.000000>, <68.900000, -105.100000, 1.000000>, <72.150000, -109.400000, 1.000000>, 
      <61.750000, -104.300000, -1.000000>, <65.300000, -104.600000, -1.000000>, <68.900000, -104.900000, -1.000000>, <72.150000, -109.200000, -1.000000>, 
      <62.025000, -101.250000, 0.000000>, <65.600000, -101.550000, 0.000000>, <69.150000, -101.850000, 0.000000>, <72.425000, -106.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <62.025000, -101.250000, 0.000000>, <65.600000, -101.550000, 0.000000>, <69.150000, -101.850000, 0.000000>, <72.425000, -106.175000, 0.000000>, 
      <62.300000, -98.200000, 1.000000>, <65.900000, -98.500000, 1.000000>, <69.400000, -98.800000, 1.000000>, <72.700000, -103.150000, 1.000000>, 
      <62.300000, -98.000000, -1.000000>, <65.900000, -98.300000, -1.000000>, <69.400000, -98.600000, -1.000000>, <72.700000, -102.950000, -1.000000>, 
      <62.437066, -95.451737, 0.000000>, <66.150000, -95.300000, 0.000000>, <69.700000, -95.600000, 0.000000>, <72.900000, -100.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <62.437066, -95.451737, 0.000000>, <66.150000, -95.300000, 0.000000>, <69.700000, -95.600000, 0.000000>, <72.900000, -100.725000, 0.000000>, 
      <62.574132, -92.903474, 1.000000>, <66.400000, -92.300000, 1.000000>, <70.000000, -92.600000, 1.000000>, <73.100000, -98.500000, 1.000000>, 
      <62.550000, -92.700000, -1.000000>, <66.400000, -92.100000, -1.000000>, <70.000000, -92.400000, -1.000000>, <73.100000, -98.300000, -1.000000>, 
      <62.812066, -89.651737, 0.000000>, <66.650000, -89.050000, 0.000000>, <70.250000, -89.350000, 0.000000>, <73.550000, -95.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <62.812066, -89.651737, 0.000000>, <66.650000, -89.050000, 0.000000>, <70.250000, -89.350000, 0.000000>, <73.550000, -95.300000, 0.000000>, 
      <63.074132, -86.603474, 1.000000>, <66.900000, -86.000000, 1.000000>, <70.500000, -86.300000, 1.000000>, <74.000000, -92.300000, 1.000000>, 
      <63.050000, -86.400000, -1.000000>, <66.900000, -85.800000, -1.000000>, <70.500000, -86.100000, -1.000000>, <74.000000, -92.100000, -1.000000>, 
      <63.337066, -83.401737, 0.000000>, <67.150000, -82.800000, 0.000000>, <70.750000, -83.100000, 0.000000>, <74.250000, -89.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <63.337066, -83.401737, 0.000000>, <67.150000, -82.800000, 0.000000>, <70.750000, -83.100000, 0.000000>, <74.250000, -89.100000, 0.000000>, 
      <63.624132, -80.403474, 1.000000>, <67.400000, -79.800000, 1.000000>, <71.000000, -80.100000, 1.000000>, <74.500000, -86.100000, 1.000000>, 
      <63.600000, -80.200000, -1.000000>, <67.400000, -79.600000, -1.000000>, <71.000000, -79.900000, -1.000000>, <74.500000, -85.900000, -1.000000>, 
      <63.887066, -77.151737, 0.000000>, <67.700000, -76.550000, 0.000000>, <71.250000, -76.850000, 0.000000>, <74.775000, -82.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <63.887066, -77.151737, 0.000000>, <67.700000, -76.550000, 0.000000>, <71.250000, -76.850000, 0.000000>, <74.775000, -82.850000, 0.000000>, 
      <64.174132, -74.103474, 1.000000>, <68.000000, -73.500000, 1.000000>, <71.500000, -73.800000, 1.000000>, <75.050000, -79.800000, 1.000000>, 
      <64.150000, -73.900000, -1.000000>, <68.000000, -73.300000, -1.000000>, <71.500000, -73.600000, -1.000000>, <75.050000, -79.600000, -1.000000>, 
      <64.412066, -70.901737, 0.000000>, <68.250000, -70.300000, 0.000000>, <71.800000, -70.600000, 0.000000>, <75.325000, -76.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <64.412066, -70.901737, 0.000000>, <68.250000, -70.300000, 0.000000>, <71.800000, -70.600000, 0.000000>, <75.325000, -76.600000, 0.000000>, 
      <64.674132, -67.903474, 1.000000>, <68.500000, -67.300000, 1.000000>, <72.100000, -67.600000, 1.000000>, <75.600000, -73.600000, 1.000000>, 
      <64.650000, -67.700000, -1.000000>, <68.500000, -67.100000, -1.000000>, <72.100000, -67.400000, -1.000000>, <75.600000, -73.400000, -1.000000>, 
      <64.912066, -64.651737, 0.000000>, <68.750000, -64.050000, 0.000000>, <72.350000, -64.350000, 0.000000>, <75.850000, -70.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <64.912066, -64.651737, 0.000000>, <68.750000, -64.050000, 0.000000>, <72.350000, -64.350000, 0.000000>, <75.850000, -70.350000, 0.000000>, 
      <65.174132, -61.603474, 1.000000>, <69.000000, -61.000000, 1.000000>, <72.600000, -61.300000, 1.000000>, <76.100000, -67.300000, 1.000000>, 
      <65.150000, -61.400000, -1.000000>, <69.000000, -60.800000, -1.000000>, <72.600000, -61.100000, -1.000000>, <76.100000, -67.100000, -1.000000>, 
      <65.437066, -58.401737, 0.000000>, <69.250000, -57.800000, 0.000000>, <72.850000, -58.100000, 0.000000>, <76.350000, -64.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <65.437066, -58.401737, 0.000000>, <69.250000, -57.800000, 0.000000>, <72.850000, -58.100000, 0.000000>, <76.350000, -64.100000, 0.000000>, 
      <65.724132, -55.403474, 1.000000>, <69.500000, -54.800000, 1.000000>, <73.100000, -55.100000, 1.000000>, <76.600000, -61.100000, 1.000000>, 
      <65.700000, -55.200000, -1.000000>, <69.500000, -54.600000, -1.000000>, <73.100000, -54.900000, -1.000000>, <76.600000, -60.900000, -1.000000>, 
      <65.962066, -52.151737, 0.000000>, <69.750000, -51.550000, 0.000000>, <73.350000, -51.850000, 0.000000>, <76.875000, -57.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <65.962066, -52.151737, 0.000000>, <69.750000, -51.550000, 0.000000>, <73.350000, -51.850000, 0.000000>, <76.875000, -57.850000, 0.000000>, 
      <66.224132, -49.103474, 1.000000>, <70.000000, -48.500000, 1.000000>, <73.600000, -48.800000, 1.000000>, <77.150000, -54.800000, 1.000000>, 
      <66.250000, -48.900000, -1.000000>, <70.100000, -48.300000, -1.000000>, <73.600000, -48.600000, -1.000000>, <77.150000, -54.600000, -1.000000>, 
      <66.625000, -45.450000, 0.000000>, <70.350000, -45.300000, 0.000000>, <73.900000, -45.600000, 0.000000>, <77.425000, -51.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <66.625000, -45.450000, 0.000000>, <70.350000, -45.300000, 0.000000>, <73.900000, -45.600000, 0.000000>, <77.425000, -51.600000, 0.000000>, 
      <67.000000, -42.000000, 1.000000>, <70.600000, -42.300000, 1.000000>, <74.200000, -42.600000, 1.000000>, <77.700000, -48.600000, 1.000000>, 
      <67.000000, -41.800000, -1.000000>, <70.600000, -42.100000, -1.000000>, <74.200000, -42.400000, -1.000000>, <77.700000, -48.400000, -1.000000>, 
      <67.250000, -38.750000, 0.000000>, <70.850000, -39.050000, 0.000000>, <74.450000, -39.350000, 0.000000>, <77.950000, -45.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <67.250000, -38.750000, 0.000000>, <70.850000, -39.050000, 0.000000>, <74.450000, -39.350000, 0.000000>, <77.950000, -45.350000, 0.000000>, 
      <67.500000, -35.700000, 1.000000>, <71.100000, -36.000000, 1.000000>, <74.700000, -36.300000, 1.000000>, <78.200000, -42.300000, 1.000000>, 
      <67.500000, -35.500000, -1.000000>, <71.100000, -35.800000, -1.000000>, <74.700000, -36.100000, -1.000000>, <78.200000, -42.100000, -1.000000>, 
      <67.775000, -32.500000, 0.000000>, <71.350000, -32.800000, 0.000000>, <74.950000, -33.100000, 0.000000>, <78.450000, -39.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <67.775000, -32.500000, 0.000000>, <71.350000, -32.800000, 0.000000>, <74.950000, -33.100000, 0.000000>, <78.450000, -39.100000, 0.000000>, 
      <68.050000, -29.500000, 1.000000>, <71.600000, -29.800000, 1.000000>, <75.200000, -30.100000, 1.000000>, <78.700000, -36.100000, 1.000000>, 
      <68.050000, -29.300000, -1.000000>, <71.600000, -29.600000, -1.000000>, <75.200000, -29.900000, -1.000000>, <78.700000, -35.900000, -1.000000>, 
      <68.300000, -26.250000, 0.000000>, <71.850000, -26.550000, 0.000000>, <75.450000, -26.850000, 0.000000>, <79.050000, -32.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <68.300000, -26.250000, 0.000000>, <71.850000, -26.550000, 0.000000>, <75.450000, -26.850000, 0.000000>, <79.050000, -32.850000, 0.000000>, 
      <68.550000, -23.200000, 1.000000>, <72.100000, -23.500000, 1.000000>, <75.700000, -23.800000, 1.000000>, <79.400000, -29.800000, 1.000000>, 
      <68.550000, -23.000000, -1.000000>, <72.100000, -23.300000, -1.000000>, <75.700000, -23.600000, -1.000000>, <79.400000, -29.600000, -1.000000>, 
      <69.110499, -20.174236, 0.039274>, <72.675544, -20.474270, 0.039274>, <76.265589, -20.774305, 0.039274>, <79.807794, -26.687152, 0.019637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <69.110499, -20.174236, 0.039274>, <72.675544, -20.474270, 0.039274>, <76.265589, -20.774305, 0.039274>, <79.807794, -26.687152, 0.019637>, 
      <69.670999, -17.348472, 1.078548>, <73.251088, -17.648541, 1.078548>, <76.831177, -17.948609, 1.078548>, <80.215589, -23.774305, 1.039274>, 
      <69.442939, -17.134885, 1.114652>, <73.023028, -17.434954, 1.114652>, <76.603117, -17.735022, 1.114652>, <80.101559, -23.567511, 0.057326>, 
      <69.744102, -13.931745, 1.114791>, <73.324191, -14.231813, 1.114791>, <76.699580, -14.531882, 1.114791>, <80.274790, -20.440941, 0.557395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <69.744102, -13.931745, 1.114791>, <73.324191, -14.231813, 1.114791>, <76.699580, -14.531882, 1.114791>, <80.274790, -20.440941, 0.557395>, 
      <70.045265, -10.728604, 1.114930>, <73.625354, -11.028672, 1.114930>, <76.796043, -11.328741, 1.114930>, <80.448021, -17.314370, 1.057465>, 
      <70.063167, -10.515017, 1.215635>, <73.643256, -10.815085, 1.215635>, <76.813945, -11.115154, 1.215635>, <80.456972, -17.107577, 0.107817>, 
      <70.316181, -7.496325, 1.165283>, <73.896271, -7.796394, 1.165283>, <77.066959, -8.096463, 1.165283>, <80.708480, -14.098231, 0.582641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <70.316181, -7.496325, 1.165283>, <73.896271, -7.796394, 1.165283>, <77.066959, -8.096463, 1.165283>, <80.708480, -14.098231, 0.582641>, 
      <70.569196, -4.477634, 1.114930>, <74.149285, -4.777703, 1.114930>, <77.319974, -5.077771, 1.114930>, <80.959987, -11.088886, 1.057465>, 
      <70.587098, -4.264047, 1.215635>, <74.167187, -4.564116, 1.215635>, <77.337876, -4.864184, 1.215635>, <81.018938, -10.882092, 0.107817>, 
      <70.914944, -1.429806, 1.147091>, <74.495034, -1.729874, 1.147091>, <77.870423, -2.029943, 1.147091>, <81.549055, -8.038434, 0.593183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <70.914944, -1.429806, 1.147091>, <74.495034, -1.729874, 1.147091>, <77.870423, -2.029943, 1.147091>, <81.549055, -8.038434, 0.593183>, 
      <71.242791, 1.404436, 1.078548>, <74.822880, 1.104367, 1.078548>, <78.402970, 0.804298, 1.078548>, <82.079172, -5.194775, 1.078548>, 
      <71.014731, 1.618023, 1.114652>, <74.594820, 1.317954, 1.114652>, <78.174910, 1.017885, 1.114652>, <81.851112, -4.981188, 1.114652>, 
      <71.107365, 4.809011, 1.057326>, <74.697410, 4.508977, 1.057326>, <79.137455, 3.208943, 1.057326>, <82.460976, -2.548501, 1.106528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <71.107365, 4.809011, 1.057326>, <74.697410, 4.508977, 1.057326>, <79.137455, 3.208943, 1.057326>, <82.460976, -2.548501, 1.106528>, 
      <71.200000, 8.000000, 1.000000>, <74.800000, 7.700000, 1.000000>, <80.100000, 5.400000, 1.000000>, <83.070839, -0.115814, 1.098405>, 
      <71.200000, 8.200000, -1.000000>, <74.800000, 7.900000, -1.000000>, <80.100000, 5.600000, -1.000000>, <83.079790, 0.090979, 0.148757>, 
      <71.450000, 11.250000, 0.000000>, <75.050000, 10.950000, 0.000000>, <80.250000, 7.400000, 0.000000>, <83.281298, 2.500325, 0.623581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <71.450000, 11.250000, 0.000000>, <75.050000, 10.950000, 0.000000>, <80.250000, 7.400000, 0.000000>, <83.281298, 2.500325, 0.623581>, 
      <71.700000, 14.300000, 1.000000>, <75.300000, 14.000000, 1.000000>, <80.400000, 9.200000, 1.000000>, <83.482805, 4.909671, 1.098405>, 
      <71.700000, 14.500000, -1.000000>, <75.300000, 14.200000, -1.000000>, <80.400000, 9.400000, -1.000000>, <83.491756, 5.116464, 0.148757>, 
      <71.975000, 17.500000, 0.000000>, <75.550000, 17.200000, 0.000000>, <80.650000, 12.400000, 0.000000>, <83.842089, 8.376836, 0.594016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <71.975000, 17.500000, 0.000000>, <75.550000, 17.200000, 0.000000>, <80.650000, 12.400000, 0.000000>, <83.842089, 8.376836, 0.594016>, 
      <72.250000, 20.500000, 1.000000>, <75.800000, 20.200000, 1.000000>, <80.900000, 15.400000, 1.000000>, <84.192423, 11.637208, 1.039274>, 
      <72.250000, 20.700000, -1.000000>, <75.800000, 20.400000, -1.000000>, <80.900000, 15.600000, -1.000000>, <84.078393, 11.844001, 0.057326>, 
      <72.475000, 23.250000, 0.000000>, <76.050000, 22.950000, 0.000000>, <81.150000, 18.650000, 0.000000>, <84.239196, 15.497001, 0.528663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <72.475000, 23.250000, 0.000000>, <76.050000, 22.950000, 0.000000>, <81.150000, 18.650000, 0.000000>, <84.239196, 15.497001, 0.528663>, 
      <72.700000, 25.800000, 1.000000>, <76.300000, 25.500000, 1.000000>, <81.400000, 21.700000, 1.000000>, <84.400000, 19.150000, 1.000000>, 
      <72.700000, 26.000000, -1.000000>, <76.300000, 25.700000, -1.000000>, <81.400000, 21.900000, -1.000000>, <84.400000, 19.350000, -1.000000>, 
      <73.025000, 28.025000, 0.000000>, <76.650000, 27.900000, 0.000000>, <81.900000, 24.600000, 0.000000>, <84.850000, 22.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <73.025000, 28.025000, 0.000000>, <76.650000, 27.900000, 0.000000>, <81.900000, 24.600000, 0.000000>, <84.850000, 22.725000, 0.000000>, 
      <73.350000, 30.050000, 1.000000>, <77.000000, 30.100000, 1.000000>, <82.400000, 27.300000, 1.000000>, <85.300000, 26.100000, 1.000000>, 
      <73.350000, 30.300000, -1.000000>, <77.000000, 30.400000, -1.000000>, <82.400000, 27.500000, -1.000000>, <85.300000, 26.300000, -1.000000>, 
      <73.675000, 33.350000, 0.000000>, <77.250000, 33.400000, 0.000000>, <82.650000, 30.400000, 0.000000>, <85.825000, 29.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <73.675000, 33.350000, 0.000000>, <77.250000, 33.400000, 0.000000>, <82.650000, 30.400000, 0.000000>, <85.825000, 29.875000, 0.000000>, 
      <74.000000, 36.400000, 1.000000>, <77.500000, 36.400000, 1.000000>, <82.900000, 33.300000, 1.000000>, <86.350000, 33.450000, 1.000000>, 
      <74.000000, 36.650000, -1.000000>, <77.500000, 36.600000, -1.000000>, <82.900000, 33.500000, -1.000000>, <86.350000, 33.650000, -1.000000>, 
      <74.575000, 39.050000, 0.000000>, <78.450000, 39.250000, 0.000000>, <83.750000, 36.900000, 0.000000>, <87.175000, 37.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <74.575000, 39.050000, 0.000000>, <78.450000, 39.250000, 0.000000>, <83.750000, 36.900000, 0.000000>, <87.175000, 37.250000, 0.000000>, 
      <75.150000, 41.450000, 1.000000>, <79.400000, 41.900000, 1.000000>, <84.600000, 40.300000, 1.000000>, <88.000000, 40.850000, 1.000000>, 
      <75.150000, 41.650000, -1.000000>, <79.400000, 42.100000, -1.000000>, <84.600000, 40.500000, -1.000000>, <88.000000, 41.050000, -1.000000>, 
      <76.000000, 45.000000, 0.700000>, <80.800000, 44.900000, 0.700000>, <84.900000, 44.400000, 0.700000>, <88.350000, 44.950000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <69.200000, -144.600000, -1.000000>, <72.500000, -148.900000, -1.000000>, <76.100000, -151.100000, -1.000000>, <80.950000, -152.050000, -1.000000>, 
      <69.550000, -140.650000, 1.000000>, <72.800000, -145.000000, 1.000000>, <76.000000, -149.400000, 1.000000>, <81.100000, -149.200000, 1.000000>, 
      <69.550000, -140.450000, -1.000000>, <72.800000, -144.800000, -1.000000>, <76.000000, -149.200000, -1.000000>, <81.100000, -149.000000, -1.000000>, 
      <69.800000, -137.425000, 0.000000>, <73.050000, -141.750000, 0.000000>, <76.800000, -145.950000, 0.000000>, <81.625000, -145.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <69.800000, -137.425000, 0.000000>, <73.050000, -141.750000, 0.000000>, <76.800000, -145.950000, 0.000000>, <81.625000, -145.875000, 0.000000>, 
      <70.050000, -134.400000, 1.000000>, <73.300000, -138.700000, 1.000000>, <77.600000, -142.700000, 1.000000>, <82.150000, -142.750000, 1.000000>, 
      <70.050000, -134.200000, -1.000000>, <73.300000, -138.500000, -1.000000>, <77.600000, -142.500000, -1.000000>, <82.150000, -142.550000, -1.000000>, 
      <70.325000, -131.175000, 0.000000>, <73.600000, -135.500000, 0.000000>, <77.850000, -139.450000, 0.000000>, <82.400000, -139.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <70.325000, -131.175000, 0.000000>, <73.600000, -135.500000, 0.000000>, <77.850000, -139.450000, 0.000000>, <82.400000, -139.500000, 0.000000>, 
      <70.600000, -128.150000, 1.000000>, <73.900000, -132.500000, 1.000000>, <78.100000, -136.400000, 1.000000>, <82.650000, -136.450000, 1.000000>, 
      <70.600000, -127.950000, -1.000000>, <73.900000, -132.300000, -1.000000>, <78.100000, -136.200000, -1.000000>, <82.650000, -136.250000, -1.000000>, 
      <70.875000, -124.925000, 0.000000>, <74.150000, -129.250000, 0.000000>, <78.400000, -133.200000, 0.000000>, <82.925000, -133.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <70.875000, -124.925000, 0.000000>, <74.150000, -129.250000, 0.000000>, <78.400000, -133.200000, 0.000000>, <82.925000, -133.250000, 0.000000>, 
      <71.150000, -121.900000, 1.000000>, <74.400000, -126.200000, 1.000000>, <78.700000, -130.200000, 1.000000>, <83.200000, -130.250000, 1.000000>, 
      <71.150000, -121.700000, -1.000000>, <74.400000, -126.000000, -1.000000>, <78.700000, -130.000000, -1.000000>, <83.200000, -130.050000, -1.000000>, 
      <71.400000, -118.675000, 0.000000>, <74.650000, -123.000000, 0.000000>, <78.950000, -126.950000, 0.000000>, <83.475000, -127.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <71.400000, -118.675000, 0.000000>, <74.650000, -123.000000, 0.000000>, <78.950000, -126.950000, 0.000000>, <83.475000, -127.000000, 0.000000>, 
      <71.650000, -115.650000, 1.000000>, <74.900000, -120.000000, 1.000000>, <79.200000, -123.900000, 1.000000>, <83.750000, -123.950000, 1.000000>, 
      <71.650000, -115.450000, -1.000000>, <74.900000, -119.800000, -1.000000>, <79.200000, -123.700000, -1.000000>, <83.750000, -123.750000, -1.000000>, 
      <71.900000, -112.425000, 0.000000>, <75.150000, -116.750000, 0.000000>, <79.450000, -120.700000, 0.000000>, <84.000000, -120.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <71.900000, -112.425000, 0.000000>, <75.150000, -116.750000, 0.000000>, <79.450000, -120.700000, 0.000000>, <84.000000, -120.750000, 0.000000>, 
      <72.150000, -109.400000, 1.000000>, <75.400000, -113.700000, 1.000000>, <79.700000, -117.700000, 1.000000>, <84.250000, -117.750000, 1.000000>, 
      <72.150000, -109.200000, -1.000000>, <75.400000, -113.500000, -1.000000>, <79.700000, -117.500000, -1.000000>, <84.250000, -117.550000, -1.000000>, 
      <72.425000, -106.175000, 0.000000>, <75.700000, -110.500000, 0.000000>, <79.950000, -114.450000, 0.000000>, <84.550000, -114.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <72.425000, -106.175000, 0.000000>, <75.700000, -110.500000, 0.000000>, <79.950000, -114.450000, 0.000000>, <84.550000, -114.675000, 0.000000>, 
      <72.700000, -103.150000, 1.000000>, <76.000000, -107.500000, 1.000000>, <80.200000, -111.400000, 1.000000>, <84.850000, -111.800000, 1.000000>, 
      <72.700000, -102.950000, -1.000000>, <76.000000, -107.300000, -1.000000>, <80.200000, -111.200000, -1.000000>, <84.900000, -111.600000, -1.000000>, 
      <72.900000, -100.725000, 0.000000>, <76.100000, -105.850000, 0.000000>, <80.500000, -108.200000, 0.000000>, <85.175000, -109.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <72.900000, -100.725000, 0.000000>, <76.100000, -105.850000, 0.000000>, <80.500000, -108.200000, 0.000000>, <85.175000, -109.325000, 0.000000>, 
      <73.100000, -98.500000, 1.000000>, <76.200000, -104.400000, 1.000000>, <80.800000, -105.200000, 1.000000>, <85.450000, -107.050000, 1.000000>, 
      <73.100000, -98.300000, -1.000000>, <76.200000, -104.200000, -1.000000>, <80.800000, -105.000000, -1.000000>, <85.450000, -106.850000, -1.000000>, 
      <73.550000, -95.300000, 0.000000>, <76.850000, -101.250000, 0.000000>, <80.950000, -101.800000, 0.000000>, <85.725000, -103.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <73.550000, -95.300000, 0.000000>, <76.850000, -101.250000, 0.000000>, <80.950000, -101.800000, 0.000000>, <85.725000, -103.750000, 0.000000>, 
      <74.000000, -92.300000, 1.000000>, <77.500000, -98.300000, 1.000000>, <81.100000, -98.600000, 1.000000>, <86.000000, -100.650000, 1.000000>, 
      <74.000000, -92.100000, -1.000000>, <77.500000, -98.100000, -1.000000>, <81.100000, -98.400000, -1.000000>, <86.100000, -100.300000, -1.000000>, 
      <74.250000, -89.100000, 0.000000>, <77.750000, -95.100000, 0.000000>, <81.350000, -95.400000, 0.000000>, <86.375000, -97.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <74.250000, -89.100000, 0.000000>, <77.750000, -95.100000, 0.000000>, <81.350000, -95.400000, 0.000000>, <86.375000, -97.300000, 0.000000>, 
      <74.500000, -86.100000, 1.000000>, <78.000000, -92.100000, 1.000000>, <81.600000, -92.400000, 1.000000>, <86.650000, -94.300000, 1.000000>, 
      <74.500000, -85.900000, -1.000000>, <78.000000, -91.900000, -1.000000>, <81.600000, -92.200000, -1.000000>, <86.650000, -94.100000, -1.000000>, 
      <74.775000, -82.850000, 0.000000>, <78.300000, -88.850000, 0.000000>, <81.900000, -89.150000, 0.000000>, <86.925000, -91.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <74.775000, -82.850000, 0.000000>, <78.300000, -88.850000, 0.000000>, <81.900000, -89.150000, 0.000000>, <86.925000, -91.050000, 0.000000>, 
      <75.050000, -79.800000, 1.000000>, <78.600000, -85.800000, 1.000000>, <82.200000, -86.100000, 1.000000>, <87.200000, -88.000000, 1.000000>, 
      <75.050000, -79.600000, -1.000000>, <78.600000, -85.600000, -1.000000>, <82.200000, -85.900000, -1.000000>, <87.200000, -87.800000, -1.000000>, 
      <75.325000, -76.600000, 0.000000>, <78.850000, -82.600000, 0.000000>, <82.450000, -82.900000, 0.000000>, <87.450000, -84.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <75.325000, -76.600000, 0.000000>, <78.850000, -82.600000, 0.000000>, <82.450000, -82.900000, 0.000000>, <87.450000, -84.800000, 0.000000>, 
      <75.600000, -73.600000, 1.000000>, <79.100000, -79.600000, 1.000000>, <82.700000, -79.900000, 1.000000>, <87.700000, -81.800000, 1.000000>, 
      <75.600000, -73.400000, -1.000000>, <79.100000, -79.400000, -1.000000>, <82.700000, -79.700000, -1.000000>, <87.700000, -81.600000, -1.000000>, 
      <75.850000, -70.350000, 0.000000>, <79.350000, -76.350000, 0.000000>, <82.950000, -76.650000, 0.000000>, <87.975000, -78.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <75.850000, -70.350000, 0.000000>, <79.350000, -76.350000, 0.000000>, <82.950000, -76.650000, 0.000000>, <87.975000, -78.550000, 0.000000>, 
      <76.100000, -67.300000, 1.000000>, <79.600000, -73.300000, 1.000000>, <83.200000, -73.600000, 1.000000>, <88.250000, -75.500000, 1.000000>, 
      <76.100000, -67.100000, -1.000000>, <79.600000, -73.100000, -1.000000>, <83.200000, -73.400000, -1.000000>, <88.250000, -75.300000, -1.000000>, 
      <76.350000, -64.100000, 0.000000>, <79.850000, -70.100000, 0.000000>, <83.450000, -70.400000, 0.000000>, <88.500000, -72.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <76.350000, -64.100000, 0.000000>, <79.850000, -70.100000, 0.000000>, <83.450000, -70.400000, 0.000000>, <88.500000, -72.300000, 0.000000>, 
      <76.600000, -61.100000, 1.000000>, <80.100000, -67.100000, 1.000000>, <83.700000, -67.400000, 1.000000>, <88.750000, -69.300000, 1.000000>, 
      <76.600000, -60.900000, -1.000000>, <80.100000, -66.900000, -1.000000>, <83.700000, -67.200000, -1.000000>, <88.750000, -69.100000, -1.000000>, 
      <76.875000, -57.850000, 0.000000>, <80.400000, -63.850000, 0.000000>, <83.950000, -64.150000, 0.000000>, <89.000000, -66.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <76.875000, -57.850000, 0.000000>, <80.400000, -63.850000, 0.000000>, <83.950000, -64.150000, 0.000000>, <89.000000, -66.050000, 0.000000>, 
      <77.150000, -54.800000, 1.000000>, <80.700000, -60.800000, 1.000000>, <84.200000, -61.100000, 1.000000>, <89.250000, -63.000000, 1.000000>, 
      <77.150000, -54.600000, -1.000000>, <80.700000, -60.600000, -1.000000>, <84.200000, -60.900000, -1.000000>, <89.250000, -62.800000, -1.000000>, 
      <77.425000, -51.600000, 0.000000>, <80.950000, -57.600000, 0.000000>, <84.500000, -57.900000, 0.000000>, <89.525000, -59.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <77.425000, -51.600000, 0.000000>, <80.950000, -57.600000, 0.000000>, <84.500000, -57.900000, 0.000000>, <89.525000, -59.800000, 0.000000>, 
      <77.700000, -48.600000, 1.000000>, <81.200000, -54.600000, 1.000000>, <84.800000, -54.900000, 1.000000>, <89.800000, -56.800000, 1.000000>, 
      <77.700000, -48.400000, -1.000000>, <81.200000, -54.400000, -1.000000>, <84.800000, -54.700000, -1.000000>, <89.800000, -56.600000, -1.000000>, 
      <77.950000, -45.350000, 0.000000>, <81.450000, -51.350000, 0.000000>, <85.050000, -51.650000, 0.000000>, <89.950000, -54.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <77.950000, -45.350000, 0.000000>, <81.450000, -51.350000, 0.000000>, <85.050000, -51.650000, 0.000000>, <89.950000, -54.500000, 0.000000>, 
      <78.200000, -42.300000, 1.000000>, <81.700000, -48.300000, 1.000000>, <85.300000, -48.600000, 1.000000>, <90.100000, -52.400000, 1.000000>, 
      <78.200000, -42.100000, -1.000000>, <81.700000, -48.100000, -1.000000>, <85.300000, -48.400000, -1.000000>, <90.350000, -50.300000, -1.000000>, 
      <78.450000, -39.100000, 0.000000>, <81.950000, -45.100000, 0.000000>, <85.550000, -45.400000, 0.000000>, <90.600000, -47.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <78.450000, -39.100000, 0.000000>, <81.950000, -45.100000, 0.000000>, <85.550000, -45.400000, 0.000000>, <90.600000, -47.300000, 0.000000>, 
      <78.700000, -36.100000, 1.000000>, <82.200000, -42.100000, 1.000000>, <85.800000, -42.400000, 1.000000>, <90.850000, -44.300000, 1.000000>, 
      <78.700000, -35.900000, -1.000000>, <82.200000, -41.900000, -1.000000>, <85.800000, -42.200000, -1.000000>, <90.850000, -44.100000, -1.000000>, 
      <79.050000, -32.850000, 0.000000>, <82.650000, -38.850000, 0.000000>, <86.250000, -39.150000, 0.000000>, <91.275000, -41.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <79.050000, -32.850000, 0.000000>, <82.650000, -38.850000, 0.000000>, <86.250000, -39.150000, 0.000000>, <91.275000, -41.050000, 0.000000>, 
      <79.400000, -29.800000, 1.000000>, <83.100000, -35.800000, 1.000000>, <86.700000, -36.100000, 1.000000>, <91.700000, -38.000000, 1.000000>, 
      <79.400000, -29.600000, -1.000000>, <83.100000, -35.600000, -1.000000>, <86.700000, -35.900000, -1.000000>, <91.700000, -37.800000, -1.000000>, 
      <79.807794, -26.687152, 0.019637>, <83.350000, -32.600000, 0.000000>, <86.950000, -32.900000, 0.000000>, <91.975000, -34.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <79.807794, -26.687152, 0.019637>, <83.350000, -32.600000, 0.000000>, <86.950000, -32.900000, 0.000000>, <91.975000, -34.800000, 0.000000>, 
      <80.215589, -23.774305, 1.039274>, <83.600000, -29.600000, 1.000000>, <87.200000, -29.900000, 1.000000>, <92.250000, -31.800000, 1.000000>, 
      <80.101559, -23.567511, 0.057326>, <83.600000, -29.400000, -1.000000>, <87.200000, -29.700000, -1.000000>, <92.250000, -31.600000, -1.000000>, 
      <80.274790, -20.440941, 0.557395>, <83.850000, -26.350000, 0.000000>, <87.450000, -26.650000, 0.000000>, <92.500000, -28.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <80.274790, -20.440941, 0.557395>, <83.850000, -26.350000, 0.000000>, <87.450000, -26.650000, 0.000000>, <92.500000, -28.550000, 0.000000>, 
      <80.448021, -17.314370, 1.057465>, <84.100000, -23.300000, 1.000000>, <87.700000, -23.600000, 1.000000>, <92.750000, -25.500000, 1.000000>, 
      <80.456972, -17.107577, 0.107817>, <84.100000, -23.100000, -1.000000>, <87.700000, -23.400000, -1.000000>, <92.750000, -25.300000, -1.000000>, 
      <80.708480, -14.098231, 0.582641>, <84.350000, -20.100000, 0.000000>, <87.950000, -20.400000, 0.000000>, <93.000000, -22.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <80.708480, -14.098231, 0.582641>, <84.350000, -20.100000, 0.000000>, <87.950000, -20.400000, 0.000000>, <93.000000, -22.300000, 0.000000>, 
      <80.959987, -11.088886, 1.057465>, <84.600000, -17.100000, 1.000000>, <88.200000, -17.400000, 1.000000>, <93.250000, -19.300000, 1.000000>, 
      <81.018938, -10.882092, 0.107817>, <84.700000, -16.900000, -1.000000>, <88.200000, -17.200000, -1.000000>, <93.250000, -19.100000, -1.000000>, 
      <81.549055, -8.038434, 0.593183>, <85.227688, -14.046924, 0.039274>, <88.767732, -14.346959, 0.039274>, <93.658866, -16.148479, 0.019637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <81.549055, -8.038434, 0.593183>, <85.227688, -14.046924, 0.039274>, <88.767732, -14.346959, 0.039274>, <93.658866, -16.148479, 0.019637>, 
      <82.079172, -5.194775, 1.078548>, <85.755375, -11.193849, 1.078548>, <89.335465, -11.493917, 1.078548>, <94.067732, -13.196959, 1.039274>, 
      <81.851112, -4.981188, 1.114652>, <85.527315, -10.980262, 1.114652>, <89.107405, -11.280330, 1.114652>, <93.953702, -12.990165, 0.057326>, 
      <82.460976, -2.548501, 1.106528>, <85.784497, -8.305945, 1.155731>, <89.562239, -8.734673, 1.096600>, <94.331119, -10.792336, 0.548300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <82.460976, -2.548501, 1.106528>, <85.784497, -8.305945, 1.155731>, <89.562239, -8.734673, 1.096600>, <94.331119, -10.792336, 0.548300>, 
      <83.070839, -0.115814, 1.098405>, <86.041679, -5.631628, 1.196810>, <90.017073, -6.189016, 1.078548>, <94.708537, -8.594508, 1.039274>, 
      <83.079790, 0.090979, 0.148757>, <86.059581, -5.418041, 1.297515>, <89.789013, -5.975429, 1.114652>, <94.594507, -8.387714, 0.057326>, 
      <83.281298, 2.500325, 0.623581>, <86.312595, -2.399350, 1.247163>, <89.967356, -2.828078, 1.155731>, <94.858678, -5.189039, 0.577866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <83.281298, 2.500325, 0.623581>, <86.312595, -2.399350, 1.247163>, <89.967356, -2.828078, 1.155731>, <94.858678, -5.189039, 0.577866>, 
      <83.482805, 4.909671, 1.098405>, <86.565610, 0.619341, 1.196810>, <90.145699, 0.319273, 1.196810>, <95.122850, -1.990364, 1.098405>, 
      <83.491756, 5.116464, 0.148757>, <86.583512, 0.832928, 1.297515>, <90.163601, 0.532860, 1.297515>, <95.131801, -1.783570, 0.148757>, 
      <83.842089, 8.376836, 0.594016>, <87.034179, 4.353672, 1.188031>, <90.498496, 4.238053, 1.247163>, <95.351048, 2.232833, 0.643218>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <83.842089, 8.376836, 0.594016>, <87.034179, 4.353672, 1.188031>, <90.498496, 4.238053, 1.247163>, <95.351048, 2.232833, 0.643218>, 
      <84.192423, 11.637208, 1.039274>, <87.484846, 7.874415, 1.078548>, <90.833390, 7.943246, 1.196810>, <95.570295, 6.249236, 1.137679>, 
      <84.078393, 11.844001, 0.057326>, <87.256786, 8.088002, 1.114652>, <90.851292, 8.156833, 1.297515>, <95.495930, 6.455587, 1.206083>, 
      <84.239196, 15.497001, 0.528663>, <87.328393, 12.344001, 1.057326>, <90.925646, 12.228417, 1.148757>, <95.753943, 10.469724, 1.135173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <84.239196, 15.497001, 0.528663>, <87.328393, 12.344001, 1.057326>, <90.925646, 12.228417, 1.148757>, <95.753943, 10.469724, 1.135173>, 
      <84.400000, 19.150000, 1.000000>, <87.400000, 16.600000, 1.000000>, <91.000000, 16.300000, 1.000000>, <96.011956, 14.483861, 1.064264>, 
      <84.400000, 19.350000, -1.000000>, <87.400000, 16.800000, -1.000000>, <91.000000, 16.500000, -1.000000>, <95.928640, 14.683418, 0.082316>, 
      <84.850000, 22.725000, 0.000000>, <87.800000, 20.850000, 0.000000>, <91.350000, 20.550000, 0.000000>, <96.159447, 18.462110, 0.590360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <84.850000, 22.725000, 0.000000>, <87.800000, 20.850000, 0.000000>, <91.350000, 20.550000, 0.000000>, <96.159447, 18.462110, 0.590360>, 
      <85.300000, 26.100000, 1.000000>, <88.200000, 24.900000, 1.000000>, <91.700000, 24.600000, 1.000000>, <96.390255, 22.240802, 1.098405>, 
      <85.300000, 26.300000, -1.000000>, <88.200000, 25.100000, -1.000000>, <91.700000, 24.800000, -1.000000>, <96.429919, 22.440359, 0.148757>, 
      <85.825000, 29.875000, 0.000000>, <89.000000, 29.350000, 0.000000>, <92.350000, 28.200000, 0.000000>, <97.290844, 26.049319, 0.594016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <85.825000, 29.875000, 0.000000>, <89.000000, 29.350000, 0.000000>, <92.350000, 28.200000, 0.000000>, <97.290844, 26.049319, 0.594016>, 
      <86.350000, 33.450000, 1.000000>, <89.800000, 33.600000, 1.000000>, <93.000000, 31.600000, 1.000000>, <98.151769, 29.658279, 1.039274>, 
      <86.350000, 33.650000, -1.000000>, <89.800000, 33.800000, -1.000000>, <93.000000, 31.800000, -1.000000>, <98.055446, 29.862079, 0.057326>, 
      <87.175000, 37.250000, 0.000000>, <90.600000, 37.600000, 0.000000>, <94.000000, 35.850000, 0.000000>, <98.852723, 33.456039, 0.528663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <87.175000, 37.250000, 0.000000>, <90.600000, 37.600000, 0.000000>, <94.000000, 35.850000, 0.000000>, <98.852723, 33.456039, 0.528663>, 
      <88.000000, 40.850000, 1.000000>, <91.400000, 41.400000, 1.000000>, <95.000000, 39.900000, 1.000000>, <99.650000, 37.050000, 1.000000>, 
      <88.000000, 41.050000, -1.000000>, <91.400000, 41.600000, -1.000000>, <95.000000, 40.100000, -1.000000>, <99.650000, 37.250000, -1.000000>, 
      <88.350000, 44.950000, 0.700000>, <91.800000, 45.500000, 0.700000>, <95.300000, 44.000000, 0.700000>, <100.300000, 41.050000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <80.950000, -152.050000, -1.000000>, <85.800000, -153.000000, -1.000000>, <95.800000, -162.700000, -1.000000>, <99.400000, -163.300000, -1.000000>, 
      <81.100000, -149.200000, 1.000000>, <86.200000, -149.000000, 1.000000>, <96.300000, -159.200000, 1.000000>, <99.850000, -159.600000, 1.000000>, 
      <81.100000, -149.000000, -1.000000>, <86.200000, -148.800000, -1.000000>, <96.300000, -159.000000, -1.000000>, <99.850000, -159.350000, -1.000000>, 
      <81.625000, -145.875000, 0.000000>, <86.450000, -145.800000, 0.000000>, <96.600000, -156.000000, 0.000000>, <100.175000, -156.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <81.625000, -145.875000, 0.000000>, <86.450000, -145.800000, 0.000000>, <96.600000, -156.000000, 0.000000>, <100.175000, -156.350000, 0.000000>, 
      <82.150000, -142.750000, 1.000000>, <86.700000, -142.800000, 1.000000>, <96.900000, -153.000000, 1.000000>, <100.500000, -153.350000, 1.000000>, 
      <82.150000, -142.550000, -1.000000>, <86.700000, -142.600000, -1.000000>, <96.900000, -152.800000, -1.000000>, <100.500000, -153.150000, -1.000000>, 
      <82.400000, -139.500000, 0.000000>, <86.950000, -139.550000, 0.000000>, <97.200000, -149.800000, 0.000000>, <100.800000, -150.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <82.400000, -139.500000, 0.000000>, <86.950000, -139.550000, 0.000000>, <97.200000, -149.800000, 0.000000>, <100.800000, -150.150000, 0.000000>, 
      <82.650000, -136.450000, 1.000000>, <87.200000, -136.500000, 1.000000>, <97.500000, -146.800000, 1.000000>, <101.100000, -147.150000, 1.000000>, 
      <82.650000, -136.250000, -1.000000>, <87.200000, -136.300000, -1.000000>, <97.500000, -146.500000, -1.000000>, <101.100000, -146.900000, -1.000000>, 
      <82.925000, -133.250000, 0.000000>, <87.450000, -133.300000, 0.000000>, <97.850000, -143.500000, 0.000000>, <101.425000, -143.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <82.925000, -133.250000, 0.000000>, <87.450000, -133.300000, 0.000000>, <97.850000, -143.500000, 0.000000>, <101.425000, -143.875000, 0.000000>, 
      <83.200000, -130.250000, 1.000000>, <87.700000, -130.300000, 1.000000>, <98.200000, -140.500000, 1.000000>, <101.750000, -140.850000, 1.000000>, 
      <83.200000, -130.050000, -1.000000>, <87.700000, -130.100000, -1.000000>, <98.200000, -140.300000, -1.000000>, <101.750000, -140.650000, -1.000000>, 
      <83.475000, -127.000000, 0.000000>, <88.000000, -127.050000, 0.000000>, <98.500000, -137.300000, 0.000000>, <102.050000, -137.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <83.475000, -127.000000, 0.000000>, <88.000000, -127.050000, 0.000000>, <98.500000, -137.300000, 0.000000>, <102.050000, -137.650000, 0.000000>, 
      <83.750000, -123.950000, 1.000000>, <88.300000, -124.000000, 1.000000>, <98.800000, -134.300000, 1.000000>, <102.350000, -134.650000, 1.000000>, 
      <83.750000, -123.750000, -1.000000>, <88.300000, -123.800000, -1.000000>, <98.800000, -134.100000, -1.000000>, <102.400000, -134.450000, -1.000000>, 
      <84.000000, -120.750000, 0.000000>, <88.550000, -120.800000, 0.000000>, <99.100000, -131.050000, 0.000000>, <102.700000, -131.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <84.000000, -120.750000, 0.000000>, <88.550000, -120.800000, 0.000000>, <99.100000, -131.050000, 0.000000>, <102.700000, -131.425000, 0.000000>, 
      <84.250000, -117.750000, 1.000000>, <88.800000, -117.800000, 1.000000>, <99.400000, -128.000000, 1.000000>, <103.000000, -128.400000, 1.000000>, 
      <84.250000, -117.550000, -1.000000>, <88.800000, -117.600000, -1.000000>, <99.400000, -127.800000, -1.000000>, <103.000000, -128.150000, -1.000000>, 
      <84.550000, -114.675000, 0.000000>, <89.150000, -114.900000, 0.000000>, <99.750000, -124.800000, 0.000000>, <103.325000, -125.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <84.550000, -114.675000, 0.000000>, <89.150000, -114.900000, 0.000000>, <99.750000, -124.800000, 0.000000>, <103.325000, -125.150000, 0.000000>, 
      <84.850000, -111.800000, 1.000000>, <89.500000, -112.200000, 1.000000>, <100.100000, -121.800000, 1.000000>, <103.650000, -122.150000, 1.000000>, 
      <84.900000, -111.600000, -1.000000>, <89.600000, -112.000000, -1.000000>, <100.100000, -121.600000, -1.000000>, <103.650000, -121.950000, -1.000000>, 
      <85.175000, -109.325000, 0.000000>, <89.850000, -110.450000, 0.000000>, <100.400000, -118.600000, 0.000000>, <104.900000, -118.775000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <85.175000, -109.325000, 0.000000>, <89.850000, -110.450000, 0.000000>, <100.400000, -118.600000, 0.000000>, <104.900000, -118.775000, 0.000000>, 
      <85.450000, -107.050000, 1.000000>, <90.100000, -108.900000, 1.000000>, <100.700000, -115.600000, 1.000000>, <106.150000, -115.600000, 1.000000>, 
      <85.450000, -106.850000, -1.000000>, <90.100000, -108.700000, -1.000000>, <100.700000, -115.300000, -1.000000>, <106.200000, -115.350000, -1.000000>, 
      <85.725000, -103.750000, 0.000000>, <90.500000, -105.700000, 0.000000>, <101.000000, -112.300000, 0.000000>, <106.700000, -112.375000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <85.725000, -103.750000, 0.000000>, <90.500000, -105.700000, 0.000000>, <101.000000, -112.300000, 0.000000>, <106.700000, -112.375000, 0.000000>, 
      <86.000000, -100.650000, 1.000000>, <90.900000, -102.700000, 1.000000>, <101.300000, -109.300000, 1.000000>, <107.200000, -109.400000, 1.000000>, 
      <86.100000, -100.300000, -1.000000>, <91.100000, -102.200000, -1.000000>, <101.300000, -109.100000, -1.000000>, <107.200000, -109.150000, -1.000000>, 
      <86.375000, -97.300000, 0.000000>, <91.400000, -99.200000, 0.000000>, <100.200000, -103.700000, 0.000000>, <107.000000, -104.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <86.375000, -97.300000, 0.000000>, <91.400000, -99.200000, 0.000000>, <100.200000, -103.700000, 0.000000>, <107.000000, -104.975000, 0.000000>, 
      <86.650000, -94.300000, 1.000000>, <91.700000, -96.200000, 1.000000>, <99.100000, -98.300000, 1.000000>, <106.800000, -100.800000, 1.000000>, 
      <86.650000, -94.100000, -1.000000>, <91.700000, -96.000000, -1.000000>, <99.100000, -98.100000, -1.000000>, <106.800000, -100.600000, -1.000000>, 
      <86.925000, -91.050000, 0.000000>, <91.950000, -92.950000, 0.000000>, <99.350000, -95.050000, 0.000000>, <107.275000, -97.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <86.925000, -91.050000, 0.000000>, <91.950000, -92.950000, 0.000000>, <99.350000, -95.050000, 0.000000>, <107.275000, -97.600000, 0.000000>, 
      <87.200000, -88.000000, 1.000000>, <92.200000, -89.900000, 1.000000>, <99.600000, -92.000000, 1.000000>, <107.750000, -94.600000, 1.000000>, 
      <87.200000, -87.800000, -1.000000>, <92.200000, -89.700000, -1.000000>, <99.600000, -91.800000, -1.000000>, <107.750000, -94.400000, -1.000000>, 
      <87.450000, -84.800000, 0.000000>, <92.450000, -86.700000, 0.000000>, <99.900000, -88.800000, 0.000000>, <108.250000, -91.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <87.450000, -84.800000, 0.000000>, <92.450000, -86.700000, 0.000000>, <99.900000, -88.800000, 0.000000>, <108.250000, -91.425000, 0.000000>, 
      <87.700000, -81.800000, 1.000000>, <92.700000, -83.700000, 1.000000>, <100.200000, -85.800000, 1.000000>, <108.750000, -88.450000, 1.000000>, 
      <87.700000, -81.600000, -1.000000>, <92.700000, -83.500000, -1.000000>, <100.200000, -85.600000, -1.000000>, <108.800000, -88.250000, -1.000000>, 
      <87.975000, -78.550000, 0.000000>, <93.000000, -80.450000, 0.000000>, <100.450000, -82.550000, 0.000000>, <109.250000, -85.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <87.975000, -78.550000, 0.000000>, <93.000000, -80.450000, 0.000000>, <100.450000, -82.550000, 0.000000>, <109.250000, -85.250000, 0.000000>, 
      <88.250000, -75.500000, 1.000000>, <93.300000, -77.400000, 1.000000>, <100.700000, -79.500000, 1.000000>, <109.700000, -82.250000, 1.000000>, 
      <88.250000, -75.300000, -1.000000>, <93.300000, -77.200000, -1.000000>, <100.700000, -79.300000, -1.000000>, <109.750000, -82.050000, -1.000000>, 
      <88.500000, -72.300000, 0.000000>, <93.550000, -74.200000, 0.000000>, <100.950000, -76.300000, 0.000000>, <110.225000, -78.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <88.500000, -72.300000, 0.000000>, <93.550000, -74.200000, 0.000000>, <100.950000, -76.300000, 0.000000>, <110.225000, -78.875000, 0.000000>, 
      <88.750000, -69.300000, 1.000000>, <93.800000, -71.200000, 1.000000>, <101.200000, -73.300000, 1.000000>, <110.700000, -75.700000, 1.000000>, 
      <88.750000, -69.100000, -1.000000>, <93.800000, -71.000000, -1.000000>, <101.200000, -73.100000, -1.000000>, <110.750000, -75.500000, -1.000000>, 
      <89.000000, -66.050000, 0.000000>, <94.050000, -67.950000, 0.000000>, <101.450000, -70.050000, 0.000000>, <110.400000, -72.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <89.000000, -66.050000, 0.000000>, <94.050000, -67.950000, 0.000000>, <101.450000, -70.050000, 0.000000>, <110.400000, -72.350000, 0.000000>, 
      <89.250000, -63.000000, 1.000000>, <94.300000, -64.900000, 1.000000>, <101.700000, -67.000000, 1.000000>, <110.050000, -69.200000, 1.000000>, 
      <89.250000, -62.800000, -1.000000>, <94.300000, -64.700000, -1.000000>, <101.700000, -66.800000, -1.000000>, <110.050000, -69.000000, -1.000000>, 
      <89.525000, -59.800000, 0.000000>, <94.550000, -61.700000, 0.000000>, <102.000000, -65.000000, 0.000000>, <111.350000, -66.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <89.525000, -59.800000, 0.000000>, <94.550000, -61.700000, 0.000000>, <102.000000, -65.000000, 0.000000>, <111.350000, -66.975000, 0.000000>, 
      <89.800000, -56.800000, 1.000000>, <94.800000, -58.700000, 1.000000>, <102.300000, -63.200000, 1.000000>, <112.650000, -64.950000, 1.000000>, 
      <89.800000, -56.600000, -1.000000>, <94.800000, -58.500000, -1.000000>, <102.300000, -62.900000, -1.000000>, <112.650000, -64.700000, -1.000000>, 
      <89.950000, -54.500000, 0.000000>, <94.850000, -57.350000, 0.000000>, <102.550000, -59.900000, 0.000000>, <113.125000, -61.725000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <89.950000, -54.500000, 0.000000>, <94.850000, -57.350000, 0.000000>, <102.550000, -59.900000, 0.000000>, <113.125000, -61.725000, 0.000000>, 
      <90.100000, -52.400000, 1.000000>, <94.900000, -56.200000, 1.000000>, <102.800000, -56.900000, 1.000000>, <113.600000, -58.750000, 1.000000>, 
      <90.350000, -50.300000, -1.000000>, <95.400000, -52.200000, -1.000000>, <102.800000, -56.700000, -1.000000>, <113.600000, -58.550000, -1.000000>, 
      <90.600000, -47.300000, 0.000000>, <95.650000, -49.200000, 0.000000>, <102.500000, -53.350000, 0.000000>, <112.975000, -55.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <90.600000, -47.300000, 0.000000>, <95.650000, -49.200000, 0.000000>, <102.500000, -53.350000, 0.000000>, <112.975000, -55.400000, 0.000000>, 
      <90.850000, -44.300000, 1.000000>, <95.900000, -46.200000, 1.000000>, <102.200000, -50.000000, 1.000000>, <112.350000, -52.250000, 1.000000>, 
      <90.850000, -44.100000, -1.000000>, <95.900000, -46.000000, -1.000000>, <102.200000, -49.800000, -1.000000>, <112.350000, -52.050000, -1.000000>, 
      <91.275000, -41.050000, 0.000000>, <96.300000, -42.950000, 0.000000>, <102.900000, -47.250000, 0.000000>, <112.850000, -49.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <91.275000, -41.050000, 0.000000>, <96.300000, -42.950000, 0.000000>, <102.900000, -47.250000, 0.000000>, <112.850000, -49.250000, 0.000000>, 
      <91.700000, -38.000000, 1.000000>, <96.700000, -39.900000, 1.000000>, <103.600000, -44.700000, 1.000000>, <113.350000, -46.450000, 1.000000>, 
      <91.700000, -37.800000, -1.000000>, <96.700000, -39.700000, -1.000000>, <103.600000, -44.500000, -1.000000>, <113.350000, -46.250000, -1.000000>, 
      <91.975000, -34.800000, 0.000000>, <97.000000, -36.700000, 0.000000>, <104.000000, -42.000000, 0.000000>, <111.825000, -43.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <91.975000, -34.800000, 0.000000>, <97.000000, -36.700000, 0.000000>, <104.000000, -42.000000, 0.000000>, <111.825000, -43.250000, 0.000000>, 
      <92.250000, -31.800000, 1.000000>, <97.300000, -33.700000, 1.000000>, <104.400000, -39.500000, 1.000000>, <110.300000, -40.250000, 1.000000>, 
      <92.250000, -31.600000, -1.000000>, <97.300000, -33.500000, -1.000000>, <104.400000, -39.300000, -1.000000>, <110.300000, -40.000000, -1.000000>, 
      <92.500000, -28.550000, 0.000000>, <97.550000, -30.450000, 0.000000>, <104.350000, -35.150000, 0.000000>, <110.350000, -36.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <92.500000, -28.550000, 0.000000>, <97.550000, -30.450000, 0.000000>, <104.350000, -35.150000, 0.000000>, <110.350000, -36.050000, 0.000000>, 
      <92.750000, -25.500000, 1.000000>, <97.800000, -27.400000, 1.000000>, <104.300000, -31.000000, 1.000000>, <110.400000, -32.100000, 1.000000>, 
      <92.750000, -25.300000, -1.000000>, <97.800000, -27.200000, -1.000000>, <104.300000, -30.800000, -1.000000>, <110.400000, -31.900000, -1.000000>, 
      <93.000000, -22.300000, 0.000000>, <98.050000, -24.200000, 0.000000>, <104.050000, -27.200000, 0.000000>, <109.275000, -28.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <93.000000, -22.300000, 0.000000>, <98.050000, -24.200000, 0.000000>, <104.050000, -27.200000, 0.000000>, <109.275000, -28.400000, 0.000000>, 
      <93.250000, -19.300000, 1.000000>, <98.300000, -21.200000, 1.000000>, <103.800000, -23.600000, 1.000000>, <108.150000, -24.900000, 1.000000>, 
      <93.250000, -19.100000, -1.000000>, <98.300000, -21.000000, -1.000000>, <103.800000, -23.400000, -1.000000>, <108.150000, -24.700000, -1.000000>, 
      <93.658866, -16.148479, 0.019637>, <98.550000, -17.950000, 0.000000>, <103.750000, -19.700000, 0.000000>, <108.100000, -21.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <93.658866, -16.148479, 0.019637>, <98.550000, -17.950000, 0.000000>, <103.750000, -19.700000, 0.000000>, <108.100000, -21.600000, 0.000000>, 
      <94.067732, -13.196959, 1.039274>, <98.800000, -14.900000, 1.000000>, <103.700000, -16.000000, 1.000000>, <108.050000, -18.500000, 1.000000>, 
      <93.953702, -12.990165, 0.057326>, <98.800000, -14.700000, -1.000000>, <103.800000, -15.800000, -1.000000>, <108.100000, -18.300000, -1.000000>, 
      <94.331119, -10.792336, 0.548300>, <99.100000, -12.850000, 0.000000>, <103.600000, -12.500000, 0.000000>, <107.875000, -15.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <94.331119, -10.792336, 0.548300>, <99.100000, -12.850000, 0.000000>, <103.600000, -12.500000, 0.000000>, <107.875000, -15.250000, 0.000000>, 
      <94.708537, -8.594508, 1.039274>, <99.400000, -11.000000, 1.000000>, <103.400000, -9.200000, 1.000000>, <107.650000, -12.200000, 1.000000>, 
      <94.594507, -8.387714, 0.057326>, <99.400000, -10.800000, -1.000000>, <103.500000, -9.000000, -1.000000>, <107.700000, -12.000000, -1.000000>, 
      <94.858678, -5.189039, 0.577866>, <99.750000, -7.550000, 0.000000>, <104.000000, -6.000000, 0.000000>, <108.225000, -9.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <94.858678, -5.189039, 0.577866>, <99.750000, -7.550000, 0.000000>, <104.000000, -6.000000, 0.000000>, <108.225000, -9.000000, 0.000000>, 
      <95.122850, -1.990364, 1.098405>, <100.100000, -4.300000, 1.000000>, <104.500000, -3.000000, 1.000000>, <108.750000, -6.000000, 1.000000>, 
      <95.131801, -1.783570, 0.148757>, <100.100000, -4.100000, -1.000000>, <104.600000, -2.800000, -1.000000>, <108.800000, -5.800000, -1.000000>, 
      <95.351048, 2.232833, 0.643218>, <100.203600, 0.227613, 0.039274>, <105.000000, 0.100000, 0.000000>, <109.225000, -2.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <95.351048, 2.232833, 0.643218>, <100.203600, 0.227613, 0.039274>, <105.000000, 0.100000, 0.000000>, <109.225000, -2.900000, 0.000000>, 
      <95.570295, 6.249236, 1.137679>, <100.307200, 4.555226, 1.078548>, <105.400000, 3.000000, 1.000000>, <109.650000, 0.000000, 1.000000>, 
      <95.495930, 6.455587, 1.206083>, <100.140567, 4.754341, 1.114652>, <105.400000, 3.200000, -1.000000>, <109.650000, 0.200000, -1.000000>, 
      <95.753943, 10.469724, 1.135173>, <100.582240, 8.711031, 1.121589>, <105.350000, 6.250000, 0.000000>, <109.575000, 3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <95.753943, 10.469724, 1.135173>, <100.582240, 8.711031, 1.121589>, <105.350000, 6.250000, 0.000000>, <109.575000, 3.600000, 0.000000>, 
      <96.011956, 14.483861, 1.064264>, <101.023913, 12.667721, 1.128527>, <105.300000, 9.300000, 1.000000>, <109.500000, 7.000000, 1.000000>, 
      <95.928640, 14.683418, 0.082316>, <100.857279, 12.866836, 1.164631>, <105.300000, 9.500000, -1.000000>, <109.500000, 7.250000, -1.000000>, 
      <96.159447, 18.462110, 0.590360>, <100.968894, 16.374220, 1.180721>, <106.406966, 12.799534, 0.064264>, <110.153483, 10.349767, 0.032132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <96.159447, 18.462110, 0.590360>, <100.968894, 16.374220, 1.180721>, <106.406966, 12.799534, 0.064264>, <110.153483, 10.349767, 0.032132>, 
      <96.390255, 22.240802, 1.098405>, <101.080509, 19.881603, 1.196810>, <107.513932, 16.099068, 1.128527>, <110.806966, 13.449534, 1.064264>, 
      <96.429919, 22.440359, 0.148757>, <101.159838, 20.080718, 1.297515>, <107.321286, 16.306666, 1.164631>, <110.710643, 13.653333, 0.082316>, 
      <97.290844, 26.049319, 0.594016>, <102.231687, 23.898639, 1.188031>, <108.618143, 20.360083, 1.180721>, <111.909072, 17.180042, 0.590360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <97.290844, 26.049319, 0.594016>, <102.231687, 23.898639, 1.188031>, <108.618143, 20.360083, 1.180721>, <111.909072, 17.180042, 0.590360>, 
      <98.151769, 29.658279, 1.039274>, <103.303537, 27.716559, 1.078548>, <109.915000, 24.413500, 1.196810>, <113.107500, 20.706750, 1.098405>, 
      <98.055446, 29.862079, 0.057326>, <103.110891, 27.924158, 1.114652>, <109.968316, 24.621099, 1.297515>, <113.134158, 20.910549, 0.148757>, 
      <98.852723, 33.456039, 0.528663>, <103.705446, 31.062079, 1.057326>, <110.354286, 27.426498, 1.188031>, <113.866059, 23.690472, 0.613653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <98.852723, 33.456039, 0.528663>, <103.705446, 31.062079, 1.057326>, <110.354286, 27.426498, 1.188031>, <113.866059, 23.690472, 0.613653>, 
      <99.650000, 37.050000, 1.000000>, <104.300000, 34.200000, 1.000000>, <110.740256, 30.231897, 1.078548>, <114.597960, 26.470394, 1.078548>, 
      <99.650000, 37.250000, -1.000000>, <104.300000, 34.400000, -1.000000>, <110.547611, 30.439496, 1.114652>, <114.405314, 26.677993, 1.114652>, 
      <100.300000, 41.050000, 0.700000>, <105.300000, 38.100000, 0.700000>, <111.200000, 34.600000, 0.700000>, <115.103722, 30.775016, 1.019719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <99.400000, -163.300000, -1.000000>, <103.000000, -163.900000, -1.000000>, <106.600000, -164.300000, -1.000000>, <108.950000, -164.450000, -1.000000>, 
      <99.850000, -159.600000, 1.000000>, <103.400000, -160.000000, 1.000000>, <105.200000, -159.200000, 1.000000>, <108.700000, -160.000000, 1.000000>, 
      <99.850000, -159.350000, -1.000000>, <103.400000, -159.700000, -1.000000>, <105.200000, -158.900000, -1.000000>, <108.700000, -159.750000, -1.000000>, 
      <100.175000, -156.350000, 0.000000>, <103.750000, -156.700000, 0.000000>, <105.900000, -155.950000, 0.000000>, <109.400000, -156.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <100.175000, -156.350000, 0.000000>, <103.750000, -156.700000, 0.000000>, <105.900000, -155.950000, 0.000000>, <109.400000, -156.800000, 0.000000>, 
      <100.500000, -153.350000, 1.000000>, <104.100000, -153.700000, 1.000000>, <106.600000, -153.000000, 1.000000>, <110.100000, -153.850000, 1.000000>, 
      <100.500000, -153.150000, -1.000000>, <104.100000, -153.500000, -1.000000>, <106.700000, -152.800000, -1.000000>, <110.200000, -153.650000, -1.000000>, 
      <100.800000, -150.150000, 0.000000>, <104.400000, -150.500000, 0.000000>, <107.400000, -149.850000, 0.000000>, <110.900000, -150.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <100.800000, -150.150000, 0.000000>, <104.400000, -150.500000, 0.000000>, <107.400000, -149.850000, 0.000000>, <110.900000, -150.700000, 0.000000>, 
      <101.100000, -147.150000, 1.000000>, <104.700000, -147.500000, 1.000000>, <108.100000, -146.900000, 1.000000>, <111.600000, -147.750000, 1.000000>, 
      <101.100000, -146.900000, -1.000000>, <104.700000, -147.300000, -1.000000>, <108.100000, -146.700000, -1.000000>, <111.600000, -147.500000, -1.000000>, 
      <101.425000, -143.875000, 0.000000>, <105.000000, -144.250000, 0.000000>, <108.800000, -143.750000, 0.000000>, <112.300000, -144.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <101.425000, -143.875000, 0.000000>, <105.000000, -144.250000, 0.000000>, <108.800000, -143.750000, 0.000000>, <112.300000, -144.550000, 0.000000>, 
      <101.750000, -140.850000, 1.000000>, <105.300000, -141.200000, 1.000000>, <109.500000, -140.800000, 1.000000>, <113.000000, -141.600000, 1.000000>, 
      <101.750000, -140.650000, -1.000000>, <105.300000, -141.000000, -1.000000>, <109.500000, -140.600000, -1.000000>, <113.000000, -141.400000, -1.000000>, 
      <102.050000, -137.650000, 0.000000>, <105.600000, -138.000000, 0.000000>, <110.200000, -137.650000, 0.000000>, <113.700000, -138.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <102.050000, -137.650000, 0.000000>, <105.600000, -138.000000, 0.000000>, <110.200000, -137.650000, 0.000000>, <113.700000, -138.450000, 0.000000>, 
      <102.350000, -134.650000, 1.000000>, <105.900000, -135.000000, 1.000000>, <110.900000, -134.700000, 1.000000>, <114.400000, -135.500000, 1.000000>, 
      <102.400000, -134.450000, -1.000000>, <106.000000, -134.800000, -1.000000>, <110.900000, -134.500000, -1.000000>, <114.400000, -135.300000, -1.000000>, 
      <102.700000, -131.425000, 0.000000>, <106.300000, -131.800000, 0.000000>, <111.600000, -131.550000, 0.000000>, <115.100000, -132.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <102.700000, -131.425000, 0.000000>, <106.300000, -131.800000, 0.000000>, <111.600000, -131.550000, 0.000000>, <115.100000, -132.350000, 0.000000>, 
      <103.000000, -128.400000, 1.000000>, <106.600000, -128.800000, 1.000000>, <112.300000, -128.600000, 1.000000>, <115.800000, -129.400000, 1.000000>, 
      <103.000000, -128.150000, -1.000000>, <106.600000, -128.500000, -1.000000>, <112.300000, -128.400000, -1.000000>, <115.800000, -129.200000, -1.000000>, 
      <103.325000, -125.150000, 0.000000>, <106.900000, -125.500000, 0.000000>, <113.000000, -125.450000, 0.000000>, <116.500000, -126.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <103.325000, -125.150000, 0.000000>, <106.900000, -125.500000, 0.000000>, <113.000000, -125.450000, 0.000000>, <116.500000, -126.250000, 0.000000>, 
      <103.650000, -122.150000, 1.000000>, <107.200000, -122.500000, 1.000000>, <113.700000, -122.500000, 1.000000>, <117.200000, -123.300000, 1.000000>, 
      <103.650000, -121.950000, -1.000000>, <107.200000, -122.300000, -1.000000>, <113.800000, -122.300000, -1.000000>, <117.300000, -123.100000, -1.000000>, 
      <104.900000, -118.775000, 0.000000>, <109.400000, -118.950000, 0.000000>, <114.450000, -119.350000, 0.000000>, <117.950000, -120.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <104.900000, -118.775000, 0.000000>, <109.400000, -118.950000, 0.000000>, <114.450000, -119.350000, 0.000000>, <117.950000, -120.150000, 0.000000>, 
      <106.150000, -115.600000, 1.000000>, <111.600000, -115.600000, 1.000000>, <115.100000, -116.400000, 1.000000>, <118.600000, -117.200000, 1.000000>, 
      <106.200000, -115.350000, -1.000000>, <111.700000, -115.400000, -1.000000>, <115.200000, -116.200000, -1.000000>, <118.700000, -117.000000, -1.000000>, 
      <106.700000, -112.375000, 0.000000>, <112.400000, -112.450000, 0.000000>, <115.900000, -113.250000, 0.000000>, <119.400000, -114.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <106.700000, -112.375000, 0.000000>, <112.400000, -112.450000, 0.000000>, <115.900000, -113.250000, 0.000000>, <119.400000, -114.050000, 0.000000>, 
      <107.200000, -109.400000, 1.000000>, <113.100000, -109.500000, 1.000000>, <116.600000, -110.300000, 1.000000>, <120.100000, -111.100000, 1.000000>, 
      <107.200000, -109.150000, -1.000000>, <113.100000, -109.200000, -1.000000>, <116.600000, -110.100000, -1.000000>, <120.100000, -110.900000, -1.000000>, 
      <107.000000, -104.975000, 0.000000>, <113.800000, -106.250000, 0.000000>, <117.300000, -107.150000, 0.000000>, <120.800000, -107.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <107.000000, -104.975000, 0.000000>, <113.800000, -106.250000, 0.000000>, <117.300000, -107.150000, 0.000000>, <120.800000, -107.950000, 0.000000>, 
      <106.800000, -100.800000, 1.000000>, <114.500000, -103.300000, 1.000000>, <118.000000, -104.200000, 1.000000>, <121.500000, -105.000000, 1.000000>, 
      <106.800000, -100.600000, -1.000000>, <114.500000, -103.100000, -1.000000>, <118.000000, -104.000000, -1.000000>, <121.500000, -104.800000, -1.000000>, 
      <107.275000, -97.600000, 0.000000>, <115.200000, -100.150000, 0.000000>, <118.700000, -101.000000, 0.000000>, <122.200000, -101.825000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <107.275000, -97.600000, 0.000000>, <115.200000, -100.150000, 0.000000>, <118.700000, -101.000000, 0.000000>, <122.200000, -101.825000, 0.000000>, 
      <107.750000, -94.600000, 1.000000>, <115.900000, -97.200000, 1.000000>, <119.400000, -98.000000, 1.000000>, <122.900000, -98.850000, 1.000000>, 
      <107.750000, -94.400000, -1.000000>, <115.900000, -97.000000, -1.000000>, <119.400000, -97.800000, -1.000000>, <122.900000, -98.650000, -1.000000>, 
      <108.250000, -91.425000, 0.000000>, <116.600000, -94.050000, 0.000000>, <120.100000, -94.850000, 0.000000>, <124.200000, -96.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <108.250000, -91.425000, 0.000000>, <116.600000, -94.050000, 0.000000>, <120.100000, -94.850000, 0.000000>, <124.200000, -96.000000, 0.000000>, 
      <108.750000, -88.450000, 1.000000>, <117.300000, -91.100000, 1.000000>, <120.800000, -91.900000, 1.000000>, <125.500000, -93.350000, 1.000000>, 
      <108.800000, -88.250000, -1.000000>, <117.400000, -90.900000, -1.000000>, <120.800000, -91.700000, -1.000000>, <125.550000, -93.150000, -1.000000>, 
      <109.250000, -85.250000, 0.000000>, <118.050000, -87.950000, 0.000000>, <121.500000, -88.750000, 0.000000>, <126.250000, -90.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <109.250000, -85.250000, 0.000000>, <118.050000, -87.950000, 0.000000>, <121.500000, -88.750000, 0.000000>, <126.250000, -90.200000, 0.000000>, 
      <109.700000, -82.250000, 1.000000>, <118.700000, -85.000000, 1.000000>, <122.200000, -85.800000, 1.000000>, <126.950000, -87.250000, 1.000000>, 
      <109.750000, -82.050000, -1.000000>, <118.800000, -84.800000, -1.000000>, <122.300000, -85.600000, -1.000000>, <127.000000, -87.050000, -1.000000>, 
      <110.225000, -78.875000, 0.000000>, <119.500000, -81.450000, 0.000000>, <123.000000, -82.650000, 0.000000>, <127.700000, -84.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <110.225000, -78.875000, 0.000000>, <119.500000, -81.450000, 0.000000>, <123.000000, -82.650000, 0.000000>, <127.700000, -84.100000, 0.000000>, 
      <110.700000, -75.700000, 1.000000>, <120.200000, -78.100000, 1.000000>, <123.700000, -79.700000, 1.000000>, <128.400000, -81.150000, 1.000000>, 
      <110.750000, -75.500000, -1.000000>, <120.300000, -77.900000, -1.000000>, <123.700000, -79.500000, -1.000000>, <128.400000, -80.950000, -1.000000>, 
      <110.400000, -72.350000, 0.000000>, <119.350000, -74.650000, 0.000000>, <122.800000, -75.900000, 0.000000>, <128.300000, -77.675000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <110.400000, -72.350000, 0.000000>, <119.350000, -74.650000, 0.000000>, <122.800000, -75.900000, 0.000000>, <128.300000, -77.675000, 0.000000>, 
      <110.050000, -69.200000, 1.000000>, <118.400000, -71.400000, 1.000000>, <121.900000, -72.300000, 1.000000>, <128.200000, -74.400000, 1.000000>, 
      <110.050000, -69.000000, -1.000000>, <118.400000, -71.200000, -1.000000>, <121.900000, -72.000000, -1.000000>, <128.200000, -74.150000, -1.000000>, 
      <111.350000, -66.975000, 0.000000>, <120.700000, -68.950000, 0.000000>, <124.200000, -69.750000, 0.000000>, <129.700000, -71.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <111.350000, -66.975000, 0.000000>, <120.700000, -68.950000, 0.000000>, <124.200000, -69.750000, 0.000000>, <129.700000, -71.550000, 0.000000>, 
      <112.650000, -64.950000, 1.000000>, <123.000000, -66.700000, 1.000000>, <126.500000, -67.500000, 1.000000>, <131.200000, -68.950000, 1.000000>, 
      <112.650000, -64.700000, -1.000000>, <123.000000, -66.500000, -1.000000>, <126.500000, -67.300000, -1.000000>, <131.200000, -68.750000, -1.000000>, 
      <113.125000, -61.725000, 0.000000>, <123.700000, -63.550000, 0.000000>, <128.400000, -65.000000, 0.000000>, <132.500000, -66.125000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <113.125000, -61.725000, 0.000000>, <123.700000, -63.550000, 0.000000>, <128.400000, -65.000000, 0.000000>, <132.500000, -66.125000, 0.000000>, 
      <113.600000, -58.750000, 1.000000>, <124.400000, -60.600000, 1.000000>, <130.300000, -62.700000, 1.000000>, <133.800000, -63.500000, 1.000000>, 
      <113.600000, -58.550000, -1.000000>, <124.400000, -60.400000, -1.000000>, <130.400000, -62.400000, -1.000000>, <133.900000, -63.250000, -1.000000>, 
      <112.975000, -55.400000, 0.000000>, <123.450000, -57.450000, 0.000000>, <128.250000, -58.600000, 0.000000>, <133.150000, -59.875000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <112.975000, -55.400000, 0.000000>, <123.450000, -57.450000, 0.000000>, <128.250000, -58.600000, 0.000000>, <133.150000, -59.875000, 0.000000>, 
      <112.350000, -52.250000, 1.000000>, <122.500000, -54.500000, 1.000000>, <126.100000, -54.800000, 1.000000>, <132.400000, -56.500000, 1.000000>, 
      <112.350000, -52.050000, -1.000000>, <122.500000, -54.300000, -1.000000>, <126.100000, -54.600000, -1.000000>, <132.450000, -56.300000, -1.000000>, 
      <112.850000, -49.250000, 0.000000>, <122.800000, -51.250000, 0.000000>, <127.600000, -52.200000, 0.000000>, <133.550000, -53.625000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <112.850000, -49.250000, 0.000000>, <122.800000, -51.250000, 0.000000>, <127.600000, -52.200000, 0.000000>, <133.550000, -53.625000, 0.000000>, 
      <113.350000, -46.450000, 1.000000>, <123.100000, -48.200000, 1.000000>, <129.100000, -49.800000, 1.000000>, <134.650000, -50.950000, 1.000000>, 
      <113.350000, -46.250000, -1.000000>, <123.100000, -48.000000, -1.000000>, <129.100000, -49.600000, -1.000000>, <134.650000, -50.750000, -1.000000>, 
      <111.825000, -43.250000, 0.000000>, <119.650000, -44.500000, 0.000000>, <126.550000, -46.450000, 0.000000>, <132.375000, -47.925000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <111.825000, -43.250000, 0.000000>, <119.650000, -44.500000, 0.000000>, <126.550000, -46.450000, 0.000000>, <132.375000, -47.925000, 0.000000>, 
      <110.300000, -40.250000, 1.000000>, <116.200000, -41.000000, 1.000000>, <124.000000, -43.300000, 1.000000>, <130.100000, -45.100000, 1.000000>, 
      <110.300000, -40.000000, -1.000000>, <116.200000, -40.700000, -1.000000>, <124.100000, -43.000000, -1.000000>, <130.150000, -44.850000, -1.000000>, 
      <110.350000, -36.050000, 0.000000>, <116.350000, -36.950000, 0.000000>, <123.800000, -39.950000, 0.000000>, <129.600000, -41.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <110.350000, -36.050000, 0.000000>, <116.350000, -36.950000, 0.000000>, <123.800000, -39.950000, 0.000000>, <129.600000, -41.950000, 0.000000>, 
      <110.400000, -32.100000, 1.000000>, <116.500000, -33.200000, 1.000000>, <123.500000, -36.900000, 1.000000>, <129.050000, -39.050000, 1.000000>, 
      <110.400000, -31.900000, -1.000000>, <116.500000, -33.000000, -1.000000>, <123.500000, -36.700000, -1.000000>, <129.050000, -38.850000, -1.000000>, 
      <109.275000, -28.400000, 0.000000>, <114.500000, -29.600000, 0.000000>, <123.350000, -34.150000, 0.000000>, <128.750000, -36.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <109.275000, -28.400000, 0.000000>, <114.500000, -29.600000, 0.000000>, <123.350000, -34.150000, 0.000000>, <128.750000, -36.250000, 0.000000>, 
      <108.150000, -24.900000, 1.000000>, <112.500000, -26.200000, 1.000000>, <123.200000, -31.600000, 1.000000>, <128.450000, -33.650000, 1.000000>, 
      <108.150000, -24.700000, -1.000000>, <112.500000, -26.000000, -1.000000>, <123.300000, -31.400000, -1.000000>, <128.500000, -33.450000, -1.000000>, 
      <108.100000, -21.600000, 0.000000>, <112.450000, -23.500000, 0.000000>, <122.200000, -26.650000, 0.000000>, <127.950000, -28.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <108.100000, -21.600000, 0.000000>, <112.450000, -23.500000, 0.000000>, <122.200000, -26.650000, 0.000000>, <127.950000, -28.750000, 0.000000>, 
      <108.050000, -18.500000, 1.000000>, <112.400000, -21.000000, 1.000000>, <121.100000, -21.900000, 1.000000>, <127.400000, -24.050000, 1.000000>, 
      <108.100000, -18.300000, -1.000000>, <112.400000, -20.800000, -1.000000>, <121.200000, -21.700000, -1.000000>, <127.500000, -23.850000, -1.000000>, 
      <107.875000, -15.250000, 0.000000>, <112.150000, -18.000000, 0.000000>, <121.400000, -18.650000, 0.000000>, <127.700000, -20.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <107.875000, -15.250000, 0.000000>, <112.150000, -18.000000, 0.000000>, <121.400000, -18.650000, 0.000000>, <127.700000, -20.800000, 0.000000>, 
      <107.650000, -12.200000, 1.000000>, <111.900000, -15.200000, 1.000000>, <121.600000, -15.600000, 1.000000>, <127.900000, -17.750000, 1.000000>, 
      <107.700000, -12.000000, -1.000000>, <111.900000, -15.000000, -1.000000>, <121.700000, -15.300000, -1.000000>, <127.950000, -17.500000, -1.000000>, 
      <108.225000, -9.000000, 0.000000>, <112.450000, -12.000000, 0.000000>, <121.800000, -12.400000, 0.000000>, <128.050000, -14.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <108.225000, -9.000000, 0.000000>, <112.450000, -12.000000, 0.000000>, <121.800000, -12.400000, 0.000000>, <128.050000, -14.575000, 0.000000>, 
      <108.750000, -6.000000, 1.000000>, <113.000000, -9.000000, 1.000000>, <121.900000, -9.500000, 1.000000>, <128.150000, -11.650000, 1.000000>, 
      <108.800000, -5.800000, -1.000000>, <113.000000, -8.800000, -1.000000>, <121.900000, -9.300000, -1.000000>, <128.200000, -11.450000, -1.000000>, 
      <109.225000, -2.900000, 0.000000>, <113.450000, -5.900000, 0.000000>, <122.450000, -7.150000, 0.000000>, <128.650000, -9.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <109.225000, -2.900000, 0.000000>, <113.450000, -5.900000, 0.000000>, <122.450000, -7.150000, 0.000000>, <128.650000, -9.150000, 0.000000>, 
      <109.650000, 0.000000, 1.000000>, <113.900000, -3.000000, 1.000000>, <123.000000, -5.000000, 1.000000>, <129.100000, -6.850000, 1.000000>, 
      <109.650000, 0.200000, -1.000000>, <113.900000, -2.800000, -1.000000>, <123.000000, -4.800000, -1.000000>, <129.100000, -6.650000, -1.000000>, 
      <109.575000, 3.600000, 0.000000>, <113.800000, 0.950000, 0.000000>, <123.550000, -1.450000, 0.000000>, <129.850000, -3.475000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <109.575000, 3.600000, 0.000000>, <113.800000, 0.950000, 0.000000>, <123.550000, -1.450000, 0.000000>, <129.850000, -3.475000, 0.000000>, 
      <109.500000, 7.000000, 1.000000>, <113.700000, 4.700000, 1.000000>, <124.100000, 1.900000, 1.000000>, <130.600000, -0.300000, 1.000000>, 
      <109.500000, 7.250000, -1.000000>, <113.700000, 5.000000, -1.000000>, <124.100000, 2.100000, -1.000000>, <130.600000, -0.150000, -1.000000>, 
      <110.153483, 10.349767, 0.032132>, <113.900000, 7.900000, 0.000000>, <124.650000, 4.400000, 0.000000>, <131.175000, 1.975000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <110.153483, 10.349767, 0.032132>, <113.900000, 7.900000, 0.000000>, <124.650000, 4.400000, 0.000000>, <131.175000, 1.975000, 0.000000>, 
      <110.806966, 13.449534, 1.064264>, <114.100000, 10.800000, 1.000000>, <125.200000, 6.700000, 1.000000>, <131.750000, 4.100000, 1.000000>, 
      <110.710643, 13.653333, 0.082316>, <114.100000, 11.000000, -1.000000>, <125.200000, 7.000000, -1.000000>, <131.750000, 4.350000, -1.000000>, 
      <111.909072, 17.180042, 0.590360>, <115.200000, 14.000000, 0.000000>, <125.600000, 9.750000, 0.000000>, <132.900000, 6.575000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <111.909072, 17.180042, 0.590360>, <115.200000, 14.000000, 0.000000>, <125.600000, 9.750000, 0.000000>, <132.900000, 6.575000, 0.000000>, 
      <113.107500, 20.706750, 1.098405>, <116.300000, 17.000000, 1.000000>, <126.000000, 12.500000, 1.000000>, <134.050000, 8.800000, 1.000000>, 
      <113.134158, 20.910549, 0.148757>, <116.300000, 17.200000, -1.000000>, <126.000000, 12.700000, -1.000000>, <134.050000, 9.000000, -1.000000>, 
      <113.866059, 23.690472, 0.613653>, <117.377832, 19.954446, 0.039274>, <126.450000, 15.150000, 0.000000>, <134.625000, 11.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <113.866059, 23.690472, 0.613653>, <117.377832, 19.954446, 0.039274>, <126.450000, 15.150000, 0.000000>, <134.625000, 11.700000, 0.000000>, 
      <114.597960, 26.470394, 1.078548>, <118.455663, 22.708892, 1.078548>, <126.900000, 17.600000, 1.000000>, <135.200000, 14.400000, 1.000000>, 
      <114.405314, 26.677993, 1.114652>, <118.263018, 22.916490, 1.114652>, <126.900000, 17.800000, -1.000000>, <135.250000, 14.600000, -1.000000>, 
      <115.103722, 30.775016, 1.019719>, <119.007444, 26.950031, 1.339437>, <127.800000, 21.600000, 0.700000>, <136.100000, 18.400000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <108.950000, -164.450000, -1.000000>, <111.300000, -164.600000, -1.000000>, <114.800000, -165.500000, -1.000000>, <118.300000, -166.300000, -1.000000>, 
      <108.700000, -160.000000, 1.000000>, <112.200000, -160.800000, 1.000000>, <115.700000, -161.600000, 1.000000>, <119.200000, -162.400000, 1.000000>, 
      <108.700000, -159.750000, -1.000000>, <112.200000, -160.600000, -1.000000>, <115.700000, -161.400000, -1.000000>, <119.200000, -162.200000, -1.000000>, 
      <109.400000, -156.800000, 0.000000>, <112.900000, -157.650000, 0.000000>, <116.400000, -158.450000, 0.000000>, <119.900000, -159.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <109.400000, -156.800000, 0.000000>, <112.900000, -157.650000, 0.000000>, <116.400000, -158.450000, 0.000000>, <119.900000, -159.250000, 0.000000>, 
      <110.100000, -153.850000, 1.000000>, <113.600000, -154.700000, 1.000000>, <117.100000, -155.500000, 1.000000>, <120.600000, -156.300000, 1.000000>, 
      <110.200000, -153.650000, -1.000000>, <113.700000, -154.500000, -1.000000>, <117.200000, -155.300000, -1.000000>, <120.700000, -156.100000, -1.000000>, 
      <110.900000, -150.700000, 0.000000>, <114.400000, -151.550000, 0.000000>, <117.900000, -152.350000, 0.000000>, <121.400000, -153.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <110.900000, -150.700000, 0.000000>, <114.400000, -151.550000, 0.000000>, <117.900000, -152.350000, 0.000000>, <121.400000, -153.150000, 0.000000>, 
      <111.600000, -147.750000, 1.000000>, <115.100000, -148.600000, 1.000000>, <118.600000, -149.400000, 1.000000>, <122.100000, -150.200000, 1.000000>, 
      <111.600000, -147.500000, -1.000000>, <115.100000, -148.300000, -1.000000>, <118.600000, -149.200000, -1.000000>, <122.100000, -150.000000, -1.000000>, 
      <112.300000, -144.550000, 0.000000>, <115.800000, -145.350000, 0.000000>, <119.300000, -146.250000, 0.000000>, <122.800000, -147.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <112.300000, -144.550000, 0.000000>, <115.800000, -145.350000, 0.000000>, <119.300000, -146.250000, 0.000000>, <122.800000, -147.050000, 0.000000>, 
      <113.000000, -141.600000, 1.000000>, <116.500000, -142.400000, 1.000000>, <120.000000, -143.300000, 1.000000>, <123.500000, -144.100000, 1.000000>, 
      <113.000000, -141.400000, -1.000000>, <116.500000, -142.200000, -1.000000>, <120.000000, -143.000000, -1.000000>, <123.500000, -143.850000, -1.000000>, 
      <113.700000, -138.450000, 0.000000>, <117.200000, -139.250000, 0.000000>, <120.700000, -140.050000, 0.000000>, <124.200000, -140.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <113.700000, -138.450000, 0.000000>, <117.200000, -139.250000, 0.000000>, <120.700000, -140.050000, 0.000000>, <124.200000, -140.900000, 0.000000>, 
      <114.400000, -135.500000, 1.000000>, <117.900000, -136.300000, 1.000000>, <121.400000, -137.100000, 1.000000>, <124.900000, -137.950000, 1.000000>, 
      <114.400000, -135.300000, -1.000000>, <117.900000, -136.100000, -1.000000>, <121.400000, -136.900000, -1.000000>, <124.900000, -137.750000, -1.000000>, 
      <115.100000, -132.350000, 0.000000>, <118.600000, -133.150000, 0.000000>, <122.100000, -133.950000, 0.000000>, <126.200000, -135.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <115.100000, -132.350000, 0.000000>, <118.600000, -133.150000, 0.000000>, <122.100000, -133.950000, 0.000000>, <126.200000, -135.100000, 0.000000>, 
      <115.800000, -129.400000, 1.000000>, <119.300000, -130.200000, 1.000000>, <122.800000, -131.000000, 1.000000>, <127.500000, -132.450000, 1.000000>, 
      <115.800000, -129.200000, -1.000000>, <119.300000, -130.000000, -1.000000>, <122.800000, -130.800000, -1.000000>, <127.550000, -132.250000, -1.000000>, 
      <116.500000, -126.250000, 0.000000>, <120.000000, -127.050000, 0.000000>, <123.500000, -127.850000, 0.000000>, <128.225000, -129.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <116.500000, -126.250000, 0.000000>, <120.000000, -127.050000, 0.000000>, <123.500000, -127.850000, 0.000000>, <128.225000, -129.300000, 0.000000>, 
      <117.200000, -123.300000, 1.000000>, <120.700000, -124.100000, 1.000000>, <124.200000, -124.900000, 1.000000>, <128.900000, -126.350000, 1.000000>, 
      <117.300000, -123.100000, -1.000000>, <120.800000, -123.900000, -1.000000>, <124.300000, -124.700000, -1.000000>, <129.000000, -126.150000, -1.000000>, 
      <117.950000, -120.150000, 0.000000>, <121.450000, -120.950000, 0.000000>, <124.950000, -121.750000, 0.000000>, <129.675000, -123.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <117.950000, -120.150000, 0.000000>, <121.450000, -120.950000, 0.000000>, <124.950000, -121.750000, 0.000000>, <129.675000, -123.200000, 0.000000>, 
      <118.600000, -117.200000, 1.000000>, <122.100000, -118.000000, 1.000000>, <125.600000, -118.800000, 1.000000>, <130.350000, -120.250000, 1.000000>, 
      <118.700000, -117.000000, -1.000000>, <122.200000, -117.800000, -1.000000>, <125.700000, -118.600000, -1.000000>, <130.400000, -120.050000, -1.000000>, 
      <119.400000, -114.050000, 0.000000>, <122.900000, -114.850000, 0.000000>, <126.400000, -115.650000, 0.000000>, <131.100000, -117.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <119.400000, -114.050000, 0.000000>, <122.900000, -114.850000, 0.000000>, <126.400000, -115.650000, 0.000000>, <131.100000, -117.100000, 0.000000>, 
      <120.100000, -111.100000, 1.000000>, <123.600000, -111.900000, 1.000000>, <127.100000, -112.700000, 1.000000>, <131.800000, -114.150000, 1.000000>, 
      <120.100000, -110.900000, -1.000000>, <123.600000, -111.700000, -1.000000>, <127.100000, -112.500000, -1.000000>, <131.800000, -113.950000, -1.000000>, 
      <120.800000, -107.950000, 0.000000>, <124.300000, -108.750000, 0.000000>, <129.000000, -110.200000, 0.000000>, <133.100000, -111.325000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <120.800000, -107.950000, 0.000000>, <124.300000, -108.750000, 0.000000>, <129.000000, -110.200000, 0.000000>, <133.100000, -111.325000, 0.000000>, 
      <121.500000, -105.000000, 1.000000>, <125.000000, -105.800000, 1.000000>, <130.900000, -107.900000, 1.000000>, <134.400000, -108.700000, 1.000000>, 
      <121.500000, -104.800000, -1.000000>, <125.000000, -105.600000, -1.000000>, <130.900000, -107.700000, -1.000000>, <134.400000, -108.500000, -1.000000>, 
      <122.200000, -101.825000, 0.000000>, <125.700000, -102.650000, 0.000000>, <131.600000, -104.750000, 0.000000>, <135.100000, -105.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <122.200000, -101.825000, 0.000000>, <125.700000, -102.650000, 0.000000>, <131.600000, -104.750000, 0.000000>, <135.100000, -105.550000, 0.000000>, 
      <122.900000, -98.850000, 1.000000>, <126.400000, -99.700000, 1.000000>, <132.300000, -101.800000, 1.000000>, <135.800000, -102.600000, 1.000000>, 
      <122.900000, -98.650000, -1.000000>, <126.400000, -99.500000, -1.000000>, <132.400000, -101.500000, -1.000000>, <135.900000, -102.350000, -1.000000>, 
      <124.200000, -96.000000, 0.000000>, <128.300000, -97.150000, 0.000000>, <133.050000, -98.550000, 0.000000>, <136.550000, -99.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <124.200000, -96.000000, 0.000000>, <128.300000, -97.150000, 0.000000>, <133.050000, -98.550000, 0.000000>, <136.550000, -99.400000, 0.000000>, 
      <125.500000, -93.350000, 1.000000>, <130.200000, -94.800000, 1.000000>, <133.700000, -95.600000, 1.000000>, <137.200000, -96.450000, 1.000000>, 
      <125.550000, -93.150000, -1.000000>, <130.300000, -94.600000, -1.000000>, <133.800000, -95.400000, -1.000000>, <137.300000, -96.250000, -1.000000>, 
      <126.250000, -90.200000, 0.000000>, <131.000000, -91.650000, 0.000000>, <134.500000, -92.450000, 0.000000>, <138.000000, -93.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <126.250000, -90.200000, 0.000000>, <131.000000, -91.650000, 0.000000>, <134.500000, -92.450000, 0.000000>, <138.000000, -93.300000, 0.000000>, 
      <126.950000, -87.250000, 1.000000>, <131.700000, -88.700000, 1.000000>, <135.200000, -89.500000, 1.000000>, <138.700000, -90.350000, 1.000000>, 
      <127.000000, -87.050000, -1.000000>, <131.700000, -88.500000, -1.000000>, <135.200000, -89.300000, -1.000000>, <138.700000, -90.150000, -1.000000>, 
      <127.700000, -84.100000, 0.000000>, <132.400000, -85.550000, 0.000000>, <135.900000, -86.350000, 0.000000>, <139.400000, -87.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <127.700000, -84.100000, 0.000000>, <132.400000, -85.550000, 0.000000>, <135.900000, -86.350000, 0.000000>, <139.400000, -87.200000, 0.000000>, 
      <128.400000, -81.150000, 1.000000>, <133.100000, -82.600000, 1.000000>, <136.600000, -83.400000, 1.000000>, <140.100000, -84.250000, 1.000000>, 
      <128.400000, -80.950000, -1.000000>, <133.100000, -82.400000, -1.000000>, <136.600000, -83.200000, -1.000000>, <140.100000, -84.000000, -1.000000>, 
      <128.300000, -77.675000, 0.000000>, <133.800000, -79.450000, 0.000000>, <137.300000, -80.250000, 0.000000>, <140.800000, -81.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <128.300000, -77.675000, 0.000000>, <133.800000, -79.450000, 0.000000>, <137.300000, -80.250000, 0.000000>, <140.800000, -81.050000, 0.000000>, 
      <128.200000, -74.400000, 1.000000>, <134.500000, -76.500000, 1.000000>, <138.000000, -77.300000, 1.000000>, <141.500000, -78.100000, 1.000000>, 
      <128.200000, -74.150000, -1.000000>, <134.500000, -76.300000, -1.000000>, <138.000000, -77.100000, -1.000000>, <141.500000, -77.900000, -1.000000>, 
      <129.700000, -71.550000, 0.000000>, <135.200000, -73.350000, 0.000000>, <138.700000, -74.150000, 0.000000>, <142.200000, -74.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <129.700000, -71.550000, 0.000000>, <135.200000, -73.350000, 0.000000>, <138.700000, -74.150000, 0.000000>, <142.200000, -74.950000, 0.000000>, 
      <131.200000, -68.950000, 1.000000>, <135.900000, -70.400000, 1.000000>, <139.400000, -71.200000, 1.000000>, <142.900000, -72.000000, 1.000000>, 
      <131.200000, -68.750000, -1.000000>, <135.900000, -70.200000, -1.000000>, <139.400000, -71.000000, -1.000000>, <142.900000, -71.800000, -1.000000>, 
      <132.500000, -66.125000, 0.000000>, <136.600000, -67.250000, 0.000000>, <140.100000, -68.050000, 0.000000>, <143.600000, -68.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <132.500000, -66.125000, 0.000000>, <136.600000, -67.250000, 0.000000>, <140.100000, -68.050000, 0.000000>, <143.600000, -68.850000, 0.000000>, 
      <133.800000, -63.500000, 1.000000>, <137.300000, -64.300000, 1.000000>, <140.800000, -65.100000, 1.000000>, <144.300000, -65.900000, 1.000000>, 
      <133.900000, -63.250000, -1.000000>, <137.400000, -64.100000, -1.000000>, <140.900000, -64.900000, -1.000000>, <144.400000, -65.700000, -1.000000>, 
      <133.150000, -59.875000, 0.000000>, <138.050000, -61.150000, 0.000000>, <141.550000, -61.950000, 0.000000>, <145.050000, -62.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <133.150000, -59.875000, 0.000000>, <138.050000, -61.150000, 0.000000>, <141.550000, -61.950000, 0.000000>, <145.050000, -62.750000, 0.000000>, 
      <132.400000, -56.500000, 1.000000>, <138.700000, -58.200000, 1.000000>, <142.200000, -59.000000, 1.000000>, <145.700000, -59.800000, 1.000000>, 
      <132.450000, -56.300000, -1.000000>, <138.800000, -58.000000, -1.000000>, <142.300000, -58.800000, -1.000000>, <145.800000, -59.600000, -1.000000>, 
      <133.550000, -53.625000, 0.000000>, <139.500000, -55.050000, 0.000000>, <143.000000, -55.850000, 0.000000>, <146.500000, -56.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <133.550000, -53.625000, 0.000000>, <139.500000, -55.050000, 0.000000>, <143.000000, -55.850000, 0.000000>, <146.500000, -56.650000, 0.000000>, 
      <134.650000, -50.950000, 1.000000>, <140.200000, -52.100000, 1.000000>, <143.700000, -52.900000, 1.000000>, <147.200000, -53.700000, 1.000000>, 
      <134.650000, -50.750000, -1.000000>, <140.200000, -51.900000, -1.000000>, <143.700000, -52.700000, -1.000000>, <147.200000, -53.500000, -1.000000>, 
      <132.375000, -47.925000, 0.000000>, <138.200000, -49.400000, 0.000000>, <144.400000, -49.750000, 0.000000>, <147.900000, -50.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <132.375000, -47.925000, 0.000000>, <138.200000, -49.400000, 0.000000>, <144.400000, -49.750000, 0.000000>, <147.900000, -50.550000, 0.000000>, 
      <130.100000, -45.100000, 1.000000>, <136.200000, -46.900000, 1.000000>, <145.100000, -46.800000, 1.000000>, <148.600000, -47.600000, 1.000000>, 
      <130.150000, -44.850000, -1.000000>, <136.200000, -46.700000, -1.000000>, <145.100000, -46.600000, -1.000000>, <148.600000, -47.400000, -1.000000>, 
      <129.600000, -41.950000, 0.000000>, <135.400000, -43.950000, 0.000000>, <143.700000, -43.350000, 0.000000>, <148.250000, -44.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <129.600000, -41.950000, 0.000000>, <135.400000, -43.950000, 0.000000>, <143.700000, -43.350000, 0.000000>, <148.250000, -44.300000, 0.000000>, 
      <129.050000, -39.050000, 1.000000>, <134.600000, -41.200000, 1.000000>, <142.300000, -40.100000, 1.000000>, <147.900000, -41.200000, 1.000000>, 
      <129.050000, -38.850000, -1.000000>, <134.600000, -41.000000, -1.000000>, <142.300000, -39.900000, -1.000000>, <147.900000, -41.000000, -1.000000>, 
      <128.750000, -36.250000, 0.000000>, <134.150000, -38.350000, 0.000000>, <139.950000, -36.750000, 0.000000>, <147.075000, -37.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <128.750000, -36.250000, 0.000000>, <134.150000, -38.350000, 0.000000>, <139.950000, -36.750000, 0.000000>, <147.075000, -37.950000, 0.000000>, 
      <128.450000, -33.650000, 1.000000>, <133.700000, -35.700000, 1.000000>, <137.600000, -33.600000, 1.000000>, <146.250000, -34.900000, 1.000000>, 
      <128.500000, -33.450000, -1.000000>, <133.700000, -35.500000, -1.000000>, <137.600000, -33.400000, -1.000000>, <146.300000, -34.700000, -1.000000>, 
      <127.950000, -28.750000, 0.000000>, <133.700000, -30.850000, 0.000000>, <138.300000, -30.450000, 0.000000>, <146.975000, -31.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <127.950000, -28.750000, 0.000000>, <133.700000, -30.850000, 0.000000>, <138.300000, -30.450000, 0.000000>, <146.975000, -31.750000, 0.000000>, 
      <127.400000, -24.050000, 1.000000>, <133.700000, -26.200000, 1.000000>, <139.000000, -27.500000, 1.000000>, <147.650000, -28.800000, 1.000000>, 
      <127.500000, -23.850000, -1.000000>, <133.800000, -26.000000, -1.000000>, <139.100000, -27.300000, -1.000000>, <147.750000, -28.550000, -1.000000>, 
      <127.700000, -20.800000, 0.000000>, <134.000000, -22.950000, 0.000000>, <139.300000, -24.200000, 0.000000>, <148.200000, -25.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <127.700000, -20.800000, 0.000000>, <134.000000, -22.950000, 0.000000>, <139.300000, -24.200000, 0.000000>, <148.200000, -25.525000, 0.000000>, 
      <127.900000, -17.750000, 1.000000>, <134.200000, -19.900000, 1.000000>, <139.500000, -21.100000, 1.000000>, <148.650000, -22.500000, 1.000000>, 
      <127.950000, -17.500000, -1.000000>, <134.200000, -19.700000, -1.000000>, <139.600000, -20.900000, -1.000000>, <148.700000, -22.300000, -1.000000>, 
      <128.050000, -14.575000, 0.000000>, <134.300000, -16.750000, 0.000000>, <140.300000, -17.650000, 0.000000>, <149.400000, -19.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <128.050000, -14.575000, 0.000000>, <134.300000, -16.750000, 0.000000>, <140.300000, -17.650000, 0.000000>, <149.400000, -19.200000, 0.000000>, 
      <128.150000, -11.650000, 1.000000>, <134.400000, -13.800000, 1.000000>, <141.000000, -14.400000, 1.000000>, <150.100000, -16.100000, 1.000000>, 
      <128.200000, -11.450000, -1.000000>, <134.500000, -13.600000, -1.000000>, <141.000000, -14.200000, -1.000000>, <150.100000, -15.900000, -1.000000>, 
      <128.650000, -9.150000, 0.000000>, <134.850000, -11.150000, 0.000000>, <142.500000, -11.700000, 0.000000>, <151.200000, -13.175000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <128.650000, -9.150000, 0.000000>, <134.850000, -11.150000, 0.000000>, <142.500000, -11.700000, 0.000000>, <151.200000, -13.175000, 0.000000>, 
      <129.100000, -6.850000, 1.000000>, <135.200000, -8.700000, 1.000000>, <144.000000, -9.200000, 1.000000>, <152.300000, -10.450000, 1.000000>, 
      <129.100000, -6.650000, -1.000000>, <135.200000, -8.500000, -1.000000>, <144.000000, -9.000000, -1.000000>, <152.300000, -10.250000, -1.000000>, 
      <129.850000, -3.475000, 0.000000>, <136.150000, -5.500000, 0.000000>, <144.000000, -6.750000, 0.000000>, <152.650000, -7.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <129.850000, -3.475000, 0.000000>, <136.150000, -5.500000, 0.000000>, <144.000000, -6.750000, 0.000000>, <152.650000, -7.650000, 0.000000>, 
      <130.600000, -0.300000, 1.000000>, <137.100000, -2.500000, 1.000000>, <144.000000, -4.500000, 1.000000>, <153.000000, -5.050000, 1.000000>, 
      <130.600000, -0.150000, -1.000000>, <137.100000, -2.400000, -1.000000>, <144.000000, -4.300000, -1.000000>, <153.000000, -4.850000, -1.000000>, 
      <131.175000, 1.975000, 0.000000>, <137.700000, -0.450000, 0.000000>, <145.150000, -2.350000, 0.000000>, <153.925000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <131.175000, 1.975000, 0.000000>, <137.700000, -0.450000, 0.000000>, <145.150000, -2.350000, 0.000000>, <153.925000, -2.400000, 0.000000>, 
      <131.750000, 4.100000, 1.000000>, <138.300000, 1.500000, 1.000000>, <146.300000, -0.400000, 1.000000>, <154.850000, 0.050000, 1.000000>, 
      <131.750000, 4.350000, -1.000000>, <138.300000, 1.700000, -1.000000>, <146.300000, -0.200000, -1.000000>, <154.900000, 0.250000, -1.000000>, 
      <132.900000, 6.575000, 0.000000>, <140.200000, 3.400000, 0.000000>, <145.950000, 2.050000, 0.000000>, <155.050000, 2.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <132.900000, 6.575000, 0.000000>, <140.200000, 3.400000, 0.000000>, <145.950000, 2.050000, 0.000000>, <155.050000, 2.850000, 0.000000>, 
      <134.050000, 8.800000, 1.000000>, <142.100000, 5.100000, 1.000000>, <145.600000, 4.300000, 1.000000>, <155.200000, 5.450000, 1.000000>, 
      <134.050000, 9.000000, -1.000000>, <142.100000, 5.300000, -1.000000>, <145.600000, 4.500000, -1.000000>, <155.250000, 5.650000, -1.000000>, 
      <134.625000, 11.700000, 0.000000>, <142.800000, 8.250000, 0.000000>, <146.300000, 7.450000, 0.000000>, <155.950000, 8.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <134.625000, 11.700000, 0.000000>, <142.800000, 8.250000, 0.000000>, <146.300000, 7.450000, 0.000000>, <155.950000, 8.600000, 0.000000>, 
      <135.200000, 14.400000, 1.000000>, <143.500000, 11.200000, 1.000000>, <147.000000, 10.400000, 1.000000>, <156.650000, 11.550000, 1.000000>, 
      <135.250000, 14.600000, -1.000000>, <143.600000, 11.400000, -1.000000>, <147.100000, 10.600000, -1.000000>, <156.700000, 11.750000, -1.000000>, 
      <136.100000, 18.400000, 0.700000>, <144.400000, 15.200000, 0.700000>, <147.900000, 14.400000, 0.700000>, <157.550000, 15.550000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <118.300000, -166.300000, -1.000000>, <121.800000, -167.100000, -1.000000>, <125.300000, -167.900000, -1.000000>, <130.000000, -169.350000, -1.000000>, 
      <119.200000, -162.400000, 1.000000>, <122.700000, -163.200000, 1.000000>, <126.200000, -164.000000, 1.000000>, <130.900000, -165.450000, 1.000000>, 
      <119.200000, -162.200000, -1.000000>, <122.700000, -163.000000, -1.000000>, <126.200000, -163.800000, -1.000000>, <130.950000, -165.250000, -1.000000>, 
      <119.900000, -159.250000, 0.000000>, <123.400000, -160.050000, 0.000000>, <126.900000, -160.850000, 0.000000>, <131.650000, -162.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <119.900000, -159.250000, 0.000000>, <123.400000, -160.050000, 0.000000>, <126.900000, -160.850000, 0.000000>, <131.650000, -162.300000, 0.000000>, 
      <120.600000, -156.300000, 1.000000>, <124.100000, -157.100000, 1.000000>, <127.600000, -157.900000, 1.000000>, <132.350000, -159.350000, 1.000000>, 
      <120.700000, -156.100000, -1.000000>, <124.200000, -156.900000, -1.000000>, <127.700000, -157.700000, -1.000000>, <132.400000, -159.150000, -1.000000>, 
      <121.400000, -153.150000, 0.000000>, <124.900000, -153.950000, 0.000000>, <129.600000, -155.400000, 0.000000>, <133.700000, -156.525000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <121.400000, -153.150000, 0.000000>, <124.900000, -153.950000, 0.000000>, <129.600000, -155.400000, 0.000000>, <133.700000, -156.525000, 0.000000>, 
      <122.100000, -150.200000, 1.000000>, <125.600000, -151.000000, 1.000000>, <131.500000, -153.100000, 1.000000>, <135.000000, -153.900000, 1.000000>, 
      <122.100000, -150.000000, -1.000000>, <125.600000, -150.800000, -1.000000>, <131.500000, -152.900000, -1.000000>, <135.000000, -153.700000, -1.000000>, 
      <122.800000, -147.050000, 0.000000>, <126.300000, -147.850000, 0.000000>, <132.200000, -149.950000, 0.000000>, <135.700000, -150.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <122.800000, -147.050000, 0.000000>, <126.300000, -147.850000, 0.000000>, <132.200000, -149.950000, 0.000000>, <135.700000, -150.750000, 0.000000>, 
      <123.500000, -144.100000, 1.000000>, <127.000000, -144.900000, 1.000000>, <132.900000, -147.000000, 1.000000>, <136.400000, -147.800000, 1.000000>, 
      <123.500000, -143.850000, -1.000000>, <127.000000, -144.700000, -1.000000>, <132.900000, -146.800000, -1.000000>, <136.400000, -147.600000, -1.000000>, 
      <124.200000, -140.900000, 0.000000>, <127.700000, -141.750000, 0.000000>, <133.600000, -143.850000, 0.000000>, <137.100000, -144.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <124.200000, -140.900000, 0.000000>, <127.700000, -141.750000, 0.000000>, <133.600000, -143.850000, 0.000000>, <137.100000, -144.650000, 0.000000>, 
      <124.900000, -137.950000, 1.000000>, <128.400000, -138.800000, 1.000000>, <134.300000, -140.900000, 1.000000>, <137.800000, -141.700000, 1.000000>, 
      <124.900000, -137.750000, -1.000000>, <128.400000, -138.600000, -1.000000>, <134.300000, -140.600000, -1.000000>, <137.800000, -141.450000, -1.000000>, 
      <126.200000, -135.100000, 0.000000>, <130.300000, -136.250000, 0.000000>, <135.000000, -137.650000, 0.000000>, <138.500000, -138.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <126.200000, -135.100000, 0.000000>, <130.300000, -136.250000, 0.000000>, <135.000000, -137.650000, 0.000000>, <138.500000, -138.500000, 0.000000>, 
      <127.500000, -132.450000, 1.000000>, <132.200000, -133.900000, 1.000000>, <135.700000, -134.700000, 1.000000>, <139.200000, -135.550000, 1.000000>, 
      <127.550000, -132.250000, -1.000000>, <132.300000, -133.700000, -1.000000>, <135.800000, -134.500000, -1.000000>, <139.300000, -135.350000, -1.000000>, 
      <128.225000, -129.300000, 0.000000>, <132.950000, -130.750000, 0.000000>, <136.450000, -131.550000, 0.000000>, <139.950000, -132.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <128.225000, -129.300000, 0.000000>, <132.950000, -130.750000, 0.000000>, <136.450000, -131.550000, 0.000000>, <139.950000, -132.400000, 0.000000>, 
      <128.900000, -126.350000, 1.000000>, <133.600000, -127.800000, 1.000000>, <137.100000, -128.600000, 1.000000>, <140.600000, -129.450000, 1.000000>, 
      <129.000000, -126.150000, -1.000000>, <133.700000, -127.600000, -1.000000>, <137.200000, -128.400000, -1.000000>, <140.700000, -129.250000, -1.000000>, 
      <129.675000, -123.200000, 0.000000>, <134.400000, -124.650000, 0.000000>, <137.900000, -125.450000, 0.000000>, <141.400000, -126.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <129.675000, -123.200000, 0.000000>, <134.400000, -124.650000, 0.000000>, <137.900000, -125.450000, 0.000000>, <141.400000, -126.300000, 0.000000>, 
      <130.350000, -120.250000, 1.000000>, <135.100000, -121.700000, 1.000000>, <138.600000, -122.500000, 1.000000>, <142.100000, -123.350000, 1.000000>, 
      <130.400000, -120.050000, -1.000000>, <135.100000, -121.500000, -1.000000>, <138.600000, -122.300000, -1.000000>, <142.100000, -123.100000, -1.000000>, 
      <131.100000, -117.100000, 0.000000>, <135.800000, -118.550000, 0.000000>, <139.300000, -119.350000, 0.000000>, <142.800000, -120.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <131.100000, -117.100000, 0.000000>, <135.800000, -118.550000, 0.000000>, <139.300000, -119.350000, 0.000000>, <142.800000, -120.150000, 0.000000>, 
      <131.800000, -114.150000, 1.000000>, <136.500000, -115.600000, 1.000000>, <140.000000, -116.400000, 1.000000>, <143.500000, -117.200000, 1.000000>, 
      <131.800000, -113.950000, -1.000000>, <136.500000, -115.400000, -1.000000>, <140.000000, -116.200000, -1.000000>, <143.500000, -117.000000, -1.000000>, 
      <133.100000, -111.325000, 0.000000>, <137.200000, -112.450000, 0.000000>, <140.700000, -113.250000, 0.000000>, <144.200000, -114.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <133.100000, -111.325000, 0.000000>, <137.200000, -112.450000, 0.000000>, <140.700000, -113.250000, 0.000000>, <144.200000, -114.050000, 0.000000>, 
      <134.400000, -108.700000, 1.000000>, <137.900000, -109.500000, 1.000000>, <141.400000, -110.300000, 1.000000>, <144.900000, -111.100000, 1.000000>, 
      <134.400000, -108.500000, -1.000000>, <137.900000, -109.300000, -1.000000>, <141.400000, -110.100000, -1.000000>, <144.900000, -110.900000, -1.000000>, 
      <135.100000, -105.550000, 0.000000>, <138.600000, -106.350000, 0.000000>, <142.100000, -107.150000, 0.000000>, <145.600000, -107.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <135.100000, -105.550000, 0.000000>, <138.600000, -106.350000, 0.000000>, <142.100000, -107.150000, 0.000000>, <145.600000, -107.950000, 0.000000>, 
      <135.800000, -102.600000, 1.000000>, <139.300000, -103.400000, 1.000000>, <142.800000, -104.200000, 1.000000>, <146.300000, -105.000000, 1.000000>, 
      <135.900000, -102.350000, -1.000000>, <139.400000, -103.200000, -1.000000>, <142.900000, -104.000000, -1.000000>, <146.350000, -104.800000, -1.000000>, 
      <136.550000, -99.400000, 0.000000>, <140.050000, -100.250000, 0.000000>, <143.550000, -101.050000, 0.000000>, <147.025000, -101.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <136.550000, -99.400000, 0.000000>, <140.050000, -100.250000, 0.000000>, <143.550000, -101.050000, 0.000000>, <147.025000, -101.850000, 0.000000>, 
      <137.200000, -96.450000, 1.000000>, <140.700000, -97.300000, 1.000000>, <144.200000, -98.100000, 1.000000>, <147.700000, -98.900000, 1.000000>, 
      <137.300000, -96.250000, -1.000000>, <140.800000, -97.100000, -1.000000>, <144.300000, -97.900000, -1.000000>, <147.800000, -98.700000, -1.000000>, 
      <138.000000, -93.300000, 0.000000>, <141.500000, -94.150000, 0.000000>, <145.000000, -94.950000, 0.000000>, <148.500000, -95.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <138.000000, -93.300000, 0.000000>, <141.500000, -94.150000, 0.000000>, <145.000000, -94.950000, 0.000000>, <148.500000, -95.750000, 0.000000>, 
      <138.700000, -90.350000, 1.000000>, <142.200000, -91.200000, 1.000000>, <145.700000, -92.000000, 1.000000>, <149.200000, -92.800000, 1.000000>, 
      <138.700000, -90.150000, -1.000000>, <142.200000, -91.000000, -1.000000>, <145.700000, -91.800000, -1.000000>, <149.200000, -92.600000, -1.000000>, 
      <139.400000, -87.200000, 0.000000>, <142.900000, -88.050000, 0.000000>, <146.400000, -88.850000, 0.000000>, <149.900000, -89.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <139.400000, -87.200000, 0.000000>, <142.900000, -88.050000, 0.000000>, <146.400000, -88.850000, 0.000000>, <149.900000, -89.650000, 0.000000>, 
      <140.100000, -84.250000, 1.000000>, <143.600000, -85.100000, 1.000000>, <147.100000, -85.900000, 1.000000>, <150.600000, -86.700000, 1.000000>, 
      <140.100000, -84.000000, -1.000000>, <143.600000, -84.800000, -1.000000>, <147.100000, -85.700000, -1.000000>, <150.600000, -86.500000, -1.000000>, 
      <140.800000, -81.050000, 0.000000>, <144.300000, -81.850000, 0.000000>, <147.800000, -82.750000, 0.000000>, <151.300000, -83.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <140.800000, -81.050000, 0.000000>, <144.300000, -81.850000, 0.000000>, <147.800000, -82.750000, 0.000000>, <151.300000, -83.550000, 0.000000>, 
      <141.500000, -78.100000, 1.000000>, <145.000000, -78.900000, 1.000000>, <148.500000, -79.800000, 1.000000>, <152.000000, -80.600000, 1.000000>, 
      <141.500000, -77.900000, -1.000000>, <145.000000, -78.700000, -1.000000>, <148.500000, -79.500000, -1.000000>, <152.000000, -80.350000, -1.000000>, 
      <142.200000, -74.950000, 0.000000>, <145.700000, -75.750000, 0.000000>, <149.200000, -76.550000, 0.000000>, <152.700000, -77.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <142.200000, -74.950000, 0.000000>, <145.700000, -75.750000, 0.000000>, <149.200000, -76.550000, 0.000000>, <152.700000, -77.400000, 0.000000>, 
      <142.900000, -72.000000, 1.000000>, <146.400000, -72.800000, 1.000000>, <149.900000, -73.600000, 1.000000>, <153.400000, -74.450000, 1.000000>, 
      <142.900000, -71.800000, -1.000000>, <146.400000, -72.600000, -1.000000>, <149.900000, -73.400000, -1.000000>, <153.400000, -74.250000, -1.000000>, 
      <143.600000, -68.850000, 0.000000>, <147.100000, -69.650000, 0.000000>, <150.600000, -70.450000, 0.000000>, <154.100000, -71.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <143.600000, -68.850000, 0.000000>, <147.100000, -69.650000, 0.000000>, <150.600000, -70.450000, 0.000000>, <154.100000, -71.300000, 0.000000>, 
      <144.300000, -65.900000, 1.000000>, <147.800000, -66.700000, 1.000000>, <151.300000, -67.500000, 1.000000>, <154.800000, -68.350000, 1.000000>, 
      <144.400000, -65.700000, -1.000000>, <147.900000, -66.500000, -1.000000>, <151.400000, -67.300000, -1.000000>, <154.900000, -68.100000, -1.000000>, 
      <145.050000, -62.750000, 0.000000>, <148.550000, -63.550000, 0.000000>, <152.050000, -64.350000, 0.000000>, <155.550000, -65.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <145.050000, -62.750000, 0.000000>, <148.550000, -63.550000, 0.000000>, <152.050000, -64.350000, 0.000000>, <155.550000, -65.150000, 0.000000>, 
      <145.700000, -59.800000, 1.000000>, <149.200000, -60.600000, 1.000000>, <152.700000, -61.400000, 1.000000>, <156.200000, -62.200000, 1.000000>, 
      <145.800000, -59.600000, -1.000000>, <149.300000, -60.400000, -1.000000>, <152.800000, -61.200000, -1.000000>, <156.300000, -62.000000, -1.000000>, 
      <146.500000, -56.650000, 0.000000>, <150.000000, -57.450000, 0.000000>, <153.500000, -58.250000, 0.000000>, <157.000000, -59.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <146.500000, -56.650000, 0.000000>, <150.000000, -57.450000, 0.000000>, <153.500000, -58.250000, 0.000000>, <157.000000, -59.050000, 0.000000>, 
      <147.200000, -53.700000, 1.000000>, <150.700000, -54.500000, 1.000000>, <154.200000, -55.300000, 1.000000>, <157.700000, -56.100000, 1.000000>, 
      <147.200000, -53.500000, -1.000000>, <150.700000, -54.300000, -1.000000>, <154.200000, -55.100000, -1.000000>, <157.700000, -55.900000, -1.000000>, 
      <147.900000, -50.550000, 0.000000>, <151.400000, -51.350000, 0.000000>, <154.900000, -52.150000, 0.000000>, <158.400000, -52.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <147.900000, -50.550000, 0.000000>, <151.400000, -51.350000, 0.000000>, <154.900000, -52.150000, 0.000000>, <158.400000, -52.950000, 0.000000>, 
      <148.600000, -47.600000, 1.000000>, <152.100000, -48.400000, 1.000000>, <155.600000, -49.200000, 1.000000>, <159.100000, -50.000000, 1.000000>, 
      <148.600000, -47.400000, -1.000000>, <152.100000, -48.200000, -1.000000>, <155.600000, -49.000000, -1.000000>, <159.100000, -49.800000, -1.000000>, 
      <148.250000, -44.300000, 0.000000>, <152.800000, -45.250000, 0.000000>, <156.300000, -46.050000, 0.000000>, <159.800000, -46.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <148.250000, -44.300000, 0.000000>, <152.800000, -45.250000, 0.000000>, <156.300000, -46.050000, 0.000000>, <159.800000, -46.850000, 0.000000>, 
      <147.900000, -41.200000, 1.000000>, <153.500000, -42.300000, 1.000000>, <157.000000, -43.100000, 1.000000>, <160.500000, -43.900000, 1.000000>, 
      <147.900000, -41.000000, -1.000000>, <153.500000, -42.100000, -1.000000>, <157.000000, -42.900000, -1.000000>, <160.500000, -43.700000, -1.000000>, 
      <147.075000, -37.950000, 0.000000>, <154.200000, -39.150000, 0.000000>, <157.700000, -39.950000, 0.000000>, <161.200000, -40.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <147.075000, -37.950000, 0.000000>, <154.200000, -39.150000, 0.000000>, <157.700000, -39.950000, 0.000000>, <161.200000, -40.750000, 0.000000>, 
      <146.250000, -34.900000, 1.000000>, <154.900000, -36.200000, 1.000000>, <158.400000, -37.000000, 1.000000>, <161.900000, -37.800000, 1.000000>, 
      <146.300000, -34.700000, -1.000000>, <155.000000, -36.000000, -1.000000>, <158.500000, -36.800000, -1.000000>, <162.000000, -37.600000, -1.000000>, 
      <146.975000, -31.750000, 0.000000>, <155.650000, -33.050000, 0.000000>, <159.150000, -33.850000, 0.000000>, <162.650000, -34.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <146.975000, -31.750000, 0.000000>, <155.650000, -33.050000, 0.000000>, <159.150000, -33.850000, 0.000000>, <162.650000, -34.650000, 0.000000>, 
      <147.650000, -28.800000, 1.000000>, <156.300000, -30.100000, 1.000000>, <159.800000, -30.900000, 1.000000>, <163.300000, -31.700000, 1.000000>, 
      <147.750000, -28.550000, -1.000000>, <156.400000, -29.800000, -1.000000>, <159.900000, -30.700000, -1.000000>, <163.400000, -31.500000, -1.000000>, 
      <148.200000, -25.525000, 0.000000>, <157.100000, -26.850000, 0.000000>, <160.600000, -27.750000, 0.000000>, <164.100000, -28.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <148.200000, -25.525000, 0.000000>, <157.100000, -26.850000, 0.000000>, <160.600000, -27.750000, 0.000000>, <164.100000, -28.550000, 0.000000>, 
      <148.650000, -22.500000, 1.000000>, <157.800000, -23.900000, 1.000000>, <161.300000, -24.800000, 1.000000>, <164.800000, -25.600000, 1.000000>, 
      <148.700000, -22.300000, -1.000000>, <157.800000, -23.700000, -1.000000>, <161.300000, -24.600000, -1.000000>, <164.800000, -25.400000, -1.000000>, 
      <149.400000, -19.200000, 0.000000>, <158.500000, -20.750000, 0.000000>, <162.000000, -21.600000, 0.000000>, <165.500000, -22.425000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <149.400000, -19.200000, 0.000000>, <158.500000, -20.750000, 0.000000>, <162.000000, -21.600000, 0.000000>, <165.500000, -22.425000, 0.000000>, 
      <150.100000, -16.100000, 1.000000>, <159.200000, -17.800000, 1.000000>, <162.700000, -18.600000, 1.000000>, <166.200000, -19.450000, 1.000000>, 
      <150.100000, -15.900000, -1.000000>, <159.200000, -17.600000, -1.000000>, <162.700000, -18.400000, -1.000000>, <166.200000, -19.250000, -1.000000>, 
      <151.200000, -13.175000, 0.000000>, <159.900000, -14.650000, 0.000000>, <163.400000, -15.450000, 0.000000>, <166.900000, -16.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <151.200000, -13.175000, 0.000000>, <159.900000, -14.650000, 0.000000>, <163.400000, -15.450000, 0.000000>, <166.900000, -16.300000, 0.000000>, 
      <152.300000, -10.450000, 1.000000>, <160.600000, -11.700000, 1.000000>, <164.100000, -12.500000, 1.000000>, <167.600000, -13.350000, 1.000000>, 
      <152.300000, -10.250000, -1.000000>, <160.600000, -11.500000, -1.000000>, <164.100000, -12.300000, -1.000000>, <167.600000, -13.150000, -1.000000>, 
      <152.650000, -7.650000, 0.000000>, <161.300000, -8.550000, 0.000000>, <164.800000, -9.350000, 0.000000>, <168.300000, -10.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <152.650000, -7.650000, 0.000000>, <161.300000, -8.550000, 0.000000>, <164.800000, -9.350000, 0.000000>, <168.300000, -10.200000, 0.000000>, 
      <153.000000, -5.050000, 1.000000>, <162.000000, -5.600000, 1.000000>, <165.500000, -6.400000, 1.000000>, <169.000000, -7.250000, 1.000000>, 
      <153.000000, -4.850000, -1.000000>, <162.000000, -5.400000, -1.000000>, <165.500000, -6.200000, -1.000000>, <169.000000, -7.000000, -1.000000>, 
      <153.925000, -2.400000, 0.000000>, <162.700000, -2.450000, 0.000000>, <166.200000, -3.250000, 0.000000>, <169.700000, -4.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <153.925000, -2.400000, 0.000000>, <162.700000, -2.450000, 0.000000>, <166.200000, -3.250000, 0.000000>, <169.700000, -4.050000, 0.000000>, 
      <154.850000, 0.050000, 1.000000>, <163.400000, 0.500000, 1.000000>, <166.900000, -0.300000, 1.000000>, <170.400000, -1.100000, 1.000000>, 
      <154.900000, 0.250000, -1.000000>, <163.500000, 0.700000, -1.000000>, <167.000000, -0.100000, -1.000000>, <170.500000, -0.900000, -1.000000>, 
      <155.050000, 2.850000, 0.000000>, <164.150000, 3.650000, 0.000000>, <167.650000, 2.850000, 0.000000>, <171.150000, 2.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <155.050000, 2.850000, 0.000000>, <164.150000, 3.650000, 0.000000>, <167.650000, 2.850000, 0.000000>, <171.150000, 2.050000, 0.000000>, 
      <155.200000, 5.450000, 1.000000>, <164.800000, 6.600000, 1.000000>, <168.300000, 5.800000, 1.000000>, <171.800000, 5.000000, 1.000000>, 
      <155.250000, 5.650000, -1.000000>, <164.900000, 6.800000, -1.000000>, <168.400000, 6.000000, -1.000000>, <171.900000, 5.200000, -1.000000>, 
      <155.950000, 8.600000, 0.000000>, <165.600000, 9.750000, 0.000000>, <169.100000, 8.950000, 0.000000>, <172.600000, 8.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <155.950000, 8.600000, 0.000000>, <165.600000, 9.750000, 0.000000>, <169.100000, 8.950000, 0.000000>, <172.600000, 8.150000, 0.000000>, 
      <156.650000, 11.550000, 1.000000>, <166.300000, 12.700000, 1.000000>, <169.800000, 11.900000, 1.000000>, <173.300000, 11.100000, 1.000000>, 
      <156.700000, 11.750000, -1.000000>, <166.300000, 12.900000, -1.000000>, <169.800000, 12.100000, -1.000000>, <173.300000, 11.300000, -1.000000>, 
      <157.550000, 15.550000, 0.700000>, <167.200000, 16.700000, 0.700000>, <170.700000, 15.900000, 0.700000>, <174.200000, 15.100000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <130.000000, -169.350000, -1.000000>, <134.700000, -170.800000, -1.000000>, <138.200000, -171.600000, -1.000000>, <141.700000, -172.400000, -1.000000>, 
      <130.900000, -165.450000, 1.000000>, <135.600000, -166.900000, 1.000000>, <139.100000, -167.700000, 1.000000>, <142.600000, -168.550000, 1.000000>, 
      <130.950000, -165.250000, -1.000000>, <135.700000, -166.700000, -1.000000>, <139.200000, -167.500000, -1.000000>, <142.700000, -168.350000, -1.000000>, 
      <131.650000, -162.300000, 0.000000>, <136.400000, -163.750000, 0.000000>, <139.900000, -164.550000, 0.000000>, <143.400000, -165.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <131.650000, -162.300000, 0.000000>, <136.400000, -163.750000, 0.000000>, <139.900000, -164.550000, 0.000000>, <143.400000, -165.400000, 0.000000>, 
      <132.350000, -159.350000, 1.000000>, <137.100000, -160.800000, 1.000000>, <140.600000, -161.600000, 1.000000>, <144.100000, -162.450000, 1.000000>, 
      <132.400000, -159.150000, -1.000000>, <137.100000, -160.600000, -1.000000>, <140.600000, -161.400000, -1.000000>, <144.100000, -162.200000, -1.000000>, 
      <133.700000, -156.525000, 0.000000>, <137.800000, -157.650000, 0.000000>, <141.300000, -158.450000, 0.000000>, <144.800000, -159.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <133.700000, -156.525000, 0.000000>, <137.800000, -157.650000, 0.000000>, <141.300000, -158.450000, 0.000000>, <144.800000, -159.250000, 0.000000>, 
      <135.000000, -153.900000, 1.000000>, <138.500000, -154.700000, 1.000000>, <142.000000, -155.500000, 1.000000>, <145.500000, -156.300000, 1.000000>, 
      <135.000000, -153.700000, -1.000000>, <138.500000, -154.500000, -1.000000>, <142.000000, -155.300000, -1.000000>, <145.500000, -156.100000, -1.000000>, 
      <135.700000, -150.750000, 0.000000>, <139.200000, -151.550000, 0.000000>, <142.700000, -152.350000, 0.000000>, <146.200000, -153.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <135.700000, -150.750000, 0.000000>, <139.200000, -151.550000, 0.000000>, <142.700000, -152.350000, 0.000000>, <146.200000, -153.150000, 0.000000>, 
      <136.400000, -147.800000, 1.000000>, <139.900000, -148.600000, 1.000000>, <143.400000, -149.400000, 1.000000>, <146.900000, -150.200000, 1.000000>, 
      <136.400000, -147.600000, -1.000000>, <139.900000, -148.400000, -1.000000>, <143.400000, -149.200000, -1.000000>, <146.900000, -150.000000, -1.000000>, 
      <137.100000, -144.650000, 0.000000>, <140.600000, -145.450000, 0.000000>, <144.100000, -146.250000, 0.000000>, <147.600000, -147.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <137.100000, -144.650000, 0.000000>, <140.600000, -145.450000, 0.000000>, <144.100000, -146.250000, 0.000000>, <147.600000, -147.050000, 0.000000>, 
      <137.800000, -141.700000, 1.000000>, <141.300000, -142.500000, 1.000000>, <144.800000, -143.300000, 1.000000>, <148.300000, -144.100000, 1.000000>, 
      <137.800000, -141.450000, -1.000000>, <141.300000, -142.300000, -1.000000>, <144.800000, -143.100000, -1.000000>, <148.300000, -143.900000, -1.000000>, 
      <138.500000, -138.500000, 0.000000>, <142.000000, -139.350000, 0.000000>, <145.500000, -140.150000, 0.000000>, <149.000000, -140.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <138.500000, -138.500000, 0.000000>, <142.000000, -139.350000, 0.000000>, <145.500000, -140.150000, 0.000000>, <149.000000, -140.950000, 0.000000>, 
      <139.200000, -135.550000, 1.000000>, <142.700000, -136.400000, 1.000000>, <146.200000, -137.200000, 1.000000>, <149.700000, -138.000000, 1.000000>, 
      <139.300000, -135.350000, -1.000000>, <142.800000, -136.200000, -1.000000>, <146.300000, -137.000000, -1.000000>, <149.800000, -137.800000, -1.000000>, 
      <139.950000, -132.400000, 0.000000>, <143.450000, -133.250000, 0.000000>, <146.950000, -134.050000, 0.000000>, <150.450000, -134.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <139.950000, -132.400000, 0.000000>, <143.450000, -133.250000, 0.000000>, <146.950000, -134.050000, 0.000000>, <150.450000, -134.850000, 0.000000>, 
      <140.600000, -129.450000, 1.000000>, <144.100000, -130.300000, 1.000000>, <147.600000, -131.100000, 1.000000>, <151.100000, -131.900000, 1.000000>, 
      <140.700000, -129.250000, -1.000000>, <144.200000, -130.100000, -1.000000>, <147.700000, -130.900000, -1.000000>, <151.200000, -131.700000, -1.000000>, 
      <141.400000, -126.300000, 0.000000>, <144.900000, -127.150000, 0.000000>, <148.400000, -127.950000, 0.000000>, <151.900000, -128.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <141.400000, -126.300000, 0.000000>, <144.900000, -127.150000, 0.000000>, <148.400000, -127.950000, 0.000000>, <151.900000, -128.750000, 0.000000>, 
      <142.100000, -123.350000, 1.000000>, <145.600000, -124.200000, 1.000000>, <149.100000, -125.000000, 1.000000>, <152.600000, -125.800000, 1.000000>, 
      <142.100000, -123.100000, -1.000000>, <145.600000, -123.900000, -1.000000>, <149.100000, -124.800000, -1.000000>, <152.600000, -125.600000, -1.000000>, 
      <142.800000, -120.150000, 0.000000>, <146.300000, -120.950000, 0.000000>, <149.800000, -121.850000, 0.000000>, <153.300000, -122.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <142.800000, -120.150000, 0.000000>, <146.300000, -120.950000, 0.000000>, <149.800000, -121.850000, 0.000000>, <153.300000, -122.650000, 0.000000>, 
      <143.500000, -117.200000, 1.000000>, <147.000000, -118.000000, 1.000000>, <150.500000, -118.900000, 1.000000>, <154.000000, -119.700000, 1.000000>, 
      <143.500000, -117.000000, -1.000000>, <147.000000, -117.800000, -1.000000>, <150.500000, -118.600000, -1.000000>, <154.000000, -119.450000, -1.000000>, 
      <144.200000, -114.050000, 0.000000>, <147.700000, -114.850000, 0.000000>, <151.200000, -115.650000, 0.000000>, <154.700000, -116.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <144.200000, -114.050000, 0.000000>, <147.700000, -114.850000, 0.000000>, <151.200000, -115.650000, 0.000000>, <154.700000, -116.500000, 0.000000>, 
      <144.900000, -111.100000, 1.000000>, <148.400000, -111.900000, 1.000000>, <151.900000, -112.700000, 1.000000>, <155.400000, -113.550000, 1.000000>, 
      <144.900000, -110.900000, -1.000000>, <148.400000, -111.700000, -1.000000>, <151.900000, -112.500000, -1.000000>, <155.400000, -113.350000, -1.000000>, 
      <145.600000, -107.950000, 0.000000>, <149.100000, -108.750000, 0.000000>, <152.600000, -109.550000, 0.000000>, <156.100000, -110.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <145.600000, -107.950000, 0.000000>, <149.100000, -108.750000, 0.000000>, <152.600000, -109.550000, 0.000000>, <156.100000, -110.400000, 0.000000>, 
      <146.300000, -105.000000, 1.000000>, <149.800000, -105.800000, 1.000000>, <153.300000, -106.600000, 1.000000>, <156.800000, -107.450000, 1.000000>, 
      <146.350000, -104.800000, -1.000000>, <149.800000, -105.600000, -1.000000>, <153.300000, -106.400000, -1.000000>, <156.800000, -107.200000, -1.000000>, 
      <147.025000, -101.850000, 0.000000>, <150.500000, -102.650000, 0.000000>, <154.000000, -103.450000, 0.000000>, <157.500000, -104.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <147.025000, -101.850000, 0.000000>, <150.500000, -102.650000, 0.000000>, <154.000000, -103.450000, 0.000000>, <157.500000, -104.250000, 0.000000>, 
      <147.700000, -98.900000, 1.000000>, <151.200000, -99.700000, 1.000000>, <154.700000, -100.500000, 1.000000>, <158.200000, -101.300000, 1.000000>, 
      <147.800000, -98.700000, -1.000000>, <151.300000, -99.500000, -1.000000>, <154.800000, -100.300000, -1.000000>, <158.300000, -101.100000, -1.000000>, 
      <148.500000, -95.750000, 0.000000>, <152.000000, -96.550000, 0.000000>, <155.500000, -97.350000, 0.000000>, <159.000000, -98.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <148.500000, -95.750000, 0.000000>, <152.000000, -96.550000, 0.000000>, <155.500000, -97.350000, 0.000000>, <159.000000, -98.150000, 0.000000>, 
      <149.200000, -92.800000, 1.000000>, <152.700000, -93.600000, 1.000000>, <156.200000, -94.400000, 1.000000>, <159.700000, -95.200000, 1.000000>, 
      <149.200000, -92.600000, -1.000000>, <152.700000, -93.400000, -1.000000>, <156.200000, -94.200000, -1.000000>, <159.700000, -95.000000, -1.000000>, 
      <149.900000, -89.650000, 0.000000>, <153.400000, -90.450000, 0.000000>, <156.900000, -91.250000, 0.000000>, <160.400000, -92.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <149.900000, -89.650000, 0.000000>, <153.400000, -90.450000, 0.000000>, <156.900000, -91.250000, 0.000000>, <160.400000, -92.050000, 0.000000>, 
      <150.600000, -86.700000, 1.000000>, <154.100000, -87.500000, 1.000000>, <157.600000, -88.300000, 1.000000>, <161.100000, -89.100000, 1.000000>, 
      <150.600000, -86.500000, -1.000000>, <154.100000, -87.300000, -1.000000>, <157.600000, -88.100000, -1.000000>, <161.100000, -88.900000, -1.000000>, 
      <151.300000, -83.550000, 0.000000>, <154.800000, -84.350000, 0.000000>, <158.300000, -85.150000, 0.000000>, <161.800000, -85.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <151.300000, -83.550000, 0.000000>, <154.800000, -84.350000, 0.000000>, <158.300000, -85.150000, 0.000000>, <161.800000, -85.950000, 0.000000>, 
      <152.000000, -80.600000, 1.000000>, <155.500000, -81.400000, 1.000000>, <159.000000, -82.200000, 1.000000>, <162.500000, -83.000000, 1.000000>, 
      <152.000000, -80.350000, -1.000000>, <155.500000, -81.200000, -1.000000>, <159.000000, -82.000000, -1.000000>, <162.500000, -82.800000, -1.000000>, 
      <152.700000, -77.400000, 0.000000>, <156.200000, -78.250000, 0.000000>, <159.700000, -79.050000, 0.000000>, <163.200000, -79.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <152.700000, -77.400000, 0.000000>, <156.200000, -78.250000, 0.000000>, <159.700000, -79.050000, 0.000000>, <163.200000, -79.850000, 0.000000>, 
      <153.400000, -74.450000, 1.000000>, <156.900000, -75.300000, 1.000000>, <160.400000, -76.100000, 1.000000>, <163.900000, -76.900000, 1.000000>, 
      <153.400000, -74.250000, -1.000000>, <156.900000, -75.100000, -1.000000>, <160.400000, -75.900000, -1.000000>, <163.900000, -76.700000, -1.000000>, 
      <154.100000, -71.300000, 0.000000>, <157.600000, -72.150000, 0.000000>, <161.100000, -72.950000, 0.000000>, <164.600000, -73.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <154.100000, -71.300000, 0.000000>, <157.600000, -72.150000, 0.000000>, <161.100000, -72.950000, 0.000000>, <164.600000, -73.750000, 0.000000>, 
      <154.800000, -68.350000, 1.000000>, <158.300000, -69.200000, 1.000000>, <161.800000, -70.000000, 1.000000>, <165.300000, -70.800000, 1.000000>, 
      <154.900000, -68.100000, -1.000000>, <158.400000, -68.900000, -1.000000>, <161.900000, -69.800000, -1.000000>, <165.400000, -70.600000, -1.000000>, 
      <155.550000, -65.150000, 0.000000>, <159.050000, -65.950000, 0.000000>, <162.550000, -66.850000, 0.000000>, <166.050000, -67.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <155.550000, -65.150000, 0.000000>, <159.050000, -65.950000, 0.000000>, <162.550000, -66.850000, 0.000000>, <166.050000, -67.650000, 0.000000>, 
      <156.200000, -62.200000, 1.000000>, <159.700000, -63.000000, 1.000000>, <163.200000, -63.900000, 1.000000>, <166.700000, -64.700000, 1.000000>, 
      <156.300000, -62.000000, -1.000000>, <159.800000, -62.800000, -1.000000>, <163.300000, -63.600000, -1.000000>, <166.800000, -64.450000, -1.000000>, 
      <157.000000, -59.050000, 0.000000>, <160.500000, -59.850000, 0.000000>, <164.000000, -60.650000, 0.000000>, <167.500000, -61.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <157.000000, -59.050000, 0.000000>, <160.500000, -59.850000, 0.000000>, <164.000000, -60.650000, 0.000000>, <167.500000, -61.500000, 0.000000>, 
      <157.700000, -56.100000, 1.000000>, <161.200000, -56.900000, 1.000000>, <164.700000, -57.700000, 1.000000>, <168.200000, -58.550000, 1.000000>, 
      <157.700000, -55.900000, -1.000000>, <161.200000, -56.700000, -1.000000>, <164.700000, -57.500000, -1.000000>, <168.200000, -58.350000, -1.000000>, 
      <158.400000, -52.950000, 0.000000>, <161.900000, -53.750000, 0.000000>, <165.400000, -54.550000, 0.000000>, <168.900000, -55.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <158.400000, -52.950000, 0.000000>, <161.900000, -53.750000, 0.000000>, <165.400000, -54.550000, 0.000000>, <168.900000, -55.400000, 0.000000>, 
      <159.100000, -50.000000, 1.000000>, <162.600000, -50.800000, 1.000000>, <166.100000, -51.600000, 1.000000>, <169.600000, -52.450000, 1.000000>, 
      <159.100000, -49.800000, -1.000000>, <162.600000, -50.600000, -1.000000>, <166.100000, -51.400000, -1.000000>, <169.600000, -52.250000, -1.000000>, 
      <159.800000, -46.850000, 0.000000>, <163.300000, -47.650000, 0.000000>, <166.800000, -48.450000, 0.000000>, <170.300000, -49.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <159.800000, -46.850000, 0.000000>, <163.300000, -47.650000, 0.000000>, <166.800000, -48.450000, 0.000000>, <170.300000, -49.300000, 0.000000>, 
      <160.500000, -43.900000, 1.000000>, <164.000000, -44.700000, 1.000000>, <167.500000, -45.500000, 1.000000>, <171.000000, -46.350000, 1.000000>, 
      <160.500000, -43.700000, -1.000000>, <164.000000, -44.500000, -1.000000>, <167.500000, -45.300000, -1.000000>, <171.000000, -46.100000, -1.000000>, 
      <161.200000, -40.750000, 0.000000>, <164.700000, -41.550000, 0.000000>, <168.200000, -42.350000, 0.000000>, <171.700000, -43.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <161.200000, -40.750000, 0.000000>, <164.700000, -41.550000, 0.000000>, <168.200000, -42.350000, 0.000000>, <171.700000, -43.150000, 0.000000>, 
      <161.900000, -37.800000, 1.000000>, <165.400000, -38.600000, 1.000000>, <168.900000, -39.400000, 1.000000>, <172.400000, -40.200000, 1.000000>, 
      <162.000000, -37.600000, -1.000000>, <165.500000, -38.400000, -1.000000>, <169.000000, -39.200000, -1.000000>, <172.500000, -40.000000, -1.000000>, 
      <162.650000, -34.650000, 0.000000>, <166.150000, -35.450000, 0.000000>, <169.650000, -36.250000, 0.000000>, <173.150000, -37.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <162.650000, -34.650000, 0.000000>, <166.150000, -35.450000, 0.000000>, <169.650000, -36.250000, 0.000000>, <173.150000, -37.050000, 0.000000>, 
      <163.300000, -31.700000, 1.000000>, <166.800000, -32.500000, 1.000000>, <170.300000, -33.300000, 1.000000>, <173.800000, -34.100000, 1.000000>, 
      <163.400000, -31.500000, -1.000000>, <166.900000, -32.300000, -1.000000>, <170.400000, -33.100000, -1.000000>, <173.900000, -33.900000, -1.000000>, 
      <164.100000, -28.550000, 0.000000>, <167.600000, -29.350000, 0.000000>, <171.100000, -30.150000, 0.000000>, <174.600000, -30.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <164.100000, -28.550000, 0.000000>, <167.600000, -29.350000, 0.000000>, <171.100000, -30.150000, 0.000000>, <174.600000, -30.950000, 0.000000>, 
      <164.800000, -25.600000, 1.000000>, <168.300000, -26.400000, 1.000000>, <171.800000, -27.200000, 1.000000>, <175.300000, -28.000000, 1.000000>, 
      <164.800000, -25.400000, -1.000000>, <168.300000, -26.200000, -1.000000>, <171.800000, -27.000000, -1.000000>, <175.300000, -27.800000, -1.000000>, 
      <165.500000, -22.425000, 0.000000>, <169.000000, -23.250000, 0.000000>, <172.500000, -24.050000, 0.000000>, <176.000000, -24.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <165.500000, -22.425000, 0.000000>, <169.000000, -23.250000, 0.000000>, <172.500000, -24.050000, 0.000000>, <176.000000, -24.850000, 0.000000>, 
      <166.200000, -19.450000, 1.000000>, <169.700000, -20.300000, 1.000000>, <173.200000, -21.100000, 1.000000>, <176.700000, -21.900000, 1.000000>, 
      <166.200000, -19.250000, -1.000000>, <169.700000, -20.100000, -1.000000>, <173.200000, -20.900000, -1.000000>, <176.700000, -21.700000, -1.000000>, 
      <166.900000, -16.300000, 0.000000>, <170.400000, -17.150000, 0.000000>, <173.900000, -17.950000, 0.000000>, <177.400000, -18.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <166.900000, -16.300000, 0.000000>, <170.400000, -17.150000, 0.000000>, <173.900000, -17.950000, 0.000000>, <177.400000, -18.750000, 0.000000>, 
      <167.600000, -13.350000, 1.000000>, <171.100000, -14.200000, 1.000000>, <174.600000, -15.000000, 1.000000>, <178.100000, -15.800000, 1.000000>, 
      <167.600000, -13.150000, -1.000000>, <171.100000, -14.000000, -1.000000>, <174.600000, -14.800000, -1.000000>, <178.100000, -15.600000, -1.000000>, 
      <168.300000, -10.200000, 0.000000>, <171.800000, -11.050000, 0.000000>, <175.300000, -11.850000, 0.000000>, <178.800000, -12.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <168.300000, -10.200000, 0.000000>, <171.800000, -11.050000, 0.000000>, <175.300000, -11.850000, 0.000000>, <178.800000, -12.650000, 0.000000>, 
      <169.000000, -7.250000, 1.000000>, <172.500000, -8.100000, 1.000000>, <176.000000, -8.900000, 1.000000>, <179.500000, -9.700000, 1.000000>, 
      <169.000000, -7.000000, -1.000000>, <172.500000, -7.800000, -1.000000>, <176.000000, -8.700000, -1.000000>, <179.500000, -9.500000, -1.000000>, 
      <169.700000, -4.050000, 0.000000>, <173.200000, -4.850000, 0.000000>, <176.700000, -5.750000, 0.000000>, <180.200000, -6.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <169.700000, -4.050000, 0.000000>, <173.200000, -4.850000, 0.000000>, <176.700000, -5.750000, 0.000000>, <180.200000, -6.550000, 0.000000>, 
      <170.400000, -1.100000, 1.000000>, <173.900000, -1.900000, 1.000000>, <177.400000, -2.800000, 1.000000>, <180.900000, -3.600000, 1.000000>, 
      <170.500000, -0.900000, -1.000000>, <174.000000, -1.700000, -1.000000>, <177.500000, -2.500000, -1.000000>, <181.000000, -3.350000, -1.000000>, 
      <171.150000, 2.050000, 0.000000>, <174.650000, 1.250000, 0.000000>, <178.150000, 0.450000, 0.000000>, <181.650000, -0.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <171.150000, 2.050000, 0.000000>, <174.650000, 1.250000, 0.000000>, <178.150000, 0.450000, 0.000000>, <181.650000, -0.400000, 0.000000>, 
      <171.800000, 5.000000, 1.000000>, <175.300000, 4.200000, 1.000000>, <178.800000, 3.400000, 1.000000>, <182.300000, 2.550000, 1.000000>, 
      <171.900000, 5.200000, -1.000000>, <175.400000, 4.400000, -1.000000>, <178.900000, 3.600000, -1.000000>, <182.400000, 2.750000, -1.000000>, 
      <172.600000, 8.150000, 0.000000>, <176.100000, 7.350000, 0.000000>, <179.600000, 6.550000, 0.000000>, <183.100000, 5.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <172.600000, 8.150000, 0.000000>, <176.100000, 7.350000, 0.000000>, <179.600000, 6.550000, 0.000000>, <183.100000, 5.700000, 0.000000>, 
      <173.300000, 11.100000, 1.000000>, <176.800000, 10.300000, 1.000000>, <180.300000, 9.500000, 1.000000>, <183.800000, 8.650000, 1.000000>, 
      <173.300000, 11.300000, -1.000000>, <176.800000, 10.500000, -1.000000>, <180.300000, 9.700000, -1.000000>, <183.800000, 8.900000, -1.000000>, 
      <174.200000, 15.100000, 0.700000>, <177.700000, 14.300000, 0.700000>, <181.200000, 13.500000, 0.700000>, <184.700000, 12.650000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <141.700000, -172.400000, -1.000000>, <145.200000, -173.200000, -1.000000>, <148.700000, -174.000000, -1.000000>, <152.200000, -174.850000, -1.000000>, 
      <142.600000, -168.550000, 1.000000>, <146.100000, -169.400000, 1.000000>, <149.600000, -170.200000, 1.000000>, <153.100000, -171.000000, 1.000000>, 
      <142.700000, -168.350000, -1.000000>, <146.200000, -169.200000, -1.000000>, <149.700000, -170.000000, -1.000000>, <153.200000, -170.800000, -1.000000>, 
      <143.400000, -165.400000, 0.000000>, <146.900000, -166.250000, 0.000000>, <150.400000, -167.050000, 0.000000>, <153.900000, -167.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <143.400000, -165.400000, 0.000000>, <146.900000, -166.250000, 0.000000>, <150.400000, -167.050000, 0.000000>, <153.900000, -167.850000, 0.000000>, 
      <144.100000, -162.450000, 1.000000>, <147.600000, -163.300000, 1.000000>, <151.100000, -164.100000, 1.000000>, <154.600000, -164.900000, 1.000000>, 
      <144.100000, -162.200000, -1.000000>, <147.600000, -163.000000, -1.000000>, <151.100000, -163.900000, -1.000000>, <154.600000, -164.700000, -1.000000>, 
      <144.800000, -159.250000, 0.000000>, <148.300000, -160.050000, 0.000000>, <151.800000, -160.950000, 0.000000>, <155.300000, -161.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <144.800000, -159.250000, 0.000000>, <148.300000, -160.050000, 0.000000>, <151.800000, -160.950000, 0.000000>, <155.300000, -161.750000, 0.000000>, 
      <145.500000, -156.300000, 1.000000>, <149.000000, -157.100000, 1.000000>, <152.500000, -158.000000, 1.000000>, <156.000000, -158.800000, 1.000000>, 
      <145.500000, -156.100000, -1.000000>, <149.000000, -156.900000, -1.000000>, <152.500000, -157.700000, -1.000000>, <156.000000, -158.550000, -1.000000>, 
      <146.200000, -153.150000, 0.000000>, <149.700000, -153.950000, 0.000000>, <153.200000, -154.750000, 0.000000>, <156.700000, -155.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <146.200000, -153.150000, 0.000000>, <149.700000, -153.950000, 0.000000>, <153.200000, -154.750000, 0.000000>, <156.700000, -155.600000, 0.000000>, 
      <146.900000, -150.200000, 1.000000>, <150.400000, -151.000000, 1.000000>, <153.900000, -151.800000, 1.000000>, <157.400000, -152.650000, 1.000000>, 
      <146.900000, -150.000000, -1.000000>, <150.400000, -150.800000, -1.000000>, <153.900000, -151.600000, -1.000000>, <157.400000, -152.450000, -1.000000>, 
      <147.600000, -147.050000, 0.000000>, <151.100000, -147.850000, 0.000000>, <154.600000, -148.650000, 0.000000>, <158.100000, -149.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <147.600000, -147.050000, 0.000000>, <151.100000, -147.850000, 0.000000>, <154.600000, -148.650000, 0.000000>, <158.100000, -149.500000, 0.000000>, 
      <148.300000, -144.100000, 1.000000>, <151.800000, -144.900000, 1.000000>, <155.300000, -145.700000, 1.000000>, <158.800000, -146.550000, 1.000000>, 
      <148.300000, -143.900000, -1.000000>, <151.800000, -144.700000, -1.000000>, <155.300000, -145.500000, -1.000000>, <158.800000, -146.300000, -1.000000>, 
      <149.000000, -140.950000, 0.000000>, <152.500000, -141.750000, 0.000000>, <156.000000, -142.550000, 0.000000>, <159.500000, -143.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <149.000000, -140.950000, 0.000000>, <152.500000, -141.750000, 0.000000>, <156.000000, -142.550000, 0.000000>, <159.500000, -143.350000, 0.000000>, 
      <149.700000, -138.000000, 1.000000>, <153.200000, -138.800000, 1.000000>, <156.700000, -139.600000, 1.000000>, <160.200000, -140.400000, 1.000000>, 
      <149.800000, -137.800000, -1.000000>, <153.300000, -138.600000, -1.000000>, <156.800000, -139.400000, -1.000000>, <160.300000, -140.200000, -1.000000>, 
      <150.450000, -134.850000, 0.000000>, <153.950000, -135.650000, 0.000000>, <157.450000, -136.450000, 0.000000>, <160.950000, -137.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <150.450000, -134.850000, 0.000000>, <153.950000, -135.650000, 0.000000>, <157.450000, -136.450000, 0.000000>, <160.950000, -137.250000, 0.000000>, 
      <151.100000, -131.900000, 1.000000>, <154.600000, -132.700000, 1.000000>, <158.100000, -133.500000, 1.000000>, <161.600000, -134.300000, 1.000000>, 
      <151.200000, -131.700000, -1.000000>, <154.700000, -132.500000, -1.000000>, <158.200000, -133.300000, -1.000000>, <161.700000, -134.100000, -1.000000>, 
      <151.900000, -128.750000, 0.000000>, <155.400000, -129.550000, 0.000000>, <158.900000, -130.350000, 0.000000>, <162.400000, -131.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <151.900000, -128.750000, 0.000000>, <155.400000, -129.550000, 0.000000>, <158.900000, -130.350000, 0.000000>, <162.400000, -131.150000, 0.000000>, 
      <152.600000, -125.800000, 1.000000>, <156.100000, -126.600000, 1.000000>, <159.600000, -127.400000, 1.000000>, <163.100000, -128.200000, 1.000000>, 
      <152.600000, -125.600000, -1.000000>, <156.100000, -126.400000, -1.000000>, <159.600000, -127.200000, -1.000000>, <163.100000, -128.000000, -1.000000>, 
      <153.300000, -122.650000, 0.000000>, <156.800000, -123.450000, 0.000000>, <160.300000, -124.250000, 0.000000>, <163.800000, -125.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <153.300000, -122.650000, 0.000000>, <156.800000, -123.450000, 0.000000>, <160.300000, -124.250000, 0.000000>, <163.800000, -125.050000, 0.000000>, 
      <154.000000, -119.700000, 1.000000>, <157.500000, -120.500000, 1.000000>, <161.000000, -121.300000, 1.000000>, <164.500000, -122.100000, 1.000000>, 
      <154.000000, -119.450000, -1.000000>, <157.500000, -120.300000, -1.000000>, <161.000000, -121.100000, -1.000000>, <164.500000, -121.900000, -1.000000>, 
      <154.700000, -116.500000, 0.000000>, <158.200000, -117.350000, 0.000000>, <161.700000, -118.150000, 0.000000>, <165.200000, -118.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <154.700000, -116.500000, 0.000000>, <158.200000, -117.350000, 0.000000>, <161.700000, -118.150000, 0.000000>, <165.200000, -118.950000, 0.000000>, 
      <155.400000, -113.550000, 1.000000>, <158.900000, -114.400000, 1.000000>, <162.400000, -115.200000, 1.000000>, <165.900000, -116.000000, 1.000000>, 
      <155.400000, -113.350000, -1.000000>, <158.900000, -114.200000, -1.000000>, <162.400000, -115.000000, -1.000000>, <165.900000, -115.800000, -1.000000>, 
      <156.100000, -110.400000, 0.000000>, <159.600000, -111.250000, 0.000000>, <163.100000, -112.050000, 0.000000>, <166.600000, -112.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <156.100000, -110.400000, 0.000000>, <159.600000, -111.250000, 0.000000>, <163.100000, -112.050000, 0.000000>, <166.600000, -112.850000, 0.000000>, 
      <156.800000, -107.450000, 1.000000>, <160.300000, -108.300000, 1.000000>, <163.800000, -109.100000, 1.000000>, <167.300000, -109.900000, 1.000000>, 
      <156.800000, -107.200000, -1.000000>, <160.300000, -108.000000, -1.000000>, <163.800000, -108.900000, -1.000000>, <167.300000, -109.700000, -1.000000>, 
      <157.500000, -104.250000, 0.000000>, <161.000000, -105.050000, 0.000000>, <164.500000, -105.950000, 0.000000>, <168.000000, -106.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <157.500000, -104.250000, 0.000000>, <161.000000, -105.050000, 0.000000>, <164.500000, -105.950000, 0.000000>, <168.000000, -106.750000, 0.000000>, 
      <158.200000, -101.300000, 1.000000>, <161.700000, -102.100000, 1.000000>, <165.200000, -103.000000, 1.000000>, <168.700000, -103.800000, 1.000000>, 
      <158.300000, -101.100000, -1.000000>, <161.800000, -101.900000, -1.000000>, <165.300000, -102.700000, -1.000000>, <168.800000, -103.550000, -1.000000>, 
      <159.000000, -98.150000, 0.000000>, <162.500000, -98.950000, 0.000000>, <166.000000, -99.750000, 0.000000>, <169.500000, -100.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <159.000000, -98.150000, 0.000000>, <162.500000, -98.950000, 0.000000>, <166.000000, -99.750000, 0.000000>, <169.500000, -100.600000, 0.000000>, 
      <159.700000, -95.200000, 1.000000>, <163.200000, -96.000000, 1.000000>, <166.700000, -96.800000, 1.000000>, <170.200000, -97.650000, 1.000000>, 
      <159.700000, -95.000000, -1.000000>, <163.200000, -95.800000, -1.000000>, <166.700000, -96.600000, -1.000000>, <170.200000, -97.450000, -1.000000>, 
      <160.400000, -92.050000, 0.000000>, <163.900000, -92.850000, 0.000000>, <167.400000, -93.650000, 0.000000>, <170.900000, -94.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <160.400000, -92.050000, 0.000000>, <163.900000, -92.850000, 0.000000>, <167.400000, -93.650000, 0.000000>, <170.900000, -94.500000, 0.000000>, 
      <161.100000, -89.100000, 1.000000>, <164.600000, -89.900000, 1.000000>, <168.100000, -90.700000, 1.000000>, <171.600000, -91.550000, 1.000000>, 
      <161.100000, -88.900000, -1.000000>, <164.600000, -89.700000, -1.000000>, <168.100000, -90.500000, -1.000000>, <171.600000, -91.350000, -1.000000>, 
      <161.800000, -85.950000, 0.000000>, <165.300000, -86.750000, 0.000000>, <168.800000, -87.550000, 0.000000>, <172.300000, -88.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <161.800000, -85.950000, 0.000000>, <165.300000, -86.750000, 0.000000>, <168.800000, -87.550000, 0.000000>, <172.300000, -88.400000, 0.000000>, 
      <162.500000, -83.000000, 1.000000>, <166.000000, -83.800000, 1.000000>, <169.500000, -84.600000, 1.000000>, <173.000000, -85.450000, 1.000000>, 
      <162.500000, -82.800000, -1.000000>, <166.000000, -83.600000, -1.000000>, <169.500000, -84.400000, -1.000000>, <173.000000, -85.200000, -1.000000>, 
      <163.200000, -79.850000, 0.000000>, <166.700000, -80.650000, 0.000000>, <170.200000, -81.450000, 0.000000>, <173.700000, -82.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <163.200000, -79.850000, 0.000000>, <166.700000, -80.650000, 0.000000>, <170.200000, -81.450000, 0.000000>, <173.700000, -82.250000, 0.000000>, 
      <163.900000, -76.900000, 1.000000>, <167.400000, -77.700000, 1.000000>, <170.900000, -78.500000, 1.000000>, <174.400000, -79.300000, 1.000000>, 
      <163.900000, -76.700000, -1.000000>, <167.400000, -77.500000, -1.000000>, <170.900000, -78.300000, -1.000000>, <174.400000, -79.100000, -1.000000>, 
      <164.600000, -73.750000, 0.000000>, <168.100000, -74.550000, 0.000000>, <171.600000, -75.350000, 0.000000>, <175.100000, -76.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <164.600000, -73.750000, 0.000000>, <168.100000, -74.550000, 0.000000>, <171.600000, -75.350000, 0.000000>, <175.100000, -76.150000, 0.000000>, 
      <165.300000, -70.800000, 1.000000>, <168.800000, -71.600000, 1.000000>, <172.300000, -72.400000, 1.000000>, <175.800000, -73.200000, 1.000000>, 
      <165.400000, -70.600000, -1.000000>, <168.900000, -71.400000, -1.000000>, <172.400000, -72.200000, -1.000000>, <175.900000, -73.000000, -1.000000>, 
      <166.050000, -67.650000, 0.000000>, <169.550000, -68.450000, 0.000000>, <173.050000, -69.250000, 0.000000>, <176.550000, -70.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <166.050000, -67.650000, 0.000000>, <169.550000, -68.450000, 0.000000>, <173.050000, -69.250000, 0.000000>, <176.550000, -70.050000, 0.000000>, 
      <166.700000, -64.700000, 1.000000>, <170.200000, -65.500000, 1.000000>, <173.700000, -66.300000, 1.000000>, <177.200000, -67.100000, 1.000000>, 
      <166.800000, -64.450000, -1.000000>, <170.300000, -65.300000, -1.000000>, <173.800000, -66.100000, -1.000000>, <177.300000, -66.900000, -1.000000>, 
      <167.500000, -61.500000, 0.000000>, <171.000000, -62.350000, 0.000000>, <174.500000, -63.150000, 0.000000>, <178.000000, -63.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <167.500000, -61.500000, 0.000000>, <171.000000, -62.350000, 0.000000>, <174.500000, -63.150000, 0.000000>, <178.000000, -63.950000, 0.000000>, 
      <168.200000, -58.550000, 1.000000>, <171.700000, -59.400000, 1.000000>, <175.200000, -60.200000, 1.000000>, <178.700000, -61.000000, 1.000000>, 
      <168.200000, -58.350000, -1.000000>, <171.700000, -59.200000, -1.000000>, <175.200000, -60.000000, -1.000000>, <178.700000, -60.800000, -1.000000>, 
      <168.900000, -55.400000, 0.000000>, <172.400000, -56.250000, 0.000000>, <175.900000, -57.050000, 0.000000>, <179.400000, -57.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <168.900000, -55.400000, 0.000000>, <172.400000, -56.250000, 0.000000>, <175.900000, -57.050000, 0.000000>, <179.400000, -57.850000, 0.000000>, 
      <169.600000, -52.450000, 1.000000>, <173.100000, -53.300000, 1.000000>, <176.600000, -54.100000, 1.000000>, <180.100000, -54.900000, 1.000000>, 
      <169.600000, -52.250000, -1.000000>, <173.100000, -53.100000, -1.000000>, <176.600000, -53.900000, -1.000000>, <180.100000, -54.700000, -1.000000>, 
      <170.300000, -49.300000, 0.000000>, <173.800000, -50.150000, 0.000000>, <177.300000, -50.950000, 0.000000>, <180.800000, -51.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <170.300000, -49.300000, 0.000000>, <173.800000, -50.150000, 0.000000>, <177.300000, -50.950000, 0.000000>, <180.800000, -51.750000, 0.000000>, 
      <171.000000, -46.350000, 1.000000>, <174.500000, -47.200000, 1.000000>, <178.000000, -48.000000, 1.000000>, <181.500000, -48.800000, 1.000000>, 
      <171.000000, -46.100000, -1.000000>, <174.500000, -46.900000, -1.000000>, <178.000000, -47.800000, -1.000000>, <181.500000, -48.600000, -1.000000>, 
      <171.700000, -43.150000, 0.000000>, <175.200000, -43.950000, 0.000000>, <178.700000, -44.850000, 0.000000>, <182.200000, -45.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <171.700000, -43.150000, 0.000000>, <175.200000, -43.950000, 0.000000>, <178.700000, -44.850000, 0.000000>, <182.200000, -45.650000, 0.000000>, 
      <172.400000, -40.200000, 1.000000>, <175.900000, -41.000000, 1.000000>, <179.400000, -41.900000, 1.000000>, <182.900000, -42.700000, 1.000000>, 
      <172.500000, -40.000000, -1.000000>, <176.000000, -40.800000, -1.000000>, <179.400000, -41.600000, -1.000000>, <182.900000, -42.450000, -1.000000>, 
      <173.150000, -37.050000, 0.000000>, <176.650000, -37.850000, 0.000000>, <180.100000, -38.650000, 0.000000>, <183.600000, -39.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <173.150000, -37.050000, 0.000000>, <176.650000, -37.850000, 0.000000>, <180.100000, -38.650000, 0.000000>, <183.600000, -39.500000, 0.000000>, 
      <173.800000, -34.100000, 1.000000>, <177.300000, -34.900000, 1.000000>, <180.800000, -35.700000, 1.000000>, <184.300000, -36.550000, 1.000000>, 
      <173.900000, -33.900000, -1.000000>, <177.400000, -34.700000, -1.000000>, <180.900000, -35.500000, -1.000000>, <184.400000, -36.350000, -1.000000>, 
      <174.600000, -30.950000, 0.000000>, <178.100000, -31.750000, 0.000000>, <181.600000, -32.550000, 0.000000>, <185.100000, -33.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <174.600000, -30.950000, 0.000000>, <178.100000, -31.750000, 0.000000>, <181.600000, -32.550000, 0.000000>, <185.100000, -33.400000, 0.000000>, 
      <175.300000, -28.000000, 1.000000>, <178.800000, -28.800000, 1.000000>, <182.300000, -29.600000, 1.000000>, <185.800000, -30.450000, 1.000000>, 
      <175.300000, -27.800000, -1.000000>, <178.800000, -28.600000, -1.000000>, <182.300000, -29.400000, -1.000000>, <185.800000, -30.200000, -1.000000>, 
      <176.000000, -24.850000, 0.000000>, <179.500000, -25.650000, 0.000000>, <183.000000, -26.450000, 0.000000>, <186.500000, -27.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <176.000000, -24.850000, 0.000000>, <179.500000, -25.650000, 0.000000>, <183.000000, -26.450000, 0.000000>, <186.500000, -27.250000, 0.000000>, 
      <176.700000, -21.900000, 1.000000>, <180.200000, -22.700000, 1.000000>, <183.700000, -23.500000, 1.000000>, <187.200000, -24.300000, 1.000000>, 
      <176.700000, -21.700000, -1.000000>, <180.200000, -22.500000, -1.000000>, <183.700000, -23.300000, -1.000000>, <187.200000, -24.100000, -1.000000>, 
      <177.400000, -18.750000, 0.000000>, <180.900000, -19.550000, 0.000000>, <184.400000, -20.350000, 0.000000>, <187.900000, -21.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <177.400000, -18.750000, 0.000000>, <180.900000, -19.550000, 0.000000>, <184.400000, -20.350000, 0.000000>, <187.900000, -21.150000, 0.000000>, 
      <178.100000, -15.800000, 1.000000>, <181.600000, -16.600000, 1.000000>, <185.100000, -17.400000, 1.000000>, <188.600000, -18.200000, 1.000000>, 
      <178.100000, -15.600000, -1.000000>, <181.600000, -16.400000, -1.000000>, <185.100000, -17.200000, -1.000000>, <188.600000, -18.000000, -1.000000>, 
      <178.800000, -12.650000, 0.000000>, <182.300000, -13.450000, 0.000000>, <185.800000, -14.250000, 0.000000>, <189.300000, -15.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <178.800000, -12.650000, 0.000000>, <182.300000, -13.450000, 0.000000>, <185.800000, -14.250000, 0.000000>, <189.300000, -15.050000, 0.000000>, 
      <179.500000, -9.700000, 1.000000>, <183.000000, -10.500000, 1.000000>, <186.500000, -11.300000, 1.000000>, <190.000000, -12.100000, 1.000000>, 
      <179.500000, -9.500000, -1.000000>, <183.000000, -10.300000, -1.000000>, <186.500000, -11.100000, -1.000000>, <190.000000, -11.900000, -1.000000>, 
      <180.200000, -6.550000, 0.000000>, <183.700000, -7.350000, 0.000000>, <187.200000, -8.150000, 0.000000>, <190.700000, -8.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <180.200000, -6.550000, 0.000000>, <183.700000, -7.350000, 0.000000>, <187.200000, -8.150000, 0.000000>, <190.700000, -8.950000, 0.000000>, 
      <180.900000, -3.600000, 1.000000>, <184.400000, -4.400000, 1.000000>, <187.900000, -5.200000, 1.000000>, <191.400000, -6.000000, 1.000000>, 
      <181.000000, -3.350000, -1.000000>, <184.500000, -4.200000, -1.000000>, <188.000000, -5.000000, -1.000000>, <191.500000, -5.800000, -1.000000>, 
      <181.650000, -0.400000, 0.000000>, <185.150000, -1.250000, 0.000000>, <188.650000, -2.050000, 0.000000>, <192.150000, -2.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <181.650000, -0.400000, 0.000000>, <185.150000, -1.250000, 0.000000>, <188.650000, -2.050000, 0.000000>, <192.150000, -2.850000, 0.000000>, 
      <182.300000, 2.550000, 1.000000>, <185.800000, 1.700000, 1.000000>, <189.300000, 0.900000, 1.000000>, <192.800000, 0.100000, 1.000000>, 
      <182.400000, 2.750000, -1.000000>, <185.900000, 1.900000, -1.000000>, <189.400000, 1.100000, -1.000000>, <192.900000, 0.300000, -1.000000>, 
      <183.100000, 5.700000, 0.000000>, <186.600000, 4.850000, 0.000000>, <190.100000, 4.050000, 0.000000>, <193.600000, 3.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <183.100000, 5.700000, 0.000000>, <186.600000, 4.850000, 0.000000>, <190.100000, 4.050000, 0.000000>, <193.600000, 3.250000, 0.000000>, 
      <183.800000, 8.650000, 1.000000>, <187.300000, 7.800000, 1.000000>, <190.800000, 7.000000, 1.000000>, <194.300000, 6.200000, 1.000000>, 
      <183.800000, 8.900000, -1.000000>, <187.300000, 8.100000, -1.000000>, <190.800000, 7.200000, -1.000000>, <194.300000, 6.400000, -1.000000>, 
      <184.700000, 12.650000, 0.700000>, <188.200000, 11.800000, 0.700000>, <191.700000, 11.000000, 0.700000>, <195.200000, 10.200000, 0.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <152.200000, -174.850000, -1.000000>, <155.700000, -175.700000, -1.000000>, <159.200000, -176.500000, -1.000000>, <162.700000, -177.300000, -1.000000>, 
      <153.100000, -171.000000, 1.000000>, <156.600000, -171.800000, 1.000000>, <160.100000, -172.600000, 1.000000>, <163.600000, -173.400000, 1.000000>, 
      <153.200000, -170.800000, -1.000000>, <156.700000, -171.600000, -1.000000>, <160.200000, -172.400000, -1.000000>, <163.700000, -173.200000, -1.000000>, 
      <153.900000, -167.850000, 0.000000>, <157.400000, -168.650000, 0.000000>, <160.850000, -169.450000, 0.000000>, <164.350000, -170.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <153.900000, -167.850000, 0.000000>, <157.400000, -168.650000, 0.000000>, <160.850000, -169.450000, 0.000000>, <164.350000, -170.250000, 0.000000>, 
      <154.600000, -164.900000, 1.000000>, <158.100000, -165.700000, 1.000000>, <161.500000, -166.500000, 1.000000>, <165.000000, -167.300000, 1.000000>, 
      <154.600000, -164.700000, -1.000000>, <158.100000, -165.500000, -1.000000>, <161.600000, -166.300000, -1.000000>, <165.100000, -167.100000, -1.000000>, 
      <155.300000, -161.750000, 0.000000>, <158.800000, -162.550000, 0.000000>, <162.300000, -163.350000, 0.000000>, <165.800000, -164.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <155.300000, -161.750000, 0.000000>, <158.800000, -162.550000, 0.000000>, <162.300000, -163.350000, 0.000000>, <165.800000, -164.150000, 0.000000>, 
      <156.000000, -158.800000, 1.000000>, <159.500000, -159.600000, 1.000000>, <163.000000, -160.400000, 1.000000>, <166.500000, -161.200000, 1.000000>, 
      <156.000000, -158.550000, -1.000000>, <159.500000, -159.400000, -1.000000>, <163.000000, -160.200000, -1.000000>, <166.500000, -161.000000, -1.000000>, 
      <156.700000, -155.600000, 0.000000>, <160.200000, -156.450000, 0.000000>, <163.700000, -157.250000, 0.000000>, <167.200000, -158.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <156.700000, -155.600000, 0.000000>, <160.200000, -156.450000, 0.000000>, <163.700000, -157.250000, 0.000000>, <167.200000, -158.050000, 0.000000>, 
      <157.400000, -152.650000, 1.000000>, <160.900000, -153.500000, 1.000000>, <164.400000, -154.300000, 1.000000>, <167.900000, -155.100000, 1.000000>, 
      <157.400000, -152.450000, -1.000000>, <160.900000, -153.300000, -1.000000>, <164.400000, -154.100000, -1.000000>, <167.900000, -154.900000, -1.000000>, 
      <158.100000, -149.500000, 0.000000>, <161.600000, -150.350000, 0.000000>, <165.100000, -151.150000, 0.000000>, <168.600000, -151.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <158.100000, -149.500000, 0.000000>, <161.600000, -150.350000, 0.000000>, <165.100000, -151.150000, 0.000000>, <168.600000, -151.950000, 0.000000>, 
      <158.800000, -146.550000, 1.000000>, <162.300000, -147.400000, 1.000000>, <165.800000, -148.200000, 1.000000>, <169.300000, -149.000000, 1.000000>, 
      <158.800000, -146.300000, -1.000000>, <162.300000, -147.100000, -1.000000>, <165.800000, -148.000000, -1.000000>, <169.300000, -148.800000, -1.000000>, 
      <159.500000, -143.350000, 0.000000>, <163.000000, -144.150000, 0.000000>, <166.500000, -145.050000, 0.000000>, <170.000000, -145.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <159.500000, -143.350000, 0.000000>, <163.000000, -144.150000, 0.000000>, <166.500000, -145.050000, 0.000000>, <170.000000, -145.850000, 0.000000>, 
      <160.200000, -140.400000, 1.000000>, <163.700000, -141.200000, 1.000000>, <167.200000, -142.100000, 1.000000>, <170.700000, -142.900000, 1.000000>, 
      <160.300000, -140.200000, -1.000000>, <163.800000, -141.000000, -1.000000>, <167.300000, -141.800000, -1.000000>, <170.800000, -142.700000, -1.000000>, 
      <160.950000, -137.250000, 0.000000>, <164.450000, -138.050000, 0.000000>, <167.950000, -138.850000, 0.000000>, <171.450000, -139.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <160.950000, -137.250000, 0.000000>, <164.450000, -138.050000, 0.000000>, <167.950000, -138.850000, 0.000000>, <171.450000, -139.750000, 0.000000>, 
      <161.600000, -134.300000, 1.000000>, <165.100000, -135.100000, 1.000000>, <168.600000, -135.900000, 1.000000>, <172.100000, -136.800000, 1.000000>, 
      <161.700000, -134.100000, -1.000000>, <165.200000, -134.900000, -1.000000>, <168.700000, -135.700000, -1.000000>, <172.200000, -136.600000, -1.000000>, 
      <162.400000, -131.150000, 0.000000>, <165.900000, -131.950000, 0.000000>, <169.400000, -132.750000, 0.000000>, <172.900000, -133.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <162.400000, -131.150000, 0.000000>, <165.900000, -131.950000, 0.000000>, <169.400000, -132.750000, 0.000000>, <172.900000, -133.600000, 0.000000>, 
      <163.100000, -128.200000, 1.000000>, <166.600000, -129.000000, 1.000000>, <170.100000, -129.800000, 1.000000>, <173.600000, -130.600000, 1.000000>, 
      <163.100000, -128.000000, -1.000000>, <166.600000, -128.800000, -1.000000>, <170.100000, -129.600000, -1.000000>, <173.600000, -130.400000, -1.000000>, 
      <163.800000, -125.050000, 0.000000>, <167.300000, -125.850000, 0.000000>, <170.800000, -126.650000, 0.000000>, <174.300000, -127.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <163.800000, -125.050000, 0.000000>, <167.300000, -125.850000, 0.000000>, <170.800000, -126.650000, 0.000000>, <174.300000, -127.450000, 0.000000>, 
      <164.500000, -122.100000, 1.000000>, <168.000000, -122.900000, 1.000000>, <171.500000, -123.700000, 1.000000>, <175.000000, -124.500000, 1.000000>, 
      <164.500000, -121.900000, -1.000000>, <168.000000, -122.700000, -1.000000>, <171.500000, -123.500000, -1.000000>, <175.000000, -124.300000, -1.000000>, 
      <165.200000, -118.950000, 0.000000>, <168.700000, -119.750000, 0.000000>, <172.200000, -120.550000, 0.000000>, <175.700000, -121.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <165.200000, -118.950000, 0.000000>, <168.700000, -119.750000, 0.000000>, <172.200000, -120.550000, 0.000000>, <175.700000, -121.350000, 0.000000>, 
      <165.900000, -116.000000, 1.000000>, <169.400000, -116.800000, 1.000000>, <172.900000, -117.600000, 1.000000>, <176.400000, -118.400000, 1.000000>, 
      <165.900000, -115.800000, -1.000000>, <169.400000, -116.600000, -1.000000>, <172.900000, -117.400000, -1.000000>, <176.400000, -118.200000, -1.000000>, 
      <166.600000, -112.850000, 0.000000>, <170.100000, -113.650000, 0.000000>, <173.600000, -114.450000, 0.000000>, <177.100000, -115.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <166.600000, -112.850000, 0.000000>, <170.100000, -113.650000, 0.000000>, <173.600000, -114.450000, 0.000000>, <177.100000, -115.250000, 0.000000>, 
      <167.300000, -109.900000, 1.000000>, <170.800000, -110.700000, 1.000000>, <174.300000, -111.500000, 1.000000>, <177.800000, -112.300000, 1.000000>, 
      <167.300000, -109.700000, -1.000000>, <170.800000, -110.500000, -1.000000>, <174.300000, -111.300000, -1.000000>, <177.800000, -112.100000, -1.000000>, 
      <168.000000, -106.750000, 0.000000>, <171.500000, -107.550000, 0.000000>, <175.000000, -108.350000, 0.000000>, <178.500000, -109.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <168.000000, -106.750000, 0.000000>, <171.500000, -107.550000, 0.000000>, <175.000000, -108.350000, 0.000000>, <178.500000, -109.150000, 0.000000>, 
      <168.700000, -103.800000, 1.000000>, <172.200000, -104.600000, 1.000000>, <175.700000, -105.400000, 1.000000>, <179.200000, -106.200000, 1.000000>, 
      <168.800000, -103.550000, -1.000000>, <172.300000, -104.400000, -1.000000>, <175.800000, -105.200000, -1.000000>, <179.300000, -106.000000, -1.000000>, 
      <169.500000, -100.600000, 0.000000>, <173.000000, -101.450000, 0.000000>, <176.500000, -102.250000, 0.000000>, <180.000000, -103.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <169.500000, -100.600000, 0.000000>, <173.000000, -101.450000, 0.000000>, <176.500000, -102.250000, 0.000000>, <180.000000, -103.050000, 0.000000>, 
      <170.200000, -97.650000, 1.000000>, <173.700000, -98.500000, 1.000000>, <177.200000, -99.300000, 1.000000>, <180.700000, -100.100000, 1.000000>, 
      <170.200000, -97.450000, -1.000000>, <173.700000, -98.300000, -1.000000>, <177.200000, -99.100000, -1.000000>, <180.700000, -99.900000, -1.000000>, 
      <170.900000, -94.500000, 0.000000>, <174.400000, -95.350000, 0.000000>, <177.900000, -96.150000, 0.000000>, <181.400000, -96.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <170.900000, -94.500000, 0.000000>, <174.400000, -95.350000, 0.000000>, <177.900000, -96.150000, 0.000000>, <181.400000, -96.950000, 0.000000>, 
      <171.600000, -91.550000, 1.000000>, <175.100000, -92.400000, 1.000000>, <178.600000, -93.200000, 1.000000>, <182.100000, -94.000000, 1.000000>, 
      <171.600000, -91.350000, -1.000000>, <175.100000, -92.200000, -1.000000>, <178.600000, -93.000000, -1.000000>, <182.100000, -93.800000, -1.000000>, 
      <172.300000, -88.400000, 0.000000>, <175.800000, -89.250000, 0.000000>, <179.300000, -90.050000, 0.000000>, <182.800000, -90.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <172.300000, -88.400000, 0.000000>, <175.800000, -89.250000, 0.000000>, <179.300000, -90.050000, 0.000000>, <182.800000, -90.850000, 0.000000>, 
      <173.000000, -85.450000, 1.000000>, <176.500000, -86.300000, 1.000000>, <180.000000, -87.100000, 1.000000>, <183.500000, -87.900000, 1.000000>, 
      <173.000000, -85.200000, -1.000000>, <176.500000, -86.000000, -1.000000>, <180.000000, -86.900000, -1.000000>, <183.500000, -87.700000, -1.000000>, 
      <173.700000, -82.250000, 0.000000>, <177.200000, -83.050000, 0.000000>, <180.700000, -83.950000, 0.000000>, <184.200000, -84.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <173.700000, -82.250000, 0.000000>, <177.200000, -83.050000, 0.000000>, <180.700000, -83.950000, 0.000000>, <184.200000, -84.750000, 0.000000>, 
      <174.400000, -79.300000, 1.000000>, <177.900000, -80.100000, 1.000000>, <181.400000, -81.000000, 1.000000>, <184.900000, -81.800000, 1.000000>, 
      <174.400000, -79.100000, -1.000000>, <177.900000, -79.900000, -1.000000>, <181.400000, -80.700000, -1.000000>, <184.900000, -81.600000, -1.000000>, 
      <175.100000, -76.150000, 0.000000>, <178.600000, -76.950000, 0.000000>, <182.100000, -77.750000, 0.000000>, <185.600000, -78.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <175.100000, -76.150000, 0.000000>, <178.600000, -76.950000, 0.000000>, <182.100000, -77.750000, 0.000000>, <185.600000, -78.650000, 0.000000>, 
      <175.800000, -73.200000, 1.000000>, <179.300000, -74.000000, 1.000000>, <182.800000, -74.800000, 1.000000>, <186.300000, -75.700000, 1.000000>, 
      <175.900000, -73.000000, -1.000000>, <179.400000, -73.800000, -1.000000>, <182.900000, -74.600000, -1.000000>, <186.400000, -75.400000, -1.000000>, 
      <176.550000, -70.050000, 0.000000>, <180.050000, -70.850000, 0.000000>, <183.550000, -71.650000, 0.000000>, <187.050000, -72.450000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <176.550000, -70.050000, 0.000000>, <180.050000, -70.850000, 0.000000>, <183.550000, -71.650000, 0.000000>, <187.050000, -72.450000, 0.000000>, 
      <177.200000, -67.100000, 1.000000>, <180.700000, -67.900000, 1.000000>, <184.200000, -68.700000, 1.000000>, <187.700000, -69.500000, 1.000000>, 
      <177.300000, -66.900000, -1.000000>, <180.800000, -67.700000, -1.000000>, <184.300000, -68.500000, -1.000000>, <187.800000, -69.300000, -1.000000>, 
      <178.000000, -63.950000, 0.000000>, <181.500000, -64.750000, 0.000000>, <185.000000, -65.550000, 0.000000>, <188.500000, -66.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <178.000000, -63.950000, 0.000000>, <181.500000, -64.750000, 0.000000>, <185.000000, -65.550000, 0.000000>, <188.500000, -66.350000, 0.000000>, 
      <178.700000, -61.000000, 1.000000>, <182.200000, -61.800000, 1.000000>, <185.700000, -62.600000, 1.000000>, <189.200000, -63.400000, 1.000000>, 
      <178.700000, -60.800000, -1.000000>, <182.200000, -61.600000, -1.000000>, <185.700000, -62.400000, -1.000000>, <189.200000, -63.200000, -1.000000>, 
      <179.400000, -57.850000, 0.000000>, <182.900000, -58.650000, 0.000000>, <186.400000, -59.450000, 0.000000>, <189.900000, -60.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <179.400000, -57.850000, 0.000000>, <182.900000, -58.650000, 0.000000>, <186.400000, -59.450000, 0.000000>, <189.900000, -60.250000, 0.000000>, 
      <180.100000, -54.900000, 1.000000>, <183.600000, -55.700000, 1.000000>, <187.100000, -56.500000, 1.000000>, <190.600000, -57.300000, 1.000000>, 
      <180.100000, -54.700000, -1.000000>, <183.600000, -55.500000, -1.000000>, <187.100000, -56.300000, -1.000000>, <190.600000, -57.100000, -1.000000>, 
      <180.800000, -51.750000, 0.000000>, <184.300000, -52.550000, 0.000000>, <187.800000, -53.350000, 0.000000>, <191.300000, -54.150000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <180.800000, -51.750000, 0.000000>, <184.300000, -52.550000, 0.000000>, <187.800000, -53.350000, 0.000000>, <191.300000, -54.150000, 0.000000>, 
      <181.500000, -48.800000, 1.000000>, <185.000000, -49.600000, 1.000000>, <188.500000, -50.400000, 1.000000>, <192.000000, -51.200000, 1.000000>, 
      <181.500000, -48.600000, -1.000000>, <185.000000, -49.400000, -1.000000>, <188.500000, -50.200000, -1.000000>, <192.000000, -51.000000, -1.000000>, 
      <182.200000, -45.650000, 0.000000>, <185.700000, -46.450000, 0.000000>, <189.200000, -47.250000, 0.000000>, <192.700000, -48.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <182.200000, -45.650000, 0.000000>, <185.700000, -46.450000, 0.000000>, <189.200000, -47.250000, 0.000000>, <192.700000, -48.050000, 0.000000>, 
      <182.900000, -42.700000, 1.000000>, <186.400000, -43.500000, 1.000000>, <189.900000, -44.300000, 1.000000>, <193.400000, -45.100000, 1.000000>, 
      <182.900000, -42.450000, -1.000000>, <186.400000, -43.300000, -1.000000>, <189.900000, -44.100000, -1.000000>, <193.400000, -44.900000, -1.000000>, 
      <183.600000, -39.500000, 0.000000>, <187.100000, -40.350000, 0.000000>, <190.600000, -41.150000, 0.000000>, <194.100000, -41.950000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <183.600000, -39.500000, 0.000000>, <187.100000, -40.350000, 0.000000>, <190.600000, -41.150000, 0.000000>, <194.100000, -41.950000, 0.000000>, 
      <184.300000, -36.550000, 1.000000>, <187.800000, -37.400000, 1.000000>, <191.300000, -38.200000, 1.000000>, <194.800000, -39.000000, 1.000000>, 
      <184.400000, -36.350000, -1.000000>, <187.900000, -37.200000, -1.000000>, <191.400000, -38.000000, -1.000000>, <194.900000, -38.800000, -1.000000>, 
      <185.100000, -33.400000, 0.000000>, <188.600000, -34.250000, 0.000000>, <192.100000, -35.050000, 0.000000>, <195.600000, -35.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <185.100000, -33.400000, 0.000000>, <188.600000, -34.250000, 0.000000>, <192.100000, -35.050000, 0.000000>, <195.600000, -35.850000, 0.000000>, 
      <185.800000, -30.450000, 1.000000>, <189.300000, -31.300000, 1.000000>, <192.800000, -32.100000, 1.000000>, <196.300000, -32.900000, 1.000000>, 
      <185.800000, -30.200000, -1.000000>, <189.300000, -31.000000, -1.000000>, <192.800000, -31.900000, -1.000000>, <196.300000, -32.700000, -1.000000>, 
      <186.500000, -27.250000, 0.000000>, <190.000000, -28.050000, 0.000000>, <193.500000, -28.950000, 0.000000>, <197.000000, -29.750000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <186.500000, -27.250000, 0.000000>, <190.000000, -28.050000, 0.000000>, <193.500000, -28.950000, 0.000000>, <197.000000, -29.750000, 0.000000>, 
      <187.200000, -24.300000, 1.000000>, <190.700000, -25.100000, 1.000000>, <194.200000, -26.000000, 1.000000>, <197.700000, -26.800000, 1.000000>, 
      <187.200000, -24.100000, -1.000000>, <190.700000, -24.900000, -1.000000>, <194.200000, -25.800000, -1.000000>, <197.700000, -26.600000, -1.000000>, 
      <187.900000, -21.150000, 0.000000>, <191.400000, -21.950000, 0.000000>, <194.900000, -22.800000, 0.000000>, <198.400000, -23.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <187.900000, -21.150000, 0.000000>, <191.400000, -21.950000, 0.000000>, <194.900000, -22.800000, 0.000000>, <198.400000, -23.650000, 0.000000>, 
      <188.600000, -18.200000, 1.000000>, <192.100000, -19.000000, 1.000000>, <195.600000, -19.800000, 1.000000>, <199.100000, -20.700000, 1.000000>, 
      <188.600000, -18.000000, -1.000000>, <192.100000, -18.800000, -1.000000>, <195.600000, -19.600000, -1.000000>, <199.100000, -20.500000, -1.000000>, 
      <189.300000, -15.050000, 0.000000>, <192.800000, -15.850000, 0.000000>, <196.300000, -16.650000, 0.000000>, <199.800000, -17.550000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <189.300000, -15.050000, 0.000000>, <192.800000, -15.850000, 0.000000>, <196.300000, -16.650000, 0.000000>, <199.800000, -17.550000, 0.000000>, 
      <190.000000, -12.100000, 1.000000>, <193.500000, -12.900000, 1.000000>, <197.000000, -13.700000, 1.000000>, <200.500000, -14.600000, 1.000000>, 
      <190.000000, -11.900000, -1.000000>, <193.500000, -12.700000, -1.000000>, <197.000000, -13.500000, -1.000000>, <200.500000, -14.300000, -1.000000>, 
      <190.700000, -8.950000, 0.000000>, <194.200000, -9.750000, 0.000000>, <197.700000, -10.550000, 0.000000>, <201.200000, -11.350000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <190.700000, -8.950000, 0.000000>, <194.200000, -9.750000, 0.000000>, <197.700000, -10.550000, 0.000000>, <201.200000, -11.350000, 0.000000>, 
      <191.400000, -6.000000, 1.000000>, <194.900000, -6.800000, 1.000000>, <198.400000, -7.600000, 1.000000>, <201.900000, -8.400000, 1.000000>, 
      <191.500000, -5.800000, -1.000000>, <195.000000, -6.600000, -1.000000>, <198.500000, -7.400000, -1.000000>, <202.000000, -8.200000, -1.000000>, 
      <192.150000, -2.850000, 0.000000>, <195.650000, -3.650000, 0.000000>, <199.150000, -4.450000, 0.000000>, <202.650000, -5.250000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <192.150000, -2.850000, 0.000000>, <195.650000, -3.650000, 0.000000>, <199.150000, -4.450000, 0.000000>, <202.650000, -5.250000, 0.000000>, 
      <192.800000, 0.100000, 1.000000>, <196.300000, -0.700000, 1.000000>, <199.800000, -1.500000, 1.000000>, <203.300000, -2.300000, 1.000000>, 
      <192.900000, 0.300000, -1.000000>, <196.400000, -0.500000, -1.000000>, <199.900000, -1.300000, -1.000000>, <203.400000, -2.100000, -1.000000>, 
      <193.600000, 3.250000, 0.000000>, <197.100000, 2.450000, 0.000000>, <200.600000, 1.650000, 0.000000>, <204.100000, 0.850000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <193.600000, 3.250000, 0.000000>, <197.100000, 2.450000, 0.000000>, <200.600000, 1.650000, 0.000000>, <204.100000, 0.850000, 0.000000>, 
      <194.300000, 6.200000, 1.000000>, <197.800000, 5.400000, 1.000000>, <201.300000, 4.600000, 1.000000>, <204.800000, 3.800000, 1.000000>, 
      <194.300000, 6.400000, -1.000000>, <197.800000, 5.600000, -1.000000>, <201.300000, 4.800000, -1.000000>, <204.800000, 4.000000, -1.000000>, 
      <195.200000, 10.200000, 0.700000>, <198.700000, 9.400000, 0.700000>, <202.200000, 8.600000, 0.700000>, <205.700000, 7.800000, 0.700000>
    }
  }
  translate  <-1.272922, -75.0, 9.8>
  material {
    Cloud_Water_1
    // Transform to world space
  }
}


