#version unofficial megapov 0.6;


#macro Lidres(Loc,Col, Lux, Rayon)
glow {
  type 2
  location Loc
  size .2
  radius .8
  color rgb <.5,.5,1>*4
}
#end

#macro Lightk(Col, Power,Abs, Scale)
material{
       texture{
       pigment{rgbf 1}
       }
       interior{media{
                emission rgb Col*Power
                absorption rgb Abs
                density{spherical}
       scale Scale
       }} 
}
#end

#declare LightB= Lightk(<1,1,2>,2,<.5,.5,0>,.5)
#declare LightB2= Lightk(<1,1,2>,4,<.5,.5,0>,.5)


//------------------------Environnement------------------------------

#if (Env)
sky_sphere{
pigment{gradient y
color_map{
[0, rgb <1,.5,0>*2]
[.5,rgb <.2,0,.4>]
[1, rgb <0,0,.4>]
}
scale 2 translate <0,-.6,0>
}

pigment{
        bozo
        color_map{
             [0,rgbf <.2,.2,.2,1>]
             [1, rgbf <.6,.6,.5,.4>*.2]
        }

      turbulence 1
      scale .5
}

pigment{bozo
color_map{
[0, rgbf 1]
[.5,rgbf 1]
[.7 ,rgb <.8,.5,.5> filter .4]
[1,  rgb <.8,.5,.5>*1.5 filter .2]
}
rotate 80*y
turbulence <1,.5,1>
omega .7
lambda 2
octaves 10
scale <.4,.2,.4>*1.2
}

pigment{
bozo
color_map{
[0, rgbf 1]
[.5,rgbf 1]
[1,  rgb <.8,.5,.5>*3 filter .2]
}
rotate 80*y
turbulence <1,.5,1>
omega .7
lambda 2
octaves 8
scale <.4,.2,.4>
}} 

plane{y,-430 
pigment{rgb <.4,.4,.5>}
normal{wrinkles 1 scale 20 turbulence .5}
finish{reflection .2 specular .8}} 

fog
{
  fog_type   2
  distance   30000
  color      rgb <.7,.4,.3>*.8
  fog_offset -500
  fog_alt    1000
  turbulence 1
} 

#end

//---------Support-------------------------------------------------
#if (Level1>1)
#declare Jrt=
material{
   texture{
   pigment{ image_map{tga "d:\elrais\cliparts\hull"} scale .1}
   finish{ambient .8}
   }
   }

#declare Hjf=
material{
texture{
pigment{
image_map{png"d:\elrais\cliparts\dstarb" interpolate 2} 
scale <80,90,80>
} 
normal{
bump_map{png "d:\elrais\cliparts\hullbump2"}10
scale 40
} 
finish{ambient .3 specular .5 brilliance 2.5}
}}
#else
#declare Jrt=material{texture{pigment{rgb 1}}}
#declare Hjf=material{texture{pigment{rgb 1}}}
#end

#declare Main=
union{
difference{
  blob{
  threshold .2
  sphere{0,50,1 scale <1,1,.2>}
  sphere{<0,0,0>,25,1 scale <1,4.5,.3> rotate -4*z translate <-20,-10,0>}
  sphere{<0,0,0>,25,1 scale <1,5,.3> rotate -26*z translate <20,-10,0>}
  scale <1,1,2> 
  }
        box{<100,0,100>,<-100,100,-100> uv_mapping material{Jrt}}
        scale <2.5,1,1>
        translate <15,0,0>
uv_mapping  material{Hjf}

} 

difference{
  blob{
  threshold .5
  sphere{<0,0,0>,30,1 scale <4,2,1> translate <-10,0,30>}
  sphere{<0,0,0>,20,1 scale <3,4,1> translate <-10,-20,30>}
  uv_mapping  material{Hjf}
  }
        box{<100,10,30>,<-100,-100,-100> material{Hjf}}  
        box{<100,0,100>,<-100,100,-100> uv_mapping material{Jrt}}

}

difference{
  blob{
  threshold .5
  sphere{<0,0,0>,30,1 scale <4,2,1> translate <-10,0,30>}
  sphere{<0,0,0>,20,1 scale <3,4,1> translate <-10,-20,30>}
  uv_mapping  material{Hjf}
  }
        box{<100,10,30>,<-100,-100,-100> material{Hjf}}  
        box{<100,0,100>,<-100,100,-100> uv_mapping material{Jrt}}

scale <1,1,-1>
}

                box{<-40,0, 10>,<-30,-10, 30> material{Hjf rotate 90*y}}
                box{<-40,0,-10>,<-30,-10,-30> material{Hjf rotate 90*y}}
/*
union{
cylinder{<-29,-1,-1>,<-29,-1,-30>,.5}
cylinder{<-41,-1,-5>,<-41,-1,-30>,.5}
cylinder{<-41,-2,-5>,<-41,-2,-30>,.5}
cylinder{<-41,-2,-15>,<-41,-2,-25>,.7}

pigment{rgb <1,1,0>}
} */

#declare Wn=100;        //tuyauterie
#declare R1=seed(15);
#declare R2=seed(105);
#declare R3=seed(150);
#declare R4=seed(145);
#declare R5=seed(1145);

union{
#while (Wn>0)
#declare F1=rand(R1);
#declare F2=rand(R2);
#declare F3=rand(R3);
#declare F4=rand(R4);
#declare F5=rand(R5);
cylinder{<-42+F1*4, -F2*8-.5, -5-(F3*20)>,<-42+ F1*4, -F2*8-.5, -35+(F4*20)>,F5*.5}
cylinder{<-42+F1*4, -F2*8-.5, -5-(F3*20)>,<-42+ F1*4, -F2*8-.5, -35+(F4*20)>,F5*.5 scale <1,1,-1>}
cylinder{<-40+F1*4, -F2*10-.5, -5-(F3*20)>,<-40+ F1*4, -(F2*10)-.5, -35+(F4*20)>,F5*.5 translate 10*x}
cylinder{<-40+F1*4, -F2*10-.5, -5-(F3*20)>,<-40+ F1*4, -(F2*10)-.5, -35+(F4*20)>,F5*.5 scale <1,1,-1> translate 10*x}
#declare Wn=Wn-1;
#end
pigment{rgb <1,1,1.2>} finish{specular .8 roughness .02 brilliance 1.5}}

#if (All_lights)
light_source{<-42,-5,15> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-42,-5,25> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-42,-5,-15> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-42,-5,-25> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}

light_source{<-28,-5,15> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-28,-5,25> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-28,-5,-15> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
light_source{<-28,-5,-25> rgb <.8,.8,1> fade_distance 5 fade_power 4 shadowless}
#end

     box{<-38,.1,13.5><-32,0,30> pigment{rgb .8} finish{specular .3 brilliance 1.5}}
     box{<-38,.1,-13.5><-32,0,-30> pigment{rgb .8} finish{specular .3 brilliance 1.5}}

     
     #declare On=10;
     #declare Ot=13.5;
     #declare Ott=(30-13.5)/On;

#if (All_lights)     

     #declare R=2;
     #declare Nsv=3;
     #declare Rgt=<1,1,2>;
     #declare Nld=<.5,.5,0>;
     #declare Sk=.5;
     
     #declare Soder=1;
     
     #macro Mifer(Loc)
     
     #if (Soder=1)
     sphere{0,R hollow Lightk(Rgt,Nsv,Nld,Sk)  translate Loc} 
     #if (Soder=2)
     Lidres(Loc,<1,1,1.2>*.5,.3,.8)
     #end
     #end
     #end

     #while (On>=0)
     
     
     /*
     sphere{0,R hollow Lightk(Rgt,Nsv,Nld,Sk)  translate <-38,.1,Ot>  }
     sphere{0,R hollow Lightk(Rgt,Nsv,Nld,Sk)  translate <-32,.1,Ot>  }
     sphere{0,R hollow Lightk(Rgt,Nsv,Nld,Sk)  translate <-38,.1,-Ot>  }
     sphere{0,R hollow Lightk(Rgt,Nsv,Nld,Sk)  translate <-32,.1,-Ot>  }
       */
     /* 
      Lidres(<-38,.1,Ot>,<1,1,1.2>*.5,.3,.8)     //41s
      Lidres(<-32,.1,Ot>,<1,1,1.2>*.5,.3,.8)     //55 s  
      Lidres(<-38,.1,-Ot>,<1,1,1.2>*.5,.3,.8) 
      Lidres(<-32,.1,-Ot>,<1,1,1.2>*.5,.3,.8) 
       */           
     
     Mifer(<-38,.1,Ot>)
     Mifer(<-32,.1,Ot>)
     Mifer(<-38,.1,-Ot>)
     Mifer(<-32,.1,-Ot>)
       
     #declare Ot=Ot+Ott;
     #declare On=On-1;
     #end
#end


}


//-----------------Arbaletes--------------------------------------------------
  #declare Fleche=
  union{
  cylinder{<-2,0,0><5,0,0>,.05
  pigment{rgb 1}
  finish{specular 1 roughness .025 brilliance 1.5}
  }
  triangle{
  <-2,.1,0>,<-0,0,0>,<-2,-.1,0>
  }
  
  prism {
  conic_sweep   linear_spline 
  -0.5,  0,5,
  <1,1>,<1,-1>,<-1,-1>,<-1,1>,<1,1>
  sturm
  scale .5 
  translate .5*y
  rotate 45*y
  scale <.7,5,.5>
  rotate -90*z
  translate 3*x
  pigment{rgb .75}
  finish{specular 1 brilliance 1.5}
  }
  }
  
#declare Arc=
union{
difference{
union{
cylinder{<0,0,0><0,0,-.4>,3.5}
box{<4,-.75,.25>,<3.0,.75,-.25>}
}
cylinder{<0,0,2>,<0,0,-2>,3.3}
box{<1,-5,3>,<-5,5,-3>}
}

cylinder{<1,3.2,0>,<-2,.5,0>,.02}
cylinder{<1,-3.2,0>,<-2,-.5,0>,.02}
cylinder{<-2,.5,0>,<-2,-.5,0>,.02}
  
  
object{ Fleche}  
object{ Fleche translate .5*y}  
object{ Fleche translate -.5*y}  

cylinder{<1,0,0>,<1,0,-.4>,.5}
box{<1,-.1,-.1>,<3.5,.1,-.3>}
box{<0,-.1,-.1>,<2.8,.1,-.3> rotate 60*z translate 1*x}
box{<0,-.1,-.1>,<2.8,.1,-.3> rotate -60*z translate 1*x}

cylinder{<1,3.2,.1>,<1,3.2,-.1>.2}
cylinder{<1,-3.2,.1>,<1,-3.2,-.1>.2}

sphere{0,.3 hollow material{LightB} translate <1,3.5,0>}
sphere{0,.3 hollow material{LightB} translate <1,-3.5,0>}
sphere{0,.3 hollow material{LightB} translate <3.6,-0,.2>}

#declare R=2;
#if (All_lights)
light_source{<1,3.6,0> rgb <.2,.2,.4>*R fade_distance 2 fade_power 10 shadowless}
light_source{<1,-3.6,0> rgb <.2,.2,.4>*R fade_distance 2 fade_power 10 shadowless}

light_source{<3.6,-0,.8> rgb <.2,.2,.4>*R/2 fade_distance 2 fade_power 10 }

#end

translate <-1,0,0>
}
//----------------------------------
#macro Weapon1(Arcrotate, Allrotate)
union{        
object{Arc
rotate Arcrotate
translate <0,4,3>
}       

object{Arc
rotate 180*x
rotate Arcrotate
translate <0,4,-3>
}       


difference{   //support
cylinder{<0,0,0>,<0,4,0> 2}

cylinder{<0,0,5>,<0,0,-5>,1
scale <1.5,3,1>
translate <2,3,0>
} 
cylinder{<0,0,5>,<0,0,-5>,1
scale <1.5,3,1>
translate <-2,3,0>
}

} 

cylinder{<0,4,3>,<0,4,-3>,.5}

sphere{0,.3 hollow material{LightB} translate <2,0,0>}
sphere{0,.3 hollow material{LightB} translate <1.25,0,1.6>}
sphere{0,.3 hollow material{LightB} translate <1.25,0,-1.6>}

#declare S=1;
#if (All_lights)
light_source{<2,0,0> rgb <.2,.2,.4>*S fade_distance 4 fade_power 10 shadowless}
light_source{<1.25,0,1.6> rgb <.2,.2,.4>*S fade_distance 4 fade_power 10 }
light_source{<1.25,0,-1.6> rgb <.2,.2,.4>*S fade_distance 4 fade_power 10 }

#end

pigment{rgb <.9,.9,1>}
rotate Allrotate
}
#end
//-------------------Arbaletes-----------------------------------------------------------------



            #if (Final)
                global_settings{
                  motion_blur 20,1
                }
                
            #else
                
                global_settings{
                  motion_blur 20,1
                }

            #end
               
#declare Akter=               
               
union{
 difference{
        union{
        torus{10,1 scale<1,1.5,1>}
        cylinder{<0,-.5,0>,<0,.5,0>,11.5}
         }
                cylinder{<0,-5,0>,<0,5,0>,9.2}
                box{<20,0,.5>,<0,2,-.5>}
 }
//structure

  box{<10,0,.5>,<0,.1,-.5>}
  superellipsoid{<1,.1> rotate 90*x scale 1.5}
  box{<.2,0,10>,<-.2,.1,0>}
  box{<.2,0,-10>,<-.2,.1,0>}

//hlice
        #declare B=.5;
        motion_blur{
        union{
        box{<9,0,B>,<0,-.1,-B> rotate <10,0,0>}
        box{<9,0,B>,<0,-.1,-B> rotate <10,120,0>}
        box{<9,0,B>,<0,-.1,-B> rotate <10,240,0>}

        box{<9,0,B>,<0,-.1,-B> rotate <10,60,0>}
        box{<9,0,B>,<0,-.1,-B> rotate <10,180,0>}
        box{<9,0,B>,<0,-.1,-B> rotate <10,300,0>}
        }
   translate -.25*y
   rotate  ((25*clock)+40)*y
   }              
   
#if (All_lights)
            #declare Merj=
                union{
                  sphere{0,.2 hollow material{LightB} }
                  light_source{<0,.5,0>, rgb <.5,.5,1>
                  fade_distance 1
                  fade_power 4
                  shadowless
                  }
                }  
         #declare Mn=19;
         #declare Mr=20;
         #declare Mra=360/20;
         
         #while (Mn>0)
         
                object{Merj translate <9.5,1.5,0> rotate Mr*y}
                object{Merj translate <10.5,1,0> rotate Mr*y}
         
         #declare Mn=Mn-1;
         #declare Mr=Mr+Mra;
         #end
                           
                           
                         #declare Qn=10;
                         #declare Qr=0;
                         #declare Qra=360/10;
                         
                         #while (Qn>0)
                         
                                object{Merj translate <1.5,.8,0> rotate Qr*y}
                         
                         #declare Qn=Qn-1;
                         #declare Qr=Qr+Qra;
                         #end

//#end

#declare Hk=.2;
#declare Hz=0;
union{
sphere{<2,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<2.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<3,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<3.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<4,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<4.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<5,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<5.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<6,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<6.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<7,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<7.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<8,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<8.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<9,.5,Hz>,Hk   pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<9.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<10,.5,Hz>,Hk  pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<10.5,.5,Hz>,Hk pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
sphere{<11,.5,Hz>,Hk  pigment{rgbf 1} interior{media{emission rgb 1}} hollow}
translate -.4*y
}
#end


} //Fin Akter


#declare Akter2=
union{
object{Akter}

                #declare  Lpad= 
                union{
                cylinder{<0,-.5,0>,<0,.5,0>,2}
                box{<2,-.5,-2>,<-2,.5,0>}
                }
object{Lpad translate 12.5*z}
object{Lpad translate 12.5*z rotate 40*y}
object{Lpad translate 12.5*z rotate -40*y}



//box{<12,1,50>,<20,2,-20>}
//box{<-12,1,50>,<-20,2,-20>}

object{Weapon1(<0,0,30>,<0,-60,0>) scale .25 translate <0,.5,13> rotate -40*y} 
object{Weapon1(<0,0,30>,<0,-90,0>) scale .25 translate <0,.5,13>} 
object{Weapon1(<0,0,30>,<0,-120,0>) scale .25 translate <0,.5,13> rotate 40*y} 
         
}

#declare Hrd=.7;

#declare Akketer=
union{
object{Akter2 scale <1,1,1>*.8  rotate -90*y translate <-49,0,-21> }
object{Akter2 scale <-1,1,1>*.8 rotate -90*y translate <-49,0,21> }

object{Akter scale <1,1,1>*Hrd  rotate -90*y translate <-22,0,-22> }
object{Akter scale <-1,1,1>*Hrd rotate -90*y translate <-22,0,22> }

object{Akter scale <1,1,1>*Hrd  rotate -90*y translate <-6,0,-22> }
object{Akter scale <-1,1,1>*Hrd rotate -90*y translate <-6,0,22> }
finish{specular .5 brilliance 1.5}
} 


//-----------------Murailles-----------------------------------------------------------
#if (Level1>=1)

#declare Gorril=
texture{
pigment{rgb <1,1,1.2>}
finish{
specular .8
brilliance 2 
reflection .2
}
}


#else

#declare Gorril=
texture{
pigment{rgb 1}
}

#end


#declare Hegor=
union{

difference{
        union{
        box{<-80,0,3>,<-80.2,9,-3>}
        box{<0,0,.1>,<5,9,-.1> rotate 20*y translate <-80,0,-3.5>}
        box{<0,0,.1>,<5,9,-.1> rotate -20*y translate <-80,0,3.5>}
        
        box{<0,0,.1>,<15,9,-.1> rotate 167*y translate <-60,0,8.5>}
        box{<0,0,.1>,<15,9,-.1> rotate 193*y translate <-60,0,-8.5>}
        
        box{<0,0,.1>,<15,9,-.1> rotate 174*y translate <-45,0,10>}
        box{<0,0,.1>,<15,9,-.1> rotate 186*y translate <-45,0,-10>}
        } 
        cylinder{<0,0,50>,<0,0,-50>,5 scale <5,.5,1> rotate -6*z translate<-60,9,0> }
        

#if (Level2>0)        
pigment{rgbf 1} finish{specular 1 reflection .2}  
hollow
interior{
media{
emission rgb <.5,.5,1>
density{bumps}
}}
#else

pigment{rgb 1} finish{specular 1 reflection .2}  
hollow
interior{
media{
emission rgb <.5,.5,1>
density{bumps}
}}


#end


normal{
bozo 1
turbulence 1
scale <1,5,1>
}

} 


#declare Pa=<-80,0,3.5>;
#declare Ph1=<0,10,0>;
#declare Pr=1.5;

        #declare Neder=
        union{
        cylinder{0,Ph1,Pr}
        
                #if (Level2>0)
                object{ Weapon1 (<0,0,20>,<0,180,0>) scale .25 translate Ph1}
                #end
        
        
        #declare Jn=10;
        #declare Jt=.5;
        #declare Jtp=1;
        
        #while (Jn>0)
        
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,-.8>}
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,-.8>}
        
        #declare Jn=Jn-1;
        #declare Jt=Jt+Jtp;
        #end

           difference{
           cylinder{<0,0,0>,Ph1+<0,.4,0>,Pr} 
           cylinder{<0,1,0>,<0,100,0>,Pr-.3}                      
           #declare Dn=6;
           #declare Dr=0;
           #declare Decal=Pr;
           
           #while (Dn>0)
           
           box{<10,-2,.2>,<-10,5,-.2> rotate Dr*y translate Ph1}
           #declare Dn=Dn-1;
           #declare Dr=Dr+30;
           
           #end
           } 
        
           
        texture{Gorril} 
        }


object{Neder   translate Pa}
object{Neder   translate Pa+<0,0,-7>}

#declare Pa=<-75,0,5>;

object{Neder   translate Pa}
object{Neder   translate Pa+<0,0,-10>}


        #declare Neder=
        union{
        cylinder{0,<0,8,0>,Pr}
                
                #if (Level2>0)
                object{ Weapon1 (<0,0,20>,<0,180,0>) scale .25 translate <0,8,0>}
                #end


        #declare Jn=8;
        #declare Jt=.5;
        #declare Jtp=1;
        
        #while (Jn>0)
        
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,-.8>}
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,-.8>}
        
        #declare Jn=Jn-1;
        #declare Jt=Jt+Jtp;
        #end
              
           difference{
           cylinder{<0,7,0>,<0,8.4,0>,Pr} 
           cylinder{<0,1,0>,<0,10,0>,Pr-.3}                      
           #declare Dn=6;
           #declare Dr=0;
           #declare Decal=Pr;
           
           #while (Dn>0)
           
           box{<10,-2,.2>,<-10,5,-.2> rotate Dr*y translate <0,8,0>}
           #declare Dn=Dn-1;
           #declare Dr=Dr+30;
           
           #end
           } 
                
        texture{Gorril} 
        }

#declare Pa=<-60,0,8.5>;

object{Neder   translate Pa}
object{Neder   translate Pa+<0,0,-17>}


        #declare Neder=
        union{
        cylinder{0,<0,6.5,0>,Pr}
                
                #if (Level2>0)
                object{ Weapon1 (<0,0,20>,<0,180,0>) scale .25 translate <0,6.5,0>}
                #end


        #declare Jn=6;
        #declare Jt=.5;
        #declare Jtp=1;
        
        #while (Jn>0)
        
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <-1.2,Jt,-.8>}
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,.8> }
        sphere{0,.2 hollow    material{texture{pigment{rgbf 1}}
        interior{media{emission rgb <.8,.8,2>*2 absorption rgb <1,1,0> density{spherical}}}} translate <1.2,Jt,-.8>}
        
        #declare Jn=Jn-1;
        #declare Jt=Jt+Jtp;
        #end
              
           difference{
           cylinder{<0,0,0>,<0,6.9,0>,Pr} 
           cylinder{<0,1,0>,<0,10,0>,Pr-.3}                      
           #declare Dn=6;
           #declare Dr=0;
           #declare Decal=Pr;
           
           #while (Dn>0)
           
           box{<10,-2,.2>,<-10,5,-.2> rotate Dr*y translate <0,6.5,0>}
           #declare Dn=Dn-1;
           #declare Dr=Dr+30;
           
           #end
           } 
   
  
        texture{Gorril} 
        }

#declare Pa=<-45,0,10>;

object{Neder   translate Pa}
object{Neder   translate Pa+<0,0,-20>}

#if (Level2>0)
object{ Weapon1 (<0,0,50>,<0,180,0>) scale .25 translate <-82.5,0,0>}
#end

} 


//--------------Generateurs------------------------------------------------------------------------


        #declare Frebby=
        union{
        sphere{0,.3
        hollow
        material{
        texture{
        pigment{rgbf 1}}
        interior{
        media{
        emission rgb 1
        absorption rgb <1,1,0>
        density{spherical}
        }}
        }
        no_shadow
        } 
        
        
        
#if(All_lights)        
        light_source{0,rgb <.8,.8,1> fade_distance .8 fade_power 5 shadowless}
#end
        }

        #declare Frebby2=
        union{
        sphere{0,.3
        hollow
        material{
        texture{
        pigment{rgbf 1}}
        interior{
        media{
        emission rgb 4
        //absorption rgb <1,1,0>
        density{spherical scale .2}
        }}
        }
        no_shadow
        }} 

#macro Velian(Fumm)
union{
cylinder{0,<0,5,0>,6}
cylinder{<0,6,0>,<0,5,0>,6.5}

cone{<0,0,0>,7 <0,1,0>,6}

sphere{<0,0,0>,6 scale <1,.5,1> translate <0,6,0>}

union{
cone{<0,7,4>,1.5,<0,9,4>,1 open 
}

#if (Level2>0)    //fume
cylinder{<0,0,0><0,8,0>,1.5
hollow
material{
texture{
pigment{rgbf 1}}
interior{
media{
emission rgb 1
absorption rgb 1
density{cylindrical
turbulence 1
}
density{gradient y scale 8}
scale <1.2,1,1.2>
}}
}
rotate 180*x
translate 8*y
//rotate 15*x   //faire pencher la fume
rotate Fumm*y
translate <0,9,4>
}
#end
} 


#if(All_lights)
        #declare Rn=20;
        #declare Ra=360/Rn;
        #declare Rr=9;
        #while(Rn>0)
        
        union{
        cylinder{<6,0,0>,<6,5,0>,.2 }
        object{Frebby translate <6.2,1,0> }    
        object{Frebby translate <6.2,5,0> }
        object{Frebby translate <6.2,6,0> }
/*
        box{<6,4.8,.1>, <6.7,6.2,-.1>   rotate -6*y}
        box{<6,4.75,.1>,<6.8,6.25,-.1> rotate -3*y}
        box{<6,4.75,.1>,<6.8,6.25,-.1> rotate  3*y}
        box{<6,4.8,.1>, <6.7,6.2,-.1>   rotate  6*y}
        cylinder{<0,0,.2><0,0,-.2>,6.2 scale <1,.5,1> translate <0,6,0>}
*/        
        rotate Rr*y }
        
        #declare Rn=Rn-1;
        #declare Rr=Rr+Ra;
        
        #end
#end

#declare Hyje=
union{
cone{ <0,5.5,6.2>,.5,<0,5.5,6.8>,.3}
cylinder{<0,5.5,6.8>,<0,5.5,7.5>,.3}
sphere{<0,5.5,7.5>,.3}
cylinder{<0,5.5,7.5>,<0,0,7.5>,.3}
cone{<0,0,7.5>,.5,<0,.5,7.5>,.3}
rotate 15*y
}
object{Hyje rotate -5*y}
object{Hyje}
object{Hyje rotate 5*y}

union{
object{Hyje rotate -5*y}
object{Hyje}
object{Hyje rotate 5*y}
rotate 105*y
} 

union{
object{Hyje rotate -5*y}
object{Hyje}
object{Hyje rotate 5*y}
rotate -95*y
} 

box{<7,0,.8>,<4,2,-.8> pigment{rgb <.2,.2,0>}}
object{Frebby2 translate <7.2,2,.8>}
object{Frebby2 translate <7.2,2,-.8>}

union{
cylinder{<5,1.5,0>,<8,1.5,0>,.5 }
sphere{<8,1.5,0>,.5}
cylinder{<8,1.5,0>,<8,0,0>,.5}
cone{<8,0,0>,.8,<8,.5,0>,.5}
rotate -20*y
}
pigment{rgb 1}

#if (Level2>0)
finish{specular .8 brilliance 2}
#end

scale .8
#end

#declare Ytrel=
union{
object{Velian(10) translate <0,0,6>}}
object{Velian(50) translate <0,0,6> scale <1,1,-1>}}
object{Velian(456) translate <20,0,6>}             }
object{Velian(20) translate <20,0,6> scale <1,1,-1>}}
object{Velian(35) translate <40,0,6>}               }
object{Velian(42) translate <40,0,6> scale <1,1,-1>}}
}
//---------------------Canon-------------------------------------------------------------
#declare Pleron=
        union{
union{
intersection{
box{<150,0,17>,<50,56,-17> }
superellipsoid{<1,.3> rotate 90*y scale <20,15,7> translate <100,5,0>}

}
  

box{<78,0,8>,<120.5,5,-8>
}

difference{
union{
cone{<75,10,0>,5 <100,10,0>,4.5}
cone{<100,10,0>,4 <180,10,0>,2.5}
}

cylinder{<250,10,0>,<100,10,0>,2.25}
}

cylinder{<110,0,0><110,21,0>,2}
cylinder{<110,21,0><110,21.5,0>,2.5}
sphere{0,2 scale <1,.7,1> translate <110,21.5,0>}

cylinder{<100,0,0><100,21,0>,2}
cylinder{<100,21,0><100,21.5,0>,2.5}
sphere{0,2 scale <1,.7,1> translate <100,21.5,0>}

cylinder{<90,0,0><90,21,0>,2}
cylinder{<90,21,0><90,21.5,0>,2.5}
sphere{0,2 scale <1,.7,1> translate <90,21.5,0>}

cylinder{<75,10,0>,<72,10,0>,5.5}
cylinder{<74,10,0>,<73,10,0>,6}
sphere{0,4.5 scale <.5,1,1> translate <72,10,0>}
torus{2.5,.4 rotate 90*z translate <69,10,0>}

#init_3d_spline {"Spekk1",<0,20,-2>,<-2,15,-9>,<0,10,-8> <1,5,-8>,<0,0,-9>} 

#if (Level2>0)
#declare cK=.005;
#else
#declare cK=.05;
#end

#declare Nedel=
union{
#declare c=0;
#while (c<1)
  sphere { eval_3d_spline ("Spekk1",c),.5 }
#declare c=c+cK;
#end 

union{
cylinder{<0,6,-7.8>,<0,7,-7.8>,.7 }
cylinder{<0,6.5,0>,<0,6.5,-8>,.2 }
cylinder{<0,0,-9>,<0,.5,-9>,.8 }
pigment{rgb 1.2}
finish{specular 1 brilliance 2 roughness .05}
}

pigment{rgb <.5,.5,.6>}
translate <100,0,0>
finish{specular 1 brilliance 1.5 }

}

#declare Nedes=
union{
object{Nedel}
object{Nedel scale <1,1,-1>}


} 

object{Nedes}
object{Nedes translate 10*x}
object{Nedes translate -10*x}

translate <-100,0,0>
scale .5
translate <110,0,0>
}       

#declare W=7;

        cylinder{<140,3.5,-3.5>,<140,3.5,3.5>,1}      
        
        cylinder{<140,3.5,-3.4>,<140,3.5,-2>,1.2 }      
        cylinder{<140,3.5,3.4>,<140,3.5,2>,1.2 }      
         
        cylinder{<140,3.5,2.7>,<130,-5,W>,.5} 
        cylinder{<140,3.5,-2.7>,<130,-5,-W>,.5} 
       
        
        cylinder{<130,-5,W-.7>,<130,-5,W+.7>,.8}
        cylinder{<130,-5,-(W-.7)>,<130,-5,-(W+.7)>,.8}
        
        cylinder{<130,-5,W>,<124,-8,W>,.5}
        cylinder{<130,-5,-W>,<124,-8,-W>,.5}

        cylinder{<130,-5,W>,<120,-13,W>,.5}
        cylinder{<130,-5,-W>,<120,-13,-W>,.5}
        
        
     union{
        cylinder{<120,-8,8>,<120,-8,-8>,.8}
        sphere{<120,-8,8>,.8}
        sphere{<120,-8,-8>,.8}
        cylinder{<120,-8,8>,<100,-8,8>,.8}
        cylinder{<120,-8,-8>,<100,-8,-8>,.8}
        box{<120,-8.8,8>,<100,-7.2,-8>}
      translate 4*x
     }   

     union{
        cylinder{<120,-8,8>,<120,-8,-8>,.8}
        sphere{<120,-8,8>,.8}
        sphere{<120,-8,-8>,.8}
        cylinder{<120,-8,8>,<100,-8,8>,.8}
        cylinder{<120,-8,-8>,<100,-8,-8>,.8}
        box{<120,-8.8,8>,<100,-7.2,-8>}
       translate <0,-5,0>
     }
       

                #declare Jiur=
                sphere{0,.5
                hollow
                material{
                 texture{
                 pigment{rgbf 1}
                 }
                interior{
                media{
                emission rgb <1.5,1.5,2>
                absorption <1,1,0>
                density{spherical}
                }}
                }
                } 
#declare Freb=
union{ 
sphere{0,1
hollow
material{
texture{
pigment{rgbf 1}}
interior{
media{
emission rgb <.5,.5,1>*2
density{spherical}
}}
}
}
             
light_source{0,rgb <.8,.8,1> fade_distance 5 fade_power 4}  
}

#if (All_lights)
object{Jiur translate <120,7.2,0>}
object{Jiur translate <125,7.15,0>}
object{Jiur translate <130,7.1,0>}
object{Jiur translate <135,7.05,0>}
object{Jiur translate <140,7.0,0>}
object{Jiur translate <145,6.95,0>}
object{Jiur translate <150,6.9,0>}

object{Jiur translate <150,6.9,0>}
object{Jiur translate <150,3.8,0>}
object{Jiur translate <150,5.25,-1.8>}
object{Jiur translate <150,5.25,1.8>}

object{Freb translate <125,.1,0> }
object{Freb translate <115,.1,6.5> }
object{Freb translate <115,.1,-6.5> }
object{Freb translate <110,.1,7.5> }
object{Freb translate <110,.1,-7.5> }
object{Freb translate <105,.1,7.5> }
object{Freb translate <105,.1,-7.5> }
object{Freb translate <100,.1,7> }
object{Freb translate <100,.1,-7> }
   
object{Freb translate <125,-4.8,0> }
object{Freb translate <130,-5,6.2> }
object{Freb translate <130,-5,-6.2> }

object{Freb translate <140,2.5,-0> }
  
#end
         pigment{rgb <.9,.9,1>}
         
         #if (Level2>0)
         finish{metallic 1 specular 1 roughness .025 brilliance 3 reflection .1}
         #end     }                                                                       

//-----------------Tour-------------------------------------------------------------              

#declare Jilsa=

/*union{
difference{
cylinder{<0,0,0>,<0,12,0>,20 scale <1,1,.3> translate <-50,0,0>}
cylinder{<0,0,0>,<0,10,0>,21 scale <1,1,.3> rotate -5*z translate <-50,10,0>}
} */

/*
sphere{15*y,19 scale <1,1,.3> translate <-50,0,0> hollow
material{
texture{
pigment{rgbf 1}}
interior{
media{
emission rgb <.2,.2,.3>
density {crackle
// metric 0
 scale 3}
}}
} 

}
cylinder{0,15*y,19 scale <1,1,.3> translate <-50,0,0>
hollow
material{
texture{
pigment{rgbf 1}}
interior{
media{
emission rgb <.2,.2,.3>
density {crackle
// metric 0
 scale 3}
}}
} 
//finish{phong 1}
}
*/


/*  
#declare Kn=20;
#declare Kray=20;
#declare Kzscale=.3;

#declare T=seed(32);
#declare U=seed(21);

union{
#while(Kn>0)

#declare Kr1=360*rand(T);
#declare Kr2=360*rand(U);
#declare Kr3=360*rand(seed(64));
#declare Kr4=360*rand(seed(45));

#declare Ka=<cos(Kr1)*Kray, sin(Kr2)*Kray,sin(Kr1)*Kray>;
#declare Kb=<cos(Kr1+10)*Kray, sin(Kr2+20)*Kray,sin(Kr1+10)*Kray>;

box{Ka, Kb}

#declare Kn=Kn-1;
#end
scale<1,1,.3>
translate -50*x
} */


/*
difference{
cone{<0,0,0>15 <0,25,0>,10 scale <1,1,.3> rotate 5*z translate -52*x}
cylinder{<0,0,15>,<0,0,-15>,11 scale <2,.5,1> rotate 10*z translate <-66,22,0>}
}

cylinder{<-69,0,0>,<-69,30,0>,.5}


finish{specular 1 roughness .025}
} */
//box{<30,0,15>,<-30,-5,-15> pigment{rgb .5}}

union{
union{
difference{
        union{
        box{<10,0,5>,<-7,35,4> }
        box{<10,0,-5>,<-7,35,-4> }
        }
#declare J=15;
#declare K=.4;
union{
cylinder{<0,0,10>,<0,0,-10>,J} 
box{<J,0,10>,<-J,250,-10>}
scale <1,K,1>
rotate 2*z
translate <J,J*K,0>}

cylinder{<0,0,10>,<0,0,-10>,10 scale <.5,2.5,1> rotate -3*z translate <-7,25,0>}
}                                   

difference{
cylinder{<0,10,0>,<0,30,0>,4.5}
cylinder{<0,0,10>,<0,0,-10>,4.5 scale <1,4,1> rotate -5*z translate <5,13,0> }
cylinder{<10,0,0>,<-10,0,0>,4.5 scale <1,2,1> translate <0,10,0>}
}

}  

difference{
superellipsoid{<1,.5>  rotate 90*x scale 4.5 translate <0,28,0>}
box{<10,28,10>,<-10,00,-10>} 
finish{specular 1 brilliance 2}

} 

blob{
threshold .6

//cylinder{<0,30,0>,<0,35,0>,9.5,1}

sphere{<1.8,3,5>,4,1.5 scale <5,1,1>}
sphere{<1.2,0,3>,4,1.5 scale <3,1,1> rotate 20*z translate <-5,0,0>}
sphere{<1.2,0,5>,3,1.5 scale <3,2,1> rotate 10*z translate <-00,0,0>}

sphere{<1.8,3,-5>,4,1.5 scale <5,1,1>}
sphere{<1.2,0,-3>,4,1.5 scale <3,1,1> rotate 20*z translate <-5,0,0>}
sphere{<1.2,0,-5>,3,1.5 scale <3,2,1> rotate 10*z translate <-00,0,0>}

sphere{<1.2,0,0>,4,1.5 scale <4,1,2> rotate 0*z translate <2,5,0>

texture{
pigment{
crackle metric 2
color_map{
[0,rgbf <.7,.7,1,.1>]
[.5,rgbf <.8,.8,1,.8>]
[1,rgbf <.8,.6,1,1>]}
scale 3
} }
finish{phong 1}
}
hollow
interior{media{
emission rgb .5
density{crackle}
}}
scale <1,.6,.6>
rotate <0,0,5>
translate <-4,30,0>
} 


union{
#declare Vn=12;
#declare Vtp=15/5;
#declare Vt=0;
#while (Vn>0)

sphere{<-1.2,0,5>,.4 translate Vt*y}
sphere{<-1.2,0,-5>,.4 translate Vt*y}
       
       #if (All_lights)
        light_source{<-1.2,Vt,-5.5> rgb <1,1,1.5> fade_distance 1 fade_power 2 shadowless}
        light_source{<-1.2,Vt,5.5>  rgb <1,1,1.5> fade_distance 1 fade_power 2 shadowless}
       #end
       
#declare Vn=Vn-1;
#declare Vt=Vt+Vtp;
#end

#declare Wn=8;
#declare Wr=0; 
#while (Wn>0)
cone{0,.4,<0,15,0>,0 translate 7*z rotate (Wr-90)*z }
cone{0,.4,<0,15,0>,0 translate -7*z rotate (Wr-90)*z }
#declare Wn=Wn-1;
#declare Wr=Wr+180/7;
#end

cylinder{<0,0,6.45>,<0,0,7.55>,2}
sphere{<0,0,7.55>,2}
cylinder{<0,0,-6.45>,<0,0,-7.55>,2}
sphere{<0,0,-7.55>,2}

light_source{<5.5,30,0> rgb <1,1,1.2> fade_distance 10 fade_power 4}
light_source{<0,10,0> rgb <1,1,1.2>*.5 fade_distance 10 fade_power 4}
light_source{<0,2,6.2> rgb <1,1,1.2>*.5 fade_distance 10 fade_power 4}
light_source{<0,2,-6.2> rgb <1,1,1.2>*.5 fade_distance 10 fade_power 4}

finish{specular .8 roughness .05 brilliance 2 reflection 1}
}


finish{specular 1 brilliance 2}
translate -50*x
} 


#if (Kbool)

//-------------------Propulseurs-----------------------------------------------------------------

#declare Celris=
union{
difference{                                                                                      
        union{
        cylinder{<0,0,0>,<-35,0,0>,5 }
        sphere{<0,0,0>,5}
        }
cylinder{<0,0,0>,<-52,0,0>,4.8 }
box{<-10,-10,3>,<10,10,-3>}
cylinder{<-45,-6,10><-30,-6,-15>,12 }
cylinder{<-0,3,15>,<-0,3,-15>,5 scale <1.2,1,1> translate -18*x}

pigment{rgb .5}
}

difference{                                                                                      
        union{
        cylinder{<0,0,0>,<-35,0,0>,4.9 }
        sphere{<0,0,0>,4.9}
        }
cylinder{<0,0,0>,<-52,0,0>,4.85 }
box{<-10,0,3>,<10,10,-3>}
cylinder{<-45,-6,10><-30,-6,-15>,12 }

pigment{rgbf <.8,.8,1,.8>}

#if (Level1>1) 
finish{phong 1}
#end
}
 
        union{ 
        box{<0,0,-5>,<-23.9,.2,-5.2> }
        box{<0,.8,-5>,<-24.4,1,-5.2> }

#declare Nn=13;
#declare Nt=0;
      #while (Nn>0)
        cylinder{<0,.5,-5>,<0,.5,-5.2>,.6 translate -Nt*x}
        sphere{<-Nt,.5,-0>,.4 scale <1,1,.5> translate -5.2*z}
        cylinder{<-Nt,0,-5.5>,<-Nt,-5,-6.5>,.2}
        cylinder{<-Nt,-3,0>,<-Nt,0,-6.5>,.4 scale <1,.2,1> translate -4.8*y}
        
        cylinder{<-Nt,0,5>,<-Nt,-5,5.5>,.2}
        cylinder{<-Nt,0,5>,<-Nt,-5,6>,.2}
        
      #declare Nn=Nn-1;
      #declare Nt=Nt+2;
      #end
 
   box{<-25,-4.8,-5>,<1,-5.5,-7>}     
   cylinder{<-25,-4.5,-6>,<-25,-5.5,-6>,1}
   cylinder{<1,-4.5,-6>,<1,-5.5,-6>,1}
   cylinder{<-25,0,-6>,<1,0,-6>,1 scale <1,.5,1> translate -5.5*y}
   sphere{<-25,-11,-6>1 scale <1,.5,1>}
   sphere{<1,-11,-6>1 scale <1,.5,1>}
 
   cylinder{<-25,0,-6>,<1,0,-6>,1 scale <1,.5,1> translate -4.8*y}
   sphere{<-25,-9.6,-6>1 scale <1,.5,1>}
   sphere{<1,-9.6,-6>1 scale <1,.5,1>}
   
   union{
   box{<-26,-5.5,-6>,<-24,-4.8,8>}
   cylinder{<-25,0,-6>,<-25,0,8>,1 scale <1,.5,1> translate <0,-4.8,0>}
   rotate 5*x
   translate -.5*y
   }    
        #if(Level2>1) finish{specular 1 roughness .025 reflection .3 brilliance 2} #end
        } 
       

#if (All_lights)
       
        cylinder{<-25,0,0>,<0,0,0>,3
        hollow
        material{
        texture{
        pigment{rgbf 1}}
        interior{
        media{
        emission rgb <1,1,.5>*.3
        absorption rgb <0,0,1>
        density{cylindrical rotate 90*z scale <1,2.5,2.5> 
        warp{turbulence 1 omega .8 lambda .8 octaves 10}
        }
        }}
        }
        } 
        
        #declare Firrod=   //eclairs bleus
        cylinder{<0,0,4.5>,<0,0,-4.5>,5
        hollow
        material{
        texture{
        pigment{rgbf 1}}
        interior{
        media{ 
        intervals 10
        emission rgb <.5,.5,1>*10
        absorption rgb 0
        density{cylindrical rotate 90*x scale .4 warp{turbulence <.2,.2,0> omega 1 octaves 6}}
        }}
        }
        }

    
    object{Firrod}
    object{Firrod translate <2,0,0> }
    object{Firrod translate <1,1,0> }
    object{Firrod translate <1,-1,0>}
     
     sphere{<1,0,0>,2
     hollow
        material{
        texture{
        pigment{rgbf 1}}
        interior{
        media{
        emission rgb 5
        absorption rgb 1
        density{spherical scale .5}
        }}
        }     
     }   

light_source{<-30,0,0> rgb <1,1,.5>*5 fade_distance 5 fade_power 5 }
#end

translate <-40,5,-38>
}

#declare Melres=
union{
object{Celris}
object{Celris scale <1,1,-1>}

}    

//-------Transports-------------------------------------------------------------------

#declare Trans=
union{
blob{
threshold .6
sphere{0,2,1 scale <3,2,1> translate <0,0,0>}
sphere{0,1,1 scale <4,1,1> translate <2.2,-1,0>}
sphere{0,1,1 scale <4,1,1> translate <-2,-1,.8>}
sphere{0,1,1 scale <4,1,1> translate <-2,-1,-.8>}
sphere{0,2,1 scale <3,.5,2> translate <0,-1,0>}
sphere{0,2,1 scale <2,1,1> translate <-.5,-.2,0>}
sphere{0,2,1 scale <1.5,1,2> translate <-1,-.2,0>}
sphere{0,2,1 scale <1.5,1,1.5> translate <-1.5,-.2,0>}
sphere{0,2,1 scale <1.5,.5,2.5> translate <-1.5,.6,0>}
sphere{0,2,1 scale <1.5,.5,4> translate <-1.5,.6,0>}
sphere{0,2,1 scale <1,.5,8> translate <-1,.6,0>}
sphere{0,2,1 scale <.8,.2,1> translate <-1,.6,6>}
sphere{0,2,1 scale <.8,.2,1> translate <-1,.6,-6>}
}
sphere{0,1 scale <1.5,.8,.5> rotate -20*z translate <2.4,-.2,0> pigment{rgb .5} finish{reflection 1 phong 1 brilliance 3}}

#if (Level1>1)
#declare W=.2;
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W+.2,7.8>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W+.1,7>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W,6>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W,5>}

sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W+.2,-7.8>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W+.1,-7>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W,-6>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <2,.5,.5> translate <-1,W,-5>}

sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <1,.4,1> translate <-4.5,-1,.8>}
sphere{0,1 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)  scale <1,.4,1> translate <-4.5,-1,-.8>}
#end

cylinder{<2,0,0>,<3.5,-2.5,0>,.15}     //pieds
cylinder{<3.5,-2.5,0>,<3.5,-2.3,0>,.2}
cylinder{<-1.8,.5,3.5>,<-1.8,-2.5,4>,.3}
cylinder{<-1.8,-2.5,4>,<-1.8,-2.2,4>,.5}
cylinder{<-1.8,.5,-3.5>,<-1.8,-2.5,-4>,.3}
cylinder{<-1.8,-2.5,-4>,<-1.8,-2.2,-4>,.5}

cylinder{<4,0,.2>,<5,0,.2>,.1}
cylinder{<4,0,-.2>,<5,0,-.2>,.1}

sphere{<0,-1.5,0>,1}
cylinder{0,<2,0,.2>,.1 rotate <0,0,-20> translate -2*y}
cylinder{0,<2,0,-.2>,.1 rotate <0,0,-20> translate -2*y}

pigment{rgb <.8,.8,.5>}
finish{specular .4 brilliance 2.5}

translate <0,2.5,0>
scale .5
}

#declare Vrifel=
union{
object{Trans rotate 30*y  translate <-25,0,41>}
object{Trans rotate -30*y translate <-25,0,34>}
object{Trans rotate 30*y  translate <-20,0,41>}
object{Trans rotate -30*y translate <-20,0,34>}
object{Trans rotate 30*y  translate <-15,0,41>}
object{Trans rotate -30*y translate <-15,0,34>}
object{Trans rotate 30*y  translate <-10,0,41>}
object{Trans rotate -30*y translate <-10,0,34>}
object{Trans rotate 30*y  translate < -5,0,41>}
object{Trans rotate -30*y translate < -5,0,34>}
object{Trans rotate 30*y  translate <  0,0,41>}
object{Trans rotate -30*y translate <  0,0,34>}
object{Trans rotate 30*y  translate <20,0,41>}
object{Trans rotate -30*y translate <20,0,34>}
object{Trans rotate 30*y  translate <15,0,41>}
object{Trans rotate -30*y translate <15,0,34>}
object{Trans rotate 30*y  translate <10,0,41>}
object{Trans rotate -30*y translate <10,0,34>}
object{Trans rotate 30*y  translate <5,0,41>}
object{Trans rotate -30*y translate <5,0,34>}
}

//------------------------Eclaireurs------------------------------------------------------------

#declare Qadel=
union{
blob{
threshold .6
sphere{0,4,1 scale <3,.5,.8>}
sphere{0,1.5,1 scale <1,5,.5> rotate -10*z translate <-3,-8,0>}
sphere{0,2,1 scale <1.5,4,.5> rotate -10*z translate <-2.5,-3,0>}
sphere{0,2,1 scale <2,1,.5> rotate -0*z translate <-2,-1,0>}
cylinder{<0,0,4>,<0,0,-4>,4,1 scale <1,.2,3> translate <0,1,0>}


pigment{rgb <.9,.8,1>*2}
normal{quilted .05 control0 .5 control1 1  scale <20,10,2>}
finish{specular 1 roughness .09 brilliance 1.5}
}

sphere{<0,0,0>,1   pigment{rgbf <.5,.5,1,.5>} finish{phong 1 reflection .5}
hollow
Lightk(5,1,0,1)
scale <2,.5,.5>
translate <5.5,.2,0> 
scale .8
}

sphere{0,1 hollow Lightk(<1,1,2>,2,.2,1) scale <3,1,1> translate <-6,0,0>}

sphere{0,.5 hollow Lightk(<2,2,5>,1,0,.8) scale <3,1,1> translate <0,1,18>}
sphere{0,.5 hollow Lightk(<2,2,5>,1,0,.8) scale <3,1,1> translate <0,1,-18>}


light_source{<0,1.5,18>  rgb <1,1,2> fade_distance 1 fade_power 5 shadowless}
light_source{<0,1.5,-18> rgb <1,1,2> fade_distance 1 fade_power 5 shadowless}

translate <6,0,0>
}
//-----------------Trajectoire des eclaireurs--------------------------------------------------------------------

#init_3d_spline {"Vld1",<-150,-30,-150><50,-20,-200><220,-10,-200>}
#init_3d_spline {"Vld2",<-150,20,80><30,20,70><120,30,70><350,35,50>}
#init_3d_spline {"Vld3",<-150,-50,-20>,<50,-30,-50>,<350,0,-100>}
#init_3d_spline {"Vld4",<-150,50,60>,<0,50,40>,<100,50,40>,<180,70,40>}
#init_3d_spline {"Vld5",<-150,-30,-80>,<-50,-80,-50>,<150,-100,-55>,<400,-130,-90>}
#init_3d_spline {"Vld6",<-150,50,20>,<0,20,60>,<200,10,90>}
#init_3d_spline {"Vld7",<-150,50,-100>,<0,10,-140>,<150,70,-150>}

#declare Dener=
union{ 

object{Qadel rotate <10,0,20>    translate <220,-10,-200>}
object{Qadel rotate <-20,5,10>   translate <350,35,50>}
object{Qadel rotate <-5,0,30>    translate <180,70,40>}
object{Qadel rotate <-10,0,20>   translate <400,-130,-90>}
object{Qadel rotate <-10,30,-20> translate <200,10,90>}
object{Qadel rotate <20,0,20>    translate <150,70,-150>}


//object{Qadel rotate <0,20,10>    translate <350,0,-100>}
//object{Qadel rotate <20,0,40> translate <00,0,-0>}

union{
#declare Sir=.8;
#declare c=0;
#while (c<1)
  sphere { eval_3d_spline ("Vld1",c),Sir }
  sphere { eval_3d_spline ("Vld2",c),Sir }
  sphere { eval_3d_spline ("Vld4",c),Sir }
  sphere { eval_3d_spline ("Vld5",c),Sir }
  sphere { eval_3d_spline ("Vld6",c),Sir }
  sphere { eval_3d_spline ("Vld7",c),Sir }

//  sphere { eval_3d_spline ("Vld3",c),Sir }

#declare c=c+0.0005;
#end

hollow
material{
texture{
pigment{rgbf 1}}
interior{
media{
emission rgb .2
}}}} 
  
} 

//----------------------Champ---------------------------------------------------------

#declare Fril=
union{
cylinder{<0,0,0>,<0,5,0>,.2}
sphere{<0,5,0>,.3 hollow Lightk(<1,1,2>,4,<.5,.5,0>,.5)}
cylinder{<0,0,0>,<0,-5,0>,.1 rotate 60*z translate 5*y}
triangle{<0,0,0>,<0,5,0>,<.866*5,.5*5,0> pigment{rgbf <.8,.8,1,1>}}
}
#declare Gors=
union{
sphere{0,.5}
light_source{<0,0,-2> rgb 4 fade_distance 6 fade_power 5 shadowless}
object{Fril}
object{Fril rotate 60*z}
object{Fril rotate 120*z}
object{Fril rotate 180*z}
object{Fril rotate 240*z}
object{Fril rotate 300*z}
pigment{rgb <1,1,.8>}
finish{specular .8 roughness .03 brilliance 2}
scale 2
}
#declare Nedal=
union{
object{Gors rotate  2*y translate <0,-4,50>}
object{Gors rotate 10*y translate <20,-4,48>}
object{Gors rotate 18*y translate <38,-4,43>}
object{Gors rotate  -4*y translate <-20,-4,50>}
object{Gors rotate  -8*y translate <-40,-4,48>}
}

#declare Gij=
union{
object{Nedal}
object{Nedal scale <1,1,-1>}
translate -2*y
}

//----------Bonshommes------------------------------------------------

/*
union{
sphere{<-75,1,30>,1}
sphere{<-10,0,47.5>,1}
sphere{<55,1,30>,1}
pigment{rgb 5}}
cylinder{<-10,0,47.5>,<-10,10,47.5>,1}
*/

//sphere{0,.5 scale <1,1.5,1> translate .75*y translate <0,0,0> pigment{rgb 5 filter .18}}

#declare Jolom=
union{
torus{.2,.08 scale <1,3.5,.5> translate .75*y}
cylinder{<.2,.9,0>,<.4,.6,0>,.08}
cylinder{<.4,.6,0>,<.3,.3,0>,.07}
cylinder{<-.2,.9,0>,<-.4,.6,0>,.08}
cylinder{<-.4,.6,0>,<-.3,.3,0>,.07}

cylinder{<0,1,0>,<0,1.2,0>,.08}
sphere{<0,0,0>,.14 scale <1,1.5,1> rotate -15*x translate <0,1.3,.02>}

torus{.18,.05 scale <1,2,.5>translate <0,.4,0>}
cylinder{<.1,.4,0>,<.1,-.2,0>,.1}
cylinder{<.1,-.1,0>,<.1,-.7,0>,.08}
cylinder{<-.1,.4,0>,<-.1,-.2,0>,.1}
cylinder{<-.1,-.1,0>,<-.1,-.7,0>,.08}
scale .7 
translate <0,.4,0>

pigment{
crackle metric 2
color_map{
[0,rgb <0,.5,0>]
//[.4,rgb 1]
[.45,rgb<.2,.2,1>]
[1,rgb <.2,.2,1>]}
scale .2
}

}              

//gnrateurs
#declare Ithres=
union{
#declare R1=seed(60544);
object{Jolom rotate rand(R1)*360*y translate <0,0,12>}
object{Jolom rotate rand(R1)*360*y translate <5,0,13>}
object{Jolom rotate rand(R1)*360*y translate <5.5,0,13.2>}
object{Jolom rotate rand(R1)*360*y translate <10,0,10>}
object{Jolom rotate rand(R1)*360*y translate <30,0,-5>}
object{Jolom rotate rand(R1)*360*y translate <25,0,-1>}
object{Jolom rotate rand(R1)*360*y translate <45,0,.8>}
object{Jolom rotate rand(R1)*360*y translate <48,0,3>}
object{Jolom rotate rand(R1)*360*y translate <8,0,3>}
object{Jolom rotate rand(R1)*360*y translate <25,0,13>}
object{Jolom rotate rand(R1)*360*y translate <32,0,11>}
object{Jolom rotate rand(R1)*360*y translate <13,0,-11>}
object{Jolom rotate rand(R1)*360*y translate <8,0,-8>}
object{Jolom rotate rand(R1)*360*y translate <29,0,4>}
object{Jolom rotate rand(R1)*360*y translate <15,0,1>}
object{Jolom rotate rand(R1)*360*y translate <-5,0,1>}
object{Jolom rotate rand(R1)*360*y translate <-5,0,1.5>}
object{Jolom rotate rand(R1)*360*y translate <-8,0,5>}
object{Jolom rotate rand(R1)*360*y translate <-7,0,-8>}
object{Jolom rotate rand(R1)*360*y translate <-9,0,3>}
object{Jolom rotate rand(R1)*360*y translate <-10,0,13>}
}


#end