#declare hw = 3;
#declare h1 = 5;
#declare h2 = 8;
#declare h3 = 9;
#declare h35 = 11;
#declare ht = 16;
#declare h4 = 16;
#declare h5 = 24;
#declare h6 = 36;


#macro building1 (_w,_h,_l)
	#local _t=0.1;
	#local _t2=0.2;
	#local _a=30;
	union {
		intersection {
			box{ <-_w/2+_t2, 0, -_l/2+_t2>, <_w/2-_t2, _h-_t, _l/2-_t2> }
			plane {
				y, 0
				rotate x*_a
				translate <0,_h-_t,0>
			}
			plane {
				y, 0
				rotate -x*_a
				translate <0,_h-_t,0>
			}
			texture { building1_body_tex }
		}
		intersection {
			box{ <-_w/2, 0, -_l/2>, <_w/2, _h, _l/2> }
			plane {
				y, 0
				rotate x*_a
				translate <0,_h,0>
			}
			plane {
				y, 0
				rotate -x*_a
				translate <0,_h,0>
			}
			union {
				plane {
					-y, 0
					rotate x*_a
					translate <0,_h-_t,0>
				}
				plane {
					-y, 0
					rotate -x*_a
					translate <0,_h-_t,0>
				}
			}
			texture { building1_roof_tex }
		}
	}
#end


#macro building2 (_w,_h,_l)
	#local _t=0.1;
	#local _t2=0.2;
	#local _a=30;
	union {
		intersection {
			box{ <-_w/2+_t2, 0, -_l/2+_t2>, <_w/2-_t2, _h-_t, _l/2-_t2> }
			plane {
				y, 0
				rotate x*_a
				translate <0,_h-_t,0>
			}
			plane {
				y, 0
				rotate -x*_a
				translate <0,_h-_t,0>
			}
			texture { building2_body_tex }
		}
		intersection {
			box{ <-_w/2, 0, -_l/2>, <_w/2, _h, _l/2> }
			plane {
				y, 0
				rotate x*_a
				translate <0,_h,0>
			}
			plane {
				y, 0
				rotate -x*_a
				translate <0,_h,0>
			}
			union {
				plane {
					-y, 0
					rotate x*_a
					translate <0,_h-_t,0>
				}
				plane {
					-y, 0
					rotate -x*_a
					translate <0,_h-_t,0>
				}
			}
			texture { building2_roof_tex }
		}
	}
#end


//some nice bezier spline macros
#macro floppy_cone (base, top, lrad, wrad, lsag, wsag, dip)
	#local dir = vnormalize(top-base);
	#local perpw = vcross(dir, y);
	#if ( vlength(perpw) < 0.01 )
		//if cone is near vertical, use x and z as w and l
		#local perpw = x;
		#local perpl = z;
	#else
		#local perpw = vnormalize(perpw);
		#local perpl = vcross(perpw, dir);
	#end
	#local p1 = base + wrad*perpw + wsag*dir;
	#local p2 = base + lrad*perpl + lsag*dir;
	#local p3 = base - wrad*perpw + wsag*dir;
	#local p4 = base - lrad*perpl + lsag*dir;
	#local curve = 4*(sqrt(2) - 1)/3;
	#local ctrll = lrad*perpl*curve;
	#local ctrlw = wrad*perpw*curve;
	union {
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 3
			v_steps 3
			top, top, top, top,
			(p1*1 + top*2 + dip*base)/(3+dip), ((p1+ctrll)*1 + top*2 + dip*base)/(3+dip), ((p2+ctrlw)*1 + top*2 + dip*base)/(3+dip), (p2*1 + top*2 + dip*base)/(3+dip)
			(p1*2 + top*1 + dip*base)/(3+dip), ((p1+ctrll)*2 + top*1 + dip*base)/(3+dip), ((p2+ctrlw)*2 + top*1 + dip*base)/(3+dip), (p2*2 + top*1 + dip*base)/(3+dip)
			p1, p1+ctrll, p2+ctrlw, p2
		}
		
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 3
			v_steps 3
			top, top, top, top,
			(p3*1 + top*2 + dip*base)/(3+dip), ((p3+ctrll)*1 + top*2 + dip*base)/(3+dip), ((p2-ctrlw)*1 + top*2 + dip*base)/(3+dip), (p2*1 + top*2 + dip*base)/(3+dip)
			(p3*2 + top*1 + dip*base)/(3+dip), ((p3+ctrll)*2 + top*1 + dip*base)/(3+dip), ((p2-ctrlw)*2 + top*1 + dip*base)/(3+dip), (p2*2 + top*1 + dip*base)/(3+dip)
			p3, p3+ctrll, p2-ctrlw, p2
		}
		
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 3
			v_steps 3
			top, top, top, top,
			(p3*1 + top*2 + dip*base)/(3+dip), ((p3-ctrll)*1 + top*2 + dip*base)/(3+dip), ((p4-ctrlw)*1 + top*2 + dip*base)/(3+dip), (p4*1 + top*2 + dip*base)/(3+dip)
			(p3*2 + top*1 + dip*base)/(3+dip), ((p3-ctrll)*2 + top*1 + dip*base)/(3+dip), ((p4-ctrlw)*2 + top*1 + dip*base)/(3+dip), (p4*2 + top*1 + dip*base)/(3+dip)
			p3, p3-ctrll, p4-ctrlw, p4
		}
		
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 3
			v_steps 3
			top, top, top, top,
			(p1*1 + top*2 + dip*base)/(3+dip), ((p1-ctrll)*1 + top*2 + dip*base)/(3+dip), ((p4+ctrlw)*1 + top*2 + dip*base)/(3+dip), (p4*1 + top*2 + dip*base)/(3+dip)
			(p1*2 + top*1 + dip*base)/(3+dip), ((p1-ctrll)*2 + top*1 + dip*base)/(3+dip), ((p4+ctrlw)*2 + top*1 + dip*base)/(3+dip), (p4*2 + top*1 + dip*base)/(3+dip)
			p1, p1-ctrll, p4+ctrlw, p4
		}
	}
#end


#macro floppy_cylinder (_start, _end, _rad, _curve)
	#local _d = _end - _start;
	#local _h = vlength( _d );
	#local _d = _d/_h;
	#local _c = vlength(_curve);
	#local _tr = (_h*_h/4 + _c*_c) / (2*_c);
	intersection {
		plane { z, _h/2 }
		plane { -z, _h/2 }
		plane { -x, 0 }
		torus { _tr, _rad }
		
		bounded_by {
			box { <0, -_rad, -_h/2>, <_tr+_rad, _rad, _h/2> }
		}

		translate <-(_tr - _c*3/3),0,_h/2>
		//transform so x points along _curve, and z points along _d
		#local _nc = vnormalize(_curve);
		#local _np = vcross( _nc, _d );
		matrix
		<	_nc.x, _nc.y, _nc.z,
			_np.x, _np.y, _np.z,
			_d.x,	 _d.y,	_d.z,
			0,		 0,			0 >

		translate _start
	}
#end	



#macro tower (_h,_r,_v)
	union {
		difference {
			intersection {
				floppy_cylinder (<0,-_h*1.8/5,0>, <0,_h*2.0/5,0>, _r*0.87, -_v*0.65)
				plane { -y, 0 }
				texture { turret_body_tex }
			}
			intersection {
				cylinder {
					_v*_r*2, <0,0,0>, _r*0.25
					scale <1,4,1>
					translate <0,_h*0.7/5,0>
				}
				plane {
					-y, -_h*0.7/5
				}
				texture {
					pigment { rgb 0 }
					finish { ambient 0 diffuse 0 }
				}
			}
		}
		object {
			floppy_cone( <0,_h*2.2/5,0> <0,_h,0>+_v, _r*1.3, _r*1.15, -_h*0.115, -_h*0.08, 0.8 )
			texture {
				turret_roof_tex
				scale 3*_v*(1.3/1.15 - 1.0) + <1,1,1>
				translate <0,_h,0>+_v
			}
		}
	}
#end


#macro steeple (_h,_r)
	#local _t = 0.3;
	#local _w = 0.2;
	#local _winw = 0.9;
	#local _winh = 4.2;
	#local _winsh = 2.2;
	#local _winb = 2.5;
	#local _gt = 0.05;
	#local _go = 0.1;
	#local _cr = _h*0.8;
	#local _s = 4;
	#local stained_glass_1 =
				box {
					<-_winw, _winb, -_r+_t+_go>, <_winw, _winb+_winh, -_r+_t+_go+_gt>
					texture {
						pigment {
							image_map {
								png "stained glass high.png"
								once
								filter all 1.0
								transmit all 0.4
							}
							translate <-0.5,0,0>
							scale <_winw*2,_winh*0.95,1>
							translate <0,_winb,0>
						}
						finish {
							ambient 1.0
							diffuse 0.3
							specular 1 roughness 0.005
						}
					}
				}

	union {
		union {
			difference {
				//walls
				box { <-_r+_t,0,-_r+_t>, <_r-_t,_h/2,_r-_t> }
				
				union {
					//room
					box { <-_r+_t+_w,0,-_r+_t+_w>, <_r-_t-_w,_h/2,_r-_t-_w> }
					
					//window shape
					box { <-_winw, _winb, -_r-0.1>, <_winw, _winb+_winsh, _r+0.1> }
					intersection {
						//_winr^2 = (_winh-_winsh)^2 + (_winr-_winw)^2
						//r^2=q^2+(r-w)^2
						//r^2=q^2+r^2-2wr+w^2
						//0=q^2-2wr
						//r=q^2/2w
						#local _winr = pow(_winh-_winsh,2)/(2*_winw);
						cylinder { <_winr-_winw, _winb+_winsh, -_r-0.1>, <_winr-_winw, _winb+_winsh, _r+0.1>, _winr }
						cylinder { <_winw-_winr, _winb+_winsh, -_r-0.1>, <_winw-_winr, _winb+_winsh, _r+0.1>, _winr }
						box { <-_winw, _winb+_winsh-0.1, -_r-0.1>, <_winw, _winb+_winh, _r+0.1> }
					}
				}
				
				texture { tower_room_tex }
			}
			
			//windows
			object { stained_glass_1 }
			object { stained_glass_1 scale <1,1,-1> }
		}

		difference {
			box { <-_r,_h/2,-_r>, <_r,_h,_r> }
			union {
				//centre of cylinders must be _cr away from bottom and top points.
				// p is in dir of <_h,_r> from <_r/2, _h/2> at dist of sqrt(_cr^2 - (_r^2+_h^2)/4). RIGHT.
				#local _l = sqrt(_h*_h/4 + _r*_r*_s*_s);
				#local _p = <_h/2,_r*_s>/_l;
				#local _p = _p * sqrt(_cr*_cr - _l*_l/4);
				#local _p = _p + <_r*_s/2, _h/4>;
				#local _p = _p + <0,_h/2>;
				cylinder {
					<-2*_r,_p.y,_p.x>, <2*_r,_p.y,_p.x>, _cr
					scale <1,1,1/_s>
				}
				cylinder {
					<-2*_r,_p.y,-_p.x>, <2*_r,_p.y,-_p.x>, _cr
					scale <1,1,1/_s>
				}
				cylinder {
					<_p.x,_p.y,-2*_r>, <_p.x,_p.y,2*_r>, _cr
					scale <1/_s,1,1>
				}
				cylinder {
					<-_p.x,_p.y,-2*_r>, <-_p.x,_p.y,2*_r>, _cr
					scale <1/_s,1,1>
				}
			}

			texture { tower_roof_tex }
		}
	}
#end


#macro main_tower(_h,_r1,_r2)
	#local _d=2;
	#local _t=1;
	#local _p=_h-2;
	#local _q=2.5;
	union {
		difference {
			intersection {
				box { <-_r1,_p-_q,-_r1>, <_r1,_h,_r1> }
				plane { <_q,-(_r1-_r2),0>, 0  translate <_r1,_p,0> }
				plane { <-_q,-(_r1-_r2),0>, 0 translate <-_r1,_p,0> }
				plane { <0,-(_r1-_r2),_q>, 0  translate <0,_p,_r1> }
				plane { <0,-(_r1-_r2),-_q>, 0 translate <0,_p,-_r1> }
			}

			box { <-_r1+_t,_h-_d,-_r1+_t>, <_r1-_t,_h+1,_r1-_t> }

			texture { tower_body_tex }
		}
		
		box {
			<-_r2,0,-_r2>, <_r2,_p,_r2>
			texture { tower_cut_tex }
		}
	}
#end


#macro box_turret( _corner1, _corner2 )
	#local _t = 1.0;
	#local _d = 2.0;
	#local _cut = 1.0;
	#local _nx = int ( ( abs( _corner2.x - _corner1.x ) - _t*2 ) * _cut );
	#local _nz = int ( ( abs( _corner2.z - _corner1.z ) - _t*2 ) * _cut );
	#local _top = max( _corner1.y, _corner2.y );
	#local _right = max( _corner1.x, _corner2.x );
	#local _left	= min( _corner1.x, _corner2.x );
	#local _front = max( _corner1.z, _corner2.z );
	#local _back	= min( _corner1.z, _corner2.z );
	difference {
		box { _corner1, _corner2 }
		
		union {
			box { <_left+_t,_top-_d,_back+_t>, <_right-_t,_top+1,_front-_t> }
			#local _x = 0;
			#while (_x < _nx)
				box { <2*_x*_cut + _left + _cut, _top-_cut, _back-1>, <(2*_x+1)*_cut + _left + _cut, _top+1, _front+1> }
				#local _x=_x+1;
			#end
			#local _z = 0;
			#while (_z < _nz)
				box { <_left-1, _top-_cut, 2*_z*_cut + _back + _cut>, <_right+1, _top+1, (2*_z+1)*_cut + _back + _cut> }
				#local _z=_z+1;
			#end
		}
		
		texture { inner_turret_tex }
	}
#end


#declare nWALL_CURVES = 5;
#declare wall_curve =
	array[nWALL_CURVES][4]
	{
		{ <-23,  0, 29>, <-23,  0, 29>+10*< 1,0,.6>, < 37,  0, 31>- 7*< 1,0,-1>, < 37,  0, 31> },
		{ < 37,  0, 31>, < 37,  0, 31>+ 8*< 1,0,-1>, < 33,  0,-29>- 8*<-1,0,-1>, < 33,  0,-29> },
		{ < 33,  0,-29>, < 33,  0,-29>+ 8*<-1,0,-1>, <-27,  0,-32>-20*<-1,0,.6>, <-27,  0,-32> },
		{ <-27,  0,-32>, <-27,  0,-32>+10*<-1,0,.6>, <-39,  0,  0>-15*<.3,0, 1>, <-39,  0,  0> },
		{ <-39,  0,  0>, <-39,  0,  0>+15*<.3,0, 1>, <-23,  0, 29>-19*< 1,0,.6>, <-23,  0, 29> }
	}

#declare fortress_buildings =
	union {
		union {
	
			//buildings
			object {
				box_turret( < -3.5,  0, -3.5>, <  3.5,  h35,  3.5> )
				translate < -9,  0, -3>
			}
			object {
				box_turret( < -3.5,  0, -3.5>, <  3.5,  h35,  3.5> )
				translate < -9,  0, 21>
			}
			object { steeple( h6-h5+2, 1.8 ) translate < 10,  h5-2,  9> }
			object { main_tower( h5, 4, 2.5 ) translate < 10,  0,  9> }
			object { building1( 32,  h4,  12) translate < 10,  0,  9> }
			difference {
				box{ <-19.5,  0,-12.5>, < 19.5,  h3, 12.5> translate < 10,  0,  9> }
				box{ <-18.5, h1,-11.5>, < 18.5,  h4, 11.5> translate < 10,  0,  9> }
				texture { inner_wall_tex }
			}
			
			translate <0,2,0>
		
		}

		object { building1( 20,  h3,   8) rotate -30*y translate <-25,  0, -3> }
		object { building1( 14,  h3,  12) rotate -30*y translate <-22,  0, 15> }
		object { building1( 24,  h3,  10) translate <  5,  0,-28> }
		object { building1( 14,  h3,  14) translate < 27,  0,-15> }
		
		//trees
		union {
			object { TREE scale h2 translate <-20,  0,-25> }
			object { TREE scale h2 translate <-13,  0,-22> }
			object { TREE scale h2 translate <-21,  0,-18> }
			object { TREE scale h2 translate <-16,  0,-11> }
			object { TREE scale h2 translate < -9,  0,-12> }
		}
		
		//turrets
		object { tower( ht, 2.0, 1.0*vnormalize(< 42,  0, 17>) ) translate < 42,  0, 17> }
		object { tower( ht, 2.0, 1.0*vnormalize(< 42,  0,  3>) ) translate < 42,  0,  3> }
		object { tower( ht, 2.0, 1.0*vnormalize(< 37,  0, 31>) ) translate < 37,  0, 31> }
		object { tower( ht, 2.0, 1.0*vnormalize(< 33,  0,-29>) ) translate < 33,  0,-29> }
		object { tower( ht, 2.0, 1.0*vnormalize(<-23,  0, 29>) ) translate <-23,  0, 29> }
		object { tower( ht, 2.0, 1.0*vnormalize(<-27,  0,-32>) ) translate <-27,  0,-32> }
		object { tower( ht, 2.0, 1.0*vnormalize(<-40,  0,  0>) ) translate <-40,  0,  0> }
		
		//walls
		union {
			#declare _r = 0.98;
			#declare r1 = (_r-1)/3 + 1;
			#declare r2 = (_r-1)*2/3 + 1;
			#declare _ws = 1.01;
			#declare loop = 0;
			#while ( loop < nWALL_CURVES )
				//outer
				bicubic_patch {
					type 1
					flatness 0.0
					u_steps 1
					v_steps 5
					wall_curve[loop][0]*_ws+y*h1,			wall_curve[loop][1]+y*hw,			wall_curve[loop][2]+y*hw,			wall_curve[loop][3]*_ws+y*h1,
					wall_curve[loop][0]+y*h1*2/3,	wall_curve[loop][1]+y*hw*2/3,	wall_curve[loop][2]+y*hw*2/3,	wall_curve[loop][3]+y*h1*2/3,
					wall_curve[loop][0]+y*h1/3,		wall_curve[loop][1]+y*hw/3,		wall_curve[loop][2]+y*hw/3,		wall_curve[loop][3]+y*h1/3,
					wall_curve[loop][0],					wall_curve[loop][1],					wall_curve[loop][2],					wall_curve[loop][3]
				}
				
				//inner
				bicubic_patch {
					type 1
					flatness 0.0
					u_steps 1
					v_steps 5
					wall_curve[loop][0]*_r*_ws+y*h1,	wall_curve[loop][1]*_r+y*hw,			wall_curve[loop][2]*_r+y*hw,			wall_curve[loop][3]*_r*_ws+y*h1,
					wall_curve[loop][0]*_r+y*h1*2/3,	wall_curve[loop][1]*_r+y*hw*2/3,	wall_curve[loop][2]*_r+y*hw*2/3,	wall_curve[loop][3]*_r+y*h1*2/3,
					wall_curve[loop][0]*_r+y*h1/3,		wall_curve[loop][1]*_r+y*hw/3,		wall_curve[loop][2]*_r+y*hw/3,		wall_curve[loop][3]*_r+y*h1/3,
					wall_curve[loop][0]*_r,						wall_curve[loop][1]*_r,						wall_curve[loop][2]*_r,						wall_curve[loop][3]*_r
				}
				
				//top
				bicubic_patch {
					type 1
					flatness 0.0
					u_steps 1
					v_steps 5
					wall_curve[loop][0]*_ws+y*h1,			wall_curve[loop][1]+y*hw,				wall_curve[loop][2]+y*hw,				wall_curve[loop][3]*_ws+y*h1,
					wall_curve[loop][0]*r1*_ws+y*h1,	wall_curve[loop][1]*r1+y*hw,		wall_curve[loop][2]*r1+y*hw,		wall_curve[loop][3]*r1*_ws+y*h1,
					wall_curve[loop][0]*r2*_ws+y*h1,	wall_curve[loop][1]*r2+y*hw,		wall_curve[loop][2]*r2+y*hw,		wall_curve[loop][3]*r2*_ws+y*h1,
					wall_curve[loop][0]*_r*_ws+y*h1,	wall_curve[loop][1]*_r+y*hw,		wall_curve[loop][2]*_r+y*hw,		wall_curve[loop][3]*_r*_ws+y*h1
				}
				
				#declare loop = loop + 1;
			#end
			
			texture { wall_tex }
		}
	}

#declare church =
	union {
		object { building2( 12, 6, 8 ) }
		object { steeple( 16, 1.8 ) scale 0.85 translate <-4,4,0> }
	}
	
#declare house =
	#declare _w = 4;
	#declare _f = 2.5;
	union {
		difference {
			object { building2( 8, 7.5, 8 ) }
			union {
				box { <        -0.4,   0.0,-9>, <         0.4,   1.8,9> }
				box { < 0.55*_w-0.4,   0.6,-9>, < 0.55*_w+0.4,   1.8,9> }
				box { <-0.55*_w-0.4,   0.6,-9>, <-0.55*_w+0.4,   1.8,9> }
				box { <        -0.4,_f+0.6,-9>, <         0.4,_f+1.8,9> }
				box { < 0.55*_w-0.4,_f+0.6,-9>, < 0.55*_w+0.4,_f+1.8,9> }
				box { <-0.55*_w-0.4,_f+0.6,-9>, <-0.55*_w+0.4,_f+1.8,9> }
				texture {
					pigment { rgb 0 }
					finish { test_finish }
				}
			}
		}
		box {
			<-3.75,0,-3.75>, <3.75,5,3.75>
			texture {
				pigment { rgb <0.3,0.4,1.0> }
				finish {
					ambient 0.1
					diffuse 0.2
					reflection 0.4
				}
			}
		}
	}
	
#declare town =
	#declare _rs = seed(22);
	union {
		object { church scale 1.1 translate <-8,0,-40> }
		#declare _loop = 0;
		#while (_loop < 33)
			object { house rotate <0,360*rand(_rs),0> translate 140*<rand(_rs)-0.5,0,rand(_rs)-0.5> }
			#declare _loop = _loop + 1;
		#end
	}


