#declare test_pigment =
	pigment { rgb 1 }

#declare test_finish=
	finish {
		diffuse 0.7
		ambient 0.3
		specular 0.75 roughness 0.05
	}

#declare test_texture =
	texture {
		pigment { test_pigment }
		finish { test_finish }
	}

#declare test_material =
	material {
		texture { test_texture }
	}


#declare plaster_col = rgb<1,1,1>;
#declare turret_roof_col = rgb <0.7, 0.0, 0.2>;
#declare wall_col = rgb <0.1, 0.4, 0.5>;
#declare tree_col = rgb <0.0, 1.0, 0.0>;
#declare building1_roof_col = wall_col;
#declare building2_roof_col = turret_roof_col;
#declare tower_roof_col = turret_roof_col;


#declare stone_base_colour = rgb <0.85,0.8,0.45>;
#declare stone_highlight = rgb <0.95,0.94,0.75>;

#declare stone_finish =
	finish {
		diffuse 0.7
		ambient 0.3
	}
	
#declare stone_normal =
	normal {
		crackle
		slope_map {
			[0.0 <0,1>]
			[0.3 <1,1>]
			[0.3 <1,0>]
			[1.0 <1,0>]
		}
		scale 1
	}

#macro stone_drybrush(_base_colour,_highlight)
	pigment {
		crackle
		scale 10
		warp {
			turbulence 0.3
		}
		scale 1/10
		colour_map {
			[0.0 _base_colour]
			[0.3 _highlight]
			[1.2 _base_colour]
		}
		scale 1
	}
#end


#declare tiles_base_colour = rgb <0.6,0.3,0.2>;
#declare tiles_highlight = rgb <0.8,0.4,0.3>;

#declare tiles_finish =
	finish {
		diffuse 0.7
		ambient 0.3
	}
	
#declare tiles_normal =
	normal {
		average
		normal_map {
			[0.6
				gradient y
				slope_map {
					[0.0 <0,-10>]
					[0.2 <1,-10>]
					[0.2 <1,0>]
					[1.0 <0,0>]
				}
				scale 0.5
			]
			[0.4
				gradient x
				sine_wave
				translate <-0.25-10000,0,0>
				scale 0.5
			]
		}
	}

#macro tiles_drybrush(_base_colour,_highlight)
	pigment {
		average
		pigment_map {
			[0.6
				gradient y
				scale 10
				warp {
					turbulence 0.3
				}
				scale 1/10
				colour_map {
					[0.0  _base_colour]
					[0.15 _base_colour]
					[0.2  _highlight]
					[0.5  _base_colour]
				}
				scale 0.5
			]
			[0.4
				gradient x
				sine_wave
				scale 10
				warp {
					turbulence 0.3
				}
				scale 1/10
				colour_map {
					[0.0  _base_colour]
					[1.0  _highlight]
				}
				translate <-0.25-10000,0,0>
				scale 0.5
			]
		}
	}
#end


#declare radial_tiles_normal =
	normal {
		average
		normal_map {
			[0.6
				gradient y
				slope_map {
					[0.0 <0,-10>]
					[0.2 <1,-10>]
					[0.2 <1,0>]
					[1.0 <0,0>]
				}
				scale 0.5
			]
			[0.4
				radial
				frequency 15
				sine_wave
			]
		}
	}

#macro radial_tiles_drybrush(_base_colour,_highlight)
	pigment {
		average
		pigment_map {
			[0.6
				gradient y
				scale 10
				warp {
					turbulence 0.3
				}
				scale 1/10
				colour_map {
					[0.0  _base_colour]
					[0.15 _base_colour]
					[0.2  _highlight]
					[0.5  _base_colour]
				}
				scale 0.5
			]
			[0.4
				radial
				frequency 15
				sine_wave
				scale 10
				warp {
					turbulence 0.3
				}
				scale 1/10
				colour_map {
					[0.0  _base_colour]
					[1.0  _highlight]
				}
				scale 0.5
			]
		}
	}
#end


#declare blue_paint_base_colour = rgb <0.1,0.2,0.6>;
#declare blue_paint_highlight = rgb <0.6,0.58,0.95>;

#declare white_paint_base_colour = rgb <0.75,0.75,0.8>;
#declare white_paint_highlight = rgb <0.95,0.95,0.95>;

#declare paint_finish =
	finish {
		diffuse 0.7
		ambient 0.3
	}


#declare sea_pigment = 
	pigment {
		//very dark green. That's what colour deep sea is without the reflection.
		rgb <0.00, 0.15, 0.10> //note: NOT see thru, 'cause there's nothing to see under it.
	}

#declare BUMPS = 0;
#declare HEIGHT = 1;

#macro sea_height(bump_or_height)
	#if (bump_or_height = HEIGHT)
		crackle
	#else
		crackle 0.6
	#end
	scale 0.2
	poly_wave 1.5
  warp
  {
		turbulence 0.7
	}
	scale 20.0
  warp
  {
		turbulence 0.3
	}
	scale 0.25
#end


#declare sea_normal = 
	normal {
		sea_height(BUMPS)
	}


#declare sea_finish = 
	finish {
		reflection 0.45
		specular 0.8 roughness 0.001
		diffuse 0.6
		ambient 0.15
	}

#declare sand_stone =
	texture {
		pigment { rgb <1,0.95,0.7> }
		finish {
			ambient rgb <0.15, 0.13, 0.1>
			diffuse 0.65
			specular 0.4 roughness 0.015
		}
	}

#declare igneous =
	texture {
		pigment {
			rgb <0.7,0.6,0.5>
		}
		finish {
			ambient rgb <0.18,0.17,0.12>
			diffuse 0.5
			specular 0.7 roughness 0.02
		}
	}

#declare quartz =
	texture {
		pigment { rgb <1.0,0.94,0.85> }
		finish {
			metallic
			ambient 0.16
			diffuse 0.7
			specular 0.8 roughness 0.1
			reflection 0.1
		}
	}

#declare coal =
	texture {
		pigment { rgb 1 }
		finish {
			ambient 0.03
			diffuse 0.12
			specular 0.8 roughness 0.04
			//reflection 0.2
		}
	}

#declare sed_rock_1 =
	texture {
		bozo
		scale <0.2,0.02,0.2>/4
		turbulence 0.2 
		rotate <15,0,0> 
		texture_map {
			[0.4 sand_stone]
			[0.42 quartz]
			[0.48 quartz]
			[0.5 sand_stone]
		}
	}

#declare sed_rock_2 =
	texture {
		bozo
		scale <0.2,0.02,0.2>/4
		turbulence 0.2
		rotate <15,0,0> 
		texture_map {
			[0.4 igneous]
			[0.42 coal]
			[0.48 coal]
			[0.5 igneous]
		}
	}

#declare sed_rock_full =
	texture {
		spherical 
		scale <80,100,80>
		texture_map {
			[0.65
				sed_rock_2
			]
			[0.665
				sed_rock_1
			]
			[0.68
				sed_rock_2
			]
			[0.74
				sed_rock_1
			]
		}
	}

//full textures:
#declare full_stone =
	texture {
		stone_drybrush(stone_base_colour,stone_highlight)
		finish { stone_finish }
		normal { stone_normal }
	}

#declare blue_paint_on_stone =
	texture {
		stone_drybrush(blue_paint_base_colour,blue_paint_highlight)
		finish { paint_finish }
		normal { stone_normal }
	}

#declare white_paint_on_stone =
	texture {
		stone_drybrush(white_paint_base_colour,white_paint_highlight)
		finish { paint_finish }
		normal { stone_normal }
	}

#declare full_tilesz =
	texture {
		tiles_drybrush(tiles_base_colour,tiles_highlight)
		finish { tiles_finish }
		normal { tiles_normal }
	}

#declare full_tilesx =
	texture {
		tiles_drybrush(tiles_base_colour,tiles_highlight)
		finish { tiles_finish }
		normal { tiles_normal }
		rotate <0,90,0>
	}
	
#declare full_radial_tiles =
	texture {
		radial_tiles_drybrush(tiles_base_colour,tiles_highlight)
		finish { tiles_finish }
		normal { radial_tiles_normal }
	}
	
#declare sea_texture =
	texture {
		pigment { sea_pigment }
		normal { sea_normal }
		finish { sea_finish }
		scale 10
	}

#declare full_rock =
	texture {
		pigment { rgb 0.7 }
		finish { ambient 0.1 diffuse 0.9 }
	}
	
#declare full_snow =
  texture {
    pigment { rgb <1.0, 1.0, 1.0> }
    normal {
      bozo 0.1
      scale 0.0001
    }
    finish {
      ambient rgb <0.3, 0.4, 0.6>
      diffuse 0.5
      specular 1.0
      roughness 0.3
    }
  }

#declare full_ground =
	texture {
		pigment {
			spotted
			turbulence 1.2
			scale 150
			warp {
				turbulence 2.0
			}
			scale 10
			colour_map {
				[0.2 rgb <0.9, 0.7, 0.5>]//dry ground
				[0.4 rgb <0.8, 0.5, 0.3>]//wet ground
				[0.6 rgb <0.8, 1.0, 0.3>]//grassy ground
			}
		}
		normal {
			bozo 0.05
			scale 0.03
		}
		finish {
			ambient 0.3
			diffuse 0.7
		}
	}
	
#declare full_sand =
	texture {
		pigment {
			spotted
			colour_map {
				#declare _yell = (<1.0, 0.9, 0.6> + <1,1,1>)/2;
				[0.05 rgb <0.7, 0.5, 0.3>]
				[0.05 rgb _yell]
				[0.30 rgb 0.8*_yell]
				[0.50 rgb _yell]
				[0.70 rgb 0.8*_yell]
				[0.93 rgb _yell]
				[0.93 rgb <0.9, 0.9, 0.9>]
			}
		}
		normal {
			spotted 0.5
			slope_map {
				[0.05 <0,0>]
				[0.05 <0,1>]
				[0.93 <1,1>]
				[0.93 <1,0>]
			}
		}
		finish {
			ambient 0.3
			diffuse 0.7
			specular 0.8 roughness 0.001
		}
		scale 0.02
	}

#declare full_grass =
	texture {
		pigment {
			bozo
			scale 0.03 //3 //woah man! scale 3 really looks like forest!
			colour_map {
				[0.6	rgbt <0.6,1.0,0.0,1.0>]
				[0.6	rgbt <0.6,1.0,0.0,0.0>]
			}
		}
		finish {
			ambient 0.4
			diffuse 0.6
			//specular 0.8 roughness 0.02
		}
	}
	

#declare full_shrub =
	texture {
		pigment {
			bozo
			scale 1
			colour_map {
				[0.7	rgbt <0.5,0.6,0.0,1.0>]
				[0.7	rgbt <0.5,0.6,0.0,0.0>]
			}
		}
		finish {
			ambient 0.2
			diffuse 0.5
			//specular 0.1 roughness 0.6
		}
	}

#declare full_flowers =
	texture {
		pigment {
			hexagon pigment { rgb <1,1,0> },
							pigment {
								bozo
								scale 8
								colour_map {
									[0.8 rgb <1,0.25,5>]
									[0.8 rgb <0.25,0.5,1>]
								}
							},
							pigment {
								bozo   
								turbulence 0.2
								scale 8
								colour_map {
									[0.8 rgb <1,0.25,5>]
									[0.8 rgb <0.25,0.5,1>]
								}
							}
			turbulence 1
			scale 0.4
		}
		finish {
			ambient 0.4
			diffuse 0.6
		}
	}
	


#declare plaster_tex =
	texture {
		pigment {
			plaster_col
		}
		finish {
			test_finish
		}
		normal {
			bozo 1
			scale 0.4
			slope_map {
				[0.92	<0,0>]
				[0.92	<0,1>]
				[1.00	<1,1>]
			}
		}
	}

#declare turret_roof_tex =
	texture {
		pigment {
			turret_roof_col
		}
		finish {
			test_finish
		}
		normal {
			radial 1
			frequency 8
			slope_map {
				[0.0	<0,1>]
				[0.1	<1,0>]
				[0.9	<1,0>]
				[1.0	<0,-1>]
			}
		}
	}

#declare turret_body_tex = plaster_tex

#declare wall_tex =
	texture {
		pigment { wall_col }
		finish {
			test_finish
		}
		normal {
			radial 1
			frequency 40
			slope_map {
				[0.00 <0,0>]
				[0.00 <0,1>]
				[0.02 <1,1>]
				[0.02 <1,0>]
				[0.08 <1,0>]
				[0.08 <1,-1>]
				[0.10 <0,-1>]
				[0.10 <0,0>]
			}
		}
	}

#declare building1_roof_tex =
	texture {
		pigment {
			building1_roof_col
		}
		finish {
			test_finish
		}
		normal {
			gradient x 1
			slope_map {
				[0.0	<0,0>]
				[0.0	<0,1>]
				[0.3	<1,1>]
				[0.3	<1,0>]
				[0.7	<1,0>]
				[0.7	<1,-1>]
				[1.0	<0,-1>]
				[1.0	<0,0>]
			}
		}
	}

#declare building1_body_tex =
	texture {
		plaster_tex
		finish {
			ambient 0.25
		}
	}

#declare building2_roof_tex =
	texture {
		pigment {
			building2_roof_col
		}
		finish {
			test_finish
		}
	}

#declare building2_body_tex = plaster_tex

#declare tower_roof_tex =
	texture {
		pigment {
			tower_roof_col
		}
		finish {
			test_finish
		}
	}

#declare tower_room_tex = plaster_tex

#declare tower_body_tex = plaster_tex

#declare tower_cut_tex = plaster_tex

#declare inner_wall_tex =
	texture {
		plaster_tex
		finish {
			ambient 0.35
		}
	}

#declare inner_turret_tex =
	texture {
		plaster_tex
		finish {
			ambient 0.35
		}
	}


