// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

// ----------------------------------------

#declare f1 = function{sin(x*(15/(z+1))) + (y/((z/40)+0.1))}
#declare cape_base =
isosurface{
  function{f1(x,y,z)}
  eval
  contained_by{box{<-30,-2,0>,<30,2,40>}}
}

#declare cape_layer =
difference{
  object{cape_base}
  object{cape_base translate y*-0.001}
}

#declare cape =
difference{
  object{cape_layer}
  plane{x, 0 rotate y*-35}
  plane{-x, 0 rotate y*35}
  plane{-z, -39}
  sphere{0,3}
}
  
#declare cape_logo =
height_field{ // logo
  png "logo.png"
  smooth
  translate -0.5
  rotate y*180
  scale 6
  translate z*10
  translate y*-1
}
