// Persistence of Vision Ray Tracer Scene Description File
// File: f.inc
// Vers: 3.1g.wmp.0.6a
// Desc: f.o.s. include for fortress irtc
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;


// ----------------------------------------

#declare FPart_Base =
difference{
  box{
    0,1
    translate<-1/2,0,-1/2>
    scale 60 // 30
    translate y*-5
  }
  plane{
    y,0
    rotate x*115
    translate z*-10
  }
  plane{
    y,0
    rotate z*-100
    translate x*-15/2
  }
  plane{
    y,0
    rotate z*100
    translate x*15/2
  }
  plane{
    y,0
    rotate x*-100
    translate z*20 // 10
  }
}  

#declare FBase =
difference{
  union{
    difference{
      object{FPart_Base}
      object{FPart_Base scale<0.6,1.1,2>}
      object{FPart_Base scale<2,1.1,0.5>}
    }
    object{FPart_Base scale<0.9,1,0.9>}
  }
  box{<3,-3,-10>,<-3,5,0> rotate x*25} // door hole
  plane{-y,-10}
}

#declare Doors =
difference{
  box{<3,-3,-7.5>,<-3,5,0.0>} // door
  box{<0.05,-4,-8.0>,<-0.05,6,0.5>} // crack
  height_field{ // logo
    png "logo.png"
    smooth
    translate -0.5
    scale <5,1,5>
    rotate y*180
    rotate x*90
    translate<0,1,-7.6>
  }
  rotate x*25
}

#declare FullFort =
union{
  object{FBase}
  object{
    Doors
    texture{T_Chrome_2A}
    normal{granite 1/8 scale 1/8}
  }
  pigment{
    granite
    pigment_map{
      [0 Gray40]
      [1 Gray80]
    }
  }
  normal{granite 1}
}
