// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

// textures
#declare baseRockTex =
texture{
  pigment{granite pigment_map{[0 Gray20][1 Gray80]}}
  normal{
    average 2
    normal_map{
      [dents 30 scale 1 ]
      [granite 30 scale 1 turbulence 0.25]
      [marble 30 scale 1 turbulence 0.5]
      [crackle 30 scale 1 turbulence 0.5]
    }
  }
}

#declare snowTex =
texture{
  pigment{rgb<0.9,0.9,1.0>*1.5}
  finish{ambient 0.30 diffuse 0.7}
}

#declare rockTex =
texture{
  agate scale 0.05 turbulence 0.5
  texture_map{
    [0.960 baseRockTex]
    [0.965 snowTex]
  }
}  

#declare MBaseTex =
texture{
  slope y
  texture_map{
    [0.75 rockTex]
    [0.75 snowTex]
  }
}

/* not bad
#declare MountFunc = function{"ridgedMF" <0.8, 2, 5, 0.95, 1.1>}
#declare maxH = 5;
#declare MBase =
isosurface{
  function {y - MountFunc(x,0,z) * 1 * max(0.5,z)}
  eval
  contained_by{box{<-5,-0.1,-15>,<5,15,15>}}
  texture{pigment{Gray}} //texture{MBaseTex}
}
object{MBase scale<100,10,100> translate z*100}
*/

#declare MountFunc = function{"ridgedMF" <0.9, 2, 5, 0.75, 2>}
#declare MBase =
isosurface{
  function { y - MountFunc(x,0,z) * min(2, max(0.125,(sqr(x/5) + sqr(z/5)))) }
  eval
  max_gradient 50
  contained_by{box{<-20,-1,-20>,<20,4,20>}}
  texture{MBaseTex}
//  scale<150,65,150>
  scale<300,100,150>
}

