// Woods Macro
// Ash, DarkAsh, Maple, Oak, Cherry1-3, Piney, WalnutStain, BlackStain
// 1=knotty, 2=very smooth, 3=normal
// #declare WoodPigment=PickWood (name_map, #) 
// (c) 2000, tls -- freely redistributable

#declare Ash_map=
color_map {
  [0.0 color rgb <0.6549, 0.3647, 0.0706>]
  [0.1 color rgb <0.7059, 0.3804, 0.0824>]
  [0.2 color rgb <0.8431, 0.6118, 0.3372>]
  [0.7 color rgb <0.9137, 0.6824, 0.3765>]
  [0.9 color rgb <0.8431, 0.6118, 0.3372>]
  [1.0 color rgb <0.7059, 0.3804, 0.0824>]
  } 
  
#declare DarkAsh_map=
color_map {
  [0.0 color rgb <0.4314, 0.2275, 0.0000>]
  [0.1 color rgb <0.5647, 0.3294, 0.0941>]
  [0.3 color rgb <0.7647, 0.4745, 0.2196>]
  [0.8 color rgb <0.5647, 0.3294, 0.0941>]
  [0.9 color rgb <0.4314, 0.2275, 0.0000>]
  [1.0 color rgb <0.7647, 0.4745, 0.2196>]
  }

#declare Maple_map=
color_map {
  [0.0 color rgb <0.4471, 0.2196, 0.0706>]
  [0.2 color rgb <0.6549, 0.3843, 0.0784>]
  [0.4 color rgb <0.8313, 0.5804, 0.3294>]
  [0.5 color rgb <0.7569, 0.4784, 0.2343>]
  [0.7 color rgb <0.3882, 0.1569, 0.0235>]
  [1.0 color rgb <0.8431, 0.5843, 0.3450>]
  }

#declare Oak_map=
color_map {
  [0.00 color rgb <0.7411, 0.4588, 0.1294>]
  [0.35 color rgb <0.5569, 0.3686, 0.0784>]
  [0.55 color rgb <0.7882, 0.4902, 0.1960>]
  [0.85 color rgb <0.5569, 0.3686, 0.0784>]
  [1.00 color rgb <0.8392, 0.6667, 0.4118>]
  }

#declare Cherry1_map=
color_map {
  [0.10 color rgb <0.4941, 0.2784, 0.0157>]
  [0.30 color rgb <0.6000, 0.3373, 0.0196>]
  [0.45 color rgb <0.9411, 0.6627, 0.3412>]
  [0.55 color rgb <0.6706, 0.3608, 0.0589>]
  [0.75 color rgb <0.9609, 0.6196, 0.3059>]
  [1.00 color rgb <0.6000, 0.3373, 0.0196>]
  }

#declare WalnutStain_map=   
color_map {
  [0.0 color rgb <0.43529, 0.23922, 0.01569>]
  [0.1 color rgb <0.19608, 0.11765, 0.01176>]
  [0.5 color rgb <0.50980, 0.31765, 0.03529>]
  [0.6 color rgb <0.39608, 0.29020, 0.01961>]
  [0.9 color rgb <0.19608, 0.11765, 0.01176>]
  [1.0 color rgb <0.50980, 0.31765, 0.03529>]
  }

#declare Piney_map=
color_map {
  [0.0 color rgb <0.91373, 0.85882, 0.63922>]
  [0.2 color rgb <0.96078, 0.95294, 0.78039>]
  [0.7 color rgb <0.93333, 0.86667, 0.60000>]
  [1.0 color rgb <0.95686, 0.93333, 0.60784>]
  }

#declare BlackStain_map=
color_map {
  [0.0 color rgb <0.25098, 0.13725, 0.00000>]
  [0.3 color rgb <0.17647, 0.13725, 0.10588>]
  [0.5 color rgb <0.27059, 0.20784, 0.08235>]
  [0.7 color rgb <0.31373, 0.27059, 0.19608>]
  [0.8 color rgb <0.25098, 0.13725, 0.00000>]
  [1.0 color rgb <0.17647, 0.13725, 0.10588>]
  }
  
#declare Cherry2_map=
color_map {
  [0.0 color rgb <0.25098, 0.00000, 0.00000>]
  [0.3 color rgb <0.35294, 0.10588, 0.00000>]
  [0.7 color rgb <0.61569, 0.35294, 0.12549>]
  [0.8 color rgb <0.50980, 0.22745, 0.00000>]
  [1.0 color rgb <0.35294, 0.10588, 0.00000>]
  }

#declare Cherry3_map=
color_map { 
  [0.0 color rgb <0.31373, 0.08235, 0.00000>]
  [0.1 color rgb <0.25882, 0.04314, 0.00000>]
  [0.5 color rgb <0.14510, 0.01176, 0.00000>]
  [0.6 color rgb <0.31373, 0.06275, 0.00000>]
  [0.7 color rgb <0.27059, 0.06275, 0.07451>]
  [0.8 color rgb <0.31373, 0.08235, 0.00000>]
  [1.0 color rgb <0.25882, 0.04314, 0.00000>]
  }

#declare LamFuzzy=2.2;
#declare LamKnotty=0.4;
#declare LamOther=2;
#declare OctFuzzy=3;
#declare OctOther=6;
#declare TurbKnotty=0.07;
#declare TurbSmooth=0.03;
#declare TurbOther=0.05;
#declare OmegaStain=1.2;
#declare OmegaOther=0.5;

#macro PickWood (WoodMap, TurbType)
  #switch (TurbType)
    #case (1)
      #local MyLambda=LamKnotty;
      #local MyOctaves=OctOther;
      #local MyTurb=TurbKnotty;
      #local MyOmega=OmegaOther;
      #local UseWarp=1;
      #break
    #case (2)
      #local MyLambda=LamOther;
      #local MyOctaves=OctOther;
      #local MyTurb=TurbSmooth;
      #local MyOmega=OmegaOther;
      #local UseWarp=0;
      #break
    #else
      #local MyLambda=LamOther;
      #local MyOctaves=OctOther;
      #local MyTurb=TurbOther;
      #local MyOmega=OmegaOther;
      #local UseWarp=1;
    #end
  pigment {
    wood
    color_map { WoodMap }
    turbulence MyTurb
    lambda MyLambda
    octaves MyOctaves
    omega MyOmega
    #if (UseWarp)
     warp {
      black_hole <0.0, 0.25, 0.0>, .25
      strength 4
      falloff 2
      repeat 1.5
      inverse
      }
    #end
    scale <.25, .25, 1.0> 
    translate <1, 2, 1>
    }
  #end

