// Full scene in this file                                              
// "XVI: The Tower" -- (c) 2001, TLS (image and pieces thereof)
// Code made available for use or inspiration. If any code is
// directly used in other scenes, please credit the author.
// Permission is specifically granted to the IRTC to reproduce
// this code and the resulting image on their CD distributions.
// Permission to redistribute image or code is otherwise only
// granted if: a) such redistribution is without any fee AND
// b) All copyright information for this file and the 
// included files 0330tower.pov and 0330flames.pov is fully
// preserved. For all other redistribution please contact
// the author: youknow@ucan.foad.org
// -------------------------------------

#version unofficial MegaPov 0.7;  
#include "0330tower.pov" // home of the tower itself
#include "0330flames.pov" // home of the flame objects

global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end 0.04
    count 60
    nearest_count 5
    error_bound 2
    recursion_limit 3
    low_error_factor 0.5
    gray_threshold 0.0
    minimum_reuse 0.018
    brightness 1
    adc_bailout 0.01/1.75
    }
  assumed_gamma 1.8
  max_trace_level 7
  }

camera {
  location <2, 21.5, -125>
  //location <0, 55, -80>
  right x*70/95
  look_at <0, 35, -18>
  //look_at <0, 55, 0>
  } 


// Background and other details

#declare CloudsOut=1500;
#declare CloudsIn=1400;

#declare MoonSize=90;

#declare MoonLoc=<150, CloudsOut+165, CloudsOut*1.9>; 
#declare MoonShape=sphere { MoonLoc, MoonSize }

light_source { // the main light source is the moon
  MoonLoc
  color rgb <0.6, 0.6, 0.55>
  looks_like { MoonShape } 
  } 

light_source { // to illuminate the card face only
  <2, 21.5, -125>
  rgb 1
  fade_distance 15
  fade_power 2
  }

#declare TheMoon=
object { MoonShape
  normal { crackle 1 scale 30 }
  pigment { 
    bozo
    turbulence .05
    color_map {
      [0.1 rgbt <.7, .7, .7, .8>]
      [0.6 rgbt <.8, .8, .5, .8>]
      [1.0 rgbt <.3, .3, .3, .8>]
      } // end cmap
    scale 50
    } // end pigment
  finish { ambient 1.75 }
  no_shadow
  } 

#declare MoonAura=
object { MoonShape
  scale 1.15
  pigment { rgbt <1, 1, .9, .97> }
  no_shadow
  }

sky_sphere { 
  pigment {
    gradient y
    color_map {
      [0.000 rgb <0.08, 0.12, 0.35>]
      [0.001 rgb <0.04, 0.08, 0.30>]
      [0.002 rgb <0.0, 0.06, 0.25>]
      [0.003 rgb <0.0, 0.03, 0.20>]
      [0.025 rgb <0.0, 0.01, 0.10>]
      [0.055 rgb <0.0, 0.00, 0.05>]
      } // end cmap
    //scale 1
    translate -1
    rotate <-119, 3, 0>
    } // end pigment
  } // end sky_sphere

#declare CloudSphere=
difference { // this allows clouds to have shadows
  // and otherwise react to light
  sphere { 0, CloudsOut }
  sphere { 0, CloudsIn }
  hollow
  pigment {
    bozo
    turbulence .6
    lambda 2.3
    omega 0.8
    color_map {
      [0.15 rgbt <.95, .95, .95, .40> ]
      [0.45 rgbt <.80, .80, .80, .35>]
      [0.80 rgbt 1]
      } // end cmap
    scale 73
    rotate <145, 55, 13>
    } // end pigment
  finish { specular .9 roughness .7 diffuse .3 }
  interior { ior 1.4 }
  } // end difference

#declare Water=
cylinder { // water
  <0, -10, 0>, <0, -45, 0>, CloudsIn
  normal { waves 1 scale <20, 3, 3> }
  pigment { rgbt <0.15, 0.35, 0.6, 0.8> } // end pigment 
  finish { reflection 0.7 specular 0.4 roughness 0.8 diffuse 0.4 } 
  interior { ior 1.33 }
  bounded_by { sphere { 0, CloudsIn } } // to cut off appropriately
  }  

#declare UnderWater=
cylinder { // ground under water
  <0, -45, 0>, <0, -46, 0>, CloudsIn
  normal { ripples 1 scale <30, 1, 1> }
  pigment { rgb <.1, .1, .1> }
  finish { specular .3 roughness .3 }
  bounded_by { sphere { 0, CloudsIn } } // to cut off appropriately
  } 

#declare RockF1=function { noise3d(x*15, y*25, z*15) * 0.6 }
#declare RockF2=function { F_Box2 + sin(x*y) }

#declare BigRock=
isosurface {
  function { RockF2 + RockF1 }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 60
  contained_by { box { -2, 2 } }
  rotate <0, 10, 15>
  scale <23, 25, 20>
  translate <8, -23, 0>
  pigment { 
    bozo
    color_map {
      [0.0 rgb <.7, .6, .3>]
      [0.4 rgb <.5, .7, .3>]
      [0.8 rgb <.6, .6, .5>]
      [1.0 rgb .45]
      }
    scale 5
    }
  finish { specular .5 roughness .4 brilliance .5 }
  }

object { TheMoon }
object { CloudSphere }
object { Water }
object { UnderWater }
object { BigRock }
object { BrokenTower }

// Test Block

//object { SmRtWindow scale <1, 1, .1> hollow pigment { color rgbf <0, 1, 1, .5> } }
//object { SmLWindow scale <1, 1, .1> hollow pigment { color rgbf <0, 1, 1, .5> } }
//object { LgWindow scale <1, 1, .1> hollow pigment { color rgbf <0, 1, 1, .5> } }

// END test Block
 

object { Flame1 scale <3.5, 1.3, 1.3> translate <-1, YStep*(Layers*2/3) -4, -18> }
object { Flame1 scale 1.5 rotate y*180 translate <6.25, YStep*(Layers*2/3)-4, -19.8>  } 
object { Flame2 scale <1.9, 1.5, 1.5> translate <-6.5, YStep*(Layers*2/3)-4, -20.5> }

object { Flame2 scale 2 translate <0, YStep*(Layers*17/20)-5, -19>  }
object { Flame3 scale 1.5 rotate y*30 translate <3, YStep*(Layers*17/20) -3, -15>  }
object { Flame2 scale 1.7 rotate y*180 rotate x*-15
  translate <-1, YStep*(Layers*17/20) -4, -19.5>  } 

object { Flame3 scale 2.5 rotate y*75 translate <15, YStep*(Layers*17/20)-2, -10> }
object { Flame1 scale 2 rotate y*-15 translate <14, YStep*(Layers*17/20)-1, -14>}
object { Flame2 scale 2 translate <13, YStep*(Layers*17/20)+2.5, -5> }

object { Flame1 scale <5, 4, 3> translate <2, YStep*(Layers*2/3)-6, -3>  }


// flame light
light_source {
  <5, YStep*(Layers*2/3)+6, -15>
  color rgb <0.75, 0.4, 0.15>
  //area_light x, z, 4, 5
  //circular
  //orient
  fade_distance 12
  fade_power 2
  }

// And, now, finally, the card edges.
  

#include "TLSwoods"

#declare CardTexA=PickWood(WalnutStain_map,1)

#declare CardTex=
texture {
  CardTexA
  scale 1.5
  }                                          
                                          
#declare LetterTex=
texture {
  pigment { rgb <0.65, 1.0, 0.75> }
  finish { brilliance 1 ambient .3 }
  }

union { // around the entire card shape
box { // left edge 
  <-1, -25, -0.3>, <1, 25, 0.3>
  rotate z*2.7
  translate <-6.75, 20, -100>
  texture { CardTex rotate z*5}
  } 

box { // right edge
  <-1, -25, -0.3>, <1, 25, 0.3>
  rotate z*-2.7
  translate <9.75, 20.25, -100>
  texture { CardTex rotate <10, 5, 0> }
  } 


union {
box { // bottom
  <-9, -1, -0.3>, <10, 1, 0.3>
  texture { CardTex rotate <0, 5, 10> }
  } 
text {
  ttf "Schlbk.ttf"
  "THE TOWER"
  1, 0
  scale <1.5, 1.5, 0.5>
  translate <-2.5, -0.25, -0.9>
  texture { LetterTex }
  }
translate <-0.5, 13.5, -100>
}

union {
box { // top
  <-9, -1, -0.3>, <10, 1, 0.3> 
  rotate z*-1
  texture { CardTex }
  }
text {
  ttf "Schlbk.ttf"
  "XVI"
  1, 0 //x*0.05
  scale <1.5, 1.4, 0.5>
  translate <0.5, -0.9, -1.1>
  texture { LetterTex }
  }
translate <-0.3, 37.1, -100>
} // end XVI union

} // end cardshape union 



  
