// EXAMPLE SCENE FILE FOR ANT.INC

#version unofficial Megapov 0.5;

global_settings{max_trace_level 15 adc_bailout 1/64}

#include "ant.inc"
#include "finish.inc"
#include "colors.inc"

camera{
location <-5,5,-5>*1.4
look_at <0,-1,0>
angle 45
}

light_source{
<5,10,-10>
color .7}

light_source{
<0,40,-30>
color .7
}

light_source{
<-100,10,-0>
color .5
}

background{rgb .5}


#declare overall_seed=seed(1262329);

// example to set an individual ant:

#declare leg1left=array[5] {0,90,0,0,0}

set_leg_to_position(<-2.45,-1,-2.5>,<-3,-1,2>,<1,-1,-3>,<-1,-1,2>,<2,-1,-2>,<2,-1,3>)

#declare Ant_Type=1;
object{
make_ant()
rotate y*clock*360
translate <0,1,0>
scale .1

}

// example to create a group of ants:

#declare odd=0;
#declare ii=0;

#while(ii<4)
#declare ii=ii+.6;
#declare uu=ii*2*pi;

#declare odd=1-odd;
#declare i=0;
#while(i<int(uu/.7))
#declare i=i+1;
object{make_random_ant(rand(overall_seed)*1000,-0.75)
translate <0,0.75,0>
scale .1
rotate y*180*odd
translate <0,0,ii>
rotate y*360*i/(int(uu/.7))
}
#end


#end



box{<-1000,-.1,-1000>,<1000,0,1000>
pigment{
				color rgb <255,190,94>/256}
normal{
	crackle 1  scale .1
	}
}
