#version unofficial megapov 0.7;



// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 400;
#declare Rad_error = .03;
#declare Rad_rec = 1;
#declare Rad_bright = 1.0;

// area_light settings
#declare Use_area = on;
#declare Nb_area1 = 6;
#declare Nb_area2 = 6;
#declare Adap_area = 2;


#declare Use_Web1 = on;
#declare Use_Web2 = on;
#declare Use_spidey = off;
#declare Use_teddy = off;
#declare Use_ants = on;
#declare Use_fly = on;



#include "cbweb.inc"
#include "etagere.inc"


//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 30
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
//	assumed_gamma 1.5
	radiosity{
		count Rad_count
		nearest_count 3
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .005

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
	//ambient_light 0.0
#end
}

#if (Use_rad)
#default { texture { pigment {rgb <1, 0, 0>} finish { ambient -.15 diffuse 1.1 } } }
#else
#default { texture { pigment {rgb <1, 0, 0>} finish { ambient .3 diffuse .7 } } }
#end



camera {
	location <6, 3, -20>*2.5
	right x
	up y*1.618
	angle 30
	look_at <-10, 5, -5>
}

background { color rgb <.6, .6, .7>*.9 }

plane {y, -150 pigment {rgb .45}}

#if (Use_rad)
#local ColLight = <1.2, 1.2, 1>*.9;
#else
#local ColLight = <1.2, 1.2, 1>*1.3;
light_source {-300*z-100*x, color rgb<.6, .6, .7>*.3 shadowless }
#end

light_source { <50, 15, -20>, rgb ColLight
#if (Use_area)
	area_light z*10, y*10, Nb_area1, Nb_area2
	orient
	circular
	jitter
	adaptive Adap_area
#end
}


//===================================
//===================================
//	SCENE
//===================================
//===================================


#declare Etag = union {
	object {
		Etagere
		texture { T_Etagere rotate y*89 translate 5*y }
	}
	object {
		Equerre translate <-LargE*.5, -EpE, 0>
		texture { T_Etagere rotate z*89 translate -15*y }
	}
}

object { Etag }

#declare Mur1 = height_field {
	png "hfmur"
	rotate -x*90
	scale <10, 24, .1/4>*4
	translate <-35, -30, -.05>
	texture {
		pigment { rgb 1 }
		normal { granite .25 }
		finish { brilliance .75 }
	}
	texture {
		pigment {
			wrinkles scale 2
			warp { turbulence .3*y }
			scale 5
			color_map {
				[0 rgbf 1]
				[0.5 rgbf <.8, .7, .5, .7>]
				[0.8 rgbf <.7, .5, .3, .5>]
			}
		}
	}
	texture {
		pigment {
			wrinkles scale 1.5
			warp { turbulence .6*y }
			scale 1.5
			color_map {
				[0 rgbf 1]
				[0.5 rgbf <.8, .7, .5, .8>]
				[1.0 rgbf <.7, .5, .3, .5>]
			}
		}
	}
}

#declare Mur2 = plane { -z, -.2 pigment {rgb .9} }


union {
	object {Mur1}
	object {Mur2}
}



#if (Use_Web1)


#declare Obj = union { object {Etag} plane { -z, 0 } }

#declare test_web=off;
#declare nbranch = 11;
#declare rbranch = .02;
#declare nturns = 8;
#declare center = <-LargE*.25,-LargE*.25-EpE,-LargE*.2>;
#declare ra = .4;
#declare rs = 1342;
#declare endpoints = array[nbranch]
#declare distances = array[nbranch]
#declare link_looseness = .5;

#local st=seed(1342);
#local dir = <-LargE*.5, -EpE-LargE*.1, 0> - center;
#local _perp = <dir.y, -dir.x, 2>;
#local i=0;
#while (i<nbranch)
//	#debug concat("\ni=", str(i, 2,0), "\n")
	#local _dir = vaxis_rotate(_perp, dir, (i*(360/nbranch) + 20*rand(st)));
	#declare endpoints[i] = FindIntersection(center, _dir, 0, Obj, 10)
//	#debug concat("endpoints = < ", str(endpoints[i].x, 3,3), ", ", str(endpoints[i].y, 3,3), ", ", str(endpoints[i].z, 3,3), " >\n")
	#declare distances[i] = vlength(endpoints[i]-center)/(.5+nturns+mod(int(rand(st)*1635), 3));
	#local i=i+1;
#end

//#declare distances[11]=vlength(endpoints[11]-center)/(nturns+10);

object {
	SpiderWeb(nbranch, rbranch, center, endpoints, distances, ra, rs, nturns)
	texture {
		pigment {color rgb .75 transmit .3 }
		finish { ambient .2 diffuse .8 phong 0.9 phong_size 5 brilliance .8 }
	}
}

#end


#if (Use_teddy)

#include "Teddy.inc"

object { TeddyB
	translate -28*x
}

#end

#if (Use_spidey)

#include "spidey.inc"

#declare SpiderMan = object { Spidey
	scale 27
	rotate -y*9
	translate <-9, 0, -5>
}

object { SpiderMan }


#if (Use_Web2)


#declare test_web=off;
#declare nbranch = 7;
#declare rbranch = .02;
#declare nturns = 9;
#declare center = <-6.5,10,-4>;
#declare ra = .3;
#declare rs = 1342;
#declare endpoints = array[nbranch]
#declare distances = array[nbranch]
#declare link_looseness = .6;


#declare Obj = union { object {Etag} object {SpiderMan} plane { -z, 0 } }

#local _dir = vaxis_rotate(-15*z, -x, -4);
#declare endpoints[0] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-25*z, -x, 35)+5.0*x;
#declare endpoints[1] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-15*z, -x, 85);
#declare endpoints[2] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-15*z, -x, 120);
#declare endpoints[3] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-15*z, -x, -175);
#declare endpoints[4] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-15*z, -x, -120);
#declare endpoints[5] = FindIntersection(center, _dir, 0, Obj, 10)
#local _dir = vaxis_rotate(-25*z, -x, -40)-1.5*x;
#declare endpoints[6] = FindIntersection(center, _dir, 0, Obj, 10)

#declare distances[0]=vlength(endpoints[0]-center)/(nturns+0.2);
#declare distances[1]=vlength(endpoints[1]-center)/(nturns+0.9);
#declare distances[2]=vlength(endpoints[2]-center)/(nturns+1.5);
#declare distances[3]=vlength(endpoints[3]-center)/(nturns+1.5);
#declare distances[4]=vlength(endpoints[4]-center)/(nturns+0.2);
#declare distances[5]=vlength(endpoints[5]-center)/(nturns+1.5);
#declare distances[6]=vlength(endpoints[6]-center)/(nturns+1.7);

object {
	SpiderWeb(nbranch, rbranch, center, endpoints, distances, ra, rs, nturns)
	texture {
		pigment {color rgb .95 transmit .3 }
		finish { ambient .2 diffuse .8 phong 0.6 phong_size 6 brilliance .8 }
	}
}



#end



#end


#if (Use_ants)

#include "ant.inc"
#include "reorient.mcr"

#declare s_ant1 = seed(1342);
#declare s_ant2 = seed(1234);

#init_3d_spline {
	"ant_path1",
	<-1, 0, -1>,
	<-2, 0, -8>,
	<-1.1, 0, -16>,
	<-3, 0, -18>,
	<-8, 0, -17>,
	<-15, 0, -18>
	<-25, 0, -17>
}

#init_3d_spline {
	"ant_path2",
	<-.2, .2, -.02>,
	<.5, .4, -.02>,
	<1, -1, -.02>,
	<2, -8, -.02>,
	<0, -15, -.02>,
	<-1, -25, -.02>
	<-3, -35, -.02>
}


#local c=.02;
#while (c<.98)

	#local _pos = eval_3d_spline("ant_path1", c);
	#local _dir = vnormalize(eval_3d_spline("ant_path1", c+.019)-eval_3d_spline("ant_path1", c-.019));

	object{
		make_random_ant(rand(s_ant1)*1000,-0.75)
		translate <0,0.75,0>
		scale .17
		Reorient(-x, _dir)
		translate _pos
	}

	#local _pos = eval_3d_spline("ant_path2", c);
	#local _dir = vnormalize(eval_3d_spline("ant_path2", c+.019)-eval_3d_spline("ant_path2", c-.019));

	object{
		make_random_ant(rand(s_ant1)*1000,-0.75)
		translate <0,0.75,0>
		rotate -x*90
		scale .17
		Reorient(-x, _dir)
		translate _pos
	}

	#local c=c+.05+.1*rand(s_ant2);

#end

#end




#if (Use_fly)

#include "fly.inc"

object {
	Fly
	scale .35
	rotate -x*90
	rotate z*25
	translate <.5, 23, 0.02>
}


#end

