//=====================================================
// cbweb.inc
// spider web macro
// by Christophe Bouffartigue
// (tofbouf@oreka.com)
//=====================================================
// This include file uses a modified version
// of link.inc by Chris Colefax
//=====================================================
// Use and modify it freely
//=====================================================
#version unofficial megapov 0.7;


#declare test_cbweb_inc = off;


#macro SpiderWeb(Nbranch, Rbranch, Center, EndPoints, Distances, Ra, Rs, Nturns)

//===============================
// local variables initialization
//===============================
#local st = seed(Rs);
#local Dirs = array[Nbranch]
#local i=0;
#while (i<Nbranch)
	#local Dirs[i]=vnormalize(EndPoints[i]-Center);
	#local i=i+1;
#end
#ifndef (test_web)
	#declare test_web=off;
#end

#if (test_web=off)
	#declare link_object = union { cylinder{-1.5*Rbranch*x, 1.5*Rbranch*x, Rbranch} sphere {1.5*Rbranch*x, Rbranch} }
	#declare link_size = 3*Rbranch;
	#declare scale_links = false;
#end

union {
	//======================
	// branches of the web
	//======================
	#local i=0;
	#while (i<Nbranch)
		cylinder {Center, EndPoints[i], Rbranch}
		#local i=i+1;
	#end

	#local i=0;
	#local imax = Nbranch*Nturns;
	#local link_point1 = Center + Dirs[0]*(Distances[0]*1/Nbranch + Ra*rand(st));
	#while (i<imax)

		//====================
		// loop variables init
		//====================
		#local i=i+1;
		#local numbr = mod(i, Nbranch);
		#local link_point2 = Center + Dirs[numbr]*(Distances[numbr]*(i+1)/Nbranch + Ra*rand(st));

		#if (test_web)
			//=================
			// just a cylinder
			//=================
			cylinder {link_point1, link_point2, Rbranch}
		#else
			//=================
			// use a link
			//=================
			#include "link.inc"
		#end

		#local link_point1 = link_point2;
	#end

}

#end


#macro FindIntersection(Start, Dir, Radius, Object, MaxTry)

#local st = seed(vlength(Dir)*Radius*1234);
#local i = MaxTry;
#local IntersectionFound = Start;
#local Norm = <0, 0, 0>;
#local _dir = vnormalize(Dir);
#local _turb = vnormalize(<_dir.y, -_dir.x, 0>);
#local _rad = abs(Radius);
#if (_rad>89.9) #local _rad=89.9; #end
#local _maxt = tan(_rad);

	#while ((i!=0) & (Norm.x=0) & (Norm.y=0) & (Norm.z=0))
		#local _dir2 = _dir + _maxt*rand(st)*vaxis_rotate(_turb, _dir, mod(int(rand(st)*53243), 360));
		#local IntersectionFound = trace(Object, Start, _dir2, Norm);
		#local i=i-1;
	#end
	#if ((Norm.x=0) & (Norm.y=0) & (Norm.z=0))
		#error "FindIntersection(): intersection not found !!!!\n"
	#else
		(IntersectionFound);
	#end
#end




#if (test_cbweb_inc)

#declare test_web=off;
#declare nbranch = 8;
#declare rbranch = .002;
#declare nturns = 11;
#declare center = <1,-1,-1>/sqrt(2);
#declare ra = .05;
#declare rs = 1234;
#declare endpoints = array[nbranch]
#declare distances = array[nbranch]
#declare link_looseness = .5;


#declare Murs = union {
	box {<-1, -10, -10>, <0, 1, 1> pigment {color rgb<.75, .82,1>}}
	box {<-1, 0, -10>, <10, 1, 1>}
	box {<-1, -10, 0>, <10, 1, 1> pigment {color rgb<.75, .82,1>}}
}


#local st=seed(1342);
#local _perp = <center.y, -center.x, 0> - .1*center;
#local i=0;
#while (i<nbranch)
	#local _dir = vaxis_rotate(_perp, center, i*(360/nbranch) + 20*rand(st));
	#declare endpoints[i] = FindIntersection(center, _dir, 7, Murs, 3)
	#declare distances[i] = vlength(endpoints[i]-center)/(nturns+1+mod(int(rand(st)*1635), 3));
	#local i=i+1;
#end

#declare distances[7] = vlength(endpoints[7]-center)/(nturns+5);

object { Murs
	texture {
		pigment { rgb 1.1 }
		normal { granite .1 scale .02 }
		finish { ambient .2 diffuse .8 }
	}
}

object {
	SpiderWeb(nbranch, rbranch, center, endpoints, distances, ra, rs, nturns)
	texture {
		pigment {color rgb .75 transmit .3 }
		finish { ambient .2 diffuse .8 phong 0.9 phong_size 5 brilliance .8 }
	}
}

light_source { <9, -.05, -5>, color rgb <1.2, 1.15, 1>
	area_light 1.5*x, 1.5*y, 4, 4
	orient
	circular
	jitter
	adaptive 1
}

light_source { <-1,-20,-1>, color rgb .2 shadowless}

camera {
	location <3,-2.7,-6>*1.5
	angle 30
	look_at <.5, -.4, 0>
}

#end

