// Cobweb Scene File
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { right 4/3*x
         location < 0, 0, -200 >
	 look_at < 0,0,0 >
	 angle 50
}

light_source { < 200,340,-400 > color rgb 1 fade_distance 400 fade_power 1 }
light_source { < 100, 600, -200 > color rgb 0.5 shadowless }
light_source { <   0, 300, -400 > color rgb 0.5 shadowless }

//
coordinate_color( 240, 0.3, 0.3, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
coordinate_color(360,0,0.85,1,4)
coordinate_color(360,0,0.75,1,5)
#local P_cloud =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.1 color rgb < R4,G4,B4 > color rgb < R5,G5,B5 > ]
                       [0.1,0.5 color rgb < R5,G5,B5 > color rgbf <1,1,1,1> ]
                       [0.5,1.001 color rgbf <1,1,1,1> color rgbf <1,1,1,1> ] }
           scale <6,1,6>  
 }
//
coordinate_color(160,0.2,0.4,1,1)
sky_sphere { pigment { color rgb < R1, G1, B1 > } pigment { P_cloud } rotate 180*y }
//
coordinate_color( 0, 1.0, 0.5, 1, 2 )
#local M_media =
media { emission rgb 0.03
             intervals 40
             samples on,1
             confidence 0.9
             variance 0.1
             density { waves
                       turbulence 0.5
                       octaves 6
                       omega 0.58
                       lambda 2
                       color_map { [0.00 rgbt <0,0,0,1> ]
                                   [0.42 rgbt <0,0,0,1> ]
                                   [0.50 rgb <R2,G2,B2> ]
                                   [0.58 rgbt <0,0,0,1> ]
                                   [1.00 rgbt <0,0,0,1> ] } translate -9.6*y scale 50 }
} 
sphere { < 0, 0, 0 >,30 hollow on
 pigment { color rgbt < 1, 1, 1, 1 > }
 interior { media { M_media } }
 scale 5
 translate 400*z
}
//**********************************************************************************
// wing
#local Bfly_w01 =
prism {
 linear_sweep
 bezier_spline 0,1,60
 <-0.994,0.005><-0.991,0.185><-0.811,0.459><-0.616,0.685>
 <-0.616,0.685><-0.421,0.911><-0.288,1><-0.024,1.138>
 <-0.024,1.138><0.24,1.277><0.485,1.33><0.701,1.375>
 <0.701,1.375><0.917,1.421><1.099,1.439><1.25,1.43>
 <1.25,1.43><1.401,1.421><1.573,1.405><1.62,1.35>
 <1.62,1.35><1.667,1.295><1.657,1.237><1.63,1.17>
 <1.63,1.17><1.603,1.103><1.479,1.045><1.39,0.95>
 <1.39,0.95><1.301,0.855><1.235,0.803><1.17,0.68>
 <1.17,0.68><1.105,0.557><1.048,0.282><1.02,0.16>
 <1.02,0.16><0.992,0.038><1.01,-0.032><0.967,-0.149>
 <0.967,-0.149><0.923,-0.267><0.887,-0.41><0.752,-0.51>
 <0.752,-0.51><0.618,-0.61><0.44,-0.626><0.221,-0.644>
 <0.221,-0.644><0.003,-0.662><-0.262,-0.639><-0.422,-0.592>
 <-0.422,-0.592><-0.582,-0.546><-0.673,-0.515><-0.79,-0.397>
 <-0.79,-0.397><-0.907,-0.278><-0.997,-0.175><-0.994,0.005>
 scale < 1,0.01,1 > rotate -90*x
}
#local Bfly_w02 =
prism {
 linear_sweep
 bezier_spline 0,1,128
 <-0.86,-0.27><-0.861,-0.131><-0.641,0.017><-0.48,0.11>
 <-0.48,0.11><-0.319,0.203><-0.214,0.202><-0.03,0.23>
 <-0.03,0.23><0.154,0.258><0.324,0.269><0.52,0.25>
 <0.52,0.25><0.716,0.231><0.869,0.214><1,0.14>
 <1,0.14><1.131,0.066><1.21,-0.051><1.26,-0.13>
 <1.26,-0.13><1.31,-0.209><1.321,-0.276><1.34,-0.35>
 <1.34,-0.35><1.359,-0.424><1.331,-0.474><1.37,-0.54>
 <1.37,-0.54><1.409,-0.606><1.504,-0.654><1.6,-0.72>
 <1.6,-0.72><1.696,-0.786><1.819,-0.865><1.97,-0.94>
 <1.97,-0.94><2.121,-1.015><2.31,-1.054><2.36,-1.1>
 <2.36,-1.1><2.41,-1.146><2.444,-1.196><2.44,-1.25>
 <2.44,-1.25><2.436,-1.304><2.41,-1.338><2.36,-1.36>
 <2.36,-1.36><2.31,-1.382><2.242,-1.366><2.17,-1.34>
 <2.17,-1.34><2.098,-1.314><1.978,-1.222><1.86,-1.13>
 <1.86,-1.13><1.742,-1.038><1.624,-0.912><1.55,-0.85>
 <1.55,-0.85><1.476,-0.788><1.401,-0.685><1.36,-0.7>
 <1.36,-0.7><1.319,-0.715><1.348,-0.796><1.33,-0.85>
 <1.33,-0.85><1.312,-0.904><1.264,-0.923><1.27,-0.98>
 <1.27,-0.98><1.276,-1.037><1.318,-1.057><1.36,-1.1>
 <1.36,-1.1><1.402,-1.143><1.59,-1.261><1.62,-1.31>
 <1.62,-1.31><1.65,-1.359><1.68,-1.417><1.65,-1.45>
 <1.65,-1.45><1.62,-1.483><1.559,-1.458><1.51,-1.43>
 <1.51,-1.43><1.461,-1.402><1.36,-1.248><1.32,-1.2>
 <1.32,-1.2><1.28,-1.152><1.277,-1.081><1.22,-1.08>
 <1.22,-1.08><1.163,-1.079><1.161,-1.174><1.1,-1.21>
 <1.1,-1.21><1.039,-1.246><0.965,-1.266><0.87,-1.27>
 <0.87,-1.27><0.775,-1.274><0.653,-1.263><0.53,-1.21>
 <0.53,-1.21><0.407,-1.157><0.362,-1.098><0.26,-1.01>
 <0.26,-1.01><0.158,-0.922><0.107,-0.827><0.01,-0.76>
 <0.01,-0.76><-0.087,-0.693><-0.15,-0.684><-0.26,-0.64>
 <-0.26,-0.64><-0.37,-0.596><-0.477,-0.596><-0.6,-0.52>
 <-0.6,-0.52><-0.723,-0.444><-0.859,-0.409><-0.86,-0.27>
 scale < 1,0.01,1 > rotate -90*x
}
//
#local Bfly_Rw = union { object { Bfly_w01 } object { Bfly_w02 translate  0.1*z rotate < 2,-2,0 > no_shadow } }
#local Bfly_Lw = union { object { Bfly_w01 } object { Bfly_w02 translate -0.1*z rotate <-2, 2,0 > } }
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
// space line functions
#macro Line_function(Tp,Vp,Func_type)
 #switch(Func_type)
  #case(0) #local Px=0; #local Py=5*Tp; #local Pz=0; #break
  #case(1) #local Px=Tp; #local Py=cos(Tp); #local Pz=0; #break           // Butterfly
  #case(11) #local Px=26*Tp; #local Py=sqrt(3)*26*Tp; #local Pz=0; #break // Spider thread
  #case(12) #local Px=25*Tp; #local Py=pow(Tp,2); #local Pz=0; #break
 #end
 #local Vp=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
#local Bfly_head = union { Cone_line(1/3,pi*< -1/6, 1/6, 1/12 >,pi*< -1/8, 1/4, 0 >,1) }
#local Bfly_abdomen = union { Cone_line(1/3.4,pi*< -1/6, 1/3, 1/12 >,pi*< -1/8, 1/4, 0 >,1) }
#local Bfly_touch = union { Cone_line(1/16,pi*< 0, 1, 1/12 >,pi*< 0, 1/4, 0 >,1) }
//
#local Bfly_leg01 = union { Cone_line(1/13,pi*< 0, 1/4, 1/12 >,pi*< 0, 1/4, 0 >,1) }
#local Bfly_leg02 = union { Cone_line(1/14,pi*< 0, 1/4, 1/12 >,pi*< 0, 1/4, 0 >,1) }
#local Bfly_leg03 = union { Cone_line(1/15,pi*< 0, 1/3, 1/12 >,pi*< 0, 1/4, 0 >,1) }
#local Bfly_leg04 = union { Cone_line(1/16,pi*< 0, 1/6, 1/12 >,pi*< 0, 1/4, 0 >,1) }
#local Bfly_Rleg =
union {
 object { Bfly_leg01 rotate < 0,-20,-50 > translate < -1.04,1.08,-0.25+0.23 > }
 object { Bfly_leg02 rotate 190*y translate 0.23*z }
 object { Bfly_leg03 rotate -50*z translate < -1.59,0.06,0.16+0.23 > }
 object { Bfly_leg04 rotate <0,182,80 > translate < 0.47,-0.58,0.13+0.23 > }
}
#local Bfly_Lleg =
union {
 object { Bfly_leg01 rotate < 0,20,-50 > translate < -1.04,1.08,0.25-0.23 > }
 object { Bfly_leg02 rotate 170*y translate -0.23*z }
 object { Bfly_leg03 rotate -50*z translate < -1.59,0.06,-0.16-0.23 > }
 object { Bfly_leg04 rotate <0,178,80 > translate < 0.47,-0.58,-0.13-0.23 > }
}
//----------------------------------------------------------------------------------
coordinate_color( 30,1.0,0.80,1,1)
coordinate_color( 30,0.2,0.30,1,2)
coordinate_color(270,1.0,0.78,3,3)
#local T_wing =
texture {
 pigment { wood
           turbulence 3
           color_map { [0.0 rgbt <R1,G1,B1,0.3> ]
                       [0.3 rgbt <R2,G2,B2,0.3> ]
                       [0.5 rgbt <R3,G3,B3,0.3> ]
                       [0.7 rgbt <R2,G2,B2,0.3> ]
                       [1.0 rgbt <R1,G1,B1,0.3> ] } scale <16,8,11>*1.4 rotate 10*z translate <-1.2,1.2,0 > }
 normal { bumps 0.1 scale < 0.1, 0.1, 1.0 > }
 finish { reflection 0.1 brilliance 0.9 diffuse 0.6 }
}
#local P_eye = pigment { hexagon color <R1,G1,B1> color <R2,G2,B2> color <R3,G3,B3> scale 0.01 }
#local T_tou =
texture {
 pigment { color rgb <R2,G2,B2>*1.6 }
 finish { reflection 0.1 brilliance 0.9 diffuse 0.6 }
}
//
coordinate_color(30,1,0.84,1,4)
#local T_abd =
texture {
 pigment { color rgb <R4,G4,B4> }
 normal { bumps 0.3 scale 0.1 }
 finish { reflection 0.1 brilliance 0.9 diffuse 0.6 }
}
#local T_leg =
texture {
 pigment { color rgbt <R4,G4,B4,0.5> }
 normal { bumps 0.3 scale 0.1 }
 finish { reflection 0.1 brilliance 0.9 diffuse 0.6 }
}
//----------------------------------------------------------------------------------
#local Butterfly =
union {
 union {
  object { Bfly_Rw texture { T_wing } translate  0.87*z rotate < 40,-26,20 > }
  object { Bfly_Lw texture { T_wing } translate -0.87*z rotate <-40, 26,20 > }
  rotate -24*z scale 24 translate < 5.5,14.2,0 >
 }
 union {
  object { Bfly_touch texture { T_tou } rotate < 0,190,-60 > translate < -2,-0.6, 0.2 > }
  object { Bfly_touch texture { T_tou } rotate < 0,170,-60 > translate < -2,-0.6,-0.2 > }
  sphere { < -1.3,-0.2, 0.2 >, 0.13 pigment { P_eye } } // R_eye
  sphere { < -1.3,-0.2,-0.2 >, 0.13 pigment { P_eye } } // L_eye
  object { Bfly_head texture { T_abd } rotate < 0,180,-20 > translate < -1.1,-1.3,0 > }
  object { Bfly_abdomen texture { T_abd } rotate -40*z translate < -0.7,-1.5,0 > }
  scale 12 translate < -8,-5,0 >
 }
 union {
  object { Bfly_Rleg translate <-24,-16,0 >*1/12 }
  object { Bfly_Rleg translate <-19,-20,0 >*1/12 }
  object { Bfly_Rleg translate <-14,-24,0 >*1/12 }
  texture { T_leg }
  scale 6 translate < -8,-11,3 >
 }
 union {
  object { Bfly_Lleg translate <-24,-16,0 >*1/12 }
  object { Bfly_Lleg translate <-19,-20,0 >*1/12 }
  object { Bfly_Lleg translate <-14,-24,0 >*1/12 }
  texture { T_leg }
  scale 6 translate <-8,-11,-3 >
 }
}
object { Butterfly rotate 135*y translate < -25,22, -5 > }
//**********************************************************************************
#local Spider_thread = union { Space_line(0.5,pi*< -5,0,1 >,11) }
#local Spider_th01 = union { Space_line(1.2,pi*< -1,1,1 >,12) }
#local Spider_th02 = union { Space_line(0.9,pi*< -1,1,1 >,12) }
#local Spider_th03 = union { Space_line(0.8,pi*< -1,1,1 >,12) }
#local Spider_th04 = union { Space_line(0.7,pi*< -1,1,1 >,12) }
#local Spider_th05 = union { Space_line(0.6,pi*< -1,1,1 >,12) }
#local Spider_th06 = union { Space_line(0.5,pi*< -1,1,1 >,12) }
#local Spider_th07 = union { Space_line(0.4,pi*< -1,1,1 >,12) }
#local Spider_th08 = union { Space_line(0.3,pi*< -1,1,1 >,12) }
//
#local Spiders_web =
union {
 #local Ei=6; #local Si=0; #while(Si<Ei)
  object { Spider_thread scale 0.5 rotate 360*Si/Ei*z }
 #local Si=Si+1; #end
 #local Ei=6; #local Si=0; #while(Si<Ei)
  object { Spider_th01 scale 1/10 translate 128*1/10*y rotate 360*Si/Ei*z }
  object { Spider_th02 scale 2/10 translate 128*2/10*y rotate 360*Si/Ei*z }
  object { Spider_th03 scale 3/10 translate 128*3/10*y rotate 360*Si/Ei*z }
  object { Spider_th04 scale 4/10 translate 128*4/10*y rotate 360*Si/Ei*z }
  object { Spider_th05 scale 5/10 translate 128*5/10*y rotate 360*Si/Ei*z }
  object { Spider_th06 scale 6/10 translate 128*6/10*y rotate 360*Si/Ei*z }
  object { Spider_th07 scale 7/10 translate 128*7/10*y rotate 360*Si/Ei*z }
  object { Spider_th08 scale 8/10 translate 128*8/10*y rotate 360*Si/Ei*z }
 #local Si=Si+1; #end
 pigment { color rgbt < 1,1,1,0.2 > }
 finish { reflection 0.1 brilliance 0.9 diffuse 0.6 }
}
object { Spiders_web rotate < 0,30,15 > translate < 100,46,100 > }
//**********************************************************************************
#include "Azalea_white.def.inc"
object { Azalea_white scale 1.5 rotate < -20, -44.6, 0 > translate < 56.8,-34,50 > }
object { Azalea_white scale 1.5 rotate < -20,  50, 0 > translate <-24.4,-42,60 > }
//
#include "Azalea_red.def.inc"
object { Azalea_red scale 1.5 rotate < -20, 75, 0 > translate < -89.4,-59.8,115 > }
//**********************************************************************************


// Signature
//#include "Sealpositive.sgn.inc"
#local Ls=< 0, 0, -200 >; #local La=< 0, 0, 0 >; #local Ag=50;
#local Tz=-60; #local Ty=(Ls.z-Tz)*sin(radians(Ag/2)); #local Tx=Ty;
#local Rx=degrees(atan2((Ls.y-La.y),sqrt(pow((Ls.x-La.x),2)+pow((Ls.z-La.z),2))));
#local Ry=180+degrees(atan2((Ls.x-La.x),(Ls.z-La.z))); #local Rz=0;
//object { Sealing scale 0.6 translate < Tx-2,Ty*3/4-1,Tz > rotate < Rx,Ry,Rz > }