//Standard include files
#include "colors.inc"
#include "textures.inc"
#include "stoneold.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"

//local files

#include "geometric.inc"
#include "spidersnet.inc"
#include "dragonfly.inc"
#include "grass.inc"
light_source { < 5,10,-60> color red 1 green 1 blue 1 }
//--------------------------------------------------------------------------------------------------------------------
camera
{
  location  <0.0,10,-8> // position of camera <X Y Z>
  look_at <0.0,0,50>
  //look_at <0.0,0,-50>
}
//--------------------------------------------------------------------------------------------------------------------
intersection
{
 plane{<0,1,0>,-1}
 plane{<0,0,1>,0}
 pigment{color Green}
}
#declare the_sun =
pigment {
gradient y
color_map {
[0.000 color rgbt <0.75, 0.75, 0.75, 0>]
[0.0003 color rgbt <0.75, 0.75, 0.75, 0.1>]
[0.0005 color rgbt <0.5,0.5,0.5, .2>]
//[0.005 color rgbt <0.4,0.4,0.4, .2>]
[0.05 color rgbt <0.4, 0.4, 0.4, .5>]
[1 color rgbt <1, 1, 1, 1>]
}
scale 2
translate -1
rotate -101*x
rotate 7.5*y
}
light_source {<0, -2000, 0> color rgb <1, .997, .97>/4 rotate -101*x rotate 7.5*y} 

#declare the_gradient =
pigment {
gradient y
color_map {
[0 color rgbt <0.1,0.1,0.2,0.2>]
[1 color rgb <0.0, 0.0, 0>]
}
}
#declare cloud_layer =
pigment {
wrinkles
turbulence .5
octaves 6
lambda 6 //3 to 6
omega 0.6 //0.2 to 0.6
color_map {
[0 color rgbt <1, 1, 1, 1>]
[0.5 color rgbt <0.7, 0.7, 0.7, .8>]
[1 color rgbt <1, 1, 1, 1>]
}
scale <.8, .1, .8>
}


fog {
distance 500
colour rgb<0.6-0.5, 0.6-0.5, .6-0.5>//, .66>
fog_type 2
fog_offset 1
fog_alt 10
}

fog {
distance 500
colour rgbt<0.6-0.4, 0.62-0.4, .6-0.4, .66>
fog_type 2
fog_offset 20
fog_alt 10
turbulence 0.2
turb_depth 0.2
}

fog {
distance 500
color rgbt <.68-0.4,.7-0.4,.68-0.4, .66>
fog_type 2
fog_offset 40
fog_alt 20
turbulence 0.1
turb_depth 0.2
}


sky_sphere
{
 pigment
 {
  gradient y
  color_map
  {
   [0.1 color rgb<0,0,0>]
   [0.7 color rgb<0.5,0.5,0.5>]
  }
  scale 2
 }
 pigment{the_sun}
 pigment
 {
  wrinkles
  color_map
  {
   [0.1 color rgbt<0.2,0.15,0.15,0.4>]
   [0.8 color rgbt<1,1,1,1>]
  }
  translate<100,0,0>
  scale <0.5,0.1,0.1>
 }
 pigment
 {
  wrinkles
  color_map
  {
   [0.1 color rgbt<0.1,0.1,0.1,0.3>]
   [0.8 color rgbt<1,1,1,1>]
  }
  scale <0.5,0.1,0.1>
 }
}

plane
{
 <0,1,0>,-2
 texture
 {
  pigment{color rgbf <1, 1, 1, 1>} 
  normal
  {
   gradient z//ripples scale 3000 frequency 5000 
   turbulence 0.4
   slope_map
   {
     [0   <0, 0>]
     [0.25 <0.5,1>]
     [0.5 <1, 0>]
     [0.75 <0.5,-1>]
     [1   <0,0>]
    }
    scale 4
   normal_map
   {[0
   onion//gradient z
   turbulence 0.6
   slope_map
   {
     [0   <0, 0>]
     [0.25 <0.5,1>]
     [0.5 <1, 0>]
     [0.75 <0.5,-1>]
     [1   <0,0>]
    }
    scale 1
    translate<-3.5,0,1.2>
   ]
   [
   1
   onion//gradient z
   turbulence 0.6
   slope_map
   {
     [0   <0, 0>]
     [0.25 <0.5,1>]
     [0.5 <1, 0>]
     [0.75 <0.5,-1>]
     [1   <0,0>]
    }
    scale 1
    translate<5,0,9>
   ] 
  }
 } 
  finish{phong 1 phong_size 90 diffuse 0 reflection .5}//ambient 0 diffuse 0 reflection 0.8}}
 } 
 interior
 { 
  ior 1.33
  media
  {
   absorption <.1, .05, .05>
   samples 2, 2
  }
 }
 hollow
}
plane {y, -20 pigment {color White}}


 
Spinnen_Netz(<-6,6,0.1>,<-7,11.5,-1.9>,<-2,12.5,0.1>,3,3,3,0.015,5,0.02)
Spinnen_Netz(<0,3.8,0>,<10,3.8,0>,<6,14,4>,3,3,3,0.015,5,0.02)
Spinnen_Netz(<-10,3,-1>,<0,3,0>,<-15,5,11>,3,3,3,0.015,5,0.02)

union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<-3.6+0.04*Counter,-8,2>,<-3.6,4.5,2.2>,<-3.5,0,20>,10,0.04,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture}
}

union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<-4+0.04*Counter,-8,7>,<-4,4.5,7.4>,<-6,0,20>,10,0.05,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture}
}

union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<-11+0.04*Counter,-8,10>, <-11,5,14>,<-11,7,30>,10,0.05,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture }
}
union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<6+0.04*Counter,-8,8>,<6,4.5,8.4>,<6,0,20>,10,0.04,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture}
}

union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<5+0.04*Counter,-8,12>,<5,4.5,12.4>,<5,0,20>,10,0.04,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture}
}

union
{
 #local Counter = 0;
 #while(Counter<10)
  Grass_Bogen(<11+0.04*Counter,-8,14>,<11,4.5,14.4>,<5,0,20>,15,0.04,0.03,10)
  #local Counter =Counter+1;
 #end 
 texture{Grass_Texture}
}

object{Libelle(20,-2) scale 3 rotate<19,0,0> rotate<0,13+180,0> translate<-0.5,8,1.1>}
object{Libelle(30,-20) scale 3 rotate<0,0,0> rotate<0,-40+180,0> translate<-28,0,45>}
object{Libelle(10,-3) scale 3 rotate<0,0,0> rotate<0,32+180,0> translate<30,-1.5,55>}
union
{
 object{Libelle_Koerper}
 object{Libelle_Fluegel_Shape_1o rotate<0,0,0> translate<1,0.01,-0.01>}
 object{Libelle_Fluegel_Shape_2o rotate<0,0,0> translate<-0.04,0.01,-0.01>}
 object{Libelle_Fluegel_Shape_1u rotate<0,0,0> translate<0.04,-0.03,0>}
 object{Libelle_Fluegel_Shape_2u rotate<0,0,0> translate<-0.04,-0.03,0>}
 scale 3
 translate<0,-2.1,20>
}


