//@--------Robot Insect Maker-----------------------------------------------------

#ifdef (GKinfest_Inc_Temp)
  //do nothing
#else
  #declare GKinfest_Inc_Temp = version;
  #ifdef (View_POV_Include_Stack)
    #debug "including GKinfest.inc\n"
  #end

//  #declares various robot insect models
//
//  RobotAnt                  robot ant facing +X, radius~5
//  RobotBeetle               robot beetle facing +X, radius~1
//  RobotBeetle_buzzsaw       as above, but with a buzzsaw attached
//  laser_RobotAnt            facing +X, length 3;rotate around Y-axis, then apply same transformations as target RobotAnt
//  RobotSpider               robot spider facing +X, radius~2
//  laser_RobotSpider         facing +X, length 1.5;rotate around Y-axis, then apply same transformations as target RobotSpider
//
//  Necessary Textures:
//
//  RobotMetalTex    (default texture{ T_Chrome_2A })                       used for metal parts of robot
//  RobotEyeTex      (default texture{ pigment{ White } })                  used for robot's eyes
//  RobotPaint1Tex   (default texture{ pigment{ Black } })                  used to decorate robot
//  RobotPaint2Tex   (default texture{ pigment{ Red } })                    used to decorate robot

//@--------Secondary Includes-----------------------------------------------------

#include "colors.inc"
#include "metals.inc"

//@--------Textures--------------------------------------------------------------

//set default textures, if not already present
#ifndef(RobotMetalTex)
  #declare RobotMetalTex = texture{ T_Chrome_2A };
#end
#ifndef(RobotEyeTex)
  #declare RobotEyeTex = texture{ pigment{ White } };
#end
#ifndef(RobotPaint1Tex)
  #declare RobotPaint1Tex = texture{ pigment{ Black } };
#end
#ifndef(RobotPaint2Tex)
  #declare RobotPaint2Tex = texture{ pigment{ Red } };
#end

//@--------Declares---------------------------------------------------------------

#declare RandSeed = seed(22);
#declare Rand1 = y*(20*rand(RandSeed))-10;
#declare Rand2 = y*(20*rand(RandSeed))-10;
#declare Rand3 = y*(20*rand(RandSeed))-10;

#declare AntKnee1 = (< 0, 0,-1.5> + vrotate(<-.5, 2,-1.5>,   Rand1));
#declare AntKnee2 = (< 0, 0,-1.5> + vrotate(< 1.5, 2,-1.5>,  Rand2)); 
#declare AntKnee3 = (< 0, 0,-1.5> + vrotate(< 3.75, 2,-1.5>, Rand3));

#declare AntKnee4 = (< 0, 0, 1.5> + vrotate(<-.5, 2, 1.5>,   Rand1));
#declare AntKnee5 = (< 0, 0, 1.5> + vrotate(< 1.5, 2, 1.5>,  Rand2));
#declare AntKnee6 = (< 0, 0, 1.5> + vrotate(< 3.75, 2, 1.5>, Rand3));

#declare Rand1 = y*(30*rand(RandSeed))-05;
#declare Rand2 = y*(30*rand(RandSeed))-20;
#declare Rand3 = y*(30*rand(RandSeed))-20;
#declare Rand4 = y*(30*rand(RandSeed))-25;

#declare SpiderKnee1 = (< 0, 2,-1.5> + vrotate(<-1.25, .75,-2>,  Rand1));
#declare SpiderKnee2 = (< 0, 2,-1.5> + vrotate(<-.5, .5,-2.25>,  Rand2));
#declare SpiderKnee3 = (< 0, 2,-1.5> + vrotate(< .5, .25,-2.25>, Rand3));
#declare SpiderKnee4 = (< 0, 2,-1.5> + vrotate(< 1.25, .125,-2>, Rand4));

#declare SpiderKnee5 = (< 0, 2, 1.5> + vrotate(<-1.25, .75, 2>,  Rand1));
#declare SpiderKnee6 = (< 0, 2, 1.5> + vrotate(<-.5, .5, 2.25>,  Rand2));
#declare SpiderKnee7 = (< 0, 2, 1.5> + vrotate(< .5, .25, 2.25>, Rand3));
#declare SpiderKnee8 = (< 0, 2, 1.5> + vrotate(< 1.25, .125, 2>, Rand4));

//@--------Object Declares--------------------------------------------------------

//#--------Robot Ant
#declare RobotAntBody =
union{
  union{
    difference{
      sphere{ 0, 1 }
      plane{ x, 0 }
    }
    difference{
      sphere{ 0, 1 }
      plane{ -x, 0 }
      scale < 5, 1, 1>
    }
    scale < 1, 1, 1.5>
    translate < 1.5, 0, 0>
  }
  sphere{
    0, 1
    scale < 4, .65, 1>
    translate < 2, 0, 0>
  }
  sphere{
    0, 1
    scale < 1, 1, 1.5>
    translate < 5, .25, 0>
  }
  texture{ RobotMetalTex }
}
#declare RobotAntLegs =
union{
  union{
    sphere{ < 0, 0,-1.5>, .25 }
    sphere{ < 1.25, 0,-1.5>, .25 }
    sphere{ < 3.25, 0,-1>, .25 }
    
    sphere{ < 0, 0, 1.5>, .25 }
    sphere{ < 1.25, 0, 1.5>, .25 }
    sphere{ < 3.25, 0, 1>, .25 }
    texture{ RobotPaint2Tex }
  }
  union{
    cylinder{ < 0, 0,-1.5>,    AntKnee1, .175 }
    cylinder{ < 1.25, 0,-1.5>, AntKnee2, .175 }
    cylinder{ < 3.25, 0,-1>,   AntKnee3, .175 }
    
    cylinder{ < 0, 0, 1.5>,    AntKnee4, .175 }
    cylinder{ < 1.25, 0, 1.5>, AntKnee5, .175 }
    cylinder{ < 3.25, 0, 1>,   AntKnee6, .175 }
    texture{ RobotPaint1Tex }
  }
  union{
    union{
      sphere{ AntKnee1, .25 }
      cone{ AntKnee1, .25, <AntKnee1.x-1,-2, AntKnee1.z-1>, .05 }
    }
    union{
      sphere{ AntKnee2, .25 }
      cone{ AntKnee2, .25, <AntKnee2.x,-2, AntKnee2.z-1>, .05 }
    }
    union{
      sphere{ AntKnee3, .25 }
      cone{ AntKnee3, .25, <AntKnee3.x+.5,-2, AntKnee3.z-1>, .05 }
    }
    
    union{
      sphere{ AntKnee4, .25 }
      cone{ AntKnee4, .25, <AntKnee4.x-1,-2, AntKnee4.z+1>, .05 }
    }
    union{
      sphere{ AntKnee5, .25 }
      cone{ AntKnee5, .25, <AntKnee5.x,-2, AntKnee5.z+1>, .05 }
    }
    union{
      sphere{ AntKnee6, .25 }
      cone{ AntKnee6, .25, <AntKnee6.x+.5,-2, AntKnee6.z+1>, .05 }
    }
    texture{ RobotMetalTex }
  }
}
#declare RobotAnt =
union{
  object{ RobotAntBody }
  object{ RobotAntLegs }
  union{  //  rings & antennae
    cylinder{
      < 2.25, 0, 0>, < 2.5, 0, 0>, 1.1
      scale < 1, .65, 1>
    }
    cylinder{
      < 3.85, 0, 0>, < 4.10, 0, 0>, 1.1
      scale < 1, .65, 1>
    }
    union{
      cylinder{ < 5.25, .25,-.5>, < 6, 2.5,-1.75>, .125 }
      sphere{ < 6, 2.5,-1.75>, .125 }
      cone{ < 6, 2.5,-1.75>, .125, < 7, 1.5,-2>, .05 }

      cylinder{ < 5.25, .25, .5>, < 6, 2.5, 1.75>, .125 }
      sphere{ < 6, 2.5, 1.75>, .125 }
      cone{ < 6, 2.5, 1.75>, .125, < 7, 1.5, 2>, .05 }
    }
    texture{ RobotPaint2Tex }
  }
  union{  //  eyes
    sphere{ < 5.25, .25,-1.25>, .5 }
    sphere{ < 5.25, .25, 1.25>, .5 }
    texture{ RobotEyeTex }
  }
  union{  //  jaws
    union{
      cone{ < 5.75, 0,-.5>, .25, < 6.75, .125,-1.25>, .15 }
      sphere{ < 6.75, .125,-1.25>, .15 }
      cone{ < 6.75, .125,-1.25>, .15, < 7.25, .125,-1.00>, .05 }

      cone{ < 5.75, 0, .5>, .25, < 6.75, .125, 1.25>, .15 }
      sphere{ < 6.75, .125, 1.25>, .15 }
      cone{ < 6.75, .125, 1.25>, .15, < 7.25, .125, 1.00>, .05 }
      texture{ RobotPaint2Tex }
    }
    union{
      sphere{ < 5.75, 0,-.5>, .4 }
      sphere{ < 5.75, 0, .5>, .4 }
      texture{ RobotPaint1Tex }
    }
  }
  translate < 0, 2, 0>
}
//#--------Laser for Robot Ant
#declare laser_RobotAnt =
union{
  cone{ < 0, 2, 0>, 1.5, < 0, 3.5, 0>, 1 texture{ RobotPaint2Tex } }
  union{
    torus{ 1, .2 translate < 0, 3.5, 0> }
    torus{ 1, .2 translate < 0, 4, 0> }
    cylinder{ < 0, 3.3, 0>, < 0, 4.2, 0>, 1 }
    cylinder{ < 0, 3.5, 0>, < 0, 4, 0>, 1.2 }
    texture{ RobotMetalTex }
  }
  cylinder{ < 0, 3.75,-.2>, < 2.5, 3.75,-.2>, .2 texture{ RobotPaint1Tex } }
  cylinder{ < 2.5, 3.75,-.2>, < 3, 3.75,-.2>, .2 texture{ RobotPaint2Tex } }
  cylinder{ < 0, 3.75, .2>, < 2.5, 3.75, .2>, .2 texture{ RobotPaint1Tex } }
  cylinder{ < 2.5, 3.75, .2>, < 3, 3.75, .2>, .2 texture{ RobotPaint2Tex } }
}
//#--------Robot Beetle
#declare RobotBeetleHead =
union{
  intersection{
    sphere{ < 0, 0, 0>, 1.2 }
    box{ < .5, 0,-2>, < 2, 2, 2> }
    scale < 1, 1/1.2, 1>
    translate < .5, 0, 0>
    texture{ RobotMetalTex }
  }
  intersection{
    cylinder{ < .4, 0, 0>, < .5, 0, 0>, 1.201 }
    box{ < 0, 0,-2>, < 1, 2, 2> }
    scale < 1, 1/1.2, 1>
    translate < .5, 0, 0>
    texture{ RobotPaint2Tex }
  }
  union{  //  antennae
    cylinder{ < 1.25, .5,-.25>, < 1.5, 1.5,-.75>, .05 }
    sphere{   < 1.5, 1.5,-.75>, .05 }
    cone{     < 1.5, 1.5,-.75>, .05, < 1.75, 1,-1>, .01 }

    cylinder{ < 1.25, .5, .25>, < 1.5, 1.5, .75>, .05 }
    sphere{   < 1.5, 1.5, .75>, .05 }
    cone{     < 1.5, 1.5, .75>, .05, < 1.75, 1, 1>, .01 }
    texture{ RobotPaint2Tex }
  }
  union{  //  eyes
    union{
      difference{
        sphere{ 0, .25 }
        plane{ z, 0 }
      }
      difference{
        sphere{ 0, .25 }
        plane{ -z, 0 }
        scale < 1, 1, 1.5>
      }
      rotate < 225, 30, 0>
      translate < 1.5, .375,-.45>
    }
    union{
      difference{
        sphere{ 0, .25 }
        plane{ z, 0 }
      }
      difference{
        sphere{ 0, .25 }
        plane{ -z, 0 }
        scale < 1, 1, 1.5>
      }
      rotate < 315,-30, 0>
      translate < 1.5, .375, .45>
    }
    texture{ RobotEyeTex }
  }
}
#declare RobotBeetle =
union{
  union{
    intersection{
      sphere{ < 0, 0, 0>, 1 }
      box{ <-2, 0,-2>, < .5, 2, .2> }
      translate < 0, 0,-.2>
      texture{ RobotPaint1Tex }
    }
    intersection{
      sphere{ < 0, 0, 0>, 1 }
      box{ <-2, 0, 2>, < .5, 2,-.2> }
      translate < 0, 0, .2>
      texture{ RobotPaint1Tex }
    }
    intersection{
      cylinder{ < 0, 0, 0>, < 0, .2, 0>, 1 }
      box{ <-2,-1,-2>, < .5, 1, 2> }
      texture{ RobotPaint2Tex }
    }
    scale < 2, 1, 1>
  }
  union{
    cone{ <-.75,-.2, 0>, .5, <-1,-.2,-1.75>, .1 }
    cone{ < 0,-.2, 0>, .5, < 0,-.2,-2>, .1 }
    cone{ < .5,-.2, 0>, .5, < 1.25,-.2,-1.5>, .1 }

    cone{ <-.75,-.2, 0>, .5, <-1,-.2, 1.75>, .1 }
    cone{ < 0,-.2, 0>, .5, < 0,-.2, 2>, .1 }
    cone{ < .5,-.2, 0>, .5, < 1.25,-.2, 1.5>, .1 }
    scale < 1, .5, 1>
    texture{ RobotMetalTex }
  }
  object{ RobotBeetleHead }
  translate < 0, .2, 0>
}
//#--------Robot Beetle with buzzsaw
#declare RobotBeetle_buzzsaw =
union{
  union{
    intersection{
      sphere{ < 0, 0, 0>, 1 }
      box{ <-2, 0,-2>, < .5, 2, .2> }
      translate <-.5, 0, 1>
      rotate 320*y
      translate < .5, 0,-1.2>
      texture{ RobotPaint1Tex }
    }
    intersection{
      sphere{ < 0, 0, 0>, 1 }
      box{ <-2, 0, 2>, < .5, 2,-.2> }
      translate <-.5, 0,-1>
      rotate 040*y
      translate < .5, 0, 1.2>
      texture{ RobotPaint1Tex }
    }
    intersection{
      sphere{ < 0, 0, 0>, (7/8) }
      box{ <-2, 0,-2>, < .5, 2, 2> }
      texture{ RobotMetalTex }
    }
    intersection{
      cylinder{ < 0, 0, 0>, < 0, .2, 0>, 1 }
      box{ <-2,-1,-2>, < .5, 1, 2> }
      texture{ RobotPaint2Tex }
    }

    intersection{
      cylinder{ < 0, 0, .1>, < 0, 0,-.1>, 1 }
      box{ <-2, .2,-2>, < .5, 2, 2> }
      texture{ RobotPaint1Tex }
    }
    scale < 2, 1, 1>
  }
  union{
    cylinder{ < 0, .8, 0>, <-1, 2.5, 0>, .075 texture{ RobotMetalTex } }
    sphere{ <-1, 2.5, 0>, .1 texture{ RobotPaint2Tex } }
    cylinder{ <-1, 2.5, 0>, <-3, 2, 0>, .075 texture{ RobotMetalTex } }

    cylinder{ <-3, 2,-.2>, <-3, 2, .2>, .15 texture{ RobotPaint1Tex } }
    cylinder{ <-3, 2,-.1>, <-3, 2, .1>, .25 texture{ RobotPaint2Tex } }
    disc{ <-3, 2, 0>, z, .5 texture{ RobotMetalTex } }
  }
  union{
    cone{ <-.75,-.2, 0>, .5, <-1,-.2,-1.75>, .1 }
    cone{ < 0,-.2, 0>, .5, < 0,-.2,-2>, .1 }
    cone{ < .5,-.2, 0>, .5, < 1.25,-.2,-1.5>, .1 }

    cone{ <-.75,-.2, 0>, .5, <-1,-.2, 1.75>, .1 }
    cone{ < 0,-.2, 0>, .5, < 0,-.2, 2>, .1 }
    cone{ < .5,-.2, 0>, .5, < 1.25,-.2, 1.5>, .1 }
    scale < 1, .5, 1>
    texture{ RobotMetalTex }
  }
  object{ RobotBeetleHead }
  translate < 0, .2, 0>
}
//#--------Robot Spider
#declare RobotSpider =
union{
  blob{  //  body
    threshold 1.5
    sphere{ < 0, 0, 0>, 1, 2 }
    sphere{ < .25,-.25, 0>, .5, -.5 scale < 1, 1, 1.5> }
    sphere{ < 0, 0, 0>, 1, .25 }

    rotate < 0, 180, 210>
    scale 6
    texture{ RobotMetalTex }
  }
  union{  //  legs
    union{
      sphere{ <-1.25, .75,-2>, .25 }
      sphere{ <-.5, .5,-2.25>, .25 }
      sphere{ < .5, .25,-2.25>, .25 }
      sphere{ < 1.25, .125,-2>, .25 }

      sphere{ <-1.25, .75, 2>, .25 }
      sphere{ <-.5, .5, 2.25>, .25 }
      sphere{ < .5, .25, 2.25>, .25 }
      sphere{ < 1.25, .125, 2>, .25 }
      texture{ RobotPaint2Tex }
    }
    union{
      cylinder{ <-1.25, .75,-2>,    SpiderKnee1, .175 }
      cylinder{ <-.5, .5,-2.25>,    SpiderKnee2, .175 }
      cylinder{ < .5, .25,-2.25>,   SpiderKnee3, .175 }
      cylinder{ < 1.25, .125,-2>,   SpiderKnee4, .175 }

      cylinder{ <-1.25, .75, 2>,    SpiderKnee5, .175 }
      cylinder{ <-.5, .5, 2.25>,    SpiderKnee6, .175 }
      cylinder{ < .5, .25, 2.25>,   SpiderKnee7, .175 }
      cylinder{ < 1.25, .125, 2>,   SpiderKnee8, .175 }
      texture{ RobotPaint1Tex }
    }
    union{
      union{
        sphere{ SpiderKnee1, .25 }
        cone{ SpiderKnee1, .25, <SpiderKnee1.x-1,-2, SpiderKnee1.z-1>, .05 }
      }
      union{
        sphere{ SpiderKnee2, .25 }
        cone{ SpiderKnee2, .25, <SpiderKnee2.x-.5,-2, SpiderKnee2.z-1>, .05 }
      }
      union{
        sphere{ SpiderKnee3, .25 }
        cone{ SpiderKnee3, .25, <SpiderKnee3.x,-2, SpiderKnee3.z-1>, .05 }
      }
      union{
        sphere{ SpiderKnee4, .25 }
        cone{ SpiderKnee4, .25, <SpiderKnee4.x+1,-2, SpiderKnee4.z-1>, .05 }
      }

      union{
        sphere{ SpiderKnee5, .25 }
        cone{ SpiderKnee5, .25, <SpiderKnee5.x-1,-2, SpiderKnee5.z+1>, .05 }
      }
      union{
        sphere{ SpiderKnee6, .25 }
        cone{ SpiderKnee6, .25, <SpiderKnee6.x-.5,-2, SpiderKnee6.z+1>, .05 }
      }
      union{
        sphere{ SpiderKnee7, .25 }
        cone{ SpiderKnee7, .25, <SpiderKnee7.x,-2, SpiderKnee7.z+1>, .05 }
      }
      union{
        sphere{ SpiderKnee8, .25 }
        cone{ SpiderKnee8, .25, <SpiderKnee8.x+.5,-2, SpiderKnee8.z+1>, .05 }
      }
      texture{ RobotMetalTex }
    }
  }
  union{  //  head
    sphere{
      < 2.75,-1, 0>, 1
      scale < 1, .75, 1>
      texture{ RobotMetalTex }
    }
    cylinder{
      < 2,-1, 0>, < 2.75,-1, 0>, 1
      scale < 1, .75, 1>
      texture{ RobotPaint2Tex }
    }
    union{  //  eyes
      sphere{ < 3.5,-.25,-.2>, .2 }
      sphere{ < 3.5,-.25, .2>, .2 }

      sphere{ < 3.7,-.55,-.15>, .15 }
      sphere{ < 3.7,-.55, .15>, .15 }

      sphere{ < 3.5,-.35,-.5>, .1 }
      sphere{ < 3.6,-.50,-.4>, .1 }
      sphere{ < 3.5,-.35, .5>, .1 }
      sphere{ < 3.6,-.50, .4>, .1 }
      texture{ RobotEyeTex }
    }
    union{  //  jaws
      union{
        cone{ < 3.5,-.75,-.5>, .2, < 4,-.75,-1>, .1 }
        sphere{ < 4,-.75,-1>, .1 }
        cone{ < 4,-.75,-1>, .1, < 4.5,-.75,-.75>, .01 }

        cone{ < 3.5,-.75, .5>, .2, < 4,-.75, 1>, .1 }
        sphere{ < 4,-.75, 1>, .1 }
        cone{ < 4,-.75, 1>, .1, < 4.5,-.75, .75>, .01 }
        texture{ RobotPaint2Tex }
      }
      union{
        sphere{ < 3.5,-.775,-.5>, .25 }
        sphere{ < 3.5,-.775, .5>, .25 }
        texture{ RobotPaint1Tex }
      }
    }
  }
  scale 1/2
  translate < 0, 1, 0>
}
//#--------Laser for Robot Spider
#declare laser_RobotSpider =
union{
  cone{ < 0, 1.5, 0>, 1.5, < 0, 3.5, 0>, .5 texture{ RobotPaint2Tex } }
  union{
    torus{ .75, .1 translate < 0, 3.5, 0> }
    torus{ .75, .1 translate < 0, 4, 0> }
    cylinder{ < 0, 3.4, 0>, < 0, 4.1, 0>, .75 }
    cylinder{ < 0, 3.5, 0>, < 0, 4, 0>, .85 }
    texture{ RobotMetalTex }
  }
  cylinder{ < 0, 3.75,-.2>, < 2.5, 3.75,-.2>, .1 texture{ RobotPaint1Tex } }
  cylinder{ < 2.5, 3.75,-.2>, < 3, 3.75,-.2>, .1 texture{ RobotPaint2Tex } }
  cylinder{ < 0, 3.75, .2>, < 2.5, 3.75, .2>, .1 texture{ RobotPaint1Tex } }
  cylinder{ < 2.5, 3.75, .2>, < 3, 3.75, .2>, .1 texture{ RobotPaint2Tex } }

  scale 1/2
  translate <-.25, .25, 0>
}

//@--------Object Assembly--------------------------------------------------------



//@--------Realisation------------------------------------------------------------

/*
  //  only used during file creation
union{
  object{ RobotAnt }
  scale 1
  rotate 0*y
  translate < 0, 0, 0>
}

camera{
  location < 15, 15, 0>
  look_at < 0, 5, 0>
}
light_source{
  < 10, 20,-20>
  White
}
*/

//plane{ y,0 pigment{ ForestGreen } }

//@--------Include Footer---------------------------------------------------------

  #version GKinfest_Inc_Temp;
#end

//@-------------------------------------------------------------------------------
