#version unofficial MegaPov 0.7;

#local k = 2.7;

camera {
	location <0, 2, -3.4>*k
	right x*image_width/image_height
    up y	    
    look_at <0, 1.7, 0>*k
} 

light_source {<-10, 14, -4>*k color rgb<1, 0.64, 0.5>*1.4}
light_source {<10, 6, 6>*k color rgb<0.4, 0.85, 1>}

#include "glows.inc"
#include "car.inc"
#include "man.inc"
#include "girl1.inc" 
#include "girl2.inc"
#include "bfly.inc"

#declare B = function{ "rounded_box", <0.35, 0.6, 4, 0.6> }
#declare G = function {pigment {granite scale 0.01}}
#declare PostTxt = texture{
    pigment{color rgb 0.5}
}
texture{
    pigment {
        gradient y
        color_map{
            [0 color rgbf<0, 0, 0, 0.3>]
            [0.4 color rgbf<0, 0, 0, 1>]
        }
        turbulence 0.2 
        scale <1, 5, 1>
    } 
    finish{ambient 0.02 diffuse 0.7 phong 0.34}
}

union{ 
    object{Girl2 scale <0.95, 1, 0.95>}
    isosurface{ 
        function{B * G} 
        contained_by{ box{-4, <2, 4, 2>} }
        texture{PostTxt}
        translate <-0.6, 0, 0.8>
    } 
    isosurface{ 
        function{B * G} 
        contained_by{ box{-4, <2, 4, 2>} }
        texture{PostTxt}
        translate <-0.6, 0, 10>
        rotate y*15
    } 
    
    rotate -y*15 translate<-1.9, 0, 0.6>*k
} 
// cigarette
glow{size 0.003 type 0 color rgb<1.3, 0, 0> translate<1.89, 7.135, 0.105> scale 0.95 rotate -y*15 translate<-1.905, 0, 0.6>*k} 

union{
    object{Girl1 translate<2.4, 0, 2.25>*k}
    object{
    	Car scale k
    }                                            
    object{Man rotate y*180 translate<2.4, 0.9, -0.65>*k}
    object{Butterfly scale 0.04 rotate y*90 rotate x*30 translate<-1.9, 1.05, 1.5> scale k}
    object{Butterfly scale 0.05 rotate y*110 rotate x*30 translate<-2.2, 1.05, 1.78> scale k}    
    
    rotate -y*110           
    translate<5, 0, 3>
}

#declare RoadTxt = texture{
    pigment{
        granite
        color_map{
            [0 0.2 color rgb 0.05 color rgb 0.15]
            [0.2 1 color rgb 0.075 color rgb 0.1]
        }       
        scale 0.034
    }
    finish{reflection 0.48 reflection_blur 0.052 reflection_samples 30 phong 0.2}
    normal{granite scale<1, 0.5, 1>}
}
#declare BorderTxt = texture{
    pigment{color rgb 0.1}       
    finish{reflection 0.32 phong 0.14}
    normal{granite scale 0.01}
}

// road
merge{
    plane{y, 0}
    intersection{
        plane{y, 0.32}
        plane{x, 0 translate -x*4.1}
    }
    intersection{
        plane{y, 0.32}
        plane{x, 0 translate -x*4.1}
        rotate y*180
        translate x*20
    }
    texture{RoadTxt}
}
// border
union{
    box{<-0.3, -0.4, -100>, <0.2, 0.4, 600> translate -x*4.1}
    box{<-0.3, -0.4, -100>, <0.2, 0.4, 600> translate x*24.1}
    texture{BorderTxt}
}

// above road
#local num = 60;
#local cnt = 0;
#while (cnt < num)
    glow{size 0.02 type 0 color rgb<1.2, 0.9, 0.6>*0.6*((num - cnt)/num) translate<16, 15, -20 + 6*cnt>}
    glow{size 0.02 type 0 color rgb<1.2, 0.9, 0.6>*0.6*((num - cnt)/num) translate<-9.5, 15, -20 + 6*cnt>}   
    #local cnt = cnt + 1;
#end 

#local num = 20;
#local cnt = 0;
#while (cnt < num)
    Cycloid(<-9, 15, -20 + 13 * cnt>, 1, 14, 0, 0, 0, 7, 0, 0.018, color rgb<0.4, 0, 0>*0.6*((num - cnt)/(2*num)), 0)
#local cnt = cnt + 1;
#end
Line(<-300, 15, 340>, <300, 15, 340>, 200, 0, 0.02, color rgb<1, 0.8, 0.5>, 0)

// bld 1
box{<-50, 0, 0>, <0, 130, 90> pigment{color rgb -0.05} translate<-40, 0, 250> no_shadow}
Line(<-39.5, 0.5, 250>, <-39.5, 130, 250>, 50, 0, 0.02, color rgb<1, 0.7, 0.4>, 0)
Line(<-39.5, 0.5, 280>, <-39.5, 130, 280>, 50, 0, 0.02, color rgb<1, 0.7, 0.4>, 0)
Line(<-39.5, 0.5, 310>, <-39.5, 130, 310>, 50, 0, 0.02, color rgb<1, 0.7, 0.4>, 0)
Line(<-39.5, 0.5, 340>, <-39.5, 130, 340>, 50, 0, 0.02, color rgb<1, 0.7, 0.4>, 0)
#local num = 15;
#local cnt = 0;
#while (cnt < num)
    Line(<-90, 7 + 7*cnt, 249>, <-40, 7 + 7*cnt, 249>, 30, 0, 0.02, color rgb<1, 0.7, 0.4>*2, 0)
    #local cnt = cnt + 1;
#end

// bld 2
box{<-50, 0, 0>, <0, 130, 60> pigment{color rgb -0.05} translate<-40, 0, 100> no_shadow}
Line(<-39.5, 0.5, 100>, <-39.5, 130, 100>, 60, 0, 0.02, color rgb<1, 0.7, 0.4>*2, 0)
Line(<-39.5, 0.5, 120>, <-39.5, 130, 120>, 60, 0, 0.02, color rgb<1, 0.7, 0.4>*2, 0)
Line(<-39.5, 0.5, 140>, <-39.5, 130, 140>, 60, 0, 0.02, color rgb<1, 0.7, 0.4>*2, 0)
#local num = 15;
#local cnt = 0;
#while (cnt < num)
    Line(<-90, 5 + 5*cnt, 99>, <-40, 5 + 5*cnt, 99>, 40, 0, 0.012, color rgb<1, 0.7, 0.4>*3, 0)
    #local cnt = cnt + 1;
#end
Circle(<-55, 45, 98>, 10, 0, 0, 40, 0, 0.022, color rgb<0.4, 0, 0>, 1)
Circle(<-55, 45, 98>, 5, 0, 0, 30, 0, 0.022, color rgb<0.4, 0, 0>, 1)
Line(<-55, 45, 98>, <-50, 0, 98>, 30, 0, 0.02, color rgb<1.1, 0.5, 0>, 0)
Line(<-55, 45, 98>, <-40, 0, 98>, 30, 0, 0.02, color rgb<1.1, 0.5, 0>, 0)
Line(<-55, 45, 98>, <-60, 0, 98>, 30, 0, 0.02, color rgb<1.1, 0.5, 0>, 0)
Line(<-55, 45, 98>, <-70, 0, 98>, 30, 0, 0.02, color rgb<1.1, 0.5, 0>, 0)
text {ttf "c:\windows\fonts\tahomabd.ttf" "H" 0.03, 0
    pigment {color rgb<0.6, 0, 0>}
    scale 3
    translate<-38, 34, 100>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "O" 0.03, 0
    pigment {color rgb<0.6, 0, 0>}
    scale 3
    translate<-38, 31, 100>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "T" 0.03, 0
    pigment {color rgb<0.6, 0, 0>}
    scale 3
    translate<-38, 28, 100>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "E" 0.03, 0
    pigment {color rgb<0.6, 0, 0>}
    scale 3
    translate<-38, 25, 100>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "L" 0.03, 0
    pigment {color rgb<0.6, 0, 0>}
    scale 3
    translate<-38, 22, 100>
}

// bld 3
box{<-60, -1, -80>, <-20, 14, 110> pigment{color rgb -0.05}} 

// large radius
#local col = color rgb<1, 0.4, 0>;
HalfCircle(<-19.8, 0.35, 120 - (13*2*1) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*2) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*3) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*4) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*5) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*6) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*7) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*8) - 2>, 13, 180, 90, 0, 36, 0, 0.02, col, 0)
// small radius
#local col = color rgb<1, 0.4, 0>;
HalfCircle(<-19.8, 0.35, 120 - (13*2*1) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*2) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*3) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*4) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*5) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*6) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*7) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)
HalfCircle(<-19.8, 0.35, 120 - (13*2*8) - 2>, 10, 180, 90, 0, 30, 0, 0.02, col, 0)

Rectangle(<-19.8, -2, 120 - (13*2*1) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*2) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*3) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*4) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*5) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*6) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*7) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)
Rectangle(<-19.8, -2, 120 - (13*2*8) - 2 - 6/2>, 6, 10, -90, 0, 0, 10, 26, 0, 0.02, color rgb<1, 0.4, 0.2>, 1)  

Rectangle(<-22, 9, 120 - (13*2*3) - 5>, 10, 6, -90, 0, -90, 10, 12, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)
Line(<-16, 0, 120 - (13*2*3) - 5>, <-16, 9, 120 - (13*2*3) - 5>, 30, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)
Line(<-16, 0, 120 - (13*2*3) - 5 + 10>, <-16, 9, 120 - (13*2*3) - 5 + 10>, 30, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)

Rectangle(<-22, 9, 120 - (13*2*4) - 5>, 10, 6, -90, 0, -90, 10, 12, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)

Rectangle(<-22, 9, 120 - (13*2*5) - 5>, 10, 6, -90, 0, -90, 10, 12, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)
Line(<-16, 0, 120 - (13*2*5) - 5>, <-16, 9, 120 - (13*2*5) - 5>, 30, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)
Line(<-16, 0, 120 - (13*2*5) - 5 + 10>, <-16, 9, 120 - (13*2*5) - 5 + 10>, 30, 0, 0.02, color rgb<0.8, 0.3, 0>, 0)

text {ttf "c:\windows\fonts\stop.ttf" "SEX" 0.03, 0
    pigment {color rgb<1, 0.1, 0>*3}
    scale 5
    rotate -y*90
    translate<-19.5, 12, 22>
}
text {ttf "c:\windows\fonts\ravie.ttf" "shop" 0.03, 0
    pigment {color rgb<1, 0.75, 0>*1.4}
    scale 2
    rotate -y*90
    translate<-19.5, 10.3, 23.3>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "BAR" 0.03, 0
    pigment {color rgb<1, 0.2, 0>*3.5}
    scale 5
    rotate -y*90
    translate<-19.5, 12, 48>
}
text {ttf "c:\windows\fonts\tahomabd.ttf" "X" 0.02, 0
    pigment {color rgb<1, 0, 0>*2}
    scale<11, 7, 7>
    rotate -y*90
    translate<-19.5, 12, 74>
}

// absorb glows
plane{-z, 0 translate<0, 0 380> pigment{color rgb -0.05}}

// bld 4
box{<50, -1, -40>, <100, 15, 235> pigment{color rgb -0.05}}
box{<65, 15, -40>, <100, 30, 204> pigment{color rgb -0.05}}
#local num = 13;
#local cnt = 0;
#while (cnt < num)
    QuarterCircle(<50, 0, -40 + cnt*20>, 14, 180, 0, 0, 20, 0, 0.02, color rgb<0, 0.86, 1>*(0.1 + ((num - cnt)/num)), 0)
#local cnt = cnt + 1;
#end
#local num = 11;
#local cnt = 0;
#while (cnt < num)
    QuarterCircle(<65, 15, -40 + cnt*20>, 14, 180, 0, 0, 20, 0, 0.02, color rgb<0, 0.86, 1>*(0.1 + ((num - cnt)/num)), 0)
#local cnt = cnt + 1;
#end
#local num = 13;
#local cnt = 0;
#while (cnt < num)
    Line(<49.5, 0, -40 + cnt*20>, <49.5, 13.5, -40 + cnt*20>, 30, 0, 0.02, color rgb<0, 0.86, 1>*0.6, 0)    
#local cnt = cnt + 1;
#end
#local num = 13;
#local cnt = 0;
#while (cnt < num)
    Line(<64.5, 15, -40 + cnt*20>, <64.5, 28.5, -40 + cnt*20>, 30, 0, 0.02, color rgb<0, 0.86, 1>*0.6, 0)    
#local cnt = cnt + 1;
#end

text {ttf "c:\windows\fonts\webssr1_.ttf" "G" 0.01, 0
    pigment {color rgb<0, 0.8, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 72>
}
Circle(<49.5, 6.3, 69.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "F" 0.01, 0
    pigment {color rgb<0.8, 0, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 92>
}
Circle(<49.5, 6.3, 89.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.9, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "B" 0.01, 0
    pigment {color rgb<0, 0.8, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 112>
}
Circle(<49.5, 6.3, 109.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.7, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "C" 0.01, 0
    pigment {color rgb<0.8, 0, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 132>
} 
Circle(<49.5, 6.3, 129.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.5, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "G" 0.01, 0
    pigment {color rgb<0, 0.8, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 152>
}
Circle(<49.5, 6.3, 149.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.4, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "F" 0.01, 0
    pigment {color rgb<0.8, 0, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 172>
}
Circle(<49.5, 6.3, 169.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.3, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "B" 0.01, 0
    pigment {color rgb<0, 0.8, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 192>
}
Circle(<49.5, 6.3, 189.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.2, 0)
text {ttf "c:\windows\fonts\webssr1_.ttf" "C" 0.01, 0
    pigment {color rgb<0.8, 0, 1>*3}
    scale 7
    rotate y*90
    translate<49.5, 4, 212>
} 
Circle(<49.5, 6.3, 209.5>, 5, 0, 90, 30, 0, 0.02, color rgb<0, 0.6, 1>*0.1, 0)

text {ttf "c:\windows\fonts\webssr1_.ttf" "F" 0.01, 0
    pigment {color rgb<1, 0, 0>*3}
    scale 4
    rotate y*90
    translate<50, 16, 90>
}
text {ttf "c:\windows\fonts\parade.ttf" "CASINO" 0.04, 0
    pigment {color rgb<0, 1.2, 0.2>*3}
    scale<8, 7, 1>
    rotate y*90
    translate<50, 15.4, 120>
}
text {ttf "c:\windows\fonts\webssr1_.ttf" "F" 0.01, 0
    pigment {color rgb<1, 0, 0>*3}
    scale 4
    rotate y*90
    translate<50, 16, 130>
}
text {ttf "c:\windows\fonts\parade.ttf" "BAR" 0.04, 0
    pigment {color rgb<0, 0.2, 1.1>*3}
    scale<8, 7, 1>
    rotate y*90
    translate<50, 15.4, 150>
}
text {ttf "c:\windows\fonts\parade.ttf" "RESTAURANT" 0.04, 0
    pigment {color rgb<1, 0.5, 0>*3}
    scale<8, 7, 1>
    rotate y*90
    translate<50, 15.4, 85>
}

text {ttf "c:\windows\fonts\parade.ttf" "Night Club" 0.04, 0
    pigment {color rgb<1, 1, 0>*3}
    scale 5
    rotate y*90
    translate<65, 34, 165>
}
text {ttf "c:\windows\fonts\Itckrist.ttf" "FORTUNE" 0.04, 0
    pigment {color rgb<1.2, 0, 0.2>*3}
    scale 9
    rotate y*90
    translate<65, 32, 140>
}

// bld 5
box{0, <60, 140, 60> pigment{color rgb -0.05} translate<90, 0, 250> no_shadow}
#declare c1 = <0.9, 0.9, 1>
Line(<89.5, 0.5, 250>, <89.5, 140, 250>, 60, 0, 0.02, color rgb c1*0.4, 0)
#local num = 18;
#local cnt = 0;
#while (cnt < num)
    Line(<90, 7 + 7*cnt, 249>, <150, 7 + 7*cnt, 249>, 30, 0, 0.02, color rgb c1, 0)
    #local cnt = cnt + 1;
#end
#local num = 18;
#local cnt = 0;
#while (cnt < num)
    Line(<89.5, 7 + 7*cnt, 251>, <89.5, 7 + 7*cnt, 309>, 20, 0, 0.02, color rgb c1*0.4, 0)
    #local cnt = cnt + 1;
#end

// green lights
glow{size 0.02 type 0 color rgb<0, 1.2, 0> translate<5, 10, 50>}
glow{size 0.02 type 0 color rgb<0, 1.2, 0> translate<9, 9, 50>}
// white lights
glow{size 0.04 type 0 color rgb 1 translate<-0.5, 5.5, 50>}
glow{size 0.04 type 0 color rgb 1 translate<2, 5.5, 50>}
// red lights
glow{size 0.03 type 0 color rgb<1, 0.2, 0> translate<5, 6, 45>}
glow{size 0.03 type 0 color rgb<1, 0.2, 0> translate<8, 6, 45>}  
glow{size 0.03 type 0 color rgb<1, 0.2, 0> translate<5.2, 7.3, 45>}
glow{size 0.03 type 0 color rgb<1, 0.2, 0> translate<7.8, 7.3, 45>}


