#include "textures.inc"

#declare light_bulb = merge
{       
        sphere
        {
                < 0, 0, 0 >,1
                scale< 4, 4, 4 >
        }
        difference
        {
                cylinder
                {
                        < 0, 0, 0 ><0, 1, 0 >,1
                        scale< 2, 4, 2 >
                        translate< 0, 3, 0 >
                }
                sphere
                {
                        < 0, 0, 0 >,1
                        scale< 4, 4, 4 >
                }
        }
        hollow
        texture{ glass2_texture }
}

#declare lamp_head = difference
{
        difference
        {         
                union
                {
                        sphere
                        {
                                < 0, 0, 0 >,1
                                scale< 10, 10, 10 >
                        }
                }
                box
                {
                        <-1, -1, -1>,<1, 0, 1 >
                        scale< 10, 10, 10 >
                }
        }
        sphere
        {
                < 0, 0, 0 >,1
                scale< 9.9, 9.9, 9.9 >
        }
}

#declare lamp_tophead = union 
{
        cylinder
        {
                < 0, 0, 0 ><0, 1, 0 >,1
        }
        sphere
        {
                < 0, 0, 0 >, 1
                translate< 0, 1, 0 >
        }
        scale< 4, 6, 4 >
        translate< 0, 7, 0 >
}

#declare arm_part = union
{
        union
        {
                box
                {
                        <0,0,0><1,1,1>
                }
                box
                {
                        <0,0,0><1,1,1>
                        translate< 0, 5, 0 >
                }
                scale< 50, 1, 1 >
        }
        union
        {
                mesh
                {
                        triangle{< 0, 0, 0.1 >,< 0, 1, 0.1 >,< 1, 1, 0.1 >}
                        triangle{< 0, 0, -0.02 >,< 0, 1, -0.02 >,< 1, 1, -0.02 >}
                }
                sphere
                {
                        <0, 0, 0>,0.1
                        translate< 0.15, 0.35, 0.05 >
                }
                sphere
                {
                        <0, 0, 0>,0.1
                        translate< 0.15, 0.85, 0.05 >
                }
                sphere
                {
                        <0, 0, 0>,0.1
                        translate< 0.65, 0.85, 0.05 >
                }
                scale< 10, 10, 10 >       
                translate< 50, -3, 0 >
        }
}

#declare arm = union
{
        object
        {
                arm_part
        }
        object
        {
                arm_part
                rotate< 0, 0, -45 >
                translate< 50, 2, 0 >
        }
}

#declare lamp = union
{
        object
        {
                light_bulb
        }
        union
        {
                object
                {
                        lamp_head
                        texture{ reflector_texture }
                }
                object
                {
                        lamp_head
                        scale< 1.01, 1.01, 1.01 >
                        texture{ lamphead_texture }
                }
                object
                {
                        lamp_tophead
                        texture{ tophead_texture }
                }
        }
        object
        {
                arm
                translate< 0, 10, 0 >
                texture{ steel_texture }
        }
}