#include "textures.inc"

#declare desk = union
{                    
        difference
        {
                difference
                {
                        box
                        {
                                < -1, -1, -1 >< 1, 1, 1 >
                                scale< 150, 70, 60 >
                        }
                        box
                        {
                                < -1, -1, -1 >< 1, 1, 1 >
                                translate< 0, -0.5, 0 >
                                scale< 145, 50, 65 >
                        }
                }
                box
                {
                        < -1, -1, -1 >< 1, 1, 1 >
                        translate< 0, 3, 0 >
                        scale< 145, 15, 65 >
                }
        }
        texture{ desk_texture }
}

#declare globe = union
{
        sphere
        {
                <0, 0, 0 >,1
                texture{ earth_continents }
                rotate< 0, -30, 0 >
                rotate< 0, 0, 12 >
                scale< 40, 40, 40 >
        }
        difference
        {
                union
                {
                        difference
                        {
                                sphere
                                {
                                        <0, 0, 0 >,1
                                }
                                union
                                {
                                        cylinder
                                        {
                                                < -1, 0, 0, >,<1, 0, 0 >,0.5
                                                scale< 1, 1.5, 1.3 >
                                        }
                                        cylinder
                                        {
                                                < 0, 0, -1 >,< 0, 0, 1 >,0.5
                                                scale< 1.3, 1.5, 1 >
                                        }
                                }
                        }
                        torus
                        {
                                0.75, 0.1
                                translate< 0, 0.6, 0 >                                
                        }
                        texture{ gold_texture }
                        translate< 0, -2, 0 >
                        scale< 25, 25, 25 >
                }
                sphere
                {
                        <0, 0, 0 >,1
                        scale< 40, 40, 40 >
                }
        }
}

#declare cup = union
{
        union
        {       
                cylinder
                {
                        < 0, 0, 0 >< 0, 1, 0 >,1
                        scale< 1, 2, 1 >
                }
                torus
                {
                        0.75, 0.25
                }
                torus
                {
                        0.75, 0.25
                        translate< 0, 2, 0 >
                }
                texture{ cup_texture }
        }
        torus
        {
                0.5, 0.15
                rotate< 90, 0 0 >
                scale< 1, 1.5, 1 >
                translate< -1, 1, 0 >
                texture{ cupbase_texture }
        }
        sphere
        {
                < 0, 0, 0 >,1
                material{ steam_material }
                hollow
                translate< 0, 1, 0 >
                scale< 1, 5, 1 >
        }
}

#declare room = union
{
        box
        {
                < -1, -1, -1 ><1, 1, 1 >
                material{ room_material }
                hollow
        }
}