/*      Spider-bot code  IRTC- May/June 2001 */


//Author: Jonathan Rafael Ghiglia  jrg_pov@hotmail.com
// You can make any change you want to this file.
// You can freely use this code.
// If you make interesting changes and improvements (such as animating the spider!) please e-mail me!!


#version unofficial megapov 0.7;

#default {finish {ambient 0}}


//--------------spider-------



//-------macros--------      

#macro lat_blob (lat_array,rad_array,tr_array,res,max_ran,thres,RS)

#declare num = dimension_size (lat_array,1);
#declare step = 360/res;
#declare ang=0;
blob {  threshold thres
        #while (ang<360)
        #declare i=0;
        #while (i<num)
        sphere {0, rad_array[i],1  translate lat_array[i] translate max_ran*rand(RS)-max_ran*rand(RS)*x rotate ang*y translate tr_array[i]*x }
        #declare i=i+1;
        #end  
        #declare ang=ang+step;
        #end
        }
        
#end  


#macro fiber (lung,rag,l_path,r_path1,r_path2,_steps,n_step,max_ran_l,max_rot,ran,RS) 

union {
#declare h=0;
#while (h<=l_path)
#declare a=0;
#while (a<360)
#declare l=lung+max_ran_l*rand(RS)-max_ran_l*rand(RS);
/*union {*/cylinder {<0,0,0>,<l+0.1*rand(RS),0,0>,rag //}
        //sphere {0,rag translate l*x}
        rotate (max_rot*rand(RS)-max_rot*rand(RS)+30)*z translate <r_path1+(h/l_path)*(r_path2-r_path1),h,0> rotate (a+ran*(360/n_step*rand(RS)-360/n_step*rand(RS)))*y
        translate ran*(l_path/_steps*rand(RS)-l_path/_steps*rand(RS))*y}
#declare a=a+360/n_step;
#end
#declare h=h+l_path/_steps;
#end
}
#end  


#macro segmento (l_s,r1,r2,sl1,sl2,stps,max_r,RS)

lathe {
        cubic_spline
        stps+3
        <-r1*sl1,0>
        <0,0>
#declare liv=-l_s/stps;
#declare n=1;
#while (n<stps)
        <r1+(liv/(-l_s))*(r2-r1)+max_r*rand(RS)-max_r*rand(RS),liv>
#declare n=n+1;
#declare liv=n*(-l_s/stps);
#end    
        <0,-l_s>
        <-r2*sl2,-l_s>  
       sturm }
#end        


        
#macro zampa (l,r_z,sl_s,stps,max_r,ang1,ang2,ang3,lung,rag,_steps,n_step,max_ran_l,max_rot,ran,RS,t_z,t_f)

#declare l1=l[0];
#declare l2=l[1];
#declare l3=l[2];
union {
        object { segmento (l1,r_z[0],r_z[1],sl_s[0],sl_s[1],stps,max_r,RS) rotate 90*x
                rotate ang1*x texture {t_z translate (l1+l2+l3)*rand(RS)}}
        object {fiber (lung,rag,l1*.95,r_z[0],r_z[1],_steps,n_step,max_ran_l,max_rot,ran,RS) 
                translate 0.025*l1*y rotate -90*x rotate ang1*x texture {t_f translate (l1+l2+l3)*rand(RS)}}
        sphere {0,r_z[1]
                translate -l1*z  rotate ang1*x texture {t_z translate (l1+l2+l3)*rand(RS)}}

        object { segmento (l2,r_z[2],r_z[3],sl_s[2],sl_s[3],stps,max_r,RS) rotate 90*x
                 rotate ang2*x 
                translate -l1*z rotate ang1*x texture {t_z translate (l1+l2+l3)*rand(RS)}}
        object {fiber (lung,rag,l2*.95,r_z[2],r_z[3],_steps,n_step,max_ran_l,max_rot,ran,RS) 
                translate 0.025*l2*y rotate -90*x rotate ang2*x 
                translate -l1*z rotate ang1*x texture {t_f translate (l1+l2+l3)*rand(RS)}}
        sphere {0,r_z[3]
                translate -l2*z  rotate ang2*x 
                translate -l1*z rotate ang1*x texture {t_z translate (l1+l2+l3)*rand(RS)}}

        object { segmento (l3,r_z[4],r_z[5],sl_s[4],sl_s[5],stps,max_r,RS) rotate 90*x
                rotate ang3*x
                translate -l2*z rotate ang2*x 
                translate -l1*z rotate ang1*x texture {t_z translate (l1+l2+l3)*rand(RS)}}
        object {fiber (lung,rag,l3*3/4*.95,r_z[4],r_z[5],_steps,n_step,max_ran_l,max_rot,ran,RS) 
                translate 0.025*l3*3/4*y rotate -90*x rotate ang3*x
                translate -l2*z rotate ang2*x 
                translate -l1*z rotate ang1*x texture {t_f translate (l1+l2+l3)*rand(RS)}}
                }
#end                

//-------textures---------(the rgb values used in the final scene are commented out in this one)


#declare t_metal = texture { wrinkles scale 0.1 warp {reset_children} texture_map {
                          [0 pigment { rgb /*<.9,.93,1>}*/<1,.93,.9>}
                           finish {ambient 0 diffuse 0.2 reflection 0.6*/*<.9,.93,1>*/<1,.93,.9> 
                           metallic 
                                        specular 2 roughness 0.007 }
                                        normal {dents 0.35 scale 0.05}]
                          [1 pigment {rgb /*<.85,.85,.915>}*/<.915,.85,.85>}
                           finish {ambient 0 diffuse 0.3 reflection 0.3*/*<.85,.85,.915>*/<.915,.85,.85> 
                           metallic
                                        specular 1 roughness 0.02 }
                                        normal {dents 0.5 scale 0.01}]} scale 4}  




//-----addome-------abdomen


//-----lathe-blob coordinates
#declare ad_a = array[10]
#declare ad_a[0]=<cos(-pi/2),sin(-pi/2)+0.1,0>*0.5;
#declare ad_a[1]=<cos(pi/9-pi/2)+0.2,sin(pi/9-pi/2),0>*0.5;
#declare ad_a[2]=<cos(2*pi/9-pi/2)+0.23,sin(2*pi/9-pi/2),0>*0.5;
#declare ad_a[3]=<cos(3*pi/9-pi/2)+0.2,sin(3*pi/9-pi/2),0>*0.5;
#declare ad_a[4]=<cos(4*pi/9-pi/2),sin(4*pi/9-pi/2),0>*0.5;
#declare ad_a[5]=<cos(5*pi/9-pi/2)-0.2,sin(5*pi/9-pi/2),0>*0.5;
#declare ad_a[6]=<cos(2*pi/3-pi/2)-0.4,sin(2*pi/3-pi/2),0>*0.5;
#declare ad_a[7]=<cos(7*pi/9-pi/2)-0.25,sin(7*pi/9-pi/2),0>*0.5;
#declare ad_a[8]=<cos(8*pi/9-pi/2)-0.23,sin(8*pi/9-pi/2),0>*0.5; 
#declare ad_a[9]=<cos(pi/2),sin(pi/2)+0.03,0>*0.5;

//-------shearing amounts
#declare tr_ad = array[10]
#declare tr_ad[0]=0.3;
#declare tr_ad[1]=0.2;
#declare tr_ad[2]=0.1;
#declare tr_ad[3]=0.0;
#declare tr_ad[4]=0;
#declare tr_ad[5]=0.0;
#declare tr_ad[6]=0.0;
#declare tr_ad[7]=0.21;
#declare tr_ad[8]=0.31;
#declare tr_ad[9]=0.4;

//---------blob components radii
#declare ra_ad = array[10]
#declare ra_ad[0] = 0.5;
#declare ra_ad[1] = 0.5;
#declare ra_ad[2] = 0.5;
#declare ra_ad[3] = 0.5;
#declare ra_ad[4] = 0.5;
#declare ra_ad[5] = 0.5;
#declare ra_ad[6] = 0.5;
#declare ra_ad[7] = 0.5;
#declare ra_ad[8] = 0.45;
#declare ra_ad[9] = 0.42;

 

#declare addome=
object {
lat_blob (ad_a,ra_ad,tr_ad,10,0.05,0.5,seed(1)) 
rotate -90*z 
scale <1,0.53,.65>*3.2 
texture {t_metal}
translate <4.6,2.5,0>           
}     



//------zampe----------legs

//-----lathe coordinates
#declare a_r_z= array[6]
#declare a_r_z[0]= .35;
#declare a_r_z[1]=.25;//.18;
#declare a_r_z[2]=.25;//.18;
#declare a_r_z[3]=.18;//.09;
#declare a_r_z[4]= .18;//.09;
#declare a_r_z[5]=.1;//.05;


//-------slope values for start/end lathe splines
#declare a_s_z=array[6]
#declare a_s_z[0]=5;
#declare a_s_z[1]=8;
#declare a_s_z[2]=8;
#declare a_s_z[3]=10;
#declare a_s_z[4]=10;
#declare a_s_z[5]=10;


//-----------legs relative positions
#declare _ang=array[8][4]
#declare _ang[0][0]= 60;
#declare _ang[0][1]= -74;
#declare _ang[0][2]= -77;
               #declare _ang[0][3]= -50;
#declare _ang[1][0]= 68;
#declare _ang[1][1]= -80;
#declare _ang[1][2]= -60;
              #declare _ang[1][3]=  -35;
#declare _ang[2][0]=  58;
#declare _ang[2][1]=  -75;
#declare _ang[2][2]=  -53;
              #declare _ang[2][3]=  45;
#declare _ang[3][0]= 60;
#declare _ang[3][1]= -65;
#declare _ang[3][2]= -60;
              #declare _ang[3][3]= 65;
#declare _ang[4][0]= 70;
#declare _ang[4][1]= -75;
#declare _ang[4][2]= -60;
              #declare _ang[4][3]= 70;
#declare _ang[5][0]= 68;
#declare _ang[5][1]= -86;
#declare _ang[5][2]= -80;
              #declare _ang[5][3]= 40;
#declare _ang[6][0]= 67;
#declare _ang[6][1]= -72;
#declare _ang[6][2]= -65;
              #declare _ang[6][3]= -35;
#declare _ang[7][0]= 63;
#declare _ang[7][1]= -80;
#declare _ang[7][2]=  -58;
              #declare _ang[7][3]=  -70;

#declare dist=0.6;  // distance between two legs
#declare c_d=0.7;   // distance between legs and the centre of abdomen

#declare zampe=
union {
#declare _z=1;
#while (_z<=8)

#declare a_l=array[3]
#declare a_l[0]=4;
#declare a_l[1]=4;
#declare a_l[2]=4;

object { 
zampa (
a_l,
a_r_z,//r_z, 
a_s_z,
10,
0.01,
_ang[_z-1][0],//ang1,
_ang[_z-1][1],//ang2,
_ang[_z-1][2],//ang3,
0.08/3*2,//lung,   length of hair
0.003*2,//rag,     radius of hair component (cylinder)
20,//_steps,       hair steps per leg segment
10,//n_step,       hairs per hair step
0.01,//max_ran_l,  random length
5,//max_rot,       random rotation
0.6,//ran,         randomness
seed(_z*1000),//RS,
t_metal,
t_metal)
 #if (_z<5) rotate _ang[_z-1][3]*y translate <3/2*dist-(_z-1)*dist,0,-c_d>
 #else rotate (180+_ang[_z-1][3])*y translate <3/2*dist-(_z-5)*dist,0,c_d> #end}
 
#declare _z=_z+1;
#end

translate 1.5*y}          

 

//---------cefalotorace--------head and chest


//---------lathe-blob coordinates
#declare ce_a = array[10]
#declare ce_a[0]=<cos(-pi/2),sin(-pi/2)-0.5,0>*0.5;
#declare ce_a[1]=<cos(pi/9-pi/2),sin(pi/9-pi/2)-0.4,0>*0.5;
#declare ce_a[2]=<cos(2*pi/9-pi/2)-0.05,sin(2*pi/9-pi/2)-0.3,0>*0.5;
#declare ce_a[3]=<cos(3*pi/9-pi/2)-0.03,sin(3*pi/9-pi/2)-0.15,0>*0.5;
#declare ce_a[4]=<cos(4*pi/9-pi/2),sin(4*pi/9-pi/2),0>*0.5;
#declare ce_a[5]=<cos(5*pi/9-pi/2)+0.1,sin(5*pi/9-pi/2),0>*0.5;
#declare ce_a[6]=<cos(2*pi/3-pi/2)+0.05,sin(2*pi/3-pi/2),0>*0.5;
#declare ce_a[7]=<cos(7*pi/9-pi/2),sin(7*pi/9-pi/2),0>*0.5;
#declare ce_a[8]=<cos(8*pi/9-pi/2),sin(8*pi/9-pi/2),0>*0.5; 
#declare ce_a[9]=<cos(pi/2)+0.1,sin(pi/2)+0.5,0>*0.5;

//--------shearing amounts
#declare tr_ce = array[10]
#declare tr_ce[0]=0.1;
#declare tr_ce[1]=0.1;
#declare tr_ce[2]=0.1;
#declare tr_ce[3]=0.0;
#declare tr_ce[4]=-0.05;
#declare tr_ce[5]=-0.2;
#declare tr_ce[6]=0.0;
#declare tr_ce[7]=0.;
#declare tr_ce[8]=0.;
#declare tr_ce[9]=0.;

//----------blob components radii
#declare ra_ce = array[10]
#declare ra_ce[0] = 0.5;
#declare ra_ce[1] = 0.5;
#declare ra_ce[2] = 0.5;
#declare ra_ce[3] = 0.5;
#declare ra_ce[4] = 0.5;
#declare ra_ce[5] = 0.35;
#declare ra_ce[6] = 0.5;
#declare ra_ce[7] = 0.5;
#declare ra_ce[8] = 0.5;
#declare ra_ce[9] = 0.5;

#declare cefalotorace=
object {
lat_blob (ce_a,ra_ce,tr_ce,10,0.05,0.5,seed(1)) 
rotate -90*z 
scale 2*<1,0.8,0.75>
translate <0.1,2.3,0>
texture {t_metal} 
 
}     
//--------occhi--------eyes 

#declare occhi=
union {
sphere {0,1 scale 0.18 translate <-1.5,-0.5,-0.25>}
sphere {0,1 scale 0.18 translate <-1.5,-0.5,0.25>} 
sphere {0,1 scale 0.18 translate <-1.1,-0.25,-0.4>}
sphere {0,1 scale 0.18 translate <-1.1,-0.25,0.4>}
sphere {0,1 scale 0.18 translate <-0.7,0.05,0.3>}
sphere {0,1 scale 0.18 translate <-0.7,0.05,-0.3>}
texture {t_metal} translate <-0.3,3.1,0>}      


//---------pedipalpi-------- I don't know the English term...


#declare pedipalpi=
union {
sphere_sweep {
linear_sphere_sweep
4,
<0,0,0>,0.2
<-1,0.7,0>,0.2
<-2.5,-0.5,0>,0.17
<-2.1,-1.2,0>,0.1
texture {t_metal} rotate -5*y scale .7 translate <-1.8,2,-.3>}

sphere_sweep {
linear_sphere_sweep
4,
<0,0,0>,0.2
<-1,0.7,0>,0.2
<-2.5,-0.5,0>,0.17
<-2.1,-1.2,0>,0.1
texture {t_metal} rotate 5*y scale .7 translate <-1.8,2,.3>}
}


#declare ragno=
union{
object {addome}
object {cefalotorace}
object {zampe}
object {occhi}
object {pedipalpi}
}

// ----------------------------------------



global_settings {
max_trace_level 15
}
#declare Location = <-4, 8,-14 >;
#declare Look_at = <0, 0, 0>;

camera
{
  location  Location
  look_at   Look_at   rotate 0*x rotate 60*y
}



light_source
{ <50, 40, -50>
  rgb <1, .98, .95>*2.5  
 }
       

// ----------------------------------------


sphere {0,200 hollow
no_shadow 
no_image 
pigment {image_map {tga "sky.tga" map_type 1 interpolate 2}}  // some cool reflections!     (you have to convert the file)
finish {ambient 2 diffuse 0}rotate -90*z}  

object {ragno}  // spider

                                                 