//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 3 materials and 28 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 06/12/2001    (12.06.2001)
//

#version unofficial MegaPov 0.7;
#include "colors.inc"
/* // Scene Comment

This scene was created with Moray For Windows.(Modified by Ceggi)

*/ // End Scene Comment

global_settings {
		ini_option "+QR"

  adc_bailout  // 0.05
                0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
        pretrace_start .08
        pretrace_end .002
        normal on
    brightness       1.4
    count            150
    error_bound      0.02
    gray_threshold   0.5
    low_error_factor 0.2  //0.5
    minimum_reuse    0.005
    nearest_count    3
    recursion_limit  1

  }
}

background { color <0.807843, 0.862745, 0.992157>*1.1 } 

camera {  //  Camera StdCam
  location  <     -0.169,     -13.239,      10.073>                                         
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <     -0.128,      -2.052,      -1.861>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <255/255, 251/255, 242/255>
  area_light <5.000, 0.000, 0.000>, <0.000, 5.000, 0.000>, 5, 5
  adaptive 0
  jitter
  fade_distance  10.0
  fade_power 2.0

  translate <5.0, -20.0, 20.0>                         
  rotate <3.0, 3.0, 1.0>
  //shadowless
}


//
// ********  MATERIALS  *******
//

#include "SkorMat3.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//




  sky_sphere {
         pigment
         {
            gradient z
            color_map
            {
            [0.0 color rgb < 0.999, 0.999, 1.0>]                  
            [1.0 color rgb <1.0, .95, 0.75>]                    

            }
         }      

}



#include "scorpio.inc"   

#declare mesh01_Ref = object {
  mesh01
  rotate <4.809499, 3.41601, 0.084745>                         
}
#declare mesh02_Ref = object {
  mesh02
  rotate <-7.065944, 3.801073, 0.072057>                      
}
#declare mesh03_Ref = object {
  mesh03
}
#declare mesh04_Ref = object {
  mesh04
}
#declare mesh05_Ref = object {
  mesh05
}
#declare mesh06_Ref = object {
  mesh06
}
#declare mesh07_Ref = object {
  mesh07
}
#declare mesh08_Ref = object {
  mesh08
}
#declare mesh09_Ref = object {
  mesh09
}
#declare mesh10_Ref = object {
  mesh10
}
#declare mesh11_Ref = object {
  mesh11
}
#declare mesh12_Ref = object {
  mesh12
}
#declare mesh13_Ref = object {
  mesh13
}
#declare mesh14_Ref = object {
  mesh14
}
#declare mesh15_Ref = object {
  mesh15
}
#declare mesh16_Ref = object {
  mesh16
}
#declare mesh17_Ref = object {
  mesh17
}
#declare mesh18_Ref = object {
  mesh18
}
#declare mesh19_Ref = object {
  mesh19
}
union { // Scorpio_group
  object { mesh01_Ref }
  object { mesh02_Ref }
  object { mesh05_Ref }
  object { mesh06_Ref }
  object { mesh07_Ref }
  object { mesh08_Ref }
  object { mesh09_Ref }
  object { mesh10_Ref }
  object { mesh11_Ref }
  object { mesh12_Ref }
  object { mesh13_Ref }
  object { mesh14_Ref }
  object { mesh15_Ref }
  object { mesh16_Ref }
  object { mesh17_Ref }
  object { mesh18_Ref }
  object { mesh19_Ref }
  
  material {
  
    insect
    rotate -90.0*y
    
  }
  scale 0.4
  rotate <-1.018346, -2.673913, -24.478058>
  translate  <0.978594, -6.076623, 0.108145>
  //no_shadow
  
}

union { // Chele_group
  object { mesh03_Ref }
  object { mesh04_Ref }
  
  material {
  
    chela
    
  }
  scale 0.4
  rotate <-1.018346, -2.673913, -24.478058>
  translate  <0.978594, -6.076623, 0.108145>
  //no_shadow
  
}


#include "scortext2.inc"      

#declare Armanisoft_0_Ref = object {
  Armanisoft_0  rotate <-1,0,0> translate <0,0,-0.04>
}
#declare Armanisoft_1_Ref = object {
  Armanisoft_1 rotate <0,1,0> translate <0,0,-0.04>
}
#declare Armanisoft_2_Ref = object {
  Armanisoft_2  rotate <0,-1,0> translate <0,0,-0.035>
}
#declare Armanisoft_3_Ref = object {
  Armanisoft_3   translate <0,0,-0.03>
}
#declare Armanisoft_4_Ref = object {
  Armanisoft_4
}
#declare Armanisoft_5_Ref = object {
  Armanisoft_5
}
#declare Armanisoft_6_Ref = object {
  Armanisoft_6
}
union { // logo
  object { Armanisoft_0_Ref }
  object { Armanisoft_1_Ref }
  object { Armanisoft_2_Ref }
  object { Armanisoft_3_Ref }
  object { Armanisoft_4_Ref }
  object { Armanisoft_5_Ref }
  object { Armanisoft_6_Ref }
  material {
    dustlogo

  }
  scale 1.5
  rotate 54.056065*z
  translate   <-3.92229, -6.06845, 0.009738>                        
    //no_shadow

}


object {   // HfSuolo
  height_field {
    tga "ground.TGA"       
    water_level 0.0
    smooth on
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    suolo
  }
  scale <9.0, 8.0, 0.42>
  translate  <2.034782, -4.220288, -0.08>
    //no_shadow

}


#include "foglia.inc"  
#declare foglia6_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 29.354994>
  translate  <2.076885, 0.487349, 0.560673>
}
#declare foglia7_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, -96.469437>
  translate  <2.362114, 0.798104, 0.550968>
}
#declare foglia8_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 143.61969>
  translate  <2.583726, 0.478013, 0.546515>
}
#declare CSG003 = union {
  object { foglia6_Ref }
  object { foglia7_Ref }
  object { foglia8_Ref }
}
#declare foglia9_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 29.354994>
  translate  <2.076885, 0.487349, 0.560673>
}
#declare foglia10_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, -96.469437>
  translate  <2.362114, 0.798104, 0.550968>
}
#declare foglia11_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 143.61969>
  translate  <2.583726, 0.478013, 0.546515>
}
#declare CSG004 = union {
  object { foglia9_Ref }
  object { foglia10_Ref }
  object { foglia11_Ref }
  scale <0.8, 0.8, 1.0>
  rotate -90.0*z
  translate  <1.848254, 2.4744, 0.099445>
}
union { // Aloe1
  object { CSG003 }
  object { CSG004 }
  scale 2.0
  translate  <-8.889714, -2.222888, -0.004866>
  //no_shadow
  
}


#declare foglia_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 29.354994>
  translate  <2.076885, 0.487349, 0.560673>
}
#declare foglia1_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, -96.469437>
  translate  <2.362114, 0.798104, 0.550968>
}
#declare foglia2_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 143.61969>
  translate  <2.583726, 0.478013, 0.546515>
}
#declare CSG001 = union {
  object { foglia_Ref }
  object { foglia1_Ref }
  object { foglia2_Ref }
}
#declare foglia3_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 29.354994>
  translate  <2.076885, 0.487349, 0.560673>
}
#declare foglia4_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, -96.469437>
  translate  <2.362114, 0.798104, 0.550968>
}
#declare foglia5_Ref = object {
  mesh01
  material {
    greentxt
  }
  scale 0.1
  rotate <0.0, -26.8901, 143.61969>
  translate  <2.583726, 0.478013, 0.546515>
}
#declare CSG002 = union {
  object { foglia3_Ref }
  object { foglia4_Ref }
  object { foglia5_Ref }
  scale <0.8, 0.8, 1.0>
  rotate -90.0*z
  translate  <1.848254, 2.4744, 0.099445>
}
union { // Aloe
  object { CSG001 }
  object { CSG002 }
  scale 2.0
  rotate -10*z
  translate  <-1.00875, -5.00428, 0.05839>
  //no_shadow
  
}


//***stones***

#include "stone.inc"

object {
  mesh01
  material {
    suolo
  }
  scale <0.119353, 0.103245, 0.111907>
  translate  <4.137955, -5.343936, 0.0>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale <0.143794, 0.124388, 0.134823>
  translate  <4.008065, -5.046418, 0.041556>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale <0.143794, 0.124388, 0.134823>
  translate  <3.544391, -4.913618, 0.041556>
  //no_shadow
}

object {
  mesh01
  material {
    suolo
  }
  scale <0.143794, 0.124388, 0.134823> * 1.2
  translate  <3.344391, -4.813618, 0.041556>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale 0.2
  translate  <3.675054, -5.119649, 0.041556>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale <0.122117, 0.087168, 0.116682>
  rotate <15.766709, -1.942598, -23.6728>
  translate  <-4.829883, -1.392106, 0.053459>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale <0.158462, 0.131043, 0.125609>
  translate  <-3.87931, -1.407242, 0.0>
  //no_shadow
}


object {
  mesh01
  material {
    suolo
  }
  scale 0.2
  translate  <-4.207026, -1.442267, -0.06>
  //no_shadow
}

object {
  mesh01
  material {
    suolo
  }
  scale 0.12
  translate  <-4.527026, -1.382267, 0.0>
  //no_shadow
}




//#version official 3.1;



