// Persistence of Vision Ray Tracer Scene Description File
// File:   RoundedColumn.inc
// Vers:   3.1
// Desc:   include file for tg_hunt.pov
// Date: 06/20/2001    (20.06.2001)
// Auth: Thomas de Groot

//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//


default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

//
// ********  MATERIALS  *******
//

//  $MRY$: 'TdG_Sandstone_rugged'


#declare Sandstone = 
   texture  // T_Grnt12
   {   
      pigment
      {
         granite
         pigment_map
         {
            [0.0   
               color rgb <0.996, 0.969, 0.8>
            ]
            [0.154 
               color rgb <0.996, 0.682, 0.604>
            ]
            [0.308 
               color rgb <0.906, 0.82, 0.714>
            ]
            [0.444 
               color rgb <0.816, 0.631, 0.537>
            ]
            [0.615 
               color rgb <0.89, 0.792, 0.675>
            ]
            [0.812 
               color rgb <0.973, 0.627, 0.627>
            ]
            [1.0   
               color rgb <0.996, 0.969, 0.8>
            ]
         }
         turbulence 0.6
         ramp_wave
         scale  <200.0, 3.0, 150.0>
         rotate -5.0 * z
      }   
      normal
      {
         bozo , 5.0
         bump_size 0.8
         turbulence 0.7
         ramp_wave
         rotate -90.0 * x
      }
   }
   texture  // T_Grnt17a
   {   
      pigment
      {
         granite
         pigment_map
         {
            [0.0   
               color rgb <0.027, 0.012, 0.012>
            ]
            [0.034 
               color rgbf <0.851, 0.812, 0.741, 0.235>
            ]
            [0.342 
               color rgbf <0.71164, 0.694, 0.82, 0.839>
            ]
            [0.462 
               color rgbf <0.631, 0.506, 0.471, 0.608>
            ]
            [0.632 
               color rgbf <0.851, 0.812, 0.741, 0.922>
            ]
            [0.983 
               color rgb <0.027, 0.012, 0.012>
            ]
            [1.0   
               color rgb <0.996, 0.969, 0.8>
            ]
         }
         turbulence 0.6
         ramp_wave
         scale  <150.0, 3.0, 200.0>
         rotate    <5.0, -10.0, 0.0>
      }   
      normal
      {
         bozo , 5.0
         bump_size 0.8
         turbulence 0.8
         ramp_wave
         rotate -90.0 * x
      }
   }
   texture  // T_Crack1
   {   
      pigment
      {
         granite
         pigment_map
         {
            [0.0   
               color rgbf <0.0, 0.0, 0.0, 0.6>
            ]
            [0.04  
               color rgbf <0.0, 0.0, 0.0, 1.0>
            ]
            [0.041 
               color rgbf <0.55, 0.09, 0.09, 0.8>
            ]
            [0.97  
               color rgbf <0.33, 0.33, 0.33, 0.9>
            ]
            [0.971 
               color rgbf <0.0, 0.0, 0.0, 0.9>
            ]
            [1.0   
               color rgbf <0.0, 0.0, 0.0, 1.0>
            ]
         }
         turbulence 0.85
         ramp_wave
         scale  <1.0, 2.0, 1.4>
         rotate    <-10.0, 0.0, 20.0>
      }
   }

#declare TdG_Sandstone_rugged = 
   material  // TdG_Sandstone_rugged
   {   
      texture { Sandstone }   
      rotate -90.0 * x
   }


//  $MRY$: 'TdG_RoughStone-dark'


#declare TdG_RoughStoneMdark = 
   material  // TdG_RoughStone-dark
   {   
      texture
      {
         granite
         texture_map
         {
            [0.0   
               // PG_Pierre8               
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <0.7, 0.6, 0.3, 0.0, 0.0> ]
                     [ 0.2     rgbft <0.4, 0.4, 0.4, 0.0, 0.0> ]
                     [ 0.9     rgbft <0.27, 0.27, 0.27, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.05, 0.05, 0.05, 0.0, 0.0> ]
                  }
                  scale  0.06
               }               
               normal
               {
                  bumps , 0.6
                  scale  0.05
               }               
               finish
               {
                  ambient 0.2
                  diffuse 0.5
                  phong 0.3
                  phong_size 30.0
               }
            ]
            [1.0   
               // CF_RoughStone               
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <0.499564, 0.499564, 0.499564, 0.0, 0.0> ]
                     [ 0.25    rgbft <0.649707, 0.649707, 0.649707, 0.0, 0.0> ]
                     [ 0.5     rgbft <0.499858, 0.499858, 0.499858, 0.0, 0.0> ]
                     [ 0.75    rgbft <0.699587, 0.699587, 0.699587, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.499644, 0.499644, 0.499644, 0.0, 0.0> ]
                  }
                  frequency 100.0
                  ramp_wave
               }               
               normal
               {
                  crackle , 1.0
                  warp
                  {
                     turbulence <0.500164, 0.500364, 0.499804>

                     omega 0.500404
                     lambda 1.999712
                  }
               }               
               finish
               {
                  ambient 0.1
                  diffuse 0.549996
                  specular 0.100002
                  roughness 1.0
               }               

               //  This texture was originally designed by Charles Fusner.

            ]

         }

         //  This texture is a combination of RoughStone originally designed by Chares Fusner,  and Pierre8

      }
   }


//
// ********  REFERENCED OBJECTS  *******
//

#declare RoundedColumnElement1 = union {
  superellipsoid { // ColumnElement1
    <1.0, 0.1>
    translate  1.0*z
    scale <0.5, 0.5, 0.24>
  }
  cylinder { // Joint1
    <0,0,1>, <0,0,0>, 1 
    material {
      TdG_RoughStoneMdark
    }
    scale <0.45, 0.45, 0.02>
    translate  0.48*z
  }
}




//
// ********  OBJECTS  *******
//
#declare Sx = seed(15455);
#declare Sy = seed(28313);
#declare Sz = seed(76521);

#declare RoundedColumn =
union { // RoundedColumn
  object { RoundedColumnElement1
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement2 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  0.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement3 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  1.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement4 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  1.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement5 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  2.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement6 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  2.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement7 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  3.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement8 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  3.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement9 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  4.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement10 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  4.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement11 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  5.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement12 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  5.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement13 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  6.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement14 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  6.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement15 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  7.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement16 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  7.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement17 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  8.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement18 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  8.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement19 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  9.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement20 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  9.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement21 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  10.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement22 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  10.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement23 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  11.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement24 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  11.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement25 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  12.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement26 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  12.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement27 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  13.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement28 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  13.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement29 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  14.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement30 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  14.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement31 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  15.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement32 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  15.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement33 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  16.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement34 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  16.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement35 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  17.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement36 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  17.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement37 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  18.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement38 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  18.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement39 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  19.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement40 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  19.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement41 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  20.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement42 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  20.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement43 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  21.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement44 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  21.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement45 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  22.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement46 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  22.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement47 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  23.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement48 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  23.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement49 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  24.0*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  object { // RoundedColumnElement50 -> RoundedColumnElement1
    RoundedColumnElement1
    translate  24.5*z
    material { TdG_Sandstone_rugged
      rotate <rand(Sx), rand(Sy), rand(Sz)>
      translate <rand(Sx), rand(Sy), rand(Sz)>
    }
  }
  scale <-1.0, 1.0, 1.0>
  rotate -90.0*x
}


