// Alien Insect
// by Slawomir Szczyrba
// steev@hot.pl

#declare head = julia_fractal {
                <-0.0083,0,-0.83,-0.025>
                quaternion
                cube
                max_iteration 5
}

#declare body = julia_fractal {
                <-0.0083,0,-0.83,-0.025>
                quaternion
                sqr
                max_iteration 5
                rotate -z*90
 }

#declare segment= julia_fractal {
                <-0.083,0,-1.00,-0.025>
                quaternion
                max_iteration 6
                rotate -z*90
                scale <0.5, 2.5, 0.5>
}

#declare segment2 = object {
                segment
                clipped_by{ plane {y, 0} }
}

#declare leg = merge {
 object { segment rotate -x*45 }
 object { segment translate <0,0.1,-2.1> }
 scale 0.5
}

#declare leg2 = merge {
 object { segment2 rotate x*45 }
 object { segment2 translate <0,0.1,-2.3> }
 object { segment2 rotate y*180 scale <1,0.8,1> rotate x*25 translate <0,0.1,-2.3> }
 sphere {<0,0.2,-2.3>, 0.5  scale <1,0.8,1>}
 scale 0.3
}

#declare eye = sphere {
 <0,0,0> 0.6
 pigment { White * 0.1 }
 finish {
  ambient 0.1
  brilliance 6
  diffuse 0.7
  metallic
  specular 0.80
  roughness 1/120
  reflection 0.7
  phong 1
  phong_size 10
 }
}

#declare skin = texture
{
 normal {bumps 0.6 scale 0.05}
 pigment { bozo
           turbulence 0.7
           color_map {
            [0.00 color Green *       1 ]
            [0.33 color Aquamarine *  0.8 ]
            [0.66 color Green *       0.6 ]
            [1.00 color GreenYellow * 0.4 ]
           } scale 0.3
 }
 finish {phong 0.3  phong_size 20}
}

#declare obcy = merge {
 object { head translate  <0,1.5,-0.5>  scale <1.5,1,1>}
 object { body }
 object { leg translate -z rotate -x*15 rotate  y*45 translate <-0.8,0.3,-0.2> }
 object { leg translate -z rotate -x*15 rotate -y*45 translate < 0.8,0.3,-0.2> }
 object { leg translate -z rotate  y*135 translate <0,-0.1,0.7>}
 object { leg translate -z rotate -y*135 translate <0,-0.1,0.7>}
 object { leg2 rotate x*20 translate -z*1.2 rotate  y*30}
 object { leg2 rotate x*20 translate -z*1.2 rotate -y*30}
 object { eye translate < 1.5,1.5,-0.5> }
 object { eye translate <-1.5,1.5,-0.5> }
 texture { skin }
}
