//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Main File
  
/* 7C - The Seven Columns of Mystique

	Built by the greatest mystical Creatures, to fight the Dark Druid, who is
	attempting to destroy all mystics.
	
	Living in feud amongst each other since ages, this time all the creatures
	unite	in the fight against the Dark Druid.
	
	The 7 Columns (in order of appearance on the image, starting at the front,
	going counter-clockwise to the right):
	
	Red: Red Knigth, Red Dragon 
	
	Yellow: (unfinished) (would have been: Alchemist, ...?)
	
	Black: (unfinished) (would have been: Skeleton, ...?)
	
	White: (unfinished) (would have been: Angel, Pegasus, ...?)
	
	Blue: (unfinished) (would have been: Fairy, ...?)
	
	Green: (unfinished) (would have been: Druid, ...?)
	
	Magic: (unfinished) (would have been: Wizard, ...?)

   2 month seemed to be by far too few time for finishing my picture, but I
   submit this entry anyway as the IRTC was the reason I started it. I will
   continue it nevertheless and post the final version in 1 or 2 years to the
   povray binaries group :)

*/  
  
#version unofficial MegaPov 0.7;

#declare CAM_POS   = <0, 1, -13>;
#declare CAM_TO    = <0, 1, 0>;
#declare CAM_DIR   = vnormalize(CAM_TO - CAM_POS);
#declare CAM_UP    = vnormalize(vcross(CAM_DIR, x));
#declare CAM_RIGHT = vcross(CAM_UP, CAM_DIR);

global_settings {

   assumed_gamma 2.2
   max_trace_level 30
           
   ini_option "+QR"           

   radiosity {
      pretrace_start 1
      pretrace_end 1 / 128

      error_bound 1
      low_error_factor 1/8
      recursion_limit 2

      nearest_count 4

      count 32

      media on
   }

}

camera {
   location CAM_POS
   direction CAM_DIR
   up CAM_UP
   right CAM_RIGHT * 4/3
}

sky_sphere {
   pigment {
      gradient y
      color_map {
         [ 0 color rgb <1, 1, 1>]
         [ 0.1 color rgb <0, 0, 0.04>]
         [ 0.3 color rgb <0, 0, 0.05>]
         [ 0.45 color rgb <0.1, 0.1, 0.4>]
         [ 0.55 color rgb <0.4, 0.2, 0.0>]
         [ 0.9 color rgb <0.3, 0.5, 0.3>]
         [ 0.9 color rgb <0, 0, 0.04>]
         [ 1 color rgb <1, 1, 1>]
      }
      ramp_wave
      scale 2
      translate y * 1
   }
}
  
#include "candle.inc"
         
#local N = 0;
#while(N < 7)

   #switch(N)
      #case(0)
         #include "column1.inc"
         #declare column = object { column1 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(1)
         #include "column2.inc"
         #declare column = object { column2 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(2)
         #include "column3.inc"
         #declare column = object { column3 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(3)
         #include "column4.inc"
         #declare column = object { column4 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(4)
         #include "column5.inc"
         #declare column = object { column5 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(5)
         #include "column6.inc"
         #declare column = object { column6 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
      #case(6)
         #include "column7.inc"
         #declare column = object { column7 }
         #declare C = <1, 0, 0>;
         #declare CL = <1.0, 0.7, 0.2>;
      #break
   #end

   union {
      object {
         column
      }

      #local CandleN = 0;
      #while(CandleN < 7)
         #local Pos = vrotate(<0, 1, -1.6>, <0, -5 + 360 * CandleN / 7, 0>) +
            <0, 1, 0>;

         placeCandle(column, Pos, C, CL)

         #set CandleN = CandleN + 1;
      #end

      translate z * -7
      rotate y * 360 * -N / 7

   }

   #declare N = N + 1;

#end

#include "dragon.inc"

#declare DragonColumn = object {
   column1
   translate z * 1
   rotate y * -210
   scale 4

}

PlaceDragon(DragonColumn)

object {
   Dragon
   scale 1 / 4
   rotate y * 210
   translate z * -8
}
       

#include "spider.inc"

object {
   o_spider
   scale 0.04
   rotate y * 160
   rotate z * 90

   translate <-1.8, -1.7, 0>
   rotate y * 360 * 2 / 7

   translate z * -7
   rotate y * 360 * -2 / 7
}

#include "skull.inc"

object {
   skull
   scale 0.2
   rotate y * 180

   translate <0, 0, -0.2>
   rotate y * 360 * -5 / 7

   translate z * -7
   rotate y * 360 * -5 / 7

}



#include "knight.inc"

object {
   knight
   scale 1
   rotate y * 40
   translate <-0.6, 0.3, -7.9>
}

#declare m_stone = material {
   texture {
      pigment { color rgb <0.8, 0.6, 0.4> }
      finish {
         ambient 0
         diffuse 0.5
      }
   }
}

#declare Arch = union {
   box {
      <-3, -50, -3> <3, 20, 3>
      material { m_stone }
      translate x * -6
   }
   box {
      <-3, -50, -3> <3, 20, 3>
      material { m_stone }
      translate x * 6
   }
   box {
      <-9, 0, -3> <9, 6, 3>
      material { m_stone }
      translate y * 20
   }
}


union {
   object { Arch }

   #declare FOG_LIGHT_POS = <0, 32, 30>;

   light_source {
      FOG_LIGHT_POS
      rgb 1

   }

   rotate y * 17
   translate <10, 0, 30>
}

sphere {
   0 100
   hollow

   interior {
      media {
         method 3
         intervals 1
         samples 3, 1000

         sample_spacing 0.1

         ratio 1

         scattering {
            2, 4 / 1000
         }

      }

   }

   pigment { color rgbf 1 }
   finish { ambient 0 }
   translate  FOG_LIGHT_POS
   rotate y * 17
   translate <10, 0, 30>
}


#include "wall.inc"

object {
   wall
   translate <-20, -40, 40>
}           
    
#undef C

union {
 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}

      scale 0.03
      scale <1,1,0.1>

      translate <0.06,0.02,0>

      matrix <
         CAM_RIGHT.x, CAM_RIGHT.y, CAM_RIGHT.z,
         CAM_UP.x, CAM_UP.y, CAM_UP.z,
         CAM_DIR.x, CAM_DIR.y, CAM_DIR.z,
         CAM_POS.x, CAM_POS.y, CAM_POS.z
      >

      translate CAM_RIGHT*-4/3
      translate CAM_UP*-1
      translate CAM_DIR*2
   }

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}

created by Elias Pschernig elias@users.sourceforge.net*/  