//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Dragon Include File

#version unofficial MegaPov 0.7;

#declare m_skin = material {
   texture {
      pigment {
         color rgb <.6, .5, .1>
      }
      finish {
         ambient 0
         diffuse 0.7
         specular .4
         roughness 0.04
         reflection 0.05
      }
      normal {
         crackle
         scale 0.25
      }
   }
}

#declare m_bone = material {
   texture {
      pigment {
         color rgb <1, .8, .6>
      }
      finish {
         ambient 0
         diffuse 0.9
         specular .6
         roughness 0.01
         reflection 0.1
         brilliance 0
      }
   }
}

#declare m_white = material {
   texture {
      pigment {
         color rgbf <1,1,1,0.1>
      }
      finish {
         ambient 0
         diffuse 1
         specular .8
         roughness 0.01
      }
   }
}

#declare m_black = material {
   texture {
      pigment {
         color rgb <0,0,0>
      }
      finish {
         ambient 0
         diffuse 1
         specular 1
         roughness 0.01
      }
   }
}

#declare head = union {
   sphere {
      z 1
   }
   cone {
      <0, .9, 0> .2 <0, 2, 0> 0
      material { m_bone }
      rotate x * 30
      translate z
   }
   union {
      cylinder {
         0 z 1
      }
      sphere {
         z 1
      }
      scale <.8, .4, 1>
      translate <0, -.5, 1>
   }
   sphere {
      <-0.4, -.4, 3> .5
   }
   sphere {
      <0.4, -.4, 3> .5
   }
   material { m_skin }
}

#declare leg = object {
   sphere { 0 .5 }
   translate z * 0.5
   material { m_skin }
}

#declare foot = union {
   sphere { 0 1 }

   cone {
      0.9*z .4 1.6*z 0
      material { m_bone }
      rotate x*30
   }

   cone {
      0.9*z .4 1.6*z 0
      material { m_bone }
      rotate y * 30
      rotate x*30
   }

   cone {
      0.9*z .4 1.6*z 0
      material { m_bone }
      rotate y * -30
      rotate x*30
   }

   scale 0.5
   translate z * 0.5
   material { m_skin }
}

#declare u_legright = union {
   object {
      leg
   }
   object {
      foot
      translate z * 0.5
   }
   rotate y * 90
}

#declare u_legleft = union {
   object {
      leg
   }
   object {
      foot
      translate z * 0.5
   }
   rotate y * -90
}

#declare u_eye = union {

   difference {
      sphere {
         <0, 0, 1> 1.2
      }

      plane {
         y .2
         rotate x * -30
      }
      material { m_skin }
   }

   sphere {
      <0, 0, 1> 1
      material { m_white }
   }
   sphere {
      <0, 0, 1.9> 0.5
      material { m_black }
   }
   scale 0.3
}

#declare u_head = union {
   object {
      head
   }
   object {
      u_eye
      translate <-0.5, 0.1, 1.7>
   }
   object {
      u_eye
      translate <0.5, 0.1, 1.7>
   }

}


// R, N, Position, Turned
#macro u_tail_elem(R, N, Position, Turned)
   union {
      sphere {
         0 R
         material { m_skin }
      }
      cone {
         y * 0.9 * R 0.2 * R y * 1.5 * R 0
         material { m_bone }
      }
      #if(N = 0 | N = 5)
         object {
            u_legleft
            rotate z * 10 / ((1+N)*0.5)

            translate -x * 0.5 * R
         }
         object {
            u_legright
            rotate z * -10 / ((1+N)*0.5)

            translate x * 0.5 * R
         }
      #else
         cylinder {
            -x * R * 1.1 x * R * 1.1 0.1 * R
            material { m_bone }
         }
      #end
      rotate y * Turned
      translate Position
   }

#end

#macro PlaceDragon(Object)
   #declare u_tail = union {
      #local N = 0;
      #local Position = <0, 0, 0>;
      #local R = 1;
      #local D = <0, 0, -1>;
      #local T = 25;
      #local Turned = 0;
      #local YLevel = 0;
      #while(N < 30)

         #local D = vaxis_rotate(-z, y, Turned);
         #local Turned = Turned + T;

         #local T = T * 0.94;

         #local R = R * 0.94;

         #local Position = Position + D * R * 0.8;
         //#local Position = Position - y * R * 0.06;

         #local Norm = <0, 0, 0>;
         #local Pos = trace(Object, Position + y, -y, Norm);

         #if(Norm.x = 0 & Norm.y = 0 & Norm.z = 0)
            #set Pos = Position + y * YLevel;
         #end

         #if(YLevel - Pos.y > 0.5 * R) #set Pos = <Pos.x, YLevel - 0.5 * R, Pos.z>; #end
         #if(YLevel - Pos.y < -0.5 * R) #set Pos = <Pos.x, YLevel + 0.5 * R, Pos.z>; #end
         #local YLevel = Pos.y;

         u_tail_elem(R, N, Pos - y, Turned)

         #local N = N + 1;
      #end

   }

   #declare Dragon = union {
      object {
         u_head

         #local NormPos = y;
         #local Pos = trace(Object, NormPos + y, -y, Norm);
         translate Pos
      }

      object {
         u_tail
         translate y
      }

   }
#end

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  