//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Flame Include File

#version unofficial megapov 0.7;

/* Works also without megapov, but then you have to double the media, make the second one
   an absorption media instead of emission, and use (1 - color) instead of (color) there
*/

// 2 color media flame material by Elias Pschernig
// version 0.5 megapov WIP!
#macro material_flame(
   Opacity1,         // outside(red part of flame) opacity, default = 1
   Opacity2,         // inside (light part of flame) opacity, default = 1
   Color1,           // red color, default = <.8,.5,0>  (gives orange glowing flame)
   Color2,           // yellow color, default = <1,1,.6> (gives yellow flame light)
   Falloff,          // the higher this value, the more the flame is pushed away from its bottom, default = 2
   Strength,         // increases the above, dfault = 1
   InverseFalloff,   // the higher this value, the more the flame is pulled to its top, default = 2
   InverseStrength,  // increases the above, default = 1
   Rotate,
   Offset,
   Turbulence)

   material{
      texture {

         pigment { color rgbf 1 }
         finish { ambient 1 diffuse 0 }
      }


      interior {
         media {
            emission { 1, rgb 1 1 }

            method 3
            intervals 1
            samples 3, 1000
            sample_spacing 0.1

            density {
               spherical
               color_map {
                  [0.0, color rgb 0]
                  [0.25, color Opacity1 *( Color1 )]
                  [0.75, color Opacity2 *( Color2 )]
                  [1.0, color rgb Opacity2]
               }
               warp {
                  black_hole (<0,-1,0>) 2
                  falloff InverseFalloff
                  strength InverseStrength
                  inverse
               }
               warp {
                  black_hole (<0,1,0>+Offset) 2
                  falloff Falloff
                  strength Strength
               }
               turbulence Turbulence
               rotate z*Rotate
            }
         }
      }
   }
#end

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/