//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Knight's Head Include File

#version unofficial megapov 0.7;

// T = minor radius
// R1 = lower mayor radius
// R2 = upper mayor radius
// Y1 = lower Y
// Y2 = upper Y
#macro hollowcone(Y1, R1, Y2, R2, T)

   union {
      #if(R1 != R2)

         #local G = (Y2 - Y1) / (R1 - R2);               // gradient of the cone

         #local H = sqrt(T * T * ( 1 + 1 / (G * G) ) );  // horizontal distance to inner cone
         #local V = sqrt(T * T / (1 + G * G) );          // vertical distance to inner cone

         #local YD = Y1 - V;
         #local RD = R1 - V * G + H * 2;

         #local YU = Y2 + V;
         #local RU = R2 + V * G;

         difference {
            intersection {
               cone { // The outer cone
                  y * YD RD
                  y * YU RU
               }
               cone { // Cut off bottom rim, orthogonal to side
                  y * (Y1 - V) R1 - V * G // down
                  y * (Y1 + (YU - Y1)) R1 + (YU - Y1) * G // up
               }
            }
            cone { // The inner cone
               y * YD RD - H * 2
               y * YU RU - H * 2
            }
            cone { // Cut off top rim, orthogonal to side
               // *2 to avoid coincident surfaces problem
               y * (Y2 + V * 2) R2 + V * 2 * G // up
               y * (Y2 - V) (R2 - V * G) // down
            }
         }
      #else
         difference {
            cylinder { // outer cylinder
               y * Y1 y * Y2 R1 + T
            }
            cylinder { // inner cylinder
               y * (Y1 - T) y * (Y2 + T) R1 - T
            }
         }
      #end

      torus { // Round upper rim
         R1 T
         translate y * Y1
      }
      torus { // Round lower rim
         R2 T
         translate y * Y2
      }

   }
#end

#declare Head = union {

   union {

      hollowcone( 0.90, 0.75, 1.00, 0.75, 0.02)
      sphere { 0 0.75 scale <1, 0.02, 1> translate y * 1.02}
      hollowcone( 0.01, 1.00, 1.00, 0.70, 0.02)


      difference {
         hollowcone(-1.10, 1.10, -0.01, 1.00, 0.02)

         box {
            <-0.50,  0.00, 0.00>
            < 0.50, -0.20, 1.20>
         }
         box {
            <-0.10,  0.00, 0.00>
            < 0.10, -1.20, 1.20>
         }
      }

      material { m_metal }
      
   }

   translate y * 1.10
   scale 0.10
}

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  