//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Knight Include File

#version unofficial megapov 0.7;

#declare A1_body           = <  -10,  0.00,  0.00>;

#declare A1_head           = <   -20,  0.00,  0.00>;
#declare A1_eyeright       = <  0.00,  0.00,  0.00>;
#declare A1_eyeleft        = <  0.00,  0.00,  0.00>;

#declare A1_armright       = <  -40,   90,   0.00>;
#declare A1_lowerarmright  = <  0.00,  -20,  0.00>;
#declare A1_handright      = <  0.00,  0.00,  0.00>;

#declare A1_armleft        = <     0,     0, 90.00>;
#declare A1_lowerarmleft   = <    20,     0,  0.00>;
#declare A1_handleft       = <  0.00,  0.00,  0.00>;

#declare A1_legright       = <   -10,  10.00,  10.00>;
#declare A1_lowerlegright  = <    10,  0.00,  0.00>;
#declare A1_footright      = <  0.00,  0.00,  0.00>;

#declare A1_legleft        = <   -10,  0.00,  0.00>;
#declare A1_lowerlegleft   = <    10,  0.00,  0.00>;
#declare A1_footleft       = <  0.00,  0.00,  0.00>;

#declare A2_body           = <  0.00,  0.00,  0.00>;

#declare A2_head           = <  0.00,  0.00,  0.00>;
#declare A2_eyeright       = <  0.00,  0.00,  0.00>;
#declare A2_eyeleft        = <  0.00,  0.00,  0.00>;

#declare A2_armright       = <  0.00,  0.00,  0.00>;
#declare A2_lowerarmright  = <  0.00,  0.00,  0.00>;
#declare A2_handright      = <  0.00,  0.00,  0.00>;

#declare A2_armleft        = <-60.00,-30.00,  0.00>;
#declare A2_lowerarmleft   = <  0.00,  0.00,  0.00>;
#declare A2_handleft       = <  0.00,  0.00,  0.00>;

#declare A2_legright       = <  0.00,  0.00,  0.00>;
#declare A2_lowerlegright  = <  0.00,  0.00,  0.00>;
#declare A2_footright      = <  0.00,  0.00,  0.00>;

#declare A2_legleft        = <  0.00,  0.00,  0.00>;
#declare A2_lowerlegleft   = <  0.00,  0.00,  0.00>;
#declare A2_footleft       = <  0.00,  0.00,  0.00>;


#declare P_body           = <  0.00,  0.00,  0.00>;

#declare P_head           = <  0.00,  0.30,  0.00>;
#declare P_eyeright       = < +0.04,  0.15,  0.10>;
#declare P_eyeleft        = < -0.04,  0.15,  0.10>;

#declare P_armright       = < +0.16,  0.24,  0.00>;
#declare P_lowerarmright  = <  0.00,  0.00,  0.15>;
#declare P_handright      = <  0.00,  0.00,  0.20>;

#declare P_armleft        = < -0.16,  0.24,  0.00>;
#declare P_lowerarmleft   = <  0.00,  0.00,  0.15>;
#declare P_handleft       = <  0.00,  0.00,  0.20>;

#declare P_legright       = < +0.08,  0.00,  0.00>;
#declare P_lowerlegright  = <  0.00, -0.20,  0.00>;
#declare P_footright      = <  0.00, -0.25,  0.00>;

#declare P_legleft        = < -0.08,  0.00,  0.00>;
#declare P_lowerlegleft   = <  0.00, -0.20,  0.00>;
#declare P_footleft       = <  0.00, -0.25,  0.00>;

#declare m_metal = material {
   texture {
      pigment {
         color rgb <1, 0.8, 0.8>
      }
      finish {
         ambient 0.1
         diffuse 0.9
         reflection 0.1
         specular 1
         roughness 0.01
         brilliance 1.2
      }
   }
}

#declare Foot = union {

   sphere {
      0 1
      scale 0.05
   }
   
   intersection {
      plane { -y 0 }
      union {
         sphere { 0 1 }
         cone { 0 1 z * 4 0 }
      }
      translate - y * 2   
      scale 0.05
   }
   material { m_metal }
}


#include "head.inc"
#include "body.inc"
#include "sword.inc"
#include "hand.inc"

/*#declare Eye = sphere {
   0 1
   material { m_eyewhite }
   scale 0.05
} */

#declare HandRight = union {

   /*sphere {
      0 1
      material { m_metal }
      scale 0.05
   } */

   union {
      object {
         metalhand
         scale 0.12
         rotate z * -90

      }

      object {
         sword
         scale 0.7
         translate <0.08, 0.05, 0.05>
      }
      rotate y * -40
      translate <-0.03, 0.05, -0.05>
   }


}

#declare HandLeft = union {

   sphere {
      0 1
      material { m_metal }
      scale 0.05
   }

   object {
      shield
      rotate x * 90
      scale 0.7
      translate <0, 0.02, 0.2>
   }
}

#declare UpperArm = union {
   sphere {
      0 0.05
   }
   cylinder {
      0 z 1
      scale <0.05, 0.05, 0.15>
   }
   material { m_metal }
}

#declare LowerArmLeft = union{
   sphere {
      0 0.05
   }
   cylinder {
      0 z 1
      scale <0.05, 0.05, 0.20>
   }


   material { m_metal }
}

#declare LowerArmRight = union{
   sphere {
      0 0.05
   }
   cylinder {
      0 z 1
      scale <0.05, 0.05, 0.20>
   }

   material { m_metal }
}

#declare UpperLeg = union {
   sphere {
      0 0.05
   }
   cylinder {
      -y 0 1
      scale <0.05, 0.2, 0.05>
   }
   material { m_metal }
}

#declare LowerLeg = union {
   sphere {
      0 0.05
   }
   cylinder {
      -y 0 1
      scale <0.05, 0.25, 0.05>
   }
   material { m_metal }
}

#declare body = Body
#declare head = Head

//#declare eyeright = Eye

#declare upperlegright = object { UpperLeg }
#declare lowerlegright = object { LowerLeg }
#declare footright = object { Foot }

#declare upperarmright = object { UpperArm }
#declare lowerarmright = object { LowerArmRight }
#declare handright = object { HandRight }

//#declare eyeleft = Eye

#declare upperlegleft = object { UpperLeg }
#declare lowerlegleft = object { LowerLeg }
#declare footleft = object { Foot }

#declare upperarmleft = object { UpperArm }
#declare lowerarmleft = object { LowerArmLeft }
#declare handleft = object { HandLeft }

#include "structure.inc"

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  