//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Skull Include File

#declare t_bone =
   material {
      texture {
         pigment {
            agate
            agate_turb 0.5
            color_map
            {
               [ 0.0     rgb 1 ]
               [ 0.5     rgb 1 ]
               [ 1.0     rgb <0.9, 0.8, 0.7> ]
            }
         }
         finish
         {
            ambient 0.0
            diffuse 0.4
            roughness 0.01
            specular 0.1
         }
      }
   }

#declare t_tooth =
   material
   {
      texture {
         pigment {
            color rgb <1,1,1>
         }
         finish {
            ambient 0.1
            diffuse 0.9
            roughness 0.01
            specular 0.4
            brilliance .1
         }
      }
   }

#declare dent = object {
   cone {
      0,0,y,1
      rotate -180.0*x
      translate y*1
      scale <0.07, 0.4, 0.07>
      material { t_tooth }
   }
}

#declare lowerjawplate = union {
   torus {
      0.9, 0.1
   }
   torus {
      0.9, 0.1
      translate  -0.1*y
   }
   cylinder {
      y, 0, 1
      scale <1,0.1,1>
      translate -0.1*y
   }
   material { t_bone }
}

#declare lowerdent = object {
  object {
    dent
    rotate -15*z
    translate 0.9*x
  }
}

#declare lowerdents = union {
   #declare i=0;
   #while (i<=20)
      object {
         lowerdent
         rotate 9*y*i
      }
      #declare i=i+1;
   #end
}


#declare jaw = union {
  object { lowerjawplate }
  object { lowerdents }
}

#declare upperskullplate = union {
   difference {
      sphere {
         0,1
      }
      box {
         <-1, -1, -1>, <1, 1, 1>
         scale <1.2, 0.6, 1.2>
         translate -0.6*y
      }
      sphere {
         0,1
         scale <0.2,0.5,0.4>
         translate <0.0,0.3,-1.0>
      }
      sphere {
         0,1
         scale 0.4
         translate <-0.5,0.5,-0.5>
      }
      sphere {
         0,1
         scale 0.4
         translate <0.5,0.5,-0.5>
      }
   }
   torus {
      0.9,0.1
   }
   material { t_bone }
}

#declare upperdent = object {
   object {
      dent
      rotate -180.0*x
      translate 0.9*x
   }
}

#declare upperdents = union {
   #declare i=0;
   #while (i<=20)
      object {
         upperdent
         rotate 9*y*i
      }
      #declare i=i+1;
   #end
}

#declare bigdent = object {
   cone {
      0,0,y,1
      translate y*-1
      scale <0.1,0.8,0.1>
      translate z*-0.9
   }
   material { t_tooth }
}

#declare upperskull = union {
   object { upperskullplate }
   object {
      bigdent
      rotate y*18
   }
   object {
      bigdent
      rotate y*-18
   }
   object { upperdents }
}

#declare skull = union {
   object {
      upperskull
      translate -z
      rotate x*45
      translate z
      translate y*-0.5
      rotate x*50
   }
   object {
      jaw
      rotate x*70
   }
   rotate x * -90

}

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  