#macro libro_cerrado(t_cubierta,t_lomo)

union{
 difference{
  superellipsoid{<.01,.01> rotate 90*x scale .5}
  box{-.5,.5 scale <.9,1.1,1> translate .05*z}
  texture{t_lomo}
 }
 box{-.5,.5
  texture{
   pigment{
    marble
    color_map{
     [0.0 color Flesh]
     [0.5 color Flesh]
     [0.5 color Flesh*.5]
     [1.0 color Flesh*.5]
    }
    scale 0.2
   }
  }
  scale <.9,.98,.9> translate .05*z
 }
}

#end

#declare t_libro_sucio=
texture{
 pigment{
  bozo turbulence .5
  color_map{
   [0 Clear]
   [1 DarkTan*.1 filter 0.5]
  }
  scale 10
 }
}

// *** libro 1 ***
#declare f_cubierta=
 finish{Phong_Dull metallic}
#declare n_cubierta=
normal{
 crackle 0.025
 scale <0.1,0.12,0.1>
 turbulence 0.2
}
#declare n_letras=
normal{
 dents
 turbulence 0.2
}
#declare p_cubierta=
 pigment{Firebrick*0.8}
#declare p_letras =
 pigment{OldGold}
#declare f_letras=
 finish{F_MetalB}
#declare t_cubierta=
 texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
 }
 texture{t_libro_sucio}
#declare t_lomo=
 texture{
  material_map{
   png "lomo1_im.png"
   texture{
    pigment{p_letras}
    normal{n_letras}
    finish{f_letras}
   }
   texture{t_cubierta}
  }
  translate -0.5
 }
#declare libro1=
object{libro_cerrado(t_cubierta,t_lomo)}

// **** libro 2 ****
#declare f_cubierta=
 finish{Dull metallic}
#declare p_cubierta=
 pigment{DarkBrown}
#declare p_letras =
 pigment{Silver}
#declare t_cubierta=
 texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
 }
 texture{t_libro_sucio}
#declare t_lomo=
 texture{
  material_map{
   png "lomo2_im.png"
   texture{
    pigment{p_letras}
    normal{n_letras}
    finish{f_letras}
   }
   texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
   }
  }
  translate -0.5
 }
#declare libro2=
object{libro_cerrado(t_cubierta,t_lomo)}

// *** libro 3 ***
#declare f_cubierta=
 finish{metallic}
#declare p_cubierta=
 pigment{Tan}
#declare p_letras =
 pigment{DarkBrown}
#declare t_cubierta=
 texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
 }
 texture{t_libro_sucio}
#declare t_lomo=
 texture{
  material_map{
   png "lomo3_im.png"
   texture{
    pigment{p_letras}
    normal{n_letras}
    finish{f_letras}
   }
   texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
   }
  }
  translate -0.5
 }
#declare libro3=
object{libro_cerrado(t_cubierta,t_lomo)}

// *** libro 4 ***
#declare f_cubierta=
 finish{Phong_Shiny metallic}
#declare p_cubierta=
 pigment{HuntersGreen}
#declare p_letras =
 pigment{Gold}
#declare t_cubierta=
 texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
 }
 texture{t_libro_sucio}
#declare t_lomo=
 texture{
  material_map{
   png "lomo2_im.png"
   texture{
    pigment{p_letras}
    normal{n_letras}
    finish{f_letras}
   }
   texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
   }
  }
  translate -0.5
 }
#declare libro4=
object{libro_cerrado(t_cubierta,t_lomo)}

// *** libro 4 ***
#declare f_cubierta=
 finish{Phong_Shiny}
#declare p_cubierta=
 pigment{DarkTan*.5+Firebrick*.1}
#declare p_letras =
 pigment{Gold}
#declare t_cubierta=
 texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
 }
 texture{t_libro_sucio}
#declare t_lomo=
 texture{
  material_map{
   png "lomo2_im.png"
   texture{
    pigment{p_letras}
    normal{n_letras}
    finish{f_letras}
   }
   texture{
    pigment{p_cubierta}
    normal{n_cubierta}
    finish{f_cubierta}
   }
  }
  translate -0.5
 }
#declare libro5=
object{libro_cerrado(t_cubierta,t_lomo)}

// *** rows constructions ***
#include "i_bookplacer_v2.inc"
#declare num_of_books=7;
#declare sep_disorder=0.9;
#declare sgn_disorder=0.2;
#declare r_books=seed(47);
#declare a_books=array[num_of_books]
books_row(a_books,<4,22,12>,<7,24,16>,1,5,sep_disorder,sgn_disorder,r_books,0)
#declare i_books=0;
#declare books_row_01=
union{
#while (i_books<num_of_books)
 #declare book_size=a_books[i_books][0];
 #declare book_pos=a_books[i_books][1];
 #declare book_ang=a_books[i_books][2];
 #declare sg=1;
 #if (book_ang.z<0)
  #declare sg=-1;
 #end
 #switch (int(4.99*rand(r_books)))
 #case (0)
 object{libro1
 #break
 #case (1)
 object{libro2
 #break
 #case (2)
 object{libro3
 #break
 #case (3)
 object{libro4
 #break
 #case (4)
 object{libro5
 #break
 #end
  rotate 180*y
  scale book_size*.99
  translate book_pos.y*y
  translate sg*book_size.x*.5*x
  rotate book_ang.z*z
  #if (book_ang.z<0)
  translate book_size.x*x
  #end
  translate book_pos.x*x
  translate book_pos.z*z
 }
 #declare i_books=i_books+1;
#end
}
#declare num_of_books=10;
#declare sep_disorder=0.1;
#declare sgn_disorder=0.1;
#declare r_books=seed(15);
#declare a_books=array[num_of_books]
books_row(a_books,<4,20,12>,<8,23,16>,1,3,sep_disorder,sgn_disorder,r_books,0)
#declare i_books=0;
#declare books_row_02=
union{
#while (i_books<num_of_books)
 #declare book_size=a_books[i_books][0];
 #declare book_pos=a_books[i_books][1];
 #declare book_ang=a_books[i_books][2];
 #declare sg=1;
 #if (book_ang.z<0)
  #declare sg=-1;
 #end
 #switch (int(4.99*rand(r_books)))
 #case (0)
 object{libro1
 #break
 #case (1)
 object{libro2
 #break
 #case (2)
 object{libro3
 #break
 #case (3)
 object{libro4
 #break
 #case (4)
 object{libro5
 #break
 #end
  scale book_size*.99
  translate book_pos.y*y
  translate sg*book_size.x*.5*x
  rotate book_ang.z*z
  #if (book_ang.z<0)
  translate book_size.x*x
  #end
  translate book_pos.x*x
  translate book_pos.z*z
 }
 #declare i_books=i_books+1;
#end
}
#declare num_of_books=9;
#declare sep_disorder=0.7;
#declare sgn_disorder=0.2;
#declare r_books=seed(6);
#declare a_books=array[num_of_books]
books_row(a_books,<4,19,12>,<7,23,16>,1,4,sep_disorder,sgn_disorder,r_books,0)
#declare i_books=0;
#declare books_row_03=
union{
#while (i_books<num_of_books)
 #declare book_size=a_books[i_books][0];
 #declare book_pos=a_books[i_books][1];
 #declare book_ang=a_books[i_books][2];
 #declare sg=1;
 #if (book_ang.z<0)
  #declare sg=-1;
 #end
 #switch (int(4.99*rand(r_books)))
 #case (0)
 object{libro1
 #break
 #case (1)
 object{libro2
 #break
 #case (2)
 object{libro3
 #break
 #case (3)
 object{libro4
 #break
 #case (4)
 object{libro5
 #break
 #end
  scale book_size*.99
  translate book_pos.y*y
  translate sg*book_size.x*.5*x
  rotate book_ang.z*z
  #if (book_ang.z<0)
  translate book_size.x*x
  #end
  translate book_pos.x*x
  translate book_pos.z*z
 }
 #declare i_books=i_books+1;
#end
}
