//********************************************************
// Persistence Of Vision raytracer version 3.1g
// Bird wing defnition type 0.1a010702a include File
// By S.Nishimura
//********************************************************


//**********************************************************************************
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px= 80*cos(Se)*cos(Ss); #local Py=10*sin(Se); #local Pz=20*cos(Se)*sin(Ss); #break
  #case(2) #local Px=-80*cos(Se)*cos(Ss); #local Py=10*sin(Se); #local Pz=20*cos(Se)*sin(Ss); #break
 #end
#end
//----------------------------------------------------------------------------------
#local Ra=20;
#local Wing_Lseg =
union {
 sphere { 0,Ra }
 cone { 0,Ra, -5*Ra*z,0.7*Ra }
 sphere { -5*Ra*z,0.7*Ra }
 clipped_by { plane { x,0 } }
 scale < 1,0.1,1 >
}
#local Sr=1/3;
#local Wing_Rseg =
union {
 sphere { 0,Ra*Sr }
 cone { 0,Ra*Sr, -(Ra*(1-Sr)+5*Ra+0.7*Ra*(1-Sr))*z,0.7*Ra*Sr }
 sphere { -(Ra*(1-Sr)+5*Ra+0.7*Ra*(1-Sr))*z,0.7*Ra*Sr }
 clipped_by { plane { x,0 rotate 180*y } }
 scale < 1,0.1,1 >
 translate Ra*(1-Sr)*z
}
#local Wing_seg =
union {
 object { Wing_Lseg  }
 object { Wing_Rseg  }
 cone { Ra*z,2, -(5*Ra+0.7*Ra-Ra*Sr/4)*z,0.8 }
 rotate -90*x rotate -90*y
 scale 0.1 
}
//----------------------------------------------------------------------------------
#local T_Rseg =
difference {
 torus { 12, 4 }
 box { <0,-(4+0.01),-(12+4+0.01)>, <(12+4+0.01),(4+0.01),(12+4+0.01)> }
 translate < 1,8,-8 >
}
//
#local Vd1=38; #local Vd2=28; #local Vh=0.5;
#local B_Rwing =
difference {
 union {
 #local Obj_seg = object { Wing_seg scale 0.6 }
 union { Normal_rect(pi*<-0.70, 0.0,1/24>,pi*<0.5-1/Vd1,0.5,1/Vd1>,1) }
 #local Obj_seg = object { Wing_seg scale 0.8 }
 union { Normal_rect(pi*<-0.60, 0.0,1/36>,pi*<0.5-2/Vd1,0.5-1/Vd1,1/Vd1>,1) }
 #local Obj_seg = object { Wing_seg }
 union { Normal_rect(pi*<-0.55, 0.0,1/42>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,1) }
 union { Normal_rect(pi*<-0.01,0.08,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,1) translate <-14,Vh,0 > }
 union { Normal_rect(pi*< 0.04,0.10,1/48>,pi*<0.5-5/Vd2,0.5-4/Vd2,1/Vd2>,1) translate <-16,Vh,0 > }
 union { Normal_rect(pi*< 0.10,0.13,1/48>,pi*<0.5-6/Vd2,0.5-5/Vd2,1/Vd2>,1) translate <-16,Vh,0 > }
 }
 object { T_Rseg }
 translate < 4,-10,0 >
}
//
#local T_Lseg =
difference {
 torus { 12, 4 }
 box { <0,-(4+0.01),-(12+4+0.01)>, <-(12+4+0.01),(4+0.01),(12+4+0.01)> }
 translate < -1,8,-8 >
}
#local B_Lwing =
difference {
 union {
 #local Obj_seg = object { Wing_seg scale 0.6 }
 union { Normal_rect(pi*<-0.70, 0.0,1/24>,pi*<0.5-1/Vd1,0.5,1/Vd1>,2) }
 #local Obj_seg = object { Wing_seg scale 0.8 }
 union { Normal_rect(pi*<-0.60, 0.0,1/36>,pi*<0.5-2/Vd1,0.5-1/Vd1,1/Vd1>,2) }
 #local Obj_seg = object { Wing_seg }
 union { Normal_rect(pi*<-0.55, 0.0,1/42>,pi*<0.5-3/Vd1,0.5-2/Vd1,1/Vd1>,2) }
 union { Normal_rect(pi*<-0.01,0.08,1/48>,pi*<0.5-4/Vd2,0.5-3/Vd2,1/Vd2>,2) translate < 14,Vh,0 > }
 union { Normal_rect(pi*< 0.04,0.10,1/48>,pi*<0.5-5/Vd2,0.5-4/Vd2,1/Vd2>,2) translate < 16,Vh,0 > }
 union { Normal_rect(pi*< 0.10,0.13,1/48>,pi*<0.5-6/Vd2,0.5-5/Vd2,1/Vd2>,2) translate < 16,Vh,0 > }
 }
 object { T_Lseg}
 translate <-4,-10,0 >
}
//
#declare L_wing = object { B_Lwing }
#declare R_wing = object { B_Rwing }
//**********************************************************************************