//********************************************************
// Persistence Of Vision raytracer version 3.1g
// Magic square defnition type 0.1a010702a include File
// By S.Nishimura
//********************************************************


//**********************************************************************************
// color square macro (Hue angle) Ha = 70; (square size) Cm = 5; Cz_max (0/10 - 10/10)
#macro Color_square(Ha,Cm,Seg_type)
#switch (Seg_type)
  #case(0) #local Color_seg = plane { y,0.1 clipped_by { box { < -1, -1, -1 >,< 1, 1, 1 > }}} #break
  #case(1) #local Color_seg = plane { y,0.1 clipped_by { superellipsoid { < 0.25, 0.25 > }}}  #break
 #end
#local Cx_up = 0.5;
#local Cz_up = 1;
#local Trans_up = 4/sqrt(2);
//
#local Cz_start = -Cm/2; 
#local Z_start = 0;
#local Hs = Ha + 180;
 #while ( Cz_start <= Cm/2 )
 #local C_work = abs(Cz_start);
 #local Trans_x = Cz_start*Trans_up;
 #local Trans_z = Z_start;
  #while ( C_work <= Cm-abs(Cz_start) )
  coordinate_color( Hs, abs(Cz_start)*2/Cm, C_work/Cm, 1, 1 )
  object { Color_seg pigment { color rgbt < R1, G1, B1, 0.6 > } rotate 45*y translate < Trans_x, 0, Trans_z > } 
  #local C_work = C_work + Cz_up;
  #local Trans_z = Trans_z + Trans_up;
  #end
 #local Cz_start = Cz_start + Cx_up;
 #if ( Cz_start <= 0 )
       #local Z_start = Z_start - Trans_up/2;      
 #else #local Z_start = Z_start + Trans_up/2;
       #local Hs = Ha; #end
 #end
#end // macro end
//----------------------------------------------------------------------------------
#include "J_number.txt.inc"
coordinate_color( 360,0,1,1,2)
#local Unit=4/sqrt(2);
#declare Magic_square03 =
union {
 union { Color_square(70,5,1) }
 object { J_n01 rotate 45*y translate <-1*Unit,-0.5,-1*Unit > }
 object { J_n02 rotate 45*y translate < 0*Unit,-0.5, 2*Unit > }
 object { J_n03 rotate 45*y translate < 1*Unit,-0.5,-1*Unit > }
 object { J_n04 rotate 45*y translate < 2*Unit,-0.5, 0*Unit > }
 object { J_n05 rotate 45*y translate < 0*Unit,-0.5, 0*Unit > }
 object { J_n06 rotate 45*y translate <-2*Unit,-0.5, 0*Unit > }
 object { J_n07 rotate 45*y translate <-1*Unit,-0.5, 1*Unit > }
 object { J_n08 rotate 45*y translate < 0*Unit,-0.5,-2*Unit > }
 object { J_n09 rotate 45*y translate < 1*Unit,-0.5, 1*Unit > }
 pigment { color rgb <R2,G2,B2> }
 rotate -45*y
 scale <16,1,16> 
}
//**********************************************************************************