// POV-Ray ver 3.1g
// Secret method Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { location < 60, 210, -200 >
	 look_at < 0, 0, 0 >
	 angle 52
}

light_source { < 200,340,-200 > color rgb 1 fade_distance 400 fade_power 1 }


//**********************************************************************************
coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
coordinate_color( 360, 0, 0.75, 1, 7 )
coordinate_color( 360, 0, 0.85, 1, 8 )
coordinate_color( 360, 0, 0.90, 1, 9 )
#local P_Cloud_a =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0, 0.1 color rgb <R8,G8,B8> color rgb <R7,G7,B7> ]
                       [0.1, 0.5 color rgb <R7,G7,B7> color rgbf <1,1,1,1> ]
                       [0.5, 1.0 color rgbf <1,1,1,1> color rgbf <1,1,1,1> ] }
 }
#local P_Cloud_b =
 pigment { bozo
           turbulence 0.8
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf <R7,G7,B7,0.0> color rgbf <R9,G9,B9,0.9> ]
                       [0.4, 0.6 color rgbf <R9,G9,B9,0.9> color rgbf <1,1,1,1> ]
                       [0.6, 1.0 color rgbf <1,1,1,1>      color rgbf <1,1,1,1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_c =
 pigment { bozo
           turbulence 0.6
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf <R7,G7,B7,0.0> color rgbf <R9,G9,B9,0.9> ]
                       [0.4, 0.7 color rgbf <R9,G9,B9,0.9> color rgbf <1,1,1,1> ]
                       [0.7, 1.0 color rgbf <1,1,1,1>      color rgbf <1,1,1,1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_d =
 pigment { bozo
           turbulence 1.5
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.5 color rgbf <R7,G7,B7,0.0> color rgbf <R9,G9,B9,0.9> ]
                       [0.5, 0.7 color rgbf <R9,G9,B9,0.9> color rgbf <1,1,1,1> ]
                       [0.7, 1.0 color rgbf <1,1,1,1>      color rgbf <1,1,1,1> ] } scale <1, 0.3, 10>
 }
//
coordinate_color(255,0.90,0.90,1,4)
coordinate_color(255,0.91,0.78,1,5)
coordinate_color(255,0.92,0.56,1,6)
#local P_Lightening =
 pigment { granite 
           turbulence 0.5
           color_map { [0.00 rgbf <1,1,1,0>]
                       [0.10 rgbf <R4, G4, B4, 0.65>]
                       [0.20 rgbf <R4, G4, B4, 0.65>]
                       [0.30 rgbf <R5, G5, B5, 0.85>]
                       [0.45 rgbf <R5, G5, B5, 0.85>]
                       [0.65 rgbf <R6, G6, B6, 0.95>] }
}
//
coordinate_color(120,0.19,0.35,1,1)
sky_sphere {
  pigment { rgb <R1,G1,B1> }
  pigment { P_Lightening scale 0.4 }
  pigment { P_Cloud_d }
  pigment { P_Cloud_c }
  pigment { P_Cloud_b }
  pigment { P_Cloud_a }
  scale 0.9 translate <-28,3,50>
}
//**********************************************************************************
coordinate_color(120,1,0.5,3,2)
#local Fl=0.5;
#local P_smoke =
 pigment { gradient x+z
           turbulence 0.5
           octaves 6
           omega 0.58
           lambda 2
           color_map { [0.00 rgbf < 1,1,1,1 > ]
                       [0.28 rgbf < 1,1,1,1 > ]
                       [0.29 rgbf < R2,G2,B2,Fl > ]
                       [0.30 rgbf < R3,G3,B3,1 > ]
                       [0.32 rgbf < R4,G4,B4,Fl > ]
                       [0.33 rgbf < 1,1,1,1 > ]
                       [1.00 rgbf < 1,1,1,1 > ] } rotate 180*y }
//
sphere { 0,60 pigment { P_smoke scale 120 } scale 1.8 rotate -60*y hollow no_shadow }
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
// space line functions
#macro Line_function(Tp,Vp,Func_type)
 #switch(Func_type)
  #case(1) #local Px=10*Tp; #local Py=0; #local Pz=10*cos(Tp); #break //cos
  #case(2) #local Px=2*Tp; #local Py=0; #local Pz=pow(Tp,2); #break
  #case(3) #local Px=3*Tp; #local Py=0; #local Pz=pow(Tp,3); #break
  #case(4) #local Rr=10; #local Px=Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break     //circle
  #case(5) #local Rr= 5; #local Px=2.9*Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break //ellipse
  #case(6) #local Rr=10*sqrt(Tp); #local Px=Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp); #break
  
  #case(12) #local Px=6*sin(Tp); #local Py=16*Tp; #local Pz=Tp*0; #break
  #case(13) #local Px=6*cos(Tp); #local Py=16*Tp; #local Pz=Tp*0; #break
  #case(17) #local Px=8*Tp; #local Py=3*sin(Tp); #local Pz=Tp*0; #break
  #case(18) #local Px=5*Tp; #local Py=6*cos(Tp); #local Pz=Tp*0; #break
 #end
 #local Vp=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
#local Direc_seg02 = union { Cone_line(2,pi*< -1.5, 1.5, 1/6 >,pi*< 1/3, 1/2.6, 0 >,2) }
#local Direc_seg06 = union { Cone_line(2,pi*< 0, 2, 1/16 >,pi*< 1/4, 1/2.6, 0 >,6) sphere {0,2*cos(pi/4)} }
#local Direc_seg03 = union { Cone_line(2,pi*< 0, 0.9, 1/6 >,pi*< 1/6, 1/2.6, 0 >,3) }
#local Direc_seg04 = union { Cone_line(0.6,pi*< 0, 1, 1/12 >,pi*< 0, 1/2.6, 0 >,4) }
#local Direc_seg01 = union { Cone_line(2,pi*< 0, 1.5, 1/12 >,pi*< 0, 1/2.6, 0 >,1) }
//----------------------------------------------------------------------------------
#local Direc_north =
union {
 cone { 0,1.2, 90*z,0.5 }
 union { Cone_line(2,pi*< 0, 2.5, 1/6 >,pi*< 1/3, 1/2.6, 0 >,2) scale <1,1,1.5> translate -16*x }
 union { Cone_line(3,pi*< 0, 0.9, 1/6 >,pi*< 1/3, 1/2.6, 0 >,5) scale <1,0.8,1> }
 object { Direc_seg02 rotate   0*z rotate (180-22)*y translate <-16.5,0,-0.35 > }
 object { Direc_seg02 rotate 180*z rotate (180+22)*y translate < 16.5,0,-0.35 > }
 object { Direc_seg06 rotate 180*z rotate  60*y translate <-16,0,-19 > }
 object { Direc_seg06 rotate   0*z rotate -60*y translate < 16,0,-19 > }
 object { Direc_seg04 rotate 180*z translate < 19.5,0,-49 > }
 object { Direc_seg04 rotate   0*z translate <-19.5,0,-49 > }
 object { Direc_seg03 rotate 180*z translate < 0,0,-80 > }
 object { Direc_seg03 rotate   0*z translate < 0,0,-80 > }
 cylinder { -80*z,0, 1.2 }
}
//----------------------------------------------------------------------------------
#local Direc_south =
union {
 cone { 5*pi*z,1.2, 80*z,0.5 }
 object { Direc_seg01 rotate < 0,-90,180 > }
 union { Cone_line(2,pi*< 0, 1, 1/12 >,pi*< 0, 1/2.6, 0 >,4) rotate 180*x }
 union { Cone_line(1.5,pi*< 0, 1, 1/12 >,pi*< -1/2, 1/2, 0 >,5) rotate 180*x scale < 1.1,1,1 > translate -7*z }
 union { Cone_line(2,pi*< 0, 2, 1/16 >,pi*< 1/4, 1/2.6, 0 >,6) }
 sphere { 0,1.2 }
 cylinder { -20*z,0, 1.2 }
}
//----------------------------------------------------------------------------------
#local Direc_west =
union {
 cone { 5*pi*z,1.2, 80*z,0.5 }
 object { Direc_seg01 rotate -90*y }
 union { Cone_line(2,pi*< 0, 1, 1/12 >,pi*< 0, 1/2.6, 0 >,4) rotate < 180,0,180 > }
 object { Direc_seg06 rotate 180*z rotate  60*y translate <-16,0,-18 > }
 object { Direc_seg06 rotate   0*z rotate -60*y translate < 16,0,-18 > }
 cylinder { -36*z,-10*z, 1.2 }
}
//----------------------------------------------------------------------------------
#local Direc_seg04e = union { Cone_line(1,pi*< 0, 1.2, 1/12 >,pi*< 0, 1/2.6, 0 >,4) scale 1.5 }
#local Direc_east =
union {
 cone { 5*pi*z,1.2, 80*z,0.5 }
 object { Direc_seg01 rotate -90*y }
 union { Cone_line(2,pi*< 0, 1, 1/12 >,pi*< 0, 1/2.6, 0 >,4) rotate < 180,0,180 > }
 object { Direc_seg04e rotate   0*z rotate 180*x translate <-15,0,-10 > }
 object { Direc_seg04e rotate 180*z rotate 180*x translate < 15,0,-10 > }
 cylinder { -25*z,-10*z, 1.2 }
}
//----------------------------------------------------------------------------------
#local Rr=132; #local Lw=22;
#local Direc_ornament =
union {
 object { Direc_north translate (90-9+Rr)*z }
 object { Direc_south rotate 180*y translate -(80-59+Rr)*z }
 object { Direc_west  rotate -90*y translate -(80-45+Rr)*x }
 object { Direc_east  rotate  90*y translate  (80-56+Rr)*x }
 torus { Lw,1 }
 cylinder { -Lw*x,Lw*x,1 rotate 45*y }
 cylinder { -Lw*x,Lw*x,1 rotate (45+90)*y }
}
//**********************************************************************************
#include "Bird_wing.def.inc"
//----------------------------------------------------------------------------------
coordinate_color(60,0.9,0.6,1,1)
coordinate_color( 0,0.4,0.3,2,2)
#local Tm=0.6;
#local T_beast =
texture {
 pigment { gradient x
           turbulence 0.3  
           color_map { [0.0 rgbt < R1, G1, B1, Tm > ]
                       [0.5 rgbt < R2, G2, B2, Tm > ]
                       [1.0 rgbt < R3, G3, B3, Tm > ] } scale 0.8 }
 normal { bumps 0.4 scale <0.6,1.2,0.6>*0.7 }
}
//----------------------------------------------------------------------------------
coordinate_color( 330,1,0.5,1,9 )
#local Beast_obj =
union {
 sphere { 0,3 pigment { color rgbt <R9,G9,B9,0.5> } scale <1,1,1.2> rotate  60*y translate <26,12+58,-4> } //R_eye
 sphere { 0,3 pigment { color rgbt <R9,G9,B9,0.5> } scale <1,1,1.2> rotate -60*y translate <26,12+58, 4> } //L_eye
 
 difference { union { Cone_line( 4,pi*< 0,0.2,1/8 >,pi*< 0, 1/3, 0 >,13) } sphere { <8,8,0>,4 scale <1,1.2,1> } translate < 12,12+58,-5 > }
 difference { union { Cone_line( 4,pi*< 0,0.2,1/8 >,pi*< 0, 1/3, 0 >,13) } sphere { <8,8,0>,4 scale <1,1.2,1> } translate < 12,12+58, 5 > }
 
 union { Cone_line( 9,pi*< 0,1,1/8 >,pi*< 0, 1/3, 0 >,18) translate < 17,6+58,0 > }
 union { Cone_line( 8,pi*< 0,1/2,1/8 >,pi*< 0, 1/4, 0 >,17) rotate 18*z translate < 2,4+58,0 > }
 union { Cone_line(14,pi*< -1/2,1,1/8 >,pi*< -1/6, 0, 0 >,17) rotate -10*z translate < -30,0+58,0 > }
 union { Cone_line(3.6,pi*< -1.0,1,1/8 >,pi*< -1/6, 0, 0 >,17) rotate 31*z translate < -66,-8+58,0 > }
 
 union { Cone_line(6.0,pi*< 0,0.3,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> translate < -6,-20+58,-10 > }
 union { Cone_line(4.0,pi*< 0,0.5,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> rotate 10*z translate <-8,-46+58,-10 > }
 union { Cone_line(3.4,pi*< 0,0.2,1/8 >,pi*< -1/4, 0, 0 >,13) scale <1,1,0.8> translate <-11.5,-57+58,-10 > }
 cone { 0,5, 4*y,3 translate < -3.2,-58+58,-10 > }
 
 union { Cone_line(6.0,pi*< 0,0.3,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> translate < -6,-20+58, 10 > }
 union { Cone_line(4.0,pi*< 0,0.5,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> rotate 10*z translate <-8,-46+58, 10 > }
 union { Cone_line(3.4,pi*< 0,0.2,1/8 >,pi*< -1/4, 0, 0 >,13) scale <1,1,0.8> translate <-11.5,-57+58, 10 > }
 cone { 0,5, 4*y,3 translate < -3.2,-58+58, 10 > }
 
 union { Cone_line(8.0,pi*< 0,0.3,1/8 >,pi*< -1/3.2, 0, 0 >,12) scale <1,1,0.8> translate < -46,-18+58,-8 > }
 union { Cone_line(4.5,pi*< 0,0.5,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> rotate -15*z translate < -58,-40+58,-8 > }
 union { Cone_line(3.4,pi*< 0,0.3,1/8 >,pi*< -1/4, 0, 0 >,13) scale <1,1,0.8> rotate -20*z translate < -65.8,-55+58,-8 > }
 cone { 0,5, 4*y,3 translate < -56.6,-58+58,-8 > }
 
 union { Cone_line(8.0,pi*< 0,0.3,1/8 >,pi*< -1/3.2, 0, 0 >,12) scale <1,1,0.8> translate < -46,-18+58, 8 > }
 union { Cone_line(4.5,pi*< 0,0.5,1/8 >,pi*< -1/4, 0, 0 >,12) scale <1,1,0.8> rotate -15*z translate < -58,-40+58, 8 > }
 union { Cone_line(3.4,pi*< 0,0.3,1/8 >,pi*< -1/4, 0, 0 >,13) scale <1,1,0.8> rotate -20*z translate < -65.8,-55+58, 8 > }
 cone { 0,5, 4*y,3 translate < -56.6,-58+58, 8 > }
}
//----------------------------------------------------------------------------------
#local Wing_beast =
union { 
 object { Beast_obj rotate -90*y }
 object { L_wing rotate < 5,0, 20 > scale < 3,3,2 > translate <-2,70,-4 > }
 object { R_wing rotate < 5,0,-20 > scale < 3,3,2 > translate < 2,70,-4 > }
}
//**********************************************************************************
#include "Magic_square.def.inc"
//**********************************************************************************
coordinate_color( 30, 0.43, 0.63, 1, 1 )
#local T_gold =
  texture {
   pigment { color < R1, G1, B1 > }
   finish { metallic ambient 0.1 diffuse 0.4 reflection 0.25 specular 1 }
}
//----------------------------------------------------------------------------------
#include "J_clock.def.inc"
//**********************************************************************************
union {
 #local Ei=4; #local Si=0; #while(Si<Ei)
  object { Wing_beast texture { T_beast } scale 0.3 translate < 0,0,122 > rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 object { Direc_ornament texture { T_gold } }
 object { Magic_square03 }
 object { Japanese_clock texture { T_gold } }
 rotate 30*y translate < -8,0,26 >
}
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Ls=< 60, 210, -200 >; #local La=< 0, 0, 0 >; #local Ag=52;
#local Sz=0.3; #local Lz=-vlength(Ls-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+La.x+7; #local Ty=Vx+La.y+8; #local Tz=Sz*Lz+La.z;
#local Rx=degrees(atan2((Ls.y-La.y),sqrt(pow((Ls.x-La.x),2)+pow((Ls.z-La.z),2))));
#local Ry=180+degrees(atan2((Ls.x-La.x),(Ls.z-La.z))); #local Rz=0;
//object { Sealing translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > }