surface redstone(
	float Ks = 0.4,
		Kd = 0.6,
		Ka = 0.1,
		roughness = 0.1,
	txtscale = 1;
	color specularcolor = 1)
{
	point PP;
	float csp;
	point Nf;
	float pixelsize, twice, scale, weight, turbulence ;

	Nf = faceforward(normalize(N), I) ;
	
	PP = transform("shader", P)*txtscale ;
	pixelsize = sqrt(area(PP)) ;
	twice = 2*pixelsize ;
	turbulence = 0 ;
	for (scale = 1; scale > twice; scale /= 2)
		turbulence += scale*noise(PP/scale) ;
	if (scale > pixelsize) {
		weight = (scale / pixelsize) - 1 ;
		weight = clamp(weight, 0,1) ;
		turbulence += weight * scale * noise(PP/scale) ;
	}
	csp = clamp(4*turbulence - 3, 0, 1) ;
	Ci = color spline(csp,
		color(0.70, 0.05, 0),
		color(0.70, 0.05, 0),
		color(0.50, 0, 0),
		color(0.50, 0, 0),
		color(0.50, 0, 0),
		color(0.70, 0.05, 0),
		color(0.70, 0.05, 0),
		color(0.52, 0.05, 0),
		color(0.52, 0.05, 0),
		color(0.40, 0, 0),
		color(0.40, 0, 0),
		color(0.70, 0.05, 0),
		color(0.40, 0, 0)
		) ;

	Ci *= Ka*ambient() + Kd*diffuse(Nf) ;
	Oi = Os ;
	Ci = Ci*Oi ;
	Ci += specularcolor * Ks * specular(Nf, normalize(-I), roughness) ;
}

