// cbfanta.pov
// IRTC 08/2000

#version unofficial megapov 0.7;

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 300;
#declare Rad_error = .05;
#declare Rad_rec = 1;
#declare Rad_bright = 1.0;

// area_light settings
#declare Use_area = on;
#declare Nb_area1 = 6;
#declare Nb_area2 = 6;
#declare Adap_area = 1;


#declare Xmin = -300;
#declare Xmax =  300;


#declare Use_mur_sol = on;

#declare Use_comptoir = on;
#declare Place_crayons = on;
#declare Use_Caisse = on;

#declare Use_WR1 = on;
#declare Use_Chapeaux = on;

#declare Use_pres1 = off;
#declare Use_pres2 = on;
#declare IMPORT_SPATCH = on;
#declare Use_Loin = on;

#declare Use_cabine = on;

#declare Use_GrosBill = on;
#declare Use_Vicky = on;
#declare Use_BusteM = on;

//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 30
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
//	assumed_gamma 1.5
	radiosity{
		count Rad_count
		nearest_count 3
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .005

		low_error_factor .5
		gray_threshold 0.3
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
	//ambient_light 0.0
#end
}

#if (Use_rad)
#default { texture { pigment {rgb <1, 0, 0>} finish { ambient -.05 diffuse 1.05 } } }
#else
#default { texture { pigment {rgb <1, 0, 0>} finish { ambient .2 diffuse .8 } } }
#end

/*
sky_sphere {
	pigment {
		gradient y
		color_map {
			[.2 rgb<126, 160, 197>/255]
			[.6 rgb<45, 75, 148>/255]
		}
	}
}
*/

camera {
	location <0, 120, -290>
	right x*2
	up y
	angle 53
	look_at <0, 120, 400>
}


#if (Use_rad)
#declare Light_Strength = .6;
#else
#declare Light_Strength = .8;
#end


/*
light_source {
	<Xmax-100, 248, 0> rgb <1, .96, .92>*Light_Strength
	spotlight
	radius 80
	falloff 90
	tightness 0
	point_at <Xmax-100, 0, 20>
	fade_distance 350
#if (Use_area)
	area_light z*120, x*30, Nb_area1, Nb_area2
	jitter
	adaptive Adap_area
#end
}
light_source {
	<Xmin+100, 248, 0> rgb <1, .96, .92>*Light_Strength
	spotlight
	radius 80
	falloff 90
	tightness 0
	point_at <Xmin+100, 0, 20>
	fade_distance 350
#if (Use_area)
	area_light z*120, x*30, Nb_area1, Nb_area2
	jitter
	adaptive Adap_area
#end
}
*/

union {
	cone { <Xmin+100, 240, 0>, 10, <Xmin+100, 243, 0>, 3
		open
		texture { pigment { rgb <.1, .2, .6> } finish { specular .5 reflection .2} }
		interior_texture { pigment { rgb 1 } }
		no_shadow
	}
	light_source { <Xmin+100, 240, 0> color rgb 1.3*Light_Strength
		fade_distance 300 fade_power 2
		spotlight radius 85 falloff 90
		tightness 0 point_at <Xmin+100, 0, 20>
	#if (Use_area)
		area_light z*20, x*20, Nb_area1, Nb_area2
		circular
		orient
		jitter
		adaptive Adap_area
	#end
	}
}
union {
	cone { <Xmax-100, 240, 0>, 10, <Xmax-100, 243, 0>, 3
		open
		texture { pigment { rgb <.1, .2, .6> } finish { specular .5 reflection .2} }
		interior_texture { pigment { rgb 1 } }
		no_shadow
	}
	light_source { <Xmax-100, 240, 0> color rgb 1.3*Light_Strength
		fade_distance 300 fade_power 2
		spotlight radius 85 falloff 90
		tightness 0 point_at <Xmax-100, 0, 20>
	#if (Use_area)
		area_light z*20, x*20, Nb_area1, Nb_area2
		circular
		orient
		jitter
		adaptive Adap_area
	#end
	}
}


/*
light_source {
	y*10000 color rgb<1,1,.7>*1.4*Light_Strength
	rotate x*30 rotate y*70
}
*/

// piece
difference {
	box {<Xmin-1, -.5, -410>, <Xmax+1, 251, 400> }
	box {<Xmin, 10,  -405>, <Xmax, 250, 400>}
	box {<Xmin+1, -.5,  -404>, <Xmax-1, 11, 399>}
	pigment { rgb 1 }
}
box {<Xmin, -.5,  -405>, <Xmax, -.1, 400> pigment { rgb .6}}

// tour vitrine
/*
union {
	difference {
		box { <Xmax-2, 0, 397>, <Xmax+2, 250, 401> }
		box { <Xmax-1, -1, 396>, <Xmax+1, 248, 399>}
	}
	difference {
		box { <Xmax-2, 246, 401>, <Xmax+2, 250, -401> }
		box { <Xmax-1, 245, 399>, <Xmax+1, 248, -399>}
	}
	difference {
		box { <Xmax-2, 0, -397>, <Xmax+2, 250, -401> }
		box { <Xmax-1, -1, -396>, <Xmax+1, 248, -399>}
	}
	texture {
		pigment { rgb .8 }
		finish { specular .3 roughness .2 phong .5 phong_size 10 }
	}
}
*/

#if (Use_mur_sol)

#include "mur_sol.inc"

object {
	Tapisse(Xmin, Xmax, 10, 230, .5, 7)
	translate <0, 0, 400>
	texture {
		pigment { color rgb <0.796,0.678,0.490> }
	}
}

object {
	Tapisse(Xmin, Xmax, 10, 230, .5, 7)
	rotate -y*90
	translate <Xmin, 0, 400+Xmin>
	texture {
		pigment { color rgb <0.796,0.678,0.490> }
	}
}

object {
	Tapisse(Xmin, Xmax, 10, 230, .5, 7)
	rotate y*90
	translate <Xmax, 0, 400-Xmax>
	texture {
		pigment { color rgb <0.796,0.678,0.490> }
	}
}

#declare r_dalle = seed(1342);
union {
	Dallage(<Xmin+1, -.5, -404>, <Xmax-1, 0, 399>, .2, .1, 10, 10, .2, r_dalle)
}

#else

box {<Xmin, -.5,  -405>, <Xmax, 0, 400> pigment { rgb 1} }


#end


#declare Affiche1 = box { 0, <1,1,-1>
	texture {
		pigment { image_map {png "NoDragon2"} }
		normal { wrinkles .8 scale .01 }
		finish { specular .5 roughness .05 }
	}
	scale <45, 45*390/290, 1>
	rotate -x*1
	rotate z*1
	translate <Xmax-130, 150, 400-.5>
}

object { Affiche1 }

// comptoir
#include "comptoir.inc"

object { Comptoir
	translate <Xmax-Clg1-70, 0, 400>
}


//===================================
//===================================
//	RANGE-CRAYONS
//===================================
//===================================

#if (Place_crayons)

#include "crayons.inc"

#declare T_Dore = texture {
	pigment { color rgb <1,.9,.6> }
	finish { specular .5 roughness .01 metallic reflection .2 reflect_metallic }
}

#declare TexCenC = texture { pigment { color rgb .1 } }
#declare TexMilC = texture {
	pigment {
		spotted
		warp { turbulence .2 octaves 2 }
		scale <5,1,1>*.1
		color_map {
			[0.55 color rgb <1, .7, .3>]
			[0.75 color rgb <1, .7, .3>*.7]
		}
	}
}

#declare TexExtC = array[4]

#declare TexExtC[0] = texture {
	pigment { color rgb<.3, 1, .5>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[1] = texture {
	pigment { color rgb<1, .5, .3>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[2] = texture {
	pigment { color rgb<.3, .5, 1>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[3] = texture {
	pigment { color rgb<.9, .7, .3>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexBicTr = texture {
	pigment { color rgbf <1,1,1,.97> }
	finish { specular .5 roughness .005 }
}
#declare CoulBic = array[2]
#declare CoulBic[0] = <.05,.05,.05>;
#declare CoulBic[1] = <.1,.2,.7>;


union {
	torus { 4, .1 translate .1*y texture { T_Dore }}
	difference {
		cylinder { .1*y, 10*y, 4 }
		cylinder { .2*y, 10.1*y, 3.9 }
		texture {
			pigment { color rgb <0.000,0.380,0.608> }
			finish { specular .6 roughness .01 metallic }
		}
	}
	torus { 4, .1 translate 10*y texture { T_Dore }}
	
	
	
	#local stc1=seed(3621);
	#local stc2=seed(8412);
	#local stc3=seed(1234);
	#local stc4=seed(4321);
	#local i=0;
	#while (i<360)
		#if (rand(stc1) > .55 )
			// crayon bic
			object {
				Crayon_Bic(CoulBic[mod(floor(rand(stc3)*20),2)], TexBicTr, 1.4, 3211, off)
				#if (rand(stc4) >.5)
					rotate z*180
					translate 14.5*y
				#end
				translate -(.5*sin(radians(30))+.1)*x - 10*y
				rotate -z*(15+10*rand(stc2))
				translate 3.9*x + 10*y
				rotate i*y
			}
		#else
			// crayon de bois
			#if (rand(stc2)>.5)
				#local mal_taille=on;
			#else
				#local mal_taille=off;
			#end
			object {
				Crayon_Bois(11+7*rand(stc1), .4, 10+6*rand(stc1), 7, 60, TexCenC, TexMilC, TexExtC[floor(rand(stc1)*4)], int(9875*rand(stc1)), mal_taille)
				translate -.4*x - 10*y
				rotate -z*(15+10*rand(stc1))
				translate 3.9*x + 10*y
				rotate i*y
			}
		#end
		#local i=i+15+25*rand(stc2);
	#end

	translate <10, 106, -70>
	translate <Xmax-Clg1-70, 0, 400>
}

#end


#if (Use_GrosBill)

#include "GrosBill.inc"

object { GrosBill
	rotate y*35
	translate <Xmax-Clg1-70+70, 0, 400-Cln1+Cln2+20>
}

#end

#if (Use_Caisse)

#include "caisse_enr.inc"

object { Caisse_Enregistreuse
	rotate -y*58
	translate <Xmax-Clg1-70+40, Cht1, 400-60>
}

#end

box {<Xmax, 0, -300>, <50000, -1, 50000>
	pigment { rgb <1,.9,.8> }
	normal { wrinkles }
}





#include "presentoir.inc"

#if (Use_pres1)

object { Presentoir_R1 translate <-100, 0, 100>}

#end


#if (Use_pres2)

object { Presentoir_R2 rotate -y*40 translate <50, 0, 100> }

#if (Use_Loin)

#include "cintreloin.inc"

#declare ln_seed=seed(1342);

#local Col1 = array[4]
#local Col2 = array[4]
#local Col3 = array[4]

#local Col1[0] = <0.855,0.796,0.506>;
#local Col2[0] = <0.99,0.98,0.97>;
#local Col3[0] = <0.494,0.416,0.294>;

#local Col1[1] = <1.000,0.776,0.369>;
#local Col2[1] = <1.000,0.941,0.843>;
#local Col3[1] = <0.373,0.349,0.314>;

#local Col1[2] = <0.663,0.518,0.400>;
#local Col2[2] = <0.729,0.710,0.620>;
#local Col3[2] = <0.482,0.306,0.267>;

#local Col1[3] = <0.855,0.796,0.506>;
#local Col2[3] = <0.99,0.98,0.97>;
#local Col3[3] = <0.494,0.416,0.294>;

union {

#local i = 3;
#while (i<358)
	#local Index = mod(int(1965*rand(ln_seed)), 4);
	object {
		Loin(Col1[Index], Col3[Index], Col3[Index], int(1342*rand(ln_seed)))
//		translate 1.5*x 
//		translate -9.8*y
		rotate (-.5+rand(ln_seed))*15*z
		rotate (-.5+rand(ln_seed))*4*y
		#if (i<180)
			#declare ht = 125 + .25*40*cos(radians(i));
		#else
			#declare ht = 105 - .25*40*cos(radians(i));
		#end
		translate ht*y + 40*x
		rotate -i*y
	}
	#local i = i+5+6*rand(ln_seed);
#end
	rotate -y*40 translate <50, 0, 100>
}


#end

#if (Use_Vicky)
#include "VGladiator.inc"
object { VGladiator
	translate 43*z
	rotate -y*40
	translate <50, 0, 100>
}
#end

#end


#if (Use_BusteM)
#include "BusteM.inc"

object { Buste_ArmorM
	rotate 30*y
	translate <-110, 0, 30>
}

#end


#if (Use_WR1)

#include "wizardrobe1.inc"

union {

#local i = 0;
#while (i<400)
	#local rnd1 = mod(int(rand(wr_seed)*13427), 7);
	object {
		WizardRobe(WRpigcoat[rnd1], WRpigtrim[rnd1], wr_seed)
		translate -12*y
		rotate (-.5+rand(wr_seed))*15*z
		translate (12+.3*rand(wr_seed))*y
		translate (Xmin+40)*x + 150*y + i*z
	}
	#local i = i + 8 + 6*rand(wr_seed);
#end
cylinder { <Xmin+40, 161, 0>, <Xmin+40, 161, 400>, 1 texture{T_Inox} }
}

#include "etagere.inc"

#declare Etagere1 = union {
	object {
		Etagere
		texture { T_Etagere rotate y*89 translate 5*y }
	}
	object {
		Equerre
		scale <1,.70,.9>
		translate <-LargE*.2, -EpE, 0>
		texture { T_Etagere translate -5*x }
	}
	object {
		Equerre
		scale <1,.70,.9>
		translate <-LongE+LargE*.2, -EpE, 0>
		texture { T_Etagere translate -15*x }
	}
}

object {
	Etagere1
	rotate -y*90
	translate <Xmin, 180, 398>
}

object {
	Etagere1
	rotate -y*90
	translate <Xmin, 180, 293>
}

object {
	Etagere1
	rotate -y*90
	translate <Xmin, 180, 190>
}

#if (Use_Chapeaux)

#include "chapeaux.inc"

#local NormChap = normal {
	average
	normal_map {
		[1 granite .6 scale .03 ]
		[1 crackle 2 scale <15, 6, 15>]
	}
}

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[0] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[1] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau3 scale <15, 20, 15> texture { pigment { WRpigtrim[2] } normal {NormChap} finish {specular .1 roughness .1} } }
	translate <Xmin+28, 180, 400-30>
}

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[3] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[0] } normal {NormChap} finish {specular .1 roughness .1} } }
	rotate y*65
	translate <Xmin+30, 180, 400-70>
}

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[5] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[2] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau3 scale <15, 20, 15> texture { pigment { WRpigtrim[6] } normal {NormChap} finish {specular .1 roughness .1} } }
	rotate -y*130
	translate <Xmin+26, 180, 400-130>
}

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[6] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[0] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau3 scale <15, 20, 15> texture { pigment { WRpigtrim[1] } normal {NormChap} finish {specular .1 roughness .1} } }
	rotate y*140
	translate <Xmin+28, 180, 400-190>
}
#end

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[1] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[5] } normal {NormChap} finish {specular .1 roughness .1} } }
	rotate y*230
	translate <Xmin+30, 180, 400-250>
}

union {
	object { Chapeau1 scale <15, 20, 15> texture { pigment { WRpigtrim[0] } normal {NormChap} finish {specular .1 roughness .1} } }
	object { Chapeau2 scale <15, 20, 15> texture { pigment { WRpigtrim[3] } normal {NormChap} finish {specular .1 roughness .1} } }
	rotate -y*60
	translate <Xmin+28, 180, 400-310>
}



#end

#if (Use_cabine)

#include "cabine.inc"

union {
	object { Rideau2 }
	object { Rideau1 scale <-1,1,1> translate (200-1.5)*x }
	object { Cabines }
	translate (400-100)*z
	translate (Xmin+130)*x
}

#end
