// ClothRay example: nappe.pov
// Christophe Bouffartigue (tofbouf@free.fr)

#version unofficial MegaPov 0.7;

#declare test_cabine_inc = off;

#include "reorient.mcr"
#include "roundedbox.mcr"

#declare Cloison = box { <-2.5, 15, -2>, <-0.2, 190, 100> }

#declare Pat_Rideau = pigment {
	object {
		union {
			sphere { <2*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <10*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <18*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <26*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <34*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <42*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <50*160/100, 97*160/100, 0>, .7*160/100 }
			sphere { <58*160/100, 97*160/100, 0>, .7*160/100 }
			scale <1/(59*160/100), 1/(99*160/100), 1>
		} color rgb 0, color rgb 1
	}
}

#declare T_Clear = texture { pigment { rgbt<0,0,0,1> } }
#declare T_Rideau1 = texture {
	pigment { rgb <0.208,0.373,0.627> }
	normal { quilted control0 1 control1 1 scale .002 }
	finish { brilliance .95 }
}

#declare T_Rideau = texture {
	pigment_pattern { Pat_Rideau }
	texture_map {
		[0.1 T_Rideau1 ]
		[0.9 T_Clear ]
	}
}


#macro ReadClothFile(nomfile)

	#debug "Reading cloth file...\n"

	#fopen file nomfile read
	#declare n1=0;
	#declare n2=0;
	#local temp=0;
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#read(file, n1, n2, temp, temp)

	#declare Points = array[n1][n2]

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#read(file, tempx, tempy, tempz, temp, temp, temp)
			#declare Points[i][j] = <tempx, tempy, tempz>;
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


ReadClothFile("ridcab2.cth")

#declare Rideau1 = union {
	mesh {
		#include "ridcab2_s.msh"
		uv_mapping
		texture { T_Rideau }
	}
	#local i=2;
	#while (i<59)
		torus {.7*160/100, .15*160/100
			rotate x*90
			scale <1,1,1.5>
			Reorient(x, (Points[i+1][97]-Points[i-1][97]))
			Reorient(y, (Points[i][98]-Points[i][96]))
			translate Points[i][97]
		}
		#local i=i+8;
	#end
	texture { pigment { rgb 1 } finish { phong .5 phong_size 10 }}
}

#undef Points

ReadClothFile("ridcab3.cth")

#declare Rideau2 = union {
	mesh {
		#include "ridcab3_s.msh"
		uv_mapping
		texture { T_Rideau }
	}
	#local i=2;
	#while (i<59)
		torus {.7*160/100, .15*160/100
			rotate x*90
			scale <1,1,1.5>
			Reorient(x, (Points[i+1][97]-Points[i-1][97]))
			Reorient(y, (Points[i][98]-Points[i][96]))
			translate Points[i][97]
		}
		#local i=i+8;
	#end
	texture { pigment { rgb 1 } finish { phong .5 phong_size 10 }}
}

#undef Points


#declare PanCabine = union {
	union {
		RoundedBox(<-2.5+.01, 15-5, -2-5>, <-0.2-.01, 190+5, 99.99>, .4)
		texture {
			pigment { rgb .2 }
			normal { dents scale 2 }
			finish { phong .6 phong_size 10 specular .6 roughness .02 }
		}
	}
	object { Cloison
		texture {
			pigment { rgb <.97, .96, .9> }
			normal { bumps .1 scale 40 }
			finish { phong .4 phong_size 10 }
		}
	}
	box { <-2.5+.3, 0, 10>, <-.2-.3, 20, 13> }
	box { <-2.5+.3, 0, 60>, <-.2-.3, 20, 63> }
	texture {
		pigment { rgb .1 }
		finish { specular .8 roughness .01 }
	}
}

#declare Cabines = union {
	object {PanCabine}
	object {PanCabine translate 100*x}
	object {PanCabine translate 200*x}
	union {
		box { <-.2, 40, 70>, <-2.5+100, 42, 100>}
		box { <-.2, 40, 70>, <-2.5+100, 42, 100> translate 100*x }
		union {
			cylinder { <-2.5+100, 170, 50>, <-2.5+95, 170, 50>, 3 }
			torus { 4, 2 rotate z*90 translate <-2.5+95, 170, 50> }
		}
		union {
			cylinder { <-2.5+100, 170, 50>, <-2.5+95, 170, 50>, 3 }
			torus { 4, 2 rotate z*90 translate <-2.5+95, 170, 50> }
			translate 100*x
		}
		texture {
			pigment { rgb <.97, .96, .9> }
			normal { bumps .1 scale 40 }
			finish { phong .4 phong_size 10 }
		}
	}
/*	union {
		box { <-.2+.02, 45, 20>, <1, 180, 60>}
		box { <-.2+.02, 45, 20>, <1, 180, 60> translate 100*x }
		texture {
			pigment { rgb 0 }
			normal { bumps .05 scale 30 }
			finish { reflection 1 specular .2 roughness .01 }
		}
	}
*/	cylinder { <-.5,20+(97*160/100), 0>, <200-2.4, 20+(97*160/100), 0>, .55*160/100
		texture {
			pigment { rgb .85 }
			finish {specular .6}
		}
	}
}



#if (test_cabine_inc)

camera {
	location <-20, 150, -100>
	angle 40
	look_at <50, 90, 300>
}

light_source { <-70, 100, -70>*50, color rgb .8 shadowless }

light_source { <50, 150, -100>*30, color rgb 1.2
	spotlight
	radius 50
	falloff 60
	tightness 2
	point_at 30*y+50*x+300*z
}



union {
	object { Rideau1 }
	object { Rideau2 scale <-1,1,1> translate (200-1.5)*x }
	object { Cabines }
	translate (400-100)*z
}
plane { -z, -400 pigment { rgb .85 } }

// floor
plane { y, 0
	pigment { color rgb .8 }
	finish { ambient .3 diffuse .7 }
}


#end

