#version unofficial megapov 0.6;

#declare Rayon11 = .25;
#declare Rayon12 = .27;
#declare Rayon21 = .15;
#declare Rayon22 = .17;

#declare QuartTor11 = intersection {
	torus { 1, Rayon11 }
	box { <-1-Rayon11*1.1, -Rayon11*1.1, 0>, <0, Rayon11*1.1, 1+Rayon11*1.1> }
	translate x
	rotate y*45
}
#declare QuartTor12 = intersection {
	torus { 1, Rayon12 }
	box { <-1-Rayon12*1.1, -Rayon12*1.1, 0>, <0, Rayon12*1.1, 1+Rayon12*1.1> }
	translate x
	rotate y*45
}

#declare QuartTor21 = intersection {
	torus { 1, Rayon21 }
	box { <-1-Rayon21*1.1, -Rayon21*1.1, -1-Rayon21*1.1>, <0, Rayon21*1.1, 0> }
	translate x
	rotate -y*45
}
#declare QuartTor22 = intersection {
	torus { 1, Rayon22 }
	box { <-1-Rayon22*1.1, -Rayon22*1.1, -1-Rayon22*1.1>, <0, Rayon22*1.1, 0> }
	translate x
	rotate -y*45
}

#declare Gros = difference {
	union {
		object {QuartTor11}
		object {QuartTor11 translate -2*sqrt(2)*x}
		object {QuartTor11 scale <-1, 1, -1>}
		object {QuartTor11 scale <-1, 1, -1> translate 2*sqrt(2)*x}
	}
	intersection {
		union {
			object {QuartTor22}
			object {QuartTor22 scale <-1, 1, -1> translate 2*sqrt(2)*x}
		}
		box { <sqrt(2)/2, -.5, -2>, <3, .5, 2> }
	}
	intersection {
		union {
			object {QuartTor22 scale <-1, 1, -1>}
			object {QuartTor22 translate -2*sqrt(2)*x}
		}
		box { <-sqrt(2)/2, -.5, -2>, <-3, .5, 2> }
	}
	rotate -x*90
//	scale <1/sqrt(2), 1, 1>
}

#declare Petit = difference {
	union {
		object {QuartTor21}
		object {QuartTor21 translate -2*sqrt(2)*x}
		object {QuartTor21 scale <-1, 1, -1>}
		object {QuartTor21 scale <-1, 1, -1> translate 2*sqrt(2)*x}
	}
	intersection {
		union {
			object {QuartTor12}
			object {QuartTor12 scale <-1, 1, -1>}
		}
		box { <sqrt(2)/2, -.5, -2>, <-sqrt(2)/2, .5, 2> }
	}
	rotate -x*90
//	scale <1/sqrt(2), 1, 1>
}


#declare F_Pig1 = function {
	pigment {
		object { Gros color rgb<0,0,0> color rgb<1,1,1> }
	}
}
#declare F_Pig2 = function {
	pigment {
		object { Petit color rgb<0,0,0> color rgb<1,1,1> }
	}
}


#declare F2_1 = pigment {
	wrinkles
	poly_wave .75
	scale .01
	color_map { [0 rgb .1] [1 rgb 1]}
}

#declare F2 = function {
	pigment {
		gradient x
		pigment_map {
			[.3 F2_1]
			[.7 F2_1 translate x]
		}
		scale 2*sqrt(2)
	}
}


global_settings { hf_gray_16 }

camera {
	orthographic
	location -5*z
	right x*2*sqrt(2)
	up 2*y*((1-1/sqrt(2))+Rayon11+.05)
	look_at 0
}

plane {
	-z, 0
	texture {
		pigment {
			function { (.2 + .8*F_Pig1 + .4*F_Pig2)* F2 }
			color_map { [0 rgb 0] [1 rgb 1]}
		}
		finish { ambient 1 diffuse 0 }
	}
}


