

global_settings { hf_gray_16 }

camera {
	orthographic
	location -5*z
	up 3*y
	right x
	look_at 0
}

#declare pent = .01;

#declare F1 = function {
	pigment {
		gradient x
		color_map {
			[0.10-pent rgb .3]
			[0.10+pent rgb .6]
			[0.15-pent rgb .6]
			[0.15+pent rgb .3]
			[0.30-pent rgb .3]
			[0.30+pent rgb .6]
			[0.35-pent rgb .6]
			[0.35+pent rgb .3]
			[0.50-pent rgb .3]
			[0.50+pent rgb 1.]
			[0.70-pent rgb 1.]
			[0.70+pent rgb .3]
			[0.75-pent rgb .3]
			[0.75+pent rgb 1.]
			[0.95-pent rgb 1.]
			[0.95+pent rgb .3]
		}
		frequency 3
	}
}

#declare F2_1 = pigment {
	wrinkles
	poly_wave .75
	scale .01
	color_map { [0 rgb .1] [1 rgb 1]}
}

#declare F2 = function {
	pigment {
		gradient x
		pigment_map {
			[.3 F2_1]
			[.7 F2_1 translate x]
		}
	}
}

plane {
	-z, 0
	texture {
		pigment {
			function { F1 * F2 }
			color_map { [0 rgb 0] [1 rgb 1]}
		}
		finish { ambient 1 diffuse 0 }
	}
	translate -.5*x -.5*y
}

