#version unofficial megapov 0.7;

#declare PapierMoquette = height_field {
	png "hfmur"
	matrix <1,0,0,
	        0,0,-1,
			0,3,0,
			0,0,0>
}

#declare LisereMoquette = height_field {
	png "hflisere"
	matrix <1,0,0,
	        0,0,-1,
			0,237/566,0,
			0,0,0>
}

#macro Tapisse(xmin, xmax, ymin, ymax, ep, nbp)

#local i = xmin;
#local scx = (xmax-xmin)/nbp;
#local scy = (ymax-ymin)/3;

union{
	#while (i < xmax*.999)
		object { PapierMoquette scale <scx, scy, ep> translate <i, ymin, 0> }
		object { LisereMoquette scale <scx/3, scx/3, ep> translate <i, ymax, 0> }
		object { LisereMoquette scale <scx/3, scx/3, ep> translate <i+scx/3, ymax, 0> }
		object { LisereMoquette scale <scx/3, scx/3, ep> translate <i+2*scx/3, ymax, 0> }
		#local i = i+scx;
	#end
}

#end

#declare N_Dalle1 = normal {
	bozo
	scale 4
	warp { turbulence .7 lambda 5 }
	scale .1
	warp { turbulence .2 lambda 3 }
	scale .1
	slope_map {
		[.3 <1, 0>]
		[.3 <1, -3>]
		[.35 <0, -3>]
		[.35 <0, 0>]
		[.75 <0, 0>]
		[.75 <0, 3>]
		[.80 <1, 3>]
		[.80 <1, 0>]
	}
}

#declare T_Dalle = texture {
	pigment {
		wrinkles
		scale 2
		warp { turbulence .6 lambda 8 }
		scale .2
		warp { turbulence .2 lambda 3 }
		color_map{ [.2 rgb .95][.4 rgb .75][.6 rgb .90][.8 rgb .93]}
	}
//	normal {
//		average
//		normal_map {
//			[1 N_Dalle1]
			/*[1*/ /*facets .3 coords .02 turbulence .2*/ /*]*/
//		}
//	}
	finish { specular .1 roughness .01
			phong .2 phong_size 5
			reflection_min .1 reflection_max .4
			reflection_blur .1 reflection_samples 10
	}
}


#include "roundedbox.mcr"

#macro Dallage(vmin, vmax, R, ec, nbx, nbz, rot, rnd)

#local largx = (vmax.x-vmin.x)/nbx;
#local largz = (vmax.z-vmin.z)/nbz;
#local ep = (vmax.y-vmin.y);

#local Dalle = union {
	HalfRoundedBox(<ec/2-largx/2, 0, ec/2-largz/2>, <-ec/2+largx/2, ep, -ec/2+largz/2>, R)
}

#local i=vmin.x+largx/2;
#while (i<vmax.x)
	#local j=vmin.z+largz/2;
	#while (j<vmax.z)
		object { Dalle
			rotate (-.5+rand(rnd))*rot.y*y
			rotate (-.5+rand(rnd))*rot.x*x
			rotate (-.5+rand(rnd))*rot.z*z
			translate i*x+j*z + (-.5+rand(rnd))*ep*.05*y
			texture { T_Dalle translate rand(rnd)*<5, 0, 5> scale <largx, 1, largz> }
		}
		#local j=j+largz;
	#end
	#local i=i+largx;
#end

#end

