#version unofficial megapov 0.7;

#declare test_caisse_enr_inc = off;


#if (test_caisse_enr_inc)

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 100;
#declare Rad_error = .1;
#declare Rad_rec = 1;
#declare Rad_bright = 0.8;

// area_light settings
#declare Use_area = on;
#declare Nb_area1 = 6;
#declare Nb_area2 = 6;
#declare Adap_area = 1;


#if (Use_rad)
#default { texture { finish { ambient -.1 diffuse 1.1 } } }
#else
#default { texture { finish { ambient .2 diffuse .8 } } }
#end

#end

#include "roundedbox.mcr"

#declare CE_Caisse = union {
	difference {
		union {
			RoundedBox(0, <43, 10, 40>, .4)
		}
		box { <2, 3, 39.9>, <15, 8, 40.01> }
	}
	box { <1, 1.5, -.5>, <42, 8, -.05>
		texture {
			pigment { rgb <.7, .75, .9>*1.1 }
			normal { bozo .3 poly_wave .4 turbulence 1 octaves 2 scale .3 }
			finish { specular .3 roughness .05 }
		}
	}
	texture {
		pigment { rgb <.7, .75, .9>*.8 }
		normal { bozo poly_wave .4 turbulence 1 octaves 2 scale .3 }
		finish { phong .3 phong_size 30 }
	}
}

#declare CE_Base0 = union {
	difference {
		union {
			RoundedBox(<0, 0, 0>, <41, 10, 39>, .8)
		}
		box { <7, 5, 26>, <13, 10.1, 26.6> }
		box { <5, 5, 24>, <15, 9.5, 27> }
		/* rainures */
		box { <3, 9.8, 28>, <17, 10.01, 28.4> }
		box { <3, 9.8, 29>, <17, 10.01, 29.4> }
		box { <3, 9.8, 30>, <17, 10.01, 30.4> }
		box { <3, 9.8, 31>, <17, 10.01, 31.4> }
		box { <3, 9.8, 32>, <17, 10.01, 32.4> }
		box { <3, 9.8, 33>, <17, 10.01, 33.4> }
		box { <3, 9.8, 34>, <17, 10.01, 34.4> }
		box { <3, 9.8, 35>, <17, 10.01, 35.4> }
		box { <3, 9.8, 36>, <17, 10.01, 36.4> }
		/* rainures */
		box { <3, 9.8, 24>, <37, 10.01, 24.4> }
		box { <3, 9.8, 23>, <37, 10.01, 23.4> }
		box { <3, 9.8, 22>, <37, 10.01, 22.4> }

	}
	box { <0, -.5, 0>, <6, 1.5, .4> rotate x*10 translate <7, 10, 26.6>}
}

#declare CE_Base1 = union {
	intersection {
		object { CE_Base0
			translate -39*z
			matrix <1,   0,0,
			        0,   1,0,
			        0,5/39,1,
			        0,   0,0>
			translate 39*z
		}
		box { <-.01, 4, -.01>, <41.01, 10.01, 39.01> }
	}
	difference {
		intersection {
			object { CE_Base0 }
			box { <-.01, -.01, -.01>, <41.01, 4, 39.01> }
		}
		box { <-.01, 3.3, -.01>, <.2, 3.8, 39.01> }
		box { <41.01, 3.3, -.01>, <40.8, 3.8, 39.01> }
		box { <-.01, 3.3, -.01>, <41.01, 3.8, .2> }
		box { <-.01, 3.3, 39.01>, <41.01, 3.8, 38.8> }
		box { <1, 1, 39.01>, <40, 9, 38.8> }
	}
}

#declare CE_Base2 = difference {
	union {
		intersection {
			object { CE_Base1 }
			box { -.01, <41.01/2, 10.01, 39.01> }
			matrix <     1,0,0,
			        1.5/10,1,0,
			             0,0,1,
			             0,0,0>
		}
		intersection {
			object { CE_Base1 }
			box { <41.01/2,-.01, -.01>, <41.01, 10.01, 39.01> }
			matrix <      1,0,0,
			        -1.5/10,1,0,
			              0,0,1,
			              0,0,0>
		}
	}
	box { 0, 1
		texture {
			pigment { image_map { tga "clavier" once} }
		}
		scale <34, 34*130/450, .2>
		rotate x*90 translate <(41-34)/2, 10.1, 4>
		translate -39*z
		matrix <1,   0,0,
		        0,   1,0,
		        0,5/39,1,
		        0,   0,0>
		translate 39*z
	}
}

#declare CE_Base3 = union {
	intersection {
		object { CE_Base2 }
		box { -.01, <41.01, 10.01, 39.01/2> }
		matrix <1,0,   0,
		        0,1,2/10,
		        0,0,   1,
		        0,0,   0>
	}
	intersection {
		object { CE_Base2 }
		box { <-.01,-.01, 39.01/2>, <41.01, 10.01, 39.01> }
		matrix <1,0,    0,
		        0,1,-1/10,
		        0,0,    1,
		        0,0,    0>
	}
	texture {
		pigment { rgb <.99, .98, .90> } 
		finish { phong .3 phong_size 30 }
	}
}

#undef CE_Base0
#undef CE_Base1
#undef CE_Base2


#declare CE_Ecran0 = union {
	RoundedBox(0, <18, 10, 10>, .5)
	texture {
		pigment { rgb <1, .99, .92> } 
		finish { phong .3 phong_size 30 }
	}
}

#declare CE_LCD0 = union {
	merge {
		RoundedBox(0, <14, 8, 2>, .2)
		hollow
		texture {
			pigment { rgbt <1, 1, 1, .3> }
			finish { diffuse 0 specular .5 roughness .02 reflection_max .4 reflection_min .1 conserve_energy }
		}
	}
	box { <1, 1, .31>, <13, 7, .32>
		texture {
			pigment {
				pigment_pattern { image_map { tga "affecran" once} scale <12, 6, 1> translate x+y }
				color_map { [.1 rgb 0][.3 rgb <.1,.9,.3>] }
			}
			finish { ambient 1/.2 }
		}
	}
	translate <(18-14)/2, (10-8)/2, -.4>
}

#declare CE_Ecran1 = union {
	intersection {
		object { CE_Ecran0 }
		box { -.01, <18.01/2, 10.01, 10.01> }
		matrix <   1,0,0,
		        1/10,1,0,
		           0,0,1,
		           0,0,0>
	}
	intersection {
		object { CE_Ecran0 }
		box { <18.01/2,-.01, -.01>, <18.01, 10.01, 10.01> }
		matrix <    1,0,0,
		        -1/10,1,0,
		            0,0,1,
		            0,0,0>
	}
}

#declare CE_Ecran2 = union {
	intersection {
		union {
			object { CE_Ecran1 }
			object { CE_LCD0 }
		}
		box { <-.01, -.01, -.5>, <18.01, 10.01, 5> }
		matrix <1,0,   0,
		        0,1,3/10,
		        0,0,   1,
		        0,0,   0>
	}
	intersection {
		object { CE_Ecran1 }
		box { <-.01,-.01, 5>, <18.01, 10.01, 10.01> }
	}
	texture {
		pigment { rgb <.99, .98, .90> } 
		finish { phong .3 phong_size 30 }
	}
}

#undef CE_Ecran0
#undef CE_Ecran1
#undef CE_LCD0


#declare CE_Papier = intersection {
	difference {
		cylinder { 0,          5*x, 6.01}
		cylinder { -0.01*x, 5.01*x, 6.00}
	}
	box { <-0.01, -2.5, -6.02>, <5.01, 1.5, -3.5> }
	translate 6*z
	texture {
		pigment { image_map { tga "ticket" once } scale <5, 4, 1> translate <0, -2.5, 0> }
	}
	rotate x*10
	translate 1.5*y
	rotate x*10
}


#declare Caisse_Enregistreuse = union {
	object { CE_Caisse }
	object { CE_Base3 translate 10*y + x + .5*z }
	object { CE_Ecran2 translate <20.5,9.6-5*(39-26)/39,26> translate 10*y + x + .5*z }
	object { CE_Papier translate <7.5+1.5, 10-5*(39-26.6)/39, 26.6-1> translate 10*y + x + .5*z }
}

#undef CE_Caisse
#undef CE_Base3
#undef CE_Ecran2
#undef CE_Papier


#if (test_caisse_enr_inc)

global_settings {
        max_trace_level 10
        adc_bailout 0.1
#if (Use_rad)
        ini_option "+QR"
        radiosity{
                count Rad_count
                nearest_count 3
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_bright

                pretrace_start  .1
                pretrace_end  .01

                low_error_factor .5
                gray_threshold 0.4
                minimum_reuse 0.015
                normal on

                max_sample 1
                adc_bailout 0.1
        }
#end
}


camera {
	location <70, 65, -80>
	angle 30
	look_at <20, 12, 20>
}

#if (Use_rad)
#declare LS = .6;
#else
#declare LS = 1;
#end

light_source { <200, 150, -100>*3 rgb 1.1*LS
#if (Use_area)
	area_light 50*x, 50*z, Nb_area1, Nb_area2
	circular
	orient
	jitter
	adaptive Adap_area
#end
}

#if (Use_rad)
sky_sphere { pigment { gradient y color_map {[0.4 rgb <.6, .7, .95>*.4][0.8 rgb <.6, .7, .95>*.9]} rotate x*20 rotate y*20 } }
#else
sky_sphere { pigment { rgb <.6, .7, .95>} }
#end

plane { y, 0 pigment {rgb 1} }


object { Caisse_Enregistreuse }

#end
