// etagere
#version unofficial megapov 0.6;

#declare test_etagere_inc = off;

#include "colormap.mcr"

#declare LargE = 50;
#declare LongE = 100;
#declare EpE = 2;
#declare R1E = .5;

#declare Etagere = union {
	box { <-LongE+R1E, 0, 0>, <-R1E, -EpE, -LargE+R1E> }
	box { <-LongE, -R1E, 0>, <0, -EpE+R1E, -LargE+R1E> }
	box { <-LongE+R1E, 0-R1E, 0>, <-R1E, -EpE+R1E, -LargE> }
	sphere { <-R1E, -R1E, -LargE+R1E>, R1E }
	sphere { <-R1E, -EpE+R1E, -LargE+R1E>, R1E }
	sphere { <-LongE+R1E, -R1E, -LargE+R1E>, R1E }
	sphere { <-LongE+R1E, -EpE+R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-R1E, -R1E, 0>, R1E }
	cylinder { <-R1E, -EpE+R1E, -LargE+R1E>, <-R1E, -EpE+R1E, 0>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-LongE+R1E, -R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -EpE+R1E, -LargE+R1E>, <-LongE+R1E, -EpE+R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-R1E, -EpE+R1E, -LargE+R1E>, R1E }
	cylinder { <-LongE+R1E, -R1E, -LargE+R1E>, <-LongE+R1E, -R1E, 0>, R1E }
	cylinder { <-LongE+R1E, -EpE+R1E, -LargE+R1E>, <-LongE+R1E, -EpE+R1E, 0>, R1E }
	cylinder { <-LongE+R1E, -R1E, -LargE+R1E>, <-LongE+R1E, -EpE+R1E, -LargE+R1E>, R1E }
}

#declare Equerre = union {
	intersection {
		union {
			torus { .35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .35*LargE, R1E translate -.5*(EpE-R1E)*y }
			cylinder { .5*EpE*y, -.5*EpE*y, .35*LargE }
			cylinder { .5*(EpE-R1E)*y, -.5*(EpE-R1E)*y, .35*LargE+R1E }
		}
		box { <0, EpE*0.51, 0>, <.35*LargE+R1E*1.01, -EpE*0.51, .35*LargE+R1E*1.01> }
		rotate x*90
		rotate y*90
		translate <0, 0, -LargE*.35>
	}
	box { <.5*EpE, 0, 0>, <-.5*EpE, -.35*LargE, -.35*LargE>}
	intersection {
		union {
			torus { .5*.35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .5*.35*LargE, R1E translate -.5*(EpE-R1E)*y }
		}
		box { <0, EpE*0.51, 0>, <-.5*.35*LargE-R1E*1.01, -EpE*0.51, .5*.35*LargE+R1E*1.01> }
		rotate -z*90
		translate <0, -LargE*.35*1.5, -LargE*.35>
	}
	difference {
		box {<.5*EpE, -.35*LargE, 0>, <-.5*EpE, -1.5*.35*LargE, -.35*LargE>}
		cylinder { <-.51*EpE, -LargE*.35*1.5, -LargE*.35>, <.51*EpE, -LargE*.35*1.5, -LargE*.35>, .5*.35*LargE }
	}
	difference {
		box {<.5*(EpE-R1E), -.35*LargE, 0>, <-.5*(EpE-R1E), -1.5*.35*LargE, -.35*LargE>}
		cylinder { <-.51*EpE, -LargE*.35*1.5, -LargE*.35>, <.51*EpE, -LargE*.35*1.5, -LargE*.35>, .5*.35*LargE-R1E }
	}
	intersection {
		union {
			torus { .5*.35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .5*.35*LargE, R1E translate -.5*(EpE-R1E)*y }
			cylinder { .5*EpE*y, -.5*EpE*y, .5*.35*LargE }
			cylinder { .5*(EpE-R1E)*y, -.5*(EpE-R1E)*y, .5*.35*LargE+R1E }
		}
		box { <0, EpE*0.51, 0>, <.5*.35*LargE+R1E*1.01, -EpE*0.51, -.5*.35*LargE-R1E*1.01> }
		rotate -z*90
		translate <0, -LargE*.35*1.5, 0>
	}
}

#declare T_Etagere = texture {
	pigment {
		wood scale 2
		turbulence .05
		color_map { ColorMapScan ("meleze",30) }
	}
	normal {
		wood
		turbulence .05
	}
	finish {
		phong .1 phong_size 20
		specular .2 roughness .01
		brilliance .8
	}	
}

#if (test_etagere_inc)

//========================
// scene
//========================

object {
	Etagere
	texture { T_Etagere rotate y*89 translate 5*y }
}
object {
	Equerre
	scale <1,.75,1>
	translate <-LargE*.2, -EpE, 0>
	texture { T_Etagere translate -5*x }
}
object {
	Equerre
	scale <1,.75,1>
	translate <-LongE+LargE*.2, -EpE, 0>
	texture { T_Etagere translate -15*x }
}


plane { -z, -.02 pigment {rgb .9} }

light_source { <50, 15, -15>*4, rgb <1.2, 1.2, 1>*1.5 }

camera {
	location <1, 1, -25>*5
	right 2*x
	up y*1
	angle 40
	look_at <-40, 0, -5>
}

light_source {-300*z-100*x, color rgb<.6, .6, .7>*.3 shadowless }
background { color rgb <.6, .6, .7> }

#end
