// include pour prsentoir de fringues

#version unofficial megapov 0.7;

#declare test_presentoir_inc = off;

#declare T_Inox = texture {
	pigment { rgb .35 }
	finish {
		brilliance 1.5 diffuse .6
		reflection .6
		specular .4 roughness .01
	}
}
#declare T_Plastic1 = texture {
	pigment { rgb <.95, .92, .90> }
	normal { dents scale .3 }
	finish {
		phong .4 phong_size 20
	}
}

#declare Presentoir_Rond_Pied = union {
	union {
		cylinder { .5*y, 10*y, .7 }
		superellipsoid { <1, .2> rotate x*90 scale <.7, .26, .7> translate .26*y texture { T_Plastic1 } }
		translate 30*x
	}
	union {
		cylinder { .5*y, 10*y, .7 }
		superellipsoid { <1, .2> rotate x*90 scale <.7, .26, .7> translate .26*y texture { T_Plastic1 } }
		translate 30*x
		rotate y*120
	}
	union {
		cylinder { .5*y, 10*y, .7 }
		superellipsoid { <1, .2> rotate x*90 scale <.7, .26, .7> translate .26*y texture { T_Plastic1 } }
		translate 30*x
		rotate -y*120
	}
	torus { 30, .8 translate 10*y }
	cylinder { <30, 10, 0>, <0, 20, 0>, .7 rotate y*60}
	cylinder { <30, 10, 0>, <0, 20, 0>, .7 rotate y*180}
	cylinder { <30, 10, 0>, <0, 20, 0>, .7 rotate -y*60}
	union {
		cylinder { .5*y, 140*y, 1.1 }
		superellipsoid { <1, .2> rotate x*90 scale <1.1, .26, 1.1> translate .26*y texture { T_Plastic1 } }
		superellipsoid { <1, .2> rotate x*90 scale <1.1, .35, 1.1> translate 140.35*y texture { T_Plastic1 } }
	}
	texture {T_Inox}
}


#declare Presentoir_R1 = union {
	object {Presentoir_Rond_Pied}
	torus { 40, .8 translate 130*y }
	cylinder { <40, 130, 0>, <0, 120, 0>, .7 }
	cylinder { <40, 130, 0>, <0, 120, 0>, .7 rotate y*180}
	cylinder { <40, 130, 0>, <0, 120, 0>, .7 rotate -y*90}
	cylinder { <40, 130, 0>, <0, 120, 0>, .7 rotate y*90}
	texture {T_Inox}
}


#declare Presentoir_R2 = union {
	object {Presentoir_Rond_Pied}
	union {
		intersection {
			torus { 40, 1 }
			box { <-41.01, -1.01, 0>, <41.01, 1.01, 41.01> }
		}
		superellipsoid { <1, .2> scale <1, .28, 0.26> translate <40, 0, -.24> texture { T_Plastic1 } }
		matrix < 1, .25, 0,
				 0, 1, 0,
				 0, 0, 1,
				 0, 125, 0>
	}
	union {
		intersection {
			torus { 40, 1 }
			box { <-41.01, -1.01, -41.01>, <41.01, 1.01, 0> }
		}
		superellipsoid { <1, .2> scale <1, .8, 0.26> translate <40, 0, .24> texture { T_Plastic1 } }
		matrix < 1, -.25, 0,
				 0, 1, 0,
				 0, 0, 1,
				 0, 105, 0>
	}
	cylinder { <40, 134.6, 0>, <0, 124.6, 0>, .7 rotate -y*5 }
	cylinder { <40, 95.4, 0>, <0, 85.4, 0>, .7 rotate y*5 }
	cylinder { <0, 125, 40>, <0, 115, 0>, .7 }
	cylinder { <-40, 115, 0>, <0, 105, 0>, .7 }
	cylinder { <0, 105, -40>, <0, 95, 0>, .7 }
	union {
		cylinder { <40, 134.6, 0>, <40, 137.6, 0>, .4 }
		sphere { 0, .4 scale <1, .3, 1> translate <40, 137.6, 0>}
		rotate -y*5
	}
	union {
		cylinder { <40, 95.4, 0>, <40, 98.4, 0>, .4 }
		sphere { 0, .4 scale <1, .3, 1> translate <40, 98.4, 0>}
		rotate y*5
	}
	texture {T_Inox}
}





#if (test_presentoir_inc)

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 100;
#declare Rad_error = .1;
#declare Rad_rec = 1;
#declare Rad_bright = 1.5;

//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 5
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
	assumed_gamma 1.1
	radiosity{
		count Rad_count
		nearest_count 3
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.3
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
	//ambient_light <.3, .5, 1>
#end
}

#if (Use_rad)
#default { texture { finish { ambient -0.10 diffuse 1.10 } } }
#else
#default { texture { finish { ambient .3 diffuse .7 } } }
#end

plane {y, 0 pigment {rgb 1} finish {brilliance .7 }}
//sphere {0, 1000 pigment { rgb .5 } inverse }

object { Presentoir_R2 }
object { Presentoir_R1 translate 60*x+70*z }

#if (Use_rad)
light_source { <300, 200, -300> rgb 1.5 }
#else
light_source { <300, 200, -300> rgb 0.8 }
#end

camera { location -250*z+170*y+30*x angle 40 look_at 80*y }

#end
